import{s as Qa,o as Aa,n as ha}from"../chunks/scheduler.bdbef820.js";import{S as Sa,i as Pa,g as o,s as n,r as j,A as Da,h as m,f as e,c as l,j as Ba,u as f,x as h,k as La,y as Ka,a as t,v as b,d as g,t as y,w as M}from"../chunks/index.c0aea24a.js";import{T as Oa}from"../chunks/Tip.31005f7d.js";import{C as T}from"../chunks/CodeBlock.6ccca92e.js";import{F as se,M as Na}from"../chunks/Markdown.1f17db59.js";import{H as ca}from"../chunks/Heading.2eb892cb.js";function ae($){let p,u='Check out the <a href="https://huggingface.co/course/chapter2/4?fw=pt" rel="nofollow">Tokenizers</a> section in Chapter 2 of the Hugging Face course to learn more about tokenization and different tokenization algorithms.';return{c(){p=o("p"),p.innerHTML=u},l(r){p=m(r,"P",{"data-svelte-h":!0}),h(p)!=="svelte-1ipp5ra"&&(p.innerHTML=u)},m(r,c){t(r,p,c)},p:ha,d(r){r&&e(p)}}}function ee($){let p,u='Use the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.set_format">set_format()</a> function to set the dataset format to be compatible with PyTorch:',r,c,d;return c=new T({props:{code:"ZGF0YXNldC5zZXRfZm9ybWF0KHR5cGUlM0QlMjJ0b3JjaCUyMiUyQyUyMGNvbHVtbnMlM0QlNUIlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiUyQyUyMCUyMmF0dGVudGlvbl9tYXNrJTIyJTJDJTIwJTIybGFiZWwlMjIlNUQpJTBBZGF0YXNldC5mb3JtYXQlNUIndHlwZSclNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_format(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.<span class="hljs-built_in">format</span>[<span class="hljs-string">&#x27;type&#x27;</span>]
<span class="hljs-string">&#x27;torch&#x27;</span>`,wrap:!1}}),{c(){p=o("p"),p.innerHTML=u,r=n(),j(c.$$.fragment)},l(i){p=m(i,"P",{"data-svelte-h":!0}),h(p)!=="svelte-151xcvt"&&(p.innerHTML=u),r=l(i),f(c.$$.fragment,i)},m(i,w){t(i,p,w),t(i,r,w),b(c,i,w),d=!0},p:ha,i(i){d||(g(c.$$.fragment,i),d=!0)},o(i){y(c.$$.fragment,i),d=!1},d(i){i&&(e(p),e(r)),M(c,i)}}}function te($){let p,u;return p=new Na({props:{$$slots:{default:[ee]},$$scope:{ctx:$}}}),{c(){j(p.$$.fragment)},l(r){f(p.$$.fragment,r)},m(r,c){b(p,r,c),u=!0},p(r,c){const d={};c&2&&(d.$$scope={dirty:c,ctx:r}),p.$set(d)},i(r){u||(g(p.$$.fragment,r),u=!0)},o(r){y(p.$$.fragment,r),u=!1},d(r){M(p,r)}}}function ne($){let p,u='Use the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.to_tf_dataset">to_tf_dataset()</a> function to set the dataset format to be compatible with TensorFlow. You’ll also need to import a <a href="https://huggingface.co/docs/transformers/main_classes/data_collator#transformers.DataCollatorWithPadding" rel="nofollow">data collator</a> from 🤗 Transformers to combine the varying sequence lengths into a single batch of equal lengths:',r,c,d;return c=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERhdGFDb2xsYXRvcldpdGhQYWRkaW5nJTBBJTBBZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBdGZfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudG9fdGZfZGF0YXNldCglMEElMjAlMjAlMjAlMjBjb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIydG9rZW5fdHlwZV9pZHMlMjIlMkMlMjAlMjJhdHRlbnRpb25fbWFzayUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX2NvbHMlM0QlNUIlMjJsYWJlbCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QyJTJDJTBBJTIwJTIwJTIwJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DataCollatorWithPadding

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DataCollatorWithPadding(tokenizer=tokenizer, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tf_dataset = dataset.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>],
<span class="hljs-meta">... </span>    label_cols=[<span class="hljs-string">&quot;label&quot;</span>],
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){p=o("p"),p.innerHTML=u,r=n(),j(c.$$.fragment)},l(i){p=m(i,"P",{"data-svelte-h":!0}),h(p)!=="svelte-1seftdi"&&(p.innerHTML=u),r=l(i),f(c.$$.fragment,i)},m(i,w){t(i,p,w),t(i,r,w),b(c,i,w),d=!0},p:ha,i(i){d||(g(c.$$.fragment,i),d=!0)},o(i){y(c.$$.fragment,i),d=!1},d(i){i&&(e(p),e(r)),M(c,i)}}}function le($){let p,u;return p=new Na({props:{$$slots:{default:[ne]},$$scope:{ctx:$}}}),{c(){j(p.$$.fragment)},l(r){f(p.$$.fragment,r)},m(r,c){b(p,r,c),u=!0},p(r,c){const d={};c&2&&(d.$$scope={dirty:c,ctx:r}),p.$set(d)},i(r){u||(g(p.$$.fragment,r),u=!0)},o(r){y(p.$$.fragment,r),u=!1},d(r){M(p,r)}}}function pe($){let p,u,r,c,d,i,w,ua="In addition to loading datasets, 🤗 Datasets other main goal is to offer a diverse set of preprocessing functions to get a dataset into an appropriate format for training with your machine learning framework.",bs,_,da="There are many possible ways to preprocess a dataset, and it all depends on your specific dataset. Sometimes you may need to rename a column, and other times you might need to unflatten nested fields. 🤗 Datasets provides a way to do most of these things. But in nearly all preprocessing cases, depending on your dataset modality, you’ll need to:",gs,U,ja="<li>Tokenize a text dataset.</li> <li>Resample an audio dataset.</li> <li>Apply transforms to an image dataset.</li>",ys,x,fa="The last preprocessing step is usually setting your dataset format to be compatible with your machine learning framework’s expected input format.",Ms,v,ba="In this tutorial, you’ll also need to install the 🤗 Transformers library:",ws,C,Ts,G,ga="Grab a dataset of your choice and follow along!",$s,I,Js,Z,ya="Models cannot process raw text, so you’ll need to convert the text into numbers. Tokenization provides a way to do this by dividing text into individual words called <em>tokens</em>. Tokens are finally converted to numbers.",ks,J,_s,R,Ma='<strong>1</strong>. Start by loading the <a href="https://huggingface.co/datasets/rotten_tomatoes" rel="nofollow">rotten_tomatoes</a> dataset and the tokenizer corresponding to a pretrained <a href="https://huggingface.co/bert-base-uncased" rel="nofollow">BERT</a> model. Using the same tokenizer as the pretrained model is important because you want to make sure the text is split in the same way.',Us,H,xs,X,wa="<strong>2</strong>. Call your tokenizer on the first row of <code>text</code> in the dataset:",vs,F,Cs,W,Ta="The tokenizer returns a dictionary with three items:",Gs,z,$a="<li><code>input_ids</code>: the numbers representing the tokens in the text.</li> <li><code>token_type_ids</code>: indicates which sequence a token belongs to if there is more than one sequence.</li> <li><code>attention_mask</code>: indicates whether a token should be masked or not.</li>",Is,Y,Ja="These values are actually the model inputs.",Zs,V,ka='<strong>3</strong>. The fastest way to tokenize your entire dataset is to use the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function. This function speeds up tokenization by applying the tokenizer to batches of examples instead of individual examples. Set the <code>batched</code> parameter to <code>True</code>:',Rs,q,Hs,E,_a="<strong>4</strong>. Set the format of your dataset to be compatible with your machine learning framework:",Xs,k,Fs,B,Ua="<strong>5</strong>. The dataset is now ready for training with your machine learning framework!",Ws,L,zs,N,xa="Audio inputs like text datasets need to be divided into discrete data points. This is known as <em>sampling</em>; the sampling rate tells you how much of the speech signal is captured per second. It is important to make sure the sampling rate of your dataset matches the sampling rate of the data used to pretrain the model you’re using. If the sampling rates are different, the pretrained model may perform poorly on your dataset because it doesn’t recognize the differences in the sampling rate.",Ys,Q,va='<strong>1</strong>. Start by loading the <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MInDS-14</a> dataset, the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Audio">Audio</a> feature, and the feature extractor corresponding to a pretrained <a href="https://huggingface.co/facebook/wav2vec2-base-960h" rel="nofollow">Wav2Vec2</a> model:',Vs,A,qs,S,Ca="<strong>2</strong>. Index into the first row of the dataset. When you call the <code>audio</code> column of the dataset, it is automatically decoded and resampled:",Es,P,Bs,D,Ga="<strong>3</strong>. Reading a dataset card is incredibly useful and can give you a lot of information about the dataset. A quick look at the MInDS-14 dataset card tells you the sampling rate is 8kHz. Likewise, you can get many details about a model from its model card. The Wav2Vec2 model card says it was sampled on 16kHz speech audio. This means you’ll need to upsample the MInDS-14 dataset to match the sampling rate of the model.",Ls,K,Ia='Use the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.cast_column">cast_column()</a> function and set the <code>sampling_rate</code> parameter in the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Audio">Audio</a> feature to upsample the audio signal. When you call the <code>audio</code> column now, it is decoded and resampled to 16kHz:',Ns,O,Qs,ss,Za='<strong>4</strong>. Use the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function to resample the entire dataset to 16kHz. This function speeds up resampling by applying the feature extractor to batches of examples instead of individual examples. Set the <code>batched</code> parameter to <code>True</code>:',As,as,Ss,es,Ra="<strong>5</strong>. The dataset is now ready for training with your machine learning framework!",Ps,ts,Ds,ns,Ha="The most common preprocessing you’ll do with image datasets is <em>data augmentation</em>, a process that introduces random variations to an image without changing the meaning of the data. This can mean changing the color properties of an image or randomly cropping an image. You are free to use any data augmentation library you like, and 🤗 Datasets will help you apply your data augmentations to your dataset.",Ks,ls,Xa='<strong>1</strong>. Start by loading the <a href="https://huggingface.co/datasets/beans" rel="nofollow">Beans</a> dataset, the <code>Image</code> feature, and the feature extractor corresponding to a pretrained <a href="https://huggingface.co/google/vit-base-patch16-224-in21k" rel="nofollow">ViT</a> model:',Os,ps,sa,rs,Fa="<strong>2</strong>. Index into the first row of the dataset. When you call the <code>image</code> column of the dataset, the underlying PIL object is automatically decoded into an image.",aa,os,ea,ms,Wa='Most image models expect the image to be in the RGB mode. The Beans images are already in the RGB mode, but if your dataset contains images in a different mode, you can use the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.cast_column">cast_column()</a> function to set the mode to RGB:',ta,is,na,cs,za='<strong>3</strong>. Now, you can apply some transforms to the image. Feel free to take a look at the <a href="https://pytorch.org/vision/stable/auto_examples/plot_transforms.html#sphx-glr-auto-examples-plot-transforms-py" rel="nofollow">various transforms available</a> in torchvision and choose one you’d like to experiment with. This example applies a transform that randomly rotates the image:',la,hs,pa,us,Ya='<strong>4</strong>. Use the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function to apply the transform on-the-fly. When you index into the image <code>pixel_values</code>, the transform is applied, and your image gets rotated.',ra,ds,oa,js,Va="<strong>5</strong>. The dataset is now ready for training with your machine learning framework!",ma,fs,ia;return d=new ca({props:{title:"Preprocess",local:"preprocess",headingTag:"h1"}}),C=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install transformers",wrap:!1}}),I=new ca({props:{title:"Tokenize text",local:"tokenize-text",headingTag:"h2"}}),J=new Oa({props:{$$slots:{default:[ae]},$$scope:{ctx:$}}}),H=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnJvdHRlbl90b21hdG9lcyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),F=new T({props:{code:"dG9rZW5pemVyKGRhdGFzZXQlNUIwJTVEJTVCJTIydGV4dCUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>])
{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">1103</span>, <span class="hljs-number">2067</span>, <span class="hljs-number">1110</span>, <span class="hljs-number">17348</span>, <span class="hljs-number">1106</span>, <span class="hljs-number">1129</span>, <span class="hljs-number">1103</span>, <span class="hljs-number">6880</span>, <span class="hljs-number">1432</span>, <span class="hljs-number">112</span>, <span class="hljs-number">188</span>, <span class="hljs-number">1207</span>, <span class="hljs-number">107</span>, <span class="hljs-number">14255</span>, <span class="hljs-number">1389</span>, <span class="hljs-number">107</span>, <span class="hljs-number">1105</span>, <span class="hljs-number">1115</span>, <span class="hljs-number">1119</span>, <span class="hljs-number">112</span>, <span class="hljs-number">188</span>, <span class="hljs-number">1280</span>, <span class="hljs-number">1106</span>, <span class="hljs-number">1294</span>, <span class="hljs-number">170</span>, <span class="hljs-number">24194</span>, <span class="hljs-number">1256</span>, <span class="hljs-number">3407</span>, <span class="hljs-number">1190</span>, <span class="hljs-number">170</span>, <span class="hljs-number">11791</span>, <span class="hljs-number">5253</span>, <span class="hljs-number">188</span>, <span class="hljs-number">1732</span>, <span class="hljs-number">7200</span>, <span class="hljs-number">10947</span>, <span class="hljs-number">12606</span>, <span class="hljs-number">2895</span>, <span class="hljs-number">117</span>, <span class="hljs-number">179</span>, <span class="hljs-number">7766</span>, <span class="hljs-number">118</span>, <span class="hljs-number">172</span>, <span class="hljs-number">15554</span>, <span class="hljs-number">1181</span>, <span class="hljs-number">3498</span>, <span class="hljs-number">6961</span>, <span class="hljs-number">3263</span>, <span class="hljs-number">1137</span>, <span class="hljs-number">188</span>, <span class="hljs-number">1566</span>, <span class="hljs-number">7912</span>, <span class="hljs-number">14516</span>, <span class="hljs-number">6997</span>, <span class="hljs-number">119</span>, <span class="hljs-number">102</span>], 
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], 
 <span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]}`,wrap:!1}}),q=new T({props:{code:"ZGVmJTIwdG9rZW5pemF0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcCh0b2tlbml6YXRpb24lMkMlMjBiYXRjaGVkJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenization</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;text&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(tokenization, batched=<span class="hljs-literal">True</span>)`,wrap:!1}}),k=new se({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[le],pytorch:[te]},$$scope:{ctx:$}}}),L=new ca({props:{title:"Resample audio signals",local:"resample-audio-signals",headingTag:"h2"}}),A=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UtOTYwaCUyMiklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMlBvbHlBSSUyRm1pbmRzMTQlMjIlMkMlMjAlMjJlbi1VUyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, <span class="hljs-string">&quot;en-US&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),P=new T({props:{code:"ZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>]
{<span class="hljs-string">&#x27;array&#x27;</span>: array([ <span class="hljs-number">0.</span>        ,  <span class="hljs-number">0.00024414</span>, -<span class="hljs-number">0.00024414</span>, ..., -<span class="hljs-number">0.00024414</span>,
         <span class="hljs-number">0.</span>        ,  <span class="hljs-number">0.</span>        ], dtype=float32),
 <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~JOINT_ACCOUNT/602ba55abb1e6d0fbce92065.wav&#x27;</span>,
 <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">8000</span>}`,wrap:!1}}),O=new T({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTZfMDAwKSklMEFkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>]
{<span class="hljs-string">&#x27;array&#x27;</span>: array([ <span class="hljs-number">2.3443763e-05</span>,  <span class="hljs-number">2.1729663e-04</span>,  <span class="hljs-number">2.2145823e-04</span>, ...,
         <span class="hljs-number">3.8356509e-05</span>, -<span class="hljs-number">7.3497440e-06</span>, -<span class="hljs-number">2.1754686e-05</span>], dtype=float32),
 <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~JOINT_ACCOUNT/602ba55abb1e6d0fbce92065.wav&#x27;</span>,
 <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">16000</span>}`,wrap:!1}}),as=new T({props:{code:"ZGVmJTIwcHJlcHJvY2Vzc19mdW5jdGlvbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBhdWRpb19hcnJheXMlMjAlM0QlMjAlNUJ4JTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlcyU1QiUyMmF1ZGlvJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fYXJyYXlzJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRGZlYXR1cmVfZXh0cmFjdG9yLnNhbXBsaW5nX3JhdGUlMkMlMjBtYXhfbGVuZ3RoJTNEMTYwMDAlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAocHJlcHJvY2Vzc19mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    audio_arrays = [x[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;audio&quot;</span>]]
<span class="hljs-meta">... </span>    inputs = feature_extractor(
<span class="hljs-meta">... </span>        audio_arrays, sampling_rate=feature_extractor.sampling_rate, max_length=<span class="hljs-number">16000</span>, truncation=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)`,wrap:!1}}),ts=new ca({props:{title:"Apply data augmentations",local:"apply-data-augmentations",headingTag:"h2"}}),ps=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwSW1hZ2UlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1pbjIxayUyMiklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmJlYW5zJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Image

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;beans&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),os=new T({props:{code:"ZGF0YXNldCU1QjAlNUQlNUIlMjJpbWFnZSUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]
&lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=500x500 at <span class="hljs-number">0x7FE5A047CC70</span>&gt;`,wrap:!1}}),is=new T({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyaW1hZ2UlMjIlMkMlMjBJbWFnZShtb2RlJTNEJTIyUkdCJTIyKSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;image&quot;</span>, Image(mode=<span class="hljs-string">&quot;RGB&quot;</span>))',wrap:!1}}),hs=new T({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBSYW5kb21Sb3RhdGlvbiUwQSUwQXJvdGF0ZSUyMCUzRCUyMFJhbmRvbVJvdGF0aW9uKGRlZ3JlZXMlM0QoMCUyQyUyMDkwKSklMEFkZWYlMjB0cmFuc2Zvcm1zKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwJTVCcm90YXRlKGltYWdlKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> RandomRotation

<span class="hljs-meta">&gt;&gt;&gt; </span>rotate = RandomRotation(degrees=(<span class="hljs-number">0</span>, <span class="hljs-number">90</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    examples[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [rotate(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),ds=new T({props:{code:"ZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybXMpJTBBZGF0YXNldCU1QjAlNUQlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(transforms)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;pixel_values&quot;</span>]`,wrap:!1}}),{c(){p=o("meta"),u=n(),r=o("p"),c=n(),j(d.$$.fragment),i=n(),w=o("p"),w.textContent=ua,bs=n(),_=o("p"),_.textContent=da,gs=n(),U=o("ul"),U.innerHTML=ja,ys=n(),x=o("p"),x.textContent=fa,Ms=n(),v=o("p"),v.textContent=ba,ws=n(),j(C.$$.fragment),Ts=n(),G=o("p"),G.textContent=ga,$s=n(),j(I.$$.fragment),Js=n(),Z=o("p"),Z.innerHTML=ya,ks=n(),j(J.$$.fragment),_s=n(),R=o("p"),R.innerHTML=Ma,Us=n(),j(H.$$.fragment),xs=n(),X=o("p"),X.innerHTML=wa,vs=n(),j(F.$$.fragment),Cs=n(),W=o("p"),W.textContent=Ta,Gs=n(),z=o("ul"),z.innerHTML=$a,Is=n(),Y=o("p"),Y.textContent=Ja,Zs=n(),V=o("p"),V.innerHTML=ka,Rs=n(),j(q.$$.fragment),Hs=n(),E=o("p"),E.innerHTML=_a,Xs=n(),j(k.$$.fragment),Fs=n(),B=o("p"),B.innerHTML=Ua,Ws=n(),j(L.$$.fragment),zs=n(),N=o("p"),N.innerHTML=xa,Ys=n(),Q=o("p"),Q.innerHTML=va,Vs=n(),j(A.$$.fragment),qs=n(),S=o("p"),S.innerHTML=Ca,Es=n(),j(P.$$.fragment),Bs=n(),D=o("p"),D.innerHTML=Ga,Ls=n(),K=o("p"),K.innerHTML=Ia,Ns=n(),j(O.$$.fragment),Qs=n(),ss=o("p"),ss.innerHTML=Za,As=n(),j(as.$$.fragment),Ss=n(),es=o("p"),es.innerHTML=Ra,Ps=n(),j(ts.$$.fragment),Ds=n(),ns=o("p"),ns.innerHTML=Ha,Ks=n(),ls=o("p"),ls.innerHTML=Xa,Os=n(),j(ps.$$.fragment),sa=n(),rs=o("p"),rs.innerHTML=Fa,aa=n(),j(os.$$.fragment),ea=n(),ms=o("p"),ms.innerHTML=Wa,ta=n(),j(is.$$.fragment),na=n(),cs=o("p"),cs.innerHTML=za,la=n(),j(hs.$$.fragment),pa=n(),us=o("p"),us.innerHTML=Ya,ra=n(),j(ds.$$.fragment),oa=n(),js=o("p"),js.innerHTML=Va,ma=n(),fs=o("p"),this.h()},l(s){const a=Da("svelte-u9bgzb",document.head);p=m(a,"META",{name:!0,content:!0}),a.forEach(e),u=l(s),r=m(s,"P",{}),Ba(r).forEach(e),c=l(s),f(d.$$.fragment,s),i=l(s),w=m(s,"P",{"data-svelte-h":!0}),h(w)!=="svelte-rumlo3"&&(w.textContent=ua),bs=l(s),_=m(s,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1ricbbc"&&(_.textContent=da),gs=l(s),U=m(s,"UL",{"data-svelte-h":!0}),h(U)!=="svelte-2smfya"&&(U.innerHTML=ja),ys=l(s),x=m(s,"P",{"data-svelte-h":!0}),h(x)!=="svelte-1qhxzm1"&&(x.textContent=fa),Ms=l(s),v=m(s,"P",{"data-svelte-h":!0}),h(v)!=="svelte-5cef87"&&(v.textContent=ba),ws=l(s),f(C.$$.fragment,s),Ts=l(s),G=m(s,"P",{"data-svelte-h":!0}),h(G)!=="svelte-ski2y"&&(G.textContent=ga),$s=l(s),f(I.$$.fragment,s),Js=l(s),Z=m(s,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-xxscky"&&(Z.innerHTML=ya),ks=l(s),f(J.$$.fragment,s),_s=l(s),R=m(s,"P",{"data-svelte-h":!0}),h(R)!=="svelte-1m4yxen"&&(R.innerHTML=Ma),Us=l(s),f(H.$$.fragment,s),xs=l(s),X=m(s,"P",{"data-svelte-h":!0}),h(X)!=="svelte-14yjtb8"&&(X.innerHTML=wa),vs=l(s),f(F.$$.fragment,s),Cs=l(s),W=m(s,"P",{"data-svelte-h":!0}),h(W)!=="svelte-jly7xk"&&(W.textContent=Ta),Gs=l(s),z=m(s,"UL",{"data-svelte-h":!0}),h(z)!=="svelte-1wa1ecr"&&(z.innerHTML=$a),Is=l(s),Y=m(s,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-uk3055"&&(Y.textContent=Ja),Zs=l(s),V=m(s,"P",{"data-svelte-h":!0}),h(V)!=="svelte-mkf1d5"&&(V.innerHTML=ka),Rs=l(s),f(q.$$.fragment,s),Hs=l(s),E=m(s,"P",{"data-svelte-h":!0}),h(E)!=="svelte-bjjamf"&&(E.innerHTML=_a),Xs=l(s),f(k.$$.fragment,s),Fs=l(s),B=m(s,"P",{"data-svelte-h":!0}),h(B)!=="svelte-1i3zt8y"&&(B.innerHTML=Ua),Ws=l(s),f(L.$$.fragment,s),zs=l(s),N=m(s,"P",{"data-svelte-h":!0}),h(N)!=="svelte-58xi8b"&&(N.innerHTML=xa),Ys=l(s),Q=m(s,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-8tezpe"&&(Q.innerHTML=va),Vs=l(s),f(A.$$.fragment,s),qs=l(s),S=m(s,"P",{"data-svelte-h":!0}),h(S)!=="svelte-1qu99mx"&&(S.innerHTML=Ca),Es=l(s),f(P.$$.fragment,s),Bs=l(s),D=m(s,"P",{"data-svelte-h":!0}),h(D)!=="svelte-1035p27"&&(D.innerHTML=Ga),Ls=l(s),K=m(s,"P",{"data-svelte-h":!0}),h(K)!=="svelte-uj4qd5"&&(K.innerHTML=Ia),Ns=l(s),f(O.$$.fragment,s),Qs=l(s),ss=m(s,"P",{"data-svelte-h":!0}),h(ss)!=="svelte-nj83l6"&&(ss.innerHTML=Za),As=l(s),f(as.$$.fragment,s),Ss=l(s),es=m(s,"P",{"data-svelte-h":!0}),h(es)!=="svelte-1i3zt8y"&&(es.innerHTML=Ra),Ps=l(s),f(ts.$$.fragment,s),Ds=l(s),ns=m(s,"P",{"data-svelte-h":!0}),h(ns)!=="svelte-gcgld7"&&(ns.innerHTML=Ha),Ks=l(s),ls=m(s,"P",{"data-svelte-h":!0}),h(ls)!=="svelte-4jwex8"&&(ls.innerHTML=Xa),Os=l(s),f(ps.$$.fragment,s),sa=l(s),rs=m(s,"P",{"data-svelte-h":!0}),h(rs)!=="svelte-50p90x"&&(rs.innerHTML=Fa),aa=l(s),f(os.$$.fragment,s),ea=l(s),ms=m(s,"P",{"data-svelte-h":!0}),h(ms)!=="svelte-1thnzga"&&(ms.innerHTML=Wa),ta=l(s),f(is.$$.fragment,s),na=l(s),cs=m(s,"P",{"data-svelte-h":!0}),h(cs)!=="svelte-18v8dwf"&&(cs.innerHTML=za),la=l(s),f(hs.$$.fragment,s),pa=l(s),us=m(s,"P",{"data-svelte-h":!0}),h(us)!=="svelte-6hjc8f"&&(us.innerHTML=Ya),ra=l(s),f(ds.$$.fragment,s),oa=l(s),js=m(s,"P",{"data-svelte-h":!0}),h(js)!=="svelte-1i3zt8y"&&(js.innerHTML=Va),ma=l(s),fs=m(s,"P",{}),Ba(fs).forEach(e),this.h()},h(){La(p,"name","hf:doc:metadata"),La(p,"content",re)},m(s,a){Ka(document.head,p),t(s,u,a),t(s,r,a),t(s,c,a),b(d,s,a),t(s,i,a),t(s,w,a),t(s,bs,a),t(s,_,a),t(s,gs,a),t(s,U,a),t(s,ys,a),t(s,x,a),t(s,Ms,a),t(s,v,a),t(s,ws,a),b(C,s,a),t(s,Ts,a),t(s,G,a),t(s,$s,a),b(I,s,a),t(s,Js,a),t(s,Z,a),t(s,ks,a),b(J,s,a),t(s,_s,a),t(s,R,a),t(s,Us,a),b(H,s,a),t(s,xs,a),t(s,X,a),t(s,vs,a),b(F,s,a),t(s,Cs,a),t(s,W,a),t(s,Gs,a),t(s,z,a),t(s,Is,a),t(s,Y,a),t(s,Zs,a),t(s,V,a),t(s,Rs,a),b(q,s,a),t(s,Hs,a),t(s,E,a),t(s,Xs,a),b(k,s,a),t(s,Fs,a),t(s,B,a),t(s,Ws,a),b(L,s,a),t(s,zs,a),t(s,N,a),t(s,Ys,a),t(s,Q,a),t(s,Vs,a),b(A,s,a),t(s,qs,a),t(s,S,a),t(s,Es,a),b(P,s,a),t(s,Bs,a),t(s,D,a),t(s,Ls,a),t(s,K,a),t(s,Ns,a),b(O,s,a),t(s,Qs,a),t(s,ss,a),t(s,As,a),b(as,s,a),t(s,Ss,a),t(s,es,a),t(s,Ps,a),b(ts,s,a),t(s,Ds,a),t(s,ns,a),t(s,Ks,a),t(s,ls,a),t(s,Os,a),b(ps,s,a),t(s,sa,a),t(s,rs,a),t(s,aa,a),b(os,s,a),t(s,ea,a),t(s,ms,a),t(s,ta,a),b(is,s,a),t(s,na,a),t(s,cs,a),t(s,la,a),b(hs,s,a),t(s,pa,a),t(s,us,a),t(s,ra,a),b(ds,s,a),t(s,oa,a),t(s,js,a),t(s,ma,a),t(s,fs,a),ia=!0},p(s,[a]){const qa={};a&2&&(qa.$$scope={dirty:a,ctx:s}),J.$set(qa);const Ea={};a&2&&(Ea.$$scope={dirty:a,ctx:s}),k.$set(Ea)},i(s){ia||(g(d.$$.fragment,s),g(C.$$.fragment,s),g(I.$$.fragment,s),g(J.$$.fragment,s),g(H.$$.fragment,s),g(F.$$.fragment,s),g(q.$$.fragment,s),g(k.$$.fragment,s),g(L.$$.fragment,s),g(A.$$.fragment,s),g(P.$$.fragment,s),g(O.$$.fragment,s),g(as.$$.fragment,s),g(ts.$$.fragment,s),g(ps.$$.fragment,s),g(os.$$.fragment,s),g(is.$$.fragment,s),g(hs.$$.fragment,s),g(ds.$$.fragment,s),ia=!0)},o(s){y(d.$$.fragment,s),y(C.$$.fragment,s),y(I.$$.fragment,s),y(J.$$.fragment,s),y(H.$$.fragment,s),y(F.$$.fragment,s),y(q.$$.fragment,s),y(k.$$.fragment,s),y(L.$$.fragment,s),y(A.$$.fragment,s),y(P.$$.fragment,s),y(O.$$.fragment,s),y(as.$$.fragment,s),y(ts.$$.fragment,s),y(ps.$$.fragment,s),y(os.$$.fragment,s),y(is.$$.fragment,s),y(hs.$$.fragment,s),y(ds.$$.fragment,s),ia=!1},d(s){s&&(e(u),e(r),e(c),e(i),e(w),e(bs),e(_),e(gs),e(U),e(ys),e(x),e(Ms),e(v),e(ws),e(Ts),e(G),e($s),e(Js),e(Z),e(ks),e(_s),e(R),e(Us),e(xs),e(X),e(vs),e(Cs),e(W),e(Gs),e(z),e(Is),e(Y),e(Zs),e(V),e(Rs),e(Hs),e(E),e(Xs),e(Fs),e(B),e(Ws),e(zs),e(N),e(Ys),e(Q),e(Vs),e(qs),e(S),e(Es),e(Bs),e(D),e(Ls),e(K),e(Ns),e(Qs),e(ss),e(As),e(Ss),e(es),e(Ps),e(Ds),e(ns),e(Ks),e(ls),e(Os),e(sa),e(rs),e(aa),e(ea),e(ms),e(ta),e(na),e(cs),e(la),e(pa),e(us),e(ra),e(oa),e(js),e(ma),e(fs)),e(p),M(d,s),M(C,s),M(I,s),M(J,s),M(H,s),M(F,s),M(q,s),M(k,s),M(L,s),M(A,s),M(P,s),M(O,s),M(as,s),M(ts,s),M(ps,s),M(os,s),M(is,s),M(hs,s),M(ds,s)}}}const re='{"title":"Preprocess","local":"preprocess","sections":[{"title":"Tokenize text","local":"tokenize-text","sections":[],"depth":2},{"title":"Resample audio signals","local":"resample-audio-signals","sections":[],"depth":2},{"title":"Apply data augmentations","local":"apply-data-augmentations","sections":[],"depth":2}],"depth":1}';function oe($){return Aa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class je extends Sa{constructor(p){super(),Pa(this,p,oe,pe,Qa,{})}}export{je as component};
