import{s as Qa,o as Za,n as la}from"../chunks/scheduler.bdbef820.js";import{S as Fa,i as qa,g as o,s as n,r as m,A as Na,h as r,f as t,c as l,j as ka,u as h,x as i,k as xa,y as za,a as e,v as d,d as u,t as f,w as g}from"../chunks/index.c0aea24a.js";import{T as na}from"../chunks/Tip.31005f7d.js";import{C as y}from"../chunks/CodeBlock.6ccca92e.js";import{H as U}from"../chunks/Heading.2eb892cb.js";function Ga(M){let p,j='A <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object is a wrapper of an Arrow table, which allows fast reads from arrays in the dataset to TensorFlow tensors.';return{c(){p=o("p"),p.innerHTML=j},l(c){p=r(c,"P",{"data-svelte-h":!0}),i(p)!=="svelte-1gs1mkp"&&(p.innerHTML=j)},m(c,b){e(c,p,b)},p:la,d(c){c&&t(p)}}}function Ha(M){let p,j=`To use the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Image">Image</a> feature type, you’ll need to install the <code>vision</code> extra as
<code>pip install datasets[vision]</code>.`;return{c(){p=o("p"),p.innerHTML=j},l(c){p=r(c,"P",{"data-svelte-h":!0}),i(p)!=="svelte-1f8oh0r"&&(p.innerHTML=j)},m(c,b){e(c,p,b)},p:la,d(c){c&&t(p)}}}function Xa(M){let p,j=`To use the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Audio">Audio</a> feature type, you’ll need to install the <code>audio</code> extra as
<code>pip install datasets[audio]</code>.`;return{c(){p=o("p"),p.innerHTML=j},l(c){p=r(c,"P",{"data-svelte-h":!0}),i(p)!=="svelte-1w85nel"&&(p.innerHTML=j)},m(c,b){e(c,p,b)},p:la,d(c){c&&t(p)}}}function Ea(M){let p,j,c,b,$,ds,C,pa=`This document is a quick introduction to using <code>datasets</code> with TensorFlow, with a particular focus on how to get
<code>tf.Tensor</code> objects out of our datasets, and how to stream data from Hugging Face <code>Dataset</code> objects to Keras methods
like <code>model.fit()</code>.`,us,R,fs,_,oa="By default, datasets return regular Python objects: integers, floats, strings, lists, etc.",gs,v,ra="To get TensorFlow tensors instead, you can set the format of the dataset to <code>tf</code>:",js,I,ys,T,bs,k,ia=`This can be useful for converting your dataset to a dict of <code>Tensor</code> objects, or for writing a generator to load TF
samples from it. If you wish to convert the entire dataset to <code>Tensor</code>, simply query the full dataset:`,Ms,x,Ts,Q,ws,Z,ca=`If your dataset consists of N-dimensional arrays, you will see that by default they are considered as nested lists.
In particular, a TensorFlow formatted dataset outputs a <code>RaggedTensor</code> instead of a single tensor:`,Js,F,Us,q,ma="To get a single tensor, you must explicitly use the <code>Array</code> feature type and specify the shape of your tensors:",$s,N,Cs,z,Rs,G,ha='<a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.ClassLabel">ClassLabel</a> data are properly converted to tensors:',_s,H,vs,X,da="Strings and binary objects are also supported:",Is,E,ks,V,ua="You can also explicitly format certain columns and leave the other columns unformatted:",xs,W,Qs,D,fa="String and binary objects are unchanged, since PyTorch only supports numbers.",Zs,Y,ga='The <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Image">Image</a> and <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Audio">Audio</a> feature types are also supported.',Fs,w,qs,L,Ns,J,zs,A,Gs,B,Hs,S,ja=`Although you can load individual samples and batches just by indexing into your dataset, this won’t work if you want
to use Keras methods like <code>fit()</code> and <code>predict()</code>. You could write a generator function that shuffles and loads batches
from your dataset and <code>fit()</code> on that, but that sounds like a lot of unnecessary work. Instead, if you want to stream
data from your dataset on-the-fly, we recommend converting your dataset to a <code>tf.data.Dataset</code> using the
<code>to_tf_dataset()</code> method.`,Xs,P,ya=`The <code>tf.data.Dataset</code> class covers a wide range of use-cases - it is often created from Tensors in memory, or using a load function to read files on disc
or external storage. The dataset can be transformed arbitrarily with the <code>map()</code> method, or methods like <code>batch()</code>
and <code>shuffle()</code> can be used to create a dataset that’s ready for training. These methods do not modify the stored data
in any way - instead, the methods build a data pipeline graph that will be executed when the dataset is iterated over,
usually during model training or inference. This is different from the <code>map()</code> method of Hugging Face <code>Dataset</code> objects,
which runs the map function immediately and saves the new or changed columns.`,Es,K,ba=`Since the entire data preprocessing pipeline can be compiled in a <code>tf.data.Dataset</code>, this approach allows for massively
parallel, asynchronous data loading and training. However, the requirement for graph compilation can be a limitation,
particularly for Hugging Face tokenizers, which are usually not (yet!) compilable as part of a TF graph. As a result,
we usually advise pre-processing the dataset as a Hugging Face dataset, where arbitrary Python functions can be
used, and then converting to <code>tf.data.Dataset</code> afterwards using <code>to_tf_dataset()</code> to get a batched dataset ready for
training. To see examples of this approach, please see the <a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">examples</a> or <a href="https://huggingface.co/docs/transformers/notebooks" rel="nofollow">notebooks</a> for <code>transformers</code>.`,Vs,O,Ws,ss,Ma="Using <code>to_tf_dataset()</code> is straightforward. Once your dataset is preprocessed and ready, simply call it like so:",Ds,as,Ys,ts,Ta=`The returned <code>tf_ds</code> object here is now fully ready to train on, and can be passed directly to <code>model.fit()</code>. Note
that you set the batch size when creating the dataset, and so you don’t need to specify it when calling <code>fit()</code>:`,Ls,es,As,ns,wa=`For a full description of the arguments, please see the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset.to_tf_dataset">to_tf_dataset()</a> documentation. In many cases,
you will also need to add a <code>collate_fn</code> to your call. This is a function that takes multiple elements of the dataset
and combines them into a single batch. When all elements have the same length, the built-in default collator will
suffice, but for more complex tasks a custom collator may be necessary. In particular, many tasks have samples
with varying sequence lengths which will require a <a href="https://huggingface.co/docs/transformers/main/en/main_classes/data_collator" rel="nofollow">data collator</a> that can pad batches correctly. You can see examples
of this in the <code>transformers</code> NLP <a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">examples</a> and
<a href="https://huggingface.co/docs/transformers/notebooks" rel="nofollow">notebooks</a>, where variable sequence lengths are very common.`,Bs,ls,Ja=`If you find that loading with <code>to_tf_dataset</code> is slow, you can also use the <code>num_workers</code> argument. This spins
up multiple subprocesses to load data in parallel. This feature is recent and still somewhat experimental - please file
an issue if you encounter any bugs while using it!`,Ss,ps,Ps,os,Ua=`The astute reader may have noticed at this point that we have offered two approaches to achieve the same goal - if you
want to pass your dataset to a TensorFlow model, you can either convert the dataset to a <code>Tensor</code> or <code>dict</code> of <code>Tensors</code>
using <code>.with_format(&#39;tf&#39;)</code>, or you can convert the dataset to a <code>tf.data.Dataset</code> with <code>to_tf_dataset()</code>. Either of these
can be passed to <code>model.fit()</code>, so which should you choose?`,Ks,rs,$a=`The key thing to recognize is that when you convert the whole dataset to <code>Tensor</code>s, it is static and fully loaded into
RAM. This is simple and convenient, but if any of the following apply, you should probably use <code>to_tf_dataset()</code>
instead:`,Os,is,Ca=`<li>Your dataset is too large to fit in RAM. <code>to_tf_dataset()</code> streams only one batch at a time, so even very large
datasets can be handled with this method.</li> <li>You want to apply random transformations using <code>dataset.with_transform()</code> or the <code>collate_fn</code>. This is
common in several modalities, such as image augmentations when training vision models, or random masking when training
masked language models. Using <code>to_tf_dataset()</code> will apply those transformations
at the moment when a batch is loaded, which means the same samples will get different augmentations each time
they are loaded. This is usually what you want.</li> <li>Your data has a variable dimension, such as input texts in NLP that consist of varying
numbers of tokens. When you create a batch with samples with a variable dimension, the standard solution is to
pad the shorter samples to the length of the longest one. When you stream samples from a dataset with <code>to_tf_dataset</code>,
you can apply this padding to each batch via your <code>collate_fn</code>. However, if you want to convert
such a dataset to dense <code>Tensor</code>s, then you will have to pad samples to the length of the longest sample in <em>the
entire dataset!</em> This can result in huge amounts of padding, which wastes memory and reduces your model’s speed.</li>`,sa,cs,aa,ms,Ra="Right now, <code>to_tf_dataset()</code> always returns a batched dataset - we will add support for unbatched datasets soon!",ta,hs,ea;return $=new U({props:{title:"Using Datasets with TensorFlow",local:"using-datasets-with-tensorflow",headingTag:"h1"}}),R=new U({props:{title:"Dataset format",local:"dataset-format",headingTag:"h2"}}),I=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRmJTIyKSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>,), dtype=int64, numpy=array([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>])&gt;}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=int64, numpy=
array([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
       [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])&gt;}`,wrap:!1}}),T=new na({props:{$$slots:{default:[Ga]},$$scope:{ctx:M}}}),x=new y({props:{code:"ZHMlNUIlM0ElNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=int64, numpy=
array([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
       [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])&gt;}`,wrap:!1}}),Q=new U({props:{title:"N-dimensional arrays",local:"n-dimensional-arrays",headingTag:"h2"}}),F=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElN0QpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0ZiUyMiklMEFkcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],[[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.RaggedTensor [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]&gt;}`,wrap:!1}}),N=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXJyYXkyRCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyZGF0YSUyMiUzQSUyMEFycmF5MkQoc2hhcGUlM0QoMiUyQyUyMDIpJTJDJTIwZHR5cGUlM0QnaW50MzInKSU3RCklMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmRhdGElMjIlM0ElMjBkYXRhJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRmJTIyKSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Array2D
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],[[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;data&quot;</span>: Array2D(shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=<span class="hljs-string">&#x27;int32&#x27;</span>)})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data}, features=features)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=int64, numpy=
 array([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
        [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])&gt;}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=int64, numpy=
 array([[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
         [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],
 
        [[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],
         [<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]])&gt;}`,wrap:!1}}),z=new U({props:{title:"Other feature types",local:"other-feature-types",headingTag:"h2"}}),H=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQ2xhc3NMYWJlbCUwQWxhYmVscyUyMCUzRCUyMCU1QjAlMkMlMjAwJTJDJTIwMSU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIybGFiZWwlMjIlM0ElMjBDbGFzc0xhYmVsKG5hbWVzJTNEJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJsYWJlbCUyMiUzQSUyMGxhYmVscyU3RCUyQyUyMGZlYXR1cmVzJTNEZmVhdHVyZXMpJTIwJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0ZiUyMiklMjAlMjAlMEFkcyU1QiUzQTMlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, ClassLabel
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;label&quot;</span>: ClassLabel(names=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>])})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;label&quot;</span>: labels}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">3</span>,), dtype=int64, numpy=array([<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>])&gt;}`,wrap:!1}}),E=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTIwJTBBdGV4dCUyMCUzRCUyMCU1QiUyMmZvbyUyMiUyQyUyMCUyMmJhciUyMiU1RCUwQWRhdGElMjAlM0QlMjAlNUIwJTJDJTIwMSU1RCUyMCUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIydGV4dCUyMiUzQSUyMHRleHQlMkMlMjAlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCklMjAlMjAlMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRmJTIyKSUyMCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features 
<span class="hljs-meta">&gt;&gt;&gt; </span>text = [<span class="hljs-string">&quot;foo&quot;</span>, <span class="hljs-string">&quot;bar&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>] 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;text&quot;</span>: text, <span class="hljs-string">&quot;data&quot;</span>: data})  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>,), dtype=string, numpy=array([<span class="hljs-string">b&#x27;foo&#x27;</span>, <span class="hljs-string">b&#x27;bar&#x27;</span>], dtype=<span class="hljs-built_in">object</span>)&gt;,
 <span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>,), dtype=int64, numpy=array([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])&gt;}`,wrap:!1}}),W=new y({props:{code:"ZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0ZiUyMiUyQyUyMGNvbHVtbnMlM0QlNUIlMjJkYXRhJTIyJTVEJTJDJTIwb3V0cHV0X2FsbF9jb2x1bW5zJTNEVHJ1ZSklMEFkcyU1QiUzQTIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>, columns=[<span class="hljs-string">&quot;data&quot;</span>], output_all_columns=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>,), dtype=int64, numpy=array([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])&gt;,
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;foo&#x27;</span>, <span class="hljs-string">&#x27;bar&#x27;</span>]}`,wrap:!1}}),w=new na({props:{$$slots:{default:[Ha]},$$scope:{ctx:M}}}),L=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMkMlMjBJbWFnZSUwQWltYWdlcyUyMCUzRCUyMCU1QiUyMnBhdGglMkZ0byUyRmltYWdlLnBuZyUyMiU1RCUyMColMjAxMCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyaW1hZ2UlMjIlM0ElMjBJbWFnZSgpJTdEKSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyaW1hZ2UlMjIlM0ElMjBpbWFnZXMlN0QlMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUyMCUwQWRzJTIwJTNEJTIwZHMud2l0aF9mb3JtYXQoJTIydGYlMjIpJTIwJTIwJTBBZHMlNUIwJTVEJTBBZHMlNUIlM0EyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [<span class="hljs-string">&quot;path/to/image.png&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;image&quot;</span>: Image()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;image&quot;</span>: images}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">4</span>), dtype=uint8, numpy=
 array([[[<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
         [<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
         ...,
         [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
         [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]], dtype=uint8)&gt;}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">4</span>), dtype=uint8, numpy=
 array([[[[<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
          [<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
          ...,
          [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
          [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]]], dtype=uint8)&gt;}`,wrap:!1}}),J=new na({props:{$$slots:{default:[Xa]},$$scope:{ctx:M}}}),A=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMkMlMjBJbWFnZSUwQWF1ZGlvJTIwJTNEJTIwJTVCJTIycGF0aCUyRnRvJTJGYXVkaW8ud2F2JTIyJTVEJTIwKiUyMDEwJTBBZmVhdHVyZXMlMjAlM0QlMjBGZWF0dXJlcyglN0IlMjJhdWRpbyUyMiUzQSUyMEF1ZGlvKCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhdWRpbyUyMiUzQSUyMGF1ZGlvJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMjAlMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRmJTIyKSUyMCUyMCUwQWRzJTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMEFkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = [<span class="hljs-string">&quot;path/to/audio.wav&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;audio&quot;</span>: Audio()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: audio}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
&lt;tf.Tensor: shape=(<span class="hljs-number">202311</span>,), dtype=float32, numpy=
array([ <span class="hljs-number">6.1035156e-05</span>,  <span class="hljs-number">1.5258789e-05</span>,  <span class="hljs-number">1.6784668e-04</span>, ...,
       -<span class="hljs-number">1.5258789e-05</span>, -<span class="hljs-number">1.5258789e-05</span>,  <span class="hljs-number">1.5258789e-05</span>], dtype=float32)&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]
&lt;tf.Tensor: shape=(), dtype=int32, numpy=<span class="hljs-number">44100</span>&gt;`,wrap:!1}}),B=new U({props:{title:"Data loading",local:"data-loading",headingTag:"h2"}}),O=new U({props:{title:"Using to_tf_dataset()",local:"using-totfdataset",headingTag:"h3"}}),as=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlN0IlMjJpbnB1dHMlMjIlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwJTVCMCUyQyUyMDElNUQlN0QlMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KGRhdGEpJTBBdGZfZHMlMjAlM0QlMjBkcy50b190Zl9kYXRhc2V0KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;inputs&quot;</span>: [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]], <span class="hljs-string">&quot;labels&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>tf_ds = ds.to_tf_dataset(
            columns=[<span class="hljs-string">&quot;inputs&quot;</span>],
            label_cols=[<span class="hljs-string">&quot;labels&quot;</span>],
            batch_size=<span class="hljs-number">2</span>,
            shuffle=<span class="hljs-literal">True</span>
            )`,wrap:!1}}),es=new y({props:{code:"bW9kZWwuZml0KHRmX2RzJTJDJTIwZXBvY2hzJTNEMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(tf_ds, epochs=<span class="hljs-number">2</span>)',wrap:!1}}),ps=new U({props:{title:"When to use to_tf_dataset",local:"when-to-use-totfdataset",headingTag:"h3"}}),cs=new U({props:{title:"Caveats and limitations",local:"caveats-and-limitations",headingTag:"h3"}}),{c(){p=o("meta"),j=n(),c=o("p"),b=n(),m($.$$.fragment),ds=n(),C=o("p"),C.innerHTML=pa,us=n(),m(R.$$.fragment),fs=n(),_=o("p"),_.textContent=oa,gs=n(),v=o("p"),v.innerHTML=ra,js=n(),m(I.$$.fragment),ys=n(),m(T.$$.fragment),bs=n(),k=o("p"),k.innerHTML=ia,Ms=n(),m(x.$$.fragment),Ts=n(),m(Q.$$.fragment),ws=n(),Z=o("p"),Z.innerHTML=ca,Js=n(),m(F.$$.fragment),Us=n(),q=o("p"),q.innerHTML=ma,$s=n(),m(N.$$.fragment),Cs=n(),m(z.$$.fragment),Rs=n(),G=o("p"),G.innerHTML=ha,_s=n(),m(H.$$.fragment),vs=n(),X=o("p"),X.textContent=da,Is=n(),m(E.$$.fragment),ks=n(),V=o("p"),V.textContent=ua,xs=n(),m(W.$$.fragment),Qs=n(),D=o("p"),D.textContent=fa,Zs=n(),Y=o("p"),Y.innerHTML=ga,Fs=n(),m(w.$$.fragment),qs=n(),m(L.$$.fragment),Ns=n(),m(J.$$.fragment),zs=n(),m(A.$$.fragment),Gs=n(),m(B.$$.fragment),Hs=n(),S=o("p"),S.innerHTML=ja,Xs=n(),P=o("p"),P.innerHTML=ya,Es=n(),K=o("p"),K.innerHTML=ba,Vs=n(),m(O.$$.fragment),Ws=n(),ss=o("p"),ss.innerHTML=Ma,Ds=n(),m(as.$$.fragment),Ys=n(),ts=o("p"),ts.innerHTML=Ta,Ls=n(),m(es.$$.fragment),As=n(),ns=o("p"),ns.innerHTML=wa,Bs=n(),ls=o("p"),ls.innerHTML=Ja,Ss=n(),m(ps.$$.fragment),Ps=n(),os=o("p"),os.innerHTML=Ua,Ks=n(),rs=o("p"),rs.innerHTML=$a,Os=n(),is=o("ul"),is.innerHTML=Ca,sa=n(),m(cs.$$.fragment),aa=n(),ms=o("p"),ms.innerHTML=Ra,ta=n(),hs=o("p"),this.h()},l(s){const a=Na("svelte-u9bgzb",document.head);p=r(a,"META",{name:!0,content:!0}),a.forEach(t),j=l(s),c=r(s,"P",{}),ka(c).forEach(t),b=l(s),h($.$$.fragment,s),ds=l(s),C=r(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1131e0q"&&(C.innerHTML=pa),us=l(s),h(R.$$.fragment,s),fs=l(s),_=r(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-ej8pz8"&&(_.textContent=oa),gs=l(s),v=r(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1jvz2h"&&(v.innerHTML=ra),js=l(s),h(I.$$.fragment,s),ys=l(s),h(T.$$.fragment,s),bs=l(s),k=r(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1sidsxe"&&(k.innerHTML=ia),Ms=l(s),h(x.$$.fragment,s),Ts=l(s),h(Q.$$.fragment,s),ws=l(s),Z=r(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-zqzaaa"&&(Z.innerHTML=ca),Js=l(s),h(F.$$.fragment,s),Us=l(s),q=r(s,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1nq7c44"&&(q.innerHTML=ma),$s=l(s),h(N.$$.fragment,s),Cs=l(s),h(z.$$.fragment,s),Rs=l(s),G=r(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-mhegnc"&&(G.innerHTML=ha),_s=l(s),h(H.$$.fragment,s),vs=l(s),X=r(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1tbbgzx"&&(X.textContent=da),Is=l(s),h(E.$$.fragment,s),ks=l(s),V=r(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1p3x5ww"&&(V.textContent=ua),xs=l(s),h(W.$$.fragment,s),Qs=l(s),D=r(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1hobffv"&&(D.textContent=fa),Zs=l(s),Y=r(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-6zcles"&&(Y.innerHTML=ga),Fs=l(s),h(w.$$.fragment,s),qs=l(s),h(L.$$.fragment,s),Ns=l(s),h(J.$$.fragment,s),zs=l(s),h(A.$$.fragment,s),Gs=l(s),h(B.$$.fragment,s),Hs=l(s),S=r(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-sac77h"&&(S.innerHTML=ja),Xs=l(s),P=r(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-p0plz9"&&(P.innerHTML=ya),Es=l(s),K=r(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1nyo297"&&(K.innerHTML=ba),Vs=l(s),h(O.$$.fragment,s),Ws=l(s),ss=r(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-lj7mpl"&&(ss.innerHTML=Ma),Ds=l(s),h(as.$$.fragment,s),Ys=l(s),ts=r(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-j57oqq"&&(ts.innerHTML=Ta),Ls=l(s),h(es.$$.fragment,s),As=l(s),ns=r(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-wwjs0r"&&(ns.innerHTML=wa),Bs=l(s),ls=r(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-iqwe7b"&&(ls.innerHTML=Ja),Ss=l(s),h(ps.$$.fragment,s),Ps=l(s),os=r(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-s09fia"&&(os.innerHTML=Ua),Ks=l(s),rs=r(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-1l92k1p"&&(rs.innerHTML=$a),Os=l(s),is=r(s,"UL",{"data-svelte-h":!0}),i(is)!=="svelte-1no32rr"&&(is.innerHTML=Ca),sa=l(s),h(cs.$$.fragment,s),aa=l(s),ms=r(s,"P",{"data-svelte-h":!0}),i(ms)!=="svelte-15wdpsm"&&(ms.innerHTML=Ra),ta=l(s),hs=r(s,"P",{}),ka(hs).forEach(t),this.h()},h(){xa(p,"name","hf:doc:metadata"),xa(p,"content",Va)},m(s,a){za(document.head,p),e(s,j,a),e(s,c,a),e(s,b,a),d($,s,a),e(s,ds,a),e(s,C,a),e(s,us,a),d(R,s,a),e(s,fs,a),e(s,_,a),e(s,gs,a),e(s,v,a),e(s,js,a),d(I,s,a),e(s,ys,a),d(T,s,a),e(s,bs,a),e(s,k,a),e(s,Ms,a),d(x,s,a),e(s,Ts,a),d(Q,s,a),e(s,ws,a),e(s,Z,a),e(s,Js,a),d(F,s,a),e(s,Us,a),e(s,q,a),e(s,$s,a),d(N,s,a),e(s,Cs,a),d(z,s,a),e(s,Rs,a),e(s,G,a),e(s,_s,a),d(H,s,a),e(s,vs,a),e(s,X,a),e(s,Is,a),d(E,s,a),e(s,ks,a),e(s,V,a),e(s,xs,a),d(W,s,a),e(s,Qs,a),e(s,D,a),e(s,Zs,a),e(s,Y,a),e(s,Fs,a),d(w,s,a),e(s,qs,a),d(L,s,a),e(s,Ns,a),d(J,s,a),e(s,zs,a),d(A,s,a),e(s,Gs,a),d(B,s,a),e(s,Hs,a),e(s,S,a),e(s,Xs,a),e(s,P,a),e(s,Es,a),e(s,K,a),e(s,Vs,a),d(O,s,a),e(s,Ws,a),e(s,ss,a),e(s,Ds,a),d(as,s,a),e(s,Ys,a),e(s,ts,a),e(s,Ls,a),d(es,s,a),e(s,As,a),e(s,ns,a),e(s,Bs,a),e(s,ls,a),e(s,Ss,a),d(ps,s,a),e(s,Ps,a),e(s,os,a),e(s,Ks,a),e(s,rs,a),e(s,Os,a),e(s,is,a),e(s,sa,a),d(cs,s,a),e(s,aa,a),e(s,ms,a),e(s,ta,a),e(s,hs,a),ea=!0},p(s,[a]){const _a={};a&2&&(_a.$$scope={dirty:a,ctx:s}),T.$set(_a);const va={};a&2&&(va.$$scope={dirty:a,ctx:s}),w.$set(va);const Ia={};a&2&&(Ia.$$scope={dirty:a,ctx:s}),J.$set(Ia)},i(s){ea||(u($.$$.fragment,s),u(R.$$.fragment,s),u(I.$$.fragment,s),u(T.$$.fragment,s),u(x.$$.fragment,s),u(Q.$$.fragment,s),u(F.$$.fragment,s),u(N.$$.fragment,s),u(z.$$.fragment,s),u(H.$$.fragment,s),u(E.$$.fragment,s),u(W.$$.fragment,s),u(w.$$.fragment,s),u(L.$$.fragment,s),u(J.$$.fragment,s),u(A.$$.fragment,s),u(B.$$.fragment,s),u(O.$$.fragment,s),u(as.$$.fragment,s),u(es.$$.fragment,s),u(ps.$$.fragment,s),u(cs.$$.fragment,s),ea=!0)},o(s){f($.$$.fragment,s),f(R.$$.fragment,s),f(I.$$.fragment,s),f(T.$$.fragment,s),f(x.$$.fragment,s),f(Q.$$.fragment,s),f(F.$$.fragment,s),f(N.$$.fragment,s),f(z.$$.fragment,s),f(H.$$.fragment,s),f(E.$$.fragment,s),f(W.$$.fragment,s),f(w.$$.fragment,s),f(L.$$.fragment,s),f(J.$$.fragment,s),f(A.$$.fragment,s),f(B.$$.fragment,s),f(O.$$.fragment,s),f(as.$$.fragment,s),f(es.$$.fragment,s),f(ps.$$.fragment,s),f(cs.$$.fragment,s),ea=!1},d(s){s&&(t(j),t(c),t(b),t(ds),t(C),t(us),t(fs),t(_),t(gs),t(v),t(js),t(ys),t(bs),t(k),t(Ms),t(Ts),t(ws),t(Z),t(Js),t(Us),t(q),t($s),t(Cs),t(Rs),t(G),t(_s),t(vs),t(X),t(Is),t(ks),t(V),t(xs),t(Qs),t(D),t(Zs),t(Y),t(Fs),t(qs),t(Ns),t(zs),t(Gs),t(Hs),t(S),t(Xs),t(P),t(Es),t(K),t(Vs),t(Ws),t(ss),t(Ds),t(Ys),t(ts),t(Ls),t(As),t(ns),t(Bs),t(ls),t(Ss),t(Ps),t(os),t(Ks),t(rs),t(Os),t(is),t(sa),t(aa),t(ms),t(ta),t(hs)),t(p),g($,s),g(R,s),g(I,s),g(T,s),g(x,s),g(Q,s),g(F,s),g(N,s),g(z,s),g(H,s),g(E,s),g(W,s),g(w,s),g(L,s),g(J,s),g(A,s),g(B,s),g(O,s),g(as,s),g(es,s),g(ps,s),g(cs,s)}}}const Va='{"title":"Using Datasets with TensorFlow","local":"using-datasets-with-tensorflow","sections":[{"title":"Dataset format","local":"dataset-format","sections":[],"depth":2},{"title":"N-dimensional arrays","local":"n-dimensional-arrays","sections":[],"depth":2},{"title":"Other feature types","local":"other-feature-types","sections":[],"depth":2},{"title":"Data loading","local":"data-loading","sections":[{"title":"Using to_tf_dataset()","local":"using-totfdataset","sections":[],"depth":3},{"title":"When to use to_tf_dataset","local":"when-to-use-totfdataset","sections":[],"depth":3},{"title":"Caveats and limitations","local":"caveats-and-limitations","sections":[],"depth":3}],"depth":2}],"depth":1}';function Wa(M){return Za(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sa extends Fa{constructor(p){super(),qa(this,p,Wa,Ea,Qa,{})}}export{Sa as component};
