import{s as ps,n as is,o as rs}from"../chunks/scheduler.bdbef820.js";import{S as os,i as ms,g as p,s as n,r as o,A as cs,h as i,f as t,c as l,j as ns,u as m,x as r,k as ls,y as ds,a,v as c,d,t as h,w as g}from"../chunks/index.c0aea24a.js";import{C as f}from"../chunks/CodeBlock.6ccca92e.js";import{H as K}from"../chunks/Heading.2eb892cb.js";function hs(qe){let u,se,O,te,b,ae,j,He='There are two types of dataset objects, a regular <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and then an ✨ <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> ✨. A <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> provides fast random access to the rows, and memory-mapping so that loading even large datasets only uses a relatively small amount of device memory. But for really, really big datasets that won’t even fit on disk or in memory, an <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> allows you to access and use the dataset without waiting for it to download completely!',ne,x,ze='This tutorial will show you how to load and access a <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and an <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',le,w,pe,y,Ye='When you load a dataset split, you’ll get a <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object. You can do many things with a <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, which is why it’s important to learn how to manipulate and interact with the data stored inside.',ie,$,Qe='This tutorial uses the <a href="https://huggingface.co/datasets/rotten_tomatoes" rel="nofollow">rotten_tomatoes</a> dataset, but feel free to load any dataset you’d like and follow along!',re,M,oe,v,me,_,Le='A <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> contains columns of data, and each column can be a different type of data. The <em>index</em>, or axis label, is used to access examples from the dataset. For example, indexing by the row returns a dictionary of an example from the dataset:',ce,T,de,k,Pe="Use the <code>-</code> operator to start from the end of the dataset:",he,U,ge,I,We="Indexing by the column name returns a list of all the values in the column:",fe,J,ue,C,Ne="You can combine row and column name indexing to return a specific value at a position:",be,G,je,R,Se="But it is important to remember that indexing order matters, especially when working with large audio and image datasets. Indexing by the column name returns all the values in the column first, then loads the value at that position. For large datasets, it may be slower to index by the column name first.",xe,Z,we,D,ye,X,Ee="Slicing returns a slice - or subset - of the dataset, which is useful for viewing several rows at once. To slice a dataset, use the <code>:</code> operator to specify a range of positions.",$e,B,Me,F,ve,q,Ve='An <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is loaded when you set the <code>streaming</code> parameter to <code>True</code> in <a href="/docs/datasets/v2.19.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',_e,H,Te,z,Ae='You can also create an <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> from an <em>existing</em> <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a>, but it is faster than streaming mode because the dataset is streamed from local files:',ke,Y,Ue,Q,Ke='An <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> progressively iterates over a dataset one example at a time, so you don’t have to wait for the whole dataset to download before you can use it. As you can imagine, this is quite useful for large datasets you want to use immediately!',Ie,L,Oe='However, this means an <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>’s behavior is different from a regular <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a>. You don’t get random access to examples in an <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>. Instead, you should iterate over its elements, for example, by calling <code>next(iter())</code> or with a <code>for</code> loop to return the next item from the <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',Je,P,Ce,W,es='You can return a subset of the dataset with a specific number of examples in it with <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a>:',Ge,N,Re,S,ss='But unlike <a href="access/#slicing">slicing</a>, <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a> creates a new <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',Ze,E,De,V,ts='Interested in learning more about the differences between these two types of datasets? Learn more about them in the <a href="about_mapstyle_vs_iterable">Differences between <code>Dataset</code> and <code>IterableDataset</code></a> conceptual guide.',Xe,A,as='To get more hands-on with these datasets types, check out the <a href="process">Process</a> guide to learn how to preprocess a <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> or the <a href="stream">Stream</a> guide to learn how to preprocess an <a href="/docs/datasets/v2.19.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',Be,ee,Fe;return b=new K({props:{title:"Know your dataset",local:"know-your-dataset",headingTag:"h1"}}),w=new K({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),M=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),v=new K({props:{title:"Indexing",local:"indexing",headingTag:"h3"}}),T=new f({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-comment"># Get the first row in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>}`,wrap:!1}}),U=new f({props:{code:"ZGF0YXNldCU1Qi0xJTVE",highlighted:`<span class="hljs-comment"># Get the last row in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[-<span class="hljs-number">1</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;things really get weird , though not particularly scary : the movie is all portent and no content .&#x27;</span>}`,wrap:!1}}),J=new f({props:{code:"ZGF0YXNldCU1QiUyMnRleHQlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;text&quot;</span>]
[<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>,
 <span class="hljs-string">&#x27;the gorgeously elaborate continuation of &quot; the lord of the rings &quot; trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson\\&#x27;s expanded vision of j . r . r . tolkien\\&#x27;s middle-earth .&#x27;</span>,
 <span class="hljs-string">&#x27;effective but too-tepid biopic&#x27;</span>,
 ...,
 <span class="hljs-string">&#x27;things really get weird , though not particularly scary : the movie is all portent and no content .&#x27;</span>]`,wrap:!1}}),G=new f({props:{code:"ZGF0YXNldCU1QjAlNUQlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>]
<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>`,wrap:!1}}),Z=new f({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQXN0YXJ0X3RpbWUlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQXRleHQlMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCU1QiUyMnRleHQlMjIlNUQlMEFlbmRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBcHJpbnQoZiUyMkVsYXBzZWQlMjB0aW1lJTNBJTIwJTdCZW5kX3RpbWUlMjAtJTIwc3RhcnRfdGltZSUzQS40ZiU3RCUyMHNlY29uZHMlMjIpJTBBJTBBc3RhcnRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBdGV4dCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXh0JTIyJTVEJTVCMCU1RCUwQWVuZF90aW1lJTIwJTNEJTIwdGltZS50aW1lKCklMEFwcmludChmJTIyRWxhcHNlZCUyMHRpbWUlM0ElMjAlN0JlbmRfdGltZSUyMC0lMjBzdGFydF90aW1lJTNBLjRmJTdEJTIwc2Vjb25kcyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time

<span class="hljs-meta">&gt;&gt;&gt; </span>start_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>end_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Elapsed time: <span class="hljs-subst">{end_time - start_time:<span class="hljs-number">.4</span>f}</span> seconds&quot;</span>)
Elapsed time: <span class="hljs-number">0.0031</span> seconds

<span class="hljs-meta">&gt;&gt;&gt; </span>start_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = dataset[<span class="hljs-string">&quot;text&quot;</span>][<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>end_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Elapsed time: <span class="hljs-subst">{end_time - start_time:<span class="hljs-number">.4</span>f}</span> seconds&quot;</span>)
Elapsed time: <span class="hljs-number">0.0094</span> seconds`,wrap:!1}}),D=new K({props:{title:"Slicing",local:"slicing",headingTag:"h3"}}),B=new f({props:{code:"ZGF0YXNldCU1QiUzQTMlNUQlMEElMEFkYXRhc2V0JTVCMyUzQTYlNUQ=",highlighted:`<span class="hljs-comment"># Get the first three rows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>,
  <span class="hljs-string">&#x27;the gorgeously elaborate continuation of &quot; the lord of the rings &quot; trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson\\&#x27;s expanded vision of j . r . r . tolkien\\&#x27;s middle-earth .&#x27;</span>,
  <span class="hljs-string">&#x27;effective but too-tepid biopic&#x27;</span>]}

<span class="hljs-comment"># Get rows between three and six</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">3</span>:<span class="hljs-number">6</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;if you sometimes like to go to the movies to have fun , wasabi is a good place to start .&#x27;</span>,
  <span class="hljs-string">&quot;emerges as something rare , an issue movie that&#x27;s so honest and keenly observed that it doesn&#x27;t feel like one .&quot;</span>,
  <span class="hljs-string">&#x27;the film provides some great insight into the neurotic mindset of all comics -- even those who have reached the absolute top of the game .&#x27;</span>]}`,wrap:!1}}),F=new K({props:{title:"IterableDataset",local:"iterabledataset",headingTag:"h2"}}),H=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmb29kMTAxJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwaXRlcmFibGVfZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGV4YW1wbGUpJTBBJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F0681F5C520</span>&gt;, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}`,wrap:!1}}),Y=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnRvX2l0ZXJhYmxlX2RhdGFzZXQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset()`,wrap:!1}}),P=new f({props:{code:"bmV4dChpdGVyKGl0ZXJhYmxlX2RhdGFzZXQpKSUwQSUwQWZvciUyMGV4YW1wbGUlMjBpbiUyMGl0ZXJhYmxlX2RhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChleGFtcGxlKSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(iterable_dataset))
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F0681F59B50</span>&gt;,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F7479DE82B0</span>&gt;, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}`,wrap:!1}}),N=new f({props:{code:"bGlzdChpdGVyYWJsZV9kYXRhc2V0LnRha2UoMykp",highlighted:`<span class="hljs-comment"># Get first three examples</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(iterable_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F7479DEE9D0</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>},
 {<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x512 at <span class="hljs-number">0x7F7479DE8190</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>},
 {<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x383 at <span class="hljs-number">0x7F7479DE8310</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}]`,wrap:!1}}),E=new K({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){u=p("meta"),se=n(),O=p("p"),te=n(),o(b.$$.fragment),ae=n(),j=p("p"),j.innerHTML=He,ne=n(),x=p("p"),x.innerHTML=ze,le=n(),o(w.$$.fragment),pe=n(),y=p("p"),y.innerHTML=Ye,ie=n(),$=p("p"),$.innerHTML=Qe,re=n(),o(M.$$.fragment),oe=n(),o(v.$$.fragment),me=n(),_=p("p"),_.innerHTML=Le,ce=n(),o(T.$$.fragment),de=n(),k=p("p"),k.innerHTML=Pe,he=n(),o(U.$$.fragment),ge=n(),I=p("p"),I.textContent=We,fe=n(),o(J.$$.fragment),ue=n(),C=p("p"),C.textContent=Ne,be=n(),o(G.$$.fragment),je=n(),R=p("p"),R.textContent=Se,xe=n(),o(Z.$$.fragment),we=n(),o(D.$$.fragment),ye=n(),X=p("p"),X.innerHTML=Ee,$e=n(),o(B.$$.fragment),Me=n(),o(F.$$.fragment),ve=n(),q=p("p"),q.innerHTML=Ve,_e=n(),o(H.$$.fragment),Te=n(),z=p("p"),z.innerHTML=Ae,ke=n(),o(Y.$$.fragment),Ue=n(),Q=p("p"),Q.innerHTML=Ke,Ie=n(),L=p("p"),L.innerHTML=Oe,Je=n(),o(P.$$.fragment),Ce=n(),W=p("p"),W.innerHTML=es,Ge=n(),o(N.$$.fragment),Re=n(),S=p("p"),S.innerHTML=ss,Ze=n(),o(E.$$.fragment),De=n(),V=p("p"),V.innerHTML=ts,Xe=n(),A=p("p"),A.innerHTML=as,Be=n(),ee=p("p"),this.h()},l(e){const s=cs("svelte-u9bgzb",document.head);u=i(s,"META",{name:!0,content:!0}),s.forEach(t),se=l(e),O=i(e,"P",{}),ns(O).forEach(t),te=l(e),m(b.$$.fragment,e),ae=l(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-15pa9e6"&&(j.innerHTML=He),ne=l(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-53gd31"&&(x.innerHTML=ze),le=l(e),m(w.$$.fragment,e),pe=l(e),y=i(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1118vdp"&&(y.innerHTML=Ye),ie=l(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-jz751l"&&($.innerHTML=Qe),re=l(e),m(M.$$.fragment,e),oe=l(e),m(v.$$.fragment,e),me=l(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-5kyaaa"&&(_.innerHTML=Le),ce=l(e),m(T.$$.fragment,e),de=l(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-18jqw8v"&&(k.innerHTML=Pe),he=l(e),m(U.$$.fragment,e),ge=l(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-18othzs"&&(I.textContent=We),fe=l(e),m(J.$$.fragment,e),ue=l(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1gzsqvo"&&(C.textContent=Ne),be=l(e),m(G.$$.fragment,e),je=l(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-158alym"&&(R.textContent=Se),xe=l(e),m(Z.$$.fragment,e),we=l(e),m(D.$$.fragment,e),ye=l(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1gt5d64"&&(X.innerHTML=Ee),$e=l(e),m(B.$$.fragment,e),Me=l(e),m(F.$$.fragment,e),ve=l(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-dq94ih"&&(q.innerHTML=Ve),_e=l(e),m(H.$$.fragment,e),Te=l(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-nu0iln"&&(z.innerHTML=Ae),ke=l(e),m(Y.$$.fragment,e),Ue=l(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-15sxdp1"&&(Q.innerHTML=Ke),Ie=l(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1e87ehz"&&(L.innerHTML=Oe),Je=l(e),m(P.$$.fragment,e),Ce=l(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-11c0lm9"&&(W.innerHTML=es),Ge=l(e),m(N.$$.fragment,e),Re=l(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-4bgqrf"&&(S.innerHTML=ss),Ze=l(e),m(E.$$.fragment,e),De=l(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-51y7bk"&&(V.innerHTML=ts),Xe=l(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-j2f3a"&&(A.innerHTML=as),Be=l(e),ee=i(e,"P",{}),ns(ee).forEach(t),this.h()},h(){ls(u,"name","hf:doc:metadata"),ls(u,"content",gs)},m(e,s){ds(document.head,u),a(e,se,s),a(e,O,s),a(e,te,s),c(b,e,s),a(e,ae,s),a(e,j,s),a(e,ne,s),a(e,x,s),a(e,le,s),c(w,e,s),a(e,pe,s),a(e,y,s),a(e,ie,s),a(e,$,s),a(e,re,s),c(M,e,s),a(e,oe,s),c(v,e,s),a(e,me,s),a(e,_,s),a(e,ce,s),c(T,e,s),a(e,de,s),a(e,k,s),a(e,he,s),c(U,e,s),a(e,ge,s),a(e,I,s),a(e,fe,s),c(J,e,s),a(e,ue,s),a(e,C,s),a(e,be,s),c(G,e,s),a(e,je,s),a(e,R,s),a(e,xe,s),c(Z,e,s),a(e,we,s),c(D,e,s),a(e,ye,s),a(e,X,s),a(e,$e,s),c(B,e,s),a(e,Me,s),c(F,e,s),a(e,ve,s),a(e,q,s),a(e,_e,s),c(H,e,s),a(e,Te,s),a(e,z,s),a(e,ke,s),c(Y,e,s),a(e,Ue,s),a(e,Q,s),a(e,Ie,s),a(e,L,s),a(e,Je,s),c(P,e,s),a(e,Ce,s),a(e,W,s),a(e,Ge,s),c(N,e,s),a(e,Re,s),a(e,S,s),a(e,Ze,s),c(E,e,s),a(e,De,s),a(e,V,s),a(e,Xe,s),a(e,A,s),a(e,Be,s),a(e,ee,s),Fe=!0},p:is,i(e){Fe||(d(b.$$.fragment,e),d(w.$$.fragment,e),d(M.$$.fragment,e),d(v.$$.fragment,e),d(T.$$.fragment,e),d(U.$$.fragment,e),d(J.$$.fragment,e),d(G.$$.fragment,e),d(Z.$$.fragment,e),d(D.$$.fragment,e),d(B.$$.fragment,e),d(F.$$.fragment,e),d(H.$$.fragment,e),d(Y.$$.fragment,e),d(P.$$.fragment,e),d(N.$$.fragment,e),d(E.$$.fragment,e),Fe=!0)},o(e){h(b.$$.fragment,e),h(w.$$.fragment,e),h(M.$$.fragment,e),h(v.$$.fragment,e),h(T.$$.fragment,e),h(U.$$.fragment,e),h(J.$$.fragment,e),h(G.$$.fragment,e),h(Z.$$.fragment,e),h(D.$$.fragment,e),h(B.$$.fragment,e),h(F.$$.fragment,e),h(H.$$.fragment,e),h(Y.$$.fragment,e),h(P.$$.fragment,e),h(N.$$.fragment,e),h(E.$$.fragment,e),Fe=!1},d(e){e&&(t(se),t(O),t(te),t(ae),t(j),t(ne),t(x),t(le),t(pe),t(y),t(ie),t($),t(re),t(oe),t(me),t(_),t(ce),t(de),t(k),t(he),t(ge),t(I),t(fe),t(ue),t(C),t(be),t(je),t(R),t(xe),t(we),t(ye),t(X),t($e),t(Me),t(ve),t(q),t(_e),t(Te),t(z),t(ke),t(Ue),t(Q),t(Ie),t(L),t(Je),t(Ce),t(W),t(Ge),t(Re),t(S),t(Ze),t(De),t(V),t(Xe),t(A),t(Be),t(ee)),t(u),g(b,e),g(w,e),g(M,e),g(v,e),g(T,e),g(U,e),g(J,e),g(G,e),g(Z,e),g(D,e),g(B,e),g(F,e),g(H,e),g(Y,e),g(P,e),g(N,e),g(E,e)}}}const gs='{"title":"Know your dataset","local":"know-your-dataset","sections":[{"title":"Dataset","local":"dataset","sections":[{"title":"Indexing","local":"indexing","sections":[],"depth":3},{"title":"Slicing","local":"slicing","sections":[],"depth":3}],"depth":2},{"title":"IterableDataset","local":"iterabledataset","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function fs(qe){return rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ws extends os{constructor(u){super(),ms(this,u,fs,hs,ps,{})}}export{ws as component};
