import{s as fa,o as ba,n as Ia}from"../chunks/scheduler.9bc65507.js";import{S as Ca,i as ga,g as p,s as t,r as M,A as va,h as i,f as e,c as n,j as ua,u as m,x as o,k as ge,y as Za,a,v as c,d as y,t as r,w as h,m as Ga,n as Wa}from"../chunks/index.707bf1b6.js";import{T as Ba}from"../chunks/Tip.c2ecdbf4.js";import{C as d}from"../chunks/CodeBlock.54a9f38d.js";import{D as _a}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as Ls}from"../chunks/Heading.342b1fa6.js";function Aa(Ds){let w,J,U='<a href="../model_doc/timesformer">TimeSformer</a>, <a href="../model_doc/videomae">VideoMAE</a>, <a href="../model_doc/vivit">ViViT</a>';return{c(){w=Ga(`The task illustrated in this tutorial is supported by the following model architectures:

`),J=p("p"),J.innerHTML=U},l(j){w=Wa(j,`The task illustrated in this tutorial is supported by the following model architectures:

`),J=i(j,"P",{"data-svelte-h":!0}),o(J)!=="svelte-jaqk6f"&&(J.innerHTML=U)},m(j,T){a(j,w,T),a(j,J,T)},p:Ia,d(j){j&&(e(w),e(J))}}}function ka(Ds){let w,J,U,j,T,Ks,I,Ps,C,ve="Video classification is the task of assigning a label or class to an entire video. Videos are expected to have only one class for each video. Video classification models take a video as input and return a prediction about which class the video belongs to. These models can be used to categorize what a video is all about. A real-world application of video classification is action / activity recognition, which is useful for fitness applications. It is also helpful for vision-impaired individuals, especially when they are commuting.",Os,g,Ze="This guide will show you how to:",sl,v,Ge='<li>Fine-tune <a href="https://huggingface.co/docs/transformers/main/en/model_doc/videomae" rel="nofollow">VideoMAE</a> on a subset of the <a href="https://www.crcv.ucf.edu/data/UCF101.php" rel="nofollow">UCF101</a> dataset.</li> <li>Use your fine-tuned model for inference.</li>',ll,u,el,Z,We="Before you begin, make sure you have all the necessary libraries installed:",al,G,tl,W,Be='You will use <a href="https://pytorchvideo.org/" rel="nofollow">PyTorchVideo</a> (dubbed <code>pytorchvideo</code>) to process and prepare the videos.',nl,B,_e="We encourage you to log in to your Hugging Face account so you can upload and share your model with the community. When prompted, enter your token to log in:",pl,_,il,A,ol,k,Ae='Start by loading a subset of the <a href="https://www.crcv.ucf.edu/data/UCF101.php" rel="nofollow">UCF-101 dataset</a>. This will give you a chance to experiment and make sure everything works before spending more time training on the full dataset.',Ml,V,ml,R,ke="After the subset has been downloaded, you need to extract the compressed archive:",cl,x,yl,X,Ve="At a high level, the dataset is organized like so:",rl,$,hl,F,Re="The (<code>sorted</code>) video paths appear like so:",dl,z,wl,Y,xe="You will notice that there are video clips belonging to the same group / scene where group is denoted by <code>g</code> in the video file paths. <code>v_ApplyEyeMakeup_g07_c04.avi</code> and <code>v_ApplyEyeMakeup_g07_c06.avi</code>, for example.",Jl,S,Xe='For the validation and evaluation splits, you wouldn’t want to have video clips from the same group / scene to prevent <a href="https://www.kaggle.com/code/alexisbcook/data-leakage" rel="nofollow">data leakage</a>. The subset that you are using in this tutorial takes this information into account.',jl,E,$e="Next up, you will derive the set of labels present in the dataset. Also, create two dictionaries that’ll be helpful when initializing the model:",Tl,Q,Fe="<li><code>label2id</code>: maps the class names to integers.</li> <li><code>id2label</code>: maps the integers to class names.</li>",Ul,N,ul,H,ze="There are 10 unique classes. For each class, there are 30 videos in the training set.",fl,L,bl,q,Ye="Instantiate a video classification model from a pretrained checkpoint and its associated image processor. The model’s encoder comes with pre-trained parameters, and the classification head is randomly initialized. The image processor will come in handy when writing the preprocessing pipeline for our dataset.",Il,D,Cl,K,Se="While the model is loading, you might notice the following warning:",gl,P,vl,O,Ee="The warning is telling us we are throwing away some weights (e.g. the weights and bias of the <code>classifier</code> layer) and randomly initializing some others (the weights and bias of a new <code>classifier</code> layer). This is expected in this case, because we are adding a new head for which we don’t have pretrained weights, so the library warns us we should fine-tune this model before using it for inference, which is exactly what we are going to do.",Zl,ss,Qe='<strong>Note</strong> that <a href="https://huggingface.co/MCG-NJU/videomae-base-finetuned-kinetics" rel="nofollow">this checkpoint</a> leads to better performance on this task as the checkpoint was obtained fine-tuning on a similar downstream task having considerable domain overlap. You can check out <a href="https://huggingface.co/sayakpaul/videomae-base-finetuned-kinetics-finetuned-ucf101-subset" rel="nofollow">this checkpoint</a> which was obtained by fine-tuning <code>MCG-NJU/videomae-base-finetuned-kinetics</code>.',Gl,ls,Wl,es,Ne='For preprocessing the videos, you will leverage the <a href="https://pytorchvideo.org/" rel="nofollow">PyTorchVideo library</a>. Start by importing the dependencies we need.',Bl,as,_l,ts,He='For the training dataset transformations, use a combination of uniform temporal subsampling, pixel normalization, random cropping, and random horizontal flipping. For the validation and evaluation dataset transformations, keep the same transformation chain except for random cropping and horizontal flipping. To learn more about the details of these transformations check out the <a href="https://pytorchvideo.org" rel="nofollow">official documentation of PyTorchVideo</a>.',Al,ns,Le="Use the <code>image_processor</code> associated with the pre-trained model to obtain the following information:",kl,ps,qe="<li>Image mean and standard deviation with which the video frame pixels will be normalized.</li> <li>Spatial resolution to which the video frames will be resized.</li>",Vl,is,De="Start by defining some constants.",Rl,os,xl,Ms,Ke="Now, define the dataset-specific transformations and the datasets respectively. Starting with the training set:",Xl,ms,$l,cs,Pe="The same sequence of workflow can be applied to the validation and evaluation sets:",Fl,ys,zl,rs,Oe='<strong>Note</strong>: The above dataset pipelines are taken from the <a href="https://pytorchvideo.org/docs/tutorial_classification#dataset" rel="nofollow">official PyTorchVideo example</a>. We’re using the <a href="https://pytorchvideo.readthedocs.io/en/latest/api/data/data.html#pytorchvideo.data.Ucf101" rel="nofollow"><code>pytorchvideo.data.Ucf101()</code></a> function because it’s tailored for the UCF-101 dataset. Under the hood, it returns a <a href="https://pytorchvideo.readthedocs.io/en/latest/api/data/data.html#pytorchvideo.data.LabeledVideoDataset" rel="nofollow"><code>pytorchvideo.data.labeled_video_dataset.LabeledVideoDataset</code></a> object. <code>LabeledVideoDataset</code> class is the base class for all things video in the PyTorchVideo dataset. So, if you want to use a custom dataset not supported off-the-shelf by PyTorchVideo, you can extend the <code>LabeledVideoDataset</code> class accordingly. Refer to the <code>data</code> API <a href="https://pytorchvideo.readthedocs.io/en/latest/api/data/data.html" rel="nofollow">documentation to</a> learn more. Also, if your dataset follows a similar structure (as shown above), then using the <code>pytorchvideo.data.Ucf101()</code> should work just fine.',Yl,hs,sa="You can access the <code>num_videos</code> argument to know the number of videos in the dataset.",Sl,ds,El,ws,Ql,Js,Nl,f,la='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sample_gif.gif" alt="Person playing basketball"/>',Hl,js,Ll,Ts,ea='Leverage <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow"><code>Trainer</code></a> from  🤗 Transformers for training the model. To instantiate a <code>Trainer</code>, you need to define the training configuration and an evaluation metric. The most important is the <a href="https://huggingface.co/transformers/main_classes/trainer.html#transformers.TrainingArguments" rel="nofollow"><code>TrainingArguments</code></a>, which is a class that contains all the attributes to configure the training. It requires an output folder name, which will be used to save the checkpoints of the model. It also helps sync all the information in the model repository on 🤗 Hub.',ql,Us,aa="Most of the training arguments are self-explanatory, but one that is quite important here is <code>remove_unused_columns=False</code>. This one will drop any features not used by the model’s call function. By default it’s <code>True</code> because usually it’s ideal to drop unused feature columns, making it easier to unpack inputs into the model’s call function. But, in this case, you need the unused features (‘video’ in particular) in order to create <code>pixel_values</code> (which is a mandatory key our model expects in its inputs).",Dl,us,Kl,fs,ta="The dataset returned by <code>pytorchvideo.data.Ucf101()</code> doesn’t implement the <code>__len__</code> method. As such, we must define <code>max_steps</code> when instantiating <code>TrainingArguments</code>.",Pl,bs,na="Next, you need to define a function to compute the metrics from the predictions, which will use the <code>metric</code> you’ll load now. The only preprocessing you have to do is to take the argmax of our predicted logits:",Ol,Is,se,Cs,pa="<strong>A note on evaluation</strong>:",le,gs,ia='In the <a href="https://arxiv.org/abs/2203.12602" rel="nofollow">VideoMAE paper</a>, the authors use the following evaluation strategy. They evaluate the model on several clips from test videos and apply different crops to those clips and report the aggregate score. However, in the interest of simplicity and brevity, we don’t consider that in this tutorial.',ee,vs,oa="Also, define a <code>collate_fn</code>, which will be used to batch examples together. Each batch consists of 2 keys, namely <code>pixel_values</code> and <code>labels</code>.",ae,Zs,te,Gs,Ma="Then you just pass all of this along with the datasets to <code>Trainer</code>:",ne,Ws,pe,Bs,ma="You might wonder why you passed along the <code>image_processor</code> as a tokenizer when you preprocessed the data already. This is only to make sure the image processor configuration file (stored as JSON) will also be uploaded to the repo on the Hub.",ie,_s,ca="Now fine-tune our model by calling the <code>train</code> method:",oe,As,Me,ks,ya='Once training is completed, share your model to the Hub with the <a href="/docs/transformers/v4.35.2/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method so everyone can use your model:',me,Vs,ce,Rs,ye,xs,ra="Great, now that you have fine-tuned a model, you can use it for inference!",re,Xs,ha="Load a video for inference:",he,$s,de,b,da='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sample_gif_two.gif" alt="Teams playing basketball"/>',we,Fs,wa='The simplest way to try out your fine-tuned model for inference is to use it in a <a href="https://huggingface.co/docs/transformers/main/en/main_classes/pipelines#transformers.VideoClassificationPipeline" rel="nofollow"><code>pipeline</code></a>. Instantiate a <code>pipeline</code> for video classification with your model, and pass your video to it:',Je,zs,je,Ys,Ja="You can also manually replicate the results of the <code>pipeline</code> if you’d like.",Te,Ss,Ue,Es,ja="Now, pass your input to the model and return the <code>logits</code>:",ue,Qs,fe,Ns,Ta="Decoding the <code>logits</code>, we get:",be,Hs,Ie,qs,Ce;return T=new Ls({props:{title:"Video classification",local:"video-classification",headingTag:"h1"}}),I=new _a({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/video_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/video_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/video_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/video_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/video_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/video_classification.ipynb"}]}}),u=new Ba({props:{$$slots:{default:[Aa]},$$scope:{ctx:Ds}}}),G=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcHl0b3JjaHZpZGVvJTIwdHJhbnNmb3JtZXJzJTIwZXZhbHVhdGU=",highlighted:"pip install -q pytorchvideo transformers evaluate",wrap:!1}}),_=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),A=new Ls({props:{title:"Load UCF101 dataset",local:"load-ucf101-dataset",headingTag:"h2"}}),V=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWhmX2RhdGFzZXRfaWRlbnRpZmllciUyMCUzRCUyMCUyMnNheWFrcGF1bCUyRnVjZjEwMS1zdWJzZXQlMjIlMEFmaWxlbmFtZSUyMCUzRCUyMCUyMlVDRjEwMV9zdWJzZXQudGFyLmd6JTIyJTBBZmlsZV9wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0RoZl9kYXRhc2V0X2lkZW50aWZpZXIlMkMlMjBmaWxlbmFtZSUzRGZpbGVuYW1lJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>hf_dataset_identifier = <span class="hljs-string">&quot;sayakpaul/ucf101-subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>filename = <span class="hljs-string">&quot;UCF101_subset.tar.gz&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(repo_id=hf_dataset_identifier, filename=filename, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)`,wrap:!1}}),x=new d({props:{code:"aW1wb3J0JTIwdGFyZmlsZSUwQSUwQXdpdGglMjB0YXJmaWxlLm9wZW4oZmlsZV9wYXRoKSUyMGFzJTIwdCUzQSUwQSUyMCUyMCUyMCUyMCUyMHQuZXh0cmFjdGFsbCglMjIuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tarfile

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tarfile.<span class="hljs-built_in">open</span>(file_path) <span class="hljs-keyword">as</span> t:
<span class="hljs-meta">... </span>     t.extractall(<span class="hljs-string">&quot;.&quot;</span>)`,wrap:!1}}),$=new d({props:{code:"VUNGMTAxX3N1YnNldCUyRiUwQSUyMCUyMCUyMCUyMHRyYWluJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQmFuZE1hcmNoaW5nJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMS5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18yLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEFyY2hlcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18xLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZGVvXzIubXA0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwdmFsJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQmFuZE1hcmNoaW5nJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMS5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18yLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEFyY2hlcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18xLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZGVvXzIubXA0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwdGVzdCUyRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEJhbmRNYXJjaGluZyUyRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZGVvXzEubXA0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMi5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBcmNoZXJ5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMS5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18yLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`UCF101_subset/
    train/
        BandMarching/
            video_1.mp4
            video_2.mp4
            ...
        Archery
            video_1.mp4
            video_2.mp4
            ...
        ...
    val/
        BandMarching/
            video_1.mp4
            video_2.mp4
            ...
        Archery
            video_1.mp4
            video_2.mp4
            ...
        ...
    <span class="hljs-built_in">test</span>/
        BandMarching/
            video_1.mp4
            video_2.mp4
            ...
        Archery
            video_1.mp4
            video_2.mp4
            ...
        ...`,wrap:!1}}),z=new d({props:{code:"",highlighted:`...
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g07_c04.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g07_c06.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g08_c01.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g09_c02.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g09_c06.avi&#x27;</span>
...`,wrap:!1}}),N=new d({props:{code:"Y2xhc3NfbGFiZWxzJTIwJTNEJTIwc29ydGVkKCU3QnN0cihwYXRoKS5zcGxpdCglMjIlMkYlMjIpJTVCMiU1RCUyMGZvciUyMHBhdGglMjBpbiUyMGFsbF92aWRlb19maWxlX3BhdGhzJTdEKSUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCbGFiZWwlM0ElMjBpJTIwZm9yJTIwaSUyQyUyMGxhYmVsJTIwaW4lMjBlbnVtZXJhdGUoY2xhc3NfbGFiZWxzKSU3RCUwQWlkMmxhYmVsJTIwJTNEJTIwJTdCaSUzQSUyMGxhYmVsJTIwZm9yJTIwbGFiZWwlMkMlMjBpJTIwaW4lMjBsYWJlbDJpZC5pdGVtcygpJTdEJTBBJTBBcHJpbnQoZiUyMlVuaXF1ZSUyMGNsYXNzZXMlM0ElMjAlN0JsaXN0KGxhYmVsMmlkLmtleXMoKSklN0QuJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>class_labels = <span class="hljs-built_in">sorted</span>({<span class="hljs-built_in">str</span>(path).split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">2</span>] <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> all_video_file_paths})
<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {label: i <span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(class_labels)}
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {i: label <span class="hljs-keyword">for</span> label, i <span class="hljs-keyword">in</span> label2id.items()}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Unique classes: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(label2id.keys())}</span>.&quot;</span>)

<span class="hljs-comment"># Unique classes: [&#x27;ApplyEyeMakeup&#x27;, &#x27;ApplyLipstick&#x27;, &#x27;Archery&#x27;, &#x27;BabyCrawling&#x27;, &#x27;BalanceBeam&#x27;, &#x27;BandMarching&#x27;, &#x27;BaseballPitch&#x27;, &#x27;Basketball&#x27;, &#x27;BasketballDunk&#x27;, &#x27;BenchPress&#x27;].</span>`,wrap:!1}}),L=new Ls({props:{title:"Load a model to fine-tune",local:"load-a-model-to-fine-tune",headingTag:"h2"}}),D=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTUFFSW1hZ2VQcm9jZXNzb3IlMkMlMjBWaWRlb01BRUZvclZpZGVvQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbF9ja3B0JTIwJTNEJTIwJTIyTUNHLU5KVSUyRnZpZGVvbWFlLWJhc2UlMjIlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBWaWRlb01BRUltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9ja3B0KSUwQW1vZGVsJTIwJTNEJTIwVmlkZW9NQUVGb3JWaWRlb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9ja3B0JTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMjAlMjAlMjMlMjBwcm92aWRlJTIwdGhpcyUyMGluJTIwY2FzZSUyMHlvdSdyZSUyMHBsYW5uaW5nJTIwdG8lMjBmaW5lLXR1bmUlMjBhbiUyMGFscmVhZHklMjBmaW5lLXR1bmVkJTIwY2hlY2twb2ludCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoMAEImageProcessor, VideoMAEForVideoClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model_ckpt = <span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = VideoMAEImageProcessor.from_pretrained(model_ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEForVideoClassification.from_pretrained(
<span class="hljs-meta">... </span>    model_ckpt,
<span class="hljs-meta">... </span>    label2id=label2id,
<span class="hljs-meta">... </span>    id2label=id2label,
<span class="hljs-meta">... </span>    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># provide this in case you&#x27;re planning to fine-tune an already fine-tuned checkpoint</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),P=new d({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwTUNHLU5KVSUyRnZpZGVvbWFlLWJhc2UlMjB3ZXJlJTIwbm90JTIwdXNlZCUyMHdoZW4lMjBpbml0aWFsaXppbmclMjBWaWRlb01BRUZvclZpZGVvQ2xhc3NpZmljYXRpb24lM0ElMjAlNUIuLi4lMkMlMjAnZGVjb2Rlci5kZWNvZGVyX2xheWVycy4xLmF0dGVudGlvbi5vdXRwdXQuZGVuc2UuYmlhcyclMkMlMjAnZGVjb2Rlci5kZWNvZGVyX2xheWVycy4yLmF0dGVudGlvbi5hdHRlbnRpb24ua2V5LndlaWdodCclNUQlMEEtJTIwVGhpcyUyMElTJTIwZXhwZWN0ZWQlMjBpZiUyMHlvdSUyMGFyZSUyMGluaXRpYWxpemluZyUyMFZpZGVvTUFFRm9yVmlkZW9DbGFzc2lmaWNhdGlvbiUyMGZyb20lMjB0aGUlMjBjaGVja3BvaW50JTIwb2YlMjBhJTIwbW9kZWwlMjB0cmFpbmVkJTIwb24lMjBhbm90aGVyJTIwdGFzayUyMG9yJTIwd2l0aCUyMGFub3RoZXIlMjBhcmNoaXRlY3R1cmUlMjAoZS5nLiUyMGluaXRpYWxpemluZyUyMGElMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMG1vZGVsJTIwZnJvbSUyMGElMjBCZXJ0Rm9yUHJlVHJhaW5pbmclMjBtb2RlbCkuJTBBLSUyMFRoaXMlMjBJUyUyME5PVCUyMGV4cGVjdGVkJTIwaWYlMjB5b3UlMjBhcmUlMjBpbml0aWFsaXppbmclMjBWaWRlb01BRUZvclZpZGVvQ2xhc3NpZmljYXRpb24lMjBmcm9tJTIwdGhlJTIwY2hlY2twb2ludCUyMG9mJTIwYSUyMG1vZGVsJTIwdGhhdCUyMHlvdSUyMGV4cGVjdCUyMHRvJTIwYmUlMjBleGFjdGx5JTIwaWRlbnRpY2FsJTIwKGluaXRpYWxpemluZyUyMGElMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMG1vZGVsJTIwZnJvbSUyMGElMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMG1vZGVsKS4lMEFTb21lJTIwd2VpZ2h0cyUyMG9mJTIwVmlkZW9NQUVGb3JWaWRlb0NsYXNzaWZpY2F0aW9uJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwTUNHLU5KVSUyRnZpZGVvbWFlLWJhc2UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJ2NsYXNzaWZpZXIuYmlhcyclMkMlMjAnY2xhc3NpZmllci53ZWlnaHQnJTVEJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`Some weights of the model checkpoint at MCG-NJU/videomae-base were not used when initializing VideoMAEForVideoClassification: [..., <span class="hljs-string">&#x27;decoder.decoder_layers.1.attention.output.dense.bias&#x27;</span>, <span class="hljs-string">&#x27;decoder.decoder_layers.2.attention.attention.key.weight&#x27;</span>]
- This IS expected <span class="hljs-keyword">if</span> you are initializing VideoMAEForVideoClassification from the checkpoint of a model trained on another task or with another architecture (e.g. initializing a BertForSequenceClassification model from a BertForPreTraining model).
- This IS NOT expected <span class="hljs-keyword">if</span> you are initializing VideoMAEForVideoClassification from the checkpoint of a model that you expect to be exactly identical (initializing a BertForSequenceClassification model from a BertForSequenceClassification model).
Some weights of VideoMAEForVideoClassification were not initialized from the model checkpoint at MCG-NJU/videomae-base and are newly initialized: [<span class="hljs-string">&#x27;classifier.bias&#x27;</span>, <span class="hljs-string">&#x27;classifier.weight&#x27;</span>]
You should probably TRAIN this model on a down-stream task to be able to use it <span class="hljs-keyword">for</span> predictions and inference.`,wrap:!1}}),ls=new Ls({props:{title:"Prepare the datasets for training",local:"prepare-the-datasets-for-training",headingTag:"h2"}}),as=new d({props:{code:"aW1wb3J0JTIwcHl0b3JjaHZpZGVvLmRhdGElMEElMEFmcm9tJTIwcHl0b3JjaHZpZGVvLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQXBwbHlUcmFuc2Zvcm1Ub0tleSUyQyUwQSUyMCUyMCUyMCUyME5vcm1hbGl6ZSUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbVNob3J0U2lkZVNjYWxlJTJDJTBBJTIwJTIwJTIwJTIwUmVtb3ZlS2V5JTJDJTBBJTIwJTIwJTIwJTIwU2hvcnRTaWRlU2NhbGUlMkMlMEElMjAlMjAlMjAlMjBVbmlmb3JtVGVtcG9yYWxTdWJzYW1wbGUlMkMlMEEpJTBBJTBBZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29tcG9zZSUyQyUwQSUyMCUyMCUyMCUyMExhbWJkYSUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbUNyb3AlMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCUyQyUwQSUyMCUyMCUyMCUyMFJlc2l6ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pytorchvideo.data

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pytorchvideo.transforms <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    ApplyTransformToKey,
<span class="hljs-meta">... </span>    Normalize,
<span class="hljs-meta">... </span>    RandomShortSideScale,
<span class="hljs-meta">... </span>    RemoveKey,
<span class="hljs-meta">... </span>    ShortSideScale,
<span class="hljs-meta">... </span>    UniformTemporalSubsample,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    Compose,
<span class="hljs-meta">... </span>    Lambda,
<span class="hljs-meta">... </span>    RandomCrop,
<span class="hljs-meta">... </span>    RandomHorizontalFlip,
<span class="hljs-meta">... </span>    Resize,
<span class="hljs-meta">... </span>)`,wrap:!1}}),os=new d({props:{code:"bWVhbiUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5pbWFnZV9tZWFuJTBBc3RkJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLmltYWdlX3N0ZCUwQWlmJTIwJTIyc2hvcnRlc3RfZWRnZSUyMiUyMGluJTIwaW1hZ2VfcHJvY2Vzc29yLnNpemUlM0ElMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjB3aWR0aCUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5zaXplJTVCJTIyc2hvcnRlc3RfZWRnZSUyMiU1RCUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCUwQSUyMCUyMCUyMCUyMHdpZHRoJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnNpemUlNUIlMjJ3aWR0aCUyMiU1RCUwQXJlc2l6ZV90byUyMCUzRCUyMChoZWlnaHQlMkMlMjB3aWR0aCklMEElMEFudW1fZnJhbWVzX3RvX3NhbXBsZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5udW1fZnJhbWVzJTBBc2FtcGxlX3JhdGUlMjAlM0QlMjA0JTBBZnBzJTIwJTNEJTIwMzAlMEFjbGlwX2R1cmF0aW9uJTIwJTNEJTIwbnVtX2ZyYW1lc190b19zYW1wbGUlMjAqJTIwc2FtcGxlX3JhdGUlMjAlMkYlMjBmcHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>mean = image_processor.image_mean
<span class="hljs-meta">&gt;&gt;&gt; </span>std = image_processor.image_std
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> <span class="hljs-string">&quot;shortest_edge&quot;</span> <span class="hljs-keyword">in</span> image_processor.size:
<span class="hljs-meta">... </span>    height = width = image_processor.size[<span class="hljs-string">&quot;shortest_edge&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    height = image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]
<span class="hljs-meta">... </span>    width = image_processor.size[<span class="hljs-string">&quot;width&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>resize_to = (height, width)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_frames_to_sample = model.config.num_frames
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_rate = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fps = <span class="hljs-number">30</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>clip_duration = num_frames_to_sample * sample_rate / fps`,wrap:!1}}),ms=new d({props:{code:"dHJhaW5fdHJhbnNmb3JtJTIwJTNEJTIwQ29tcG9zZSglMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBcHBseVRyYW5zZm9ybVRvS2V5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGtleSUzRCUyMnZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3JtJTNEQ29tcG9zZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBVbmlmb3JtVGVtcG9yYWxTdWJzYW1wbGUobnVtX2ZyYW1lc190b19zYW1wbGUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTGFtYmRhKGxhbWJkYSUyMHglM0ElMjB4JTIwJTJGJTIwMjU1LjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTm9ybWFsaXplKG1lYW4lMkMlMjBzdGQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tU2hvcnRTaWRlU2NhbGUobWluX3NpemUlM0QyNTYlMkMlMjBtYXhfc2l6ZSUzRDMyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSYW5kb21Dcm9wKHJlc2l6ZV90byklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcChwJTNEMC41KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBweXRvcmNodmlkZW8uZGF0YS5VY2YxMDEoJTBBJTIwJTIwJTIwJTIwZGF0YV9wYXRoJTNEb3MucGF0aC5qb2luKGRhdGFzZXRfcm9vdF9wYXRoJTJDJTIwJTIydHJhaW4lMjIpJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9zYW1wbGVyJTNEcHl0b3JjaHZpZGVvLmRhdGEubWFrZV9jbGlwX3NhbXBsZXIoJTIycmFuZG9tJTIyJTJDJTIwY2xpcF9kdXJhdGlvbiklMkMlMEElMjAlMjAlMjAlMjBkZWNvZGVfYXVkaW8lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybSUzRHRyYWluX3RyYW5zZm9ybSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_transform = Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        ApplyTransformToKey(
<span class="hljs-meta">... </span>            key=<span class="hljs-string">&quot;video&quot;</span>,
<span class="hljs-meta">... </span>            transform=Compose(
<span class="hljs-meta">... </span>                [
<span class="hljs-meta">... </span>                    UniformTemporalSubsample(num_frames_to_sample),
<span class="hljs-meta">... </span>                    Lambda(<span class="hljs-keyword">lambda</span> x: x / <span class="hljs-number">255.0</span>),
<span class="hljs-meta">... </span>                    Normalize(mean, std),
<span class="hljs-meta">... </span>                    RandomShortSideScale(min_size=<span class="hljs-number">256</span>, max_size=<span class="hljs-number">320</span>),
<span class="hljs-meta">... </span>                    RandomCrop(resize_to),
<span class="hljs-meta">... </span>                    RandomHorizontalFlip(p=<span class="hljs-number">0.5</span>),
<span class="hljs-meta">... </span>                ]
<span class="hljs-meta">... </span>            ),
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = pytorchvideo.data.Ucf101(
<span class="hljs-meta">... </span>    data_path=os.path.join(dataset_root_path, <span class="hljs-string">&quot;train&quot;</span>),
<span class="hljs-meta">... </span>    clip_sampler=pytorchvideo.data.make_clip_sampler(<span class="hljs-string">&quot;random&quot;</span>, clip_duration),
<span class="hljs-meta">... </span>    decode_audio=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    transform=train_transform,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ys=new d({props:{code:"dmFsX3RyYW5zZm9ybSUyMCUzRCUyMENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQXBwbHlUcmFuc2Zvcm1Ub0tleSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBrZXklM0QlMjJ2aWRlbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybSUzRENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVW5pZm9ybVRlbXBvcmFsU3Vic2FtcGxlKG51bV9mcmFtZXNfdG9fc2FtcGxlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMExhbWJkYShsYW1iZGElMjB4JTNBJTIweCUyMCUyRiUyMDI1NS4wKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME5vcm1hbGl6ZShtZWFuJTJDJTIwc3RkKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlc2l6ZShyZXNpemVfdG8pJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBdmFsX2RhdGFzZXQlMjAlM0QlMjBweXRvcmNodmlkZW8uZGF0YS5VY2YxMDEoJTBBJTIwJTIwJTIwJTIwZGF0YV9wYXRoJTNEb3MucGF0aC5qb2luKGRhdGFzZXRfcm9vdF9wYXRoJTJDJTIwJTIydmFsJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfc2FtcGxlciUzRHB5dG9yY2h2aWRlby5kYXRhLm1ha2VfY2xpcF9zYW1wbGVyKCUyMnVuaWZvcm0lMjIlMkMlMjBjbGlwX2R1cmF0aW9uKSUyQyUwQSUyMCUyMCUyMCUyMGRlY29kZV9hdWRpbyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtJTNEdmFsX3RyYW5zZm9ybSUyQyUwQSklMEElMEF0ZXN0X2RhdGFzZXQlMjAlM0QlMjBweXRvcmNodmlkZW8uZGF0YS5VY2YxMDEoJTBBJTIwJTIwJTIwJTIwZGF0YV9wYXRoJTNEb3MucGF0aC5qb2luKGRhdGFzZXRfcm9vdF9wYXRoJTJDJTIwJTIydGVzdCUyMiklMkMlMEElMjAlMjAlMjAlMjBjbGlwX3NhbXBsZXIlM0RweXRvcmNodmlkZW8uZGF0YS5tYWtlX2NsaXBfc2FtcGxlciglMjJ1bmlmb3JtJTIyJTJDJTIwY2xpcF9kdXJhdGlvbiklMkMlMEElMjAlMjAlMjAlMjBkZWNvZGVfYXVkaW8lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybSUzRHZhbF90cmFuc2Zvcm0lMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>val_transform = Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        ApplyTransformToKey(
<span class="hljs-meta">... </span>            key=<span class="hljs-string">&quot;video&quot;</span>,
<span class="hljs-meta">... </span>            transform=Compose(
<span class="hljs-meta">... </span>                [
<span class="hljs-meta">... </span>                    UniformTemporalSubsample(num_frames_to_sample),
<span class="hljs-meta">... </span>                    Lambda(<span class="hljs-keyword">lambda</span> x: x / <span class="hljs-number">255.0</span>),
<span class="hljs-meta">... </span>                    Normalize(mean, std),
<span class="hljs-meta">... </span>                    Resize(resize_to),
<span class="hljs-meta">... </span>                ]
<span class="hljs-meta">... </span>            ),
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>val_dataset = pytorchvideo.data.Ucf101(
<span class="hljs-meta">... </span>    data_path=os.path.join(dataset_root_path, <span class="hljs-string">&quot;val&quot;</span>),
<span class="hljs-meta">... </span>    clip_sampler=pytorchvideo.data.make_clip_sampler(<span class="hljs-string">&quot;uniform&quot;</span>, clip_duration),
<span class="hljs-meta">... </span>    decode_audio=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    transform=val_transform,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>test_dataset = pytorchvideo.data.Ucf101(
<span class="hljs-meta">... </span>    data_path=os.path.join(dataset_root_path, <span class="hljs-string">&quot;test&quot;</span>),
<span class="hljs-meta">... </span>    clip_sampler=pytorchvideo.data.make_clip_sampler(<span class="hljs-string">&quot;uniform&quot;</span>, clip_duration),
<span class="hljs-meta">... </span>    decode_audio=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    transform=val_transform,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ds=new d({props:{code:"cHJpbnQodHJhaW5fZGF0YXNldC5udW1fdmlkZW9zJTJDJTIwdmFsX2RhdGFzZXQubnVtX3ZpZGVvcyUyQyUyMHRlc3RfZGF0YXNldC5udW1fdmlkZW9zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(train_dataset.num_videos, val_dataset.num_videos, test_dataset.num_videos)
<span class="hljs-comment"># (300, 30, 75)</span>`,wrap:!1}}),ws=new Ls({props:{title:"Visualize the preprocessed video for better debugging",local:"visualize-the-preprocessed-video-for-better-debugging",headingTag:"h2"}}),Js=new d({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> imageio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">unnormalize_img</span>(<span class="hljs-params">img</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Un-normalizes the image pixels.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    img = (img * std) + mean
<span class="hljs-meta">... </span>    img = (img * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> img.clip(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_gif</span>(<span class="hljs-params">video_tensor, filename=<span class="hljs-string">&quot;sample.gif&quot;</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Prepares a GIF from a video tensor.
<span class="hljs-meta">... </span>    
<span class="hljs-meta">... </span>    The video tensor is expected to have the following shape:
<span class="hljs-meta">... </span>    (num_frames, num_channels, height, width).
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> video_frame <span class="hljs-keyword">in</span> video_tensor:
<span class="hljs-meta">... </span>        frame_unnormalized = unnormalize_img(video_frame.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>).numpy())
<span class="hljs-meta">... </span>        frames.append(frame_unnormalized)
<span class="hljs-meta">... </span>    kargs = {<span class="hljs-string">&quot;duration&quot;</span>: <span class="hljs-number">0.25</span>}
<span class="hljs-meta">... </span>    imageio.mimsave(filename, frames, <span class="hljs-string">&quot;GIF&quot;</span>, **kargs)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> filename

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">display_gif</span>(<span class="hljs-params">video_tensor, gif_name=<span class="hljs-string">&quot;sample.gif&quot;</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Prepares and displays a GIF from a video tensor.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    video_tensor = video_tensor.permute(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>)
<span class="hljs-meta">... </span>    gif_filename = create_gif(video_tensor, gif_name)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> Image(filename=gif_filename)

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_video = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(train_dataset))
<span class="hljs-meta">&gt;&gt;&gt; </span>video_tensor = sample_video[<span class="hljs-string">&quot;video&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>display_gif(video_tensor)`,wrap:!1}}),js=new Ls({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),us=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjBtb2RlbF9ja3B0LnNwbGl0KCUyMiUyRiUyMiklNUItMSU1RCUwQW5ld19tb2RlbF9uYW1lJTIwJTNEJTIwZiUyMiU3Qm1vZGVsX25hbWUlN0QtZmluZXR1bmVkLXVjZjEwMS1zdWJzZXQlMjIlMEFudW1fZXBvY2hzJTIwJTNEJTIwNCUwQSUwQWFyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBuZXdfbW9kZWxfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbl9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTUlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3JhdGlvJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBtZXRyaWNfZm9yX2Jlc3RfbW9kZWwlM0QlMjJhY2N1cmFjeSUyMiUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRCh0cmFpbl9kYXRhc2V0Lm51bV92aWRlb3MlMjAlMkYlMkYlMjBiYXRjaF9zaXplKSUyMColMjBudW1fZXBvY2hzJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = model_ckpt.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>new_model_name = <span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>-finetuned-ucf101-subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">4</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>args = TrainingArguments(
<span class="hljs-meta">... </span>    new_model_name,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=batch_size,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=batch_size,
<span class="hljs-meta">... </span>    warmup_ratio=<span class="hljs-number">0.1</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    metric_for_best_model=<span class="hljs-string">&quot;accuracy&quot;</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    max_steps=(train_dataset.num_videos // batch_size) * num_epochs,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Is=new d({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmFjY3VyYWN5JTIyKSUwQSUwQSUwQWRlZiUyMGNvbXB1dGVfbWV0cmljcyhldmFsX3ByZWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgoZXZhbF9wcmVkLnByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RldmFsX3ByZWQubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions = np.argmax(eval_pred.predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=eval_pred.label_ids)`,wrap:!1}}),Zs=new d({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBwZXJtdXRlJTIwdG8lMjAobnVtX2ZyYW1lcyUyQyUyMG51bV9jaGFubmVscyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmV4YW1wbGUlNUIlMjJ2aWRlbyUyMiU1RC5wZXJtdXRlKDElMkMlMjAwJTJDJTIwMiUyQyUyMDMpJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QmV4YW1wbGUlNUIlMjJsYWJlbCUyMiU1RCUyMGZvciUyMGV4YW1wbGUlMjBpbiUyMGV4YW1wbGVzJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnBpeGVsX3ZhbHVlcyUyMiUzQSUyMHBpeGVsX3ZhbHVlcyUyQyUyMCUyMmxhYmVscyUyMiUzQSUyMGxhYmVscyU3RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># permute to (num_frames, num_channels, height, width)</span>
<span class="hljs-meta">... </span>    pixel_values = torch.stack(
<span class="hljs-meta">... </span>        [example[<span class="hljs-string">&quot;video&quot;</span>].permute(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>) <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}`,wrap:!1}}),Ws=new d({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRGltYWdlX3Byb2Nlc3NvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRlX2ZuJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model,
<span class="hljs-meta">... </span>    args,
<span class="hljs-meta">... </span>    train_dataset=train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=val_dataset,
<span class="hljs-meta">... </span>    tokenizer=image_processor,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>    data_collator=collate_fn,
<span class="hljs-meta">... </span>)`,wrap:!1}}),As=new d({props:{code:"dHJhaW5fcmVzdWx0cyUyMCUzRCUyMHRyYWluZXIudHJhaW4oKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>train_results = trainer.train()',wrap:!1}}),Vs=new d({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),Rs=new Ls({props:{title:"Inference",local:"inference",headingTag:"h2"}}),$s=new d({props:{code:"c2FtcGxlX3Rlc3RfdmlkZW8lMjAlM0QlMjBuZXh0KGl0ZXIodGVzdF9kYXRhc2V0KSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>sample_test_video = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(test_dataset))',wrap:!1}}),zs=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlkZW9fY2xzJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJteV9hd2Vzb21lX3ZpZGVvX2Nsc19tb2RlbCUyMiklMEF2aWRlb19jbHMoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGc2F5YWtwYXVsJTJGdWNmMTAxLXN1YnNldCUyRnJlc29sdmUlMkZtYWluJTJGdl9CYXNrZXRiYWxsRHVua19nMTRfYzA2LmF2aSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>video_cls = pipeline(model=<span class="hljs-string">&quot;my_awesome_video_cls_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_cls(<span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/ucf101-subset/resolve/main/v_BasketballDunk_g14_c06.avi&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9272987842559814</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BasketballDunk&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.017777055501937866</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BabyCrawling&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.01663011871278286</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BalanceBeam&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.009560945443809032</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BandMarching&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0068979403004050255</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BaseballPitch&#x27;</span>}]`,wrap:!1}}),Ss=new d({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShtb2RlbCUyQyUyMHZpZGVvKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMChudW1fZnJhbWVzJTJDJTIwbnVtX2NoYW5uZWxzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGgpJTBBJTIwJTIwJTIwJTIwcGVydW11dGVkX3NhbXBsZV90ZXN0X3ZpZGVvJTIwJTNEJTIwdmlkZW8ucGVybXV0ZSgxJTJDJTIwMCUyQyUyMDIlMkMlMjAzKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpeGVsX3ZhbHVlcyUyMiUzQSUyMHBlcnVtdXRlZF9zYW1wbGVfdGVzdF92aWRlby51bnNxdWVlemUoMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYWJlbHMlMjIlM0ElMjB0b3JjaC50ZW5zb3IoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCc2FtcGxlX3Rlc3RfdmlkZW8lNUIlMjJsYWJlbCUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMjAlMjAlMjMlMjB0aGlzJTIwY2FuJTIwYmUlMjBza2lwcGVkJTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBsYWJlbHMlMjBhdmFpbGFibGUuJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG1vZGVsLnRvKGRldmljZSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBmb3J3YXJkJTIwcGFzcyUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">model, video</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># (num_frames, num_channels, height, width)</span>
<span class="hljs-meta">... </span>    perumuted_sample_test_video = video.permute(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>)
<span class="hljs-meta">... </span>    inputs = {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;pixel_values&quot;</span>: perumuted_sample_test_video.unsqueeze(<span class="hljs-number">0</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;labels&quot;</span>: torch.tensor(
<span class="hljs-meta">... </span>            [sample_test_video[<span class="hljs-string">&quot;label&quot;</span>]]
<span class="hljs-meta">... </span>        ),  <span class="hljs-comment"># this can be skipped if you don&#x27;t have labels available.</span>
<span class="hljs-meta">... </span>    }

<span class="hljs-meta">... </span>    device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">... </span>    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
<span class="hljs-meta">... </span>    model = model.to(device)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        outputs = model(**inputs)
<span class="hljs-meta">... </span>        logits = outputs.logits

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> logits`,wrap:!1}}),Qs=new d({props:{code:"bG9naXRzJTIwJTNEJTIwcnVuX2luZmVyZW5jZSh0cmFpbmVkX21vZGVsJTJDJTIwc2FtcGxlX3Rlc3RfdmlkZW8lNUIlMjJ2aWRlbyUyMiU1RCk=",highlighted:'&gt;&gt;&gt; logits = run<span class="hljs-constructor">_inference(<span class="hljs-params">trained_model</span>, <span class="hljs-params">sample_test_video</span>[<span class="hljs-string">&quot;video&quot;</span>])</span>',wrap:!1}}),Hs=new d({props:{code:"cHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
<span class="hljs-comment"># Predicted class: BasketballDunk</span>`,wrap:!1}}),{c(){w=p("meta"),J=t(),U=p("p"),j=t(),M(T.$$.fragment),Ks=t(),M(I.$$.fragment),Ps=t(),C=p("p"),C.textContent=ve,Os=t(),g=p("p"),g.textContent=Ze,sl=t(),v=p("ol"),v.innerHTML=Ge,ll=t(),M(u.$$.fragment),el=t(),Z=p("p"),Z.textContent=We,al=t(),M(G.$$.fragment),tl=t(),W=p("p"),W.innerHTML=Be,nl=t(),B=p("p"),B.textContent=_e,pl=t(),M(_.$$.fragment),il=t(),M(A.$$.fragment),ol=t(),k=p("p"),k.innerHTML=Ae,Ml=t(),M(V.$$.fragment),ml=t(),R=p("p"),R.textContent=ke,cl=t(),M(x.$$.fragment),yl=t(),X=p("p"),X.textContent=Ve,rl=t(),M($.$$.fragment),hl=t(),F=p("p"),F.innerHTML=Re,dl=t(),M(z.$$.fragment),wl=t(),Y=p("p"),Y.innerHTML=xe,Jl=t(),S=p("p"),S.innerHTML=Xe,jl=t(),E=p("p"),E.textContent=$e,Tl=t(),Q=p("ul"),Q.innerHTML=Fe,Ul=t(),M(N.$$.fragment),ul=t(),H=p("p"),H.textContent=ze,fl=t(),M(L.$$.fragment),bl=t(),q=p("p"),q.textContent=Ye,Il=t(),M(D.$$.fragment),Cl=t(),K=p("p"),K.textContent=Se,gl=t(),M(P.$$.fragment),vl=t(),O=p("p"),O.innerHTML=Ee,Zl=t(),ss=p("p"),ss.innerHTML=Qe,Gl=t(),M(ls.$$.fragment),Wl=t(),es=p("p"),es.innerHTML=Ne,Bl=t(),M(as.$$.fragment),_l=t(),ts=p("p"),ts.innerHTML=He,Al=t(),ns=p("p"),ns.innerHTML=Le,kl=t(),ps=p("ul"),ps.innerHTML=qe,Vl=t(),is=p("p"),is.textContent=De,Rl=t(),M(os.$$.fragment),xl=t(),Ms=p("p"),Ms.textContent=Ke,Xl=t(),M(ms.$$.fragment),$l=t(),cs=p("p"),cs.textContent=Pe,Fl=t(),M(ys.$$.fragment),zl=t(),rs=p("p"),rs.innerHTML=Oe,Yl=t(),hs=p("p"),hs.innerHTML=sa,Sl=t(),M(ds.$$.fragment),El=t(),M(ws.$$.fragment),Ql=t(),M(Js.$$.fragment),Nl=t(),f=p("div"),f.innerHTML=la,Hl=t(),M(js.$$.fragment),Ll=t(),Ts=p("p"),Ts.innerHTML=ea,ql=t(),Us=p("p"),Us.innerHTML=aa,Dl=t(),M(us.$$.fragment),Kl=t(),fs=p("p"),fs.innerHTML=ta,Pl=t(),bs=p("p"),bs.innerHTML=na,Ol=t(),M(Is.$$.fragment),se=t(),Cs=p("p"),Cs.innerHTML=pa,le=t(),gs=p("p"),gs.innerHTML=ia,ee=t(),vs=p("p"),vs.innerHTML=oa,ae=t(),M(Zs.$$.fragment),te=t(),Gs=p("p"),Gs.innerHTML=Ma,ne=t(),M(Ws.$$.fragment),pe=t(),Bs=p("p"),Bs.innerHTML=ma,ie=t(),_s=p("p"),_s.innerHTML=ca,oe=t(),M(As.$$.fragment),Me=t(),ks=p("p"),ks.innerHTML=ya,me=t(),M(Vs.$$.fragment),ce=t(),M(Rs.$$.fragment),ye=t(),xs=p("p"),xs.textContent=ra,re=t(),Xs=p("p"),Xs.textContent=ha,he=t(),M($s.$$.fragment),de=t(),b=p("div"),b.innerHTML=da,we=t(),Fs=p("p"),Fs.innerHTML=wa,Je=t(),M(zs.$$.fragment),je=t(),Ys=p("p"),Ys.innerHTML=Ja,Te=t(),M(Ss.$$.fragment),Ue=t(),Es=p("p"),Es.innerHTML=ja,ue=t(),M(Qs.$$.fragment),fe=t(),Ns=p("p"),Ns.innerHTML=Ta,be=t(),M(Hs.$$.fragment),Ie=t(),qs=p("p"),this.h()},l(s){const l=va("svelte-u9bgzb",document.head);w=i(l,"META",{name:!0,content:!0}),l.forEach(e),J=n(s),U=i(s,"P",{}),ua(U).forEach(e),j=n(s),m(T.$$.fragment,s),Ks=n(s),m(I.$$.fragment,s),Ps=n(s),C=i(s,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1uw5n59"&&(C.textContent=ve),Os=n(s),g=i(s,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1aff4p7"&&(g.textContent=Ze),sl=n(s),v=i(s,"OL",{"data-svelte-h":!0}),o(v)!=="svelte-1qfvs25"&&(v.innerHTML=Ge),ll=n(s),m(u.$$.fragment,s),el=n(s),Z=i(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1c9nexd"&&(Z.textContent=We),al=n(s),m(G.$$.fragment,s),tl=n(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-cnicg0"&&(W.innerHTML=Be),nl=n(s),B=i(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-27hn0u"&&(B.textContent=_e),pl=n(s),m(_.$$.fragment,s),il=n(s),m(A.$$.fragment,s),ol=n(s),k=i(s,"P",{"data-svelte-h":!0}),o(k)!=="svelte-zo4tpc"&&(k.innerHTML=Ae),Ml=n(s),m(V.$$.fragment,s),ml=n(s),R=i(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-yyrc6l"&&(R.textContent=ke),cl=n(s),m(x.$$.fragment,s),yl=n(s),X=i(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-vxwx6z"&&(X.textContent=Ve),rl=n(s),m($.$$.fragment,s),hl=n(s),F=i(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-xl39ap"&&(F.innerHTML=Re),dl=n(s),m(z.$$.fragment,s),wl=n(s),Y=i(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1t7u230"&&(Y.innerHTML=xe),Jl=n(s),S=i(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-igo46q"&&(S.innerHTML=Xe),jl=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-4ll1ff"&&(E.textContent=$e),Tl=n(s),Q=i(s,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-1y0n38a"&&(Q.innerHTML=Fe),Ul=n(s),m(N.$$.fragment,s),ul=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1z0r2k5"&&(H.textContent=ze),fl=n(s),m(L.$$.fragment,s),bl=n(s),q=i(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-14088fx"&&(q.textContent=Ye),Il=n(s),m(D.$$.fragment,s),Cl=n(s),K=i(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1rauzal"&&(K.textContent=Se),gl=n(s),m(P.$$.fragment,s),vl=n(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-19dkvgp"&&(O.innerHTML=Ee),Zl=n(s),ss=i(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-nk737h"&&(ss.innerHTML=Qe),Gl=n(s),m(ls.$$.fragment,s),Wl=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-islfqt"&&(es.innerHTML=Ne),Bl=n(s),m(as.$$.fragment,s),_l=n(s),ts=i(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-5m4gle"&&(ts.innerHTML=He),Al=n(s),ns=i(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-8w7a7w"&&(ns.innerHTML=Le),kl=n(s),ps=i(s,"UL",{"data-svelte-h":!0}),o(ps)!=="svelte-u2neln"&&(ps.innerHTML=qe),Vl=n(s),is=i(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-llv4fi"&&(is.textContent=De),Rl=n(s),m(os.$$.fragment,s),xl=n(s),Ms=i(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-1lr33l4"&&(Ms.textContent=Ke),Xl=n(s),m(ms.$$.fragment,s),$l=n(s),cs=i(s,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-92qkhv"&&(cs.textContent=Pe),Fl=n(s),m(ys.$$.fragment,s),zl=n(s),rs=i(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-lyltai"&&(rs.innerHTML=Oe),Yl=n(s),hs=i(s,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-1vli4t8"&&(hs.innerHTML=sa),Sl=n(s),m(ds.$$.fragment,s),El=n(s),m(ws.$$.fragment,s),Ql=n(s),m(Js.$$.fragment,s),Nl=n(s),f=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-1mxsghh"&&(f.innerHTML=la),Hl=n(s),m(js.$$.fragment,s),Ll=n(s),Ts=i(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-rirkpj"&&(Ts.innerHTML=ea),ql=n(s),Us=i(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-ixq0kp"&&(Us.innerHTML=aa),Dl=n(s),m(us.$$.fragment,s),Kl=n(s),fs=i(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-1v50sum"&&(fs.innerHTML=ta),Pl=n(s),bs=i(s,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-1kbaooa"&&(bs.innerHTML=na),Ol=n(s),m(Is.$$.fragment,s),se=n(s),Cs=i(s,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-1yc7v5f"&&(Cs.innerHTML=pa),le=n(s),gs=i(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-9bk5j6"&&(gs.innerHTML=ia),ee=n(s),vs=i(s,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-1csqroh"&&(vs.innerHTML=oa),ae=n(s),m(Zs.$$.fragment,s),te=n(s),Gs=i(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-16wl6hd"&&(Gs.innerHTML=Ma),ne=n(s),m(Ws.$$.fragment,s),pe=n(s),Bs=i(s,"P",{"data-svelte-h":!0}),o(Bs)!=="svelte-g6wg27"&&(Bs.innerHTML=ma),ie=n(s),_s=i(s,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-umxz0w"&&(_s.innerHTML=ca),oe=n(s),m(As.$$.fragment,s),Me=n(s),ks=i(s,"P",{"data-svelte-h":!0}),o(ks)!=="svelte-1js6lc3"&&(ks.innerHTML=ya),me=n(s),m(Vs.$$.fragment,s),ce=n(s),m(Rs.$$.fragment,s),ye=n(s),xs=i(s,"P",{"data-svelte-h":!0}),o(xs)!=="svelte-riodtu"&&(xs.textContent=ra),re=n(s),Xs=i(s,"P",{"data-svelte-h":!0}),o(Xs)!=="svelte-w1spga"&&(Xs.textContent=ha),he=n(s),m($s.$$.fragment,s),de=n(s),b=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-556htt"&&(b.innerHTML=da),we=n(s),Fs=i(s,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-e8z0ag"&&(Fs.innerHTML=wa),Je=n(s),m(zs.$$.fragment,s),je=n(s),Ys=i(s,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-1j33lbi"&&(Ys.innerHTML=Ja),Te=n(s),m(Ss.$$.fragment,s),Ue=n(s),Es=i(s,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-12olihs"&&(Es.innerHTML=ja),ue=n(s),m(Qs.$$.fragment,s),fe=n(s),Ns=i(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-1v8qszj"&&(Ns.innerHTML=Ta),be=n(s),m(Hs.$$.fragment,s),Ie=n(s),qs=i(s,"P",{}),ua(qs).forEach(e),this.h()},h(){ge(w,"name","hf:doc:metadata"),ge(w,"content",Va),ge(f,"class","flex justify-center"),ge(b,"class","flex justify-center")},m(s,l){Za(document.head,w),a(s,J,l),a(s,U,l),a(s,j,l),c(T,s,l),a(s,Ks,l),c(I,s,l),a(s,Ps,l),a(s,C,l),a(s,Os,l),a(s,g,l),a(s,sl,l),a(s,v,l),a(s,ll,l),c(u,s,l),a(s,el,l),a(s,Z,l),a(s,al,l),c(G,s,l),a(s,tl,l),a(s,W,l),a(s,nl,l),a(s,B,l),a(s,pl,l),c(_,s,l),a(s,il,l),c(A,s,l),a(s,ol,l),a(s,k,l),a(s,Ml,l),c(V,s,l),a(s,ml,l),a(s,R,l),a(s,cl,l),c(x,s,l),a(s,yl,l),a(s,X,l),a(s,rl,l),c($,s,l),a(s,hl,l),a(s,F,l),a(s,dl,l),c(z,s,l),a(s,wl,l),a(s,Y,l),a(s,Jl,l),a(s,S,l),a(s,jl,l),a(s,E,l),a(s,Tl,l),a(s,Q,l),a(s,Ul,l),c(N,s,l),a(s,ul,l),a(s,H,l),a(s,fl,l),c(L,s,l),a(s,bl,l),a(s,q,l),a(s,Il,l),c(D,s,l),a(s,Cl,l),a(s,K,l),a(s,gl,l),c(P,s,l),a(s,vl,l),a(s,O,l),a(s,Zl,l),a(s,ss,l),a(s,Gl,l),c(ls,s,l),a(s,Wl,l),a(s,es,l),a(s,Bl,l),c(as,s,l),a(s,_l,l),a(s,ts,l),a(s,Al,l),a(s,ns,l),a(s,kl,l),a(s,ps,l),a(s,Vl,l),a(s,is,l),a(s,Rl,l),c(os,s,l),a(s,xl,l),a(s,Ms,l),a(s,Xl,l),c(ms,s,l),a(s,$l,l),a(s,cs,l),a(s,Fl,l),c(ys,s,l),a(s,zl,l),a(s,rs,l),a(s,Yl,l),a(s,hs,l),a(s,Sl,l),c(ds,s,l),a(s,El,l),c(ws,s,l),a(s,Ql,l),c(Js,s,l),a(s,Nl,l),a(s,f,l),a(s,Hl,l),c(js,s,l),a(s,Ll,l),a(s,Ts,l),a(s,ql,l),a(s,Us,l),a(s,Dl,l),c(us,s,l),a(s,Kl,l),a(s,fs,l),a(s,Pl,l),a(s,bs,l),a(s,Ol,l),c(Is,s,l),a(s,se,l),a(s,Cs,l),a(s,le,l),a(s,gs,l),a(s,ee,l),a(s,vs,l),a(s,ae,l),c(Zs,s,l),a(s,te,l),a(s,Gs,l),a(s,ne,l),c(Ws,s,l),a(s,pe,l),a(s,Bs,l),a(s,ie,l),a(s,_s,l),a(s,oe,l),c(As,s,l),a(s,Me,l),a(s,ks,l),a(s,me,l),c(Vs,s,l),a(s,ce,l),c(Rs,s,l),a(s,ye,l),a(s,xs,l),a(s,re,l),a(s,Xs,l),a(s,he,l),c($s,s,l),a(s,de,l),a(s,b,l),a(s,we,l),a(s,Fs,l),a(s,Je,l),c(zs,s,l),a(s,je,l),a(s,Ys,l),a(s,Te,l),c(Ss,s,l),a(s,Ue,l),a(s,Es,l),a(s,ue,l),c(Qs,s,l),a(s,fe,l),a(s,Ns,l),a(s,be,l),c(Hs,s,l),a(s,Ie,l),a(s,qs,l),Ce=!0},p(s,[l]){const Ua={};l&2&&(Ua.$$scope={dirty:l,ctx:s}),u.$set(Ua)},i(s){Ce||(y(T.$$.fragment,s),y(I.$$.fragment,s),y(u.$$.fragment,s),y(G.$$.fragment,s),y(_.$$.fragment,s),y(A.$$.fragment,s),y(V.$$.fragment,s),y(x.$$.fragment,s),y($.$$.fragment,s),y(z.$$.fragment,s),y(N.$$.fragment,s),y(L.$$.fragment,s),y(D.$$.fragment,s),y(P.$$.fragment,s),y(ls.$$.fragment,s),y(as.$$.fragment,s),y(os.$$.fragment,s),y(ms.$$.fragment,s),y(ys.$$.fragment,s),y(ds.$$.fragment,s),y(ws.$$.fragment,s),y(Js.$$.fragment,s),y(js.$$.fragment,s),y(us.$$.fragment,s),y(Is.$$.fragment,s),y(Zs.$$.fragment,s),y(Ws.$$.fragment,s),y(As.$$.fragment,s),y(Vs.$$.fragment,s),y(Rs.$$.fragment,s),y($s.$$.fragment,s),y(zs.$$.fragment,s),y(Ss.$$.fragment,s),y(Qs.$$.fragment,s),y(Hs.$$.fragment,s),Ce=!0)},o(s){r(T.$$.fragment,s),r(I.$$.fragment,s),r(u.$$.fragment,s),r(G.$$.fragment,s),r(_.$$.fragment,s),r(A.$$.fragment,s),r(V.$$.fragment,s),r(x.$$.fragment,s),r($.$$.fragment,s),r(z.$$.fragment,s),r(N.$$.fragment,s),r(L.$$.fragment,s),r(D.$$.fragment,s),r(P.$$.fragment,s),r(ls.$$.fragment,s),r(as.$$.fragment,s),r(os.$$.fragment,s),r(ms.$$.fragment,s),r(ys.$$.fragment,s),r(ds.$$.fragment,s),r(ws.$$.fragment,s),r(Js.$$.fragment,s),r(js.$$.fragment,s),r(us.$$.fragment,s),r(Is.$$.fragment,s),r(Zs.$$.fragment,s),r(Ws.$$.fragment,s),r(As.$$.fragment,s),r(Vs.$$.fragment,s),r(Rs.$$.fragment,s),r($s.$$.fragment,s),r(zs.$$.fragment,s),r(Ss.$$.fragment,s),r(Qs.$$.fragment,s),r(Hs.$$.fragment,s),Ce=!1},d(s){s&&(e(J),e(U),e(j),e(Ks),e(Ps),e(C),e(Os),e(g),e(sl),e(v),e(ll),e(el),e(Z),e(al),e(tl),e(W),e(nl),e(B),e(pl),e(il),e(ol),e(k),e(Ml),e(ml),e(R),e(cl),e(yl),e(X),e(rl),e(hl),e(F),e(dl),e(wl),e(Y),e(Jl),e(S),e(jl),e(E),e(Tl),e(Q),e(Ul),e(ul),e(H),e(fl),e(bl),e(q),e(Il),e(Cl),e(K),e(gl),e(vl),e(O),e(Zl),e(ss),e(Gl),e(Wl),e(es),e(Bl),e(_l),e(ts),e(Al),e(ns),e(kl),e(ps),e(Vl),e(is),e(Rl),e(xl),e(Ms),e(Xl),e($l),e(cs),e(Fl),e(zl),e(rs),e(Yl),e(hs),e(Sl),e(El),e(Ql),e(Nl),e(f),e(Hl),e(Ll),e(Ts),e(ql),e(Us),e(Dl),e(Kl),e(fs),e(Pl),e(bs),e(Ol),e(se),e(Cs),e(le),e(gs),e(ee),e(vs),e(ae),e(te),e(Gs),e(ne),e(pe),e(Bs),e(ie),e(_s),e(oe),e(Me),e(ks),e(me),e(ce),e(ye),e(xs),e(re),e(Xs),e(he),e(de),e(b),e(we),e(Fs),e(Je),e(je),e(Ys),e(Te),e(Ue),e(Es),e(ue),e(fe),e(Ns),e(be),e(Ie),e(qs)),e(w),h(T,s),h(I,s),h(u,s),h(G,s),h(_,s),h(A,s),h(V,s),h(x,s),h($,s),h(z,s),h(N,s),h(L,s),h(D,s),h(P,s),h(ls,s),h(as,s),h(os,s),h(ms,s),h(ys,s),h(ds,s),h(ws,s),h(Js,s),h(js,s),h(us,s),h(Is,s),h(Zs,s),h(Ws,s),h(As,s),h(Vs,s),h(Rs,s),h($s,s),h(zs,s),h(Ss,s),h(Qs,s),h(Hs,s)}}}const Va='{"title":"Video classification","local":"video-classification","sections":[{"title":"Load UCF101 dataset","local":"load-ucf101-dataset","sections":[],"depth":2},{"title":"Load a model to fine-tune","local":"load-a-model-to-fine-tune","sections":[],"depth":2},{"title":"Prepare the datasets for training","local":"prepare-the-datasets-for-training","sections":[],"depth":2},{"title":"Visualize the preprocessed video for better debugging","local":"visualize-the-preprocessed-video-for-better-debugging","sections":[],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Ra(Ds){return ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sa extends Ca{constructor(w){super(),ga(this,w,Ra,ka,fa,{})}}export{Sa as component};
