import{s as ot,n as rt,o as at}from"../chunks/scheduler.9bc65507.js";import{S as it,i as lt,g as a,s,r as p,A as dt,h as i,f as n,c as o,j as w,u as g,x as m,k as b,y as t,a as c,v as f,d as u,t as h,w as k}from"../chunks/index.707bf1b6.js";import{D as z}from"../chunks/Docstring.17db21ae.js";import{C as ct}from"../chunks/CodeBlock.54a9f38d.js";import{H as He}from"../chunks/Heading.342b1fa6.js";function mt(Xe){let T,re,se,ae,B,ie,I,le,C,De='The BERTweet model was proposed in <a href="https://www.aclweb.org/anthology/2020.emnlp-demos.2.pdf" rel="nofollow">BERTweet: A pre-trained language model for English Tweets</a> by Dat Quoc Nguyen, Thanh Vu, Anh Tuan Nguyen.',de,q,Pe="The abstract from the paper is the following:",ce,U,We=`<em>We present BERTweet, the first public large-scale pre-trained language model for English Tweets. Our BERTweet, having
the same architecture as BERT-base (Devlin et al., 2019), is trained using the RoBERTa pre-training procedure (Liu et
al., 2019). Experiments show that BERTweet outperforms strong baselines RoBERTa-base and XLM-R-base (Conneau et al.,
2020), producing better performance results than the previous state-of-the-art models on three Tweet NLP tasks:
Part-of-speech tagging, Named-entity recognition and text classification.</em>`,me,E,Qe="Example of use:",pe,j,ge,L,Ne='This model was contributed by <a href="https://huggingface.co/dqnguyen" rel="nofollow">dqnguyen</a>. The original code can be found <a href="https://github.com/VinAIResearch/BERTweet" rel="nofollow">here</a>.',fe,V,ue,l,R,$e,Q,Se="Constructs a BERTweet tokenizer, using Byte-Pair-Encoding.",xe,N,Ae=`This tokenizer inherits from <a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Je,v,Z,Me,S,Ge="Loads a pre-existing dictionary from a text file and adds its symbols to this instance.",ze,_,F,Be,A,Ye=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. A BERTweet sequence has the following format:`,Ie,G,Oe="<li>single sequence: <code>&lt;s&gt; X &lt;/s&gt;</code></li> <li>pair of sequences: <code>&lt;s&gt; A &lt;/s&gt;&lt;/s&gt; B &lt;/s&gt;</code></li>",Ce,y,H,qe,Y,Ke="Converts a sequence of tokens (string) in a single string.",Ue,$,X,Ee,O,et=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. BERTweet does
not make use of token type ids, therefore a list of zeros is returned.`,je,x,D,Le,K,tt=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Ve,J,P,Re,ee,nt="Normalize tokens in a Tweet",Ze,M,W,Fe,te,st="Normalize a raw Tweet",he,oe,ke;return B=new He({props:{title:"BERTweet",local:"bertweet",headingTag:"h1"}}),I=new He({props:{title:"Overview",local:"overview",headingTag:"h2"}}),j=new ct({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWJlcnR3ZWV0JTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ2aW5haSUyRmJlcnR3ZWV0LWJhc2UlMjIpJTBBJTBBJTIzJTIwRm9yJTIwdHJhbnNmb3JtZXJzJTIwdjQueCUyQiUzQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnZpbmFpJTJGYmVydHdlZXQtYmFzZSUyMiUyQyUyMHVzZV9mYXN0JTNERmFsc2UpJTBBJTBBJTIzJTIwRm9yJTIwdHJhbnNmb3JtZXJzJTIwdjMueCUzQSUwQSUyMyUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnZpbmFpJTJGYmVydHdlZXQtYmFzZSUyMiklMEElMEElMjMlMjBJTlBVVCUyMFRXRUVUJTIwSVMlMjBBTFJFQURZJTIwTk9STUFMSVpFRCElMEFsaW5lJTIwJTNEJTIwJTIyU0MlMjBoYXMlMjBmaXJzdCUyMHR3byUyMHByZXN1bXB0aXZlJTIwY2FzZXMlMjBvZiUyMGNvcm9uYXZpcnVzJTIwJTJDJTIwREhFQyUyMGNvbmZpcm1zJTIwSFRUUFVSTCUyMHZpYSUyMCU0MFVTRVIlMjAlM0FjcnklM0ElMjIlMEElMEFpbnB1dF9pZHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCdG9rZW5pemVyLmVuY29kZShsaW5lKSU1RCklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZmVhdHVyZXMlMjAlM0QlMjBiZXJ0d2VldChpbnB1dF9pZHMpJTIwJTIwJTIzJTIwTW9kZWxzJTIwb3V0cHV0cyUyMGFyZSUyMG5vdyUyMHR1cGxlcyUwQSUwQSUyMyUyMFdpdGglMjBUZW5zb3JGbG93JTIwMi4wJTJCJTNBJTBBJTIzJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsJTBBJTIzJTIwYmVydHdlZXQlMjAlM0QlMjBURkF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydmluYWklMkZiZXJ0d2VldC1iYXNlJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>bertweet = AutoModel.from_pretrained(<span class="hljs-string">&quot;vinai/bertweet-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For transformers v4.x+:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;vinai/bertweet-base&quot;</span>, use_fast=<span class="hljs-literal">False</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For transformers v3.x:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tokenizer = AutoTokenizer.from_pretrained(&quot;vinai/bertweet-base&quot;)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># INPUT TWEET IS ALREADY NORMALIZED!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>line = <span class="hljs-string">&quot;SC has first two presumptive cases of coronavirus , DHEC confirms HTTPURL via @USER :cry:&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(line)])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    features = bertweet(input_ids)  <span class="hljs-comment"># Models outputs are now tuples</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With TensorFlow 2.0+:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># from transformers import TFAutoModel</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># bertweet = TFAutoModel.from_pretrained(&quot;vinai/bertweet-base&quot;)</span>`,wrap:!1}}),V=new He({props:{title:"BertweetTokenizer",local:"transformers.BertweetTokenizer",headingTag:"h2"}}),R=new z({props:{name:"class transformers.BertweetTokenizer",anchor:"transformers.BertweetTokenizer",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"normalization",val:" = False"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BertweetTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.BertweetTokenizer.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.BertweetTokenizer.normalization",description:`<strong>normalization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to apply a normalization preprocess.`,name:"normalization"},{anchor:"transformers.BertweetTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.BertweetTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.BertweetTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.BertweetTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.BertweetTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.BertweetTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.BertweetTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/bertweet/tokenization_bertweet.py#L68"}}),Z=new z({props:{name:"add_from_file",anchor:"transformers.BertweetTokenizer.add_from_file",parameters:[{name:"f",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/bertweet/tokenization_bertweet.py#L418"}}),F=new z({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.BertweetTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.BertweetTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.BertweetTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/bertweet/tokenization_bertweet.py#L183",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),H=new z({props:{name:"convert_tokens_to_string",anchor:"transformers.BertweetTokenizer.convert_tokens_to_string",parameters:[{name:"tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/bertweet/tokenization_bertweet.py#L384"}}),X=new z({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.BertweetTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.BertweetTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.BertweetTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/bertweet/tokenization_bertweet.py#L237",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of zeros.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),D=new z({props:{name:"get_special_tokens_mask",anchor:"transformers.BertweetTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.BertweetTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.BertweetTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.BertweetTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/bertweet/tokenization_bertweet.py#L209",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),P=new z({props:{name:"normalizeToken",anchor:"transformers.BertweetTokenizer.normalizeToken",parameters:[{name:"token",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/bertweet/tokenization_bertweet.py#L357"}}),W=new z({props:{name:"normalizeTweet",anchor:"transformers.BertweetTokenizer.normalizeTweet",parameters:[{name:"tweet",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/bertweet/tokenization_bertweet.py#L323"}}),{c(){T=a("meta"),re=s(),se=a("p"),ae=s(),p(B.$$.fragment),ie=s(),p(I.$$.fragment),le=s(),C=a("p"),C.innerHTML=De,de=s(),q=a("p"),q.textContent=Pe,ce=s(),U=a("p"),U.innerHTML=We,me=s(),E=a("p"),E.textContent=Qe,pe=s(),p(j.$$.fragment),ge=s(),L=a("p"),L.innerHTML=Ne,fe=s(),p(V.$$.fragment),ue=s(),l=a("div"),p(R.$$.fragment),$e=s(),Q=a("p"),Q.textContent=Se,xe=s(),N=a("p"),N.innerHTML=Ae,Je=s(),v=a("div"),p(Z.$$.fragment),Me=s(),S=a("p"),S.textContent=Ge,ze=s(),_=a("div"),p(F.$$.fragment),Be=s(),A=a("p"),A.textContent=Ye,Ie=s(),G=a("ul"),G.innerHTML=Oe,Ce=s(),y=a("div"),p(H.$$.fragment),qe=s(),Y=a("p"),Y.textContent=Ke,Ue=s(),$=a("div"),p(X.$$.fragment),Ee=s(),O=a("p"),O.textContent=et,je=s(),x=a("div"),p(D.$$.fragment),Le=s(),K=a("p"),K.innerHTML=tt,Ve=s(),J=a("div"),p(P.$$.fragment),Re=s(),ee=a("p"),ee.textContent=nt,Ze=s(),M=a("div"),p(W.$$.fragment),Fe=s(),te=a("p"),te.textContent=st,he=s(),oe=a("p"),this.h()},l(e){const r=dt("svelte-u9bgzb",document.head);T=i(r,"META",{name:!0,content:!0}),r.forEach(n),re=o(e),se=i(e,"P",{}),w(se).forEach(n),ae=o(e),g(B.$$.fragment,e),ie=o(e),g(I.$$.fragment,e),le=o(e),C=i(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1tvfkok"&&(C.innerHTML=De),de=o(e),q=i(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-vfdo9a"&&(q.textContent=Pe),ce=o(e),U=i(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-eh682o"&&(U.innerHTML=We),me=o(e),E=i(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1euxn0a"&&(E.textContent=Qe),pe=o(e),g(j.$$.fragment,e),ge=o(e),L=i(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-fl8xrj"&&(L.innerHTML=Ne),fe=o(e),g(V.$$.fragment,e),ue=o(e),l=i(e,"DIV",{class:!0});var d=w(l);g(R.$$.fragment,d),$e=o(d),Q=i(d,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-b8riyv"&&(Q.textContent=Se),xe=o(d),N=i(d,"P",{"data-svelte-h":!0}),m(N)!=="svelte-7nx0d1"&&(N.innerHTML=Ae),Je=o(d),v=i(d,"DIV",{class:!0});var _e=w(v);g(Z.$$.fragment,_e),Me=o(_e),S=i(_e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-ooaeix"&&(S.textContent=Ge),_e.forEach(n),ze=o(d),_=i(d,"DIV",{class:!0});var ne=w(_);g(F.$$.fragment,ne),Be=o(ne),A=i(ne,"P",{"data-svelte-h":!0}),m(A)!=="svelte-zjm6uf"&&(A.textContent=Ye),Ie=o(ne),G=i(ne,"UL",{"data-svelte-h":!0}),m(G)!=="svelte-rq8uot"&&(G.innerHTML=Oe),ne.forEach(n),Ce=o(d),y=i(d,"DIV",{class:!0});var we=w(y);g(H.$$.fragment,we),qe=o(we),Y=i(we,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-b3k2yi"&&(Y.textContent=Ke),we.forEach(n),Ue=o(d),$=i(d,"DIV",{class:!0});var be=w($);g(X.$$.fragment,be),Ee=o(be),O=i(be,"P",{"data-svelte-h":!0}),m(O)!=="svelte-vpfvn5"&&(O.textContent=et),be.forEach(n),je=o(d),x=i(d,"DIV",{class:!0});var Te=w(x);g(D.$$.fragment,Te),Le=o(Te),K=i(Te,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1f4f5kp"&&(K.innerHTML=tt),Te.forEach(n),Ve=o(d),J=i(d,"DIV",{class:!0});var ve=w(J);g(P.$$.fragment,ve),Re=o(ve),ee=i(ve,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1jdrmaw"&&(ee.textContent=nt),ve.forEach(n),Ze=o(d),M=i(d,"DIV",{class:!0});var ye=w(M);g(W.$$.fragment,ye),Fe=o(ye),te=i(ye,"P",{"data-svelte-h":!0}),m(te)!=="svelte-15su17z"&&(te.textContent=st),ye.forEach(n),d.forEach(n),he=o(e),oe=i(e,"P",{}),w(oe).forEach(n),this.h()},h(){b(T,"name","hf:doc:metadata"),b(T,"content",pt),b(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,T),c(e,re,r),c(e,se,r),c(e,ae,r),f(B,e,r),c(e,ie,r),f(I,e,r),c(e,le,r),c(e,C,r),c(e,de,r),c(e,q,r),c(e,ce,r),c(e,U,r),c(e,me,r),c(e,E,r),c(e,pe,r),f(j,e,r),c(e,ge,r),c(e,L,r),c(e,fe,r),f(V,e,r),c(e,ue,r),c(e,l,r),f(R,l,null),t(l,$e),t(l,Q),t(l,xe),t(l,N),t(l,Je),t(l,v),f(Z,v,null),t(v,Me),t(v,S),t(l,ze),t(l,_),f(F,_,null),t(_,Be),t(_,A),t(_,Ie),t(_,G),t(l,Ce),t(l,y),f(H,y,null),t(y,qe),t(y,Y),t(l,Ue),t(l,$),f(X,$,null),t($,Ee),t($,O),t(l,je),t(l,x),f(D,x,null),t(x,Le),t(x,K),t(l,Ve),t(l,J),f(P,J,null),t(J,Re),t(J,ee),t(l,Ze),t(l,M),f(W,M,null),t(M,Fe),t(M,te),c(e,he,r),c(e,oe,r),ke=!0},p:rt,i(e){ke||(u(B.$$.fragment,e),u(I.$$.fragment,e),u(j.$$.fragment,e),u(V.$$.fragment,e),u(R.$$.fragment,e),u(Z.$$.fragment,e),u(F.$$.fragment,e),u(H.$$.fragment,e),u(X.$$.fragment,e),u(D.$$.fragment,e),u(P.$$.fragment,e),u(W.$$.fragment,e),ke=!0)},o(e){h(B.$$.fragment,e),h(I.$$.fragment,e),h(j.$$.fragment,e),h(V.$$.fragment,e),h(R.$$.fragment,e),h(Z.$$.fragment,e),h(F.$$.fragment,e),h(H.$$.fragment,e),h(X.$$.fragment,e),h(D.$$.fragment,e),h(P.$$.fragment,e),h(W.$$.fragment,e),ke=!1},d(e){e&&(n(re),n(se),n(ae),n(ie),n(le),n(C),n(de),n(q),n(ce),n(U),n(me),n(E),n(pe),n(ge),n(L),n(fe),n(ue),n(l),n(he),n(oe)),n(T),k(B,e),k(I,e),k(j,e),k(V,e),k(R),k(Z),k(F),k(H),k(X),k(D),k(P),k(W)}}}const pt='{"title":"BERTweet","local":"bertweet","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"BertweetTokenizer","local":"transformers.BertweetTokenizer","sections":[],"depth":2}],"depth":1}';function gt(Xe){return at(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wt extends it{constructor(T){super(),lt(this,T,gt,mt,ot,{})}}export{wt as component};
