import{s as ss,o as as,n as x}from"../chunks/scheduler.9bc65507.js";import{S as rs,i as ls,g as p,s as r,r as _,A as is,h as m,f as s,c as l,j as q,u as T,x as f,k as I,y as c,a as d,v as b,d as y,t as M,w as v}from"../chunks/index.707bf1b6.js";import{T as he}from"../chunks/Tip.c2ecdbf4.js";import{D as X}from"../chunks/Docstring.17db21ae.js";import{C as ue}from"../chunks/CodeBlock.54a9f38d.js";import{E as pe}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as me}from"../chunks/Heading.342b1fa6.js";function ds(w){let t,h="Examples:",o,a,k;return a=new ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENUUkxDb25maWclMkMlMjBDVFJMTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ1RSTCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwQ1RSTENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBDVFJMTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CTRLConfig, CTRLModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CTRL configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = CTRLConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,o=r(),_(a.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=h),o=l(n),T(a.$$.fragment,n)},m(n,g){d(n,t,g),d(n,o,g),b(a,n,g),k=!0},p:x,i(n){k||(y(a.$$.fragment,n),k=!0)},o(n){M(a.$$.fragment,n),k=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function cs(w){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=h},l(o){t=m(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(o,a){d(o,t,a)},p:x,d(o){o&&s(t)}}}function ps(w){let t,h="Example:",o,a,k;return a=new ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDVFJMTW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZjdHJsJTIyKSUwQW1vZGVsJTIwJTNEJTIwQ1RSTE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGY3RybCUyMiklMEElMEElMjMlMjBDVFJMJTIwd2FzJTIwdHJhaW5lZCUyMHdpdGglMjBjb250cm9sJTIwY29kZXMlMjBhcyUyMHRoZSUyMGZpcnN0JTIwdG9rZW4lMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyT3BpbmlvbiUyME15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFhc3NlcnQlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlNUIwJTJDJTIwMCU1RC5pdGVtKCklMjBpbiUyMHRva2VuaXplci5jb250cm9sX2NvZGVzLnZhbHVlcygpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CTRLModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLModel.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># CTRL was trained with control codes as the first token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Opinion My dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">0</span>].item() <span class="hljs-keyword">in</span> tokenizer.control_codes.values()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">5</span>, <span class="hljs-number">1280</span>]`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,o=r(),_(a.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),f(t)!=="svelte-11lpom8"&&(t.textContent=h),o=l(n),T(a.$$.fragment,n)},m(n,g){d(n,t,g),d(n,o,g),b(a,n,g),k=!0},p:x,i(n){k||(y(a.$$.fragment,n),k=!0)},o(n){M(a.$$.fragment,n),k=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function ms(w){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=h},l(o){t=m(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(o,a){d(o,t,a)},p:x,d(o){o&&s(t)}}}function us(w){let t,h="Example:",o,a,k;return a=new ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMENUUkxMTUhlYWRNb2RlbCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZjdHJsJTIyKSUwQW1vZGVsJTIwJTNEJTIwQ1RSTExNSGVhZE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGY3RybCUyMiklMEElMEElMjMlMjBDVFJMJTIwd2FzJTIwdHJhaW5lZCUyMHdpdGglMjBjb250cm9sJTIwY29kZXMlMjBhcyUyMHRoZSUyMGZpcnN0JTIwdG9rZW4lMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyV2lraXBlZGlhJTIwVGhlJTIwbGxhbWElMjBpcyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBYXNzZXJ0JTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTVCMCUyQyUyMDAlNUQuaXRlbSgpJTIwaW4lMjB0b2tlbml6ZXIuY29udHJvbF9jb2Rlcy52YWx1ZXMoKSUwQSUwQXNlcXVlbmNlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEFzZXF1ZW5jZXMlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKHNlcXVlbmNlX2lkcyklMEFzZXF1ZW5jZXMlMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBcm91bmQob3V0cHV0cy5sb3NzLml0ZW0oKSUyQyUyMDIpJTBBJTBBbGlzdChvdXRwdXRzLmxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CTRLLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLLMHeadModel.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># CTRL was trained with control codes as the first token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Wikipedia The llama is&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">0</span>].item() <span class="hljs-keyword">in</span> tokenizer.control_codes.values()

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = tokenizer.batch_decode(sequence_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>sequences
[<span class="hljs-string">&#x27;Wikipedia The llama is a member of the family Bovidae. It is native to the Andes of Peru,&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(outputs.loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">9.21</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(outputs.logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">5</span>, <span class="hljs-number">246534</span>]`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,o=r(),_(a.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),f(t)!=="svelte-11lpom8"&&(t.textContent=h),o=l(n),T(a.$$.fragment,n)},m(n,g){d(n,t,g),d(n,o,g),b(a,n,g),k=!0},p:x,i(n){k||(y(a.$$.fragment,n),k=!0)},o(n){M(a.$$.fragment,n),k=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function hs(w){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=h},l(o){t=m(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(o,a){d(o,t,a)},p:x,d(o){o&&s(t)}}}function fs(w){let t,h="Example of single-label classification:",o,a,k;return a=new ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMENUUkxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBbW9kZWwlMjAlM0QlMjBDVFJMRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBJTBBJTIzJTIwQ1RSTCUyMHdhcyUyMHRyYWluZWQlMjB3aXRoJTIwY29udHJvbCUyMGNvZGVzJTIwYXMlMjB0aGUlMjBmaXJzdCUyMHRva2VuJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk9waW5pb24lMjBNeSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBYXNzZXJ0JTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTVCMCUyQyUyMDAlNUQuaXRlbSgpJTIwaW4lMjB0b2tlbml6ZXIuY29udHJvbF9jb2Rlcy52YWx1ZXMoKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQW1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CTRLForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># CTRL was trained with control codes as the first token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Opinion My dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">0</span>].item() <span class="hljs-keyword">in</span> tokenizer.control_codes.values()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
<span class="hljs-string">&#x27;LABEL_0&#x27;</span>`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,o=r(),_(a.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),f(t)!=="svelte-ykxpe4"&&(t.textContent=h),o=l(n),T(a.$$.fragment,n)},m(n,g){d(n,t,g),d(n,o,g),b(a,n,g),k=!0},p:x,i(n){k||(y(a.$$.fragment,n),k=!0)},o(n){M(a.$$.fragment,n),k=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function gs(w){let t,h;return t=new ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5tYW51YWxfc2VlZCg0MiklMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBDVFJMRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIlMkMlMjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyklMEElMEFsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoMSklMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3MlMEFyb3VuZChsb3NzLml0ZW0oKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">0.35</span>`,wrap:!1}}),{c(){_(t.$$.fragment)},l(o){T(t.$$.fragment,o)},m(o,a){b(t,o,a),h=!0},p:x,i(o){h||(y(t.$$.fragment,o),h=!0)},o(o){M(t.$$.fragment,o),h=!1},d(o){v(t,o)}}}function _s(w){let t,h="Example of multi-label classification:",o,a,k;return a=new ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMENUUkxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBbW9kZWwlMjAlM0QlMjBDVFJMRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIlMkMlMjBwcm9ibGVtX3R5cGUlM0QlMjJtdWx0aV9sYWJlbF9jbGFzc2lmaWNhdGlvbiUyMiUwQSklMEElMEElMjMlMjBDVFJMJTIwd2FzJTIwdHJhaW5lZCUyMHdpdGglMjBjb250cm9sJTIwY29kZXMlMjBhcyUyMHRoZSUyMGZpcnN0JTIwdG9rZW4lMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyT3BpbmlvbiUyME15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFhc3NlcnQlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlNUIwJTJDJTIwMCU1RC5pdGVtKCklMjBpbiUyMHRva2VuaXplci5jb250cm9sX2NvZGVzLnZhbHVlcygpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWQlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KCkuaXRlbSgpJTBBbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CTRLForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># CTRL was trained with control codes as the first token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Opinion My dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">0</span>].item() <span class="hljs-keyword">in</span> tokenizer.control_codes.values()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
<span class="hljs-string">&#x27;LABEL_0&#x27;</span>`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,o=r(),_(a.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1l8e32d"&&(t.textContent=h),o=l(n),T(a.$$.fragment,n)},m(n,g){d(n,t,g),d(n,o,g),b(a,n,g),k=!0},p:x,i(n){k||(y(a.$$.fragment,n),k=!0)},o(n){M(a.$$.fragment,n),k=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function Ts(w){let t,h;return t=new ue({props:{code:"JTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwQ1RSTEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZjdHJsJTIyJTJDJTIwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMpJTBBJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5vbmVfaG90KHRvcmNoLnRlbnNvciglNUJwcmVkaWN0ZWRfY2xhc3NfaWQlNUQpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKS50byglMEElMjAlMjAlMjAlMjB0b3JjaC5mbG9hdCUwQSklMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3MlMEFsb3NzLmJhY2t3YXJkKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CTRLForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.nn.functional.one_hot(torch.tensor([predicted_class_id]), num_classes=num_labels).to(
<span class="hljs-meta">... </span>    torch.<span class="hljs-built_in">float</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()`,wrap:!1}}),{c(){_(t.$$.fragment)},l(o){T(t.$$.fragment,o)},m(o,a){b(t,o,a),h=!0},p:x,i(o){h||(y(t.$$.fragment,o),h=!0)},o(o){M(t.$$.fragment,o),h=!1},d(o){v(t,o)}}}function bs(w){let t,h="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",o,a,k="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",n,g,se=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,F,$,E=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,j,L,P=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=p("p"),t.innerHTML=h,o=r(),a=p("ul"),a.innerHTML=k,n=r(),g=p("p"),g.innerHTML=se,F=r(),$=p("ul"),$.innerHTML=E,j=r(),L=p("p"),L.innerHTML=P},l(u){t=m(u,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1ajbfxg"&&(t.innerHTML=h),o=l(u),a=m(u,"UL",{"data-svelte-h":!0}),f(a)!=="svelte-qm1t26"&&(a.innerHTML=k),n=l(u),g=m(u,"P",{"data-svelte-h":!0}),f(g)!=="svelte-1v9qsc5"&&(g.innerHTML=se),F=l(u),$=m(u,"UL",{"data-svelte-h":!0}),f($)!=="svelte-15scerc"&&($.innerHTML=E),j=l(u),L=m(u,"P",{"data-svelte-h":!0}),f(L)!=="svelte-1an3odd"&&(L.innerHTML=P)},m(u,C){d(u,t,C),d(u,o,C),d(u,a,C),d(u,n,C),d(u,g,C),d(u,F,C),d(u,$,C),d(u,j,C),d(u,L,C)},p:x,d(u){u&&(s(t),s(o),s(a),s(n),s(g),s(F),s($),s(j),s(L))}}}function ys(w){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=h},l(o){t=m(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(o,a){d(o,t,a)},p:x,d(o){o&&s(t)}}}function Ms(w){let t,h="Example:",o,a,k;return a=new ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkNUUkxNb2RlbCUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkNUUkxNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFCTRLModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFCTRLModel.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,o=r(),_(a.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),f(t)!=="svelte-11lpom8"&&(t.textContent=h),o=l(n),T(a.$$.fragment,n)},m(n,g){d(n,t,g),d(n,o,g),b(a,n,g),k=!0},p:x,i(n){k||(y(a.$$.fragment,n),k=!0)},o(n){M(a.$$.fragment,n),k=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function vs(w){let t,h="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",o,a,k="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",n,g,se=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,F,$,E=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,j,L,P=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=p("p"),t.innerHTML=h,o=r(),a=p("ul"),a.innerHTML=k,n=r(),g=p("p"),g.innerHTML=se,F=r(),$=p("ul"),$.innerHTML=E,j=r(),L=p("p"),L.innerHTML=P},l(u){t=m(u,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1ajbfxg"&&(t.innerHTML=h),o=l(u),a=m(u,"UL",{"data-svelte-h":!0}),f(a)!=="svelte-qm1t26"&&(a.innerHTML=k),n=l(u),g=m(u,"P",{"data-svelte-h":!0}),f(g)!=="svelte-1v9qsc5"&&(g.innerHTML=se),F=l(u),$=m(u,"UL",{"data-svelte-h":!0}),f($)!=="svelte-15scerc"&&($.innerHTML=E),j=l(u),L=m(u,"P",{"data-svelte-h":!0}),f(L)!=="svelte-1an3odd"&&(L.innerHTML=P)},m(u,C){d(u,t,C),d(u,o,C),d(u,a,C),d(u,n,C),d(u,g,C),d(u,F,C),d(u,$,C),d(u,j,C),d(u,L,C)},p:x,d(u){u&&(s(t),s(o),s(a),s(n),s(g),s(F),s($),s(j),s(L))}}}function ks(w){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=h},l(o){t=m(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(o,a){d(o,t,a)},p:x,d(o){o&&s(t)}}}function ws(w){let t,h="Example:",o,a,k;return a=new ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkNUUkxMTUhlYWRNb2RlbCUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkNUUkxMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFCTRLLMHeadModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFCTRLLMHeadModel.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,o=r(),_(a.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),f(t)!=="svelte-11lpom8"&&(t.textContent=h),o=l(n),T(a.$$.fragment,n)},m(n,g){d(n,t,g),d(n,o,g),b(a,n,g),k=!0},p:x,i(n){k||(y(a.$$.fragment,n),k=!0)},o(n){M(a.$$.fragment,n),k=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function Cs(w){let t,h="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",o,a,k="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",n,g,se=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,F,$,E=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,j,L,P=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=p("p"),t.innerHTML=h,o=r(),a=p("ul"),a.innerHTML=k,n=r(),g=p("p"),g.innerHTML=se,F=r(),$=p("ul"),$.innerHTML=E,j=r(),L=p("p"),L.innerHTML=P},l(u){t=m(u,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1ajbfxg"&&(t.innerHTML=h),o=l(u),a=m(u,"UL",{"data-svelte-h":!0}),f(a)!=="svelte-qm1t26"&&(a.innerHTML=k),n=l(u),g=m(u,"P",{"data-svelte-h":!0}),f(g)!=="svelte-1v9qsc5"&&(g.innerHTML=se),F=l(u),$=m(u,"UL",{"data-svelte-h":!0}),f($)!=="svelte-15scerc"&&($.innerHTML=E),j=l(u),L=m(u,"P",{"data-svelte-h":!0}),f(L)!=="svelte-1an3odd"&&(L.innerHTML=P)},m(u,C){d(u,t,C),d(u,o,C),d(u,a,C),d(u,n,C),d(u,g,C),d(u,F,C),d(u,$,C),d(u,j,C),d(u,L,C)},p:x,d(u){u&&(s(t),s(o),s(a),s(n),s(g),s(F),s($),s(j),s(L))}}}function $s(w){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=h},l(o){t=m(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(o,a){d(o,t,a)},p:x,d(o){o&&s(t)}}}function Ls(w){let t,h="Example:",o,a,k;return a=new ue({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkNUUkxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGY3RybCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQ1RSTEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZjdHJsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwaW50KHRmLm1hdGguYXJnbWF4KGxvZ2l0cyUyQyUyMGF4aXMlM0QtMSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFCTRLForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFCTRLForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){t=p("p"),t.textContent=h,o=r(),_(a.$$.fragment)},l(n){t=m(n,"P",{"data-svelte-h":!0}),f(t)!=="svelte-11lpom8"&&(t.textContent=h),o=l(n),T(a.$$.fragment,n)},m(n,g){d(n,t,g),d(n,o,g),b(a,n,g),k=!0},p:x,i(n){k||(y(a.$$.fragment,n),k=!0)},o(n){M(a.$$.fragment,n),k=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function js(w){let t,h;return t=new ue({props:{code:"JTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwVEZDVFJMRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmN0cmwlMjIlMkMlMjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyklMEElMEFsYWJlbHMlMjAlM0QlMjB0Zi5jb25zdGFudCgxKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on `num_labels` classes, you can pass `num_labels=num_labels` to `.from_pretrained(...)`</span>\n<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)\n<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFCTRLForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Salesforce/ctrl&quot;</span>, num_labels=num_labels)\n\n<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tf.constant(<span class="hljs-number">1</span>)\n<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss',wrap:!1}}),{c(){_(t.$$.fragment)},l(o){T(t.$$.fragment,o)},m(o,a){b(t,o,a),h=!0},p:x,i(o){h||(y(t.$$.fragment,o),h=!0)},o(o){M(t.$$.fragment,o),h=!1},d(o){v(t,o)}}}function Rs(w){let t,h,o,a,k,n,g,se='<a href="https://huggingface.co/models?filter=ctrl"><img alt="Models" src="https://img.shields.io/badge/All_model_pages-ctrl-blueviolet"/></a> <a href="https://huggingface.co/spaces/docs-demos/tiny-ctrl"><img alt="Spaces" src="https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue"/></a>',F,$,E,j,L=`CTRL model was proposed in <a href="https://arxiv.org/abs/1909.05858" rel="nofollow">CTRL: A Conditional Transformer Language Model for Controllable Generation</a> by Nitish Shirish Keskar<em>, Bryan McCann</em>, Lav R. Varshney, Caiming Xiong and
Richard Socher. It’s a causal (unidirectional) transformer pre-trained using language modeling on a very large corpus
of ~140 GB of text data with the first token reserved as a control code (such as Links, Books, Wikipedia etc.).`,P,u,C="The abstract from the paper is the following:",Vt,Ue,To=`<em>Large-scale language models show promising text generation capabilities, but users cannot easily control particular
aspects of the generated text. We release CTRL, a 1.63 billion-parameter conditional transformer language model,
trained to condition on control codes that govern style, content, and task-specific behavior. Control codes were
derived from structure that naturally co-occurs with raw text, preserving the advantages of unsupervised learning while
providing more explicit control over text generation. These codes also allow CTRL to predict which parts of the
training data are most likely given a sequence. This provides a potential method for analyzing large amounts of data
via model-based source attribution.</em>`,Xt,We,bo="Tips:",Gt,Ne,yo=`<li>CTRL makes use of control codes to generate text: it requires generations to be started by certain words, sentences
or links to generate coherent text. Refer to the <a href="https://github.com/salesforce/ctrl" rel="nofollow">original implementation</a> for
more information.</li> <li>CTRL is a model with absolute position embeddings so it’s usually advised to pad the inputs on the right rather than
the left.</li> <li>CTRL was trained with a causal language modeling (CLM) objective and is therefore powerful at predicting the next
token in a sequence. Leveraging this feature allows CTRL to generate syntactically coherent text as it can be
observed in the <em>run_generation.py</em> example script.</li> <li>The PyTorch models can take the <code>past_key_values</code> as input, which is the previously computed key/value attention pairs.
TensorFlow models accepts <code>past</code> as input. Using the <code>past_key_values</code> value prevents the model from re-computing
pre-computed values in the context of text generation. See the <a href="model_doc/ctrl#transformers.CTRLModel.forward"><code>forward</code></a>
method for more information on the usage of this argument.</li>`,Et,qe,Mo=`This model was contributed by <a href="https://huggingface.co/keskarnitishr" rel="nofollow">keskarnitishr</a>. The original code can be found
<a href="https://github.com/salesforce/ctrl" rel="nofollow">here</a>.`,Pt,He,Yt,Ze,vo='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/language_modeling">Causal language modeling task guide</a></li>',Qt,Be,Ot,Y,Se,hn,ct,ko=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> or a <a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a>. It is used to
instantiate a CTRL model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/Salesforce/ctrl" rel="nofollow">Salesforce/ctrl</a> architecture from SalesForce.`,fn,pt,wo=`Configuration objects inherit from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,gn,fe,Dt,Ve,At,Q,Xe,_n,mt,Co="Construct a CTRL tokenizer. Based on Byte-Pair-Encoding.",Tn,ut,$o=`This tokenizer inherits from <a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,bn,ht,Ge,Kt,Ee,en,H,Pe,yn,ft,Lo="The bare CTRL Model transformer outputting raw hidden-states without any specific head on top.",Mn,gt,jo=`This model inherits from <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,vn,_t,Ro=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,kn,ee,Ye,wn,Tt,xo='The <a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> forward method, overrides the <code>__call__</code> special method.',Cn,ge,$n,_e,tn,Qe,nn,Z,Oe,Ln,bt,Fo=`The CTRL Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,jn,yt,Jo=`This model inherits from <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Rn,Mt,zo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,xn,te,De,Fn,vt,Io='The <a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> forward method, overrides the <code>__call__</code> special method.',Jn,Te,zn,be,on,Ae,sn,B,Ke,In,kt,Uo=`The CTRL Model transformer with a sequence classification head on top (linear layer).
<a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLForSequenceClassification">CTRLForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do. Since it does classification on the last token, it requires to know the position of the last
token. If a <code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in
each row. If no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot
guess the padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last
value in each row of the batch).`,Un,wt,Wo=`This model inherits from <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Wn,Ct,No=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Nn,z,et,qn,$t,qo='The <a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLForSequenceClassification">CTRLForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Hn,ye,Zn,Me,Bn,ve,Sn,ke,Vn,we,an,tt,rn,U,nt,Xn,Lt,Ho="The bare CTRL Model transformer outputting raw hidden-states without any specific head on top.",Gn,jt,Zo=`This model inherits from <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,En,Rt,Bo=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Pn,Ce,Yn,ne,ot,Qn,xt,So='The <a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a> forward method, overrides the <code>__call__</code> special method.',On,$e,Dn,Le,ln,st,dn,W,at,An,Ft,Vo=`The CTRL Model transformer with a language modeling head on top (linear layer with weights tied to the input
embeddings).`,Kn,Jt,Xo=`This model inherits from <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,eo,zt,Go=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,to,je,no,oe,rt,oo,It,Eo='The <a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> forward method, overrides the <code>__call__</code> special method.',so,Re,ao,xe,cn,lt,pn,R,it,ro,Ut,Po="The CTRL Model transformer with a sequence classification head on top (linear layer).",lo,Wt,Yo=`<a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.TFCTRLForSequenceClassification">TFCTRLForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-1, GPT-2) do.`,io,Nt,Qo=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,co,qt,Oo=`This model inherits from <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,po,Ht,Do=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">tf.keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,mo,Fe,uo,G,dt,ho,Zt,Ao='The <a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.TFCTRLForSequenceClassification">TFCTRLForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',fo,Je,go,ze,_o,Ie,mn,Bt,un;return k=new me({props:{title:"CTRL",local:"ctrl",headingTag:"h1"}}),$=new me({props:{title:"Overview",local:"overview",headingTag:"h2"}}),He=new me({props:{title:"Documentation resources",local:"documentation-resources",headingTag:"h2"}}),Be=new me({props:{title:"CTRLConfig",local:"transformers.CTRLConfig",headingTag:"h2"}}),Se=new X({props:{name:"class transformers.CTRLConfig",anchor:"transformers.CTRLConfig",parameters:[{name:"vocab_size",val:" = 246534"},{name:"n_positions",val:" = 256"},{name:"n_embd",val:" = 1280"},{name:"dff",val:" = 8192"},{name:"n_layer",val:" = 48"},{name:"n_head",val:" = 16"},{name:"resid_pdrop",val:" = 0.1"},{name:"embd_pdrop",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-06"},{name:"initializer_range",val:" = 0.02"},{name:"use_cache",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CTRLConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 246534) &#x2014;
Vocabulary size of the CTRL model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> or <a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a>.`,name:"vocab_size"},{anchor:"transformers.CTRLConfig.n_positions",description:`<strong>n_positions</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"n_positions"},{anchor:"transformers.CTRLConfig.n_embd",description:`<strong>n_embd</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"n_embd"},{anchor:"transformers.CTRLConfig.dff",description:`<strong>dff</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimensionality of the inner dimension of the feed forward networks (FFN).`,name:"dff"},{anchor:"transformers.CTRLConfig.n_layer",description:`<strong>n_layer</strong> (<code>int</code>, <em>optional</em>, defaults to 48) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"n_layer"},{anchor:"transformers.CTRLConfig.n_head",description:`<strong>n_head</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"n_head"},{anchor:"transformers.CTRLConfig.resid_pdrop",description:`<strong>resid_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"resid_pdrop"},{anchor:"transformers.CTRLConfig.embd_pdrop",description:`<strong>embd_pdrop</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the embeddings.`,name:"embd_pdrop"},{anchor:"transformers.CTRLConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon to use in the layer normalization layers`,name:"layer_norm_epsilon"},{anchor:"transformers.CTRLConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.CTRLConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/configuration_ctrl.py#L28"}}),fe=new pe({props:{anchor:"transformers.CTRLConfig.example",$$slots:{default:[ds]},$$scope:{ctx:w}}}),Ve=new me({props:{title:"CTRLTokenizer",local:"transformers.CTRLTokenizer",headingTag:"h2"}}),Xe=new X({props:{name:"class transformers.CTRLTokenizer",anchor:"transformers.CTRLTokenizer",parameters:[{name:"vocab_file",val:""},{name:"merges_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CTRLTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.CTRLTokenizer.merges_file",description:`<strong>merges_file</strong> (<code>str</code>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.CTRLTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/tokenization_ctrl.py#L119"}}),Ge=new X({props:{name:"save_vocabulary",anchor:"transformers.CTRLTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/tokenization_ctrl.py#L226"}}),Ee=new me({props:{title:"CTRLModel",local:"transformers.CTRLModel",headingTag:"h2"}}),Pe=new X({props:{name:"class transformers.CTRLModel",anchor:"transformers.CTRLModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.CTRLModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/modeling_ctrl.py#L319"}}),Ye=new X({props:{name:"forward",anchor:"transformers.CTRLModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CTRLModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0].shape[-2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only input IDs that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CTRLModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains pre-computed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as input ids as they have already been computed.`,name:"past_key_values"},{anchor:"transformers.CTRLModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CTRLModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.CTRLModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CTRLModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.CTRLModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CTRLModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.CTRLModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CTRLModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CTRLModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/modeling_ctrl.py#L352",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLConfig"
>CTRLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ge=new he({props:{$$slots:{default:[cs]},$$scope:{ctx:w}}}),_e=new pe({props:{anchor:"transformers.CTRLModel.forward.example",$$slots:{default:[ps]},$$scope:{ctx:w}}}),Qe=new me({props:{title:"CTRLLMHeadModel",local:"transformers.CTRLLMHeadModel",headingTag:"h2"}}),Oe=new X({props:{name:"class transformers.CTRLLMHeadModel",anchor:"transformers.CTRLLMHeadModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.CTRLLMHeadModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/modeling_ctrl.py#L511"}}),De=new X({props:{name:"forward",anchor:"transformers.CTRLLMHeadModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CTRLLMHeadModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0].shape[-2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only input IDs that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CTRLLMHeadModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains pre-computed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as input ids as they have already been computed.`,name:"past_key_values"},{anchor:"transformers.CTRLLMHeadModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CTRLLMHeadModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.CTRLLMHeadModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CTRLLMHeadModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.CTRLLMHeadModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CTRLLMHeadModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.CTRLLMHeadModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CTRLLMHeadModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CTRLLMHeadModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.CTRLLMHeadModel.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/modeling_ctrl.py#L544",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLConfig"
>CTRLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Te=new he({props:{$$slots:{default:[ms]},$$scope:{ctx:w}}}),be=new pe({props:{anchor:"transformers.CTRLLMHeadModel.forward.example",$$slots:{default:[us]},$$scope:{ctx:w}}}),Ae=new me({props:{title:"CTRLForSequenceClassification",local:"transformers.CTRLForSequenceClassification",headingTag:"h2"}}),Ke=new X({props:{name:"class transformers.CTRLForSequenceClassification",anchor:"transformers.CTRLForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.CTRLForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/modeling_ctrl.py#L662"}}),et=new X({props:{name:"forward",anchor:"transformers.CTRLForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CTRLForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0].shape[-2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only input IDs that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CTRLForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.FloatTensor]]</code> of length <code>config.n_layers</code>) &#x2014;
Contains pre-computed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as input ids as they have already been computed.`,name:"past_key_values"},{anchor:"transformers.CTRLForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CTRLForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.CTRLForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CTRLForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.CTRLForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CTRLForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.CTRLForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CTRLForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CTRLForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.CTRLForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/modeling_ctrl.py#L672",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLConfig"
>CTRLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ye=new he({props:{$$slots:{default:[hs]},$$scope:{ctx:w}}}),Me=new pe({props:{anchor:"transformers.CTRLForSequenceClassification.forward.example",$$slots:{default:[fs]},$$scope:{ctx:w}}}),ve=new pe({props:{anchor:"transformers.CTRLForSequenceClassification.forward.example-2",$$slots:{default:[gs]},$$scope:{ctx:w}}}),ke=new pe({props:{anchor:"transformers.CTRLForSequenceClassification.forward.example-3",$$slots:{default:[_s]},$$scope:{ctx:w}}}),we=new pe({props:{anchor:"transformers.CTRLForSequenceClassification.forward.example-4",$$slots:{default:[Ts]},$$scope:{ctx:w}}}),tt=new me({props:{title:"TFCTRLModel",local:"transformers.TFCTRLModel",headingTag:"h2"}}),nt=new X({props:{name:"class transformers.TFCTRLModel",anchor:"transformers.TFCTRLModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFCTRLModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/modeling_tf_ctrl.py#L523"}}),Ce=new he({props:{$$slots:{default:[bs]},$$scope:{ctx:w}}}),ot=new X({props:{name:"call",anchor:"transformers.TFCTRLModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"past_key_values",val:": Optional[Tuple[Tuple[Union[np.ndarray, tf.Tensor]]]] = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFCTRLModel.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past</code> is <code>None</code> else <code>past[0].shape[-2]</code> (<code>sequence_length</code> of
input past key value states).</p>
<p>Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past</code> is used, only input IDs that do not have their past calculated should be passed as <code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFCTRLModel.call.past",description:`<strong>past</strong> (<code>List[tf.Tensor]</code> of length <code>config.n_layers</code>) &#x2014;
Contains pre-computed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past</code> output below). Can be used to speed up sequential decoding. The token ids which have their past
given to this model should not be passed as input ids as they have already been computed.`,name:"past"},{anchor:"transformers.TFCTRLModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFCTRLModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFCTRLModel.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFCTRLModel.call.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFCTRLModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFCTRLModel.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past</code> key value states are returned and can be used to speed up decoding (see <code>past</code>).`,name:"use_cache"},{anchor:"transformers.TFCTRLModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFCTRLModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFCTRLModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFCTRLModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/modeling_tf_ctrl.py#L528",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPast"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPast</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLConfig"
>CTRLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPast"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPast</a> or <code>tuple(tf.Tensor)</code></p>
`}}),$e=new he({props:{$$slots:{default:[ys]},$$scope:{ctx:w}}}),Le=new pe({props:{anchor:"transformers.TFCTRLModel.call.example",$$slots:{default:[Ms]},$$scope:{ctx:w}}}),st=new me({props:{title:"TFCTRLLMHeadModel",local:"transformers.TFCTRLLMHeadModel",headingTag:"h2"}}),at=new X({props:{name:"class transformers.TFCTRLLMHeadModel",anchor:"transformers.TFCTRLLMHeadModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFCTRLLMHeadModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/modeling_tf_ctrl.py#L596"}}),je=new he({props:{$$slots:{default:[vs]},$$scope:{ctx:w}}}),rt=new X({props:{name:"call",anchor:"transformers.TFCTRLLMHeadModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"past_key_values",val:": Optional[Tuple[Tuple[Union[np.ndarray, tf.Tensor]]]] = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFCTRLLMHeadModel.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past</code> is <code>None</code> else <code>past[0].shape[-2]</code> (<code>sequence_length</code> of
input past key value states).</p>
<p>Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past</code> is used, only input IDs that do not have their past calculated should be passed as <code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFCTRLLMHeadModel.call.past",description:`<strong>past</strong> (<code>List[tf.Tensor]</code> of length <code>config.n_layers</code>) &#x2014;
Contains pre-computed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past</code> output below). Can be used to speed up sequential decoding. The token ids which have their past
given to this model should not be passed as input ids as they have already been computed.`,name:"past"},{anchor:"transformers.TFCTRLLMHeadModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFCTRLLMHeadModel.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFCTRLLMHeadModel.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFCTRLLMHeadModel.call.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFCTRLLMHeadModel.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFCTRLLMHeadModel.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past</code> key value states are returned and can be used to speed up decoding (see <code>past</code>).`,name:"use_cache"},{anchor:"transformers.TFCTRLLMHeadModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFCTRLLMHeadModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFCTRLLMHeadModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFCTRLLMHeadModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFCTRLLMHeadModel.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the cross entropy classification loss. Indices should be in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/modeling_tf_ctrl.py#L648",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutputWithPast"
>transformers.modeling_tf_outputs.TFCausalLMOutputWithPast</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLConfig"
>CTRLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutputWithPast"
>transformers.modeling_tf_outputs.TFCausalLMOutputWithPast</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Re=new he({props:{$$slots:{default:[ks]},$$scope:{ctx:w}}}),xe=new pe({props:{anchor:"transformers.TFCTRLLMHeadModel.call.example",$$slots:{default:[ws]},$$scope:{ctx:w}}}),lt=new me({props:{title:"TFCTRLForSequenceClassification",local:"transformers.TFCTRLForSequenceClassification",headingTag:"h2"}}),it=new X({props:{name:"class transformers.TFCTRLForSequenceClassification",anchor:"transformers.TFCTRLForSequenceClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFCTRLForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/modeling_tf_ctrl.py#L729"}}),Fe=new he({props:{$$slots:{default:[Cs]},$$scope:{ctx:w}}}),dt=new X({props:{name:"call",anchor:"transformers.TFCTRLForSequenceClassification.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"past_key_values",val:": Optional[Tuple[Tuple[Union[np.ndarray, tf.Tensor]]]] = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"token_type_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"training",val:": Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.TFCTRLForSequenceClassification.call.input_ids",description:`<strong>input_ids</strong> (<code>Numpy array</code> or <code>tf.Tensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past</code> is <code>None</code> else <code>past[0].shape[-2]</code> (<code>sequence_length</code> of
input past key value states).</p>
<p>Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past</code> is used, only input IDs that do not have their past calculated should be passed as <code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> and
<a href="/docs/transformers/v4.35.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFCTRLForSequenceClassification.call.past",description:`<strong>past</strong> (<code>List[tf.Tensor]</code> of length <code>config.n_layers</code>) &#x2014;
Contains pre-computed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past</code> output below). Can be used to speed up sequential decoding. The token ids which have their past
given to this model should not be passed as input ids as they have already been computed.`,name:"past"},{anchor:"transformers.TFCTRLForSequenceClassification.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFCTRLForSequenceClassification.call.token_type_ids",description:`<strong>token_type_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.TFCTRLForSequenceClassification.call.position_ids",description:`<strong>position_ids</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.TFCTRLForSequenceClassification.call.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFCTRLForSequenceClassification.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>tf.Tensor</code> or <code>Numpy array</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFCTRLForSequenceClassification.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past</code> key value states are returned and can be used to speed up decoding (see <code>past</code>).`,name:"use_cache"},{anchor:"transformers.TFCTRLForSequenceClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFCTRLForSequenceClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFCTRLForSequenceClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFCTRLForSequenceClassification.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"},{anchor:"transformers.TFCTRLForSequenceClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the cross entropy classification loss. Indices should be in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/ctrl/modeling_tf_ctrl.py#L749",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/ctrl#transformers.CTRLConfig"
>CTRLConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Je=new he({props:{$$slots:{default:[$s]},$$scope:{ctx:w}}}),ze=new pe({props:{anchor:"transformers.TFCTRLForSequenceClassification.call.example",$$slots:{default:[Ls]},$$scope:{ctx:w}}}),Ie=new pe({props:{anchor:"transformers.TFCTRLForSequenceClassification.call.example-2",$$slots:{default:[js]},$$scope:{ctx:w}}}),{c(){t=p("meta"),h=r(),o=p("p"),a=r(),_(k.$$.fragment),n=r(),g=p("div"),g.innerHTML=se,F=r(),_($.$$.fragment),E=r(),j=p("p"),j.innerHTML=L,P=r(),u=p("p"),u.textContent=C,Vt=r(),Ue=p("p"),Ue.innerHTML=To,Xt=r(),We=p("p"),We.textContent=bo,Gt=r(),Ne=p("ul"),Ne.innerHTML=yo,Et=r(),qe=p("p"),qe.innerHTML=Mo,Pt=r(),_(He.$$.fragment),Yt=r(),Ze=p("ul"),Ze.innerHTML=vo,Qt=r(),_(Be.$$.fragment),Ot=r(),Y=p("div"),_(Se.$$.fragment),hn=r(),ct=p("p"),ct.innerHTML=ko,fn=r(),pt=p("p"),pt.innerHTML=wo,gn=r(),_(fe.$$.fragment),Dt=r(),_(Ve.$$.fragment),At=r(),Q=p("div"),_(Xe.$$.fragment),_n=r(),mt=p("p"),mt.textContent=Co,Tn=r(),ut=p("p"),ut.innerHTML=$o,bn=r(),ht=p("div"),_(Ge.$$.fragment),Kt=r(),_(Ee.$$.fragment),en=r(),H=p("div"),_(Pe.$$.fragment),yn=r(),ft=p("p"),ft.textContent=Lo,Mn=r(),gt=p("p"),gt.innerHTML=jo,vn=r(),_t=p("p"),_t.innerHTML=Ro,kn=r(),ee=p("div"),_(Ye.$$.fragment),wn=r(),Tt=p("p"),Tt.innerHTML=xo,Cn=r(),_(ge.$$.fragment),$n=r(),_(_e.$$.fragment),tn=r(),_(Qe.$$.fragment),nn=r(),Z=p("div"),_(Oe.$$.fragment),Ln=r(),bt=p("p"),bt.textContent=Fo,jn=r(),yt=p("p"),yt.innerHTML=Jo,Rn=r(),Mt=p("p"),Mt.innerHTML=zo,xn=r(),te=p("div"),_(De.$$.fragment),Fn=r(),vt=p("p"),vt.innerHTML=Io,Jn=r(),_(Te.$$.fragment),zn=r(),_(be.$$.fragment),on=r(),_(Ae.$$.fragment),sn=r(),B=p("div"),_(Ke.$$.fragment),In=r(),kt=p("p"),kt.innerHTML=Uo,Un=r(),wt=p("p"),wt.innerHTML=Wo,Wn=r(),Ct=p("p"),Ct.innerHTML=No,Nn=r(),z=p("div"),_(et.$$.fragment),qn=r(),$t=p("p"),$t.innerHTML=qo,Hn=r(),_(ye.$$.fragment),Zn=r(),_(Me.$$.fragment),Bn=r(),_(ve.$$.fragment),Sn=r(),_(ke.$$.fragment),Vn=r(),_(we.$$.fragment),an=r(),_(tt.$$.fragment),rn=r(),U=p("div"),_(nt.$$.fragment),Xn=r(),Lt=p("p"),Lt.textContent=Ho,Gn=r(),jt=p("p"),jt.innerHTML=Zo,En=r(),Rt=p("p"),Rt.innerHTML=Bo,Pn=r(),_(Ce.$$.fragment),Yn=r(),ne=p("div"),_(ot.$$.fragment),Qn=r(),xt=p("p"),xt.innerHTML=So,On=r(),_($e.$$.fragment),Dn=r(),_(Le.$$.fragment),ln=r(),_(st.$$.fragment),dn=r(),W=p("div"),_(at.$$.fragment),An=r(),Ft=p("p"),Ft.textContent=Vo,Kn=r(),Jt=p("p"),Jt.innerHTML=Xo,eo=r(),zt=p("p"),zt.innerHTML=Go,to=r(),_(je.$$.fragment),no=r(),oe=p("div"),_(rt.$$.fragment),oo=r(),It=p("p"),It.innerHTML=Eo,so=r(),_(Re.$$.fragment),ao=r(),_(xe.$$.fragment),cn=r(),_(lt.$$.fragment),pn=r(),R=p("div"),_(it.$$.fragment),ro=r(),Ut=p("p"),Ut.textContent=Po,lo=r(),Wt=p("p"),Wt.innerHTML=Yo,io=r(),Nt=p("p"),Nt.innerHTML=Qo,co=r(),qt=p("p"),qt.innerHTML=Oo,po=r(),Ht=p("p"),Ht.innerHTML=Do,mo=r(),_(Fe.$$.fragment),uo=r(),G=p("div"),_(dt.$$.fragment),ho=r(),Zt=p("p"),Zt.innerHTML=Ao,fo=r(),_(Je.$$.fragment),go=r(),_(ze.$$.fragment),_o=r(),_(Ie.$$.fragment),mn=r(),Bt=p("p"),this.h()},l(e){const i=is("svelte-u9bgzb",document.head);t=m(i,"META",{name:!0,content:!0}),i.forEach(s),h=l(e),o=m(e,"P",{}),q(o).forEach(s),a=l(e),T(k.$$.fragment,e),n=l(e),g=m(e,"DIV",{class:!0,"data-svelte-h":!0}),f(g)!=="svelte-1jjt97v"&&(g.innerHTML=se),F=l(e),T($.$$.fragment,e),E=l(e),j=m(e,"P",{"data-svelte-h":!0}),f(j)!=="svelte-z0k74f"&&(j.innerHTML=L),P=l(e),u=m(e,"P",{"data-svelte-h":!0}),f(u)!=="svelte-vfdo9a"&&(u.textContent=C),Vt=l(e),Ue=m(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-f7zzo4"&&(Ue.innerHTML=To),Xt=l(e),We=m(e,"P",{"data-svelte-h":!0}),f(We)!=="svelte-axv494"&&(We.textContent=bo),Gt=l(e),Ne=m(e,"UL",{"data-svelte-h":!0}),f(Ne)!=="svelte-yfbkp1"&&(Ne.innerHTML=yo),Et=l(e),qe=m(e,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-3n853r"&&(qe.innerHTML=Mo),Pt=l(e),T(He.$$.fragment,e),Yt=l(e),Ze=m(e,"UL",{"data-svelte-h":!0}),f(Ze)!=="svelte-17u5l9r"&&(Ze.innerHTML=vo),Qt=l(e),T(Be.$$.fragment,e),Ot=l(e),Y=m(e,"DIV",{class:!0});var ae=q(Y);T(Se.$$.fragment,ae),hn=l(ae),ct=m(ae,"P",{"data-svelte-h":!0}),f(ct)!=="svelte-2la8j2"&&(ct.innerHTML=ko),fn=l(ae),pt=m(ae,"P",{"data-svelte-h":!0}),f(pt)!=="svelte-1g275hz"&&(pt.innerHTML=wo),gn=l(ae),T(fe.$$.fragment,ae),ae.forEach(s),Dt=l(e),T(Ve.$$.fragment,e),At=l(e),Q=m(e,"DIV",{class:!0});var re=q(Q);T(Xe.$$.fragment,re),_n=l(re),mt=m(re,"P",{"data-svelte-h":!0}),f(mt)!=="svelte-1ry85wb"&&(mt.textContent=Co),Tn=l(re),ut=m(re,"P",{"data-svelte-h":!0}),f(ut)!=="svelte-7nx0d1"&&(ut.innerHTML=$o),bn=l(re),ht=m(re,"DIV",{class:!0});var St=q(ht);T(Ge.$$.fragment,St),St.forEach(s),re.forEach(s),Kt=l(e),T(Ee.$$.fragment,e),en=l(e),H=m(e,"DIV",{class:!0});var O=q(H);T(Pe.$$.fragment,O),yn=l(O),ft=m(O,"P",{"data-svelte-h":!0}),f(ft)!=="svelte-418ah6"&&(ft.textContent=Lo),Mn=l(O),gt=m(O,"P",{"data-svelte-h":!0}),f(gt)!=="svelte-1ku9owf"&&(gt.innerHTML=jo),vn=l(O),_t=m(O,"P",{"data-svelte-h":!0}),f(_t)!=="svelte-hswkmf"&&(_t.innerHTML=Ro),kn=l(O),ee=m(O,"DIV",{class:!0});var le=q(ee);T(Ye.$$.fragment,le),wn=l(le),Tt=m(le,"P",{"data-svelte-h":!0}),f(Tt)!=="svelte-pyon11"&&(Tt.innerHTML=xo),Cn=l(le),T(ge.$$.fragment,le),$n=l(le),T(_e.$$.fragment,le),le.forEach(s),O.forEach(s),tn=l(e),T(Qe.$$.fragment,e),nn=l(e),Z=m(e,"DIV",{class:!0});var D=q(Z);T(Oe.$$.fragment,D),Ln=l(D),bt=m(D,"P",{"data-svelte-h":!0}),f(bt)!=="svelte-ej2g0g"&&(bt.textContent=Fo),jn=l(D),yt=m(D,"P",{"data-svelte-h":!0}),f(yt)!=="svelte-1ku9owf"&&(yt.innerHTML=Jo),Rn=l(D),Mt=m(D,"P",{"data-svelte-h":!0}),f(Mt)!=="svelte-hswkmf"&&(Mt.innerHTML=zo),xn=l(D),te=m(D,"DIV",{class:!0});var ie=q(te);T(De.$$.fragment,ie),Fn=l(ie),vt=m(ie,"P",{"data-svelte-h":!0}),f(vt)!=="svelte-1hgbhf5"&&(vt.innerHTML=Io),Jn=l(ie),T(Te.$$.fragment,ie),zn=l(ie),T(be.$$.fragment,ie),ie.forEach(s),D.forEach(s),on=l(e),T(Ae.$$.fragment,e),sn=l(e),B=m(e,"DIV",{class:!0});var A=q(B);T(Ke.$$.fragment,A),In=l(A),kt=m(A,"P",{"data-svelte-h":!0}),f(kt)!=="svelte-113vn3h"&&(kt.innerHTML=Uo),Un=l(A),wt=m(A,"P",{"data-svelte-h":!0}),f(wt)!=="svelte-1ku9owf"&&(wt.innerHTML=Wo),Wn=l(A),Ct=m(A,"P",{"data-svelte-h":!0}),f(Ct)!=="svelte-hswkmf"&&(Ct.innerHTML=No),Nn=l(A),z=m(A,"DIV",{class:!0});var N=q(z);T(et.$$.fragment,N),qn=l(N),$t=m(N,"P",{"data-svelte-h":!0}),f($t)!=="svelte-1uxhz7p"&&($t.innerHTML=qo),Hn=l(N),T(ye.$$.fragment,N),Zn=l(N),T(Me.$$.fragment,N),Bn=l(N),T(ve.$$.fragment,N),Sn=l(N),T(ke.$$.fragment,N),Vn=l(N),T(we.$$.fragment,N),N.forEach(s),A.forEach(s),an=l(e),T(tt.$$.fragment,e),rn=l(e),U=m(e,"DIV",{class:!0});var S=q(U);T(nt.$$.fragment,S),Xn=l(S),Lt=m(S,"P",{"data-svelte-h":!0}),f(Lt)!=="svelte-418ah6"&&(Lt.textContent=Ho),Gn=l(S),jt=m(S,"P",{"data-svelte-h":!0}),f(jt)!=="svelte-1kin23z"&&(jt.innerHTML=Zo),En=l(S),Rt=m(S,"P",{"data-svelte-h":!0}),f(Rt)!=="svelte-1ivrf8m"&&(Rt.innerHTML=Bo),Pn=l(S),T(Ce.$$.fragment,S),Yn=l(S),ne=m(S,"DIV",{class:!0});var de=q(ne);T(ot.$$.fragment,de),Qn=l(de),xt=m(de,"P",{"data-svelte-h":!0}),f(xt)!=="svelte-18vogy5"&&(xt.innerHTML=So),On=l(de),T($e.$$.fragment,de),Dn=l(de),T(Le.$$.fragment,de),de.forEach(s),S.forEach(s),ln=l(e),T(st.$$.fragment,e),dn=l(e),W=m(e,"DIV",{class:!0});var V=q(W);T(at.$$.fragment,V),An=l(V),Ft=m(V,"P",{"data-svelte-h":!0}),f(Ft)!=="svelte-ej2g0g"&&(Ft.textContent=Vo),Kn=l(V),Jt=m(V,"P",{"data-svelte-h":!0}),f(Jt)!=="svelte-1kin23z"&&(Jt.innerHTML=Xo),eo=l(V),zt=m(V,"P",{"data-svelte-h":!0}),f(zt)!=="svelte-1ivrf8m"&&(zt.innerHTML=Go),to=l(V),T(je.$$.fragment,V),no=l(V),oe=m(V,"DIV",{class:!0});var ce=q(oe);T(rt.$$.fragment,ce),oo=l(ce),It=m(ce,"P",{"data-svelte-h":!0}),f(It)!=="svelte-j4av9h"&&(It.innerHTML=Eo),so=l(ce),T(Re.$$.fragment,ce),ao=l(ce),T(xe.$$.fragment,ce),ce.forEach(s),V.forEach(s),cn=l(e),T(lt.$$.fragment,e),pn=l(e),R=m(e,"DIV",{class:!0});var J=q(R);T(it.$$.fragment,J),ro=l(J),Ut=m(J,"P",{"data-svelte-h":!0}),f(Ut)!=="svelte-1f84wtp"&&(Ut.textContent=Po),lo=l(J),Wt=m(J,"P",{"data-svelte-h":!0}),f(Wt)!=="svelte-107x8zp"&&(Wt.innerHTML=Yo),io=l(J),Nt=m(J,"P",{"data-svelte-h":!0}),f(Nt)!=="svelte-10ugs3m"&&(Nt.innerHTML=Qo),co=l(J),qt=m(J,"P",{"data-svelte-h":!0}),f(qt)!=="svelte-1kin23z"&&(qt.innerHTML=Oo),po=l(J),Ht=m(J,"P",{"data-svelte-h":!0}),f(Ht)!=="svelte-1ivrf8m"&&(Ht.innerHTML=Do),mo=l(J),T(Fe.$$.fragment,J),uo=l(J),G=m(J,"DIV",{class:!0});var K=q(G);T(dt.$$.fragment,K),ho=l(K),Zt=m(K,"P",{"data-svelte-h":!0}),f(Zt)!=="svelte-102wbdl"&&(Zt.innerHTML=Ao),fo=l(K),T(Je.$$.fragment,K),go=l(K),T(ze.$$.fragment,K),_o=l(K),T(Ie.$$.fragment,K),K.forEach(s),J.forEach(s),mn=l(e),Bt=m(e,"P",{}),q(Bt).forEach(s),this.h()},h(){I(t,"name","hf:doc:metadata"),I(t,"content",xs),I(g,"class","flex flex-wrap space-x-1"),I(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){c(document.head,t),d(e,h,i),d(e,o,i),d(e,a,i),b(k,e,i),d(e,n,i),d(e,g,i),d(e,F,i),b($,e,i),d(e,E,i),d(e,j,i),d(e,P,i),d(e,u,i),d(e,Vt,i),d(e,Ue,i),d(e,Xt,i),d(e,We,i),d(e,Gt,i),d(e,Ne,i),d(e,Et,i),d(e,qe,i),d(e,Pt,i),b(He,e,i),d(e,Yt,i),d(e,Ze,i),d(e,Qt,i),b(Be,e,i),d(e,Ot,i),d(e,Y,i),b(Se,Y,null),c(Y,hn),c(Y,ct),c(Y,fn),c(Y,pt),c(Y,gn),b(fe,Y,null),d(e,Dt,i),b(Ve,e,i),d(e,At,i),d(e,Q,i),b(Xe,Q,null),c(Q,_n),c(Q,mt),c(Q,Tn),c(Q,ut),c(Q,bn),c(Q,ht),b(Ge,ht,null),d(e,Kt,i),b(Ee,e,i),d(e,en,i),d(e,H,i),b(Pe,H,null),c(H,yn),c(H,ft),c(H,Mn),c(H,gt),c(H,vn),c(H,_t),c(H,kn),c(H,ee),b(Ye,ee,null),c(ee,wn),c(ee,Tt),c(ee,Cn),b(ge,ee,null),c(ee,$n),b(_e,ee,null),d(e,tn,i),b(Qe,e,i),d(e,nn,i),d(e,Z,i),b(Oe,Z,null),c(Z,Ln),c(Z,bt),c(Z,jn),c(Z,yt),c(Z,Rn),c(Z,Mt),c(Z,xn),c(Z,te),b(De,te,null),c(te,Fn),c(te,vt),c(te,Jn),b(Te,te,null),c(te,zn),b(be,te,null),d(e,on,i),b(Ae,e,i),d(e,sn,i),d(e,B,i),b(Ke,B,null),c(B,In),c(B,kt),c(B,Un),c(B,wt),c(B,Wn),c(B,Ct),c(B,Nn),c(B,z),b(et,z,null),c(z,qn),c(z,$t),c(z,Hn),b(ye,z,null),c(z,Zn),b(Me,z,null),c(z,Bn),b(ve,z,null),c(z,Sn),b(ke,z,null),c(z,Vn),b(we,z,null),d(e,an,i),b(tt,e,i),d(e,rn,i),d(e,U,i),b(nt,U,null),c(U,Xn),c(U,Lt),c(U,Gn),c(U,jt),c(U,En),c(U,Rt),c(U,Pn),b(Ce,U,null),c(U,Yn),c(U,ne),b(ot,ne,null),c(ne,Qn),c(ne,xt),c(ne,On),b($e,ne,null),c(ne,Dn),b(Le,ne,null),d(e,ln,i),b(st,e,i),d(e,dn,i),d(e,W,i),b(at,W,null),c(W,An),c(W,Ft),c(W,Kn),c(W,Jt),c(W,eo),c(W,zt),c(W,to),b(je,W,null),c(W,no),c(W,oe),b(rt,oe,null),c(oe,oo),c(oe,It),c(oe,so),b(Re,oe,null),c(oe,ao),b(xe,oe,null),d(e,cn,i),b(lt,e,i),d(e,pn,i),d(e,R,i),b(it,R,null),c(R,ro),c(R,Ut),c(R,lo),c(R,Wt),c(R,io),c(R,Nt),c(R,co),c(R,qt),c(R,po),c(R,Ht),c(R,mo),b(Fe,R,null),c(R,uo),c(R,G),b(dt,G,null),c(G,ho),c(G,Zt),c(G,fo),b(Je,G,null),c(G,go),b(ze,G,null),c(G,_o),b(Ie,G,null),d(e,mn,i),d(e,Bt,i),un=!0},p(e,[i]){const ae={};i&2&&(ae.$$scope={dirty:i,ctx:e}),fe.$set(ae);const re={};i&2&&(re.$$scope={dirty:i,ctx:e}),ge.$set(re);const St={};i&2&&(St.$$scope={dirty:i,ctx:e}),_e.$set(St);const O={};i&2&&(O.$$scope={dirty:i,ctx:e}),Te.$set(O);const le={};i&2&&(le.$$scope={dirty:i,ctx:e}),be.$set(le);const D={};i&2&&(D.$$scope={dirty:i,ctx:e}),ye.$set(D);const ie={};i&2&&(ie.$$scope={dirty:i,ctx:e}),Me.$set(ie);const A={};i&2&&(A.$$scope={dirty:i,ctx:e}),ve.$set(A);const N={};i&2&&(N.$$scope={dirty:i,ctx:e}),ke.$set(N);const S={};i&2&&(S.$$scope={dirty:i,ctx:e}),we.$set(S);const de={};i&2&&(de.$$scope={dirty:i,ctx:e}),Ce.$set(de);const V={};i&2&&(V.$$scope={dirty:i,ctx:e}),$e.$set(V);const ce={};i&2&&(ce.$$scope={dirty:i,ctx:e}),Le.$set(ce);const J={};i&2&&(J.$$scope={dirty:i,ctx:e}),je.$set(J);const K={};i&2&&(K.$$scope={dirty:i,ctx:e}),Re.$set(K);const Ko={};i&2&&(Ko.$$scope={dirty:i,ctx:e}),xe.$set(Ko);const es={};i&2&&(es.$$scope={dirty:i,ctx:e}),Fe.$set(es);const ts={};i&2&&(ts.$$scope={dirty:i,ctx:e}),Je.$set(ts);const ns={};i&2&&(ns.$$scope={dirty:i,ctx:e}),ze.$set(ns);const os={};i&2&&(os.$$scope={dirty:i,ctx:e}),Ie.$set(os)},i(e){un||(y(k.$$.fragment,e),y($.$$.fragment,e),y(He.$$.fragment,e),y(Be.$$.fragment,e),y(Se.$$.fragment,e),y(fe.$$.fragment,e),y(Ve.$$.fragment,e),y(Xe.$$.fragment,e),y(Ge.$$.fragment,e),y(Ee.$$.fragment,e),y(Pe.$$.fragment,e),y(Ye.$$.fragment,e),y(ge.$$.fragment,e),y(_e.$$.fragment,e),y(Qe.$$.fragment,e),y(Oe.$$.fragment,e),y(De.$$.fragment,e),y(Te.$$.fragment,e),y(be.$$.fragment,e),y(Ae.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),y(ye.$$.fragment,e),y(Me.$$.fragment,e),y(ve.$$.fragment,e),y(ke.$$.fragment,e),y(we.$$.fragment,e),y(tt.$$.fragment,e),y(nt.$$.fragment,e),y(Ce.$$.fragment,e),y(ot.$$.fragment,e),y($e.$$.fragment,e),y(Le.$$.fragment,e),y(st.$$.fragment,e),y(at.$$.fragment,e),y(je.$$.fragment,e),y(rt.$$.fragment,e),y(Re.$$.fragment,e),y(xe.$$.fragment,e),y(lt.$$.fragment,e),y(it.$$.fragment,e),y(Fe.$$.fragment,e),y(dt.$$.fragment,e),y(Je.$$.fragment,e),y(ze.$$.fragment,e),y(Ie.$$.fragment,e),un=!0)},o(e){M(k.$$.fragment,e),M($.$$.fragment,e),M(He.$$.fragment,e),M(Be.$$.fragment,e),M(Se.$$.fragment,e),M(fe.$$.fragment,e),M(Ve.$$.fragment,e),M(Xe.$$.fragment,e),M(Ge.$$.fragment,e),M(Ee.$$.fragment,e),M(Pe.$$.fragment,e),M(Ye.$$.fragment,e),M(ge.$$.fragment,e),M(_e.$$.fragment,e),M(Qe.$$.fragment,e),M(Oe.$$.fragment,e),M(De.$$.fragment,e),M(Te.$$.fragment,e),M(be.$$.fragment,e),M(Ae.$$.fragment,e),M(Ke.$$.fragment,e),M(et.$$.fragment,e),M(ye.$$.fragment,e),M(Me.$$.fragment,e),M(ve.$$.fragment,e),M(ke.$$.fragment,e),M(we.$$.fragment,e),M(tt.$$.fragment,e),M(nt.$$.fragment,e),M(Ce.$$.fragment,e),M(ot.$$.fragment,e),M($e.$$.fragment,e),M(Le.$$.fragment,e),M(st.$$.fragment,e),M(at.$$.fragment,e),M(je.$$.fragment,e),M(rt.$$.fragment,e),M(Re.$$.fragment,e),M(xe.$$.fragment,e),M(lt.$$.fragment,e),M(it.$$.fragment,e),M(Fe.$$.fragment,e),M(dt.$$.fragment,e),M(Je.$$.fragment,e),M(ze.$$.fragment,e),M(Ie.$$.fragment,e),un=!1},d(e){e&&(s(h),s(o),s(a),s(n),s(g),s(F),s(E),s(j),s(P),s(u),s(Vt),s(Ue),s(Xt),s(We),s(Gt),s(Ne),s(Et),s(qe),s(Pt),s(Yt),s(Ze),s(Qt),s(Ot),s(Y),s(Dt),s(At),s(Q),s(Kt),s(en),s(H),s(tn),s(nn),s(Z),s(on),s(sn),s(B),s(an),s(rn),s(U),s(ln),s(dn),s(W),s(cn),s(pn),s(R),s(mn),s(Bt)),s(t),v(k,e),v($,e),v(He,e),v(Be,e),v(Se),v(fe),v(Ve,e),v(Xe),v(Ge),v(Ee,e),v(Pe),v(Ye),v(ge),v(_e),v(Qe,e),v(Oe),v(De),v(Te),v(be),v(Ae,e),v(Ke),v(et),v(ye),v(Me),v(ve),v(ke),v(we),v(tt,e),v(nt),v(Ce),v(ot),v($e),v(Le),v(st,e),v(at),v(je),v(rt),v(Re),v(xe),v(lt,e),v(it),v(Fe),v(dt),v(Je),v(ze),v(Ie)}}}const xs='{"title":"CTRL","local":"ctrl","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Documentation resources","local":"documentation-resources","sections":[],"depth":2},{"title":"CTRLConfig","local":"transformers.CTRLConfig","sections":[],"depth":2},{"title":"CTRLTokenizer","local":"transformers.CTRLTokenizer","sections":[],"depth":2},{"title":"CTRLModel","local":"transformers.CTRLModel","sections":[],"depth":2},{"title":"CTRLLMHeadModel","local":"transformers.CTRLLMHeadModel","sections":[],"depth":2},{"title":"CTRLForSequenceClassification","local":"transformers.CTRLForSequenceClassification","sections":[],"depth":2},{"title":"TFCTRLModel","local":"transformers.TFCTRLModel","sections":[],"depth":2},{"title":"TFCTRLLMHeadModel","local":"transformers.TFCTRLLMHeadModel","sections":[],"depth":2},{"title":"TFCTRLForSequenceClassification","local":"transformers.TFCTRLForSequenceClassification","sections":[],"depth":2}],"depth":1}';function Fs(w){return as(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends rs{constructor(t){super(),ls(this,t,Fs,Rs,ss,{})}}export{Hs as component};
