import{s as Pi,n as Qi,o as Ai}from"../chunks/scheduler.36a0863c.js";import{S as qi,i as Ki,g as a,s as o,r as d,A as Di,h as s,f as l,c as n,j as Si,u as p,x as r,k as Ni,y as Oi,a as i,v as m,d as c,t as u,w as M}from"../chunks/index.9c13489a.js";import{C as f}from"../chunks/CodeBlock.05d8ec32.js";import{H as b}from"../chunks/Heading.7a254a62.js";function eo(Xl){let T,tt,Oe,lt,v,it,y,ot,J,Vl=`Un paio di modifiche sono state introdotte nel passaggio dalla versione 3 alla versione 4. Di seguito è riportato un riepilogo delle
modifiche previste:`,nt,z,at,w,Rl="I tokenizer python e rust hanno all’incirca le stesse API, ma i tokenizer rust hanno un set di funzionalità più completo.",st,_,Fl="Ciò introduce due modifiche sostanziali:",rt,$,El="<li>La gestione dei token in overflow tra i tokenizer Python e Rust è diversa.</li> <li>I tokenizers di rust non accettano numeri interi nei metodi di codifica.</li>",dt,g,pt,U,Yl='<li>Le pipeline ora contengono funzionalità aggiuntive pronte all’uso. Vedi la <a href="main_classes/pipelines#transformers.TokenClassificationPipeline">pipeline di classificazione dei token con il flag <code>grouped_entities</code></a>.</li> <li>Gli auto-tokenizer ora restituiscono tokenizer rust. Per ottenere invece i tokenizer python, l’utente deve usare il flag <code>use_fast</code> impostandolo <code>False</code>:</li>',mt,h,Sl="Nella versione <code>v3.x</code>:",ct,j,ut,Z,Nl="per ottenere lo stesso nella versione <code>v4.x</code>:",Mt,k,bt,C,ft,x,Pl="Il requisito sulla dipendenza SentencePiece è stato rimosso da <code>setup.py</code>. È stato fatto per avere un canale su anaconda cloud senza basarsi su <code>conda-forge</code>. Ciò significa che i tokenizer che dipendono dalla libreria SentencePiece non saranno disponibili con un’installazione standard di <code>transformers</code>.",Tt,B,Ql="Ciò include le versioni <strong>lente</strong> di:",vt,I,Al="<li><code>XLNetTokenizer</code></li> <li><code>AlbertTokenizer</code></li> <li><code>CamembertTokenizer</code></li> <li><code>MBartTokenizer</code></li> <li><code>PegasusTokenizer</code></li> <li><code>T5Tokenizer</code></li> <li><code>ReformerTokenizer</code></li> <li><code>XLMRobertaTokenizer</code></li>",yt,W,Jt,H,ql="Per ottenere lo stesso comportamento della versione <code>v3.x</code>, devi installare anche <code>sentencepiece</code>:",zt,G,Kl="Nella versione <code>v3.x</code>:",wt,L,_t,X,Dl="per ottenere lo stesso nella versione <code>v4.x</code>:",$t,V,gt,R,Ol="o",Ut,F,ht,E,jt,Y,ei="Con l’aggiunta di nuovi modelli, il numero di file nella cartella <code>src/transformers</code> continua a crescere e diventa più difficile navigare e capire. Abbiamo fatto la scelta di inserire ogni modello e i file che lo accompagnano nelle proprie sottocartelle.",Zt,S,ti="Si tratta di una modifica sostanziale in quanto l’importazione di layer intermedi utilizzando direttamente il modulo di un modello deve essere eseguita tramite un percorso diverso.",kt,N,Ct,P,li="Per ottenere lo stesso comportamento della versione <code>v3.x</code>, devi aggiornare il percorso utilizzato per accedere ai layer.",xt,Q,ii="Nella versione <code>v3.x</code>:",Bt,A,It,q,oi="per ottenere lo stesso nella versione <code>v4.x</code>:",Wt,K,Ht,D,Gt,O,ni='L’<a href="main_classes/output">argomento <code>return_dict</code></a> abilita la restituzione di oggetti python dict-like contenenti gli output del modello, invece delle tuple standard. Questo oggetto è self-documented poiché le chiavi possono essere utilizzate per recuperare valori, comportandosi anche come una tupla e gli utenti possono recuperare oggetti per indexing o slicing.',Lt,ee,ai="Questa è una modifica sostanziale poiché la tupla non può essere decompressa: <code>value0, value1 = outputs</code> non funzionerà.",Xt,te,Vt,le,si="Per ottenere lo stesso comportamento della versione <code>v3.x</code>, specifica l’argomento <code>return_dict</code> come <code>False</code>, sia nella configurazione del modello che nel passaggio successivo.",Rt,ie,ri="Nella versione <code>v3.x</code>:",Ft,oe,Et,ne,di="per ottenere lo stesso nella versione <code>v4.x</code>:",Yt,ae,St,se,pi="o",Nt,re,Pt,de,Qt,pe,mi='Gli attributi sono stati rimossi se deprecati da almeno un mese. L’elenco completo degli attributi obsoleti è disponibile in <a href="https://github.com/huggingface/transformers/pull/8604" rel="nofollow">#8604</a>.',At,me,ci="Ecco un elenco di questi attributi/metodi/argomenti e quali dovrebbero essere le loro sostituzioni:",qt,ce,ui="In diversi modelli, le etichette diventano coerenti con gli altri modelli:",Kt,ue,Mi="<li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>AlbertForMaskedLM</code> e <code>AlbertForPreTraining</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>BertForMaskedLM</code> e <code>BertForPreTraining</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>DistilBertForMaskedLM</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>ElectraForMaskedLM</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>LongformerForMaskedLM</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>MobileBertForMaskedLM</code>.</li> <li><code>masked_lm_labels</code> diventa <code>labels</code> in <code>RobertaForMaskedLM</code>.</li> <li><code>lm_labels</code> diventa <code>labels</code> in <code>BartForConditionalGeneration</code>.</li> <li><code>lm_labels</code> diventa <code>labels</code> in <code>GPT2DoubleHeadsModel</code>.</li> <li><code>lm_labels</code> diventa <code>labels</code> in <code>OpenAIGPTDoubleHeadsModel</code>.</li> <li><code>lm_labels</code> diventa <code>labels</code> in <code>T5ForConditionalGeneration</code>.</li>",Dt,Me,bi="In diversi modelli, il meccanismo di memorizzazione nella cache diventa coerente con gli altri:",Ot,be,fi="<li><code>decoder_cached_states</code> diventa <code>past_key_values</code> in tutti i modelli BART-like, FSMT e T5.</li> <li><code>decoder_past_key_values</code> diventa <code>past_key_values</code> in tutti i modelli BART-like, FSMT e T5.</li> <li><code>past</code> diventa <code>past_key_values</code> in tutti i modelli CTRL.</li> <li><code>past</code> diventa <code>past_key_values</code> in tutti i modelli GPT-2.</li>",el,fe,Ti="Per quanto riguarda le classi tokenizer:",tl,Te,vi="<li>L’attributo tokenizer <code>max_len</code> diventa <code>model_max_length</code>.</li> <li>L’attributo tokenizer <code>return_lengths</code> diventa <code>return_length</code>.</li> <li>L’argomento di codifica del tokenizer <code>is_pretokenized</code> diventa <code>is_split_into_words</code>.</li>",ll,ve,yi="Per quanto riguarda la classe <code>Trainer</code>:",il,ye,Ji="<li>L’argomento <code>tb_writer</code> di <code>Trainer</code> è stato rimosso in favore della funzione richiamabile <code>TensorBoardCallback(tb_writer=...)</code>.</li> <li>L’argomento <code>prediction_loss_only</code> di <code>Trainer</code> è stato rimosso in favore dell’argomento di classe <code>args.prediction_loss_only</code>.</li> <li>L’attributo <code>data_collator</code> di <code>Trainer</code> sarà richiamabile.</li> <li>Il metodo <code>_log</code> di <code>Trainer</code> è deprecato a favore di <code>log</code>.</li> <li>Il metodo <code>_training_step</code> di <code>Trainer</code> è deprecato a favore di <code>training_step</code>.</li> <li>Il metodo <code>_prediction_loop</code> di <code>Trainer</code> è deprecato a favore di <code>prediction_loop</code>.</li> <li>Il metodo <code>is_local_master</code> di <code>Trainer</code> è deprecato a favore di <code>is_local_process_zero</code>.</li> <li>Il metodo <code>is_world_master</code> di <code>Trainer</code> è deprecato a favore di <code>is_world_process_zero</code>.</li>",ol,Je,zi="Per quanto riguarda la classe <code>TrainingArguments</code>:",nl,ze,wi="<li>L’argomento <code>evaluate_during_training</code> di <code>TrainingArguments</code> è deprecato a favore di <code>evaluation_strategy</code>.</li>",al,we,_i="Per quanto riguarda il modello Transfo-XL:",sl,_e,$i="<li>L’attributo di configurazione <code>tie_weight</code> di Transfo-XL diventa <code>tie_words_embeddings</code>.</li> <li>Il metodo di modellazione <code>reset_length</code> di Transfo-XL diventa <code>reset_memory_length</code>.</li>",rl,$e,gi="Per quanto riguarda le pipeline:",dl,ge,Ui="<li>L’argomento <code>topk</code> di <code>FillMaskPipeline</code> diventa <code>top_k</code>.</li>",pl,Ue,ml,he,hi="Ecco un breve riepilogo di ciò a cui prestare attenzione durante il passaggio da <code>pytorch-transformers</code> a 🤗 Transformers.",cl,je,ul,Ze,ji="Per usare Torchscript (vedi #1010, #1204 e #1195) l’ordine specifico delle <strong>parole chiave di input</strong> di alcuni modelli (<code>attention_mask</code>, <code>token_type_ids</code>…) è stato modificato.",Ml,ke,Zi="Se inizializzavi i modelli usando parole chiave per gli argomenti, ad esempio <code>model(inputs_ids, attention_mask=attention_mask, token_type_ids=token_type_ids)</code>, questo non dovrebbe causare alcun cambiamento.",bl,Ce,ki="Se inizializzavi i modelli con input posizionali per gli argomenti, ad esempio <code>model(inputs_ids, attention_mask, token_type_ids)</code>, potrebbe essere necessario ricontrollare l’ordine esatto degli argomenti di input.",fl,xe,Tl,Be,Ci="Ecco un breve riepilogo di ciò a cui prestare attenzione durante la migrazione da <code>pytorch-pretrained-bert</code> a 🤗 Transformers",vl,Ie,yl,We,xi="La principale modifica di rilievo durante la migrazione da <code>pytorch-pretrained-bert</code> a 🤗 Transformers è che il metodo dei modelli di previsione dà sempre una <code>tupla</code> con vari elementi a seconda del modello e dei parametri di configurazione.",Jl,He,Bi='Il contenuto esatto delle tuple per ciascun modello è mostrato in dettaglio nelle docstring dei modelli e nella <a href="https://huggingface.co/transformers/" rel="nofollow">documentazione</a>.',zl,Ge,Ii="In quasi tutti i casi, andrà bene prendendo il primo elemento dell’output come quello che avresti precedentemente utilizzato in <code>pytorch-pretrained-bert</code>.",wl,Le,Wi=`Ecco un esempio di conversione da <code>pytorch-pretrained-bert</code>
a 🤗 Transformers per un modello di classificazione <code>BertForSequenceClassification</code>:`,_l,Xe,$l,Ve,gl,Re,Hi="Modifica sostanziale nel metodo <code>from_pretrained()</code>:",Ul,Fe,Gi="<li><p>I modelli sono ora impostati in modalità di valutazione in maniera predefinita quando usi il metodo <code>from_pretrained()</code>. Per addestrarli non dimenticare di riportarli in modalità di addestramento (<code>model.train()</code>) per attivare i moduli di dropout.</p></li> <li><p>Gli argomenti aggiuntivi <code>*inputs</code> e <code>**kwargs</code> forniti al metodo <code>from_pretrained()</code> venivano passati direttamente al metodo <code>__init__()</code> della classe sottostante del modello. Ora sono usati per aggiornare prima l’attributo di configurazione del modello, che può non funzionare con le classi del modello derivate costruite basandosi sui precedenti esempi di <code>BertForSequenceClassification</code>. Più precisamente, gli argomenti posizionali <code>*inputs</code> forniti a <code>from_pretrained()</code> vengono inoltrati direttamente al metodo <code>__init__()</code>  del modello mentre gli argomenti keyword <code>**kwargs</code> (i) che corrispondono agli attributi della classe di configurazione, vengono utilizzati per aggiornare tali attributi (ii) che non corrispondono ad alcun attributo della classe di configurazione, vengono inoltrati al metodo <code>__init__()</code>.</p></li>",hl,Ee,Li="Inoltre, sebbene non si tratti di una modifica sostanziale, i metodi di serializzazione sono stati standardizzati e probabilmente dovresti passare al nuovo metodo <code>save_pretrained(save_directory)</code> se prima usavi qualsiasi altro metodo di serializzazione.",jl,Ye,Xi="Ecco un esempio:",Zl,Se,kl,Ne,Cl,Pe,Vi="I due ottimizzatori precedenti inclusi, <code>BertAdam</code> e <code>OpenAIAdam</code>, sono stati sostituiti da un singolo <code>AdamW</code> che presenta alcune differenze:",xl,Qe,Ri="<li>implementa solo la correzione del weights decay,</li> <li>lo scheduling ora è esterno (vedi sotto),</li> <li>anche il gradient clipping ora è esterno (vedi sotto).</li>",Bl,Ae,Fi="Il nuovo ottimizzatore <code>AdamW</code> corrisponde alle API di <code>Adam</code> di PyTorch e ti consente di utilizzare metodi PyTorch o apex per lo scheduling e il clipping.",Il,qe,Ei='Lo scheduling è ora standard <a href="https://pytorch.org/docs/stable/optim.html#how-to-adjust-learning-rate" rel="nofollow">PyTorch learning rate schedulers</a> e non fanno più parte dell’ottimizzatore.',Wl,Ke,Yi="Ecco un esempio di linear warmup e decay con <code>BertAdam</code> e con <code>AdamW</code>:",Hl,De,Gl,et,Ll;return v=new b({props:{title:"Migrazione da pacchetti precedenti",local:"migrazione-da-pacchetti-precedenti",headingTag:"h1"}}),y=new b({props:{title:"Migrazione da transformers v3.x a v4.x",local:"migrazione-da-transformers-v3x-a-v4x",headingTag:"h2"}}),z=new b({props:{title:"1. AutoTokenizer e pipeline ora utilizzano tokenizer veloci (rust) per impostazione predefinita.",local:"1-autotokenizer-e-pipeline-ora-utilizzano-tokenizer-veloci-rust-per-impostazione-predefinita",headingTag:"h4"}}),g=new b({props:{title:"Come ottenere lo stesso comportamento di v3.x in v4.x",local:"come-ottenere-lo-stesso-comportamento-di-v3x-in-v4x",headingTag:"h5"}}),j=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)`,wrap:!1}}),k=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIlMkMlMjB1c2VfZmFzdCUzREZhbHNlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, use_fast=<span class="hljs-literal">False</span>)`,wrap:!1}}),C=new b({props:{title:"2. SentencePiece è stato rimosso dalle dipendenze richieste",local:"2-sentencepiece-è-stato-rimosso-dalle-dipendenze-richieste",headingTag:"h4"}}),W=new b({props:{title:"Come ottenere lo stesso comportamento della v3.x nella v4.x",local:"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x",headingTag:"h5"}}),L=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install transformers",wrap:!1}}),V=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyU1QnNlbnRlbmNlcGllY2UlNUQ=",highlighted:"pip install transformers[sentencepiece]",wrap:!1}}),F=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMHN0ZW50ZW5jZXBpZWNl",highlighted:"pip install transformers stentencepiece",wrap:!1}}),E=new b({props:{title:"3. L’architettura delle repo è stato aggiornata in modo che ogni modello abbia la propria cartella",local:"3-larchitettura-delle-repo-è-stato-aggiornata-in-modo-che-ogni-modello-abbia-la-propria-cartella",headingTag:"h4"}}),N=new b({props:{title:"Come ottenere lo stesso comportamento della v3.x nella v4.x",local:"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x",headingTag:"h5"}}),A=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbGluZ19iZXJ0JTIwaW1wb3J0JTIwQmVydExheWVy",highlighted:"from transformers.modeling_bert import BertLayer",wrap:!1}}),K=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMuYmVydC5tb2RlbGluZ19iZXJ0JTIwaW1wb3J0JTIwQmVydExheWVy",highlighted:"from transformers.models.bert.modeling_bert import BertLayer",wrap:!1}}),D=new b({props:{title:"4. Impostare l’argomento return_dict su True per impostazione predefinita",local:"4-impostare-largomento-returndict-su-true-per-impostazione-predefinita",headingTag:"h4"}}),te=new b({props:{title:"Come ottenere lo stesso comportamento della v3.x nella v4.x",local:"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x",headingTag:"h5"}}),oe=new f({props:{code:"bW9kZWwlMjAlM0QlMjBCZXJ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMp",highlighted:`model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
outputs = model(**inputs)`,wrap:!1}}),ae=new f({props:{code:"bW9kZWwlMjAlM0QlMjBCZXJ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlKQ==",highlighted:`model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
outputs = model(**inputs, return_dict=False)`,wrap:!1}}),re=new f({props:{code:"bW9kZWwlMjAlM0QlMjBCZXJ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMHJldHVybl9kaWN0JTNERmFsc2UpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKQ==",highlighted:`model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, return_dict=False)
outputs = model(**inputs)`,wrap:!1}}),de=new b({props:{title:"5. Rimozione di alcuni attributi deprecati",local:"5-rimozione-di-alcuni-attributi-deprecati",headingTag:"h4"}}),Ue=new b({props:{title:"Passaggio da pytorch-transformers a 🤗 Transformers",local:"passaggio-da-pytorch-transformers-a--transformers",headingTag:"h2"}}),je=new b({props:{title:"L’ordine posizionale di alcune parole chiave di input dei modelli ( attention_mask , token_type_ids …) è cambiato",local:"lordine-posizionale-di-alcune-parole-chiave-di-input-dei-modelli--attentionmask--tokentypeids--è-cambiato",headingTag:"h3"}}),xe=new b({props:{title:"Migrazione da pytorch-pretrained-bert",local:"migrazione-da-pytorch-pretrained-bert",headingTag:"h2"}}),Ie=new b({props:{title:"I modelli restituiscono sempre tuple",local:"i-modelli-restituiscono-sempre-tuple",headingTag:"h3"}}),Xe=new f({props:{code:"JTIzJTIwQ2FyaWNoaWFtbyUyMGlsJTIwbm9zdHJvJTIwbW9kZWxsbyUwQW1vZGVsJTIwJTNEJTIwQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUwQSUyMyUyMFNlJTIwdXNhdmklMjBxdWVzdGElMjByaWdhJTIwaW4lMjBweXRvcmNoLXByZXRyYWluZWQtYmVydCUyMCUzQSUwQWxvc3MlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBJTBBJTIzJTIwT3JhJTIwdXNhJTIwcXVlc3RhJTIwcmlnYSUyMGluJTIwJUYwJTlGJUE0JTk3JTIwVHJhbnNmb3JtZXJzJTIwcGVyJTIwZXN0cmFycmUlMjBsYSUyMHBlcmRpdGElMjBkYWxsYSUyMHR1cGxhJTIwZGklMjBvdXRwdXQlM0ElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzJTVCMCU1RCUwQSUwQSUyMyUyMEluJTIwJUYwJTlGJUE0JTk3JTIwVHJhbnNmb3JtZXJzJTIwcHVvaSUyMGFuY2hlJTIwYXZlcmUlMjBhY2Nlc3NvJTIwYWklMjBsb2dpdCUzQSUwQWxvc3MlMkMlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzJTVCJTNBMiU1RCUwQSUwQSUyMyUyMEVkJTIwYW5jaGUlMjBhZ2xpJTIwYXR0ZW50aW9uJTIwd2VpZ2h0JTIwc2UlMjBjb25maWd1cmklMjBpbCUyMG1vZGVsbG8lMjBwZXIlMjByZXN0aXR1aXJsaSUyMChlJTIwYW5jaGUlMjBhbHRyaSUyMG91dHB1dCUyQyUyMHZlZGklMjBsZSUyMGRvY3N0cmluZyUyMGUlMjBsYSUyMGRvY3VtZW50YXppb25lKSUwQW1vZGVsJTIwJTNEJTIwQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMiUyMGJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBbG9zcyUyQyUyMGxvZ2l0cyUyQyUyMGF0dGVudGlvbnMlMjAlM0QlMjBvdXRwdXRz",highlighted:`<span class="hljs-comment"># Carichiamo il nostro modello</span>
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

<span class="hljs-comment"># Se usavi questa riga in pytorch-pretrained-bert :</span>
loss = model(input_ids, labels=labels)

<span class="hljs-comment"># Ora usa questa riga in 🤗 Transformers per estrarre la perdita dalla tupla di output:</span>
outputs = model(input_ids, labels=labels)
loss = outputs[<span class="hljs-number">0</span>]

<span class="hljs-comment"># In 🤗 Transformers puoi anche avere accesso ai logit:</span>
loss, logits = outputs[:<span class="hljs-number">2</span>]

<span class="hljs-comment"># Ed anche agli attention weight se configuri il modello per restituirli (e anche altri output, vedi le docstring e la documentazione)</span>
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot; bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
outputs = model(input_ids, labels=labels)
loss, logits, attentions = outputs`,wrap:!1}}),Ve=new b({props:{title:"Serializzazione",local:"serializzazione",headingTag:"h3"}}),Se=new f({props:{code:"JTIzJTIzJTIzJTIwQ2FyaWNoaWFtbyUyMHVuJTIwbW9kZWxsbyUyMGUlMjB1biUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQmVydEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEJlcnRUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUwQSUyMyUyMyUyMyUyMEZhY2NpYW1vJTIwZmFyZSUyMGFsY3VuZSUyMGNvc2UlMjBhbCUyMG5vc3RybyUyMG1vZGVsbG8lMjBlJTIwdG9rZW5pemVyJTBBJTIzJTIwRXMlM0ElMjBhZ2dpdW5naWFtbyUyMG51b3ZpJTIwdG9rZW4lMjBhbCUyMHZvY2Fib2xhcmlvJTIwZSUyMGFnbGklMjBlbWJlbmRpbmclMjBkZWwlMjBub3N0cm8lMjBtb2RlbGxvJTBBdG9rZW5pemVyLmFkZF90b2tlbnMoJTVCJTIyJTVCU1BFQ0lBTF9UT0tFTl8xJTVEJTIyJTJDJTIwJTIyJTVCU1BFQ0lBTF9UT0tFTl8yJTVEJTIyJTVEKSUwQW1vZGVsLnJlc2l6ZV90b2tlbl9lbWJlZGRpbmdzKGxlbih0b2tlbml6ZXIpKSUwQSUyMyUyMEFsbGVuaWFtbyUyMGlsJTIwbm9zdHJvJTIwbW9kZWxsbyUwQXRyYWluKG1vZGVsKSUwQSUwQSUyMyUyMyUyMyUyME9yYSUyMHNhbHZpYW1vJTIwaWwlMjBub3N0cm8lMjBtb2RlbGxvJTIwZSUyMGlsJTIwdG9rZW5pemVyJTIwaW4lMjB1bmElMjBjYXJ0ZWxsYSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGbXlfc2F2ZWRfbW9kZWxfZGlyZWN0b3J5JTJGJTIyKSUwQXRva2VuaXplci5zYXZlX3ByZXRyYWluZWQoJTIyLiUyRm15X3NhdmVkX21vZGVsX2RpcmVjdG9yeSUyRiUyMiklMEElMEElMjMlMjMlMjMlMjBSaWNhcmljaGlhbW8lMjBpbCUyMG1vZGVsbG8lMjBlJTIwaWwlMjB0b2tlbml6ZXIlMEFtb2RlbCUyMCUzRCUyMEJlcnRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjIuJTJGbXlfc2F2ZWRfbW9kZWxfZGlyZWN0b3J5JTJGJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEJlcnRUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZteV9zYXZlZF9tb2RlbF9kaXJlY3RvcnklMkYlMjIp",highlighted:`<span class="hljs-comment">### Carichiamo un modello e un tokenizer</span>
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

<span class="hljs-comment">### Facciamo fare alcune cose al nostro modello e tokenizer</span>
<span class="hljs-comment"># Es: aggiungiamo nuovi token al vocabolario e agli embending del nostro modello</span>
tokenizer.add_tokens([<span class="hljs-string">&quot;[SPECIAL_TOKEN_1]&quot;</span>, <span class="hljs-string">&quot;[SPECIAL_TOKEN_2]&quot;</span>])
model.resize_token_embeddings(<span class="hljs-built_in">len</span>(tokenizer))
<span class="hljs-comment"># Alleniamo il nostro modello</span>
train(model)

<span class="hljs-comment">### Ora salviamo il nostro modello e il tokenizer in una cartella</span>
model.save_pretrained(<span class="hljs-string">&quot;./my_saved_model_directory/&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;./my_saved_model_directory/&quot;</span>)

<span class="hljs-comment">### Ricarichiamo il modello e il tokenizer</span>
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;./my_saved_model_directory/&quot;</span>)
tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;./my_saved_model_directory/&quot;</span>)`,wrap:!1}}),Ne=new b({props:{title:"Ottimizzatori: BertAdam e OpenAIAdam ora sono AdamW, lo scheduling è quello standard PyTorch",local:"ottimizzatori-bertadam-e-openaiadam-ora-sono-adamw-lo-scheduling-è-quello-standard-pytorch",headingTag:"h3"}}),De=new f({props:{code:"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",highlighted:`<span class="hljs-comment"># Parametri:</span>
lr = <span class="hljs-number">1e-3</span>
max_grad_norm = <span class="hljs-number">1.0</span>
num_training_steps = <span class="hljs-number">1000</span>
num_warmup_steps = <span class="hljs-number">100</span>
warmup_proportion = <span class="hljs-built_in">float</span>( num_warmup_steps) / <span class="hljs-built_in">float</span>(num_training_steps) <span class="hljs-comment"># 0.1</span>

<span class="hljs-comment">### In precedenza l&#x27;ottimizzatore BertAdam veniva istanziato in questo modo:</span>
optimizer = BertAdam(
   model.parameters(),
   lr=lr,
   schedule=<span class="hljs-string">&quot;warmup_linear&quot;</span>,
   warmup=warmup_proportion,
   num_training_steps=num_training_steps,
)
<span class="hljs-comment">### e usato in questo modo:</span>
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_data:
   loss = model(batch)
   loss.backward()
   optimizer.step()

<span class="hljs-comment">### In 🤗 Transformers, ottimizzatore e schedule sono divisi e usati in questo modo:</span>
optimizer = AdamW(
   model.parameters(), lr=lr, correct_bias=<span class="hljs-literal">False</span>
) <span class="hljs-comment"># Per riprodurre il comportamento specifico di BertAdam impostare correct_bias=False</span>
scheduler = get_linear_schedule_with_warmup(
   optimizer, num_warmup_steps=num_warmup_steps, num_training_steps=num_training_steps
) <span class="hljs-comment"># PyTorch scheduler</span>
<span class="hljs-comment">### e va usato così:</span>
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_data:
   loss = model(batch)
   loss.backward()
   torch.nn.utils.clip_grad_norm_(
   model.parameters(), max_grad_norm
   ) <span class="hljs-comment"># Gradient clipping non è più in AdamW (quindi puoi usare amp senza problemi)</span>
   optimizer.step()
   scheduler.step()`,wrap:!1}}),{c(){T=a("meta"),tt=o(),Oe=a("p"),lt=o(),d(v.$$.fragment),it=o(),d(y.$$.fragment),ot=o(),J=a("p"),J.textContent=Vl,nt=o(),d(z.$$.fragment),at=o(),w=a("p"),w.textContent=Rl,st=o(),_=a("p"),_.textContent=Fl,rt=o(),$=a("ul"),$.innerHTML=El,dt=o(),d(g.$$.fragment),pt=o(),U=a("ul"),U.innerHTML=Yl,mt=o(),h=a("p"),h.innerHTML=Sl,ct=o(),d(j.$$.fragment),ut=o(),Z=a("p"),Z.innerHTML=Nl,Mt=o(),d(k.$$.fragment),bt=o(),d(C.$$.fragment),ft=o(),x=a("p"),x.innerHTML=Pl,Tt=o(),B=a("p"),B.innerHTML=Ql,vt=o(),I=a("ul"),I.innerHTML=Al,yt=o(),d(W.$$.fragment),Jt=o(),H=a("p"),H.innerHTML=ql,zt=o(),G=a("p"),G.innerHTML=Kl,wt=o(),d(L.$$.fragment),_t=o(),X=a("p"),X.innerHTML=Dl,$t=o(),d(V.$$.fragment),gt=o(),R=a("p"),R.textContent=Ol,Ut=o(),d(F.$$.fragment),ht=o(),d(E.$$.fragment),jt=o(),Y=a("p"),Y.innerHTML=ei,Zt=o(),S=a("p"),S.textContent=ti,kt=o(),d(N.$$.fragment),Ct=o(),P=a("p"),P.innerHTML=li,xt=o(),Q=a("p"),Q.innerHTML=ii,Bt=o(),d(A.$$.fragment),It=o(),q=a("p"),q.innerHTML=oi,Wt=o(),d(K.$$.fragment),Ht=o(),d(D.$$.fragment),Gt=o(),O=a("p"),O.innerHTML=ni,Lt=o(),ee=a("p"),ee.innerHTML=ai,Xt=o(),d(te.$$.fragment),Vt=o(),le=a("p"),le.innerHTML=si,Rt=o(),ie=a("p"),ie.innerHTML=ri,Ft=o(),d(oe.$$.fragment),Et=o(),ne=a("p"),ne.innerHTML=di,Yt=o(),d(ae.$$.fragment),St=o(),se=a("p"),se.textContent=pi,Nt=o(),d(re.$$.fragment),Pt=o(),d(de.$$.fragment),Qt=o(),pe=a("p"),pe.innerHTML=mi,At=o(),me=a("p"),me.textContent=ci,qt=o(),ce=a("p"),ce.textContent=ui,Kt=o(),ue=a("ul"),ue.innerHTML=Mi,Dt=o(),Me=a("p"),Me.textContent=bi,Ot=o(),be=a("ul"),be.innerHTML=fi,el=o(),fe=a("p"),fe.textContent=Ti,tl=o(),Te=a("ul"),Te.innerHTML=vi,ll=o(),ve=a("p"),ve.innerHTML=yi,il=o(),ye=a("ul"),ye.innerHTML=Ji,ol=o(),Je=a("p"),Je.innerHTML=zi,nl=o(),ze=a("ul"),ze.innerHTML=wi,al=o(),we=a("p"),we.textContent=_i,sl=o(),_e=a("ul"),_e.innerHTML=$i,rl=o(),$e=a("p"),$e.textContent=gi,dl=o(),ge=a("ul"),ge.innerHTML=Ui,pl=o(),d(Ue.$$.fragment),ml=o(),he=a("p"),he.innerHTML=hi,cl=o(),d(je.$$.fragment),ul=o(),Ze=a("p"),Ze.innerHTML=ji,Ml=o(),ke=a("p"),ke.innerHTML=Zi,bl=o(),Ce=a("p"),Ce.innerHTML=ki,fl=o(),d(xe.$$.fragment),Tl=o(),Be=a("p"),Be.innerHTML=Ci,vl=o(),d(Ie.$$.fragment),yl=o(),We=a("p"),We.innerHTML=xi,Jl=o(),He=a("p"),He.innerHTML=Bi,zl=o(),Ge=a("p"),Ge.innerHTML=Ii,wl=o(),Le=a("p"),Le.innerHTML=Wi,_l=o(),d(Xe.$$.fragment),$l=o(),d(Ve.$$.fragment),gl=o(),Re=a("p"),Re.innerHTML=Hi,Ul=o(),Fe=a("ol"),Fe.innerHTML=Gi,hl=o(),Ee=a("p"),Ee.innerHTML=Li,jl=o(),Ye=a("p"),Ye.textContent=Xi,Zl=o(),d(Se.$$.fragment),kl=o(),d(Ne.$$.fragment),Cl=o(),Pe=a("p"),Pe.innerHTML=Vi,xl=o(),Qe=a("ul"),Qe.innerHTML=Ri,Bl=o(),Ae=a("p"),Ae.innerHTML=Fi,Il=o(),qe=a("p"),qe.innerHTML=Ei,Wl=o(),Ke=a("p"),Ke.innerHTML=Yi,Hl=o(),d(De.$$.fragment),Gl=o(),et=a("p"),this.h()},l(e){const t=Di("svelte-u9bgzb",document.head);T=s(t,"META",{name:!0,content:!0}),t.forEach(l),tt=n(e),Oe=s(e,"P",{}),Si(Oe).forEach(l),lt=n(e),p(v.$$.fragment,e),it=n(e),p(y.$$.fragment,e),ot=n(e),J=s(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-668hq5"&&(J.textContent=Vl),nt=n(e),p(z.$$.fragment,e),at=n(e),w=s(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-gf1el4"&&(w.textContent=Rl),st=n(e),_=s(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1m5uxey"&&(_.textContent=Fl),rt=n(e),$=s(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-57nl0c"&&($.innerHTML=El),dt=n(e),p(g.$$.fragment,e),pt=n(e),U=s(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-1jqlgbo"&&(U.innerHTML=Yl),mt=n(e),h=s(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-s7f1fx"&&(h.innerHTML=Sl),ct=n(e),p(j.$$.fragment,e),ut=n(e),Z=s(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1ggfn91"&&(Z.innerHTML=Nl),Mt=n(e),p(k.$$.fragment,e),bt=n(e),p(C.$$.fragment,e),ft=n(e),x=s(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1yqxt38"&&(x.innerHTML=Pl),Tt=n(e),B=s(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-7vgiw8"&&(B.innerHTML=Ql),vt=n(e),I=s(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-gqa7ea"&&(I.innerHTML=Al),yt=n(e),p(W.$$.fragment,e),Jt=n(e),H=s(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-e0qch8"&&(H.innerHTML=ql),zt=n(e),G=s(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-s7f1fx"&&(G.innerHTML=Kl),wt=n(e),p(L.$$.fragment,e),_t=n(e),X=s(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1ggfn91"&&(X.innerHTML=Dl),$t=n(e),p(V.$$.fragment,e),gt=n(e),R=s(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1cem39h"&&(R.textContent=Ol),Ut=n(e),p(F.$$.fragment,e),ht=n(e),p(E.$$.fragment,e),jt=n(e),Y=s(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1d9aumn"&&(Y.innerHTML=ei),Zt=n(e),S=s(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-z35xty"&&(S.textContent=ti),kt=n(e),p(N.$$.fragment,e),Ct=n(e),P=s(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1syye96"&&(P.innerHTML=li),xt=n(e),Q=s(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-s7f1fx"&&(Q.innerHTML=ii),Bt=n(e),p(A.$$.fragment,e),It=n(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1ggfn91"&&(q.innerHTML=oi),Wt=n(e),p(K.$$.fragment,e),Ht=n(e),p(D.$$.fragment,e),Gt=n(e),O=s(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-15fnb1f"&&(O.innerHTML=ni),Lt=n(e),ee=s(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-6z85oe"&&(ee.innerHTML=ai),Xt=n(e),p(te.$$.fragment,e),Vt=n(e),le=s(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1bl6pbd"&&(le.innerHTML=si),Rt=n(e),ie=s(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-s7f1fx"&&(ie.innerHTML=ri),Ft=n(e),p(oe.$$.fragment,e),Et=n(e),ne=s(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1ggfn91"&&(ne.innerHTML=di),Yt=n(e),p(ae.$$.fragment,e),St=n(e),se=s(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1cem39h"&&(se.textContent=pi),Nt=n(e),p(re.$$.fragment,e),Pt=n(e),p(de.$$.fragment,e),Qt=n(e),pe=s(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1jgy8li"&&(pe.innerHTML=mi),At=n(e),me=s(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1jjvwm4"&&(me.textContent=ci),qt=n(e),ce=s(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-ykanzw"&&(ce.textContent=ui),Kt=n(e),ue=s(e,"UL",{"data-svelte-h":!0}),r(ue)!=="svelte-19g3nxw"&&(ue.innerHTML=Mi),Dt=n(e),Me=s(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-ja413z"&&(Me.textContent=bi),Ot=n(e),be=s(e,"UL",{"data-svelte-h":!0}),r(be)!=="svelte-1wt3yrf"&&(be.innerHTML=fi),el=n(e),fe=s(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1hgabrv"&&(fe.textContent=Ti),tl=n(e),Te=s(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-31xrbn"&&(Te.innerHTML=vi),ll=n(e),ve=s(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-170kx12"&&(ve.innerHTML=yi),il=n(e),ye=s(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-1d9dzd2"&&(ye.innerHTML=Ji),ol=n(e),Je=s(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-uuss7p"&&(Je.innerHTML=zi),nl=n(e),ze=s(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-10nscti"&&(ze.innerHTML=wi),al=n(e),we=s(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-13a2h9b"&&(we.textContent=_i),sl=n(e),_e=s(e,"UL",{"data-svelte-h":!0}),r(_e)!=="svelte-g6j8ra"&&(_e.innerHTML=$i),rl=n(e),$e=s(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1k2o8s3"&&($e.textContent=gi),dl=n(e),ge=s(e,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-8otb07"&&(ge.innerHTML=Ui),pl=n(e),p(Ue.$$.fragment,e),ml=n(e),he=s(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-l36xrj"&&(he.innerHTML=hi),cl=n(e),p(je.$$.fragment,e),ul=n(e),Ze=s(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-seplpo"&&(Ze.innerHTML=ji),Ml=n(e),ke=s(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1ro2lsk"&&(ke.innerHTML=Zi),bl=n(e),Ce=s(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1plbv18"&&(Ce.innerHTML=ki),fl=n(e),p(xe.$$.fragment,e),Tl=n(e),Be=s(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-q2e62a"&&(Be.innerHTML=Ci),vl=n(e),p(Ie.$$.fragment,e),yl=n(e),We=s(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-4cf5r"&&(We.innerHTML=xi),Jl=n(e),He=s(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-bgxvfx"&&(He.innerHTML=Bi),zl=n(e),Ge=s(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1jfesn2"&&(Ge.innerHTML=Ii),wl=n(e),Le=s(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-83adx7"&&(Le.innerHTML=Wi),_l=n(e),p(Xe.$$.fragment,e),$l=n(e),p(Ve.$$.fragment,e),gl=n(e),Re=s(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1d5f1v"&&(Re.innerHTML=Hi),Ul=n(e),Fe=s(e,"OL",{"data-svelte-h":!0}),r(Fe)!=="svelte-5qzntw"&&(Fe.innerHTML=Gi),hl=n(e),Ee=s(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1pjusnp"&&(Ee.innerHTML=Li),jl=n(e),Ye=s(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1nimzcx"&&(Ye.textContent=Xi),Zl=n(e),p(Se.$$.fragment,e),kl=n(e),p(Ne.$$.fragment,e),Cl=n(e),Pe=s(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-2o9zch"&&(Pe.innerHTML=Vi),xl=n(e),Qe=s(e,"UL",{"data-svelte-h":!0}),r(Qe)!=="svelte-15b1x1u"&&(Qe.innerHTML=Ri),Bl=n(e),Ae=s(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-5iz2eq"&&(Ae.innerHTML=Fi),Il=n(e),qe=s(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-18bzze7"&&(qe.innerHTML=Ei),Wl=n(e),Ke=s(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-hz6tan"&&(Ke.innerHTML=Yi),Hl=n(e),p(De.$$.fragment,e),Gl=n(e),et=s(e,"P",{}),Si(et).forEach(l),this.h()},h(){Ni(T,"name","hf:doc:metadata"),Ni(T,"content",to)},m(e,t){Oi(document.head,T),i(e,tt,t),i(e,Oe,t),i(e,lt,t),m(v,e,t),i(e,it,t),m(y,e,t),i(e,ot,t),i(e,J,t),i(e,nt,t),m(z,e,t),i(e,at,t),i(e,w,t),i(e,st,t),i(e,_,t),i(e,rt,t),i(e,$,t),i(e,dt,t),m(g,e,t),i(e,pt,t),i(e,U,t),i(e,mt,t),i(e,h,t),i(e,ct,t),m(j,e,t),i(e,ut,t),i(e,Z,t),i(e,Mt,t),m(k,e,t),i(e,bt,t),m(C,e,t),i(e,ft,t),i(e,x,t),i(e,Tt,t),i(e,B,t),i(e,vt,t),i(e,I,t),i(e,yt,t),m(W,e,t),i(e,Jt,t),i(e,H,t),i(e,zt,t),i(e,G,t),i(e,wt,t),m(L,e,t),i(e,_t,t),i(e,X,t),i(e,$t,t),m(V,e,t),i(e,gt,t),i(e,R,t),i(e,Ut,t),m(F,e,t),i(e,ht,t),m(E,e,t),i(e,jt,t),i(e,Y,t),i(e,Zt,t),i(e,S,t),i(e,kt,t),m(N,e,t),i(e,Ct,t),i(e,P,t),i(e,xt,t),i(e,Q,t),i(e,Bt,t),m(A,e,t),i(e,It,t),i(e,q,t),i(e,Wt,t),m(K,e,t),i(e,Ht,t),m(D,e,t),i(e,Gt,t),i(e,O,t),i(e,Lt,t),i(e,ee,t),i(e,Xt,t),m(te,e,t),i(e,Vt,t),i(e,le,t),i(e,Rt,t),i(e,ie,t),i(e,Ft,t),m(oe,e,t),i(e,Et,t),i(e,ne,t),i(e,Yt,t),m(ae,e,t),i(e,St,t),i(e,se,t),i(e,Nt,t),m(re,e,t),i(e,Pt,t),m(de,e,t),i(e,Qt,t),i(e,pe,t),i(e,At,t),i(e,me,t),i(e,qt,t),i(e,ce,t),i(e,Kt,t),i(e,ue,t),i(e,Dt,t),i(e,Me,t),i(e,Ot,t),i(e,be,t),i(e,el,t),i(e,fe,t),i(e,tl,t),i(e,Te,t),i(e,ll,t),i(e,ve,t),i(e,il,t),i(e,ye,t),i(e,ol,t),i(e,Je,t),i(e,nl,t),i(e,ze,t),i(e,al,t),i(e,we,t),i(e,sl,t),i(e,_e,t),i(e,rl,t),i(e,$e,t),i(e,dl,t),i(e,ge,t),i(e,pl,t),m(Ue,e,t),i(e,ml,t),i(e,he,t),i(e,cl,t),m(je,e,t),i(e,ul,t),i(e,Ze,t),i(e,Ml,t),i(e,ke,t),i(e,bl,t),i(e,Ce,t),i(e,fl,t),m(xe,e,t),i(e,Tl,t),i(e,Be,t),i(e,vl,t),m(Ie,e,t),i(e,yl,t),i(e,We,t),i(e,Jl,t),i(e,He,t),i(e,zl,t),i(e,Ge,t),i(e,wl,t),i(e,Le,t),i(e,_l,t),m(Xe,e,t),i(e,$l,t),m(Ve,e,t),i(e,gl,t),i(e,Re,t),i(e,Ul,t),i(e,Fe,t),i(e,hl,t),i(e,Ee,t),i(e,jl,t),i(e,Ye,t),i(e,Zl,t),m(Se,e,t),i(e,kl,t),m(Ne,e,t),i(e,Cl,t),i(e,Pe,t),i(e,xl,t),i(e,Qe,t),i(e,Bl,t),i(e,Ae,t),i(e,Il,t),i(e,qe,t),i(e,Wl,t),i(e,Ke,t),i(e,Hl,t),m(De,e,t),i(e,Gl,t),i(e,et,t),Ll=!0},p:Qi,i(e){Ll||(c(v.$$.fragment,e),c(y.$$.fragment,e),c(z.$$.fragment,e),c(g.$$.fragment,e),c(j.$$.fragment,e),c(k.$$.fragment,e),c(C.$$.fragment,e),c(W.$$.fragment,e),c(L.$$.fragment,e),c(V.$$.fragment,e),c(F.$$.fragment,e),c(E.$$.fragment,e),c(N.$$.fragment,e),c(A.$$.fragment,e),c(K.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(oe.$$.fragment,e),c(ae.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(Ue.$$.fragment,e),c(je.$$.fragment,e),c(xe.$$.fragment,e),c(Ie.$$.fragment,e),c(Xe.$$.fragment,e),c(Ve.$$.fragment,e),c(Se.$$.fragment,e),c(Ne.$$.fragment,e),c(De.$$.fragment,e),Ll=!0)},o(e){u(v.$$.fragment,e),u(y.$$.fragment,e),u(z.$$.fragment,e),u(g.$$.fragment,e),u(j.$$.fragment,e),u(k.$$.fragment,e),u(C.$$.fragment,e),u(W.$$.fragment,e),u(L.$$.fragment,e),u(V.$$.fragment,e),u(F.$$.fragment,e),u(E.$$.fragment,e),u(N.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),u(D.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(xe.$$.fragment,e),u(Ie.$$.fragment,e),u(Xe.$$.fragment,e),u(Ve.$$.fragment,e),u(Se.$$.fragment,e),u(Ne.$$.fragment,e),u(De.$$.fragment,e),Ll=!1},d(e){e&&(l(tt),l(Oe),l(lt),l(it),l(ot),l(J),l(nt),l(at),l(w),l(st),l(_),l(rt),l($),l(dt),l(pt),l(U),l(mt),l(h),l(ct),l(ut),l(Z),l(Mt),l(bt),l(ft),l(x),l(Tt),l(B),l(vt),l(I),l(yt),l(Jt),l(H),l(zt),l(G),l(wt),l(_t),l(X),l($t),l(gt),l(R),l(Ut),l(ht),l(jt),l(Y),l(Zt),l(S),l(kt),l(Ct),l(P),l(xt),l(Q),l(Bt),l(It),l(q),l(Wt),l(Ht),l(Gt),l(O),l(Lt),l(ee),l(Xt),l(Vt),l(le),l(Rt),l(ie),l(Ft),l(Et),l(ne),l(Yt),l(St),l(se),l(Nt),l(Pt),l(Qt),l(pe),l(At),l(me),l(qt),l(ce),l(Kt),l(ue),l(Dt),l(Me),l(Ot),l(be),l(el),l(fe),l(tl),l(Te),l(ll),l(ve),l(il),l(ye),l(ol),l(Je),l(nl),l(ze),l(al),l(we),l(sl),l(_e),l(rl),l($e),l(dl),l(ge),l(pl),l(ml),l(he),l(cl),l(ul),l(Ze),l(Ml),l(ke),l(bl),l(Ce),l(fl),l(Tl),l(Be),l(vl),l(yl),l(We),l(Jl),l(He),l(zl),l(Ge),l(wl),l(Le),l(_l),l($l),l(gl),l(Re),l(Ul),l(Fe),l(hl),l(Ee),l(jl),l(Ye),l(Zl),l(kl),l(Cl),l(Pe),l(xl),l(Qe),l(Bl),l(Ae),l(Il),l(qe),l(Wl),l(Ke),l(Hl),l(Gl),l(et)),l(T),M(v,e),M(y,e),M(z,e),M(g,e),M(j,e),M(k,e),M(C,e),M(W,e),M(L,e),M(V,e),M(F,e),M(E,e),M(N,e),M(A,e),M(K,e),M(D,e),M(te,e),M(oe,e),M(ae,e),M(re,e),M(de,e),M(Ue,e),M(je,e),M(xe,e),M(Ie,e),M(Xe,e),M(Ve,e),M(Se,e),M(Ne,e),M(De,e)}}}const to='{"title":"Migrazione da pacchetti precedenti","local":"migrazione-da-pacchetti-precedenti","sections":[{"title":"Migrazione da transformers v3.x a v4.x","local":"migrazione-da-transformers-v3x-a-v4x","sections":[{"title":"1. AutoTokenizer e pipeline ora utilizzano tokenizer veloci (rust) per impostazione predefinita.","local":"1-autotokenizer-e-pipeline-ora-utilizzano-tokenizer-veloci-rust-per-impostazione-predefinita","sections":[{"title":"Come ottenere lo stesso comportamento di v3.x in v4.x","local":"come-ottenere-lo-stesso-comportamento-di-v3x-in-v4x","sections":[],"depth":5}],"depth":4},{"title":"2. SentencePiece è stato rimosso dalle dipendenze richieste","local":"2-sentencepiece-è-stato-rimosso-dalle-dipendenze-richieste","sections":[{"title":"Come ottenere lo stesso comportamento della v3.x nella v4.x","local":"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x","sections":[],"depth":5}],"depth":4},{"title":"3. L’architettura delle repo è stato aggiornata in modo che ogni modello abbia la propria cartella","local":"3-larchitettura-delle-repo-è-stato-aggiornata-in-modo-che-ogni-modello-abbia-la-propria-cartella","sections":[{"title":"Come ottenere lo stesso comportamento della v3.x nella v4.x","local":"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x","sections":[],"depth":5}],"depth":4},{"title":"4. Impostare l’argomento return_dict su True per impostazione predefinita","local":"4-impostare-largomento-returndict-su-true-per-impostazione-predefinita","sections":[{"title":"Come ottenere lo stesso comportamento della v3.x nella v4.x","local":"come-ottenere-lo-stesso-comportamento-della-v3x-nella-v4x","sections":[],"depth":5}],"depth":4},{"title":"5. Rimozione di alcuni attributi deprecati","local":"5-rimozione-di-alcuni-attributi-deprecati","sections":[],"depth":4}],"depth":2},{"title":"Passaggio da pytorch-transformers a 🤗 Transformers","local":"passaggio-da-pytorch-transformers-a--transformers","sections":[{"title":"L’ordine posizionale di alcune parole chiave di input dei modelli ( attention_mask , token_type_ids …) è cambiato","local":"lordine-posizionale-di-alcune-parole-chiave-di-input-dei-modelli--attentionmask--tokentypeids--è-cambiato","sections":[],"depth":3}],"depth":2},{"title":"Migrazione da pytorch-pretrained-bert","local":"migrazione-da-pytorch-pretrained-bert","sections":[{"title":"I modelli restituiscono sempre tuple","local":"i-modelli-restituiscono-sempre-tuple","sections":[],"depth":3},{"title":"Serializzazione","local":"serializzazione","sections":[],"depth":3},{"title":"Ottimizzatori: BertAdam e OpenAIAdam ora sono AdamW, lo scheduling è quello standard PyTorch","local":"ottimizzatori-bertadam-e-openaiadam-ora-sono-adamw-lo-scheduling-è-quello-standard-pytorch","sections":[],"depth":3}],"depth":2}],"depth":1}';function lo(Xl){return Ai(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class so extends qi{constructor(T){super(),Ki(this,T,lo,eo,Pi,{})}}export{so as component};
