import{s as ja,o as Ja,n as ba}from"../chunks/scheduler.9bc65507.js";import{S as $a,i as va,g as i,s as l,r as o,A as Ua,h as p,f as t,c as n,j as Ta,u as c,x as r,k as $t,y as Za,a,v as m,d as h,t as u,w as f,m as Ia,n as ka}from"../chunks/index.707bf1b6.js";import{T as vt}from"../chunks/Tip.c2ecdbf4.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";import{H as b}from"../chunks/Heading.342b1fa6.js";function Ga($){let d,M='Take a look at the <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> documentation for a complete list of supported tasks and available parameters.';return{c(){d=i("p"),d.innerHTML=M},l(w){d=p(w,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1xq6lbr"&&(d.innerHTML=M)},m(w,T){a(w,d,T)},p:ba,d(w){w&&t(d)}}}function xa($){let d;return{c(){d=Ia(`Creating an inference engine is a complex topic which deserves it's own
page.`)},l(M){d=ka(M,`Creating an inference engine is a complex topic which deserves it's own
page.`)},m(M,w){a(M,d,w)},d(M){M&&t(d)}}}function Ba($){let d,M='To run the example above you need to have <a href="https://pypi.org/project/pytesseract/" rel="nofollow"><code>pytesseract</code></a> installed in addition to 🤗 Transformers:',w,T,j;return T=new y({props:{code:"c3VkbyUyMGFwdCUyMGluc3RhbGwlMjAteSUyMHRlc3NlcmFjdC1vY3IlMEFwaXAlMjBpbnN0YWxsJTIwcHl0ZXNzZXJhY3Q=",highlighted:`sudo apt install -y tesseract-ocr
pip install pytesseract`,wrap:!1}}),{c(){d=i("p"),d.innerHTML=M,w=l(),o(T.$$.fragment)},l(g){d=p(g,"P",{"data-svelte-h":!0}),r(d)!=="svelte-z3k1tk"&&(d.innerHTML=M),w=n(g),c(T.$$.fragment,g)},m(g,J){a(g,d,J),a(g,w,J),m(T,g,J),j=!0},p:ba,i(g){j||(h(T.$$.fragment,g),j=!0)},o(g){u(T.$$.fragment,g),j=!1},d(g){g&&(t(d),t(w)),f(T,g)}}}function Wa($){let d,M,w,T,j,g,J,Ut='The <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> makes it simple to use any model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a> for inference on any language, computer vision, speech, and multimodal tasks. Even if you don’t have experience with a specific modality or aren’t familiar with the underlying code behind the models, you can still use them for inference with the <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>! This tutorial will teach you to:',De,k,Zt='<li>Use a <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for inference.</li> <li>Use a specific tokenizer or model.</li> <li>Use a <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for audio, vision, and multimodal tasks.</li>',Ke,v,Oe,G,es,x,It=`While each task has an associated <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>, it is simpler to use the general <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> abstraction which contains
all the task-specific pipelines. The <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> automatically loads a default model and a preprocessing class capable
of inference for your task. Let’s take the example of using the <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for automatic speech recognition (ASR), or
speech-to-text.`,ss,B,kt='<li>Start by creating a <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> and specify the inference task:</li>',ts,W,as,U,Gt='<li>Pass your input to the <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>. In the case of speech recognition, this is an audio input file:</li>',ls,C,ns,X,xt=`Not the result you had in mind? Check out some of the <a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;sort=trending" rel="nofollow">most downloaded automatic speech recognition models</a>
on the Hub to see if you can get a better transcription.`,is,H,Bt=`Let’s try the <a href="https://huggingface.co/openai/whisper-large" rel="nofollow">Whisper large-v2</a> model from OpenAI. Whisper was released
2 years later than Wav2Vec2, and was trained on close to 10x more data. As such, it beats Wav2Vec2 on most downstream
benchmarks. It also has the added benefit of predicting punctuation and casing, neither of which are possible with<br/>
Wav2Vec2.`,ps,_,Wt="Let’s give it a try here to see how it performs:",rs,R,os,Y,Ct=`Now this result looks more accurate! For a deep-dive comparison on Wav2Vec2 vs Whisper, refer to the <a href="https://huggingface.co/learn/audio-course/chapter5/asr_models" rel="nofollow">Audio Transformers Course</a>.
We really encourage you to check out the Hub for models in different languages, models specialized in your field, and more.
You can check out and compare model results directly from your browser on the Hub to see if it fits or
handles corner cases better than other ones.
And if you don’t find a model for your use case, you can always start <a href="training">training</a> your own!`,cs,V,Xt="If you have several inputs, you can pass your input as a list:",ms,N,hs,q,Ht=`Pipelines are great for experimentation as switching from one model to another is trivial; however, there are some ways to optimize them for larger workloads than experimentation. See the following guides that dive into iterating over whole datasets or using pipelines in a webserver:
of the docs:`,us,z,_t='<li><a href="#using-pipelines-on-a-dataset">Using pipelines on a dataset</a></li> <li><a href="./pipeline_webserver">Using pipelines for a webserver</a></li>',fs,F,ds,L,Rt=`<a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> supports many parameters; some are task specific, and some are general to all pipelines.
In general, you can specify parameters anywhere you want:`,ys,S,gs,Q,Yt="Let’s check out 3 important ones:",ws,E,Ms,P,Vt=`If you use <code>device=n</code>, the pipeline automatically puts the model on the specified device.
This will work regardless of whether you are using PyTorch or Tensorflow.`,Ts,A,bs,D,Nt=`If the model is too large for a single GPU and you are using PyTorch, you can set <code>device_map=&quot;auto&quot;</code> to automatically
determine how to load and store the model weights. Using the <code>device_map</code> argument requires the 🤗 <a href="https://huggingface.co/docs/accelerate" rel="nofollow">Accelerate</a>
package:`,js,K,Js,O,qt="The following code automatically loads and stores model weights across devices:",$s,ee,vs,se,zt="Note that if  <code>device_map=&quot;auto&quot;</code> is passed, there is no need to add the argument <code>device=device</code> when instantiating your <code>pipeline</code> as you may encounter some unexpected behavior!",Us,te,Zs,ae,Ft='By default, pipelines will not batch inference for reasons explained in detail <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#pipeline-batching" rel="nofollow">here</a>. The reason is that batching is not necessarily faster, and can actually be quite slower in some cases.',Is,le,Lt="But if it works in your use case, you can use:",ks,ne,Gs,ie,St=`This runs the pipeline on the 4 provided audio files, but it will pass them in batches of 2
to the model (which is on a GPU, where batching is more likely to help) without requiring any further code from you.
The output should always match what you would have received without batching. It is only meant as a way to help you get more speed out of a pipeline.`,xs,pe,Qt='Pipelines can also alleviate some of the complexities of batching because, for some pipelines, a single item (like a long audio file) needs to be chunked into multiple parts to be processed by a model. The pipeline performs this <a href="./main_classes/pipelines#pipeline-chunk-batching"><em>chunk batching</em></a> for you.',Bs,re,Ws,oe,Et=`All tasks provide task specific parameters which allow for additional flexibility and options to help you get your job done.
For instance, the <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline.__call__">transformers.AutomaticSpeechRecognitionPipeline.<strong>call</strong>()</a> method has a <code>return_timestamps</code> parameter which sounds promising for subtitling videos:`,Cs,ce,Xs,me,Pt="As you can see, the model inferred the text and also outputted <strong>when</strong> the various sentences were pronounced.",Hs,he,At=`There are many parameters available for each task, so check out each task’s API reference to see what you can tinker with!
For instance, the <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline">AutomaticSpeechRecognitionPipeline</a> has a <code>chunk_length_s</code> parameter which is helpful
for working on really long audio files (for example, subtitling entire movies or hour-long videos) that a model typically
cannot handle on its own:`,_s,ue,Rs,fe,Dt='If you can’t find a parameter that would really help you out, feel free to <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=feature&amp;template=feature-request.yml" rel="nofollow">request it</a>!',Ys,de,Vs,ye,Kt="The pipeline can also run inference on a large dataset. The easiest way we recommend doing this is by using an iterator:",Ns,ge,qs,we,Ot=`The iterator <code>data()</code> yields each result, and the pipeline automatically
recognizes the input is iterable and will start fetching the data while
it continues to process it on the GPU (this uses <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow">DataLoader</a> under the hood).
This is important because you don’t have to allocate memory for the whole dataset
and you can feed the GPU as fast as possible.`,zs,Me,ea="Since batching could speed things up, it may be useful to try tuning the <code>batch_size</code> parameter here.",Fs,Te,sa='The simplest way to iterate over a dataset is to just load one from 🤗 <a href="https://github.com/huggingface/datasets/" rel="nofollow">Datasets</a>:',Ls,be,Ss,je,Qs,Z,Es,Je,ta='<a href="./pipeline_webserver">Link</a>',Ps,$e,As,ve,aa='Using a <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for vision tasks is practically identical.',Ds,Ue,la="Specify your task and pass your image to the classifier. The image can be a link, a local path or a base64-encoded image. For example, what species of cat is shown below?",Ks,Ze,na='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',Os,Ie,et,ke,st,Ge,ia='Using a <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for NLP tasks is practically identical.',tt,xe,at,Be,lt,We,pa='The <a href="/docs/transformers/v4.39.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> supports more than one modality. For example, a visual question answering (VQA) task combines text and image. Feel free to use any image link you like and a question you want to ask about the image. The image can be a URL or a local path to the image.',nt,Ce,ra='For example, if you use this <a href="https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png" rel="nofollow">invoice image</a>:',it,Xe,pt,I,rt,He,ot,_e,oa="You can easily run <code>pipeline</code> on large models using 🤗 <code>accelerate</code>! First make sure you have installed <code>accelerate</code> with <code>pip install accelerate</code>.",ct,Re,ca="First load your model using <code>device_map=&quot;auto&quot;</code>! We will use <code>facebook/opt-1.3b</code> for our example.",mt,Ye,ht,Ve,ma="You can also pass 8-bit loaded models if you install <code>bitsandbytes</code> and add the argument <code>load_in_8bit=True</code>",ut,Ne,ft,qe,ha="Note that you can replace the checkpoint with any Hugging Face model that supports large model loading, such as BLOOM.",dt,ze,yt,Fe,ua='Pipelines are automatically supported in <a href="https://github.com/gradio-app/gradio/" rel="nofollow">Gradio</a>, a library that makes creating beautiful and user-friendly machine learning apps on the web a breeze. First, make sure you have Gradio installed:',gt,Le,wt,Se,fa='Then, you can create a web demo around an image classification pipeline (or any other pipeline) in a single line of code by calling Gradio’s <a href="https://www.gradio.app/docs/interface#interface-from-pipeline" rel="nofollow"><code>Interface.from_pipeline</code></a> function to launch the pipeline. This creates an intuitive drag-and-drop interface in your browser:',Mt,Qe,Tt,Ee,da='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/panda-classification.png"/>',bt,Pe,ya=`By default, the web demo runs on a local server. If you’d like to share it with others, you can generate a temporary public
link by setting <code>share=True</code> in <code>launch()</code>. You can also host your demo on <a href="https://huggingface.co/spaces" rel="nofollow">Hugging Face Spaces</a> for a permanent link.`,jt,Ae,Jt;return j=new b({props:{title:"Pipelines for inference",local:"pipelines-for-inference",headingTag:"h1"}}),v=new vt({props:{$$slots:{default:[Ga]},$$scope:{ctx:$}}}),G=new b({props:{title:"Pipeline usage",local:"pipeline-usage",headingTag:"h2"}}),W=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)`,wrap:!1}}),C=new y({props:{code:"dHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I HAVE A DREAM BUT ONE DAY THIS NATION WILL RISE UP LIVE UP THE TRUE MEANING OF ITS TREES&#x27;</span>}`,wrap:!1}}),R=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),N=new y({props:{code:"dHJhbnNjcmliZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGMS5mbGFjJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKQ==",highlighted:`transcriber(
    [
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>,
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/1.flac&quot;</span>,
    ]
)`,wrap:!1}}),F=new b({props:{title:"Parameters",local:"parameters",headingTag:"h2"}}),S=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBteV9wYXJhbWV0ZXIlM0QxKSUwQSUwQW91dCUyMCUzRCUyMHRyYW5zY3JpYmVyKC4uLiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMHVzZSUyMCU2MG15X3BhcmFtZXRlciUzRDElNjAuJTBBb3V0JTIwJTNEJTIwdHJhbnNjcmliZXIoLi4uJTJDJTIwbXlfcGFyYW1ldGVyJTNEMiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMG92ZXJyaWRlJTIwYW5kJTIwdXNlJTIwJTYwbXlfcGFyYW1ldGVyJTNEMiU2MC4lMEFvdXQlMjAlM0QlMjB0cmFuc2NyaWJlciguLi4pJTIwJTIwJTIzJTIwVGhpcyUyMHdpbGwlMjBnbyUyMGJhY2slMjB0byUyMHVzaW5nJTIwJTYwbXlfcGFyYW1ldGVyJTNEMSU2MC4=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, my_parameter=<span class="hljs-number">1</span>)\n\nout = transcriber(...)  <span class="hljs-comment"># This will use `my_parameter=1`.</span>\nout = transcriber(..., my_parameter=<span class="hljs-number">2</span>)  <span class="hljs-comment"># This will override and use `my_parameter=2`.</span>\nout = transcriber(...)  <span class="hljs-comment"># This will go back to using `my_parameter=1`.</span>',wrap:!1}}),E=new b({props:{title:"Device",local:"device",headingTag:"h3"}}),A=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwKQ==",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>)',wrap:!1}}),K=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGFjY2VsZXJhdGU=",highlighted:"pip install --upgrade accelerate",wrap:!1}}),ee=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)',wrap:!1}}),te=new b({props:{title:"Batch size",local:"batch-size",headingTag:"h3"}}),ne=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwJTJDJTIwYmF0Y2hfc2l6ZSUzRDIpJTBBYXVkaW9fZmlsZW5hbWVzJTIwJTNEJTIwJTVCZiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGJTdCaSU3RC5mbGFjJTIyJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMSUyQyUyMDUpJTVEJTBBdGV4dHMlMjAlM0QlMjB0cmFuc2NyaWJlcihhdWRpb19maWxlbmFtZXMp",highlighted:`transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>, batch_size=<span class="hljs-number">2</span>)
audio_filenames = [<span class="hljs-string">f&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/<span class="hljs-subst">{i}</span>.flac&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, <span class="hljs-number">5</span>)]
texts = transcriber(audio_filenames)`,wrap:!1}}),re=new b({props:{title:"Task specific parameters",local:"task-specific-parameters",headingTag:"h3"}}),ce=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjByZXR1cm5fdGltZXN0YW1wcyUzRFRydWUpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>, <span class="hljs-string">&#x27;chunks&#x27;</span>: [{<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">0.0</span>, <span class="hljs-number">11.88</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its&#x27;</span>}, {<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">11.88</span>, <span class="hljs-number">12.38</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; creed.&#x27;</span>}]}`,wrap:!1}}),ue=new y({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBjaHVua19sZW5ndGhfcyUzRDMwJTJDJTIwcmV0dXJuX3RpbWVzdGFtcHMlM0RUcnVlKSUwQXRyYW5zY3JpYmVyKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnNhbmNoaXQtZ2FuZGhpJTJGbGlicmlzcGVlY2hfbG9uZyUyRnJlc29sdmUlMkZtYWluJTJGYXVkaW8ud2F2JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, chunk_length_s=<span class="hljs-number">30</span>, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/sanchit-gandhi/librispeech_long/resolve/main/audio.wav&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot; Chapter 16. I might have told you of the beginning of this liaison in a few lines, but I wanted you to see every step by which we came.  I, too, agree to whatever Marguerite wished, Marguerite to be unable to live apart from me. It was the day after the evening...</span>`,wrap:!1}}),de=new b({props:{title:"Using pipelines on a dataset",local:"using-pipelines-on-a-dataset",headingTag:"h2"}}),ge=new y({props:{code:"ZGVmJTIwZGF0YSgpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMGYlMjJNeSUyMGV4YW1wbGUlMjAlN0JpJTdEJTIyJTBBJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBkZXZpY2UlM0QwKSUwQWdlbmVyYXRlZF9jaGFyYWN0ZXJzJTIwJTNEJTIwMCUwQWZvciUyMG91dCUyMGluJTIwcGlwZShkYXRhKCkpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX2NoYXJhY3RlcnMlMjAlMkIlM0QlMjBsZW4ob3V0JTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">data</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> <span class="hljs-string">f&quot;My example <span class="hljs-subst">{i}</span>&quot;</span>


pipe = pipeline(model=<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, device=<span class="hljs-number">0</span>)
generated_characters = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(data()):
    generated_characters += <span class="hljs-built_in">len</span>(out[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>])`,wrap:!1}}),be=new y({props:{code:"JTIzJTIwS2V5RGF0YXNldCUyMGlzJTIwYSUyMHV0aWwlMjB0aGF0JTIwd2lsbCUyMGp1c3QlMjBvdXRwdXQlMjB0aGUlMjBpdGVtJTIwd2UncmUlMjBpbnRlcmVzdGVkJTIwaW4uJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMucHRfdXRpbHMlMjBpbXBvcnQlMjBLZXlEYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRnRpbnktcmFuZG9tLXdhdjJ2ZWMyJTIyJTJDJTIwZGV2aWNlJTNEMCklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiU1QiUzQTEwJTVEJTIyKSUwQSUwQWZvciUyMG91dCUyMGluJTIwcGlwZShLZXlEYXRhc2V0KGRhdGFzZXQlMkMlMjAlMjJhdWRpbyUyMikpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQob3V0KQ==",highlighted:`<span class="hljs-comment"># KeyDataset is a util that will just output the item we&#x27;re interested in.</span>
<span class="hljs-keyword">from</span> transformers.pipelines.pt_utils <span class="hljs-keyword">import</span> KeyDataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

pipe = pipeline(model=<span class="hljs-string">&quot;hf-internal-testing/tiny-random-wav2vec2&quot;</span>, device=<span class="hljs-number">0</span>)
dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation[:10]&quot;</span>)

<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(KeyDataset(dataset, <span class="hljs-string">&quot;audio&quot;</span>)):
    <span class="hljs-built_in">print</span>(out)`,wrap:!1}}),je=new b({props:{title:"Using pipelines for a webserver",local:"using-pipelines-for-a-webserver",headingTag:"h2"}}),Z=new vt({props:{$$slots:{default:[xa]},$$scope:{ctx:$}}}),$e=new b({props:{title:"Vision pipeline",local:"vision-pipeline",headingTag:"h2"}}),Ie=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQXByZWRzJTIwJTNEJTIwdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}]`,wrap:!1}}),ke=new b({props:{title:"Text pipeline",local:"text-pipeline",headingTag:"h2"}}),xe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwVGhpcyUyMG1vZGVsJTIwaXMlMjBhJTIwJTYwemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJTYwJTIwbW9kZWwuJTBBJTIzJTIwSXQlMjB3aWxsJTIwY2xhc3NpZnklMjB0ZXh0JTJDJTIwZXhjZXB0JTIweW91JTIwYXJlJTIwZnJlZSUyMHRvJTIwY2hvb3NlJTIwYW55JTIwbGFiZWwlMjB5b3UlMjBtaWdodCUyMGltYWdpbmUlMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJmYWNlYm9vayUyRmJhcnQtbGFyZ2UtbW5saSUyMiklMEFjbGFzc2lmaWVyKCUwQSUyMCUyMCUyMCUyMCUyMkklMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISElMjIlMkMlMEElMjAlMjAlMjAlMjBjYW5kaWRhdGVfbGFiZWxzJTNEJTVCJTIydXJnZW50JTIyJTJDJTIwJTIybm90JTIwdXJnZW50JTIyJTJDJTIwJTIycGhvbmUlMjIlMkMlMjAlMjJ0YWJsZXQlMjIlMkMlMjAlMjJjb21wdXRlciUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This model is a \`zero-shot-classification\` model.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># It will classify text, except you are free to choose any label you might imagine</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(model=<span class="hljs-string">&quot;facebook/bart-large-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;I have a problem with my iphone that needs to be resolved asap!!&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;urgent&quot;</span>, <span class="hljs-string">&quot;not urgent&quot;</span>, <span class="hljs-string">&quot;phone&quot;</span>, <span class="hljs-string">&quot;tablet&quot;</span>, <span class="hljs-string">&quot;computer&quot;</span>],
<span class="hljs-meta">... </span>)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.504</span>, <span class="hljs-number">0.479</span>, <span class="hljs-number">0.013</span>, <span class="hljs-number">0.003</span>, <span class="hljs-number">0.002</span>]}`,wrap:!1}}),Be=new b({props:{title:"Multimodal pipeline",local:"multimodal-pipeline",headingTag:"h2"}}),Xe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdnFhJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiklMEF2cWEoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBpbnZvaWNlJTIwbnVtYmVyJTNGJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vqa = pipeline(model=<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vqa(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>,
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.42515</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;us-001&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>}]`,wrap:!1}}),I=new vt({props:{$$slots:{default:[Ba]},$$scope:{ctx:$}}}),He=new b({props:{title:"Using pipeline on large models with 🤗 accelerate :",local:"using-pipeline-on-large-models-with--accelerate-",headingTag:"h2"}}),Ye=new y({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),Ne=new y({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMG1vZGVsX2t3YXJncyUzRCU3QiUyMmxvYWRfaW5fOGJpdCUyMiUzQSUyMFRydWUlN0QpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate bitsandbytes</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, model_kwargs={<span class="hljs-string">&quot;load_in_8bit&quot;</span>: <span class="hljs-literal">True</span>})
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),ze=new b({props:{title:"Creating web demos from pipelines with gradio",local:"creating-web-demos-from-pipelines-with-gradio",headingTag:"h2"}}),Le=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdyYWRpbw==",highlighted:'pip <span class="hljs-keyword">install</span> gradio',wrap:!1}}),Qe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBZ3IuSW50ZXJmYWNlLmZyb21fcGlwZWxpbmUocGlwZSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

pipe = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)

gr.Interface.from_pipeline(pipe).launch()`,wrap:!1}}),{c(){d=i("meta"),M=l(),w=i("p"),T=l(),o(j.$$.fragment),g=l(),J=i("p"),J.innerHTML=Ut,De=l(),k=i("ul"),k.innerHTML=Zt,Ke=l(),o(v.$$.fragment),Oe=l(),o(G.$$.fragment),es=l(),x=i("p"),x.innerHTML=It,ss=l(),B=i("ol"),B.innerHTML=kt,ts=l(),o(W.$$.fragment),as=l(),U=i("ol"),U.innerHTML=Gt,ls=l(),o(C.$$.fragment),ns=l(),X=i("p"),X.innerHTML=xt,is=l(),H=i("p"),H.innerHTML=Bt,ps=l(),_=i("p"),_.textContent=Wt,rs=l(),o(R.$$.fragment),os=l(),Y=i("p"),Y.innerHTML=Ct,cs=l(),V=i("p"),V.textContent=Xt,ms=l(),o(N.$$.fragment),hs=l(),q=i("p"),q.textContent=Ht,us=l(),z=i("ul"),z.innerHTML=_t,fs=l(),o(F.$$.fragment),ds=l(),L=i("p"),L.innerHTML=Rt,ys=l(),o(S.$$.fragment),gs=l(),Q=i("p"),Q.textContent=Yt,ws=l(),o(E.$$.fragment),Ms=l(),P=i("p"),P.innerHTML=Vt,Ts=l(),o(A.$$.fragment),bs=l(),D=i("p"),D.innerHTML=Nt,js=l(),o(K.$$.fragment),Js=l(),O=i("p"),O.textContent=qt,$s=l(),o(ee.$$.fragment),vs=l(),se=i("p"),se.innerHTML=zt,Us=l(),o(te.$$.fragment),Zs=l(),ae=i("p"),ae.innerHTML=Ft,Is=l(),le=i("p"),le.textContent=Lt,ks=l(),o(ne.$$.fragment),Gs=l(),ie=i("p"),ie.textContent=St,xs=l(),pe=i("p"),pe.innerHTML=Qt,Bs=l(),o(re.$$.fragment),Ws=l(),oe=i("p"),oe.innerHTML=Et,Cs=l(),o(ce.$$.fragment),Xs=l(),me=i("p"),me.innerHTML=Pt,Hs=l(),he=i("p"),he.innerHTML=At,_s=l(),o(ue.$$.fragment),Rs=l(),fe=i("p"),fe.innerHTML=Dt,Ys=l(),o(de.$$.fragment),Vs=l(),ye=i("p"),ye.textContent=Kt,Ns=l(),o(ge.$$.fragment),qs=l(),we=i("p"),we.innerHTML=Ot,zs=l(),Me=i("p"),Me.innerHTML=ea,Fs=l(),Te=i("p"),Te.innerHTML=sa,Ls=l(),o(be.$$.fragment),Ss=l(),o(je.$$.fragment),Qs=l(),o(Z.$$.fragment),Es=l(),Je=i("p"),Je.innerHTML=ta,Ps=l(),o($e.$$.fragment),As=l(),ve=i("p"),ve.innerHTML=aa,Ds=l(),Ue=i("p"),Ue.textContent=la,Ks=l(),Ze=i("p"),Ze.innerHTML=na,Os=l(),o(Ie.$$.fragment),et=l(),o(ke.$$.fragment),st=l(),Ge=i("p"),Ge.innerHTML=ia,tt=l(),o(xe.$$.fragment),at=l(),o(Be.$$.fragment),lt=l(),We=i("p"),We.innerHTML=pa,nt=l(),Ce=i("p"),Ce.innerHTML=ra,it=l(),o(Xe.$$.fragment),pt=l(),o(I.$$.fragment),rt=l(),o(He.$$.fragment),ot=l(),_e=i("p"),_e.innerHTML=oa,ct=l(),Re=i("p"),Re.innerHTML=ca,mt=l(),o(Ye.$$.fragment),ht=l(),Ve=i("p"),Ve.innerHTML=ma,ut=l(),o(Ne.$$.fragment),ft=l(),qe=i("p"),qe.textContent=ha,dt=l(),o(ze.$$.fragment),yt=l(),Fe=i("p"),Fe.innerHTML=ua,gt=l(),o(Le.$$.fragment),wt=l(),Se=i("p"),Se.innerHTML=fa,Mt=l(),o(Qe.$$.fragment),Tt=l(),Ee=i("p"),Ee.innerHTML=da,bt=l(),Pe=i("p"),Pe.innerHTML=ya,jt=l(),Ae=i("p"),this.h()},l(e){const s=Ua("svelte-u9bgzb",document.head);d=p(s,"META",{name:!0,content:!0}),s.forEach(t),M=n(e),w=p(e,"P",{}),Ta(w).forEach(t),T=n(e),c(j.$$.fragment,e),g=n(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1vymey6"&&(J.innerHTML=Ut),De=n(e),k=p(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-1dcj9pm"&&(k.innerHTML=Zt),Ke=n(e),c(v.$$.fragment,e),Oe=n(e),c(G.$$.fragment,e),es=n(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-ib6jic"&&(x.innerHTML=It),ss=n(e),B=p(e,"OL",{"data-svelte-h":!0}),r(B)!=="svelte-55uqdz"&&(B.innerHTML=kt),ts=n(e),c(W.$$.fragment,e),as=n(e),U=p(e,"OL",{start:!0,"data-svelte-h":!0}),r(U)!=="svelte-jracsl"&&(U.innerHTML=Gt),ls=n(e),c(C.$$.fragment,e),ns=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-jt3v05"&&(X.innerHTML=xt),is=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1sbs9t3"&&(H.innerHTML=Bt),ps=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-5gg07s"&&(_.textContent=Wt),rs=n(e),c(R.$$.fragment,e),os=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1yjypga"&&(Y.innerHTML=Ct),cs=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1udq0dv"&&(V.textContent=Xt),ms=n(e),c(N.$$.fragment,e),hs=n(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1y2bxsh"&&(q.textContent=Ht),us=n(e),z=p(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-boqb6q"&&(z.innerHTML=_t),fs=n(e),c(F.$$.fragment,e),ds=n(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1vmdpru"&&(L.innerHTML=Rt),ys=n(e),c(S.$$.fragment,e),gs=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-e9485z"&&(Q.textContent=Yt),ws=n(e),c(E.$$.fragment,e),Ms=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-sob7ne"&&(P.innerHTML=Vt),Ts=n(e),c(A.$$.fragment,e),bs=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1tfx7co"&&(D.innerHTML=Nt),js=n(e),c(K.$$.fragment,e),Js=n(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-6riuku"&&(O.textContent=qt),$s=n(e),c(ee.$$.fragment,e),vs=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1otna9r"&&(se.innerHTML=zt),Us=n(e),c(te.$$.fragment,e),Zs=n(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-v1mumi"&&(ae.innerHTML=Ft),Is=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1jutax8"&&(le.textContent=Lt),ks=n(e),c(ne.$$.fragment,e),Gs=n(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-n3ouik"&&(ie.textContent=St),xs=n(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-sq1wry"&&(pe.innerHTML=Qt),Bs=n(e),c(re.$$.fragment,e),Ws=n(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1ewslch"&&(oe.innerHTML=Et),Cs=n(e),c(ce.$$.fragment,e),Xs=n(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1ad1wem"&&(me.innerHTML=Pt),Hs=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-ay0y1j"&&(he.innerHTML=At),_s=n(e),c(ue.$$.fragment,e),Rs=n(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1nowgzq"&&(fe.innerHTML=Dt),Ys=n(e),c(de.$$.fragment,e),Vs=n(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1sh6mg6"&&(ye.textContent=Kt),Ns=n(e),c(ge.$$.fragment,e),qs=n(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1rrzg9"&&(we.innerHTML=Ot),zs=n(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1litpj1"&&(Me.innerHTML=ea),Fs=n(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1pgxdbs"&&(Te.innerHTML=sa),Ls=n(e),c(be.$$.fragment,e),Ss=n(e),c(je.$$.fragment,e),Qs=n(e),c(Z.$$.fragment,e),Es=n(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-52dmam"&&(Je.innerHTML=ta),Ps=n(e),c($e.$$.fragment,e),As=n(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1269h69"&&(ve.innerHTML=aa),Ds=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-ip2z2f"&&(Ue.textContent=la),Ks=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1bks2jw"&&(Ze.innerHTML=na),Os=n(e),c(Ie.$$.fragment,e),et=n(e),c(ke.$$.fragment,e),st=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-5vkjll"&&(Ge.innerHTML=ia),tt=n(e),c(xe.$$.fragment,e),at=n(e),c(Be.$$.fragment,e),lt=n(e),We=p(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1s509mk"&&(We.innerHTML=pa),nt=n(e),Ce=p(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-4s0csr"&&(Ce.innerHTML=ra),it=n(e),c(Xe.$$.fragment,e),pt=n(e),c(I.$$.fragment,e),rt=n(e),c(He.$$.fragment,e),ot=n(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-32c7q2"&&(_e.innerHTML=oa),ct=n(e),Re=p(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1yg483v"&&(Re.innerHTML=ca),mt=n(e),c(Ye.$$.fragment,e),ht=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1c9ycn6"&&(Ve.innerHTML=ma),ut=n(e),c(Ne.$$.fragment,e),ft=n(e),qe=p(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-frv3wv"&&(qe.textContent=ha),dt=n(e),c(ze.$$.fragment,e),yt=n(e),Fe=p(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-hf8ov5"&&(Fe.innerHTML=ua),gt=n(e),c(Le.$$.fragment,e),wt=n(e),Se=p(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-191d3mo"&&(Se.innerHTML=fa),Mt=n(e),c(Qe.$$.fragment,e),Tt=n(e),Ee=p(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-rjj5jb"&&(Ee.innerHTML=da),bt=n(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-efanlv"&&(Pe.innerHTML=ya),jt=n(e),Ae=p(e,"P",{}),Ta(Ae).forEach(t),this.h()},h(){$t(d,"name","hf:doc:metadata"),$t(d,"content",Ca),$t(U,"start","2")},m(e,s){Za(document.head,d),a(e,M,s),a(e,w,s),a(e,T,s),m(j,e,s),a(e,g,s),a(e,J,s),a(e,De,s),a(e,k,s),a(e,Ke,s),m(v,e,s),a(e,Oe,s),m(G,e,s),a(e,es,s),a(e,x,s),a(e,ss,s),a(e,B,s),a(e,ts,s),m(W,e,s),a(e,as,s),a(e,U,s),a(e,ls,s),m(C,e,s),a(e,ns,s),a(e,X,s),a(e,is,s),a(e,H,s),a(e,ps,s),a(e,_,s),a(e,rs,s),m(R,e,s),a(e,os,s),a(e,Y,s),a(e,cs,s),a(e,V,s),a(e,ms,s),m(N,e,s),a(e,hs,s),a(e,q,s),a(e,us,s),a(e,z,s),a(e,fs,s),m(F,e,s),a(e,ds,s),a(e,L,s),a(e,ys,s),m(S,e,s),a(e,gs,s),a(e,Q,s),a(e,ws,s),m(E,e,s),a(e,Ms,s),a(e,P,s),a(e,Ts,s),m(A,e,s),a(e,bs,s),a(e,D,s),a(e,js,s),m(K,e,s),a(e,Js,s),a(e,O,s),a(e,$s,s),m(ee,e,s),a(e,vs,s),a(e,se,s),a(e,Us,s),m(te,e,s),a(e,Zs,s),a(e,ae,s),a(e,Is,s),a(e,le,s),a(e,ks,s),m(ne,e,s),a(e,Gs,s),a(e,ie,s),a(e,xs,s),a(e,pe,s),a(e,Bs,s),m(re,e,s),a(e,Ws,s),a(e,oe,s),a(e,Cs,s),m(ce,e,s),a(e,Xs,s),a(e,me,s),a(e,Hs,s),a(e,he,s),a(e,_s,s),m(ue,e,s),a(e,Rs,s),a(e,fe,s),a(e,Ys,s),m(de,e,s),a(e,Vs,s),a(e,ye,s),a(e,Ns,s),m(ge,e,s),a(e,qs,s),a(e,we,s),a(e,zs,s),a(e,Me,s),a(e,Fs,s),a(e,Te,s),a(e,Ls,s),m(be,e,s),a(e,Ss,s),m(je,e,s),a(e,Qs,s),m(Z,e,s),a(e,Es,s),a(e,Je,s),a(e,Ps,s),m($e,e,s),a(e,As,s),a(e,ve,s),a(e,Ds,s),a(e,Ue,s),a(e,Ks,s),a(e,Ze,s),a(e,Os,s),m(Ie,e,s),a(e,et,s),m(ke,e,s),a(e,st,s),a(e,Ge,s),a(e,tt,s),m(xe,e,s),a(e,at,s),m(Be,e,s),a(e,lt,s),a(e,We,s),a(e,nt,s),a(e,Ce,s),a(e,it,s),m(Xe,e,s),a(e,pt,s),m(I,e,s),a(e,rt,s),m(He,e,s),a(e,ot,s),a(e,_e,s),a(e,ct,s),a(e,Re,s),a(e,mt,s),m(Ye,e,s),a(e,ht,s),a(e,Ve,s),a(e,ut,s),m(Ne,e,s),a(e,ft,s),a(e,qe,s),a(e,dt,s),m(ze,e,s),a(e,yt,s),a(e,Fe,s),a(e,gt,s),m(Le,e,s),a(e,wt,s),a(e,Se,s),a(e,Mt,s),m(Qe,e,s),a(e,Tt,s),a(e,Ee,s),a(e,bt,s),a(e,Pe,s),a(e,jt,s),a(e,Ae,s),Jt=!0},p(e,[s]){const ga={};s&2&&(ga.$$scope={dirty:s,ctx:e}),v.$set(ga);const wa={};s&2&&(wa.$$scope={dirty:s,ctx:e}),Z.$set(wa);const Ma={};s&2&&(Ma.$$scope={dirty:s,ctx:e}),I.$set(Ma)},i(e){Jt||(h(j.$$.fragment,e),h(v.$$.fragment,e),h(G.$$.fragment,e),h(W.$$.fragment,e),h(C.$$.fragment,e),h(R.$$.fragment,e),h(N.$$.fragment,e),h(F.$$.fragment,e),h(S.$$.fragment,e),h(E.$$.fragment,e),h(A.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(de.$$.fragment,e),h(ge.$$.fragment,e),h(be.$$.fragment,e),h(je.$$.fragment,e),h(Z.$$.fragment,e),h($e.$$.fragment,e),h(Ie.$$.fragment,e),h(ke.$$.fragment,e),h(xe.$$.fragment,e),h(Be.$$.fragment,e),h(Xe.$$.fragment,e),h(I.$$.fragment,e),h(He.$$.fragment,e),h(Ye.$$.fragment,e),h(Ne.$$.fragment,e),h(ze.$$.fragment,e),h(Le.$$.fragment,e),h(Qe.$$.fragment,e),Jt=!0)},o(e){u(j.$$.fragment,e),u(v.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(C.$$.fragment,e),u(R.$$.fragment,e),u(N.$$.fragment,e),u(F.$$.fragment,e),u(S.$$.fragment,e),u(E.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(de.$$.fragment,e),u(ge.$$.fragment,e),u(be.$$.fragment,e),u(je.$$.fragment,e),u(Z.$$.fragment,e),u($e.$$.fragment,e),u(Ie.$$.fragment,e),u(ke.$$.fragment,e),u(xe.$$.fragment,e),u(Be.$$.fragment,e),u(Xe.$$.fragment,e),u(I.$$.fragment,e),u(He.$$.fragment,e),u(Ye.$$.fragment,e),u(Ne.$$.fragment,e),u(ze.$$.fragment,e),u(Le.$$.fragment,e),u(Qe.$$.fragment,e),Jt=!1},d(e){e&&(t(M),t(w),t(T),t(g),t(J),t(De),t(k),t(Ke),t(Oe),t(es),t(x),t(ss),t(B),t(ts),t(as),t(U),t(ls),t(ns),t(X),t(is),t(H),t(ps),t(_),t(rs),t(os),t(Y),t(cs),t(V),t(ms),t(hs),t(q),t(us),t(z),t(fs),t(ds),t(L),t(ys),t(gs),t(Q),t(ws),t(Ms),t(P),t(Ts),t(bs),t(D),t(js),t(Js),t(O),t($s),t(vs),t(se),t(Us),t(Zs),t(ae),t(Is),t(le),t(ks),t(Gs),t(ie),t(xs),t(pe),t(Bs),t(Ws),t(oe),t(Cs),t(Xs),t(me),t(Hs),t(he),t(_s),t(Rs),t(fe),t(Ys),t(Vs),t(ye),t(Ns),t(qs),t(we),t(zs),t(Me),t(Fs),t(Te),t(Ls),t(Ss),t(Qs),t(Es),t(Je),t(Ps),t(As),t(ve),t(Ds),t(Ue),t(Ks),t(Ze),t(Os),t(et),t(st),t(Ge),t(tt),t(at),t(lt),t(We),t(nt),t(Ce),t(it),t(pt),t(rt),t(ot),t(_e),t(ct),t(Re),t(mt),t(ht),t(Ve),t(ut),t(ft),t(qe),t(dt),t(yt),t(Fe),t(gt),t(wt),t(Se),t(Mt),t(Tt),t(Ee),t(bt),t(Pe),t(jt),t(Ae)),t(d),f(j,e),f(v,e),f(G,e),f(W,e),f(C,e),f(R,e),f(N,e),f(F,e),f(S,e),f(E,e),f(A,e),f(K,e),f(ee,e),f(te,e),f(ne,e),f(re,e),f(ce,e),f(ue,e),f(de,e),f(ge,e),f(be,e),f(je,e),f(Z,e),f($e,e),f(Ie,e),f(ke,e),f(xe,e),f(Be,e),f(Xe,e),f(I,e),f(He,e),f(Ye,e),f(Ne,e),f(ze,e),f(Le,e),f(Qe,e)}}}const Ca='{"title":"Pipelines for inference","local":"pipelines-for-inference","sections":[{"title":"Pipeline usage","local":"pipeline-usage","sections":[],"depth":2},{"title":"Parameters","local":"parameters","sections":[{"title":"Device","local":"device","sections":[],"depth":3},{"title":"Batch size","local":"batch-size","sections":[],"depth":3},{"title":"Task specific parameters","local":"task-specific-parameters","sections":[],"depth":3}],"depth":2},{"title":"Using pipelines on a dataset","local":"using-pipelines-on-a-dataset","sections":[],"depth":2},{"title":"Using pipelines for a webserver","local":"using-pipelines-for-a-webserver","sections":[],"depth":2},{"title":"Vision pipeline","local":"vision-pipeline","sections":[],"depth":2},{"title":"Text pipeline","local":"text-pipeline","sections":[],"depth":2},{"title":"Multimodal pipeline","local":"multimodal-pipeline","sections":[],"depth":2},{"title":"Using pipeline on large models with 🤗 accelerate :","local":"using-pipeline-on-large-models-with--accelerate-","sections":[],"depth":2},{"title":"Creating web demos from pipelines with gradio","local":"creating-web-demos-from-pipelines-with-gradio","sections":[],"depth":2}],"depth":1}';function Xa($){return Ja(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Na extends $a{constructor(d){super(),va(this,d,Xa,Wa,ja,{})}}export{Na as component};
