import{s as Fs,n as Ws,o as Ns}from"../chunks/scheduler.25b97de1.js";import{S as Zs,i as Qs,g as i,s as a,r as m,A as Es,h as p,f as l,c as n,j as $s,u as o,x as M,k as w,y as As,a as t,v as r,d as y,t as c,w as U}from"../chunks/index.d9030fc9.js";import{C as h}from"../chunks/CodeBlock.e6cd0d95.js";import{H as oe,E as Gs}from"../chunks/EditOnGithub.91d95064.js";function zs(as){let u,re,Me,ye,f,ce,C,ns=`Mask generation is the task of generating semantically meaningful masks for an image.
This task is very similar to <a href="semantic_segmentation">image segmentation</a>, but many differences exist. Image segmentation models are trained on labeled datasets and are limited to the classes they have seen during training; they return a set of masks and corresponding classes, given an image.`,Ue,k,is="Mask generation models are trained on large amounts of data and operate in two modes.",he,x,ps=`<li>Prompting mode: In this mode, the model takes in an image and a prompt, where a prompt can be a 2D point location (XY coordinates) in the image within an object or a bounding box surrounding an object. In prompting mode, the model only returns the mask over the object
that the prompt is pointing out.</li> <li>Segment Everything mode: In segment everything, given an image, the model generates every mask in the image. To do so, a grid of points is generated and overlaid on the image for inference.</li>`,ue,v,Ms='Mask generation task is supported by <a href="model_doc/sam">Segment Anything Model (SAM)</a>. It’s a powerful model that consists of a Vision Transformer-based image encoder, a prompt encoder, and a two-way transformer mask decoder. Images and prompts are encoded, and the decoder takes these embeddings and generates valid masks.',Je,J,ms='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sam.png" alt="SAM Architecture"/>',de,B,os=`SAM serves as a powerful foundation model for segmentation as it has large data coverage. It is trained on
<a href="https://ai.meta.com/datasets/segment-anything/" rel="nofollow">SA-1B</a>, a dataset with 1 million images and 1.1 billion masks.`,je,I,rs="In this guide, you will learn how to:",Te,$,ys="<li>Infer in segment everything mode with batching,</li> <li>Infer in point prompting mode,</li> <li>Infer in box prompting mode.</li>",be,F,cs="First, let’s install <code>transformers</code>:",ge,W,we,N,fe,Z,Us="The easiest way to infer mask generation models is to use the <code>mask-generation</code> pipeline.",Ce,Q,ke,E,hs="Let’s see the image.",xe,A,ve,d,us='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg" alt="Example Image"/>',Be,G,Js="Let’s segment everything. <code>points-per-batch</code> enables parallel inference of points in segment everything mode. This enables faster inference, but consumes more memory. Moreover, SAM only enables batching over points and not the images. <code>pred_iou_thresh</code> is the IoU confidence threshold where only the masks above that certain threshold are returned.",Ie,z,$e,H,ds="The <code>masks</code> looks like the following:",Fe,_,We,R,js="We can visualize them like this:",Ne,Y,Ze,V,Ts="Below is the original image in grayscale with colorful maps overlaid. Very impressive.",Qe,j,bs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee_segmented.png" alt="Visualized"/>',Ee,S,Ae,X,Ge,L,gs=`You can also use the model without the pipeline. To do so, initialize the model and
the processor.`,ze,D,He,q,ws=`To do point prompting, pass the input point to the processor, then take the processor output
and pass it to the model for inference. To post-process the model output, pass the outputs and
<code>original_sizes</code> and <code>reshaped_input_sizes</code> we take from the processor’s initial output. We need to pass these
since the processor resizes the image, and the output needs to be extrapolated.`,_e,K,Re,P,fs="We can visualize the three masks in the <code>masks</code> output.",Ye,O,Ve,T,Cs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/masks.png" alt="Visualized"/>',Se,ee,Xe,se,ks=`You can also do box prompting in a similar fashion to point prompting. You can simply pass the input box in the format of a list
<code>[x_min, y_min, x_max, y_max]</code> format along with the image to the <code>processor</code>. Take the processor output and directly pass it
to the model, then post-process the output again.`,Le,le,De,te,xs="You can visualize the bounding box around the bee as shown below.",qe,ae,Ke,b,vs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/bbox.png" alt="Visualized Bbox"/>',Pe,ne,Bs="You can see the inference output below.",Oe,ie,es,g,Is='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/box_inference.png" alt="Visualized Inference"/>',ss,pe,ls,me,ts;return f=new oe({props:{title:"Mask Generation",local:"mask-generation",headingTag:"h1"}}),W=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),N=new oe({props:{title:"Mask Generation Pipeline",local:"mask-generation-pipeline",headingTag:"h2"}}),Q=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmZhY2Vib29rJTJGc2FtLXZpdC1iYXNlJTIyJTBBbWFza19nZW5lcmF0b3IlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRGNoZWNrcG9pbnQlMkMlMjB0YXNrJTNEJTIybWFzay1nZW5lcmF0aW9uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_generator = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;mask-generation&quot;</span>)`,wrap:!1}}),A=new h({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGYmVlLmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1nX3VybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdykuY29udmVydCglMjJSR0IlMjIp",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/bee.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(img_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)`,wrap:!1}}),z=new h({props:{code:"bWFza3MlMjAlM0QlMjBtYXNrX2dlbmVyYXRvcihpbWFnZSUyQyUyMHBvaW50c19wZXJfYmF0Y2glM0QxMjglMkMlMjBwcmVkX2lvdV90aHJlc2glM0QwLjg4KQ==",highlighted:'masks = mask_generator(image, points_per_batch=<span class="hljs-number">128</span>, pred_iou_thresh=<span class="hljs-number">0.88</span>)',wrap:!1}}),_=new h({props:{code:"JTdCJ21hc2tzJyUzQSUyMCU1QmFycmF5KCU1QiU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMCUyMFRydWUlMkMlMjAlMjBUcnVlJTJDJTIwJTIwVHJ1ZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMCUyMFRydWUlMkMlMjAlMjBUcnVlJTJDJTIwJTIwVHJ1ZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMCUyMFRydWUlMkMlMjAlMjBUcnVlJTJDJTIwJTIwVHJ1ZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QkZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSUyQyUyMC4uLiUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjBGYWxzZSU1RCU1RCklMkMlMEElMjAlMjBhcnJheSglNUIlNUJGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAuLi4lMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAuLi4lMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlMkMlMjAuLi4lMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEEnc2NvcmVzJyUzQSUyMHRlbnNvciglNUIwLjk5NzIlMkMlMjAwLjk5MTclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElN0Q=",highlighted:`{<span class="hljs-string">&#x27;masks&#x27;</span>: [array([[False, False, False, ...,  True,  True,  True],
         [False, False, False, ...,  True,  True,  True],
         [False, False, False, ...,  True,  True,  True],
         ...,
         [False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False]]),
  array([[False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False],
         [False, False, False, ..., False, False, False],
         ...,
<span class="hljs-string">&#x27;scores&#x27;</span>: tensor([0.9972, 0.9917,
        ...,
}`,wrap:!1}}),Y=new h({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5pbXNob3coaW1hZ2UlMkMlMjBjbWFwJTNEJ2dyYXknKSUwQSUwQWZvciUyMGklMkMlMjBtYXNrJTIwaW4lMjBlbnVtZXJhdGUobWFza3MlNUIlMjJtYXNrcyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjBwbHQuaW1zaG93KG1hc2slMkMlMjBjbWFwJTNEJ3ZpcmlkaXMnJTJDJTIwYWxwaGElM0QwLjElMkMlMjB2bWluJTNEMCUyQyUyMHZtYXglM0QxKSUwQSUwQXBsdC5heGlzKCdvZmYnKSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.imshow(image, cmap=<span class="hljs-string">&#x27;gray&#x27;</span>)

<span class="hljs-keyword">for</span> i, mask <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(masks[<span class="hljs-string">&quot;masks&quot;</span>]):
    plt.imshow(mask, cmap=<span class="hljs-string">&#x27;viridis&#x27;</span>, alpha=<span class="hljs-number">0.1</span>, vmin=<span class="hljs-number">0</span>, vmax=<span class="hljs-number">1</span>)

plt.axis(<span class="hljs-string">&#x27;off&#x27;</span>)
plt.show()`,wrap:!1}}),S=new oe({props:{title:"Model Inference",local:"model-inference",headingTag:"h2"}}),X=new oe({props:{title:"Point Prompting",local:"point-prompting",headingTag:"h3"}}),D=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNhbU1vZGVsJTJDJTIwU2FtUHJvY2Vzc29yJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCdjdWRhJyUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAnY3B1JyklMEElMEFtb2RlbCUyMCUzRCUyMFNhbU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnNhbS12aXQtYmFzZSUyMikudG8oZGV2aWNlKSUwQXByb2Nlc3NvciUyMCUzRCUyMFNhbVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZzYW0tdml0LWJhc2UlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SamModel, SamProcessor

device = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)

model = SamModel.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>).to(device)
processor = SamProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/sam-vit-base&quot;</span>)`,wrap:!1}}),K=new h({props:{code:"aW5wdXRfcG9pbnRzJTIwJTNEJTIwJTVCJTVCJTVCMjU5MiUyQyUyMDE3MjglNUQlNUQlNUQlMjAlMjMlMjBwb2ludCUyMGxvY2F0aW9uJTIwb2YlMjB0aGUlMjBiZWUlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjBpbnB1dF9wb2ludHMlM0RpbnB1dF9wb2ludHMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFtYXNrcyUyMCUzRCUyMHByb2Nlc3Nvci5pbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX21hc2tzKG91dHB1dHMucHJlZF9tYXNrcy5jcHUoKSUyQyUyMGlucHV0cyU1QiUyMm9yaWdpbmFsX3NpemVzJTIyJTVELmNwdSgpJTJDJTIwaW5wdXRzJTVCJTIycmVzaGFwZWRfaW5wdXRfc2l6ZXMlMjIlNUQuY3B1KCkp",highlighted:`input_points = [[[<span class="hljs-number">2592</span>, <span class="hljs-number">1728</span>]]] <span class="hljs-comment"># point location of the bee</span>

inputs = processor(image, input_points=input_points, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)
masks = processor.image_processor.post_process_masks(outputs.pred_masks.cpu(), inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>].cpu(), inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>].cpu())`,wrap:!1}}),O=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBtYXRwbG90bGliLnB5cGxvdCUyMGFzJTIwcGx0JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZmlnJTJDJTIwYXhlcyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwNCUyQyUyMGZpZ3NpemUlM0QoMTUlMkMlMjA1KSklMEElMEFheGVzJTVCMCU1RC5pbXNob3coaW1hZ2UpJTBBYXhlcyU1QjAlNUQuc2V0X3RpdGxlKCdPcmlnaW5hbCUyMEltYWdlJyklMEFtYXNrX2xpc3QlMjAlM0QlMjAlNUJtYXNrcyU1QjAlNUQlNUIwJTVEJTVCMCU1RC5udW1weSgpJTJDJTIwbWFza3MlNUIwJTVEJTVCMCU1RCU1QjElNUQubnVtcHkoKSUyQyUyMG1hc2tzJTVCMCU1RCU1QjAlNUQlNUIyJTVELm51bXB5KCklNUQlMEElMEFmb3IlMjBpJTJDJTIwbWFzayUyMGluJTIwZW51bWVyYXRlKG1hc2tfbGlzdCUyQyUyMHN0YXJ0JTNEMSklM0ElMEElMjAlMjAlMjAlMjBvdmVybGF5ZWRfaW1hZ2UlMjAlM0QlMjBucC5hcnJheShpbWFnZSkuY29weSgpJTBBJTBBJTIwJTIwJTIwJTIwb3ZlcmxheWVkX2ltYWdlJTVCJTNBJTJDJTNBJTJDMCU1RCUyMCUzRCUyMG5wLndoZXJlKG1hc2slMjAlM0QlM0QlMjAxJTJDJTIwMjU1JTJDJTIwb3ZlcmxheWVkX2ltYWdlJTVCJTNBJTJDJTNBJTJDMCU1RCklMEElMjAlMjAlMjAlMjBvdmVybGF5ZWRfaW1hZ2UlNUIlM0ElMkMlM0ElMkMxJTVEJTIwJTNEJTIwbnAud2hlcmUobWFzayUyMCUzRCUzRCUyMDElMkMlMjAwJTJDJTIwb3ZlcmxheWVkX2ltYWdlJTVCJTNBJTJDJTNBJTJDMSU1RCklMEElMjAlMjAlMjAlMjBvdmVybGF5ZWRfaW1hZ2UlNUIlM0ElMkMlM0ElMkMyJTVEJTIwJTNEJTIwbnAud2hlcmUobWFzayUyMCUzRCUzRCUyMDElMkMlMjAwJTJDJTIwb3ZlcmxheWVkX2ltYWdlJTVCJTNBJTJDJTNBJTJDMiU1RCklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBheGVzJTVCaSU1RC5pbXNob3cob3ZlcmxheWVkX2ltYWdlKSUwQSUyMCUyMCUyMCUyMGF4ZXMlNUJpJTVELnNldF90aXRsZShmJ01hc2slMjAlN0JpJTdEJyklMEFmb3IlMjBheCUyMGluJTIwYXhlcyUzQSUwQSUyMCUyMCUyMCUyMGF4LmF4aXMoJ29mZicpJTBBJTBBcGx0LnNob3coKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

fig, axes = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, figsize=(<span class="hljs-number">15</span>, <span class="hljs-number">5</span>))

axes[<span class="hljs-number">0</span>].imshow(image)
axes[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">&#x27;Original Image&#x27;</span>)
mask_list = [masks[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">0</span>].numpy(), masks[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">1</span>].numpy(), masks[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">2</span>].numpy()]

<span class="hljs-keyword">for</span> i, mask <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(mask_list, start=<span class="hljs-number">1</span>):
    overlayed_image = np.array(image).copy()

    overlayed_image[:,:,<span class="hljs-number">0</span>] = np.where(mask == <span class="hljs-number">1</span>, <span class="hljs-number">255</span>, overlayed_image[:,:,<span class="hljs-number">0</span>])
    overlayed_image[:,:,<span class="hljs-number">1</span>] = np.where(mask == <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, overlayed_image[:,:,<span class="hljs-number">1</span>])
    overlayed_image[:,:,<span class="hljs-number">2</span>] = np.where(mask == <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, overlayed_image[:,:,<span class="hljs-number">2</span>])
    
    axes[i].imshow(overlayed_image)
    axes[i].set_title(<span class="hljs-string">f&#x27;Mask <span class="hljs-subst">{i}</span>&#x27;</span>)
<span class="hljs-keyword">for</span> ax <span class="hljs-keyword">in</span> axes:
    ax.axis(<span class="hljs-string">&#x27;off&#x27;</span>)

plt.show()`,wrap:!1}}),ee=new oe({props:{title:"Box Prompting",local:"box-prompting",headingTag:"h3"}}),le=new h({props:{code:"JTIzJTIwYm91bmRpbmclMjBib3glMjBhcm91bmQlMjB0aGUlMjBiZWUlMEFib3glMjAlM0QlMjAlNUIyMzUwJTJDJTIwMTYwMCUyQyUyMDI4NTAlMkMlMjAyMTAwJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfYm94ZXMlM0QlNUIlNUIlNUJib3glNUQlNUQlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBJTIwJTIwJTIwJTIwKS50byglMjJjdWRhJTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbWFzayUyMCUzRCUyMHByb2Nlc3Nvci5pbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX21hc2tzKCUwQSUyMCUyMCUyMCUyMG91dHB1dHMucHJlZF9tYXNrcy5jcHUoKSUyQyUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm9yaWdpbmFsX3NpemVzJTIyJTVELmNwdSgpJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTVCJTIycmVzaGFwZWRfaW5wdXRfc2l6ZXMlMjIlNUQuY3B1KCklMEEpJTVCMCU1RCU1QjAlNUQlNUIwJTVELm51bXB5KCk=",highlighted:`<span class="hljs-comment"># bounding box around the bee</span>
box = [<span class="hljs-number">2350</span>, <span class="hljs-number">1600</span>, <span class="hljs-number">2850</span>, <span class="hljs-number">2100</span>]

inputs = processor(
        image,
        input_boxes=[[[box]]],
        return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
    ).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)

mask = processor.image_processor.post_process_masks(
    outputs.pred_masks.cpu(),
    inputs[<span class="hljs-string">&quot;original_sizes&quot;</span>].cpu(),
    inputs[<span class="hljs-string">&quot;reshaped_input_sizes&quot;</span>].cpu()
)[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>][<span class="hljs-number">0</span>].numpy()`,wrap:!1}}),ae=new h({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5wYXRjaGVzJTIwYXMlMjBwYXRjaGVzJTBBJTBBZmlnJTJDJTIwYXglMjAlM0QlMjBwbHQuc3VicGxvdHMoKSUwQWF4Lmltc2hvdyhpbWFnZSklMEElMEFyZWN0YW5nbGUlMjAlM0QlMjBwYXRjaGVzLlJlY3RhbmdsZSgoMjM1MCUyQyUyMDE2MDAlMkMlMjA1MDAlMkMlMjA1MDAlMkMlMjBsaW5ld2lkdGglM0QyJTJDJTIwZWRnZWNvbG9yJTNEJ3InJTJDJTIwZmFjZWNvbG9yJTNEJ25vbmUnKSUwQWF4LmFkZF9wYXRjaChyZWN0YW5nbGUpJTBBYXguYXhpcyglMjJvZmYlMjIpJTBBcGx0LnNob3coKQ==",highlighted:`<span class="hljs-keyword">import</span> matplotlib.patches <span class="hljs-keyword">as</span> patches

fig, ax = plt.subplots()
ax.imshow(image)

rectangle = patches.Rectangle((<span class="hljs-number">2350</span>, <span class="hljs-number">1600</span>, <span class="hljs-number">500</span>, <span class="hljs-number">500</span>, linewidth=<span class="hljs-number">2</span>, edgecolor=<span class="hljs-string">&#x27;r&#x27;</span>, facecolor=<span class="hljs-string">&#x27;none&#x27;</span>)
ax.add_patch(rectangle)
ax.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.show()`,wrap:!1}}),ie=new h({props:{code:"ZmlnJTJDJTIwYXglMjAlM0QlMjBwbHQuc3VicGxvdHMoKSUwQWF4Lmltc2hvdyhpbWFnZSklMEFheC5pbXNob3cobWFzayUyQyUyMGNtYXAlM0QndmlyaWRpcyclMkMlMjBhbHBoYSUzRDAuNCklMEElMEFheC5heGlzKCUyMm9mZiUyMiklMEFwbHQuc2hvdygp",highlighted:`fig, ax = plt.subplots()
ax.imshow(image)
ax.imshow(mask, cmap=<span class="hljs-string">&#x27;viridis&#x27;</span>, alpha=<span class="hljs-number">0.4</span>)

ax.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.show()`,wrap:!1}}),pe=new Gs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/mask_generation.md"}}),{c(){u=i("meta"),re=a(),Me=i("p"),ye=a(),m(f.$$.fragment),ce=a(),C=i("p"),C.innerHTML=ns,Ue=a(),k=i("p"),k.textContent=is,he=a(),x=i("ul"),x.innerHTML=ps,ue=a(),v=i("p"),v.innerHTML=Ms,Je=a(),J=i("div"),J.innerHTML=ms,de=a(),B=i("p"),B.innerHTML=os,je=a(),I=i("p"),I.textContent=rs,Te=a(),$=i("ul"),$.innerHTML=ys,be=a(),F=i("p"),F.innerHTML=cs,ge=a(),m(W.$$.fragment),we=a(),m(N.$$.fragment),fe=a(),Z=i("p"),Z.innerHTML=Us,Ce=a(),m(Q.$$.fragment),ke=a(),E=i("p"),E.textContent=hs,xe=a(),m(A.$$.fragment),ve=a(),d=i("div"),d.innerHTML=us,Be=a(),G=i("p"),G.innerHTML=Js,Ie=a(),m(z.$$.fragment),$e=a(),H=i("p"),H.innerHTML=ds,Fe=a(),m(_.$$.fragment),We=a(),R=i("p"),R.textContent=js,Ne=a(),m(Y.$$.fragment),Ze=a(),V=i("p"),V.textContent=Ts,Qe=a(),j=i("div"),j.innerHTML=bs,Ee=a(),m(S.$$.fragment),Ae=a(),m(X.$$.fragment),Ge=a(),L=i("p"),L.textContent=gs,ze=a(),m(D.$$.fragment),He=a(),q=i("p"),q.innerHTML=ws,_e=a(),m(K.$$.fragment),Re=a(),P=i("p"),P.innerHTML=fs,Ye=a(),m(O.$$.fragment),Ve=a(),T=i("div"),T.innerHTML=Cs,Se=a(),m(ee.$$.fragment),Xe=a(),se=i("p"),se.innerHTML=ks,Le=a(),m(le.$$.fragment),De=a(),te=i("p"),te.textContent=xs,qe=a(),m(ae.$$.fragment),Ke=a(),b=i("div"),b.innerHTML=vs,Pe=a(),ne=i("p"),ne.textContent=Bs,Oe=a(),m(ie.$$.fragment),es=a(),g=i("div"),g.innerHTML=Is,ss=a(),m(pe.$$.fragment),ls=a(),me=i("p"),this.h()},l(e){const s=Es("svelte-u9bgzb",document.head);u=p(s,"META",{name:!0,content:!0}),s.forEach(l),re=n(e),Me=p(e,"P",{}),$s(Me).forEach(l),ye=n(e),o(f.$$.fragment,e),ce=n(e),C=p(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-11gpkf1"&&(C.innerHTML=ns),Ue=n(e),k=p(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1efgayb"&&(k.textContent=is),he=n(e),x=p(e,"UL",{"data-svelte-h":!0}),M(x)!=="svelte-110gnfy"&&(x.innerHTML=ps),ue=n(e),v=p(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-grokwa"&&(v.innerHTML=Ms),Je=n(e),J=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(J)!=="svelte-18bgtyc"&&(J.innerHTML=ms),de=n(e),B=p(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-siwu7f"&&(B.innerHTML=os),je=n(e),I=p(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1xy9go1"&&(I.textContent=rs),Te=n(e),$=p(e,"UL",{"data-svelte-h":!0}),M($)!=="svelte-1xdcdcm"&&($.innerHTML=ys),be=n(e),F=p(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1qvzz2d"&&(F.innerHTML=cs),ge=n(e),o(W.$$.fragment,e),we=n(e),o(N.$$.fragment,e),fe=n(e),Z=p(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-hy99c4"&&(Z.innerHTML=Us),Ce=n(e),o(Q.$$.fragment,e),ke=n(e),E=p(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-13rxk6q"&&(E.textContent=hs),xe=n(e),o(A.$$.fragment,e),ve=n(e),d=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(d)!=="svelte-5ac7qo"&&(d.innerHTML=us),Be=n(e),G=p(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-xsc4t1"&&(G.innerHTML=Js),Ie=n(e),o(z.$$.fragment,e),$e=n(e),H=p(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-rg5py"&&(H.innerHTML=ds),Fe=n(e),o(_.$$.fragment,e),We=n(e),R=p(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1kbs52p"&&(R.textContent=js),Ne=n(e),o(Y.$$.fragment,e),Ze=n(e),V=p(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-b8wd3m"&&(V.textContent=Ts),Qe=n(e),j=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(j)!=="svelte-1xv3qg"&&(j.innerHTML=bs),Ee=n(e),o(S.$$.fragment,e),Ae=n(e),o(X.$$.fragment,e),Ge=n(e),L=p(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-kmstl8"&&(L.textContent=gs),ze=n(e),o(D.$$.fragment,e),He=n(e),q=p(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-kaodbx"&&(q.innerHTML=ws),_e=n(e),o(K.$$.fragment,e),Re=n(e),P=p(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-zoqnl5"&&(P.innerHTML=fs),Ye=n(e),o(O.$$.fragment,e),Ve=n(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(T)!=="svelte-od5m1y"&&(T.innerHTML=Cs),Se=n(e),o(ee.$$.fragment,e),Xe=n(e),se=p(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-1hby767"&&(se.innerHTML=ks),Le=n(e),o(le.$$.fragment,e),De=n(e),te=p(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-n8en77"&&(te.textContent=xs),qe=n(e),o(ae.$$.fragment,e),Ke=n(e),b=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(b)!=="svelte-12t8f97"&&(b.innerHTML=vs),Pe=n(e),ne=p(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-mexiag"&&(ne.textContent=Bs),Oe=n(e),o(ie.$$.fragment,e),es=n(e),g=p(e,"DIV",{class:!0,"data-svelte-h":!0}),M(g)!=="svelte-1inger9"&&(g.innerHTML=Is),ss=n(e),o(pe.$$.fragment,e),ls=n(e),me=p(e,"P",{}),$s(me).forEach(l),this.h()},h(){w(u,"name","hf:doc:metadata"),w(u,"content",Hs),w(J,"class","flex justify-center"),w(d,"class","flex justify-center"),w(j,"class","flex justify-center"),w(T,"class","flex justify-center"),w(b,"class","flex justify-center"),w(g,"class","flex justify-center")},m(e,s){As(document.head,u),t(e,re,s),t(e,Me,s),t(e,ye,s),r(f,e,s),t(e,ce,s),t(e,C,s),t(e,Ue,s),t(e,k,s),t(e,he,s),t(e,x,s),t(e,ue,s),t(e,v,s),t(e,Je,s),t(e,J,s),t(e,de,s),t(e,B,s),t(e,je,s),t(e,I,s),t(e,Te,s),t(e,$,s),t(e,be,s),t(e,F,s),t(e,ge,s),r(W,e,s),t(e,we,s),r(N,e,s),t(e,fe,s),t(e,Z,s),t(e,Ce,s),r(Q,e,s),t(e,ke,s),t(e,E,s),t(e,xe,s),r(A,e,s),t(e,ve,s),t(e,d,s),t(e,Be,s),t(e,G,s),t(e,Ie,s),r(z,e,s),t(e,$e,s),t(e,H,s),t(e,Fe,s),r(_,e,s),t(e,We,s),t(e,R,s),t(e,Ne,s),r(Y,e,s),t(e,Ze,s),t(e,V,s),t(e,Qe,s),t(e,j,s),t(e,Ee,s),r(S,e,s),t(e,Ae,s),r(X,e,s),t(e,Ge,s),t(e,L,s),t(e,ze,s),r(D,e,s),t(e,He,s),t(e,q,s),t(e,_e,s),r(K,e,s),t(e,Re,s),t(e,P,s),t(e,Ye,s),r(O,e,s),t(e,Ve,s),t(e,T,s),t(e,Se,s),r(ee,e,s),t(e,Xe,s),t(e,se,s),t(e,Le,s),r(le,e,s),t(e,De,s),t(e,te,s),t(e,qe,s),r(ae,e,s),t(e,Ke,s),t(e,b,s),t(e,Pe,s),t(e,ne,s),t(e,Oe,s),r(ie,e,s),t(e,es,s),t(e,g,s),t(e,ss,s),r(pe,e,s),t(e,ls,s),t(e,me,s),ts=!0},p:Ws,i(e){ts||(y(f.$$.fragment,e),y(W.$$.fragment,e),y(N.$$.fragment,e),y(Q.$$.fragment,e),y(A.$$.fragment,e),y(z.$$.fragment,e),y(_.$$.fragment,e),y(Y.$$.fragment,e),y(S.$$.fragment,e),y(X.$$.fragment,e),y(D.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(ae.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),ts=!0)},o(e){c(f.$$.fragment,e),c(W.$$.fragment,e),c(N.$$.fragment,e),c(Q.$$.fragment,e),c(A.$$.fragment,e),c(z.$$.fragment,e),c(_.$$.fragment,e),c(Y.$$.fragment,e),c(S.$$.fragment,e),c(X.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),ts=!1},d(e){e&&(l(re),l(Me),l(ye),l(ce),l(C),l(Ue),l(k),l(he),l(x),l(ue),l(v),l(Je),l(J),l(de),l(B),l(je),l(I),l(Te),l($),l(be),l(F),l(ge),l(we),l(fe),l(Z),l(Ce),l(ke),l(E),l(xe),l(ve),l(d),l(Be),l(G),l(Ie),l($e),l(H),l(Fe),l(We),l(R),l(Ne),l(Ze),l(V),l(Qe),l(j),l(Ee),l(Ae),l(Ge),l(L),l(ze),l(He),l(q),l(_e),l(Re),l(P),l(Ye),l(Ve),l(T),l(Se),l(Xe),l(se),l(Le),l(De),l(te),l(qe),l(Ke),l(b),l(Pe),l(ne),l(Oe),l(es),l(g),l(ss),l(ls),l(me)),l(u),U(f,e),U(W,e),U(N,e),U(Q,e),U(A,e),U(z,e),U(_,e),U(Y,e),U(S,e),U(X,e),U(D,e),U(K,e),U(O,e),U(ee,e),U(le,e),U(ae,e),U(ie,e),U(pe,e)}}}const Hs='{"title":"Mask Generation","local":"mask-generation","sections":[{"title":"Mask Generation Pipeline","local":"mask-generation-pipeline","sections":[],"depth":2},{"title":"Model Inference","local":"model-inference","sections":[{"title":"Point Prompting","local":"point-prompting","sections":[],"depth":3},{"title":"Box Prompting","local":"box-prompting","sections":[],"depth":3}],"depth":2}],"depth":1}';function _s(as){return Ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xs extends Zs{constructor(u){super(),Qs(this,u,_s,zs,Fs,{})}}export{Xs as component};
