import os
import glob

def count_lines_in_jsonl_files(folder_path):
    # Pattern to match the specific filenames
    file_pattern = os.path.join(folder_path, "explain_dataset??_strategy.jsonl")
    
    total_lines = 0
    
    # Iterate through all matching files
    for file_path in glob.glob(file_pattern):
        with open(file_path, 'r') as file:
            # Count lines in the current file
            line_count = sum(1 for line in file)
            total_lines += line_count
            print(f"File: {os.path.basename(file_path)}, Lines: {line_count}")
    
    return total_lines

# Specify the folder path where the JSONL files are located
folder_path = "/Users/PC/Desktop/UCLA2024FALL/NAACL/dataset/strategy"  # Replace this with the actual path

# Call the function and print the result
total_lines = count_lines_in_jsonl_files(folder_path)
print(f"\nTotal number of lines across all files: {total_lines}")