import chess
import chess.engine
import random
# engine = chess.engine.SimpleEngine.popen_uci("/usr/games/stockfish")

### king safety

### attack the enemy king, threaten its safety
### sacrifice a piece to open a file or diagonal to the enemy king, it is a threat to the enemy king
 
### move a piece to protect own king, it is a defense to own king
def kingsafety(input_board = "r1bqkbnr/pp2pppp/2p5/3pn2Q/3PPP2/8/PPP3PP/RNB1KBNR w KQkq - 0 5"):
    
    language_explanation_protect = \
    ['Shift the piece to shield the king and anticipate a potential attack from the opposing side.',
    'Position the piece to safeguard its king while countering the opponent\'s possible threats.',
    'Relocate the piece to defend its king and ward off an impending attack from the rival.',
    'Move the chessman to ensure the king\'s protection and neutralize the threat from the adversary.',
    'Place the piece to secure the king and guard against the opponent\'s looming strike.',
    'Advance the piece to hold the king safe and mitigate any forthcoming assault from the challenger.',
    'Deploy the piece to defend its king and foil the potential offensive from the competitor.',
    'Maneuver the piece to protect the king and preempt any attack from the opposition.',
    'Shift the piece to safeguard the king and defend against the rival\'s imminent attack.',
    'Move the chess piece to reinforce the king\'s safety and block the opponent\'s prospective attack.',
    'Position the piece to shield the king while counteracting the adversary\'s anticipated move.',
    'Transfer the piece to secure its king and fend off any attacks from the opponent.',
    'Advance the piece to guard its king and avert the rival\'s impending assault.',
    'Relocate the piece to defend the king and neutralize the opposing player\'s potential threat.',
    'Move the piece into place to protect the king and handle the competitor\'s forthcoming attack.',
    'Set the piece to ensure the king\'s safety and counter the opponent\'s possible attack.',
    'Deploy the piece strategically to shield its king from an opponent\'s likely strike.',
    'Maneuver the piece to secure the king and thwart any emerging attacks from the challenger.',
    'Shift the piece to brace its king and preclude any potential offensive from the opposition.',
    'Position the piece to fortify the king and intercept the rival\'s likely assault.'
    ]

    language_explanation_sacrifice = \
    [ f'Give up a piece to open a path or line near the opponent\'s king',
    f'Offer a piece to clear a file or diagonal close to the enemy king',
    f'Surrender a piece to create an open file or diagonal near the opposing king',
    f'Sacrifice a piece to clear a file or diagonal adjacent to the enemy king',
    f'Lose a piece to create an opening on a file or diagonal near the rival king',
    f'Remove a piece to free up a file or diagonal close to the enemy king',
    f'Sacrifice a piece to unlock a file or diagonal in proximity to the opposing king',
    f'Give up a piece to gain access to a file or diagonal near the enemy king',
    f'Offer a piece to open a file or diagonal adjacent to the opposing king',
    f'Surrender a piece to free a path or diagonal near the rival king',
    f'Sacrifice a piece to break open a file or diagonal close to the enemy king',
    f'Exchange a piece to open up a file or diagonal near the opponent\'s king',
    f'Sacrifice a piece to pry open a file or diagonal near the enemy king',
    f'Give away a piece to clear a path or diagonal near the opponent\'s king',
    f'Offer a piece to unblock a file or diagonal around the enemy king',
    f'Surrender a piece to establish an open file or diagonal near the rival king',
    f'Sacrifice a piece to carve open a file or diagonal close to the enemy king',
    f'Lose a piece to clear a line or diagonal near the opposing king',
    f'Sacrifice a piece to open a channel or diagonal near the opponent\'s king',
    f'Give up a piece to create an open pathway or diagonal near the enemy king'
    ]

    language_explanation_attack = \
    [
    'Assault the opposing king, endanger its security.',
    'Target the rival king, jeopardize its safety.',
    'Launch an offensive on the enemy king, put its safety at risk.',
    'Challenge the enemy king, compromise its safety.',
    'Strike at the adversary king, menace its safety.',
    'Advance on the enemy king, imperil its security.',
    'Engage the enemy king, threaten its protection.',
    'Launch an attack on the enemy king, risk its safety.',
    'Confront the opponent\'s king, endanger its defense.',
    'Harass the enemy king, undermine its safety.',
    'Move against the rival king, jeopardize its security.',
    'Press the attack on the enemy king, threaten its well-being.',
    'Mount an assault on the enemy king, challenge its safety.',
    'Conduct an offensive against the enemy king, threaten its security.',
    'Direct your forces towards the enemy king, compromise its defense.',
    'Target the opposing king, put its safety in jeopardy.',
    'Make a move on the enemy king, endanger its security.',
    'Focus your attack on the enemy king, risk its protection.',
    'Advance your pieces against the enemy king, threaten its defense.',
    'Close in on the enemy king, challenge its safety.'
    ]


    board = chess.Board(input_board)
    list_move = []
    for move in board.legal_moves:
        
        # print(move.uci())
        s1 = move.from_square
        s2 = move.to_square
        name_s1 = chess.square_name(s1)
        name_s2 = chess.square_name(s2)
        # print(s1)
        p1 = chess.piece_name(board.piece_type_at(s1)) 
        color_p1 = "white" if board.color_at(s1) == chess.WHITE else "black"
        # print(p1 + ' ' + color_p1 + ' '+ chess.square_name(s1))
        
        # if board.gives_check(move):
        #     print(move.uci())
        #     exp = random.choice(language_explanation_attack)
        #     print(exp)
        
        own_king_square = (board.pieces(chess.KING,  board.color_at(s1))).pop()
        # print(chess.square_name(own_king_square.pop()))
        enemy_king_square = (board.pieces(chess.KING,  not board.color_at(s1))).pop()
        # print(chess.square_name(enemy_king_square.pop()))
        # break
        
        # if p1 != "king" and p1 != "pawn":
        #     if chess.square_distance(s2, own_king_square) < 3 and chess.square_distance(s2, own_king_square) <= chess.square_distance(s1, own_king_square):
        #         print(move.uci())
        #         exp = random.choice(language_explanation_protect)
        #         print(exp)
                
        if board.piece_type_at(s2) == None:
            continue
        p2 = chess.piece_name(board.piece_type_at(s2)) 
        if p1 != 'pawn' and p1 != 'king' and p2 == 'pawn':
            if chess.square_distance(s2, enemy_king_square) < 2: 
                # print(move.uci())
                exp = random.choice(language_explanation_sacrifice)
                list_move.append((move, exp)) 
        
    return list_move

# engine.quit()