import chess
import chess.engine
import random
# engine = chess.engine.SimpleEngine.popen_uci("/usr/games/stockfish")

### material count
###  
### count the total value of pieces for each color
### the total value of pieces for each color is the sum of the value of each piece
### the value of each piece is:
### pawn = 1
### knight = 3
### bishop = 3
### rook = 5
### queen = 9
###  when total value of pieces for white is higher than black, white has an advantage
###  when total value of pieces for black is higher than white, black has an advantage
###  when total value of pieces for white is equal to black, the game is balanced
###  in a balanced game, the player trade pieces with same value, aiming to simplify the game, fighting for a draw
###  in a game where a player has an advantage, the player trade pieces with the same value, aiming to simplify the game, fighting for a winnable endgame
###  in a game where a player has a disadvantage, it is not good for the player to trade pieces with same value, 
###  trading pieces with higher value is a good strategy to achieve advantage

### a move is trading with a piece of the same value or higher value, 

### trade the smaller value piece with the higher value piece, gain an advantage

def get_piece_value(piece):
    piece_value = {
        "pawn": 1,
        "knight": 3,
        "bishop": 3,
        "rook": 5,
        "queen": 9,
        "king": 0
    }
    return piece_value[piece]

def materialcount(input_board = "r1bqkbnr/pppppppp/8/4n3/3PP3/8/PPP2PPP/RNBQKBNR w KQkq - 1 3"): 

    board = chess.Board(input_board)

    language_explanation_tradeforhigher = \
    [
    'Swap the lesser piece for a greater one to gain an advantage.',
    'Exchange the lower value piece for a higher value piece, and gain an edge.',
    'Replace the lower-value piece with a more valuable one to secure an advantage.',
    'Trade a minor piece for a major piece to gain strategic leverage.',
    'Switch the lower-value piece with a higher-value one for an advantage.',
    'Trade your smaller piece for your opponent\'s bigger piece to gain an upper hand.',
    'Replace a less valuable piece with a more valuable one to gain the upper hand.',
    'Exchange a lower-valued piece for a more valuable one, and secure an advantage.',
    'Trade a lesser piece for a higher-value piece to gain a positional advantage.',
    'Replace the smaller piece with a higher-value one, gaining a strategic edge.',
    'Exchange a minor piece for a major one, and gain a tactical advantage.',
    'Swap a lower-value piece for a higher-value one to gain the advantage.',
    'Trade your lesser piece for a more valuable piece to gain benefit.',
    'Replace a smaller piece with a higher-value piece to gain a positional edge.',
    'Exchange the low-value piece with a high-value piece, gaining an advantage.',
    'Trade the minor piece for a major piece, and secure an advantage.',
    'Switch a lower value piece with a higher value piece, to gain an advantage.',
    'Exchange the piece of lesser value for one of greater value to get ahead.',
    'Trade a lower-value piece for one of higher value to gain the upper hand.',
    'Replace a smaller valued piece with a higher valued one for an advantageous position.'
    ]
    list_move = []
    for move in board.legal_moves:
        
        # if move.from_square == chess.D4 and move.to_square == chess.E5:
        #     print(move)
        #     print(chess.piece_name(board.piece_type_at(move.to_square)) )
        # print(move.uci())
        s1 = move.from_square
        s2 = move.to_square
        name_s1 = chess.square_name(s1)
        name_s2 = chess.square_name(s2)
        # print(s1)
        p1 = chess.piece_name(board.piece_type_at(s1)) 
        color_p1 = "white" if board.color_at(s1) == chess.WHITE else "black"
        # print(p1 + ' ' + color_p1 + ' '+ chess.square_name(s1)) 
        
        if board.piece_type_at(s2) == None:
            continue
        
        p2 = chess.piece_name(board.piece_type_at(s2))
        color_p2 = "white" if board.color_at(s2) == chess.WHITE else "black"
        value1 = get_piece_value(p1)
        value2 = get_piece_value(p2)
        if value1 < value2:
            # print(p1 + ' ' + color_p1 + ' '+ chess.square_name(s1) + ' ' + move.uci())
            exp = random.choice(language_explanation_tradeforhigher)
            list_move.append((move, exp))
    return list_move             

# engine.quit()