import chess
import chess.engine
import random
# engine = chess.engine.SimpleEngine.popen_uci("/usr/games/stockfish")

### pawn structure 
###  a pawn takes another pawn, the pawn structure is changed

def pawnstructure(input_board = "r1bqkbnr/ppp1pppp/8/3pn3/3PPP2/8/PPP3PP/RNBQKBNR w KQkq - 0 4"):
 

    language_explanation = \
    [
    f'The pawn captures another pawn, altering the pawn structure.',
    f'A pawn captures another, modifying the pawn structure.',
    f'One pawn takes another, changing the formation of pawns.',
    f'The pawn seizes another pawn, affecting the pawn arrangement.',
    f'The pawn captures its counterpart, changing the structural layout.',
    f'A pawn overtakes another, restructuring the pawn formation.',
    f'The pawn eliminates another pawn, shifting the pawn structure.',
    f'Capturing another pawn, the pawn transforms the structure.',
    f'A pawn removes another, adjusting the pawn arrangement.',
    f'The pawn\'s move captures its opponent, altering the structure.',
    f'One pawn captures another, revising the pawn setup.',
    f'Another pawn is taken, resulting in a changed pawn structure.',
    f'Capturing another, the pawn changes the overall pawn structure.',
    f'A pawn takes its rival, modifying the pawn setup.',
    f'The pawn capture alters the arrangement of other pawns.',
    f'A capture by the pawn changes the pawn lineup.',
    f'The pawn\'s capture reshapes the pawn structure.',
    f'A pawn\'s move results in another pawn being taken, altering the structure.',
    f'By capturing another pawn, the pawn changes the formation.',
    f'The pawn\'s capture of another pawn modifies the structure.'
    
    ]
    board = chess.Board(input_board)
    list_move = []
    for move in board.legal_moves:
        
        # print(move.uci())
        s1 = move.from_square
        s2 = move.to_square
        name_s1 = chess.square_name(s1)
        name_s2 = chess.square_name(s2)
        # print(s1)
        p1 = chess.piece_name(board.piece_type_at(s1)) 
        color_p1 = "white" if board.color_at(s1) == chess.WHITE else "black"
        # print(p1 + ' ' + color_p1 + ' '+ chess.square_name(s1))
        
        if board.piece_type_at(s2) == None:
            continue
        
        p2 = chess.piece_name(board.piece_type_at(s2))
        if p1 == "pawn" and p2 == "pawn":
            # print(p1 + ' ' + color_p1 + ' '+ chess.square_name(s1) + ' ' + move.uci())
            exp = random.choice(language_explanation)
            list_move.append((move, exp)) 
        
    return list_move
# engine.quit()