import chess
import chess.engine
import random
# engine = chess.engine.SimpleEngine.popen_uci("/usr/games/stockfish")

### piece activity 

### active pieces are pieces that have more freedom to move, they have more control over the board
### active pieces are usually in the center of the board, they are closer to the enemy's side

def more_active(start_square, end_square, color):
    file_start = start_square[0]
    rank_start = start_square[1]    
    file_end = end_square[0]
    rank_end = end_square[1]
    if file_start == 'a':
        if file_end == 'b' or file_end == 'c' or file_end == 'd' or file_end == 'e' or file_end == 'f': 
            return True
    if file_start == 'b':
        if file_end == 'c' or file_end == 'd' or file_end == 'e' or file_end == 'f':
            return True
    if file_start == 'c':
        if file_end == 'd' or file_end == 'e':
            return True
    if file_start == 'f':
        if file_end == 'd' or file_end == 'e':
            return True
    if file_start == 'g':
        if file_end == 'c' or file_end == 'd' or file_end == 'e' or file_end == 'f': 
            return True
    if file_start == 'h':
        if file_end == 'c' or file_end == 'd' or file_end == 'e' or file_end == 'f' or file_end == 'g':
            return True
    if color == "white":
        if rank_end > rank_start:
            return True
    if color == "black":
        if rank_end < rank_start:
            return True
    return False

def pieceactivity(input_board = "r1bqkbnr/pppppppp/8/4n3/3PP3/8/PPP2PPP/RNBQKBNR w KQkq - 1 3"):

    
    language_explanation = \
    [f'Relocate the piece to a dynamic square, it\'s more influential on the board.',
    f'Position the piece more actively, giving it greater board command.',
    f'Move the piece to an aggressive spot, enhancing its control over the board.',
    f'Shift the piece to a proactive position, where it exerts more influence.',
    f'Redeploy the piece to a vibrant location, increasing its board dominance.',
    f'Advance the piece to a strategic square, optimizing its control over the board.',
    f'Transfer the piece to a lively area, boosting its impact on the board.',
    f'Settle the piece in a more energetic spot, where it has better board supervision.',
    f'Place the piece in a commanding position, maximizing its control on the board.',
    f'Reposition the piece to an assertive square, where it governs more of the board.',
    f'Move the piece to a stronger position, enhancing its board control.',
    f'Switch the piece to a more advantageous place, increasing its mastery over the board.',
    f'Set the piece in a more potent location, giving it superior board control.',
    f'Navigate the piece to an advanced spot, augmenting its influence over the board.',
    f'Displace the piece to a more promising position, strengthening its board authority.',
    f'Adjust the piece to a key area, where it holds more influence over the board.',
    f'Marshall the piece to a better square, extending its control over the board.',
    f'Move the piece to a pivotal position, providing it with greater board command.',
    f'Plant the piece in a dominant spot, expanding its control over the board.',
    f'Reassign the piece to a central area, where it exercises more control over the board.'
    ]


    list_move = []
    board = chess.Board(input_board)

    for move in board.legal_moves:
        
        # print(move.uci())
        s1 = move.from_square
        s2 = move.to_square
        name_s1 = chess.square_name(s1)
        name_s2 = chess.square_name(s2)
        # print(s1, name_s1)
        # print(s1)
        p1 = chess.piece_name(board.piece_type_at(s1)) 
        color_p1 = "white" if board.color_at(s1) == chess.WHITE else "black"
        
        
        # print(board.piece_type_at(s2))
        if board.piece_type_at(s2) == None:
            if p1 != "pawn":
                if more_active(name_s1, name_s2, color_p1):
                    # print(p1 + ' ' + color_p1 + ' '+ chess.square_name(s1) + ' ' + move.uci())
                    exp = random.choice(language_explanation)
                    list_move.append((move, exp)) 
                    
    return list_move
        
# engine.quit()