import chess
import chess.engine
import random
# engine = chess.engine.SimpleEngine.popen_uci("/usr/games/stockfish")

### space 
### enlarging space usually happen in any period of the game, openning, middle game, end game.
### the most significant indicator is that a pawn moves forward

### white/black pawn moves foward, create more space on the queenside/kingside/center,
### white/black can control more freedom to move the pieces"

def space(input_board = "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"):

    board = chess.Board(input_board)
    list_move = []
    
    for move in board.legal_moves:
        
        # print(move.uci())
        s1 = move.from_square
        s2 = move.to_square
        name_s1 = chess.square_name(s1)
        name_s2 = chess.square_name(s2)
        # print(s1)
        p1 = chess.piece_name(board.piece_type_at(s1)) 
        color_p1 = "white" if board.color_at(s1) == chess.WHITE else "black"
        # print(p1 + ' ' + color_p1 + ' '+ chess.square_name(s1))
        if p1 == "pawn" :
            if name_s1[0] == name_s2[0]:
                
                color_choice = color_p1
                
                if name_s1[0] == 'a' or name_s1[0] == 'b' or name_s1[0] == 'c':
                    section_choice = "queenside"
                elif name_s1[0] == 'd' or name_s1[0] == 'e':
                    section_choice = "center"
                else:
                    section_choice = "kingside"
                
                language_explanation = \
                [f'When a {color_choice} pawn advances, it creates more space on the {section_choice}, allowing for greater movement of pieces.',
                f'By pushing a {color_choice} pawn forward, it opens up the {section_choice}, granting more freedom to maneuver other pieces.',
                f'Advancing a {color_choice} pawn enhances space on the {section_choice} and offers better control for piece movement.',
                f'A forward-moving {color_choice} pawn expands the area on the {section_choice}, providing increased liberty for other pieces.',
                f'When a {color_choice} pawn moves ahead, it enlarges the {section_choice}, allowing for more versatile piece movement.',
                f'Shifting a {color_choice} pawn forward broadens the {section_choice}, enabling more strategic piece relocation.',
                f'The movement of a {color_choice} pawn creates additional room on the {section_choice}, giving {color_choice} more control over piece movement.',
                f'By advancing a {color_choice} pawn, additional space on the {section_choice} is created, permitting more dynamic piece movement.',
                f'Pushing a {color_choice} pawn forward opens up more space on the {section_choice}, facilitating freer piece movement.',
                f'A {color_choice} pawn\'s forward movement makes the {section_choice} more spacious, increasing the freedom to maneuver pieces.',
                f'When a {color_choice} pawn advances, it widens the {section_choice}, allowing {color_choice} greater liberty in moving pieces.',
                f'Advancing a {color_choice} pawn results in more space on the {section_choice}, enhancing the potential for piece mobility.',
                f'Moving a {color_choice} pawn forward expands the {section_choice}, offering more avenues for piece movement.',
                f'A push from a {color_choice} pawn generates extra space on the {section_choice}, providing better control over piece movement.',
                f'With a {color_choice} pawn moving ahead, additional space is created on the {section_choice}, allowing for more dynamic piece motion.',
                f'Advancing a {color_choice} pawn clears more area on the {section_choice}, granting {color_choice} increased control over the board.',
                f'A forward move by a {color_choice} pawn opens up the {section_choice}, resulting in greater freedom to reposition pieces.',
                f'When a {color_choice} pawn pushes forward, it creates more room on the {section_choice}, facilitating easier piece movement.',
                f'By moving a {color_choice} pawn forward, the {section_choice} becomes more spacious, offering more opportunities to move pieces freely.',
                f'A {color_choice} pawn advance creates added space on the {section_choice}, giving {color_choice} the ability to maneuver pieces with greater freedom.'
                ]
                
                exp = random.choice(language_explanation)
                list_move.append((move, exp)) 
    return list_move
# engine.quit()