%%
%% This is file `revtex4.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% revtex4.dtx  (with options: `class-pre')
%% ltxutil.dtx  (with options: `ltxutil-krn')
%% ltxgrid.dtx  (with options: `ltxgrid-krn')
%% revtex4.dtx  (with options: `class-pst')
%% 
%% This file is part of the APS files in the REVTeX 4 distribution.
%% For the version number, search on the string 
%% Original version by David Carlisle
%% Modified by Arthur Ogawa (mailto:ogawa@teleport.com)
%% 
%% Copyright (c) 1999 The American Physical Society.
%% http://publish.aps.org/revtex4/
%% mailto:revtex4@aps.org
%% 
%% See the REVTeX 4 README file for restrictions and more information.
%% 
\NeedsTeXFormat{LaTeX2e}[1996/06/01]
\ProvidesClass{revtex4}
          [2000/05/19 v4.0beta4 RevTeX class (DPC,AO,APS)]%FileInfo
\def\class@name{revtex4}%
\if@compatibility
  \edef\reserved@a{\errhelp{%
   Change your \string\documentstyle\space statement to
   \string\documentclass\space and rerun.
  }}\reserved@a
  \errmessage{You cannot run \class@name\space in compatability mode}%
  \expandafter\@@end
\fi
\typeout{%
 ltxutil: portions licensed from W. E. Baxter (web@superscript.com)%
}%
\def\class@err#1{\ClassError{\class@name}{#1}\@eha}%
\def\class@warn#1{\ClassWarningNoLine{\class@name}{#1}}%
\def\class@info#1{\ClassInfo{\class@name}{#1}}%
\def\obsolete@command#1{%
 \class@warn@end{Command \string#1\space is obsolete.^^JPlease remove from your document}%
 \global\let#1\@empty
 #1%
}%
\def\replace@command#1#2{%
 \class@warn@end{Command \string#1\space is obsolete;^^JUse \string#2\space instead}%
 \global\let#1#2%
 #1%
}%
\def\replace@environment#1#2{%
 \class@warn@end{Environment #1 is obsolete;^^JUse #2 instead}%
 \glet@environment{#1}{#2}%
 \@nameuse{#1}%
}%
\def\incompatible@package#1{%
 \@ifpackageloaded{#1}{%
  \def\@tempa{I cannot continue. You must remove the \string\usepackage\ statement that caused that package to be loaded.}%
  \ClassError{\class@name}{The #1 package cannot be used with \class@name}%
  \@tempa\stop
 }{%
  \class@info{#1 was not loaded (OK!)}%
 }%
}%
\def\class@warn@end#1{%
 \gappdef\class@enddocumenthook{\class@warn{#1}}%
}%
\AtEndOfClass{%
 \@ifxundefined\class@name{\def\class@name{Generic Class}}{}%
}%
\def\halignt@{\halign to}%
\chardef\f@ur=4\relax
\chardef\other=12\relax
\def\let@environment#1#2{%
 \expandafter\let
 \csname#1\expandafter\endcsname\csname#2\endcsname
 \expandafter\let
 \csname end#1\expandafter\endcsname\csname end#2\endcsname
}%
\def\glet@environment#1#2{%
 \global\expandafter\let
 \csname#1\expandafter\endcsname\csname#2\endcsname
 \global\expandafter\let
 \csname end#1\expandafter\endcsname\csname end#2\endcsname
}%
\newcommand\tracingplain{%
 \tracingonline\z@\tracingcommands\z@\tracingstats\z@
 \tracingpages\z@\tracingoutput\z@\tracinglostchars\@ne
 \tracingmacros\z@\tracingparagraphs\z@\tracingrestores\z@
 \showboxbreadth5\showboxdepth3\relax %\errorstopmode
 }%
\newcommand\traceoutput{%
 \appdef\@resetactivechars{\showoutput}%
}%
\newcommand\say[1]{\typeout{<\noexpand#1=\meaning#1>}}%
\newcommand\saythe[1]{\typeout{<\noexpand#1=\the#1>}}%
\long\def\prepdef#1#2{%
 \@ifxundefined#1{\toks@{}}{\toks@\expandafter{#1}}%
 \toks@ii{#2}%
 \edef#1{\the\toks@ii\the\toks@}%
}%
\long\def\appdef#1#2{%
 \@ifxundefined#1{\toks@{}}{\toks@\expandafter{#1}}%
 \toks@ii{#2}%
 \edef#1{\the\toks@\the\toks@ii}%
}%
\long\def\gappdef#1#2{%
 \@ifxundefined#1{\toks@{}}{\toks@\expandafter{#1}}%
 \toks@ii{#2}%
 \global\edef#1{\the\toks@\the\toks@ii}%
}%
\long\def\appdef@val#1#2{%
 \appdef#1{{#2}}%
}%
\long\def\appdef@e#1#2{%
 \expandafter\appdef
 \expandafter#1%
 \expandafter{#2}%
}%
\long\def\appdef@eval#1#2{%
 \expandafter\appdef@val
 \expandafter#1%
 \expandafter{#2}%
}%
\toksdef\toks@ii=\tw@
\long\def\@ifxundefined#1{\@ifx{\undefined#1}}%
\long\def\@ifnotrelax#1#2#3{\@ifx{\relax#1}{#3}{#2}}%
\long\def\@argswap#1#2{#2#1}%
\long\def\@argswap@val#1#2{#2{#1}}%
\def\@ifxundefined@cs#1{\expandafter\@ifx\expandafter{\csname#1\endcsname\relax}}%
\def\@boolean#1#2{%
  \long\def#1{%
    #2% \if<something>
      \expandafter\true@sw
    \else
      \expandafter\false@sw
    \fi
  }%
}%
\def\@boole@def#1#{\@boolean{#1}}% Implicit #2
\def\@booleantrue#1{\let#1\true@sw}%
\def\@booleanfalse#1{\let#1\false@sw}%
\@boole@def\@ifx#1{\ifx#1}%
\@boole@def\@ifx@empty#1{\ifx\@empty#1}%
\@boole@def\@ifempty#1{\if!#1!}%
\def\@if@sw#1#2{#1\expandafter\true@sw\else\expandafter\false@sw#2}%
\@boole@def\@ifdim#1{\ifdim#1}%
\@boole@def\@ifeof#1{\ifeof#1}%
\@boole@def\@ifhbox#1{\ifhbox#1}%
\@boole@def\@ifhmode{\ifhmode}%
\@boole@def\@ifinner{\ifinner}%
\@boole@def\@ifmmode{\ifmmode}%
\@boole@def\@ifnum#1{\ifnum#1}%
\@boole@def\@ifodd#1{\ifodd#1}%
\@boole@def\@ifvbox#1{\ifvbox#1}%
\@boole@def\@ifvmode{\ifvmode}%
\@boole@def\@ifvoid#1{\ifvoid#1}%
\long\def\true@sw#1#2{#1}%
\long\def\false@sw#1#2{#2}%
\long\def\loopuntil#1{#1{}{\loopuntil{#1}}}%
\long\def\loopwhile#1{#1{\loopwhile{#1}}{}}%
\prepdef\document{%
 \endgroup
 \set@typesize@hook
 \normalsize
 \set@pica@hook
 \true@sw{}%
}%
\AtBeginDocument{%
 \class@documenthook
}%
\AtEndDocument{%
 \class@enddocumenthook
}%
\def\class@documenthook{}%
\def\class@enddocumenthook{}%
\def\set@typesize@hook{}%
\def\set@pica@hook{}%
\def\enddocument{%
 \@enddocumenthook
 \@checkend{document}%
 \clearpage
 \check@aux
 \deadcycles\z@
 \@@end
}%
\def\check@aux{\do@check@aux}%
\def\do@check@aux{%
 \@if@sw\if@filesw\fi{%
  \immediate\closeout\@mainaux
  \let\@setckpt\@gobbletwo
  \let\@newl@bel\@testdef
  \@tempswafalse
  \makeatletter
  \input\jobname.aux\relax
 }%
 \@dofilelist
 \@ifdim{\font@submax >\fontsubfuzz\relax}{%
  \@font@warning{%
   Size substitutions with differences\MessageBreak
   up to \font@submax\space have occured.\@gobbletwo
  }%
 }{}%
 \@defaultsubs
 \@refundefined
 \@if@sw\if@filesw\fi{%
  \@ifx{\@multiplelabels\relax}{%
   \@if@sw\if@tempswa\fi{%
    \@latex@warning@no@line{%
     Label(s) may have changed.
     Rerun to get cross-references right
    }%
   }{}%
  }{%
    \@multiplelabels
  }%
 }{}%
}%
\def\flushing{%
  \let\\\@normalcr
  \leftskip\z@skip
  \rightskip\z@skip
  \@rightskip\z@skip
  \parfillskip\@flushglue
}%
\def\eqnarray@LaTeX{%
   \stepcounter{equation}%
   \def\@currentlabel{\p@equation\theequation}%
   \global\@eqnswtrue
   \m@th
   \global\@eqcnt\z@
   \tabskip\@centering
   \let\\\@eqncr
   $$\everycr{}\halign to\displaywidth\bgroup
       \hskip\@centering$\displaystyle\tabskip\z@skip{##}$\@eqnsel
      &\global\@eqcnt\@ne\hskip \tw@\arraycolsep \hfil${##}$\hfil
      &\global\@eqcnt\tw@ \hskip \tw@\arraycolsep
         $\displaystyle{##}$\hfil\tabskip\@centering
      &\global\@eqcnt\thr@@ \hb@xt@\z@\bgroup\hss##\egroup
         \tabskip\z@skip
      \cr
}
\long\def\eqnarray@fleqn@fixed{%
 \stepcounter{equation}\def\@currentlabel{\p@equation\theequation}%
 \global\@eqnswtrue\m@th\global\@eqcnt\z@
 \tabskip\mathindent
 \let\\=\@eqncr
 \setlength\abovedisplayskip{\topsep}%
 \ifvmode\addtolength\abovedisplayskip{\partopsep}\fi
 \addtolength\abovedisplayskip{\parskip}%
 \setlength\belowdisplayskip{\abovedisplayskip}%
 \setlength\belowdisplayshortskip{\abovedisplayskip}%
 \setlength\abovedisplayshortskip{\abovedisplayskip}%
 $$%
 \everycr{}%
 \halignt@\linewidth\bgroup
  \hskip\@centering$\displaystyle\tabskip\z@skip{##}$\@eqnsel
  &\global\@eqcnt\@ne
   \hskip\tw@\eqncolsep
   \hfil${{}##{}}$\hfil
  &\global\@eqcnt\tw@
   \hskip\tw@\eqncolsep
   $\displaystyle{##}$\hfil\tabskip\@centering
  &\global\@eqcnt\thr@@\hb@xt@\z@\bgroup\hss##\egroup
   \tabskip\z@skip
  \cr
}%
\@ifx{\eqnarray\eqnarray@LaTeX}{%
 \expandafter\PackageInfo\expandafter{\class@name}%
  {Repairing broken {eqnarray} definition}%
 \let\eqnarray\eqnarray@fleqn@fixed
 \newlength\eqncolsep
 \setlength\eqncolsep\z@
 \let\eqnarray@LaTeX\relax
 \let\eqnarray@fleqn@fixed\relax
}{}%
\def\mathindent{\@centering}%
\def\set@eqnarray@skips{}%
\def\footnote{%
 \@ifnextchar[\@xfootnote{\@yfootnote\@footnotetext}%
}%
\def\footnotemark{%
 \@ifnextchar[\@xfootnotemark{\@yfootnote}%
}%
\def\@xfootnote[#1]{%
 \@xfootnotemark[#1]%
 \@footnotetext
}%
\def\@xfootnotemark@ltx[#1]{%
 \begingroup
   \csname c@\@mpfn\endcsname #1\relax
   \unrestored@protected@xdef\@thefnmark{\thempfn}%
 \endgroup
 \H@@footnotemark
}%
\def\@yfootnote{%
 \stepcounter\@mpfn
 \protected@xdef\@thefnmark{\thempfn}%
 \H@@footnotemark
}%
\appdef\class@documenthook{%
 \@ifxundefined\H@@footnotemark{%
  \let\H@@footnotemark\@footnotemark
 }{}%
 \let\@xfootnotemark\@xfootnotemark@ltx
}%
\long\def\@footnotetext{%
 \insert\footins\bgroup
  \make@footnotetext
}%
\long\def\@mpfootnotetext{%
 \global\setbox\@mpfootins\vbox\bgroup
  \unvbox\@mpfootins
  \set@footnotewidth
  \make@footnotetext
}%
\def\make@footnotetext#1{%
  \reset@font\footnotesize
  \interlinepenalty\interfootnotelinepenalty
  \splittopskip\footnotesep
  \splitmaxdepth\dp\strutbox
  \hsize\columnwidth
  \@parboxrestore
  \protected@edef\@currentlabel{%
   \csname p@footnote\endcsname\@thefnmark
  }%
  \color@begingroup
   \@makefntext{%
    \rule\z@\footnotesep\ignorespaces#1\@finalstrut\strutbox
   }%
  \color@endgroup
 \egroup
}%
\def\set@footnotewidth{}%
\appdef\class@documenthook{%
 \prepdef\caption{\minipagefootnotes}%
}%
\def\minipagefootnotes{%
    \par
    \@ifvoid\@mpfootins{}{%
      \unvbox\@mpfootins
    }%
}%
\let\@xfloat@LaTeX\@xfloat
\def\@xfloat#1[#2]{%
  \@xfloat@prep
  \@nameuse{fp@proc@#2}%
  \@ifxundefined\floats@sw{\global\@booleantrue\floats@sw}{}%
  \floats@sw{\@xfloat@LaTeX{#1}[#2]}{\@xfloat@anchored{#1}[]}%
}%
\def\@xfloat@prep{%
  \let\footnote\footnote@latex
  \def\@mpfn{mpfootnote}%
  \def\thempfn{\thempfootnote}%
  \c@mpfootnote\z@
  \let\@footnotetext\@mpfootnotetext
  \let\H@@footnotetext\@mpfootnotetext
  \let\@makefntext\@mpmakefntext
  \samepage
}%
\appdef\class@documenthook{%
 \let\footnote@latex\footnote
}%
\def\@xfloat@anchored#1[#2]{%
 \def\@captype{#1}%
 \begin@float@pagebreak
  \let\end@float\end@float@anchored
  \pagegrid@col\@ne % Klootch to avoid processing as a float
}%
\def\end@float@anchored{%
  \minipagefootnotes
  \par\vskip\z@skip      %% \par\vskip\z@ added 15 Dec 87
 \par
 \end@float@pagebreak
}%
\def\begin@float@pagebreak{\par\addvspace\intextsep}%
\def\end@float@pagebreak{\par\addvspace\intextsep}%
\def\@mpmakefntext#1{%
 \parindent=1em
 \noindent
 \hb@xt@1em{\hss\@makefnmark}%
 #1%
}%
\def\do@if@floats#1#2{%
 \@ifxundefined\floats@sw{\global\@booleantrue\floats@sw}{}%
 \floats@sw{}{%
  \expandafter\newwrite
              \csname#1write\endcsname
  \expandafter\def
              \csname#1@stream\endcsname{\jobname#2}%
  \expandafter\immediate
  \expandafter\openout
              \csname#1write\endcsname
              \csname#1@stream\endcsname\relax
  \@ifxundefined\@float@LaTeX{%
   \let\@float@LaTeX\@float
   \let\@dblfloat@LaTeX\@dblfloat
   \let\@float\write@float
   \let\@dblfloat\write@floats
  }{}%
  \let@environment{#1@float}{#1}%
  \let@environment{#1@floats}{#1*}%
  \@ifxundefined@cs{#1@write}{}{%
   \let@environment{#1}{#1@write}%
  }%
 }%
}%
\def\triggerpar{\leavevmode\@@par}%
\def\oneapage{\def\begin@float@pagebreak{\newpage}\def\end@float@pagebreak{\newpage}}%
\def\print@float#1#2{%
 \@ifxundefined@cs{#1write}{}{%
  \begingroup
   \@booleanfalse\floats@sw
   #2%
   \raggedbottom
   \def\array@default{v}% floats must
   \let\@float\@float@LaTeX
   \let\@dblfloat\@dblfloat@LaTeX
   \let\trigger@float@par\triggerpar
   \let@environment{#1}{#1@float}%
   \let@environment{#1*}{#1@floats}%
   \expandafter\prepdef\csname#1\endcsname{\trigger@float@par}%
   \expandafter\prepdef\csname#1*\endcsname{\trigger@float@par}%
   \@namedef{fps@#1}{h!}%
   \expandafter\immediate
   \expandafter\closeout
               \csname#1write\endcsname
   \everypar{%
    \global\let\trigger@float@par\relax
    \global\everypar{}\setbox\z@\lastbox
    \@ifxundefined@cs{#1sname}{}{%
     \begin@float@pagebreak
     \expandafter\section
     \expandafter*%
     \expandafter{%
                  \csname#1sname\endcsname
                 }%
    }%
   }%
   \input{\csname#1@stream\endcsname}%
  \endgroup
  \expandafter\let\csname#1write\endcsname\relax
 }%
}%
\def\write@float#1{\write@@float{#1}{#1}}%
\def\endwrite@float{\@Esphack}%
\def\write@floats#1{\write@@float{#1*}{#1}}%
\def\endwrite@floats{\@Esphack}%
\def\write@@float#1#2{%
  \ifhmode
     \@bsphack
  \fi
  \chardef\@tempc\csname#2write\endcsname
  \toks@{\begin{#1}}%
  \def\@tempb{#1}%
  \expandafter\let\csname end#1\endcsname\endwrite@float
  \catcode`\^^M\active
  \@makeother\{\@makeother\}\@makeother\%
  \write@floatline
}%
\begingroup
 \catcode`\[\the\catcode`\{\catcode`\]\the\catcode`\}\@makeother\{\@makeother\}%
 \gdef\float@end@tag#1\end{#2}#3\@nul[%
  \def\@tempa[#2]%
  \@ifx[\@tempa\@tempb][\end[#2]][\write@floatline]%
 ]%
 \obeylines%
 \gdef\write@floatline#1^^M[%
  \begingroup%
   \newlinechar`\^^M%
   \toks@\expandafter[\the\toks@#1]\immediate\write\@tempc[\the\toks@]%
  \endgroup%
  \toks@[]%
  \float@end@tag#1\end{}\@nul%
 ]%
\endgroup
\def\@alph#1{\ifcase#1\or a\or b\or c\or d\else\@ialph{#1}\fi}
\def\@ialph#1{\ifcase#1\or \or \or \or \or e\or f\or g\or h\or i\or j\or
  k\or l\or m\or n\or o\or p\or q\or r\or s\or t\or u\or v\or w\or x\or
  y\or z\or aa\or bb\or cc\or dd\or ee\or ff\or gg\or hh\or ii\or jj\or
  kk\or ll\or mm\or nn\or oo\or pp\or qq\or rr\or ss\or tt\or uu\or
  vv\or ww\or xx\or yy\or zz\else\@ctrerr\fi}
\def\@fnsymbol#1{\ensuremath{\ifcase#1\or *\or \dagger\or \ddagger\or
  \mathchar "278\or **\or \dagger\dagger
  \or \ddagger\ddagger \or \mathsection \mathsection\or
  *{*}*\or\dagger\dagger\dagger\or\ddagger\ddagger\ddagger\or
  \mathsection \mathsection \mathsection
  \else\@ctrerr\fi}}
\def\@startsection#1#2#3#4#5#6{%
 \@startsection@hook
 \if@noskipsec \leavevmode \fi
 \par
 \@tempskipa #4\relax
 \@afterindenttrue
 \ifdim \@tempskipa <\z@
  \@tempskipa -\@tempskipa \@afterindentfalse
 \fi
 \if@nobreak
  \everypar{}%
 \else
  \addpenalty\@secpenalty\addvspace\@tempskipa
 \fi
 \@ifstar
  {\@dblarg{\@ssect@ltx{#1}{#2}{#3}{#4}{#5}{#6}}}%
  {\@dblarg{\@sect {#1}{#2}{#3}{#4}{#5}{#6}}}%
}%
\def\@startsection@hook{}%
\class@info
  {Repairing broken definition of \string\@sect.}%
\def\@sect#1#2#3#4#5#6[#7]#8{%
  \@ifnum{#2>\c@secnumdepth}{%
    \let\@svsec\@empty
  }{%
    \refstepcounter{#1}%
    \protected@edef\@svsec{{#1}}%
    \@ifundefined{@#1cntformat}{%
     \prepdef\@svsec\@seccntformat
    }{%
     \expandafter\prepdef
     \expandafter\@svsec
                 \csname @#1cntformat\endcsname
    }%
  }%
  \@tempskipa #5\relax
  \@ifdim{\@tempskipa>\z@}{%
    \begingroup
      \interlinepenalty \@M
      #6{%
       \@ifundefined{@hangfrom@#1}{\@hangfrom}{\csname @hangfrom@#1\endcsname}%
       {\hskip#3\relax\@svsec}{#8}%
      }%
      \@@par
    \endgroup
    \@ifundefined{#1mark}{\@gobble}{\csname #1mark\endcsname}{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #8}%
  }{%
    \def\@svsechd{%
      #6{%
       \@ifundefined{@runin@to@#1}{\@runin@to}{\csname @runin@to@#1\endcsname}%
       {\hskip#3\relax\@svsec}{#8}%
      }%
      \@ifundefined{#1mark}{\@gobble}{\csname #1mark\endcsname}{#7}%
      \addcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi
        #8}%
    }%
  }%
  \@xsect{#5}%
}%
\def\@runin@to#1#2{#1#2}%
\def\@ssect@ltx#1#2#3#4#5#6[#7]#8{%
  \def\@currentlabelname{#8}%
  \@tempskipa #5\relax
  \@ifdim{\@tempskipa>\z@}{%
    \begingroup
      \interlinepenalty \@M
      #6{%
       \@ifundefined{@hangfroms@#1}{\@hangfrom}{\csname @hangfroms@#1\endcsname}%
       {\hskip#3\relax}{\Sectionformat{#8}{#1}}%
      }%
      \@@par
    \endgroup
    \@ifundefined{#1smark}{\@gobble}{\csname #1smark\endcsname}{#7}%
    \addcontentsline{toc}{#1}{#8}%
  }{%
    \def\@svsechd{%
      #6{%
       \@ifundefined{@runin@tos@#1}{\@runin@to}{\csname @runin@tos@#1\endcsname}%
       {\hskip#3\relax}{\Sectionformat{#8}{#1}}%
      }%
      \@ifundefined{#1smark}{\@gobble}{\csname #1smark\endcsname}{#7}%
      \addcontentsline{toc}{#1}{#8}%
    }%
  }%
  \@xsect{#5}%
  \phantomsection
}%
\appdef\class@documenthook{%
 \@ifx{\phantomsection\@undefined}{\let\phantomsection\@empty}{}%
 \@ifx{\Sectionformat\@undefined}{\let\Sectionformat\@firstoftwo}{}%
}%
\def\sec@upcase#1{\relax{#1}}%
\appdef\class@documenthook{%
 \@ifpackageloaded{array}{\switch@array}{\switch@tabular}%
 \prepdef\endtabular{\endtabular@hook}%
 \prepdef\endarray{\endarray@hook}%
 \providecommand\array@hook{}%
 \@ifxundefined\endarray@hook{\let\endarray@hook\@empty}{}%
 \providecommand\tabular@hook{}%
 \@ifxundefined\endtabular@hook{\let\endtabular@hook\@empty}{}%
 \prepdef\@tabular{\tabular@font}%
}%
\def\switch@tabular{%
 \let\@array@sw\@array@sw@array
 \@ifx{\@array\@array@LaTeX}{%
  \@ifx{\multicolumn\multicolumn@LaTeX}{%
   \@ifx{\@tabular\@tabular@LaTeX}{%
    \@ifx{\@tabarray\@tabarray@LaTeX}{%
     \@ifx{\array\array@LaTeX}{%
      \@ifx{\endarray\endarray@LaTeX}{%
       \@ifx{\endtabular\endtabular@LaTeX}{%
        \@ifx{\@mkpream\@mkpream@LaTeX}{%
         \@ifx{\@addamp\@addamp@LaTeX}{%
          \@ifx{\@arrayacol\@arrayacol@LaTeX}{%
           \@ifx{\@tabacol\@tabacol@LaTeX}{%
            \@ifx{\@arrayclassz\@arrayclassz@LaTeX}{%
             \@ifx{\@tabclassiv\@tabclassiv@LaTeX}{%
              \@ifx{\@arrayclassiv\@arrayclassiv@LaTeX}{%
               \@ifx{\@tabclassz\@tabclassz@LaTeX}{%
                \@ifx{\@classv\@classv@LaTeX}{%
                 \@ifx{\hline\hline@LaTeX}{%
                  \true@sw
                 }{%
                  \false@sw
                 }%
                }{%
                 \false@sw
                }%
               }{%
                \false@sw
               }%
              }{%
               \false@sw
              }%
             }{%
              \false@sw
             }%
            }{%
             \false@sw
            }%
           }{%
            \false@sw
           }%
          }{%
           \false@sw
          }%
         }{%
          \false@sw
         }%
        }{%
         \false@sw
        }%
       }{%
        \false@sw
       }%
      }{%
       \false@sw
      }%
     }{%
      \false@sw
     }%
    }{%
     \false@sw
    }%
   }{%
    \false@sw
   }%
  }{%
   \false@sw
  }%
 }{%
  \false@sw
 }%
 {%
  \class@info{Patching LaTeX tabular.}%
 }{%
  \class@info{Unrecognized LaTeX tabular. Please update this document class! (Proceeding with fingers crossed.)}%
 }%
 \let\@array\@array@ltx
 \let\multicolumn\multicolumn@ltx
 \let\@tabular\@tabular@ltx
 \let\@tabarray\@tabarray@ltx
 \let\array\array@ltx
 \let\endarray\endarray@ltx
 \let\endtabular\endtabular@ltx
 \let\@mkpream\@mkpream@ltx
 \let\@addamp\@addamp@ltx
 \let\@arrayacol\@arrayacol@ltx
 \let\@tabacol\@tabacol@ltx
 \let\@arrayclassz\@arrayclassz@ltx
 \let\@tabclassiv\@tabclassiv@ltx
 \let\@arrayclassiv\@arrayclassiv@ltx
 \let\@tabclassz\@tabclassz@ltx
 \let\@classv\@classv@ltx
 \let\hline\hline@ltx
}%
\def\switch@array{%
 \let\@array@sw\@array@sw@LaTeX
 \@ifx{\@array\@array@array}{%
  \@ifx{\@tabular\@tabular@array}{%
   \@ifx{\@tabarray\@tabarray@array}{%
    \@ifx{\array\array@array}{%
     \@ifx{\endarray\endarray@array}{%
      \@ifx{\endtabular\endtabular@array}{%
       \@ifx{\@mkpream\@mkpream@array}{%
        \@ifx{\@classx\@classx@array}{%
         \@ifx{\insert@column\insert@column@array}{%
          \true@sw
         }{%
          \false@sw
         }%
        }{%
         \false@sw
        }%
       }{%
        \false@sw
       }%
      }{%
       \false@sw
      }%
     }{%
      \false@sw
     }%
    }{%
     \false@sw
    }%
   }{%
    \false@sw
   }%
  }{%
   \false@sw
  }%
 }{%
  \false@sw
 }{%
  \class@info{Patching array package.}%
 }{%
  \class@info{Unrecognized array package. Please update this document class! (Proceeding with fingers crossed.)}%
 }%
 \let\@array    \@array@array@new
 \let\@@array   \@array % Cosi fan tutti
 \let\@tabular  \@tabular@array@new
 \let\@tabarray \@tabarray@array@new
 \let\array     \array@array@new
 \let\endarray  \endarray@array@new
 \let\endtabular\endtabular@array@new
 \let\@mkpream  \@mkpream@array@new
 \let\@classx   \@classx@array@new
 \let\@arrayacol\@arrayacol@ltx
 \let\@tabacol  \@tabacol@ltx
 \let\insert@column\insert@column@array@new
 \expandafter\let\csname endtabular*\endcsname\endtabular % Cosi fan tutti
}%
\def\@array@sw@LaTeX{\@ifx{\\\@tabularcr}}%
\def\@array@sw@array{\@ifx{\d@llarbegin\begingroup}}%
\def\@tabular@LaTeX{%
 \leavevmode
 \hbox\bgroup$%
  \let\@acol\@tabacol
  \let\@classz\@tabclassz
  \let\@classiv\@tabclassiv
  \let\\\@tabularcr
  \@tabarray
}%
\def\@tabular@ltx{%
  \let\@acoll\@tabacoll
  \let\@acolr\@tabacolr
  \let\@acol\@tabacol
  \let\@classz\@tabclassz
  \let\@classiv\@tabclassiv
  \let\\\@tabularcr
  \@tabarray
}%
\def\@tabular@array{%
 \leavevmode
 \hbox\bgroup$%
  \col@sep\tabcolsep
  \let\d@llarbegin\begingroup
  \let\d@llarend\endgroup
  \@tabarray
}%
\def\@tabular@array@new{%
  \let\@acoll\@tabacoll
  \let\@acolr\@tabacolr
  \let\@acol\@tabacol
  \let\col@sep\@undefined
  \let\d@llarbegin\begingroup
  \let\d@llarend\endgroup
  \@tabarray
}%
\def\@tabarray@LaTeX{%
 \m@th\@ifnextchar[\@array{\@array[c]}%
}%
\def\@tabarray@ltx{%
 \m@th\@ifnextchar[\@array{\expandafter\@array\expandafter[\array@default]}%
}%
\def\@tabarray@array{%
 \@ifnextchar[{\@@array}{\@@array[c]}%
}%
\def\@tabarray@array@new{%
 \@ifnextchar[{\@@array}{\expandafter\@@array\expandafter[\array@default]}%
}%
\def\array@LaTeX{%
 \let\@acol\@arrayacol
 \let\@classz\@arrayclassz
 \let\@classiv\@arrayclassiv
 \let\\\@arraycr
 \let\@halignto\@empty
 \@tabarray
}%
\def\array@ltx{%
 \@ifmmode{}{\@badmath$}%
 \let\@acoll\@arrayacol
 \let\@acolr\@arrayacol
 \let\@acol\@arrayacol
 \let\@classz\@arrayclassz
 \let\@classiv\@arrayclassiv
 \let\\\@arraycr
 \let\@halignto\@empty
 \@tabarray
}%
\def\array@array{%
 \col@sep\arraycolsep
 \def\d@llarbegin{$}\let\d@llarend\d@llarbegin\gdef\@halignto{}%
 \@tabarray
}
\def\array@array@new{%
 \@ifmmode{}{\@badmath$}%
 \let\@acoll\@arrayacol
 \let\@acolr\@arrayacol
 \let\@acol\@arrayacol
\let\col@sep\@undefined
 \def\d@llarbegin{$}%
 \let\d@llarend\d@llarbegin
 \gdef\@halignto{}%
 \@tabarray
}%
\def\@array@LaTeX[#1]#2{%
  \if #1t\vtop \else \if#1b\vbox \else \vcenter \fi\fi
  \bgroup
  \setbox\@arstrutbox\hbox{%
    \vrule \@height\arraystretch\ht\strutbox
           \@depth\arraystretch \dp\strutbox
           \@width\z@}%
  \@mkpream{#2}%
  \edef\@preamble{%
    \ialign \noexpand\@halignto
      \bgroup \@arstrut \@preamble \tabskip\z@skip \cr}%
  \let\@startpbox\@@startpbox \let\@endpbox\@@endpbox
  \let\tabularnewline\\%
    \let\par\@empty
    \let\@sharp##%
    \set@typeset@protect
    \lineskip\z@skip\baselineskip\z@skip
    \ifhmode \@preamerr\z@ \@@par\fi
    \@preamble
}%
\def\@array@ltx[#1]#2{%
 \@nameuse{@array@align@#1}%
  \setbox\@arstrutbox\hbox{%
    \vrule \@height\arraystretch\ht\strutbox
           \@depth\arraystretch \dp\strutbox
           \@width\z@
  }%
  \@mkpream{#2}%
  \prepdef\@preamble{%
    \tabskip\tabmid@skip
    \@arstrut
  }%
  \appdef\@preamble{%
    \tabskip\tabright@skip
    \cr
    \array@row@pre
  }%
  \let\tabularnewline\\%
  \let\par\@empty
  \let\@sharp##%
  \set@typeset@protect
  \lineskip\z@skip\baselineskip\z@skip
  \tabskip\tableft@skip\relax
  \ifhmode \@preamerr\z@ \@@par\fi
  \everycr{}%
  \expandafter\halign\expandafter\@halignto\expandafter\bgroup\@preamble
}%
\def\@array@array[#1]#2{%
  \@tempdima \ht \strutbox
  \advance \@tempdima by\extrarowheight
  \setbox \@arstrutbox \hbox{\vrule
             \@height \arraystretch \@tempdima
             \@depth \arraystretch \dp \strutbox
             \@width \z@}%
  \begingroup
  \@mkpream{#2}%
  \xdef\@preamble{\noexpand \ialign \@halignto
                  \bgroup \@arstrut \@preamble
                          \tabskip \z@ \cr}%
  \endgroup
  \@arrayleft
  \if #1t\vtop \else \if#1b\vbox \else \vcenter \fi \fi
  \bgroup
  \let \@sharp ##\let \protect \relax
  \lineskip \z@
  \baselineskip \z@
  \m@th
  \let\\\@arraycr \let\tabularnewline\\\let\par\@empty \@preamble
}%
\def\@array@array@new[#1]#2{%
  \@tempdima\ht\strutbox
  \advance\@tempdima by\extrarowheight
  \setbox\@arstrutbox\hbox{%
   \vrule \@height\arraystretch\@tempdima
          \@depth \arraystretch\dp\strutbox
          \@width \z@
  }%
  \begingroup
   \@mkpream{#2}%
   \xdef\@preamble{\@preamble}%
  \endgroup
  \prepdef\@preamble{%
   \tabskip\tabmid@skip
    \@arstrut
  }%
  \appdef\@preamble{%
   \tabskip\tabright@skip
   \cr
   \array@row@pre
  }%
  \@arrayleft
  \@nameuse{@array@align@#1}%
  \m@th
  \let\\\@arraycr
  \let\tabularnewline\\%
  \let\par\@empty
  \let\@sharp##%
  \set@typeset@protect
  \lineskip\z@\baselineskip\z@
  \tabskip\tableft@skip
  \everycr{}%
  \expandafter\halign\expandafter\@halignto\expandafter\bgroup\@preamble
}%
\def\endarray@LaTeX{%
 \crcr\egroup\egroup
}%
\def\endarray@ltx{%
 \crcr\array@row@pst\egroup\egroup
}%
\def\endarray@array{%
 \crcr \egroup \egroup \@arrayright \gdef\@preamble{}%
}%
\def\endarray@array@new{%
 \crcr\array@row@pst\egroup\egroup % Same as \endarray@ltx
 \@arrayright
 \global\let\@preamble\@empty
}%
\def\endtabular@LaTeX{%
 \crcr\egroup\egroup $\egroup
}%
\def\endtabular@ltx{%
 \endarray
}%
\def\endtabular@array{%
 \endarray $\egroup
}%
\def\endtabular@array@new{%
 \endarray
}%
\@namedef{endtabular*}{\endtabular}%
\long\def\multicolumn@LaTeX#1#2#3{%
 \multispan{#1}\begingroup
  \@mkpream{#2}%
  \def\@sharp{#3}\set@typeset@protect
  \let\@startpbox\@@startpbox\let\@endpbox\@@endpbox
  \@arstrut \@preamble\hbox{}\endgroup\ignorespaces
}%
\long\def\multicolumn@ltx#1#2#3{%
 \multispan{#1}%
 \begingroup
  \@mkpream{#2}%
  \def\@sharp{#3}%
  \set@typeset@protect
 %\let\@startpbox\@@startpbox\let\@endpbox\@@endpbox
  \@arstrut
  \@preamble
  \hbox{}%
 \endgroup
 \ignorespaces
}%
\def\@array@align@t{\leavevmode\vtop\bgroup}%
\def\@array@align@b{\leavevmode\vbox\bgroup}%
\def\@array@align@c{\leavevmode\@ifmmode{\vcenter\bgroup}{$\vcenter\bgroup\aftergroup$\aftergroup\relax}}%
\def\@array@align@v{\@ifmmode{\@badmath\vcenter}{\par}\bgroup}%
\def\array@default{c}%
\def\array@row@rst{%
 \let\@array@align@v\@array@align@c
}%
\def\array@row@pre{}%
\def\array@row@pst{}%
\newcommand\toprule{\tab@rule{\column@font}{\column@fil}{\frstrut}}%
\newcommand\colrule{\unskip\lrstrut\\\tab@rule{\body@font}{}{\frstrut}}%
\newcommand\botrule{\unskip\lrstrut\\\noalign{\hline@rule}{}}%
\def\hline@LaTeX{%
 \noalign{\ifnum0=`}\fi\hrule \@height \arrayrulewidth \futurelet
   \reserved@a\@xhline
}%
\def\hline@ltx{%
 \noalign{%
  \ifnum0=`}\fi
  \hline@rule
  \futurelet\reserved@a\@xhline
 % \noalign ended in \@xhline
}%
\def\@xhline@unneeded{%
 \say\reserved@a
 \ifx\reserved@a\hline
  \vskip\doublerulesep
  \vskip-\arrayrulewidth
 \fi
 \ifnum0=`{\fi}%
}%
\def\tab@rule#1#2#3{%
 \crcr
 \noalign{%
  \hline@rule
  \gdef\@arstrut@hook{%
   \global\let\@arstrut@hook\@empty
   #3%
  }%
  \gdef\cell@font{#1}%
  \gdef\cell@fil{#2}%
 }%
}%
\def\hline@rule{\hrule\@height\arrayrulewidth}%
\def\column@font{}%
\def\column@fil{}%
\def\body@font{}%
\def\cell@font{}%
\def\frstrut{}%
\def\lrstrut{}%
\def\tableft@skip{\z@skip}%
\def\tabmid@skip{\z@skip}%\@flushglue
\def\tabright@skip{\z@skip}%
\def\tableftsep{\tabcolsep}%
\def\tabmidsep{\tabcolsep}%
\def\tabrightsep{\tabcolsep}%
\def\cell@fil{}%
\def\pbox@hook{}%
\appdef\@arstrut{\@arstrut@hook}%
\let\@arstrut@hook\@empty
\def\@addtopreamble{\appdef\@preamble}%
\def\@mkpream@LaTeX#1{%
  \@firstamptrue\@lastchclass6
  \let\@preamble\@empty
  \let\protect\@unexpandable@protect
  \let\@sharp\relax
  \let\@startpbox\relax\let\@endpbox\relax
  \@expast{#1}%
  \expandafter\@tfor \expandafter
    \@nextchar \expandafter:\expandafter=\reserved@a\do
       {\@testpach\@nextchar
    \ifcase \@chclass \@classz \or \@classi \or \@classii \or \@classiii
      \or \@classiv \or\@classv \fi\@lastchclass\@chclass}%
  \ifcase \@lastchclass \@acol
      \or \or \@preamerr \@ne\or \@preamerr \tw@\or \or \@acol \fi
}%
\def\@mkpream@ltx#1{%
 \@firstamptrue
 \@lastchclass6
 \let\@preamble\@empty
 \let\protect\@unexpandable@protect
 \let\@sharp\relax
 \@expast{#1}%
 \expandafter\@tfor\expandafter\@nextchar\expandafter:\expandafter=\reserved@a
 \do{%
  \expandafter\@testpach\expandafter{\@nextchar}%
  \ifcase\@chclass
   \@classz
  \or
   \@classi
  \or
   \@classii
  \or
   \@classiii
  \or
   \@classiv
  \or
   \@classv
  \fi
  \@lastchclass\@chclass
 }%
 \ifcase\@lastchclass
  \@acolr % right-hand column
 \or
 \or
  \@preamerr\@ne
 \or
  \@preamerr\tw@
 \or
 \or
  \@acolr % right-hand column
 \fi
}%
\def\insert@column@array{%
   \the@toks \the \@tempcnta
   \ignorespaces \@sharp \unskip
   \the@toks \the \count@ \relax
}%
\def\insert@column@array@new{%
 \the@toks\the\@tempcnta
 \array@row@rst\cell@font
 \ignorespaces\@sharp\unskip
 \the@toks\the\count@
 \relax
}%
\def\@mkpream@relax{%
 \let\tableftsep\relax
 \let\tabmidsep\relax
 \let\tabrightsep\relax
 \let\array@row@rst\relax
 \let\cell@font\relax
}%
\def\@mkpream@array#1{%
   \gdef\@preamble{}\@lastchclass 4 \@firstamptrue
   \let\@sharp\relax \let\@startpbox\relax \let\@endpbox\relax
   \@temptokena{#1}\@tempswatrue
   \@whilesw\if@tempswa\fi{\@tempswafalse\the\NC@list}%
   \count@\m@ne
   \let\the@toks\relax
   \prepnext@tok
   \expandafter \@tfor \expandafter \@nextchar
    \expandafter :\expandafter =\the\@temptokena \do
   {\@testpach
   \ifcase \@chclass \@classz \or \@classi \or \@classii
     \or \save@decl \or \or \@classv \or \@classvi
     \or \@classvii \or \@classviii
     \or \@classx
     \or \@classx \fi
   \@lastchclass\@chclass}%
   \ifcase\@lastchclass
   \@acol \or
   \or
   \@acol \or
   \@preamerr \thr@@ \or
   \@preamerr \tw@ \@addtopreamble\@sharp \or
   \or
   \else  \@preamerr \@ne \fi
   \def\the@toks{\the\toks}%
}%
\def\@mkpream@array@new#1{%
 \gdef\@preamble{}%
 \@lastchclass\f@ur
 \@firstamptrue
 \let\@sharp\relax
 \@mkpream@relax
 \@temptokena{#1}\@tempswatrue
 \@whilesw\if@tempswa\fi{\@tempswafalse\the\NC@list}%
 \count@\m@ne
 \let\the@toks\relax
 \prepnext@tok
 \expandafter\@tfor\expandafter\@nextchar\expandafter:\expandafter=\the\@temptokena
 \do{%
  \@testpach
  \ifcase\@chclass
   \@classz
  \or
   \@classi
  \or
   \@classii
  \or
   \save@decl
  \or
  \or
   \@classv
  \or
   \@classvi
  \or
   \@classvii
  \or
   \@classviii
  \or
   \@classx
  \or
   \@classx
  \fi
  \@lastchclass\@chclass
 }%
 \ifcase\@lastchclass
  \@acolr % right-hand column
 \or
 \or
  \@acolr % right-hand column
 \or
  \@preamerr\thr@@
 \or
  \@preamerr\tw@\@addtopreamble\@sharp
 \or
 \or
 \else
  \@preamerr\@ne
 \fi
 \def\the@toks{\the\toks}%
}%
\def\@addamp@LaTeX{%
  \if@firstamp\@firstampfalse\else\edef\@preamble{\@preamble &}\fi
}%
\def\@addamp@ltx{%
 \if@firstamp\@firstampfalse\else\@addtopreamble{&}\fi
}%
\def\@arrayacol@LaTeX{%
 \edef\@preamble{\@preamble \hskip \arraycolsep}%
}%
\def\@arrayacol@ltx{%
 \@addtopreamble{\hskip\arraycolsep}%
}%
\def\@tabacoll{%
 \@addtopreamble{\hskip\tableftsep\relax}%
}%
\def\@tabacol@LaTeX{%
 \edef\@preamble{\@preamble \hskip \tabcolsep}%
}%
\def\@tabacol@ltx{%
 \@addtopreamble{\hskip\tabmidsep\relax}%
}%
\def\@tabacolr{%
 \@addtopreamble{\hskip\tabrightsep\relax}%
}%
\def\@arrayclassz@LaTeX{%
 \ifcase \@lastchclass \@acolampacol \or \@ampacol \or
   \or \or \@addamp \or
   \@acolampacol \or \@firstampfalse \@acol \fi
 \edef\@preamble{\@preamble
  \ifcase \@chnum
     \hfil$\relax\@sharp$\hfil \or $\relax\@sharp$\hfil
    \or \hfil$\relax\@sharp$\fi}%
}%
\def\@arrayclassz@ltx{%
 \ifcase\@lastchclass
  \@acolampacol
 \or
  \@ampacol
 \or
 \or
 \or
  \@addamp
 \or
  \@acolampacol
 \or
  \@firstampfalse\@acoll
 \fi
 \ifcase\@chnum
  \@addtopreamble{%
   \hfil\array@row@rst$\relax\@sharp$\hfil
  }%
 \or
  \@addtopreamble{%
   \array@row@rst$\relax\@sharp$\hfil
  }%
 \or
  \@addtopreamble{%
   \hfil\array@row@rst$\relax\@sharp$%
  }%
 \fi
}%
\def\@tabclassz@LaTeX{%
  \ifcase\@lastchclass
    \@acolampacol
  \or
    \@ampacol
  \or
  \or
  \or
    \@addamp
  \or
    \@acolampacol
  \or
    \@firstampfalse\@acol
  \fi
  \edef\@preamble{%
    \@preamble{%
      \ifcase\@chnum
        \hfil\ignorespaces\@sharp\unskip\hfil
      \or
        \hskip1sp\ignorespaces\@sharp\unskip\hfil
      \or
        \hfil\hskip1sp\ignorespaces\@sharp\unskip
      \fi}}%
}%
\def\@tabclassz@ltx{%
 \ifcase\@lastchclass
  \@acolampacol
 \or
  \@ampacol
 \or
 \or
 \or
  \@addamp
 \or
  \@acolampacol
 \or
  \@firstampfalse\@acoll
 \fi
 \ifcase\@chnum
  \@addtopreamble{%
   {\hfil\array@row@rst\cell@font\ignorespaces\@sharp\unskip\hfil}%
  }%
 \or
  \@addtopreamble{%
   {\cell@fil\hskip1sp\array@row@rst\cell@font\ignorespaces\@sharp\unskip\hfil}%
  }%
 \or
  \@addtopreamble{%
   {\hfil\hskip1sp\array@row@rst\cell@font\ignorespaces\@sharp\unskip\cell@fil}%
  }%
 \fi
}%
\def\@tabclassiv@LaTeX{%
 \@addtopreamble\@nextchar
}%
\def\@tabclassiv@ltx{%
 \expandafter\@addtopreamble\expandafter{\@nextchar}%
}%
\def\@arrayclassiv@LaTeX{%
 \@addtopreamble{$\@nextchar$}%
}%
\def\@arrayclassiv@ltx{%
 \expandafter\@addtopreamble\expandafter{\expandafter$\@nextchar$}%
}%
\def\@classv@LaTeX{%
 \@addtopreamble{\@startpbox{\@nextchar}\ignorespaces
 \@sharp\@endpbox}%
}%
\def\@classv@ltx{%
 \expandafter\@addtopreamble
 \expandafter{%
 \expandafter \@startpbox
 \expandafter {\@nextchar}%
 \pbox@hook\array@row@rst\cell@font\ignorespaces\@sharp\@endpbox
 }%
}%
\def\@classx@array{%
  \ifcase \@lastchclass
  \@acolampacol \or
  \@addamp \@acol \or
  \@acolampacol \or
  \or
  \@acol \@firstampfalse \or
  \@addamp
  \fi
}%
\def\@classx@array@new{%
 \ifcase \@lastchclass
  \@acolampacol
 \or
  \@addamp \@acol
 \or
  \@acolampacol
 \or
 \or
  \@firstampfalse\@acoll
 \or
  \@addamp
 \fi
}%
\newcommand*\@gobble@opt@one[2][]{}%
\def\@starttoc#1{%
  \begingroup
    \toc@pre
    \makeatletter
    \@input{\jobname.#1}%
    \if@filesw
      \expandafter\newwrite\csname tf@#1\endcsname
      \immediate\openout \csname tf@#1\endcsname \jobname.#1\relax
    \fi
    \@nobreakfalse
    \toc@post
  \endgroup
}%
\def\toc@pre{}%
\def\toc@post{}%
\def\toc@@font{}%{\footnotesize\rmfamily}%
\def\@dotsep{\z@}%{5.5pt}%
\let\tocdim@section       \leftmargini
\let\tocdim@subsection    \leftmarginii
\let\tocdim@subsubsection \leftmarginiii
\let\tocdim@paragraph     \leftmarginiv
\let\tocdim@appendix      \leftmarginv
\let\tocdim@pagenum       \leftmarginvi
\def\toc@pre@auto{%
  \toc@@font
  \@tempdima\z@
  \toc@setindent\@tempdima{section}%
  \toc@setindent\@tempdima{subsection}%
  \toc@setindent\@tempdima{subsubsection}%
  \toc@setindent\@tempdima{paragraph}%
  \toc@letdimen{appendix}%
  \toc@letdimen{pagenum}%
}%
\def\toc@post@auto{%
  \if@filesw
   \begingroup
    \toc@writedimen{section}%
    \toc@writedimen{subsection}%
    \toc@writedimen{subsubsection}%
    \toc@writedimen{paragraph}%
    \toc@writedimen{appendix}%
    \toc@writedimen{pagenum}%
   \endgroup
  \fi
}%
\def\toc@setindent#1#2{%
 \csname tocdim@#2\endcsname\z@
 \@ifundefined{tocmax@#2}{\@namedef{tocmax@#2}{\z@}}{}%
 \advance#1\@nameuse{tocmax@#2}\relax
 \expandafter\edef\csname tocleft@#2\endcsname{\the#1}%
}%
\def\toc@letdimen#1{%
 \csname tocdim@#1\endcsname\z@
 \@ifundefined{tocmax@#1}{\@namedef{tocmax@#1}{\z@}}{}%
 \expandafter\let\csname tocleft@#1\expandafter\endcsname\csname tocmax@#1\endcsname
}%
\def\toc@writedimen#1{%
 \immediate\write\@auxout{%
  \gdef\expandafter\string\csname tocmax@#1\endcsname{%
   \expandafter\the\csname tocdim@#1\endcsname
  }%
 }%
}%
\def\l@@sections#1#2#3#4{%
 % #1 - superior section
 % #2 - this section
 % #3 - content, including possible \numberline
 % #4 - page number
 \expandafter\let\expandafter\dimen@temp\csname tocdim@#2\endcsname
 \setbox\z@\hbox{\ignorespaces#4}\ifdim\tocdim@pagenum<\wd\z@\tocdim@pagenum\wd\z@\fi
 \begingroup
  \everypar{}%
  \leftskip\csname tocleft@#2\endcsname\relax
  \parindent-\leftskip\advance\parindent\csname tocleft@#1\endcsname\relax
  \rightskip\tocleft@pagenum plus 1fil\relax
  \skip@\parfillskip\parfillskip\z@
  \let\numberline\numberline@@sections
  \ignorespaces#3\unskip\nobreak\hskip\skip@
  \hb@xt@\rightskip{\hfil\unhbox\z@}\hskip-\rightskip\hskip\z@skip
  \par
  \aftergroup\dimen@temp
  \expandafter
 \endgroup\the\dimen@temp\relax
}%
\def\numberline@@sections#1{%
 \leavevmode\hb@xt@-\parindent{%
  \aftergroup\dimen@temp
  \hfil
  \setbox\z@\hbox{#1.\kern\@dotsep}\dimen@\wd\z@
  \unhbox\z@
  \@ifdim{\dimen@<\dimen@temp}{\dimen@\dimen@temp}{}%
  \expandafter
 }\the\dimen@\relax
 \ignorespaces
}%
\def\list#1#2{%
  \ifnum \@listdepth >5\relax
    \@toodeep
  \else
    \global\advance\@listdepth\@ne
  \fi
  \rightmargin\z@
  \listparindent\z@
  \itemindent\z@
  \csname @list\romannumeral\the\@listdepth\endcsname
  \def\@itemlabel{#1}%
  \let\makelabel\@mklab
  \@nmbrlistfalse
  #2\relax
  \@trivlist
  \parskip\parsep
  \set@listindent
  \ignorespaces
}%
\def\set@listindent@parshape{%
 \parindent\listparindent
 \advance\@totalleftmargin\leftmargin
 \advance\linewidth-\rightmargin
 \advance\linewidth-\leftmargin
 \parshape\@ne\@totalleftmargin\linewidth
}%
\def\set@listindent@{%
 \parindent\listparindent
 \advance\@totalleftmargin\leftmargin
 \advance\rightskip\rightmargin
 \advance\leftskip\@totalleftmargin
}%
\let\set@listindent\set@listindent@parshape
\typeout{%
 ltxgrid: portions licensed from W. E. Baxter (web@superscript.com)%
}%
\newcounter{linecount}
\def\lineloop#1{%
 \loop
 \ifnum\c@linecount<#1\relax
  \global\advance\c@linecount\@ne
  \par
  \hb@xt@\hsize{%
   \ifnum\c@linecount<100 0\fi\ifnum\c@linecount<10 0\fi\number\c@linecount
   \vrule depth2.5\p@
   \leaders\hrule\hfil
  }%
  \allowbreak
 \repeat
}%
\let\@@mark\mark
\let\@@topmark\topmark
\let\@@firstmark\firstmark
\let\@@botmark\botmark
\let\@@splitfirstmark\splitfirstmark
\let\@@splitbotmark\splitbotmark
\def\@themark{{}{}{}{}}%
\def\markboth#1#2{%
 \mark@netw@\@themark{#1}{#2}\do@mark\@themark
}%
\def\markright#1{%
 \marktw@\@themark{#1}\do@mark\@themark
}%
\def\mark@envir{\markthr@@\@themark\@currenvir\do@mark\@themark}%
\def\bot@envir{\expandafter\@bot@thr@@\@@botmark{}{}{}{}\@@nul}%
\def\mark@netw@#1{\expandafter\@mark@netw@\expandafter#1#1}%
\def\@mark@netw@#1#2#3#4#5#6#7{\gdef#1{{#6}{#7}{#4}{#5}}}%
\def\marktw@#1{\expandafter\@marktw@\expandafter#1#1}%
\def\@marktw@#1#2#3#4#5#6{\gdef#1{{#2}{#6}{#4}{#5}}}%
\def\markthr@@#1{\expandafter\@markthr@@\expandafter#1#1}%
\def\@markthr@@#1#2#3#4#5#6{\gdef#1{{#2}{#3}{#6}{#5}}}%
\def\leftmark{\expandafter\@leftmark\saved@@botmark{}{}{}{}\@@nul}%
\def\@leftmark#1#2#3#4#5\@@nul{#1}%
\def\rightmark{\expandafter\@rightmark\saved@@firstmark{}{}{}{}\@@nul}%
\def\@rightmark#1#2#3#4#5\@@nul{#2}%
\def\bot@thr@@{\expandafter\@bot@thr@@\saved@@botmark{}{}{}{}\@@nul}%
\def\@bot@thr@@#1#2#3#4#5\@@nul{#3}%
\def\do@mark#1{%
 \begingroup\let@mark\@@mark{#1}\endgroup\nobreak@mark
}%
\def\let@mark{%
 \let\protect\@unexpandable@protect
 \let\label\relax
 \let\index\relax
 \let\glossary\relax
}%
\def\nobreak@mark{%
 \@if@sw\if@nobreak\fi{\@ifvmode{\nobreak}{}}{}%
}%
\let\primitive@output\output
\long\def\@tempa#1\@@nil{#1}%
\toks@
\expandafter\expandafter
\expandafter{%
\expandafter \@tempa
             \the\output
             \@@nil
             }%
\newtoks\output
\output\expandafter{\the\toks@}%
\primitive@output{\dispatch@output}%
\def\dispatch@output{%
 \let\par\@@par
 \expandafter\let\expandafter\@tempa\csname output@\the\outputpenalty\endcsname
 \outputdebug@sw{%
  \saythe\outputpenalty
  \saythe\holdinginserts
 %\saythe\insertpenalties
 %\say\@@topmark
 %\say\saved@@topmark
 %\say\@@firstmark
 %\say\saved@@firstmark
 %\say\@@botmark
 %\say\saved@@botmark
 %\say\thepagegrid
  \say\@tempa
  \def\@tempb{\@message@saved}%
  \@ifx{\@tempa\@tempb}{\expandafter\say\@tempa}{}%
  {\tracingall\scrollmode
   \showbox\@cclv
   \showbox\pagesofar
   \showbox\footins
   \showlists
  }%
 }{}%
 \@ifnotrelax\@tempa{\@tempa}{\the\output}%
}%
\@booleanfalse\outputdebug@sw
\output={%
 \move@insert@sw{%
  \hold@insertions
  \set@top@firstmark
  \@ifnum{\outputpenalty=\do@newpage@pen}{%
   \setbox\@cclv\vbox{\unvbox\@cclv\setbox\z@\lastbox\unskip}%
  }{}%
  \csname output@prep@\bot@envir \endcsname
  \@makecol
  \csname output@column@\thepagegrid\endcsname
  \set@colroom
  \global\@mparbottom\z@
  \global\@textfloatsheight\z@ %FIXME: this variable is set, but never queried!
  \protect@penalty\do@startcolumn@pen
  \csname output@post@\bot@envir \endcsname
 }{%
  \move@insertions
  \csname output@init@\bot@envir \endcsname
  \dead@cycle@tested
 }%
}%
\def\protect@penalty#1{%
 \nointerlineskip\null\penalty-#1%
}%
\def\dead@cycle{%
 \@@mark{\@@botmark}%
 \unvbox\@cclv
 \@ifnum{\outputpenalty<\@M}{\penalty\outputpenalty}{}%
}%
\def\dead@cycle@tested{%
 \setbox\@cclv\vbox{\unvbox\@cclv}%
 \@ifdim{\ht\@cclv=\z@}{%
  \@ifdim{\dp\@cclv=\z@}{%
   \@ifdim{\wd\@cclv=\z@}{%
    \true@sw
   }{%
    \false@sw
   }%
  }{%
   \false@sw
  }%
 }{%
  \false@sw
 }{%
  \setbox\z@\box\@cclv
  \@ifnum{\outputpenalty<\@M}{\penalty\outputpenalty}{}%
 }{%
  \dead@cycle
 }%
}%
\def\output@init@document{%
 \@ifvoid\footbox{}{%
  \global\advance\vsize-\ht\footbox
  \global\advance\vsize-\dp\footbox
 }%
}%
\def\output@prep@document{%
 \@ifvoid\footbox{}{%
  \setbox\footins\vbox{\unvbox\footbox\unvbox\footins}%
 }%
}%
\def\output@post@document{}%
\let\@opcol\@undefined
\def\@makecol{%
 \setbox\@outputbox\vbox{%
  \boxmaxdepth\@maxdepth
  \@tempdima\dp\@cclv
  \unvbox\@cclv
  \vskip-\@tempdima
 }%
 \@combineinserts\@outputbox\footins
 \xdef\@freelist{\@freelist\@midlist}\global\let\@midlist\@empty
 \@combinefloats
 \@ifvbox\@kludgeins{%
  \@makespecialcolbox
 }{%
  \set@adj@colht\dimen@
  \setbox\@outputbox\vbox to\dimen@{%
   \@texttop
   \dimen@\dp\@outputbox
   \unvbox\@outputbox
   \vskip-\dimen@
   \@textbottom
  }%
 }%
 \global\maxdepth\@maxdepth
}%
\def\@combineinserts#1#2{%
 \setbox#1\vbox{%
  \unvbox#1%
  \vbox{%
   \@ifvoid#2{}{%
    \vskip\skip\footins
    \color@begingroup
    \normalcolor
    \footnoterule
    \nointerlineskip
    \box#2%
    \color@endgroup
   }{}%
  }%
 }%
}%
\appdef\@floatplacement{%
 \global\@fpmin\@fpmin
}%
\mathchardef\pagebreak@pen=\@M
\expandafter\let\csname output@-\the\pagebreak@pen\endcsname\relax
\mathchardef\do@startcolumn@pen=10005
\@namedef{output@-\the\do@startcolumn@pen}{%
 \clearpage@sw{\@clearfloatplacement}{\@floatplacement}%
 \set@colroom
 \commit@deferred\@deferlist\@scolelt\@colroom
 \set@vsize
}%
\mathchardef\do@startpage@pen=10006
\@namedef{output@-\the\do@startpage@pen}{%
 \clearpage@sw{\@clearfloatplacement}{\@dblfloatplacement}%
 \set@colht
 \commit@deferred\@dbldeferlist\@sdblcolelt\@colht
}%
\def\commit@deferred#1#2#3{%
 \setbox\@cclv\vbox{\unvbox\@cclv\setbox\z@\lastbox\unskip}%
 \begingroup
  \@colht#3%
  \@tryfcolumn#1%
 \endgroup
 \fcolmade@sw{%
  \setbox\@cclv\vbox{\unvbox\@outputbox\unvbox\@cclv}%
  \outputpenalty-\pagebreak@pen % ask for a return visit, this time with insertions and all.
 }{%
  \begingroup
   \let\reserved@b#1\global\let#1\@empty
   \let\@elt#2\reserved@b
  \endgroup
  \outputpenalty\@M
 }%
 \dead@cycle
}%
\def\@addtonextcol{%
 \begingroup
   \@insertfalse
   \@setfloattypecounts
   \@ifnum{\@fpstype=8 }{}{%
     \@ifnum{\@fpstype=24 }{}{%
       \@flsettextmin
       \@reqcolroom \ht\@currbox
       \advance \@reqcolroom \@textmin
       \advance \@reqcolroom \vsize % take into account split insertions
       \advance \@reqcolroom -\pagegoal
       \@ifdim{\@colroom>\@reqcolroom}{%
         \@flsetnum \@colnum
         \@ifnum{\@colnum>\z@}{%
            \@bitor\@currtype\@deferlist
            \@if@sw\if@test\fi{}{%
              \@addtotoporbot
            }%
         }{}%
       }{}%
     }%
   }%
   \@if@sw\if@insert\fi{}{%
     \@cons\@deferlist\@currbox
   }%
 \endgroup
}%
\def\@tryfcolumn #1{%
  \global\@booleanfalse\fcolmade@sw
  \@ifx@empty#1{}{%
    \xdef\@trylist{#1}%
    \global \let \@failedlist \@empty
    \begingroup
      \dimen@\vsize\advance\dimen@-\pagegoal\@ifdim{\dimen@>\z@}{%
       \advance\@fpmin-\dimen@
      }{}%
      \let \@elt \@xtryfc \@trylist
    \endgroup
    \fcolmade@sw{%
      \global\setbox\@outputbox\vbox{\vskip \@fptop}%
      \let \@elt \@wtryfc \@flsucceed
      \global\setbox\@outputbox\vbox{\unvbox\@outputbox
        \unskip \vskip \@fpbot
      }%
      \let \@elt \relax
      \xdef #1{\@failedlist\@flfail}%
      \xdef\@freelist{\@freelist\@flsucceed}%
    }{}%
  }%
}%
\def\@wtryfc #1{%
  \global\setbox\@outputbox\vbox{\unvbox\@outputbox
    \box #1\vskip\@fpsep
  }%
}%
\def\@xtryfc #1{%
  \@next\reserved@a\@trylist{}{}% trim \@trylist. Ugly!
  \@currtype \count #1%
  \divide\@currtype\@xxxii\multiply\@currtype\@xxxii
  \@bitor \@currtype \@failedlist
  \@testfp #1%
  \@ifdim{\ht #1>\@colht}{%
    \@testtrue
  }{}%
  \@if@sw\if@test\fi{%
    \@cons\@failedlist #1%
  }{%
    \begingroup
      \gdef\@flsucceed{\@elt #1}%
      \global\let\@flfail\@empty
      \@tempdima\ht #1%
      \let \@elt \@ztryfc \@trylist
      \@ifdim{\@tempdima >\@fpmin}{%
        \global\@booleantrue\fcolmade@sw
      }{%
        \@cons\@failedlist #1%
      }%
    \endgroup
    \fcolmade@sw{%
      \let \@elt \@gobble
    }{}%
  }%
}%
\def\@ztryfc #1{%
  \@tempcnta \count#1%
  \divide\@tempcnta\@xxxii\multiply\@tempcnta\@xxxii
  \@bitor \@tempcnta {\@failedlist \@flfail}%
  \@testfp #1%
  \@tempdimb\@tempdima
  \advance\@tempdimb \ht#1\advance\@tempdimb\@fpsep
  \@ifdim{\@tempdimb >\@colht}{%
    \@testtrue
  }{}%
  \@if@sw\if@test\fi{%
    \@cons\@flfail #1%
  }{%
    \@cons\@flsucceed #1%
    \@tempdima\@tempdimb
  }%
}%
\def\cleardoublepage{%
 \clearpage
 \@if@sw\if@twoside\fi{%
  \@ifodd\c@page{}{%
   \null\clearpage
  }%
 }{}%
}%
\def\clearpage{%
 \do@output@MVL{%
  \global\@booleantrue\clearpage@sw
  \protect@penalty\do@newpage@pen
  \protect@penalty\do@endpage@pen
 }%
 \do@output@MVL{\global\@booleanfalse\clearpage@sw}%
}%
\@booleanfalse\clearpage@sw
\mathchardef\do@endpage@pen=10007
\@namedef{output@-\the\do@endpage@pen}{%
 \unvbox\@cclv\setbox\z@\lastbox
 \csname end@column@\thepagegrid\endcsname
}%
\mathchardef\do@newpage@pen=10001
\expandafter\let\csname output@-\the\do@newpage@pen\endcsname\relax
\def\@clearfloatplacement{%
 \global\@topnum     \maxdimen % \c@topnumber
 \global\@toproom    \maxdimen % \topfraction\@colht
 \global\@botnum     \maxdimen % \c@bottomnumber
 \global\@botroom    \maxdimen % \bottomfraction\@colht
 \global\@colnum     \maxdimen % \c@totalnumber
 \global\@dbltopnum  \maxdimen % \c@dbltopnumber
 \global\@dbltoproom \maxdimen % \dbltopfraction\@colht
 \global\@textmin    \z@       % \@colht\advance \@textmin -\@dbltoproom
 \global\@fpmin      \z@       % \dblfloatpagefraction\textheight
 \let\@testfp\@gobble
 \appdef\@setfloattypecounts{\@fpstype\@xxxii\advance\@fpstype\m@ne}%
}%
\let\@doclearpage\@undefined
\let\@makefcolumn\@undefined
\def\clr@top@firstmark{%
 \global\let\saved@@topmark\@undefined
 \global\let\saved@@firstmark\@empty
 \global\let\saved@@botmark\@empty
}%
\clr@top@firstmark
\def\set@top@firstmark{%
 \@ifxundefined\saved@@topmark{\expandafter\gdef\expandafter\saved@@topmark\expandafter{\@@topmark}}{}%
 \@ifempty\saved@@firstmark{\expandafter\gdef\expandafter\saved@@firstmark\expandafter{\@@firstmark}}{}%
 \@ifempty\@@botmark{}{\expandafter\gdef\expandafter\saved@@botmark\expandafter{\@@botmark}}%
}%
\appdef\@outputpage{%
 \clr@top@firstmark
}%
\def\end@float{%
 \minipagefootnotes
 \@endfloatbox
 \@ifnum{\@floatpenalty <\z@}{%
  \@largefloatcheck
  \@cons\@currlist\@currbox
  \@ifnum{\@floatpenalty <-\@Mii}{%
   \do@output@cclv{\@add@float}%
  }{%
   \vadjust{\do@output@cclv{\@add@float}}%
   \@Esphack
  }%
 }{}%
}%
\def\@dblfloat{%
 \@ifnum{\pagegrid@col=\@ne}{%
  \@float
 }{%
  \@dbflt
 }%
}%
\def\end@dblfloat{%
 \@ifnum{\pagegrid@col=\@ne}{%
  \end@float
 }{%
  \minipagefootnotes
  \@endfloatbox
  \@ifnum{\@floatpenalty <\z@}{%
    \@largefloatcheck
    % Note: here is the place to implement better placement of full-column-width floats
    \@cons\@dbldeferlist\@currbox %FIXME: should be done via output routine!
  }{}%
  \@ifnum{\@floatpenalty =-\@Mii}{\@Esphack}{}%
 }%
}%
\providecommand\minipagefootnotes{}%
\let\@specialoutput\@undefined
\def\@add@float{%
 \@pageht\ht\@cclv\@pagedp\dp\@cclv
 \unvbox\@cclv
 \@next\@currbox\@currlist{%
  \@ifnum{\count\@currbox>\z@}{%
   \advance \@pageht \@pagedp
   \advance \@pageht \vsize \advance \@pageht -\pagegoal % do not assume \holdinginserts is cleared!
   \@ifvbox\@kludgeins{%
    \@ifdim{\wd\@kludgeins=\z@}{%
     \advance \@pageht \ht\@kludgeins
    }{}%
   }{}%
   \@addtocurcol % Commit an h float
  }{%
   \@addmarginpar
  }%
 }\@latexbug
 \@ifnum{\outputpenalty<\z@}{%
  \@if@sw\if@nobreak\fi{%
   \nobreak
  }{%
   \addpenalty \interlinepenalty
  }%
 }{}%
 \set@vsize
}%
\let\@reinserts\@undefined
\def \@addtocurcol {%
   \@insertfalse
   \@setfloattypecounts
   \ifnum \@fpstype=8
   \else
     \ifnum \@fpstype=24
     \else
       \@flsettextmin
       \advance \@textmin \@textfloatsheight
       \@reqcolroom \@pageht
       \ifdim \@textmin>\@reqcolroom
         \@reqcolroom \@textmin
       \fi
       \advance \@reqcolroom \ht\@currbox
       \ifdim \@colroom>\@reqcolroom
         \@flsetnum \@colnum
         \ifnum \@colnum>\z@
           \@bitor\@currtype\@deferlist
           \if@test
           \else
             \@bitor\@currtype\@botlist
             \if@test
               \@addtobot
             \else
               \ifodd \count\@currbox
                 \advance \@reqcolroom \intextsep
                 \ifdim \@colroom>\@reqcolroom
                   \global \advance \@colnum \m@ne
                   \global \advance \@textfloatsheight \ht\@currbox
                   \global \advance \@textfloatsheight 2\intextsep
                   \@cons \@midlist \@currbox
                   \if@nobreak
                     \nobreak
                     \@nobreakfalse
                     \everypar{}%
                   \else
                     \addpenalty \interlinepenalty
                   \fi
                   \vskip \intextsep
                   \unvbox\@currbox %AO
                   \penalty\interlinepenalty
                   \vskip\intextsep
                   \ifnum\outputpenalty <-\@Mii \vskip -\parskip\fi
                   \outputpenalty \z@
                   \@inserttrue
                 \fi
               \fi
               \if@insert
               \else
                 \@addtotoporbot
               \fi
             \fi
           \fi
         \fi
       \fi
     \fi
   \fi
   \if@insert
   \else
     \@resethfps
     \@cons\@deferlist\@currbox
   \fi
}
\@twocolumnfalse
\let\@twocolumntrue\@twocolumnfalse
\def\@addmarginpar{%
 \@next\@marbox\@currlist{%
  \@cons\@freelist\@marbox\@cons\@freelist\@currbox
 }\@latexbug
 \setbox\@marbox\hb@xt@\columnwidth{%
  \csname @addmarginpar@\thepagegrid\endcsname{%
   \hskip-\marginparsep\hskip-\marginparwidth
   \box\@currbox
  }{%
   \hskip\columnwidth\hskip\marginparsep
   \box\@marbox
  }%
  \hss
 }%
 \setbox\z@\@currbox
    \@tempdima\@mparbottom
    \advance\@tempdima -\@pageht
    \advance\@tempdima\ht\@marbox
 \@ifdim{\@tempdima >\z@}{%
   \@latex@warning@no@line {Marginpar on page \thepage\space moved}%
 }{%
   \@tempdima\z@
 }%
    \global\@mparbottom\@pageht
    \global\advance\@mparbottom\@tempdima
    \global\advance\@mparbottom\dp\@marbox
    \global\advance\@mparbottom\marginparpush
    \advance\@tempdima -\ht\@marbox
    \global\setbox \@marbox
                   \vbox {\vskip \@tempdima
                          \box \@marbox}%
    \global \ht\@marbox \z@
    \global \dp\@marbox \z@
    \kern -\@pagedp
    \nointerlineskip
  \box\@marbox
    \nointerlineskip
    \hbox{\vrule \@height\z@ \@width\z@ \@depth\@pagedp}%
}%
\@namedef{output@-1073741824}{%"40000000
 \deadcycles\z@
 \setbox\z@\box\@cclv
}%
\mathchardef\save@column@pen=10016
\@namedef{output@-\the\save@column@pen}{\save@column}%
\let \@cclv@saved \@holdpg
\let \@holdpg \@undefined
\def\save@column{%
 \set@top@firstmark
 \global\@topmark@saved\expandafter{\@@topmark}%
 \global\setbox\@cclv@saved\vbox{%
  \unvbox\@cclv
  \lose@breaks
  \setbox\z@\lastbox
 }%
}%
\newtoks\@topmark@saved
\def\prep@cclv{%
 \setbox\z@\box\@cclv
 \setbox\@cclv\vbox{\unvbox\@cclv@saved}%
 \vbadness\@M
}%
\mathchardef\save@column@insert@pen=10017
\@namedef{output@-\the\save@column@insert@pen}{%
 \move@insert@sw{%
  \hold@insertions
  \save@column
  \global\setbox\footins@saved\box\footins
 }{%
  \move@insertions
  \dead@cycle
 }%
}%
\newbox\footins@saved
\mathchardef\save@message@pen=10018
\@namedef{output@-\the\save@message@pen}{%
 \setbox\z@\box\@cclv
 \toks@\expandafter{\@@firstmark}\xdef\@message@saved{\the\toks@}%
 \expandafter\@@mark\expandafter{\the\@topmark@saved}%
}%
\gdef   \@message@saved{}%
\mathchardef\execute@message@pen=10019
\@namedef{output@-\the\execute@message@pen}{%
 \@message@saved
}%
\def\execute@message{%
 \@execute@message\save@column@pen %Implicit #2
}%
\def\execute@message@insert#1{%
 \@execute@message\save@column@insert@pen{\setbox\footins\box\footins@saved#1}%
}%
\long\def\@execute@message#1#2{%
 \begingroup
  \dimen@\prevdepth\@ifdim{\dimen@<\z@}{\dimen@\z@}{}%
  \setbox\z@\vbox{%
   \protect@penalty#1%
   \nointerlineskip\null
   \toks@{\prep@cclv#2}\@@mark{\the\toks@}%
   \penalty-\save@message@pen
   \setbox\z@\null\dp\z@\dimen@\ht\z@-\dimen@
   \nointerlineskip\box\z@\penalty-\execute@message@pen
  }\unvbox\z@
 \endgroup
}%
\def\do@output@cclv{\execute@message}%
\def\do@output@MVL#1{%
 \@ifvmode{%
  \begingroup\execute@message{\unvbox\@cclv#1}\endgroup
 }{%
  \@ifhmode{%
   \vadjust{\execute@message{\unvbox\@cclv#1}}%
  }{%
   \@latexerr{\string\do@output@MVL\space cannot be executed in this mode!}\@eha
  }%
 }%
}%
\def\lose@breaks{%
 \loopwhile{%
  \count@\lastpenalty
  \@ifnum{\count@=\@M}{% 10000 is a TeX magic number!
   \unpenalty\true@sw
  }{%
   \false@sw
  }%
 }%
}%
\def\removestuff{\do@output@MVL{\unskip\unpenalty}}%
\def\removephantombox{%
 \vadjust{%
  \execute@message{%
   \unvbox\@cclv
   \setbox\z@\lastbox
   \unskip
   \unskip
   \unpenalty
   \penalty\predisplaypenalty
   \vskip\abovedisplayskip
  }%
 }%
}%
\def\addstuff#1#2{\edef\@tempa{\noexpand\do@output@MVL{\noexpand\@addstuff{#1}{#2}}}\@tempa}%
\def\@addstuff#1#2{%
 \skip@\lastskip\unskip
 \count@\lastpenalty\unpenalty
 \@ifempty{#1}{}{\penalty#1\relax}%
 \@ifnum{\count@=\z@}{}{\penalty\count@}%
 \vskip\skip@
 \@ifempty{#2}{}{\vskip#2\relax}%
}%
\def\replacestuff#1#2{\edef\@tempa{\noexpand\do@output@MVL{\noexpand\@replacestuff{#1}{#2}}}\@tempa}%
\def\@replacestuff#1#2{%
 \skip@\lastskip\unskip
 \count@\lastpenalty\unpenalty
 \@ifempty{#1}{}{%
 \@ifnum{\count@>\@M}{}{%
   \@ifnum{\count@=\z@}{\count@=#1\relax}{%
    \@ifnum{\count@<#1\relax}{}{%
     \count@=#1\relax
    }%
   }%
 }%
 }%
 \@ifnum{\count@=\z@}{}{\penalty\count@}%
 \@ifempty{#2}{}{%
  \@tempskipa#2\relax
  \@ifdim{\z@>\@tempskipa}{%
   \advance\skip@-\@tempskipa
  }{%
   \@ifdim{\skip@>\@tempskipa}{}{%
    \skip@\@tempskipa
   }%
  }%
 }%
 \vskip\skip@
}%
\def\move@insertions{\global\holdinginserts\z@}%
\def\hold@insertions{\global\holdinginserts\@ne}%
\hold@insertions
\def\move@insert@sw{\@ifnum{\holdinginserts=\z@}}%
\def\do@columngrid#1#2{%
 \par
 \expandafter\let\expandafter\@tempa\csname open@column@#1\endcsname
 \@ifx{\relax\@tempa}{%
  \class@warn{Unknown page grid #1. No action taken.}%
 }{%
  \do@output@MVL{\start@column{#1}{#2}}%
 }%
}%
\def\start@column#1#2{%
 \def\@tempa{#1}\@ifx{\@tempa\thepagegrid}{%
  \class@warn{Already in page grid \thepagegrid. No action taken.}%
 }{%
  \expandafter\execute@message@insert
  \expandafter{%
               \csname shut@column@\thepagegrid\expandafter\endcsname
               \csname open@column@#1\endcsname{#2}%
               \set@vsize
             }%
 }%
}%
\def\thepagegrid{one}%
\newbox\pagesofar
\newbox\footbox
\newcommand\onecolumngrid{\do@columngrid{one}{\@ne}}%
\let\onecolumn\@undefined
\def\open@column@one#1{%
 \unvbox\pagesofar
 \gdef\thepagegrid{one}%
 \global\pagegrid@col#1%
 \global\pagegrid@cur\@ne
 \set@colroom
 \set@column@hsize\pagegrid@col
}%
\def\shut@column@one{%
 \@makecol
 \global\setbox\pagesofar\vbox{\unvbox\@outputbox\recover@footins}%
 \set@colroom
}%
\def\end@column@one{%
 \@ifx@empty\@toplist{%
  \@ifx@empty\@botlist{%
   \false@sw
  }{%
   \true@sw
  }%
 }{%
  \true@sw
 }{%
  \protect@penalty\do@newpage@pen
  \protect@penalty\do@endpage@pen
 }{%
 }%
}%
\def\output@column@one{%
 \@outputpage
}%
\def\@addmarginpar@one{%
 \@if@sw\if@mparswitch\fi{%
  \@ifodd\c@page{\false@sw}{\true@sw}%
 }{\false@sw}{%
  \@if@sw\if@reversemargin\fi{\false@sw}{\true@sw}%
 }{%
  \@if@sw\if@reversemargin\fi{\true@sw}{\false@sw}%
 }%
}%
\newcommand\twocolumngrid{\do@columngrid{mlt}{\tw@}}%
\let\twocolumn\@undefined
\let\@topnewpage\@undefined
\def\open@column@mlt#1{%
 \gdef\thepagegrid{mlt}%
 \global\pagegrid@col#1%
 \global\pagegrid@cur\@ne
 \set@column@hsize\pagegrid@col
 \set@colroom
}%
\def\shut@column@mlt{%
 \@makecol
 \@ifnum{\pagegrid@cur<\pagegrid@col}{%
  \expandafter\global\expandafter\setbox\csname col@\the\pagegrid@cur\endcsname\box\@outputbox
  \global\advance\pagegrid@cur\@ne
 }{}%
 \csname balance@\the\pagegrid@col\endcsname
 \grid@column{}%
 \@combinepage
 \global\setbox\pagesofar\box\@outputbox
 \set@colroom
}%
\def\end@column@mlt{%
 \@ifx@empty\@toplist{%
  \@ifx@empty\@botlist{%
   \@ifx@empty\@dbltoplist{%
    \@ifx@empty\@dbldeferlist{%
     \@ifnum{\pagegrid@cur=\@ne}{%
      \false@sw
     }{%
      \true@sw
     }%
    }{%
     \true@sw
    }%
   }{%
    \true@sw
   }%
  }{%
   \true@sw
  }%
 }{%
  \true@sw
 }%
 % true = kick out a page and try again
 {%
  \protect@penalty\do@newpage@pen
  \protect@penalty\do@endpage@pen
 }{%
 }%
}%
\def\output@column@mlt{%
 \@ifnum{\pagegrid@cur<\pagegrid@col}{%
  \expandafter\global\expandafter\setbox\csname col@\the\pagegrid@cur\endcsname\box\@outputbox
  \global\advance\pagegrid@cur\@ne
 }{%
  \set@adj@colht\dimen@
  \grid@column{\dimen@}%
  \@combinepage
  \@combinedblfloats
  \@outputpage
  \global\pagegrid@cur\@ne
  \protect@penalty\do@startpage@pen
 }%
}%
\let\@outputdblcol\@undefined
\def\@addmarginpar@mlt{% emits a boolean
 \@ifnum{\pagegrid@cur=\@ne}%
}%
\let\pagegrid@cur\col@number
\let\col@number\@undefined
\newcount\pagegrid@col
\pagegrid@cur\@ne
\expandafter\let\csname col@\the\pagegrid@cur\endcsname\@leftcolumn
\let\@leftcolumn\@undefined
\pagegrid@col\tw@
\def\pagegrid@init{%
 \advance\pagegrid@cur\@ne
 \@ifnum{\pagegrid@cur<\pagegrid@col}{%
  \csname newbox\expandafter\endcsname\csname col@\the\pagegrid@cur\endcsname
  \pagegrid@init
 }{%
 }%
}%
\appdef\class@documenthook{%
 \pagegrid@init
}%
\def\grid@column#1{%
 \global\setbox\@outputbox\vbox{%
  \hb@xt@\textwidth{%
   \vrule\@height\z@\@width\z@\@ifempty{#1}{}{\@depth#1}%
   \pagegrid@cur\@ne
   \append@column
   \box@column\@outputbox
  }%
  \vskip\z@skip % FIXME: page depth!
 }%
}%
\def\append@column{%
 \@ifnum{\pagegrid@cur<\pagegrid@col}{%
  \expandafter\box@column\csname col@\the\pagegrid@cur\endcsname
  \hfil
  \vrule \@width\columnseprule
  \hfil
  \advance\pagegrid@cur\@ne
  \append@column
 }{%
 }%
}%
\def\box@column#1{%
 \raise\topskip
 \hb@xt@\columnwidth{%
  \outputdebug@sw{\saythe\vsize}{}%
  \vtop
  \@ifdim{\ht#1>\vsize}{to\vsize}{}%
  {\hrule\@height\z@\unvbox#1}%
  \hss
 }%
}%
\def\marry@baselines{%
 \skip@\baselineskip\advance\skip@-\topskip %FIXME: cannot assume \baselineskip!
 \@ifdim{\skip@>\z@}{\vskip\skip@}{}%
}%
\def\@combinepage{%
 \@ifvoid\pagesofar{}{%
  \setbox\@outputbox\vbox{%
   \unvbox\pagesofar
   \marry@baselines
   \unvbox\@outputbox
  }%
 }%
}%
\def\@combinedblfloats{%
 \@ifx@empty\@dbltoplist{}{%
  \setbox\@tempboxa\vbox{}%
  \let\@elt\@comdblflelt\@dbltoplist
  \let\@elt\relax\xdef\@freelist{\@freelist\@dbltoplist}%
  \global\let\@dbltoplist\@empty
  \setbox\@outputbox\vbox to\textheight{%
   %\boxmaxdepth\maxdepth   %% probably not needed, CAR
   \unvbox\@tempboxa\unskip
   \@ifnum{\@dbltopnum>\m@ne}{\dblfigrule}{}%FIXME: how is \@dbltopnum maintained?
   \vskip\dbltextfloatsep
   \unvbox\@outputbox
  }%
 }%
}%
\def\set@column@hsize#1{%
 \pagegrid@col#1%
 \global\columnwidth\textwidth
 \global\advance\columnwidth\columnsep
 \global\divide\columnwidth\pagegrid@col
 \global\advance\columnwidth-\columnsep
 \global\hsize\columnwidth
 \global\linewidth\columnwidth
}%
\def\set@colht{%
 \global\@colht\textheight
 \set@colroom
}%
\def\set@colroom{%
 \set@adj@colht\@colroom
 \global\@colroom\@colroom
 \set@vsize
}%
\def\set@vsize{%
 \global\vsize\@colroom
}%
\def\set@adj@colht#1{%
 #1\@colht\advance#1-\ht\pagesofar\advance#1-\dp\pagesofar
}%
\appdef\@outputpage{%
 \set@colht
 \@floatplacement    % FIXME: needed?
 \@dblfloatplacement % FIXME: needed?
}%
\@namedef{balance@2}{%
 \expandafter\balance@two\csname col@1\endcsname\@outputbox
 % Avoid a bug by preventing a restore when leaving this group
 \global\setbox\csname col@1\endcsname\box\csname col@1\endcsname
}%
\def\balance@two#1#2{%
\outputdebug@sw{{\tracingall\scrollmode\showbox#1\showbox#2}}{}%
 \setbox\@ne\vbox{%
  \@ifvoid#1{}{%
   \unvcopy#1\recover@footins
   \@ifvoid#2{}{\marry@baselines}%
  }%
  \@ifvoid#2{}{%
   \unvcopy#2\recover@footins
  }%
 }%
 \dimen@\ht\@ne\divide\dimen@\tw@
 \dimen@i\dimen@
 \vbadness\@M
 \vfuzz\dimen@i
 \loopwhile{%
  \dimen@i=.5\dimen@i
  \setbox\z@\copy\@ne\setbox\tw@\vsplit\z@ to\dimen@
  \setbox\z@ \vbox{\unvbox\z@ \setbox\z@\lastbox\dimen@\dp\z@\box\z@\vskip-\dimen@}%
  \setbox\tw@\vbox{\unvbox\tw@\setbox\z@\lastbox\dimen@\dp\z@\box\z@\vskip-\dimen@}%
  \dimen@ii\ht\tw@\advance\dimen@ii-\ht\z@
  \@ifdim{\dimen@i>.5\p@}{%
   \advance\dimen@\@ifdim{\dimen@ii<\z@}{}{-}\dimen@i
   \true@sw
  }{%
   \@ifdim{\dimen@ii<\z@}{%
    \advance\dimen@\tw@\dimen@i
    \true@sw
   }{%
    \false@sw
   }%
  }%
 }%
\outputdebug@sw{{\tracingall\scrollmode\showbox\tw@\showbox\z@}}{}%
 \setbox#1\box\tw@
 \setbox#2\box\z@
}%
\def\recover@footins{%
 \skip\z@ \lastskip\unskip
 \skip\@ne\lastskip\unskip
 \setbox\z@\lastbox
 \setbox\z@\vbox{%
  \unvbox\z@
  \setbox\z@\lastbox
  \@ifvoid\z@{}{%
   \global\setbox\footbox\vbox{\unvbox\footbox\unvbox\z@}%
  }%
 }%
}%
\prepdef\@begindocumenthook{%
 \open@column@one\@ne
 \set@colht
 \@floatplacement
 \@dblfloatplacement
}%
\def\longtable@longtable{%
 \par
 \ifx\multicols\@undefined\else\ifnum\col@number>\@ne\@twocolumntrue\fi\fi
 \if@twocolumn\LT@err{longtable not in 1-column mode}\@ehc\fi
 \begingroup
 \@ifnextchar[\LT@array{\LT@array[x]}%
}%
\def\longtable@new{%
 \par
  \@ifnextchar[\LT@array{\LT@array[x]}%
}%
\def\endlongtable@longtable{%
  \crcr
  \noalign{%
    \let\LT@entry\LT@entry@chop
    \xdef\LT@save@row{\LT@save@row}}%
  \LT@echunk
  \LT@start
  \unvbox\z@
  \LT@get@widths
  \if@filesw
    {\let\LT@entry\LT@entry@write\immediate\write\@auxout{%
      \gdef\expandafter\noexpand
        \csname LT@\romannumeral\c@LT@tables\endcsname
          {\LT@save@row}}}%
  \fi
  \ifx\LT@save@row\LT@@save@row
  \else
    \LT@warn{Column \@width s have changed\MessageBreak
             in table \thetable}%
    \LT@final@warn
  \fi
  \endgraf\penalty -\LT@end@pen
  \endgroup
  \global\@mparbottom\z@
  \pagegoal\vsize
  \endgraf\penalty\z@\addvspace\LTpost
  \ifvoid\footins\else\insert\footins{}\fi
}%
\def\endlongtable@new{%
  \crcr
  \noalign{%
   \let\LT@entry\LT@entry@chop
   \xdef\LT@save@row{\LT@save@row}%
  }%
  \LT@echunk
  \LT@start
  \unvbox\z@
  \LT@get@widths
  \@if@sw\if@filesw\fi{%
   {%
    \let\LT@entry\LT@entry@write
    \immediate\write\@auxout{%
     \gdef\expandafter\noexpand\csname LT@\romannumeral\c@LT@tables\endcsname
     {\LT@save@row}%
    }%
   }%
  }{}%
  \@ifx\LT@save@row\LT@@save@row{}{%
   \LT@warn{%
    Column \@width s have changed\MessageBreak in table \thetable
   }\LT@final@warn
  }%
  \endgraf
  \nobreak
  \box\@ifvoid\LT@lastfoot{\LT@foot}{\LT@lastfoot}%
 \global\@mparbottom\z@
 \endgraf
 \LT@post
}%
\def\LT@start@longtable{%
 \let\LT@start\endgraf
 \endgraf
 \penalty\z@
 \vskip\LTpre
 \dimen@\pagetotal
 \advance\dimen@ \ht\ifvoid\LT@firsthead\LT@head\else\LT@firsthead\fi
 \advance\dimen@ \dp\ifvoid\LT@firsthead\LT@head\else\LT@firsthead\fi
 \advance\dimen@ \ht\LT@foot
 \dimen@ii\vfuzz
 \vfuzz\maxdimen
   \setbox\tw@\copy\z@
   \setbox\tw@\vsplit\tw@ to \ht\@arstrutbox
   \setbox\tw@\vbox{\unvbox\tw@}%
 \vfuzz\dimen@ii
 \advance\dimen@ \ht
       \ifdim\ht\@arstrutbox>\ht\tw@\@arstrutbox\else\tw@\fi
 \advance\dimen@\dp
       \ifdim\dp\@arstrutbox>\dp\tw@\@arstrutbox\else\tw@\fi
 \advance\dimen@ -\pagegoal
 \ifdim \dimen@>\z@\vfil\break\fi
     \global\@colroom\@colht
 \ifvoid\LT@foot\else
   \advance\vsize-\ht\LT@foot
   \global\advance\@colroom-\ht\LT@foot
   \dimen@\pagegoal\advance\dimen@-\ht\LT@foot\pagegoal\dimen@
   \maxdepth\z@
 \fi
 \ifvoid\LT@firsthead\copy\LT@head\else\box\LT@firsthead\fi
 \output{\LT@output}%
}%
\def\LT@start@new{%
 \let\LT@start\endgraf
 \endgraf
 \markthr@@\@themark{}\do@mark\@themark
 \LT@pre
 \@ifvoid\LT@firsthead{\LT@top}{\box\LT@firsthead\nobreak}%
 \mark@envir\aftergroup\mark@envir
}%
\def\LT@end@hd@ft@longtable#1{%
 \LT@echunk
 \ifx\LT@start\endgraf
  \LT@err{Longtable head or foot not at start of table}{Increase LTchunksize}%
 \fi
 \setbox#1\box\z@
 \LT@get@widths\LT@bchunk
}%
\def\LT@end@hd@ft@new#1{%
 \LT@echunk
 \@ifx{\LT@start\endgraf}{%
  \LT@err{Longtable head or foot not at start of table}{Increase LTchunksize}%
 }%
 \global\setbox#1\box\z@
 \LT@get@widths
 \LT@bchunk
}%
\def\LT@array@longtable[#1]#2{%
  \refstepcounter{table}\stepcounter{LT@tables}%
  \if l#1%
    \LTleft\z@ \LTright\fill
  \else\if r#1%
    \LTleft\fill \LTright\z@
  \else\if c#1%
    \LTleft\fill \LTright\fill
  \fi\fi\fi
  \let\LT@mcol\multicolumn
  \let\LT@@tabarray\@tabarray
  \let\LT@@hl\hline
  \def\@tabarray{%
    \let\hline\LT@@hl
    \LT@@tabarray}%
  \let\\\LT@tabularcr\let\tabularnewline\\%
  \def\newpage{\noalign{\break}}%
  \def\pagebreak{\noalign{\ifnum`}=0\fi\@testopt{\LT@no@pgbk-}4}%
  \def\nopagebreak{\noalign{\ifnum`}=0\fi\@testopt\LT@no@pgbk4}%
  \let\hline\LT@hline \let\kill\LT@kill\let\caption\LT@caption
  \@tempdima\ht\strutbox
  \let\@endpbox\LT@endpbox
  \ifx\extrarowheight\@undefined
    \let\@acol\@tabacol
    \let\@classz\@tabclassz \let\@classiv\@tabclassiv
    \def\@startpbox{\vtop\LT@startpbox}%
    \let\@@startpbox\@startpbox
    \let\@@endpbox\@endpbox
    \let\LT@LL@FM@cr\@tabularcr
  \else
    \advance\@tempdima\extrarowheight
    \col@sep\tabcolsep
    \let\@startpbox\LT@startpbox\let\LT@LL@FM@cr\@arraycr
  \fi
  \setbox\@arstrutbox\hbox{\vrule
    \@height \arraystretch \@tempdima
    \@depth \arraystretch \dp \strutbox
    \@width \z@}%
  \let\@sharp##\let\protect\relax
   \begingroup
    \@mkpream{#2}%
    \xdef\LT@bchunk{%
       \global\advance\c@LT@chunks\@ne
       \global\LT@rows\z@\setbox\z@\vbox\bgroup
       \LT@setprevdepth
       \tabskip\LTleft\halign to\hsize\bgroup
      \tabskip\z@ \@arstrut \@preamble \tabskip\LTright \cr}%
  \endgroup
  \expandafter\LT@nofcols\LT@bchunk&\LT@nofcols
  \LT@make@row
  \m@th\let\par\@empty
  \everycr{}\lineskip\z@\baselineskip\z@
  \LT@bchunk
}%
\def\LT@LR@l{\LTleft\z@   \LTright\fill}%
\def\LT@LR@r{\LTleft\fill \LTright\z@  }%
\def\LT@LR@c{\LTleft\fill \LTright\fill}%
\def\LT@array@new[#1]#2{%
 \refstepcounter{table}\stepcounter{LT@tables}%
 \LTleft\fill \LTright\fill
 \csname LT@LR@#1\endcsname
 \let\LT@mcol\multicolumn
 \let\LT@@hl\hline
 \prepdef\@tabarray{\let\hline\LT@@hl}%
 \let\\\LT@tabularcr
 \let\tabularnewline\\%
 \def\newpage{\noalign{\break}}%
 \def\pagebreak{\noalign{\ifnum`}=0\fi\@testopt{\LT@no@pgbk-}4}%
 \def\nopagebreak{\noalign{\ifnum`}=0\fi\@testopt\LT@no@pgbk4}%
 \let\hline\LT@hline
 \let\kill\LT@kill
 \let\caption\LT@caption
 \@tempdima\ht\strutbox
 \let\@endpbox\LT@endpbox
 \@ifxundefined\extrarowheight{%
  \let\@acol\@tabacol
  \let\@classz\@tabclassz
  \let\@classiv\@tabclassiv
  \def\@startpbox{\vtop\LT@startpbox}%
  \let\@@startpbox\@startpbox
  \let\@@endpbox\@endpbox
  \let\LT@LL@FM@cr\@tabularcr
 }{%
  \advance\@tempdima\extrarowheight
  \col@sep\tabcolsep
  \let\@startpbox\LT@startpbox
  \let\LT@LL@FM@cr\@arraycr
 }%
 \let\@acoll\@tabacoll
 \let\@acolr\@tabacolr
 \let\@acol\@tabacol
 \setbox\@arstrutbox\hbox{%
  \vrule
  \@height \arraystretch \@tempdima
  \@depth \arraystretch \dp \strutbox
  \@width \z@
 }%
 \let\@sharp##%
 \let\protect\relax
 \begingroup
  \@mkpream{#2}%
  \@mkpream@relax
  \edef\@preamble{\@preamble}%
  \prepdef\@preamble{%
   \global\advance\c@LT@chunks\@ne
   \global\LT@rows\z@
   \setbox\z@\vbox\bgroup
    \LT@setprevdepth
    \tabskip\LTleft
    \halign to\hsize\bgroup
     \tabskip\z@
     \@arstrut
  }%
  \appdef\@preamble{%
     \tabskip\LTright
     \cr
  }%
  \global\let\LT@bchunk\@preamble
 \endgroup
 \expandafter\LT@nofcols\LT@bchunk&\LT@nofcols
 \LT@make@row
 \m@th
 \let\par\@empty
 \everycr{}%
 \lineskip\z@
 \baselineskip\z@
 \LT@bchunk
}%
\def\switch@longtable{%
 \@ifpackageloaded{longtable}{%
  \@ifx{\longtable\longtable@longtable}{%
   \@ifx{\endlongtable\endlongtable@longtable}{%
    \@ifx{\LT@start\LT@start@longtable}{%
     \@ifx{\LT@end@hd@ft\LT@end@hd@ft@longtable}{%
      \@ifx{\LT@array\LT@array@longtable}{%
       \true@sw
      }{\false@sw}%
     }{\false@sw}%
    }{\false@sw}%
   }{\false@sw}%
  }{\false@sw}%
  {%
   \class@info{Patching longtable.}%
  }{%
   \class@info{Unrecognized longtable package. Please update REVTeX! (Proceeding with fingers crossed.)}%
  }%
  \let\longtable\longtable@new
  \let\endlongtable\endlongtable@new
  \let\LT@start\LT@start@new
  \let\LT@end@hd@ft\LT@end@hd@ft@new
  \let\LT@array\LT@array@new
 }{}%
}%
\def\LT@pre{\penalty\z@\vskip\LTpre}%
\def\LT@bot{\nobreak\copy\LT@foot\vfil}%
\def\LT@top{\copy\LT@head\nobreak}%
\def\LT@post{\penalty\z@\addvspace\LTpost}%
\def\LT@adj{%
 \setbox\z@\vbox{\null}\dimen@-\ht\z@
 \setbox\z@\vbox{\unvbox\z@\LT@bot}\advance\dimen@\ht\z@
 \global\advance\vsize-\dimen@
}%
\def\output@init@longtable{\LT@adj}%
\def\output@prep@longtable{\setbox\@cclv\vbox{\unvbox\@cclv\LT@bot}}%
\def\output@post@longtable{\LT@top}%
\let\output@init@theindex\@empty
\let\output@prep@theindex\@empty
\def\output@post@theindex{%
 \@ifodd\c@page{}{%
  \@ifnum{\pagegrid@cur=\@ne}{% we have the leftmost column of a verso page
   % insert the current top-level continued head
  }%
 }%
}%
\def\check@aux{\do@output@MVL{\do@check@aux}}%
\appdef\class@documenthook{%
 \switch@longtable
}%
\appdef\class@documenthook{%
 \class@inithook
}%
\def\class@inithook{}%
\appdef\class@inithook{%
 \@ifxundefined\twocolumn@sw{\@booleanfalse\twocolumn@sw}{}%
}%
\appdef\class@inithook{%
 \@ifxundefined\footinbib@sw{\@booleanfalse\footinbib@sw}{}%
}%
\appdef\class@inithook{%
 \@ifxundefined\preprintsty@sw{\@booleanfalse\preprintsty@sw}{}%
}%
\appdef\class@inithook{%
 \@ifxundefined\preprint@sw{\@booleantrue\preprint@sw}{}%
}%
\appdef\class@inithook{%
 \@ifxundefined\galley@sw{\@booleanfalse\galley@sw}{}%
}%
\appdef\class@inithook{%
 \@ifxundefined\showPACS@sw{\@booleanfalse\showPACS@sw}{}%
}%
\appdef\class@inithook{%
 \@ifxundefined\twoside@sw{\@booleanfalse\twoside@sw}{}%
 \twoside@sw{\@twosidetrue}{\@twosidefalse}%
}%
\appdef\class@inithook{%
 \@ifxundefined\draft@sw{\@booleanfalse\draft@sw}{}%
 \draft@sw{\overfullrule 5\p@}{\overfullrule\z@}%
}%
\appdef\class@inithook{%
 \@ifxundefined\tightenlines@sw{\@booleanfalse\tightenlines@sw}{}%
}%
\appdef\class@inithook{%
 \@ifxundefined\lengthcheck@sw{\@booleanfalse\lengthcheck@sw}{}%
}%
\appdef\class@inithook{%
 \@ifxundefined\eqsecnum@sw{\@booleanfalse\eqsecnum@sw}{}%
 \eqsecnum@sw{%
  \@addtoreset{equation}{section}%
  \def\theequation@prefix{\thesection.}%
 }{}%
}%
\appdef\class@inithook{%
 \@ifxundefined\byrevtex@sw{\@booleanfalse\byrevtex@sw}{}%
}%
\DeclareOption{checkin}{%
  \@booleantrue\dateinRH@sw
  \@booleantrue\preprintsty@sw
  \def\@pointsize{12}%
  \@booleantrue\showPACS@sw
}%
\@booleanfalse\dateinRH@sw
\def\checkindate{\dateinRH@sw{{\tiny(\today)}}{}}%
\DeclareOption{preprint}{%
  \@booleantrue\preprintsty@sw
  \def\@pointsize{12}%
}%
\DeclareOption{manuscript}{%
 \class@warn{Document class option manuscript is obsolete; use preprint instead}%
 \ExecuteOptions{preprint}%
}%
\DeclareOption{showpacs}{%
  \@booleantrue\showPACS@sw
}%
\DeclareOption{noshowpacs}{%
  \@booleanfalse\showPACS@sw
}%
\DeclareOption{nopreprintnumbers}{%
  \@booleanfalse\preprint@sw
}%
\DeclareOption{hyperref}{%
 \AtEndOfClass{%
\begingroup
\edef\@tempa{%
 \let
 \noexpand\@clsextension
 \noexpand\@empty
 \noexpand\RequirePackage{hyperref}%
 \def\noexpand
 \@clsextension{\@clsextension}%
}%
\expandafter
\endgroup
\@tempa
 }%
  \def\@pointsize{10}%
}%
\DeclareOption{10pt}{\def\@pointsize{10}}
\DeclareOption{11pt}{\def\@pointsize{11}}
\DeclareOption{12pt}{\def\@pointsize{12}}
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\DeclareOption{bibnotes}{\@booleantrue\bibnotes@sw}%
\DeclareOption{nobibnotes}{\@booleanfalse\bibnotes@sw}%
\appdef\class@inithook{%
 \@ifxundefined\bibnotes@sw{\@booleanfalse\bibnotes@sw}{}%
 \bibnotes@sw{%
  \let\author@note\rtx@bibnote
  \appdef\class@endpagegridhook{\auto@bib}%
 }{%
  \let\author@note\footnote
 }%
}%
\DeclareOption{footinbib}{\@booleantrue\footinbib@sw}
\DeclareOption{nofootinbib}{\@booleanfalse\footinbib@sw}
\DeclareOption{superbib}{%
 \def\place@bibnumber{\place@bibnumber@sup}%
}%
\DeclareOption{twoside}{\@booleantrue\twoside@sw \@mparswitchfalse}
\DeclareOption{oneside}{\@booleanfalse\twoside@sw\@mparswitchtrue}
\def\class@endpagegridhook{\par}%
\AtEndOfClass{%
 \appdef\class@enddocumenthook{%
  \class@endpagegridhook
  \close@column
 }%
 \appdef\class@inithook{%
  \@ifxundefined\close@column{%
   \let\close@column\close@column@default
  }{}%
 }%
}%
\DeclareOption{twocolumn}{%
  \@booleantrue\twocolumn@sw
}%
\DeclareOption{onecolumn}{%
  \@booleanfalse\twocolumn@sw
}%
\DeclareOption{galley}{%
  \ExecuteOptions{onecolumn}%
  \@booleantrue\galley@sw
  \appdef\set@pica@hook{%
    \advance\textwidth-\columnsep
    \textwidth.5\textwidth
  }%
}%
\DeclareOption{tightenlines}{\@booleantrue\tightenlines@sw}
\DeclareOption{lengthcheck}{\@booleantrue\lengthcheck@sw}
\DeclareOption{draft}{%
 \@booleantrue\draft@sw
}%
\DeclareOption{final}{%
 \@booleanfalse\draft@sw
}%
\DeclareOption{eqsecnum}{\@booleantrue\eqsecnum@sw}
\DeclareOption{secnumarabic}{\@booleantrue\secnumarabic@sw}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\DeclareOption{floats}{\@booleantrue\floats@sw\@booleanfalse\floatp@sw}
\DeclareOption{endfloats}{\@booleanfalse\floats@sw\@booleanfalse\floatp@sw}
\DeclareOption{endfloats*}{\@booleanfalse\floats@sw\@booleantrue\floatp@sw}
\appdef\class@inithook{%
 \@ifxundefined\floats@sw{\@booleantrue\floats@sw}{}%
 \@ifxundefined\floatp@sw{\@booleantrue\floatp@sw}{}%
}%
\DeclareOption{titlepage}{\@booleantrue\titlepage@sw}
\DeclareOption{notitlepage}{\@booleanfalse\titlepage@sw}
\appdef\defaults@hook{%
 \@ifxundefined\titlepage@sw{\@booleanfalse\titlepage@sw}{}%
}%
\def\change@society#1{%
 \def\@tempa{#1}%
 \@ifxundefined\@society{}{%
  \@ifx{\@tempa\@society}{}{%
   \class@warn{Conflicting society \@tempa<>\@society.}%
  }%
 }%
 \let\@society\@tempa
}%
\DeclareOption{aps}{\change@society{aps}\def\@journal{}}%
\DeclareOption{pra}{\change@society{aps}\def\@journal{pra}}%
\DeclareOption{prb}{\change@society{aps}\def\@journal{prb}}%
\DeclareOption{prc}{\change@society{aps}\def\@journal{prc}}%
\DeclareOption{prd}{\change@society{aps}\def\@journal{prd}}%
\DeclareOption{pre}{\change@society{aps}\def\@journal{pre}}%
\DeclareOption{prl}{\change@society{aps}\def\@journal{prl}}%
\DeclareOption{prstab}{\change@society{aps}\def\@journal{prstab}}%
\DeclareOption{rmp}{\change@society{aps}\def\@journal{rmp}}%
\DeclareOption{amsfonts}{%
  \def\class@amsfonts{\RequirePackage{amsfonts}}%
}%
\DeclareOption{noamsfonts}{%
  \let\class@amsfonts\@empty
}%
\AtEndOfClass{%
 \@ifxundefined\class@amsfonts{}{\class@amsfonts}%
}%
\DeclareOption{amssymb}{%
  \def\class@amssymb{\RequirePackage{amssymb}}%
}%
\DeclareOption{noamssymb}{%
  \let\class@amssymb\@empty
}%
\AtEndOfClass{%
 \@ifxundefined\class@amssymb{}{\class@amssymb}%
}%
\DeclareOption{groupedaddress}{\clo@groupedaddress}%
\def\clo@groupedaddress{%
 \@booleantrue\groupauthors@sw
 \@booleantrue\@affils@sw
 \@booleanfalse\runinaddress@sw
}%
\appdef\class@inithook{%
 \@ifxundefined\groupauthors@sw{\clo@groupedaddress}{}%
}%
\DeclareOption{unsortedaddress}{\clo@unsortedaddress}%
\def\clo@unsortedaddress{%
 \@booleantrue\groupauthors@sw
 \@booleanfalse\@affils@sw
 \@booleanfalse\runinaddress@sw
}%
\DeclareOption{runinaddress}{\clo@runinaddress}%
\def\clo@runinaddress{%
 \@booleantrue\groupauthors@sw
 \@booleantrue\@affils@sw
 \@booleantrue\runinaddress@sw
}%
\DeclareOption{superscriptaddress}{\clo@superscriptaddress}%
\def\clo@superscriptaddress{%
 \@booleanfalse\groupauthors@sw
 \@booleantrue\@affils@sw
 \@booleanfalse\runinaddress@sw
}%
\DeclareOption{byrevtex}{\@booleantrue\byrevtex@sw}%
\DeclareOption*{%
 \IfFileExists{\CurrentOption\substyle@ext}{%
  \expandafter\change@society\expandafter{\CurrentOption}%
 }{%
  \OptionNotUsed
 }%
}%
\def\substyle@ext{.rtx}%
\AtEndOfClass{%
 \@ifxundefined\@society{%
  \class@warn{No Society specified, using generic APS style}%
  \def\@society{aps}\def\@journal{}%
 }{}%
 \expandafter\input\expandafter{\@society\substyle@ext}%
}%
\ExecuteOptions{10pt}
\ProcessOptions\relax
\def\ps@headings@twoside{%
    \let\@mkboth\markboth
    \let\@oddfoot\@empty
    \let\@evenfoot\@empty
    \def\@evenhead{\thepage\quad\checkindate\hfil \slshape \leftmark}%
    \def\@oddhead{{\slshape \rightmark}\hfil\checkindate\quad\thepage}%
    \def\sectionmark##1{%
      \markboth{%
       \MakeTextUppercase{%
        \@ifnum{\c@secnumdepth >\z@}{\thesection\hskip 1em\relax}{}%
         ##1%
       }%
       }{}%
    }%
    \def\subsectionmark##1{%
      \markright {%
        \@ifnum{\c@secnumdepth >\@ne}{\thesubsection\hskip 1em\relax}{}%
         ##1%
      }%
    }%
}%
\def\ps@headings@oneside{%
    \let\@mkboth\markboth
    \let\@oddfoot\@empty
    \let\@evenfoot\@empty
    \def\@oddhead{{\slshape \rightmark}\hfil\checkindate\quad\thepage}%
    \def\sectionmark##1{%
     \markright {%
      \MakeTextUppercase{%
       \@ifnum{\c@secnumdepth >\z@}{\thesection\hskip 1em\relax}{}%
       ##1%
      }%
     }%
    }%
}%
\def\ps@footer{%
    \let\@mkboth\markboth
    \def\@oddfoot{\hb@xt@\z@{\checkindate\hss}\hfil\thepage\hfil}%
    \def\@evenfoot{\hfil\thepage\hfil\hb@xt@\z@{\hss\checkindate}}%
    \def\@oddhead{}%
    \def\@evenhead{}%
    \def\sectionmark##1{}%
}%
\appdef\class@inithook{%
 \twoside@sw{%
  \let\ps@headings\ps@headings@twoside
 }{%
  \let\ps@headings\ps@headings@oneside
 }%
}%
\def\ps@myheadings{%
  \let\@mkboth\@gobbletwo
  \def\@oddhead{{\slshape\rightmark}\hfil\checkindate\quad\thepage}%
  \let\@oddfoot\@empty
  \def\@evenhead{\thepage\quad\checkindate\hfil\slshape\leftmark}%
  \let\@evenfoot\@empty
  \let\sectionmark\@gobble
  \let\subsectionmark\@gobble
}%
\def\ps@article{%
  \def\@evenhead{\thepage\quad\checkindate\hfil{\leftmark}}%
  \def\@oddhead{{\rightmark}\hfil\checkindate\quad\thepage}%
  \def\@oddfoot{}%
  \let\@evenfoot\@oddfoot
  \let\@mkboth\@gobbletwo
  \let\sectionmark\@gobble
  \let\subsectionmark\@gobble
}%
\def\lastpage@putlabel{%
 \if@filesw
  \begingroup
    \advance\c@page\m@ne
    \immediate\write\@auxout{\string\newlabel{LastPage}{{}{\thepage}}}%
  \endgroup
 \fi
}%
\AtEndOfClass{%
 \appdef\class@enddocumenthook{%
  \clearpage
  \lastpage@putlabel
  \let\clearpage\relax
 }%
}%
\RequirePackage{url}%
\appdef\class@inithook{%
 \incompatible@package{cite}%
 \incompatible@package{multicol}%
}%
\renewcommand\title{\@dblarg\do@title}%
\def\do@title[#1]#2{%
  \def\@title{#2}%
  \def\@shorttitle{#1}%
}%
\def\@title{\class@warn{No title}}%
\def\@shorttitle{}%
\newcounter{affil}
\renewcommand\author[1]{%
  \@author@sw{%
    \@addaffils
  }{}%
  \move@author
  \def\@author{{}{}{#1}{}}%
  \let\thanks\thanks@author
}%
\def\move@author{%
 \@author@sw{}{%
  \collaboration@sw{%
    \@booleanfalse\collaboration@sw
    \expandafter\appdef
    \expandafter\@authors@curr
    \expandafter{%
    \expandafter \@collaboration@opr
                 \@author
                }%
  }{%
    \expandafter\appdef
    \expandafter\@authors@curr
    \expandafter{%
    \expandafter \@author@opr
                 \@author
                }%
  }%
 }%
}%
\@booleanfalse\collaboration@sw
\def\collaboration#1{%
 \groupauthors@sw{%
  \class@warn{%
   \string\collaboration\space not allowed with groupaddress option.
   Use superscriptaddress instead
  }%
 }{%
  \@booleantrue\collaboration@sw
 }%
 \author{#1}%
}%
\def\@collaboration@opr#1#2#3#4{%
  \par
  {%
   \let\@affilID@temp\@empty
   \@author@opr{#1}{#2}{(\ignorespaces#3\unskip)}{#4}%
  }%
  \par
}%
\def\@collaboration@count{%
 \appdef@eval\@tempa{\the\@tempcnta}%
 \@tempcnta\z@
 \@gobblefour
}%
\def\@collaboration@present#1#2#3#4{%
 \par
 \@author@opr{#1}{#2}{(\ignorespaces#3\unskip)}{#4}\par
 \smallskip
 \reset@authorcount
}%
\def\@author@cleared{{}{}{}{}}%
\def\@author@init{\let\@author\@author@cleared\let\thanks\thanks@warning}%
\def\@author@sw{\@ifx{\@author\@author@cleared}}%
\appdef\class@inithook{%
 \@author@init
}%
\def\@author@join@i#1#2#3#4#5{%
  \def\@author{{\@join{\@separator}{#1}{#5}}{#2}{#3}{#4}}%
}%
\def\@author@join@ii#1#2#3#4#5{%
  \def\@author{{#1}{\@join{\@separator}{#2}{#5}}{#3}{#4}}%
}%
\def\@author@join@iii#1#2#3#4#5{%
  \def\@author{{#1}{#2}{\@join{\@separator}{#3}{#5}}{#4}}%
}%
\def\@author@join@iv#1#2#3#4#5{%
  \def\@author{{#1}{#2}{#3}{\@join{\@separator}{#4}{#5}}}%
}%
\def\@author@finish{%
 \@author@sw{}{%
  \move@author
  \begingroup
   \let\href\@secondoftwo
   \class@warn{No affiliation specified for \@author}%
  \endgroup
 }%
 \@addaffils
}%
\def\@join#1#2#3{%
  \@ifempty{#2}{#3}{#2#1#3}%
}%
\def\@separator{;\space}%
\let\surname\@firstofone
\let\firstname\@firstofone
\let\@authors@curr\@empty
\renewcommand\and{\class@err{\protect\and\space is not supported}}
\def\cat@comma@active{\catcode`\,\active}%
{\cat@comma@active\gdef,{\active@comma}}%
\def\active@comma{,\penalty-300\relax}%
\newcommand*\affiliation[1][]{\begingroup\cat@comma@active\@affiliation{#1}}%
\def\@affiliation#1#2{%
  \endgroup
  \move@author\@author@init
  \@booleanfalse\temp@sw
  \let\@tempd\@empty
  \@affils@sw{%
    \def\@tempa{#2}\let\@affil@opr\@affil@match\@affil@list
  }{}\temp@sw
  {%
   \def\@tempa{#1}%
   \@ifx{\@tempd\@tempa}{}{%
    \class@warn{%
     New footnote specified for \string\affiliation{#2}.
     Please put it on the *first* instance thereof.
    }%
   }%
  }%
  {%
    \stepcounter{affil}%
    \edef\@tempc{\theaffil}%
    \appdef     \@affil@list{\@affil@opr}%
    \appdef@eval\@affil@list\@tempc
    \appdef     \@affil@list{{#1}{#2}}%
  }%
  \appdef@eval\@affilID@curr\@tempc
}%
\newcommand\noaffiliation{%
  \move@author\@author@init
  \edef\@affilID@curr{\@affilID@curr}%
}%
\let\@authors\@empty
\def\@addaffils{%
    \appdef     \@authors{\@affilID@opr}%
    \appdef@eval\@authors{\@affilID@curr}%
    \appdef@e   \@authors{\@authors@curr}%
    \@booleanfalse\temp@sw
    \let\affils@opr\affils@match\affils@list
    \temp@sw{}{%
      \appdef     \affils@list{\affils@opr}%
      \appdef@eval\affils@list{\@affilID@curr}%
    }%
    \let\@authors@curr\@empty
    \let\@affilID@curr\@empty
}%
\let\affils@list\@empty
\let\@affil@list\@empty
\let\@affilID@curr\@empty
\def\@affil@match#1#2#3{%
  \def\@tempb{#3}%
  \@ifx{\@tempa\@tempb}{%
    \@booleantrue\temp@sw
    \def\@tempd{#2}%
    \def\@tempc{#1}%
  }{}%
}%
\def\@tempaffil@script#1#2{%
 ,\,#1%
}%
\def\@tempaffil@group#1#2{%
 \def\@tempc{#1}%
 \def\@tempb{#2}%
 \begingroup
  \let\@affil@opr\@affil@footnote\@affil@list
 \endgroup
}%
\def\@affil@footnote#1#2#3{%
  \def\@tempa{#1}%
  \@ifx{\@tempa\@tempc}{%
   \comma@space
   \footnote{\@tempb#3}%
   \footnote{#2}%
  }{}%
}%
\def\@affil@group#1#2#3{%
  \@ifnum{\count@=#1\relax}{%
    #3%
    \@ifempty{#2}{}{\footnote{#2}}%
    \after@address
    \advance\@tempcnta\m@ne
  }{}%
}%
\def\sanitize@url{%
 \@makeother\%%
 \@makeother\~%
 \@makeother\_%
}%
\newcommand*\email[1][Electronic address: ]{\begingroup\sanitize@url\@email{#1}}%
\def\@email#1#2{%
 \endgroup
 \expandafter\@author@join@ii\@author{#1\href{mailto:#2}{#2}}%
}%
\newcommand*\homepage[1][URL:~]{\begingroup\sanitize@url\@homepage{#1}}%
\def\@homepage#1#2{%
 \endgroup
 \expandafter\@author@join@ii\@author{#1\url{#2}}%
}%
\appdef\class@documenthook{%
 \providecommand\url{\texttt}%
 \providecommand\href[2]{\url{#2}}%
}%
\def\thanks@warning{%
 \class@warn{\string\thanks\space is valid only following \string\author.^^JPlease move it.}%
 \@gobble
}%
\let\thanks\thanks@warning
\def\thanks@author{%
  \expandafter\@author@join@ii\@author
}%
\newcommand*\altaffiliation[2][]{%
  \expandafter\@author@join@ii\@author{#1#2}%
}%
\def\@listand{\@ifnum{\@tempcnta=\tw@}{\andname\space}{}}%
\def\@listcomma{\@ifnum{\@tempcnta>\@ne}{,}{}}%
\def\@author@present@group#1#2#3#4{%
  \gdef\comma@space{\gdef\comma@space{\textsuperscript{,\,}}}%
  \doauthor{#1}{#2}{#3}{#4}%
  \advance\@tempcnta\m@ne
}%
\def\@author@present@script#1#2#3#4{%
  \gdef\comma@space{\textsuperscript{,\,}}%
  \doauthor{#1}{#2}{#3}{%
   \textsuperscript{\expandafter\@affilcomma\@affilID@temp\relax\relax}%
   #4%
  }%
  \advance\@tempcnta\m@ne
}%
\def\@affilcomma#1#2{%
  #1%
  \@ifx{\relax#2}{}{%
    ,\,\@affilcomma
  }%
  {#2}%
}%
\def\@doauthor@count{\advance\@tempcnta\@ne\@gobblefour}%
\def\doauthor#1#2#3#4{%
  \ignorespaces#3\unskip\@listcomma
  \@ifx{\@affilID@temp\@empty}{}{#4}%
  \@ifempty{#1#2}{}{%
   \@ifx{\@affilID@temp\@empty}{}{\comma@space}%
   \author@note{%
    % \ttfamily
    #1%
    \@ifempty{#1}{}{\@ifempty{#2}{}{, }}%
    #2%
   }%
  }%
  \space\@listand
}%#4
\def\@affilID@def#1{%
 \def\@affilID@temp{#1}%
}%
\let\@affilID@temp\@empty
\let\@affilID@opr\@affilID@def
\def\@affilID@count#1{%
  \def\@tempb{#1}%
  \@ifx{\@tempa\@tempb}{%
    \let\@author@opr\@doauthor@count
  }{%
    \let\@author@opr\@gobblefour
  }%
}%
\def\@affilID@match#1{%
 \def\@tempb{#1}%
 \@ifx{\@tempa\@tempb}{%
   \let\@author@opr\@author@present
 }{%
   \let\@author@opr\@gobblefour
 }%
}%
\def\@thanks{\comma@space\footnote}
\def\@affil@marked#1#2#3{%
  \par
  \begingroup
   \frontmatter@affiliationfont
   \textsuperscript{\normalfont#1}%
   #3\par
  \endgroup
}%
\def\affils@match#1{%
  \def\@tempa{#1}%
  \@ifx{\@affilID@curr\@tempa}{%
    \@booleantrue\temp@sw
  }{}%
}%
\def\do@affil@fromgroup#1#2{%
  \@ifx{\relax#2}{}{%
    \count@#2\relax
    #1\do@affil@fromgroup#1%
  }%
}%
\def\keywords#1{%
  \gdef\@keywords{#1}}
\def\@keywords{}
\renewcommand*\date[2][\Dated@name]{\def\@date{#1#2}}%
\def\@date{}%
\newcommand*\received[2][\Received@name]{\def\@received{#1#2}}%
\def\@received{}%
\newcommand*\revised[2][\Revised@name]{\def\@revised{#1#2}}%
\def\@revised{}%
\newcommand*\accepted[2][\Accepted@name]{\def\@accepted{#1#2}}%
\def\@accepted{}%
\newcommand*\published[2][\Published@name]{\def\@published{#1#2}}%
\def\@published{}%
\def\pacs#1{%
  \aftermaketitle@chk{\pacs}%
  \gdef\@pacs{#1}%
}%
\def\@pacs{}%{\class@warn{No PACS numbers}}%
\def\preprint#1{\gappdef\@preprint{\preprint{#1}}}%
\let\@preprint\@empty
\newbox\absbox
\newenvironment{abstract}{%
  \aftermaketitle@chk{\begin{abstract}}%
  \lrbox\absbox
   \minipage{\frontmatter@abstractwidth}%
    \frontmatter@abstractheading
    \frontmatter@abstractfont
    \let\footnote\mini@note
}{%
   \endminipage
  \endlrbox
}%
\def\frontmatter@abstractheading{%
 \begin{center}\large\abstractname\end{center}%
 \vspace{-1pc}%
}%
\def\frontmatter@abstractfont{}%
\def\frontmatter@abstractwidth{\textwidth}
\def\frontmatter@abstract@produce{%
  \addvspace\frontmatter@preabstractspace
  \leavevmode\box\absbox\mini@notes\par
  \addvspace\frontmatter@postabstractspace
}%
\def\frontmatter@preabstractspace{.5\baselineskip}
\def\frontmatter@postabstractspace{.5\baselineskip}
\newenvironment{titlepage}{%
      \twocolumn@sw{\onecolumngrid}{\newpage}%
      \thispagestyle{titlepage}%
      \setcounter{page}\@ne
}{%
     \twocolumn@sw{\twocolumngrid}{\newpage}%
     \twoside@sw{}{%
        \setcounter{page}\@ne
     }%
}%
\def\maketitle{%
  \@author@finish
  \title@column\titleblock@produce
  \suppressfloats[t]%
  \let\and\relax
  \let\affiliation\@gobble@opt@one
  \let\author\@gobble
  \@author@init
  \let\@authors\@empty
  \let\@authors@curr\@empty
  \let\@affil@list\@empty
  \let\keywords\@gobble
  \let\@keywords\@empty
  \let\email\@gobble
  \let\@address\@empty
  \let\maketitle\relax
  \let\thanks\@gobble
  \titlepage@sw{%
   \clearpage
  }{}%
}%
\def\titleblock@produce{%
 \begingroup
  \groupauthors@sw{%
   \let\@author@present\@author@present@group
   \let\frontmatter@author@produce\frontmatter@author@produce@group
   \let\@tempaffil\@tempaffil@group
  }{%
   \let\@author@present\@author@present@script
   \let\frontmatter@author@produce\frontmatter@author@produce@script
   \let\@tempaffil\@tempaffil@script
  }%
  \let\footnote\footnote@latex
  \let\thefootnote\frontmatter@thefootnote
  \global\c@footnote\@ne % FIXME: what if the title had a footnote?
  \let\@makefnmark\frontmatter@makefnmark
  \frontmatter@setup
  \thispagestyle{titlepage}\label{FirstPage}%
  \frontmatter@title@produce
  \frontmatter@author@produce
  \frontmatter@RRAPformat{%
   \expandafter\produce@RRAP\expandafter{\@date}%
   \expandafter\produce@RRAP\expandafter{\@received}%
   \expandafter\produce@RRAP\expandafter{\@revised}%
   \expandafter\produce@RRAP\expandafter{\@accepted}%
   \expandafter\produce@RRAP\expandafter{\@published}%
  }%
  \frontmatter@abstract@produce
  \@pacs@produce\@pacs
  \@keywords@produce\@keywords
  \par
  \addvspace\frontmatter@finalspace
  \par
 \endgroup
}%
\def\frontmatter@title@produce{%
 \begingroup\@title\par\endgroup
 \addvspace{\baselineskip}%
}%
\def\frontmatter@author@produce@group{%
  \begingroup
    \frontmatter@authorformat
    \let\@collaboration@opr\@gobblefour
    \let\affils@opr\affils@present\affils@list
    \par
  \endgroup
}%
\def\frontmatter@author@produce@script{%
  \begingroup
    \frontmatter@authorformat
    \let\@tempa\@empty
    \@tempcnta\z@
    \let\@affilID@opr\@gobble
    \let\@author@opr\@doauthor@count
    \let\@collaboration@opr\@collaboration@count
    \@authors
    \appdef@eval\@tempa{\the\@tempcnta}%
    \reset@authorcount
    \let\@affilID@opr\@affilID@def
    \let\@author@opr\@author@present
    \let\@collaboration@opr\@collaboration@present
    \@authors\unskip\unskip
    \par
    \frontmatter@above@affiliation
    \let\@affil@opr\@affil@marked\@affil@list
    \par
  \endgroup
}%
\def\affils@present#1{%
  \def\@tempa{#1}%
  \let\@affilID@opr\@affilID@count
  \begingroup
   \@tempcnta\z@
   \@authors
   \@ifnum{\@tempcnta=\z@}{}{%
    \begingroup
     \@ifnum{\@tempcnta=\tw@}{%
        \let\@listcomma\relax
     }{}%
     \let\@affilID@opr\@affilID@match\@authors
    \endgroup
    \begingroup
     \par
     \frontmatter@above@affiliation
     \frontmatter@affiliationfont
     \let\\\frontmatter@addressnewline
     \@tempcnta\z@
     \@tfor\@tempa:=#1\do{\advance\@tempcnta\@ne}%
     \@ifnum{\@tempcnta=\tw@}{%
      \let\@listcomma\@empty
     }{}%
     \def\after@address{\@listcomma\ \@listand}%
     \runinaddress@sw{}{%
      \tightenlines@sw{}{%
       \parskip\z@ %space between affilations in grouped mode
      }%
      \appdef\@listcomma\par
     }%
     \let\@affil@opr\@affil@group
     \do@affil@fromgroup\@affil@list#1\relax
    \endgroup
   }%
   \par
  \endgroup
 \smallskip
}%
\def\reset@authorcount{%
  \expandafter\@reset@ac\@tempa0\@reset@ac
  \@ifnum{\@tempcnta=\tw@}{%
    \let\@listcomma\relax
  }{%
    \def\@listcomma{\@ifnum{\@tempcnta>\@ne}{,}{}}%
  }%
}%
\def\@reset@ac#1#2\@reset@ac{%
  \@tempcnta#1%
  \def\@tempa{#2}%
}%
\def\@pacs@produce#1{%
 \showPACS@sw{\parbox[t]{\frontmatter@abstractwidth}{\@pacs@name#1}}{}%
}%
\def\@keywords@produce#1{%
}%
\def\frontmatter@thefootnote{\@fnsymbol\c@footnote}%
\def\frontmatter@makefnmark{\@textsuperscript{\normalfont\@thefnmark}}%
\long\def\frontmatter@makefntext#1{%
 \parindent 1em
 \noindent
 \@textsuperscript{\normalfont\@thefnmark}#1%
}%
\def\frontmatter@setup{}%
\def\frontmatter@RRAPformat#1{\begingroup#1\par\endgroup}%
\def\punct@RRAP{; }%
\def\produce@RRAP#1{%
  \@ifempty{#1}{}{%
   \@ifvmode{\leavevmode}{\unskip\punct@RRAP\ignorespaces}%
   #1%
  }%
}%
\def\frontmatter@authorformat{}%
\def\frontmatter@above@affiliation{}%
\def\frontmatter@affiliationfont{}%
\def\frontmatter@finalspace{2\baselineskip}
\def\frontmatter@addressnewline{%
  \@ifhmode{\skip@\lastskip\unskip\unpenalty\break\hskip\skip@}{}%
  % was: \vskip-.5ex
}%
\def\aftermaketitle@chk#1{%
  \@ifx{\maketitle\relax}{%
    \class@err{\protect#1 must be used before \protect\maketitle}%
  }{}%
}%
\def\ps@titlepage{\ps@empty}%
\def\volumeyear#1{\gdef\@volumeyear{#1}}%
\def\@volumeyear{}%
\def\volumenumber#1{\gdef\@volumenumber{#1}}%
\def\@volumenumber{}%
\def\issuenumber#1{\gdef\@issuenumber{#1}}%
\def\@issuenumber{}%
\def\eid#1{\gdef\@eid{#1}}%
\def\@eid{}%
\def\startpage#1{\gdef\@startpage{#1}\c@page#1\relax}%
\def\@startpage{\pageref{FirstPage}}%
\def\endpage#1{\gdef\@endpage{#1}}%
\def\@endpage{\pageref{LastPage}}%
\def\print@toc#1{%
 \begingroup
  \expandafter\section
  \expandafter*%
  \expandafter{%
              \csname#1name\endcsname
              }%
  \let\appendix\appendix@toc
  \@starttoc{#1}%
 \endgroup
}%
\def\appendix@toc{}%
\def\labelenumi{\theenumi.}
\def\theenumi{\arabic{enumi}}
\def\labelenumii{(\theenumii)}
\def\theenumii{\alph{enumii}}
\def\p@enumii{\theenumi}
\def\labelenumiii{\theenumiii.}
\def\theenumiii{\roman{enumiii}}
\def\p@enumiii{\theenumi(\theenumii)}
\def\labelenumiv{\theenumiv.}
\def\theenumiv{\Alph{enumiv}}
\def\p@enumiv{\p@enumiii\theenumiii}
\def\labelitemi{\textbullet}
\def\labelitemii{\normalfont\bseries\textendash}
\def\labelitemiii{\textasteriskcentered}
\def\labelitemiv{\textperiodcentered}
\pagenumbering{arabic}
\setcounter{topnumber}{2}
\def\topfraction{.7}
\setcounter{bottomnumber}{1}
\def\bottomfraction{.7}
\setcounter{totalnumber}{3}
\def\textfraction{.2}
\def\floatpagefraction{.9}
\setcounter{dbltopnumber}{2}
\def\dbltopfraction{.7}
\def\dblfloatpagefraction{.9}
\newenvironment{verse}{%
  \let\\=\@centercr
  \list{}{%
    \itemsep\z@ \itemindent -1.5em\listparindent \itemindent
    \rightmargin\leftmargin\advance\leftmargin 1.5em}\item[]%
}{%
 \endlist
}%
\newenvironment{quotation}{%
  \list{}{%
    \listparindent 1.5em
    \itemindent\listparindent
    \rightmargin\leftmargin \parsep \z@ \@plus\p@}\item[]%
}{%
 \endlist
}%
\newenvironment{quote}{%
  \list{}{%
  \rightmargin\leftmargin}\item[]%
}{%
 \endlist
}%
\def\descriptionlabel#1{%
  \hspace\labelsep \normalfont\bfseries #1%
}%
\newenvironment{description}{%
 \list{}{%
    \labelwidth\z@ \itemindent-\leftmargin
    \let\makelabel\descriptionlabel
 }%
}{%
 \endlist
}%
\newcounter{part}
\newcounter{section}
\newcounter{subsection}[section]
\newcounter{subsubsection}[subsection]
\newcounter{paragraph}[subsubsection]
\newcounter{subparagraph}[paragraph]
\def\thepart          {\Roman{part}} %
\def\thesection       {\Roman{section}}
\def\p@section        {}
\def\thesubsection    {\Alph{subsection}}
\def\p@subsection     {\thesection\,}
\def\thesubsubsection {\arabic{subsubsection}}
\def\p@subsubsection  {\thesection\,\thesubsection\,}
\def\theparagraph     {\alph{paragraph}}
\def\thesubparagraph  {\theparagraph.\arabic{subparagraph}}
\newenvironment{acknowledgments}{%
 \@ifx@empty\acknowledgmentsname{%
  \par
 }{%
  \section*{\acknowledgmentsname}%
 }%
}{%
 \par
}%
\newenvironment{acknowledgements}{%
 \replace@environment{acknowledgements}{acknowledgments}%
}{%
 \endacknowledgments
}%
\def\part{\par
   \addvspace{4ex}
   \@afterindentfalse
   \secdef\@part\@spart}
\def\@part[#1]#2{%
 \@ifnum{\c@secnumdepth >\m@ne}{%
        \refstepcounter{part}
        \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
 }{%
      \addcontentsline{toc}{part}{#1}%
 }%
 \begingroup
    \parindent \z@ \raggedright
    \interlinepenalty\@M
    \@ifnum{\c@secnumdepth >\m@ne}{%
      \Large \bf \partname~\thepart%
      \par\nobreak
    }{}%
    \huge \bf
    #2%
    \markboth{}{}\par
 \endgroup
   \nobreak
   \vskip 3ex
   \@afterheading
}%
\def\@spart#1{{\parindent \z@ \raggedright
    \interlinepenalty\@M
    \huge \bf
    #1\par}
    \nobreak
    \vskip 3ex
    \@afterheading}
\def\section{%
  \@startsection
    {section}%
    {1}%
    {\z@}%
    {0.8cm \@plus1ex \@minus .2ex}%
    {0.5cm \@plus1ex \@minus.2ex}%
    {%
      \normalfont\small\bfseries
      \centering
      \MakeTextUppercase
    }%
}%
\def\@sectioncntformat#1{\csname the#1\endcsname.\quad}%
\def\subsection{%
  \@startsection
    {subsection}%
    {2}%
    {\z@}%
    {.8cm \@plus1ex \@minus .2ex}%
    {.5cm \@plus1ex \@minus.2ex}%
    {%
     \normalfont\small\bfseries
     \centering
    }%
}%
\def\subsubsection{%
  \@startsection
    {subsubsection}%
    {3}%
    {\z@}%
    {.8cm \@plus1ex \@minus .2ex}%
    {.5cm \@plus1ex \@minus.2ex}%
    {%
     \normalfont\small\itshape
     \centering
    }%
}%
\def\paragraph{%
  \@startsection
    {paragraph}%
    {4}%
    {\parindent}%
    {\z@}%
    {-1em}%
    {\normalfont\normalsize\itshape}%
}%
\def\subparagraph{%
  \@startsection
    {subparagraph}%
    {5}%
    {\parindent}%
    {3.25ex \@plus1ex \@minus .2ex}%
    {-1em}%
    {\normalfont\normalsize\bseries}%
}%
\def\theequation{%
 \theequation@prefix\arabic{equation}%
}%
\def\theequation@prefix{}%
\AtEndOfClass{%
 \expandafter\input\expandafter{\@pointsize pt\substyle@ext}%
}%
\setcounter{secnumdepth}{4}
\lineskip 1pt
\normallineskip 1pt
\def\baselinestretch{1}%
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\arraycolsep 3pt
\tabcolsep 2pt
\arrayrulewidth .4pt
\doublerulesep 2pt
\skip\@mpfootins = \skip\footins
\fboxsep  = 3.0pt
\fboxrule = 0.4pt
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{2\p@}
\long\def\@makecaption#1#2{%
  \par
  \nobreak
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1: #2}%
  \@ifdim{\wd\@tempboxa >\hsize}{%
   \begingroup
    \flushing
    \let\footnote\@footnotemark@gobble
    #1: #2\par
   \endgroup
  }{%
    \global \@minipagefalse
    \hb@xt@\hsize{\unhbox\@tempboxa\hfil}%
  }%
  \vskip\belowcaptionskip
}%
\def\@footnotemark@gobble{%
 \@footnotemark
 \@ifnextchar[{\@gobble@opt@i}{\@gobble}%
}%
\def\@gobble@opt@i[#1]#2{}%
\def\@mpmakefntext#1{%
 \flushing
 \parindent=1em
 \noindent
 \hb@xt@1em{\hss\@makefnmark}%
 #1%
}%
\newcounter{figure}
\renewcommand \thefigure {\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\appdef\class@documenthook{%
 \do@if@floats{figure}{.fgx}%
}%
\appdef\class@enddocumenthook{%
 \printfigures\relax
}%
\newcommand\printfigures{%
 \@ifstar{\true@sw}{\floatp@sw{\true@sw}{\false@sw}}%
 {%
  \print@float{figure}{\oneapage}%
 }{%
  \print@float{figure}{}%
 }%
}%
\appdef\@xfloat@prep{%
 \appdef\@parboxrestore{\centering}%
 \let\@makefnmark\@makefnmark@latex
}%
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}
\newcounter{table}
\renewcommand\thetable{\@Roman\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\def\tabular@font{\small}%
\def\squeezetable{\def\tabular@font{\scriptsize}}%
\appdef\class@documenthook{%
 \floats@sw{}{%
  \let@environment{longtable@float}{longtable}%
  \let@environment{longtable}{longtable@write}%
 }%
 \do@if@floats{table}{.tbx}%
}%
\appdef\class@enddocumenthook{%
 \printtables\relax
}%
\newenvironment{longtable@write}{%
 \write@@float{longtable}{table}%
}{%
 \endwrite@float
}%
\newcommand\printtables{%
 \begingroup
  \let@environment{longtable}{longtable@float}%
  \prepdef\longtable{\trigger@float@par}%
  \@ifstar{\true@sw}{\floatp@sw{\true@sw}{\false@sw}}%
  {%
   \print@float{table}{\oneapage}%
  }{%
   \print@float{table}{}%
  }%
 \endgroup
}%
\def\tabular@hook{}%
\def\endtabular@hook{}%
\appdef\class@documenthook{%
 \@ifpackageloaded{dcolumn}{%
  \newcolumntype{d}{D{.}{.}{-1}}%
 }{}%
}%
\def\toprule{\hline\hline}%
\def\colrule{\hline}%
\def\botrule{\hline\hline}%
\newenvironment{ruledtabular}{%
 \def\array@default{v}%
 \appdef\tabular@font{\def\@halignto{to\hsize}}%
 \let\tableft@skip@default\tableft@skip
 \let\tableft@skip\tableft@skip@float
 \let\tabmid@skip@default\tabmid@skip
 \let\tabmid@skip\tabmid@skip@float
 \let\tabright@skip@default\tabright@skip
 \let\tabright@skip\tabright@skip@float
 \let\array@row@pre@default\array@row@pre
 \let\array@row@pre\array@row@pre@float
 \let\array@row@pst@default\array@row@pst
 \let\array@row@pst\array@row@pst@float
 \appdef\array@row@rst{%
  \let\array@row@pre\array@row@pre@default
  \let\array@row@pst\array@row@pst@default
  \let\tableft@skip\tableft@skip@default
  \let\tabmid@skip\tabmid@skip@default
  \let\tabright@skip\tabright@skip@default
  \appdef\tabular@font{\let\@halignto\@empty}%
 }%
}{%
}%
\newcommand\@makefntext[1]{%
  \def\baselinestretch{1}%
  \reset@font\footnotesize
  \parindent 1em%
  \noindent
  \hb@xt@1.8em{\hss\@makefnmark}%
  #1\par
}%
\newenvironment{thebibliography}{}{}%
\let\@listi\@empty
\RequirePackage[sort&compress]{natbib}[1999/05/28 7.0]%
\let\NAT@thebibliography\thebibliography
\let\NAT@endthebibliography\endthebibliography
\let\bibliographystyle@latex\bibliographystyle
\renewcommand\NAT@citesuper[3]{%
 \ifNAT@swa
  \leavevmode
  \unskip
  \textsuperscript{#1}%
  \if*#3*\else\ (#3)\fi
 \else
  #1%
 \fi
 \endgroup
}%
\def\@makefnmark@cite{\begingroup\NAT@swatrue\@cite{{\@thefnmark}}{}{}}%
\let\bibliographystyle@latex\bibliographystyle
\def\bibliographystyle{\def\@bibstyle}%
\def\bibsection{%
 \@ifx@empty\refname{%
  \par
 }{%
  \section*{\refname}%
 }%
}%
\def\class@bibsetup#1{\NAT@bibsetup{\ref{LastBibItem}}}%
\let\bibpreamble\@empty
\def\bibfont{%
 \bibsep\z@\relax
 \let\NAT@bibsetup\@bibsetup
 \let\@bibsetup\class@bibsetup
 \@ifxundefined\place@bibnumber{%
  \let\@biblabel\place@bibnumber@inl
 }{%
  \let\@biblabel\place@bibnumber
 }%
 \def\newblock{\ }%
}%
\let\NAT@citeyear\citeyear
\def\NAT@onlinecite#1{%
 \begingroup
  \let\@cite\NAT@citenum
  \let\NAT@mbox\mbox
  \let\citeyear\NAT@citeyear
  \def\NAT@space{ }%
  \cite{#1}%
 \endgroup
}%
\appdef\class@inithook{%
 \@ifxundefined\onlinecite{\def\onlinecite{\citealp}}{}%
 \@ifxundefined\textcite{\def\textcite{\citet}}{}%
}%
\renewenvironment{thebibliography}[1]{%
 \NAT@thebibliography{#1}%
 \@bibnotes
}{%
 \@endnotesinbib
 \edef\@currentlabel{\arabic{NAT@ctr}}%
 \label{LastBibItem}%
 \NAT@endthebibliography
 \aftergroup\let
 \aftergroup\auto@bib
 \aftergroup\@empty
}%
\def\place@bibnumber@sup#1{\textsuperscript{#1}}%
\def\place@bibnumber@inl#1{[#1]}%
\def\rtx@bibnote{\bib@note\@bibnotes}%Implicit #1
\def\bib@note#1#2{%
  \stepcounter\@mpfn
  \protected@xdef\@thefnmark{\thempfn}%
  \protected@xdef\@@thefnmark{\textsuperscript{\normalfont\thempfn}}%
  \@footnotemark
  \expandafter\g@addto@macro
  \expandafter#1%
  \expandafter{%
  \expandafter \item
  \expandafter [\@@thefnmark]#2\par
              }%
}%
\let\@bibnotes\@empty
\def\mini@note{\save@note\mini@notes}%Implicit #1
\def\save@note#1#2{%
  \stepcounter\@mpfn
  \protected@xdef\@thefnmark{\thempfn}%
  \@footnotemark
  \expandafter\g@addto@macro
  \expandafter#1%
  \expandafter{%
  \expandafter \@@footnotetext
  \expandafter {\@thefnmark}{#2}%
              }%
}%
\long\def\@@footnotetext#1{\def\@thefnmark{#1}\@footnotetext}%
\let\mini@notes\@empty
\def\endnote{%
 \@ifnextchar[{%
  \@xendnote
 }{%
  \stepcounter{footnote}%
  \protected@xdef\@thefnmark{\thefootnote}%
  \@footnotemark
  \@endnotetext
 }%
}%
\def\@xendnote[#1]{%
   \begingroup
     \c@footnote#1\relax
     \unrestored@protected@xdef\@thefnmark{\thefootnote}%
   \endgroup
   \@footnotemark
   \@endnotetext
}%
\def\endnote@ext{.end}%
\long\def\@endnotetext#1{%
  \@ifxundefined\@endnoteout{%
    \newwrite\@endnoteout
    \gdef\endnote@stream{\jobname\endnote@ext}%
    \immediate\openout\@endnoteout\endnote@stream\relax
  }{}%
  \begingroup
    \let\label\relax \let\index\relax \let\glossary\relax
    \let\cite\relax \let\ref\relax \let\pageref\relax
    \let\\\relax
    \let\protect\noexpand
    \newlinechar`\^^M%
    \immediate\write\@endnoteout{\noexpand\@doendnote{\@thefnmark}{#1}}%
  \endgroup
}%
\def\endnotetext{%
  \@ifnextchar[{%
   \@xendnotenext
  }{%
   \protected@xdef\@thefnmark{\thefootnote}\@endnotetext
  }%
}%
\def\@xendnotenext[#1]{%
  \begingroup
     \c@footnote#1\relax
     \unrestored@protected@xdef\@thefnmark{\thefootnote}%
  \endgroup
  \@endnotetext
}%
\def\printendnotes{%
 \@ifx{\@endnoteout\@undefined}{}{%
  \begingroup
   \c@secnumdepth-\maxdimen
   \section{%
    \notesname
   }%
   \immediate\closeout\@endnoteout
   \global\let\@endnoteout\@undefined
   \begin{enumerate}%
   \makeatletter
   \input{\endnote@stream}%
   \end{enumerate}%
  \endgroup
 }%
}%
\appdef\class@enddocumenthook{%
 \printendnotes
}%
\mathchardef\firstnote@num\z@
\appdef\class@documenthook{%
 \global\c@footnote\firstnote@num
 \appdef\maketitle{\global\c@footnote\firstnote@num}%
}%
\def\set@firstnote#1{%
 \@ifnum{\firstnote@num=#1\relax}{}{%
  \class@warn@end{Endnote numbers changed: rerun LaTeX}%
 }%
 \immediate\write\@mainaux{%
   \global\chardef\string\firstnote@num#1\relax
 }%
}%
\def\@endnotesinbib{%
 \set@firstnote\z@
}%
\def\@endnotesinbibliography{%
 \expandafter\set@firstnote\expandafter{\the\c@NAT@ctr}%
 \@ifx{\@endnoteout\@undefined}{}{%
  \immediate\closeout\@endnoteout
  \global\let\@endnoteout\@undefined
  \makeatletter
  \input{\endnote@stream}%
 }%
}%
\appdef\class@documenthook{%
 \footinbib@sw{%
  \let\footnote\endnote
  \let\printendnotes\relax
  \let\@endnotesinbib\@endnotesinbibliography
  \let\@makefnmark@latex\@makefnmark
  \let\@makefnmark\@makefnmark@cite
  \appdef\class@endpagegridhook{\auto@bib}%
 }{}%
}%
\def\auto@bib{%
 \@ifx@empty\@bibnotes{%
  \@ifxundefined\@endnoteout{%
   \false@sw
  }{%
   \true@sw
  }%
 }{%
  \true@sw
 }{%
  \begin{thebibliography}{}\end{thebibliography}%
 }%
}%
\def\@doendnote#1#2{\bibitem{endnote#1}#2}
\let\@bibnotes\@empty
\appdef\class@documenthook{%
 \preprintsty@sw{\ps@footer}{\ps@article}%
 \pagenumbering{arabic}%
 \normalsize
 \tabbingsep \labelsep
 \leftmargin\leftmargini
 \labelwidth\leftmargin\advance\labelwidth-\labelsep
 \let\@listi\@listI
 \@listi
 \twoside@sw{}{%
  \raggedbottom
 }%
 \mark@envir
 \twocolumn@sw{%
  \open@column@mlt\tw@
  \set@colht
  \@floatplacement
  \@dblfloatplacement
  \sloppy
  \raggedbottom
  \let\set@listindent\set@listindent@
 }{%
  \open@column@one\@ne
  \set@colht
  \@floatplacement
  \@dblfloatplacement
  \sloppy
  \raggedbottom
  \let\set@listindent\set@listindent@parshape
 }%
}%
\def\appendix{%
  \par
  \setcounter{section}\z@
  \setcounter{subsection}\z@
  \setcounter{subsubsection}\z@
  \def\thesection{\Alph{section}}%
  \def\thesubsection{\arabic{subsection}}%
  \def\thesubsubsection{\alph{subsubsection}}%
  \@addtoreset{equation}{section}%
  \def\theequation@prefix{\thesection}%
  \addtocontents{toc}{\protect\appendix}%
}%
\def\title@column@default#1{#1}%
\def\close@column@default{}%
\def\galley@outdent{\rightmargin-\columnwidth\advance\rightmargin-\columnsep}%
\let\widetext@outdent\@empty
\newenvironment{widetext@galley}{%
  \list{}{%
    \topsep        \z@skip
    \listparindent \parindent
    \itemindent    \parindent
    \leftmargin    \z@
    \parsep        \z@\@plus\p@
    \widetext@outdent
    \relax
  }%
  \item\relax
}{
  \endlist
}%
\def\title@column@grid#1{%
 \onecolumngrid
 \begingroup
  \let\@footnotetext\@mpfootnotetext
  \let\set@footnotewidth\set@footnotewidth@ii
  #1%
 \endgroup
 \twocolumngrid
 \@ifvoid\@mpfootins{}{%
  \insert\footins\bgroup\unvbox\@mpfootins\egroup
 }%
}%
\def\set@footnotewidth@ii{%
 \columnwidth\textwidth
 \advance\columnwidth\columnsep
 \divide\columnwidth\tw@
 \advance\columnwidth-\columnsep
}%
\def\close@column@grid{%
 \onecolumngrid
 \twocolumngrid
}%
\newenvironment{widetext@grid}{%
  \par\ignorespaces\onecolumngrid
}{%
  \par\twocolumngrid\global\@ignoretrue
  \@endpetrue
}%
\appdef\class@documenthook{%
 \twocolumn@sw{%
  \let@environment{widetext}{widetext@grid}%
  \let\title@column\title@column@grid
  \let\close@column\close@column@grid
 }{%
  \let@environment{widetext}{widetext@galley}%
  \preprintsty@sw{%
  }{%
   \galley@sw{%
    \let\widetext@outdent\galley@outdent
   }{%
   }%
  }%
 }%
}%
\appdef\class@inithook{%
 \@ifxundefined\title@column{%
  \let\title@column\title@column@default
 }{}%
}%
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
\def\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\def\notesname{Notes}
\def\partname{Part}
\def\tocname{Contents}
\def\lofname{List of Figures}
\def\lotname{List of Tables}
\def\refname{References}
\def\indexname{Index}
\def\figurename{FIG.}
\def\figuresname{Figures}%
\def\tablename{TABLE}
\def\tablesname{Tables}%
\def\abstractname{Abstract}
\def\appendixesname{Appendixes}%
\def\appendixname{Appendix}%
\def\acknowledgmentsname{Acknowledgments}
\def\journalname{??}
\def\copyrightname{??}
\def\andname{and}
\def\@pacs@name{PACS numbers: }%
\def\ppname{pp}
\def\numbername{number}
\def\volumename{volume}
\def\Dated@name{dated: }%
\def\Received@name{received }%
\def\Revised@name{revised }%
\def\Accepted@name{accepted }%
\def\Published@name{published }%
\appdef\class@inithook{%
  \providecommand\MakeTextUppercase{\MakeUppercase}%
}%
\def\address{\replace@command\address\affiliation}%
\def\altaddress{\replace@command\altaddress\altaffiliation}%
\newenvironment{references}{%
 \class@warn@end{The references environment is not supported; use thebibliography instead.}
 \gdef\references{\thebibliography{}}\references
}{%
 \endthebibliography
}%
\def\draft{%
 \class@warn@end{Command \string\draft\space is obsolete;^^JInvoke option draft instead.}%
 \@booleantrue\draft@sw
}%
\def\tighten{%
 \class@warn@end{Command \string\tighten\space is obsolete;^^JInvoke option tightenlines instead.}%
 \@booleantrue\tightenlines@sw
}%
\def\tableline{%
 \noalign{%
  \class@warn@end{Command \string\tableline\space is obsolete;^^JUse \string\colrule\space instead.}%
  \global\let\tableline\colrule
 }%
 \tableline
}%
\def\case{\replace@command\case\frac}%
\def\slantfrac{\replace@command\slantfrac\frac}%
\def\tablenote{\replace@command\tablenote\footnote}%
\def\tablenotemark{\replace@command\tablenotemark\footnotemark}%
\def\tablenotetext{\replace@command\tablenotetext\footnotetext}%
\DeclareRobustCommand\REV@text[1]{%
 \relax
 \ifmmode
  \mathchoice
   {\hbox{{\everymath{\displaystyle     }#1}}}%
   {\hbox{{\everymath{\textstyle        }#1}}}%
   {\hbox{{\everymath{\scriptstyle      }\let\f@size\sf@size\selectfont#1}}}%
   {\hbox{{\everymath{\scriptscriptstyle}\let\f@size\ssf@size\selectfont#1}}}%
  \glb@settings
 \else
  \mbox{#1}%
 \fi
}%
\DeclareRobustCommand\REV@bbox[1]{%
 \relax
 \ifmmode
  \mathchoice
   {\hbox{{\everymath{\displaystyle     }\boldmath$#1$}}}%
   {\hbox{{\everymath{\textstyle        }\boldmath$#1$}}}%
   {\hbox{{\everymath{\scriptstyle      }\boldmath$#1$}}}%
   {\hbox{{\everymath{\scriptscriptstyle}\boldmath$#1$}}}%
  \glb@settings
 \else
  \mbox{#1}%
 \fi
}%
\DeclareRobustCommand\REV@bm[1]{%
 \class@warn@end{To use \string\bm, please load the bm package!}%
 \global\let\bm\relax
}%
\def\FL{\obsolete@command\FL}%
\def\FR{\obsolete@command\FR}%
\def\narrowtext{\obsolete@command\narrowtext}%
\def\mediumtext{\obsolete@command\mediumtext}%
\newenvironment{quasitable}{%
 \let@environment{tabular}{longtable}%
}{%
}%
\appdef\class@inithook{%
 \@ifxundefined\text{\let\text\REV@text}{}%
 \@ifxundefined\bm{\let\bm\REV@bm}{}%
 \providecommand\bibinfo[2]{#2}%
 \providecommand\eprint[2][]{#2}%
 \providecommand\url[1]{#1}%
}%
\def\bbox#1{%
 \class@warn@end{\string\bbox\space is obsolete,^^Jload the bm package and use \string\bm\space instead.}%
 \global\let\bbox\relax
}%
\newenvironment{mathletters}{%
 \class@warn@end{Environment {mathletters} is obsolete;^^Jload the amsmath package and use {subequations}!}%
 \global\let\mathletters\@empty
}{%
}%
\def\eqnum#1{%
 \class@warn@end{\string\eqnum\space is obsolete, load the amsmath package and use \string\tag!}%
 \global\let\eqnum\@gobble
}%
\RequirePackage{revsymb}%
\AtEndOfClass{%
 \InputIfFileExists{\jobname.rty}{}{}%
}%
\AtEndOfClass{%
 \@ifxundefined\secnumarabic@sw{\@booleanfalse\secnumarabic@sw}{}%
 \secnumarabic@sw{%
  \def\p@section        {}%
  \def\thesection       {\arabic{section}}%
  \def\p@subsection     {}%
  \def\thesubsection    {\thesection.\arabic{subsection}}%
  \def\p@subsubsection  {}%
  \def\thesubsubsection {\thesubsection.\arabic{subsubsection}}%
 }{}%
}%
\AtEndOfClass{%
 \appdef\class@documenthook{%
  \@ifxundefined\@bibstyle{}{%
   \expandafter\bibliographystyle@latex\expandafter{\@bibstyle}%
  }%
 }%
}%
\AtEndOfClass{%
 \appdef\class@documenthook{%
  \defaults@hook
 }%
}%
\@ifxundefined\defaults@hook{\let\defaults@hook\@empty}{}%
\endinput
%%
%% End of file `revtex4.cls'.
