% Blackwell Science MN journal document style
% v1.4, released 14th September 1995
%
% Copyright (C) Cambridge University Press 1994
%    for LaTeX version 2.09, 1988, by Leslie Lamport
%    based on the original LaTeX ARTICLE DOCUMENT STYLE
%    modifications by Sue Brooks, Alison Woollatt and Mark Reed 1993, 1994
%
% > Incorporating also parts of authordate.sty
%   by David Rhead, Cripps Computing Centre (Feb 1990).
% > Incorporating special symbol code from laa.sty v1.1 (25th Feb 1991)
%   used with the permission of Springer Verlag.
% > Incorporating parts of mssymb.tex (8th July 1987).
% > Incorporating newfont.sty vALPHA pl 8 (16th August 1994), by M. Reed
%
% v0.1.01  SFB text area, abstract heading, secnumdepth, 
%          \dblfloatpagefraction
% v0.1.02  SFB landscape, galley and referee options;
%          new catchline; enumerated lists; correct raggedright 
%          on section headings;
% v0.1.03  SFB continued floats with \caption* (removed now),
%          short captions centred
% v0.1.04  SFB appendices, unnumbered list (using description)
% v0.1.05  AJW roman catchline, final statement
% v1.0     RM  BSP note, \bsp, added to cup specials
% v1.1     AJW / MR, 28th January 1994. NFSS 1/2 compatible, 
%          Springer-Verlag macros added
% v1.2     AJW, 18th July 1994. Improved cont. captions, 
%          MR font selection check improved,
%          MR removed some redundant code, AW \sevensize added,
%          MR Added MR's `NewFont' support, MR Improved NFSS 1/2 support,
%          MR Added support for Bold math and AMS symbols for NFSS 1,
%          MR par's in abstract now have par indents.
%          MR added \ifCUPmtlplainloaded switch for use in documents.
%          MR Added mnsym.tex (for Times version).
% v1.25    MR, not released to authors 16th August 1994.
%          Replaced existing Newfont.sty code with updated code, after
%          discovering several bugs. This version not released to authors
%          because they are unlikely to find the bugs unless:
%          1) they have an extremely long article,
%          2) have used many \New.. commands (no docs were supplied for
%          these anyway).
% v1.3     MR, 5 September 1994. Added printing of style file version to
%          'Printed' info in catchline. Will help us identify how the 
%          article was produced (TeX/LaTeX) and the version number of the
%          macros.
%          MR Tables and Figures no longer get double spaced when using the
%          `referee' or `doublespacing' options.
%          MR Corrected 7th footnote symbol: made a \star\star (was **).
%          MR Corrected problem where some headings were not upper-case
%          when they should have been (\section*).
% v1.4     AJW, 14th September 1995. Add footlines and \newauthor,
%          correct \listparindent in enumerate environment.

\newif\ifoldfss
\newif\ifnfssone
\newif\ifnfsstwo
\def\f@s@s{}

\@ifundefined{DeclareFontShape}%
  {%
   \@ifundefined{selectfont}%
    {\global\oldfsstrue\let\reset@font=\relax%
     \def\f@s@s{with OFSS,\space}}% old font selection scheme
    {\global\nfssonetrue\def\f@s@s{with NFSS release 1,\space}}%
  }%
  {\global\nfsstwotrue\def\f@s@s{with NFSS release 2,\space}}%

\def\@version{1.4}

\typeout{Document Style `MN' \f@s@s v\@version, released 14th September 1995}

%  Journals use two-sided printing.
%
\@twosidetrue
\@twocolumntrue
\@mparswitchtrue
\def\ds@draft{\overfullrule 5pt}
\def\ds@twocolumn{\@twocolumntrue}
\def\ds@onecolumn{\@twocolumnfalse}

% letters option
%
\newif\if@letters
\def\ds@letters{\@letterstrue}

% landscape option
%
\newif\ifSFB@landscape
\def\ds@landscape{\SFB@landscapetrue}

% galley option
%
\newif\ifSFB@galley
\def\ds@galley{\SFB@galleytrue}

% referee option
%
\newif\ifSFB@referee
\def\ds@referee{%
 \SFB@refereetrue
 \@twocolumnfalse
}
\newif\ifdoublesp@cing
\def\ds@doublespacing{%
 \doublesp@cingtrue
}%
\@options
%
%  ****************************************
%  *               FONTS                  *
%  ****************************************
%
\lineskip 1pt
\normallineskip 1pt
\ifSFB@referee
  \def\baselinestretch{1.5}
\else
  \ifdoublesp@cing
  \def\baselinestretch{2}
\else
  \def\baselinestretch{1}
\fi\fi
\if@twocolumn
  \def\@normalsize{\@setsize\normalsize{11pt}\ixpt\@ixpt
   \abovedisplayskip 6pt plus 2pt minus 2pt
   \belowdisplayskip \abovedisplayskip
   \abovedisplayshortskip 6pt plus 2pt
   \belowdisplayshortskip \abovedisplayshortskip
   \let\@listi\@listI}
 \else
 \ifSFB@referee
  \def\@normalsize{\@setsize\normalsize{14pt}\xiipt\@xiipt
   \abovedisplayskip 4pt plus 1pt minus 1pt
   \belowdisplayskip \abovedisplayskip
   \abovedisplayshortskip 4pt plus 1pt
   \belowdisplayshortskip \abovedisplayshortskip
   \let\@listi\@listI}
 \else
  \def\@normalsize{\@setsize\normalsize{12pt}\ixpt\@ixpt
   \abovedisplayskip 4pt plus 1pt minus 1pt
   \belowdisplayskip \abovedisplayskip
   \abovedisplayshortskip 4pt plus 1pt
   \belowdisplayshortskip \abovedisplayshortskip
   \let\@listi\@listI}
 \fi
\fi
\def\small{\@setsize\small{10pt}\viiipt\@viiipt
 \abovedisplayskip 4pt plus 1pt minus 1pt
 \belowdisplayskip \abovedisplayskip
 \abovedisplayshortskip 4pt plus 1pt
 \belowdisplayshortskip \abovedisplayshortskip
 \def\@listi{\leftmargin\leftmargini
  \topsep 2pt plus 1pt minus 1pt
  \parsep \z@
  \itemsep 2pt}}
\def\footnotesize{\@setsize\footnotesize{10pt}\viiipt\@viiipt
 \abovedisplayskip 4pt plus 1pt minus 1pt
 \belowdisplayskip \abovedisplayskip
 \abovedisplayshortskip 4pt plus 1pt
 \belowdisplayshortskip \abovedisplayshortskip
 \def\@listi{\leftmargin\leftmargini
  \topsep 2pt plus 1pt minus 1pt
  \parsep \z@
  \itemsep 2pt}}
\def\scriptsize{\@setsize\scriptsize{8pt}\vipt\@vipt}
\def\tiny{\@setsize\tiny{6pt}\vpt\@vpt}
%
\if@twocolumn
  \def\large{\@setsize\large{11pt}\xpt\@xpt}
 \else
  \def\large{\@setsize\large{12pt}\xpt\@xpt}
 \fi
\def\Large{\@setsize\Large{14pt}\xiipt\@xiipt}
\def\LARGE{\@setsize\LARGE{17pt}\xivpt\@xivpt}
\def\huge{\@setsize\huge{20pt}\xviipt\@xviipt}
\def\Huge{\@setsize\Huge{25pt}\xxpt\@xxpt}
%
\def\sevensize{\@setsize\sevensize{8pt}\viipt\@viipt}
%
\normalsize

%%%%%%%%%%%%%%%%%%%%%%%% Extra Math / Symbol code %%%%%%%%%%%%%%%%%%%%%%%%

\def\hexnumber#1{\ifcase#1 0\or1\or2\or3\or4\or5\or6\or7%
  \or8\or9\or A\or B\or C\or D\or E\or F\fi}

\def\setboxz@h{\setbox\z@\hbox}
\def\wdz@{\wd\z@}
\def\boxz@{\box\z@}
\def\setbox@ne{\setbox\@ne}
\def\wd@ne{\wd\@ne}

\def\math@atom#1#2{%
   \binrel@{#1}\binrel@@{#2}}
\def\binrel@#1{\setboxz@h{\thinmuskip0mu
  \medmuskip\m@ne mu\thickmuskip\@ne mu$#1\m@th$}%
 \setbox@ne\hbox{\thinmuskip0mu\medmuskip\m@ne mu\thickmuskip
  \@ne mu${}#1{}\m@th$}%
 \setbox\tw@\hbox{\hskip\wd@ne\hskip-\wdz@}}
\def\binrel@@#1{\ifdim\wd2<\z@\mathbin{#1}\else\ifdim\wd\tw@>\z@
 \mathrel{#1}\else{#1}\fi\fi}

% These must be here because \newif and \newtoks are defined \outer.
\newif\iffirstta
\newtoks\math@groups
\newif\ifd@f

\ifoldfss
%
% newfont.sty
% ALPHA VERSION patchlevel 8, 16th August 1994, M. Reed

% \addtom@thgroup{math font loading info}
% Adds to internal \math@groups definition, which is executed at the end
% of each size changing command. It is called by \NewSymbolFont.

\math@groups={}
\def\addtom@thgroup#1#2{#1\expandafter{\the#1#2}} %  \mac={new\the\mac}


% Redefine \@setsize to allow math fonts to be reloaded automatically.
% \@setsize\SIZE{BASELINESKIP}\FONTSIZE\@FONTSIZE
% \@setsize\tiny{6pt}\vpt\@vpt

\def\@setsize#1#2#3#4{\@nomath#1\let\@currsize#1\baselineskip
   #2\setbox\strutbox\hbox{\vrule height.7\baselineskip
      depth.3\baselineskip width\z@}\baselineskip\baselinestretch\baselineskip
   \normalbaselineskip\baselineskip#3#4\relax
   \the\math@groups
}


% Make LaTeX change the values of \s@ze, \ss@ze, \sss@ze when \@npt is
% executed. This makes it possible for math characters to be loaded
% at the correct size automatically when the size is changed.

% \addtosizeh@ok{x}{10}{7}{5}

\def\addtosizeh@ok#1#2#3#4{%
  \expandafter\def\csname @#1pt\endcsname{%
    \def\s@ze{#2}\def\ss@ze{#3}\def\sss@ze{#4}%
  }%
}


% \resetsizehook allows the size parameters to be reset after \addtosizeh@ok
% has been called (it re-defines \@npt).
% e.g JFM which requires \xpt to have 10.5pt instead of 10pt.
% Note: \resetsizehook must be used BEFORE \begin{document}, and BEFORE any
% \New... commands.

% e.g. \resetsizehook{x}{10.5}{7}{5}

\let\resetsizehook=\addtosizeh@ok


% Standard LaTeX sizes

\ifx\CUP@mtlplain@loaded\undefined
  \addtosizeh@ok{v}    {5}     {5}     {5}
  \addtosizeh@ok{vi}   {6}     {6}     {6}
  \addtosizeh@ok{vii}  {7}     {6}     {5}
  \addtosizeh@ok{viii} {8}     {6}     {5}
  \addtosizeh@ok{ix}   {9}     {6}     {5}
  \addtosizeh@ok{x}    {10}    {7}     {5}
  \addtosizeh@ok{xi}   {10.95} {8}     {6}
  \addtosizeh@ok{xii}  {12}    {8}     {6}
  \addtosizeh@ok{xiv}  {14.4}  {10}    {7}
  \addtosizeh@ok{xvii} {17.28} {12}    {10}
  \addtosizeh@ok{xx}   {20.74} {14.4}  {12}
  \addtosizeh@ok{xxv}  {24.88} {20.74} {17.28}
\else
  \addtosizeh@ok{v}    {5} {5}  {5}
  \addtosizeh@ok{vi}   {6} {6}  {6}
  \addtosizeh@ok{vii}  {7} {6}  {5}
  \addtosizeh@ok{viii} {8} {6}  {5}
  \addtosizeh@ok{ix}   {9} {6}  {5}
  \addtosizeh@ok{x}    {10}{7}  {5}
  \addtosizeh@ok{xi}   {11}{8}  {6}
  \addtosizeh@ok{xii}  {12}{8}  {6}
  \addtosizeh@ok{xiv}  {14}{10} {7}
  \addtosizeh@ok{xvii} {17}{12}{10}
  \addtosizeh@ok{xx}   {20}{14}{12}
  \addtosizeh@ok{xxv}  {25}{20}{17}
\fi


\def\get@font#1#2#3{%
  \edef\fonts@ze{\romannumeral#3}%         10 -> x
  \edef\fontn@me{\fonts@ze#1}%             AMSa -> xAMSa
  \@ifundefined{\fontn@me}%
    {%%\typeout{defining \fontn@me}%
     \global\expandafter\font\csname \fontn@me\endcsname=#2 at #3pt}%
    {}%
}

\def\ass@tfont#1#2{%
  \xdef\fam@name{\csname #1\endcsname}%
  \xdef\font@name{\csname #2\endcsname}%
  \let\textfont@name\font@name
  \textfont\fam@name\textfont@name
}

\def\ass@sfont#1#2{%
  \xdef\fam@name{\csname #1\endcsname}%
  \xdef\font@name{\csname #2\endcsname}%
  \let\textfont@name\font@name
  \scriptfont\fam@name\textfont@name
}

\def\ass@ssfont#1#2{%
  \xdef\fam@name{\csname #1\endcsname}%
  \xdef\font@name{\csname #2\endcsname}%
  \let\textfont@name\font@name
  \scriptscriptfont\fam@name\textfont@name
}


%                fam name  base font  (allocates a \newfam)
% \NewSymbolFont {AMSa}    {mtxm10}

\def\NewSymbolFont#1#2{%
  \expandafter\ifx\csname sym#1fam\endcsname\relax % if not defined
    \expandafter\newfam\csname sym#1fam\endcsname
    \expandafter\edef\csname sym#1fam\endcsname{\the\allocationnumber}%
    \addtom@thgroup\math@groups{%
      \get@font{#1}{#2}{\s@ze}%
      \ass@tfont{sym#1fam}{\fontn@me}%
      \get@font{#1}{#2}{\ss@ze}%
      \ass@sfont{sym#1fam}{\fontn@me}%
      \get@font{#1}{#2}{\sss@ze}%
      \ass@ssfont{sym#1fam}{\fontn@me}%
    }%
  \else
    \errmessage{Family `#1' already defined}%
  \fi
}


%                symbol         type fam    pos (hex)
% \NewMathSymbol {\blacksquare} {0}  {AMSa} {04}

\def\NewMathSymbol#1#2#3#4{%
  \edef\f@mly{\expandafter\hexnumber{\csname sym#3fam\endcsname}}%
  \mathchardef#1="#2\f@mly#4\relax
}


%                  macro name  type  fam1   pos  fam2   pos
% \NewMathDelimiter{\ulcorner} {4}   {AMSa} {70} {AMSb} {70}

\def\NewMathDelimiter#1#2#3#4#5#6{%
  \d@ftrue
  \expandafter\ifx\csname sym#3fam\endcsname\relax
    \d@ffalse \errmessage{Family `#3' is not defined}%
  \fi
  \expandafter\ifx\csname sym#5fam\endcsname\relax
    \d@ffalse \errmessage{Family `#5' is not defined}%
  \fi
  \ifd@f
    \edef\f@mly{\expandafter\hexnumber{\csname sym#3fam\endcsname}}%
    \edef\f@mlytw@{\expandafter\hexnumber{\csname sym#5fam\endcsname}}%
    \xdef#1{\delimiter"#2\f@mly #4\f@mlytw@ #6\relax}%
  \fi
}


%                  macro name  base font  skewchar setting e.g '60 (octal)
% \NewMathAlphabet {mathbssi}  {mtmisb10} {}

\def\m@thit{1}

\def\set@skchar#1{\global\expandafter\skewchar
  \csname\fontn@me\endcsname=#1\relax}

\def\NewMathAlphabet#1#2#3{%
  \def\tst{#3}%
  \ifx\tst\empty\else % if a \skewchar setting is present
    \expandafter\gdef\csname #1@sc\endcsname{}%  \def\cmd@sc{..}
  \fi
  %
  \expandafter\def\csname #1\endcsname{%  \def\cmd{\protect\@cmd}
    \protect\csname @#1\endcsname}%
  %
  \expandafter\def\csname @#1\endcsname##1{%  \def\@cmd{..}
    {%
    \begingroup
      \get@font{#1}{#2}{\s@ze}%
      \@ifundefined{#1@sc}{}{\set@skchar{#3}}%
      \ass@tfont{m@thit}{\fontn@me}%
      \get@font{#1}{#2}{\ss@ze}%
      \@ifundefined{#1@sc}{}{\set@skchar{#3}}%
      \ass@sfont{m@thit}{\fontn@me}%
      \get@font{#1}{#2}{\sss@ze}%
      \@ifundefined{#1@sc}{}{\set@skchar{#3}}%
      \ass@ssfont{m@thit}{\fontn@me}%
      %
      \math@atom{##1}{%
      \mathchoice%
        {\hbox{$\m@th\displaystyle##1$}}%
        {\hbox{$\m@th\textstyle##1$}}%
        {\hbox{$\m@th\scriptstyle##1$}}%
        {\hbox{$\m@th\scriptscriptstyle##1$}}}%
    \endgroup
    }%
  }%
}


%                  macro name  base font  hyphenchar setting e.g -1 (off)
% \NewTextAlphabet {textbfit}  {mtbxti10} {}

% save a family if \NewTextAlphabet is not used.
\firsttatrue

\def\set@hchar#1{\global\expandafter\hyphenchar
  \csname\fontn@me\endcsname=#1\relax}

\def\NewTextAlphabet#1#2#3{%
  \iffirstta
    \global\firsttafalse
    \newfam\scratchfam
    \edef\scrt@fam{\the\allocationnumber}%
  \fi
  \def\tst{#3}%
  \ifx\tst\empty\else % if a \hyphenchar setting is required
    \expandafter\gdef\csname #1@hc\endcsname{}%  \def\cmd@sc{..}
  \fi
  %
  \expandafter\def\csname #1\endcsname{%  \def\cmd{\protect\t@cmd}
    \protect\csname t@#1\endcsname}%
  %
  \long\expandafter\def\csname t@#1\endcsname##1{%  \def\t@cmd{..}
    \ifmmode
      \typeout{Warning: do not use \expandafter\string\csname #1\endcsname
        \space in math mode}\fi%
    {%
      \get@font{#1}{#2}{\s@ze}\let\t@xtfnt=\fontn@me\relax
      \@ifundefined{#1@hc}{}{\set@hchar{#3}}%
      \ass@tfont{scrt@fam}{\fontn@me}%
      \get@font{#1}{#2}{\ss@ze}%
      \@ifundefined{#1@hc}{}{\set@hchar{#3}}%
      \ass@sfont{scrt@fam}{\fontn@me}%
      \get@font{#1}{#2}{\sss@ze}%
      \@ifundefined{#1@hc}{}{\set@hchar{#3}}%
      \ass@ssfont{scrt@fam}{\fontn@me}%
      \fam\scratchfam\csname\t@xtfnt\endcsname
    ##1%
    }%
  }%
  %
  \expandafter\def\csname #1shape%  \def\cmdshape{\protect\@cmdshape}
    \endcsname{\protect\csname @#1shape\endcsname}%
  %
  \expandafter\def\csname @#1shape\endcsname{%  \def\@cmdshape
    \ifmmode
      \typeout{Warning: do not use \expandafter\string\csname
        #1shape\endcsname \space in math mode}\fi
      %
      \get@font{#1}{#2}{\s@ze}\let\t@xtfnt=\fontn@me\relax
      \@ifundefined{#1@hc}{}{\set@hchar{#3}}%
      \ass@tfont{scrt@fam}{\fontn@me}%
      \get@font{#1}{#2}{\ss@ze}%
      \@ifundefined{#1@hc}{}{\set@hchar{#3}}%
      \ass@sfont{scrt@fam}{\fontn@me}%
      \get@font{#1}{#2}{\sss@ze}%
      \@ifundefined{#1@hc}{}{\set@hchar{#3}}%
      \ass@ssfont{scrt@fam}{\fontn@me}%
      \fam\scratchfam\csname\t@xtfnt\endcsname
  }%
}


% \bmath{math text}

\ifx\CUP@mtlplain@loaded\undefined
  \def\math@itfnt{cmmib10}
  \def\math@syfnt{cmbsy10}
\else
  \def\math@itfnt{mtmib10}
  \def\math@syfnt{mtbsy10}
\fi

\def\m@thsy{2}

\def\bmath{\protect\@bmath}
\def\@bmath#1{%
  {%
  \begingroup
    \get@font{mthit}{\math@itfnt}{\s@ze}\set@skchar{'177}%
    \ass@tfont{m@thit}{\fontn@me}%
    \get@font{mthit}{\math@itfnt}{\ss@ze}\set@skchar{'177}%
    \ass@sfont{m@thit}{\fontn@me}%
    \get@font{mthit}{\math@itfnt}{\sss@ze}\set@skchar{'177}%
    \ass@ssfont{m@thit}{\fontn@me}%
    %
    \get@font{mthsy}{\math@syfnt}{\s@ze}\set@skchar{'60}%
    \ass@tfont{m@thsy}{\fontn@me}%
    \get@font{mthsy}{\math@syfnt}{\ss@ze}\set@skchar{'60}%
    \ass@sfont{m@thsy}{\fontn@me}%
    \get@font{mthsy}{\math@syfnt}{\sss@ze}\set@skchar{'60}%
    \ass@ssfont{m@thsy}{\fontn@me}%
    %
    \math@atom{#1}{%
    \mathchoice%
      {\hbox{$\m@th\displaystyle#1$}}%
      {\hbox{$\m@th\textstyle#1$}}%
      {\hbox{$\m@th\scriptstyle#1$}}%
      {\hbox{$\m@th\scriptscriptstyle#1$}}}%
  \endgroup
  }%
}
%
\fi % End of ofss

% Make these do nothing (for backwards compatibility}
\let\loadboldmathitalic=\relax
\let\loadboldgreek=\relax

\ifoldfss % if NFSS release 1 or 2
\else
  %
  \def\mathch{\protect\p@mathch}
  \def\p@mathch#1#2{%
    \begingroup
    \let\@nomath\@gobble \mathversion{#1}%
    \math@atom{#2}{%
    \mathchoice%
      {\hbox{$\m@th\displaystyle#2$}}%
      {\hbox{$\m@th\textstyle#2$}}%
      {\hbox{$\m@th\scriptstyle#2$}}%
      {\hbox{$\m@th\scriptscriptstyle#2$}}}%
  \endgroup}
  %
  \def\bmath{\protect\p@boldm}
  \def\p@boldm#1{\mathch{bold}{#1}}
  %
\fi


% Define lowercase bold Greek.
% Use \boldeta for bold \eta (clashes with \beta).

\ifnfsstwo % if OFSS or NFSS release 1
\else
%
  \def\balpha{\bmath{\alpha}}
  \def\bbeta{\bmath{\beta}}
  \def\bgamma{\bmath{\gamma}}
  \def\bdelta{\bmath{\delta}}
  \def\bepsilon{\bmath{\epsilon}}
  \def\bzeta{\bmath{\zeta}}
  \def\boldeta{\bmath{\eta}}
  \def\btheta{\bmath{\theta}}
  \def\biota{\bmath{\iota}}
  \def\bkappa{\bmath{\kappa}}
  \def\blambda{\bmath{\lambda}}
  \def\bmu{\bmath{\mu}}
  \def\bnu{\bmath{\nu}}
  \def\bxi{\bmath{\xi}}
  \def\bpi{\bmath{\pi}}
  \def\brho{\bmath{\rho}}
  \def\bsigma{\bmath{\sigma}}
  \def\btau{\bmath{\tau}}
  \def\bupsilon{\bmath{\upsilon}}
  \def\bphi{\bmath{\phi}}
  \def\bchi{\bmath{\chi}}
  \def\bpsi{\bmath{\psi}}
  \def\bomega{\bmath{\omega}}
  \def\bvarepsilon{\bmath{\varepsilon}}
  \def\bvartheta{\bmath{\vartheta}}
  \def\bvarpi{\bmath{\varpi}}
  \def\bvarrho{\bmath{\varrho}}
  \def\bvarsigma{\bmath{\varsigma}}
  \def\bvarphi{\bmath{\varphi}}
  %
\fi

\ifnfsstwo
  %
  \let\mit=\mathnormal
  %
  % The following is needed beause NFSS release 2 does not define the bold
  % math symbol font to be available!
  %
  \SetSymbolFont{symbols}{bold}{OMS}{cmsy}{b}{n}
  %
  \DeclareSymbolFont{bmisymbols}{OML}{cmm}{b}{it}
  \DeclareMathSymbol{\balpha}{0}{bmisymbols}{"0B}
  \DeclareMathSymbol{\bbeta}{0}{bmisymbols}{"0C}
  \DeclareMathSymbol{\bgamma}{0}{bmisymbols}{"0D}
  \DeclareMathSymbol{\bdelta}{0}{bmisymbols}{"0E}
  \DeclareMathSymbol{\bepsilon}{0}{bmisymbols}{"0F}
  \DeclareMathSymbol{\bzeta}{0}{bmisymbols}{"10}
  \DeclareMathSymbol{\boldeta}{0}{bmisymbols}{"11}
  \DeclareMathSymbol{\btheta}{0}{bmisymbols}{"12}
  \DeclareMathSymbol{\biota}{0}{bmisymbols}{"13}
  \DeclareMathSymbol{\bkappa}{0}{bmisymbols}{"14}
  \DeclareMathSymbol{\blambda}{0}{bmisymbols}{"15}
  \DeclareMathSymbol{\bmu}{0}{bmisymbols}{"16}
  \DeclareMathSymbol{\bnu}{0}{bmisymbols}{"17}
  \DeclareMathSymbol{\bxi}{0}{bmisymbols}{"18}
  \DeclareMathSymbol{\bpi}{0}{bmisymbols}{"19}
  \DeclareMathSymbol{\brho}{0}{bmisymbols}{"1A}
  \DeclareMathSymbol{\bsigma}{0}{bmisymbols}{"1B}
  \DeclareMathSymbol{\btau}{0}{bmisymbols}{"1C}
  \DeclareMathSymbol{\bupsilon}{0}{bmisymbols}{"1D}
  \DeclareMathSymbol{\bphi}{0}{bmisymbols}{"1E}
  \DeclareMathSymbol{\bchi}{0}{bmisymbols}{"1F}
  \DeclareMathSymbol{\bpsi}{0}{bmisymbols}{"20}
  \DeclareMathSymbol{\bomega}{0}{bmisymbols}{"21}
  \DeclareMathSymbol{\bvarepsilon}{0}{bmisymbols}{"22}
  \DeclareMathSymbol{\bvartheta}{0}{bmisymbols}{"23}
  \DeclareMathSymbol{\bvarpi}{0}{bmisymbols}{"24}
  \DeclareMathSymbol{\bvarrho}{0}{bmisymbols}{"25}
  \DeclareMathSymbol{\bvarsigma}{0}{bmisymbols}{"26}
  \DeclareMathSymbol{\bvarphi}{0}{bmisymbols}{"27}
  %
\fi


% Define font shapes for Euler upright Math, bold upright Math,
% AMS symbol fonts A and B, sans-serif bold, bold text italic,
% math italic bold and bold math symbol.
% These font shapes are defined in mnsym.tex to use Times fonts.

\ifx\CUP@mtlplain@loaded\undefined
  %
  \ifnfssone
    %
    \new@fontshape{eur}{m}{n}{%
      <5>eurm5<6>eurm6<7>eurm7<8>eurm8<9>eurm9<10>eurm10%
      <11>eurm10 at 10.95pt<12>eurm10 at 12pt<14>eurm10 at 14.4pt%
      <17>eurm10 at 17.28pt<20>eurm10 at 20.74pt<25>eurm10 at 24.88pt}{}
    %
    \new@fontshape{eur}{b}{n}{%
      <5>eurb5<6>eurb6<7>eurb7<8>eurb8<9>eurb9<10>eurb10%
      <11>eurb10 at 10.95pt<12>eurb10 at 12pt<14>eurb10 at 14.4pt%
      <17>eurb10 at 17.28pt<20>eurb10 at 20.74pt<25>eurb10 at 24.88pt}{}
    %
    \new@fontshape{msa}{m}{n}{%
      <5>msam5<6>msam6<7>msam7<8>msam8<9>msam9<10>msam10%
      <11>msam10 at 10.95pt<12>msam10 at 12pt<14>msam10 at 14.4pt%
      <17>msam10 at 17.28pt<20>msam10 at 20.74pt<25>msam10 at 24.88pt}{}
    %
    \new@fontshape{msb}{m}{n}{%
      <5>msbm5<6>msbm6<7>msbm7<8>msbm8<9>msbm9<10>msbm10%
      <11>msbm10 at 10.95pt<12>msbm10 at 12pt<14>msbm10 at 14.4pt%
      <17>msbm10 at 17.28pt<20>msbm10 at 20.74pt<25>msbm10 at 24.88pt}{}
    %
    \new@fontshape{cmss}{bx}{n}{%
      <5>cmssbx10 at5pt<6>cmssbx10 at6pt<7>cmssbx10 at7pt<8>cmssbx10 at8pt%
      <9>cmssbx10 at9pt<10>cmssbx10<11>cmssbx10 at10.95pt<12>cmssbx10 at12pt%
      <14>cmssbx10 at14.4pt<17>cmssbx10 at17.28pt<20>cmssbx10 at20.74pt%
      <25>cmssbx10 at24.88pt}{}
    %
    \new@fontshape{cmr}{bx}{it}{%
      <5>cmbxti10 at5pt<6>cmbxti10 at6pt<7>cmbxti10 at7pt<8>cmbxti10 at8pt%
      <9>cmbxti10 at9pt<10>cmbxti10<11>cmbxti10 at10.95pt<12>cmbxti10 at12pt%
      <14>cmbxti10 at14.4pt<17>cmbxti10 at17.28pt<20>cmbxti10 at20.74pt%
      <25>cmbxti10 at24.88pt}{}
    %
    \new@fontshape{cmm}{b}{it}{%
      <5>cmmib10 at5pt<6>cmmib10 at6pt<7>cmmib10 at7pt<8>cmmib10 at8pt%
      <9>cmmib10 at9pt<10>cmmib10<11>cmmib10 at10.95pt<12>cmmib10 at12pt%
      <14>cmmib10 at14.4pt<17>cmmib10 at17.28pt<20>cmmib10 at20.74pt%
      <25>cmmib10 at24.88pt}{}
      %
    \new@fontshape{cmsy}{b}{n}{%
      <5>cmbsy10 at5pt<6>cmbsy10 at6pt<7>cmbsy10 at7pt<8>cmbsy10 at8pt%
      <9>cmbsy10 at9pt<10>cmbsy10<11>cmbsy10 at10.95pt<12>cmbsy10 at12pt%
      <14>cmbsy10 at14.4pt<17>cmbsy10 at17.28pt<20>cmbsy10 at20.74pt%
      <25>cmbsy10 at24.88pt}{}
    %
    \def\UseAMStwoboldmath{%
      \new@fontshape{cmm}{b}{it}{%
        <5>cmmib5<6>cmmib6<7>cmmib7<8>cmmib8<9>cmmib9<10>cmmib10%
        <11>cmmib10 at10.95pt<12>cmmib10 at12pt<14>cmmib10 at14.4pt%
        <17>cmmib10 at17.28pt<20>cmmib10 at20.74pt<25>cmmib10 at24.88pt}{}
      %
      \new@fontshape{cmsy}{b}{n}{%
        <5>cmbsy5<6>cmbsy6<7>cmbsy7<8>cmbsy8<9>cmbsy9<10>cmbsy10%
        <11>cmbsy10 at10.95pt<12>cmbsy10 at12pt<14>cmbsy10 at14.4pt%
        <17>cmbsy10 at17.28pt<20>cmbsy10 at20.74pt<25>cmbsy10 at24.88pt}{}
    }%
    %
  \fi % End of NFSS release 1
\else
  \let\UseAMStwoboldmath=\relax
\fi


% Astronomy and Astrophysics symbol macros

% \def\la{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
% $\reset@font\displaystyle##$\hfil\cr<\cr\sim\cr}}}
% {\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr
% <\cr\sim\cr}}}
% {\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr
% <\cr\sim\cr}}}
% {\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
% <\cr\sim\cr}}}}}
% 
% \def\ga{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
% $\reset@font\displaystyle##$\hfil\cr>\cr\sim\cr}}}
% {\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr
% >\cr\sim\cr}}}
% {\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr
% >\cr\sim\cr}}}
% {\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
% >\cr\sim\cr}}}}}
% 

\def\getsto{\mathrel{\mathchoice {\vcenter{\offinterlineskip
\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr\gets\cr\to\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr\gets
\cr\to\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr\gets
\cr\to\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
\gets\cr\to\cr}}}}}

\def\cor{\mathrel{\mathchoice {\hbox{$\widehat=$}}{\hbox{$\widehat=$}}
{\hbox{$\reset@font\scriptstyle\hat=$}}
{\hbox{$\reset@font\scriptscriptstyle\hat=$}}}}

\def\lid{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr<\cr\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr<\cr
\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr<\cr
\noalign{\vskip1pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
<\cr
\noalign{\vskip0.9pt}=\cr}}}}}

\def\gid{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr>\cr\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr>\cr
\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr>\cr
\noalign{\vskip1pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
>\cr
\noalign{\vskip0.9pt}=\cr}}}}}

\def\sol{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr\sim\cr<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr\sim\cr
<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr\sim\cr
<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
\sim\cr<\cr}}}}}

\def\sog{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr\sim\cr>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr\sim\cr
>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr
\sim\cr>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
\sim\cr>\cr}}}}}

\def\lse{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr<\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr
<\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr
<\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
<\cr\simeq\cr}}}}}

\def\gse{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr>\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr
>\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr
>\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
>\cr\simeq\cr}}}}}

\def\grole{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr>\cr\noalign{\vskip-1.5pt}<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr
>\cr\noalign{\vskip-1.5pt}<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr
>\cr\noalign{\vskip-1pt}<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
>\cr\noalign{\vskip-0.5pt}<\cr}}}}}

\def\leogr{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr<\cr\noalign{\vskip-1.5pt}>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr
<\cr\noalign{\vskip-1.5pt}>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr
<\cr\noalign{\vskip-1pt}>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
<\cr\noalign{\vskip-0.5pt}>\cr}}}}}

\def\loa{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr<\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr
<\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr
<\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
<\cr\approx\cr}}}}}

\def\goa{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr>\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr
>\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr
>\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
>\cr\approx\cr}}}}}

\def\sun{\hbox{$\odot$}}
\def\degr{\hbox{$^\circ$}}
\def\diameter{{\ifmmode\mathchoice
{\ooalign{\hfil\hbox{$\reset@font\displaystyle/$}\hfil\crcr
{\hbox{$\reset@font\displaystyle\mathchar"20D$}}}}
{\ooalign{\hfil\hbox{$\reset@font\textstyle/$}\hfil\crcr
{\hbox{$\reset@font\textstyle\mathchar"20D$}}}}
{\ooalign{\hfil\hbox{$\reset@font\scriptstyle/$}\hfil\crcr
{\hbox{$\reset@font\scriptstyle\mathchar"20D$}}}}
{\ooalign{\hfil\hbox{$\reset@font\scriptscriptstyle/$}\hfil\crcr
{\hbox{$\reset@font\scriptscriptstyle\mathchar"20D$}}}}
\else{\ooalign{\hfil/\hfil\crcr\mathhexbox20D}}%
\fi}}

\def\sq{\ifmmode\squareforqed\else{\unskip\nobreak\hfil
\penalty50\hskip1em\null\nobreak\hfil\squareforqed
\parfillskip=0pt\finalhyphendemerits=0\endgraf}\fi}
\def\squareforqed{\hbox{\rlap{$\sqcap$}$\sqcup$}}

\ifoldfss
  \newcommand{\r@mn}[1] {{\rm #1}}%
\else
  \newcommand{\r@mn}[1] {\mathrm{#1}}%
\fi

\def\fd{\hbox{$.\!\!^{\reset@font\r@mn{d}}$}}
\def\fh{\hbox{$.\!\!^{\reset@font\r@mn{h}}$}}
\def\fm{\hbox{$.\!\!^{\reset@font\r@mn{m}}$}}
\def\fs{\hbox{$.\!\!^{\reset@font\r@mn{s}}$}}
\def\fdg{\hbox{$.\!\!^\circ$}}
\def\farcm{\hbox{$.\mkern-4mu^\prime$}}
\def\farcs{\hbox{$.\!\!^{\prime\prime}$}}
\def\fp{\hbox{$.\!\!^{\reset@font\scriptscriptstyle\r@mn{p}}$}}
\def\arcmin{\hbox{$^\prime$}}
\def\arcsec{\hbox{$^{\prime\prime}$}}

%%%%%%%%%%%%%%%%%%%%% End of Extra Math / Symbol code %%%%%%%%%%%%%%%%%%%%%

%  ****************************************
%  *            PAGE LAYOUT               *
%  ****************************************
%
% SIDE MARGINS:
\if@twocolumn
 \oddsidemargin -2.5pc \evensidemargin -2.5pc
\else
 \ifSFB@referee
  \oddsidemargin \z@  \evensidemargin \z@
 \else
  \oddsidemargin -2pc  \evensidemargin -2pc
 \fi
\fi
\marginparwidth 4pc
\marginparsep 0.5pc

% VERTICAL SPACING:
%\if@twocolumn
% \topmargin -2pc
%\else
 \topmargin \z@
%\fi
\headheight 14pt
\headsep    15pt
\topskip     9pt
\footheight 11pt
\footskip   22pt % was 26pt
%
% DIMENSION OF TEXT: % SFB 0.1.01
%
\newdimen\SFB@measure
\SFB@measure 42pc
%
\textheight 682pt
\textwidth \SFB@measure
%
\ifSFB@landscape
 \textwidth \textheight
 \textheight \SFB@measure
\fi
\ifSFB@referee
 \textwidth 39pc
\fi
\columnsep 2pc
\columnseprule 0pt

% FOOTNOTES:
\footnotesep 6pt
\skip\footins 19.5pt plus 12pt minus 1pt

% FLOATS:
\floatsep 12pt plus 5.5pt minus 1pt
\textfloatsep 12pt plus 7.5pt 
\intextsep 12pt plus 5.5pt minus 2pt
\@maxsep 15pt
\dblfloatsep 12pt plus 5.5pt minus 2pt
\dbltextfloatsep 15pt plus 4.5pt minus 3pt
\@dblmaxsep 15pt
\@fptop 0pt plus 0fil
\@fpsep 12pt plus 0fil
\@fpbot 0pt plus 0fil% 3fil ajw
\@dblfptop 0pt plus 0fil
\@dblfpsep 12pt plus 0fil
\@dblfpbot 0pt plus 0fil% 3fil ajw
\marginparpush 5pt

%  ****************************************
%  *           PARAGRAPHING               *
%  ****************************************
%
\newdimen\realparindent % needed for abstract
\parskip \z@ plus .1pt
\parindent 18pt
\realparindent=\parindent
\partopsep 0pt plus 1pt
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\@beginparpenalty -\@lowpenalty
\@endparpenalty -\@lowpenalty
\@itempenalty -\@lowpenalty
\clubpenalty=0
\widowpenalty=10000

%  ****************************************
%  *       PARTS & SECTIONS NUMBERS       *
%  ****************************************
%
\newcounter {part}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\def\thepart {\arabic{part}}
\def\thesection {\arabic{section}}
\def\thesubsection    {\thesection.\arabic{subsection}}
\def\thesubsubsection {\thesubsection.\arabic{subsubsection}}
\def\theparagraph     {\thesubsubsection.\arabic{paragraph}}
\def\thesubparagraph  {\theparagraph.\arabic{subparagraph}}

%  ****************************************
%  *                PARTS                 *
%  ****************************************
%
\def\part{\par \addvspace{4ex}\@afterindentfalse
 \secdef\@part\@spart}
\def\@part[#1]#2{\ifnum \c@secnumdepth >\m@ne
  \refstepcounter{part}
  \addcontentsline{toc}{part}{Part \thepart: #1}
 \else \addcontentsline{toc}{part}{#1}
 \fi
 {\parindent 0pt \raggedright
  \ifnum \c@secnumdepth >\m@ne
   \reset@font\large\rm PART
   \ifcase\thepart \or ONE \or TWO \or THREE \or FOUR \or FIVE
    \or SIX \or SEVEN \or EIGHT \or NINE \or TEN \else \fi
   \par \nobreak
  \fi
  \reset@font\LARGE \rm #2 \markboth{}{}\par }
 \nobreak \vskip 3ex \@afterheading}
\def\@spart#1{{\parindent 0pt \raggedright
  \reset@font\LARGE \rm #1\par}
 \nobreak \vskip 3ex \@afterheading}

%  ****************************************
%  *               SECTIONS               *
%  ****************************************
%
% \@startsection modified to leave less space before \subsection
%    if it immediately follows \section

% \@startsection {NAME}{LEVEL}{INDENT}{BEFORESKIP}{AFTERSKIP}{STYLE}

\newif\if@levelone

\def\@startsection#1#2#3#4#5#6{\if@noskipsec \leavevmode \fi
   \par \@tempskipa #4\relax
   \@afterindenttrue
   \ifnum #2=\@ne  % if level=1 ie. section
     \global\@levelonetrue
   \else
     \global\@levelonefalse
   \fi
   \ifdim \@tempskipa <\z@ \@tempskipa -\@tempskipa \@afterindentfalse\fi
   \if@nobreak
     \everypar{}\ifnum#2=2 \vskip 0pt plus1pt\fi % was 6pt
   \else
     \addpenalty{\@secpenalty}\addvspace{\@tempskipa}
   \fi \@ifstar
     {\@ssect{#3}{#4}{#5}{#6}}{\@dblarg{\@sect{#1}{#2}{#3}{#4}{#5}{#6}}}}

%\def\SFB@hangraggedright{\rightskip\@flushglue \let\\=\newline}
%\def\SFB@raggedright{\rightskip\@flushglue \let\\=\@centercr
% \parindent=\SFB@indent}

\def\SFB@hangraggedright{\rightskip=\@flushglue \let\\=\@centercr \parindent=0pt}

\def\section{\@startsection{section}{1}{\z@}
 {-24pt plus -12pt minus -1pt}{6pt}
 {\SFB@hangraggedright\reset@font\normalsize\bf}}
\def\subsection{\@startsection{subsection}{2}{\z@}
 {-18pt plus -9pt minus -1pt}{6pt}
 {\SFB@hangraggedright\reset@font\normalsize\bf}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}
 {-18pt plus -9pt minus -1pt}{6pt}
 {\SFB@hangraggedright\reset@font\normalsize\it}}
\def\paragraph{\@startsection{paragraph}{4}{\z@}
 {12pt plus 2.25pt minus 1pt}{-0.5em}{\reset@font\normalsize\bf}}
\def\subparagraph{\@startsection{subparagraph}{5}{\parindent}
 {12pt plus 2.25pt minus 1pt}{-0.5em}{\reset@font\normalsize\it}}
\setcounter{secnumdepth}{4} % SFB 0.1.01
%
% \@sect{NAME}{LEVEL}{INDENT}{BEFORESKIP}{AFTERSKIP}{STYLE}[ARG1]{ARG2}
\def\@sect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \def\@svsec{}%
  \else
    \refstepcounter{#1}%
    \if@levelone % is it a \section or \section*
      \ifSFB@appendix
        \edef\@svsec{}%
      \else
        \edef\@svsec{\csname the#1\endcsname\hskip 1em}%
      \fi
    \else
      \edef\@svsec{\csname the#1\endcsname\hskip 1em}%
    \fi
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup #6\relax
    \if@levelone
      \ifSFB@appendix
        \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty \@M
        APPENDIX \csname the#1\endcsname:\hskip 0.5em\uppercase{#8}\par}%
      \else
        \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty \@M
        \uppercase{#8}\par}%
      \fi
    \else
      \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty \@M #8\par}%
    \fi
  \endgroup
   \csname #1mark\endcsname{#7}%
   \addcontentsline{toc}{#1}{\ifnum #2>\c@secnumdepth \else %ajw
   \protect\numberline{\csname the#1\endcsname}\fi #7}%ajw
 \else
  \def\@svsechd{#6\hskip #3\@svsec \if@levelone \uppercase{#8}\else #8\fi
  \csname #1mark\endcsname{#7}
  \addcontentsline{toc}{#1}{\ifnum #2>\c@secnumdepth \else %ajw
  \protect\numberline{\csname the#1\endcsname}\fi#7}%ajw
  }\fi
 \@xsect{#5}}

% from latex.tex
%   \@ssect{INDENT}{BEFORESKIP}{AFTERSKIP}{STYLE}{ARG}
\def\@ssect#1#2#3#4#5{%
  \@tempskipa #3\relax
    \ifdim \@tempskipa>\z@
      \begingroup #4\@hangfrom{\hskip #1}{%
      \interlinepenalty \@M 
      \if@levelone
        \uppercase{#5}%
      \else {#5}%
      \fi\par}%
     \endgroup
    \else 
      \def\@svsechd{#4\hskip #1\relax
      \if@levelone
        \uppercase{#5}%
      \else {#5}%
      \fi}
    \fi
  \@xsect{#3}%
}

\newif\ifSFB@appendix
\def\appendix{\par
 \SFB@appendixtrue
 \@addtoreset{equation}{section}
 \@addtoreset{table}{section}
 \@addtoreset{figure}{section}
 \setcounter{section}{0}
 \setcounter{equation}{0}
 \setcounter{figure}{0}
 \setcounter{table}{0}
 \def\thesection{\Alph{section}}
 \def\thesubsection{\thesection\arabic{subsection}}
 \def\theequation{\thesection\arabic{equation}}
 \def\thefigure{\thesection\@arabic\c@figure}
 \def\thetable{\thesection\@arabic\c@table}
}

%  ****************************************
%  *               SKIPS                  *
%  ****************************************
%
\newskip\@indentskip
\newskip\smallindent
\newskip\@footindent
\newskip\@leftskip
\@indentskip=18pt
\smallindent=1.5em
\@footindent=\smallindent
\@leftskip=\z@

%  ****************************************
%  *                LISTS                 *
%  ****************************************
%
\leftmargini   \z@
\leftmarginii  1.25pc
\leftmarginiii 1.25pc
\leftmarginiv  1.25pc
\leftmarginv   1pc
\leftmarginvi  1pc
\leftmargin\leftmargini
\labelsep 0.5em
\labelwidth\leftmargini\advance\labelwidth-\labelsep
%
% label macros for Range-Left and Range-Right labels
\def\makeRLlabel#1{\rlap{#1}\hss}
\def\makeRRlabel#1{\hss\llap{#1}}
\def\makenewlabel#1{#1}
%
\def\@listI{\leftmargin\leftmargini
 \parsep \z@
 \topsep 6pt plus 1pt minus 1pt
 \itemsep \z@ plus .1pt
}
\let\@listi\@listI
\@listi
\def\@listii{\leftmargin\leftmarginii
 \labelwidth\leftmarginii\advance\labelwidth-\labelsep
 \topsep 6pt plus 1pt minus 1pt
 \parsep \z@
 \itemsep \z@ plus .1pt
}
\def\@listiii{\leftmargin\leftmarginiii
 \labelwidth\leftmarginiii\advance\labelwidth-\labelsep
 \topsep 6pt plus 1pt minus 1pt
 \parsep \z@
 \partopsep \z@
 \itemsep \topsep
}
\def\@listiv{\leftmargin\leftmarginiv
 \labelwidth\leftmarginiv\advance\labelwidth-\labelsep
}
\def\@listv{\leftmargin\leftmarginv
 \labelwidth\leftmarginv\advance\labelwidth-\labelsep
}
\def\@listvi{\leftmargin\leftmarginvi
 \labelwidth\leftmarginvi\advance\labelwidth-\labelsep
}
%
% ITEMIZE
\def\itemize{%
  \ifnum \@itemdepth >3 \@toodeep
  \else \advance\@itemdepth \@ne
   \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
   \list{\csname\@itemitem\endcsname}%
   {\let\makelabel\makeRRlabel}%
   \parindent 1em%
   \leftmargin 3.5em\labelsep 0.5em\itemindent 2.0em\labelwidth 0.5em%
  \fi}
\def\labelitemi{$\bullet$}
\def\labelitemii{--}
\def\labelitemiii{$\cdot$}
\def\labelitemiv{*}
%
% ENUMERATE
% SFB -- enumerate with optional argument to set left margin...
\def\enumerate{\ifnum \@enumdepth >3 \@toodeep \else
  \advance\@enumdepth \@ne
  \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
 \fi
 \@ifnextchar [{\@enumeratetwo}{\@enumerateone}%
}
\def\@enumeratetwo[#1]{%
 \list{\csname label\@enumctr\endcsname}%
  {\settowidth\labelwidth{[#1]}
   \leftmargin\z@ 
   \listparindent 1em
   \usecounter{\@enumctr}
   \let\makelabel\makenewlabel}
}
\def\@enumerateone{%
 \list{\csname label\@enumctr\endcsname}%
  {\usecounter{\@enumctr}\itemindent 1em\listparindent 1em
   \let\makelabel\makenewlabel}}
%
\def\labelenumi{\theenumi}
\def\theenumi{(\roman{enumi})}
\def\labelenumii{(\theenumii)}
\def\theenumii{(\alph{enumii})}
\def\p@enumii{\theenumi}
\def\labelenumiii{\theenumiii}
\def\theenumiii{(\arabic{enumiii})}
\def\p@enumiii{\theenumi(\theenumii)}
\def\labelenumiv{\theenumiv}
\def\theenumiv{(\Alph{enumiv})}
\def\p@enumiv{\p@enumiii\theenumiii}
%
% DESCRIPTION
%\def\descriptionlabel#1{\hspace\labelsep \reset@font\bf #1}
%\def\description{\list{}{\labelwidth\z@ \itemindent-\leftmargin
%  \leftmargin 1em
%  \itemindent-1em
%}}
\def\descriptionlabel#1{\reset@font\bf #1}
\def\description{\list{}{\labelwidth\z@
  \leftmargin \z@
  \itemindent 1em
}}
\let\enddescription\endlist

%  ****************************************
%  *            DISPLAYED TEXT            *
%  ****************************************
%
% VERSE
\def\verse{\let\\=\@centercr
 \list{}{\itemsep\z@
  \itemindent -\@indentskip
  \listparindent \itemindent
  \rightmargin\leftmargin
  \advance\leftmargin \@indentskip}\item[]}
\let\endverse\endlist
%
% QUOTATION
\def\quotation{\list{}{\listparindent \smallindent
%  \itemindent\listparindent
  \leftmargin\z@\rightmargin\leftmargin
  \parsep 0pt plus 1pt}\item[]\reset@font\small}
\let\endquotation=\endlist
%
% QUOTE
\def\quote{\list{}{\leftmargin\z@\rightmargin\leftmargin}\item[]%
  \reset@font\small}
\let\endquote=\endlist

%  ****************************************
%  *         OTHER ENVIRONMENTS           *
%  ****************************************
%
% THEOREM
\def\@begintheorem#1#2{\reset@font\rm \trivlist \item[\hskip \labelsep
  {\reset@font\bf #1\ #2.}]}
\def\@opargbegintheorem#1#2#3{\reset@font\rm \trivlist
  \item[\hskip \labelsep{\reset@font\bf #1\ #2.\ (#3)}]}
\def\@endtheorem{\endtrivlist}
%
% PROOF
\def\proof{\reset@font\rm \trivlist \item[\hskip \labelsep
  {\reset@font\it Proof.}]}
\def\endproof{\hspace*{1em}{\begin{picture}(6.5,6.5)%
  \put(0,0){\framebox(6.5,6.5){}}\end{picture}}\endtrivlist}
\@namedef{proof*}{\reset@font\rm \trivlist \item[\hskip \labelsep
  {\reset@font\it Proof.}]}
\@namedef{endproof*}{\endtrivlist}
\def\proofbox{\begin{picture}(6.5,6.5)%
  \put(0,0){\framebox(6.5,6.5){}}\end{picture}}
%
% TITLEPAGE
\def\titlepage{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
  \else \newpage \fi \thispagestyle{empty}\c@page\z@}
\def\endtitlepage{\if@restonecol\twocolumn \else \newpage \fi}

% ARRAY AND TABULAR
%
\arraycolsep   5pt
\tabcolsep     6pt
\arrayrulewidth .5pt
\doublerulesep 1.5pt

\def\tabular{\def\@halignto{}
 \def\hline{\noalign{\ifnum0=`}\fi
  \vskip 3pt
  \hrule \@height \arrayrulewidth
%   {\hbox to 0.667\textwidth{\hrulefill}}
  \vskip 3pt
  \futurelet \@tempa\@xhline}
 \def\fullhline{\noalign{\ifnum0=`}\fi
  \vskip 3pt
  \hrule \@height \arrayrulewidth
%   {\hbox to \textwidth{\hrulefill}}
  \vskip 3pt
  \futurelet \@tempa\@xhline}
 \def\@xhline{\ifx\@tempa\hline
   \vskip -6pt
   \vskip \doublerulesep
  \fi
  \ifnum0=`{\fi}}
  \def\@arrayrule{\@addtopreamble{\hskip -.5\arrayrulewidth
%                                  \vrule \@width \arrayrulewidth
                                  \hskip .5\arrayrulewidth}}
\@tabular
}
% TABBING
%
\tabbingsep \labelsep

% MINIPAGE
%
\skip\@mpfootins = \skip\footins

% FRAMEBOX
%
% Space left between box and text by \fbox and \framebox.
\fboxsep = 3pt
% Width of rules in box made by \fbox and \framebox.
\fboxrule = \arrayrulewidth

%  ****************************************
%  *         TITLE AND ABSTRACT           *
%  ****************************************
%
\def\maketitle{\par
 \begingroup
  \if@twocolumn
   \twocolumn[\vspace*{17pt}\@maketitle] 
  \else
   \newpage
   \global\@topnum\z@
   \@maketitle
  \fi
  \thispagestyle{titlepage}
 \endgroup
 \let\maketitle\relax
 \let\@maketitle\relax
 \gdef\@author{}
 \gdef\@title{}
 \let\thanks\relax
}
\def\newauthor{%
  \end{author@tabular}\par
  \begin{author@tabular}[t]{@{}l@{}}%
}
\def\and{%
  \end{author@tabular}\vskip 3pt\par
 \begin{author@tabular}[t]{@{}l@{}}%
}
\def\@maketitle{\newpage
 \vspace*{7pt}
 {\raggedright \sloppy
  {\reset@font\huge \bf \@title \par}
  \vskip 23pt
  {\reset@font\LARGE
   \begin{author@tabular}[t]{@{}l@{}}\@author
   \end{author@tabular}\par}
  \vskip 22pt
 }
 \par\noindent
 {\reset@font\small \@date \par}
 \vskip 22pt
}
%
\def\abstract{\if@twocolumn
   \start@SFBbox\@abstract
 \else
   \@abstract
 \fi}
\def\endabstract{\if@twocolumn
   \endlist\finish@SFBbox
 \else
  \endlist
 \fi}
\def\@abstract{\list{}{%
    \listparindent\realparindent
    \itemindent\z@
    \labelwidth\z@ \labelsep\z@ 
    \leftmargin 11pc\rightmargin\z@
    \parsep 0pt plus 1pt}\item[]%
    \reset@font\normalsize{\bf ABSTRACT}\\\reset@font\large
} % SFB 0.1.01 
%
\newif\ifSFB@keywords
\def\keywords{\if@twocolumn
  \start@SFBbox\@keywords
 \else
  \@keywords
 \fi
}
\def\@keywords{\list{}{%
    \labelwidth\z@ \labelsep\z@ 
    \leftmargin 11pc\rightmargin\z@
    \parsep 0pt plus 1pt}\item[]\reset@font\large{\bf Key words: }%
}
\def\endkeywords{\if@twocolumn
  \endlist\addvspace{37pt plus 0.5\baselineskip}\finish@SFBbox 
 \else
  \endlist
 \fi
 \@thanks
 \gdef\@thanks{}
 \SFB@keywordstrue
}
\def\nokeywords{\ifSFB@keywords\else
 \if@twocolumn \start@SFBbox\addvspace{37pt}\finish@SFBbox \fi
 \@thanks
 \gdef\@thanks{}\fi
}

\def\author@tabular{\def\@halignto{}\@authortable}
\let\endauthor@tabular=\endtabular
%
\def\author@tabcrone{\vspace{2pt}{\ifnum0=`}\fi%
  \@xtabularcr[-7pt]\reset@font\small\it
  \let\\=\author@tabcrtwo\ignorespaces}
%
\def\author@tabcrtwo{{\ifnum0=`}\fi\@xtabularcr[-7pt]\reset@font\small\it
 \let\\=\author@tabcrtwo\ignorespaces}
%
\def\@authortable{\leavevmode \hbox \bgroup $\let\@acol\@tabacol
 \let\@classz\@tabclassz \let\@classiv\@tabclassiv
 \let\\=\author@tabcrone\ignorespaces \@tabarray}

\def\start@SFBbox{\@next\@currbox\@freelist{}{}%
 \global\setbox\@currbox
 \vbox\bgroup
  \hsize \textwidth
  \@parboxrestore
}
\def\finish@SFBbox{\par\vskip -\dbltextfloatsep
  \egroup
  \global\count\@currbox\tw@
  \global\@dbltopnum\@ne
  \global\@dbltoproom\maxdimen\@addtodblcol
  \global\vsize\@colht
  \global\@colroom\@colht
}

%  ****************************************
%  *            PAGE STYLES               *
%  ****************************************
%
\mark{{}{}}
\gdef\@author{\mbox{}}
\def\author{\@ifnextchar [{\@authortwo}{\@authorone}}
\def\@authortwo[#1]#2{\gdef\@author{#2}\gdef\@shortauthor{#1}}
\def\@authorone#1{\gdef\@author{#1}\gdef\@shortauthor{#1}}
%\def\shortauthor#1{\gdef\@shortauthor{#1}}
\gdef\@shortauthor{}
\gdef\@title{\mbox{}}
\def\title{\@ifnextchar [{\@titletwo}{\@titleone}}
\def\@titletwo[#1]#2{\gdef\@title{#2}\gdef\@shorttitle{#1}}
\def\@titleone#1{\gdef\@title{#1}\gdef\@shorttitle{#1}}
\def\shorttitle#1{\gdef\@shorttitle{#1}}
\gdef\@shorttitle{}
\def\volume#1{\gdef\@volume{#1}}
\gdef\@volume{000}
\def\tod@y{\today}
\def\microfiche#1{\gdef\@microfiche{#1}}
\gdef\@microfiche{}
\def\pubyear#1{\gdef\@pubyear{#1}}
\gdef\@pubyear{0000}
\def\pagerange#1{\gdef\@pagerange{#1}}
\gdef\@pagerange{000--000}
\def\journal#1{\gdef\@journal{#1}}
\def\plate#1{\gdef\pl@te{#1}}
\ifx\CUP@mtlplain@loaded\undefined
  \def\@printed{\qquad Printed \tod@y\qquad
    (MN \LaTeX\ style file v\@version)}
\else
  \def\@printed{}
\fi
\gdef\@journal{{Mon.\ Not.\ R.\ Astron.\ Soc.} {\bf \@volume}, \@pagerange\
% (\number\year) \@microfiche\@printed}
  (\@pubyear) \@microfiche\@printed}
%
% \ps@empty and \ps@plain defined in LATEX.TEX
%
\def\@ddell{}
\if@letters
  \def\@ddell{L}
\fi
\def\ps@headings{\let\@mkboth\markboth
 \def\@oddhead{\Large\hfill{\it\@shorttitle}\hspace{1.5em}%
   \rm\@ddell\thepage}
 \def\@oddfoot{\small\copyright\ \@pubyear\ RAS, MNRAS {\bf \@volume}, \@pagerange\hfil}
 \def\@evenhead{\Large\@ddell\thepage\hspace{1.5em}\it\@shortauthor\hfill}
 \def\@evenfoot{\hfil\small\copyright\ \@pubyear\ RAS, MNRAS {\bf \@volume}, \@pagerange}
 \def\sectionmark##1{\markboth{##1}{}}
 \def\subsectionmark##1{\markright{##1}}}

\def\ps@myheadings{\let\@mkboth\@gobbletwo
 \def\@oddhead{\Large\hfill\it\rightmark\hspace{1.5em}\rm\@ddell\thepage}
 \def\@oddfoot{\small\copyright\ \@pubyear\ RAS, MNRAS {\bf \@volume}, \@pagerange\hfil}
 \def\@evenhead{\Large\@ddell\thepage\hspace{1.5em}\it\leftmark\hfill}
 \def\@evenfoot{\hfil\small\copyright\ \@pubyear\ RAS, MNRAS {\bf \@volume}, \@pagerange}
 \def\sectionmark##1{}
 \def\subsectionmark##1{}}

\def\ps@titlepage{\let\@mkboth\@gobbletwo
 \def\@oddhead{\footnotesize\@journal\hfill}
 \def\@oddfoot{\small\copyright\ \@pubyear\ RAS\hfil}
 \def\@evenhead{\footnotesize\@journal\hfill}
 \def\@evenfoot{\hfil\small\copyright\ \@pubyear\ RAS}
 \def\sectionmark##1{}
 \def\subsectionmark##1{}}

\def\ps@plate{\let\@mkboth\@gobbletwo
  \def\@oddhead{\footnotesize\pl@te\hfill}
  \def\@oddfoot{\small\copyright\ \@pubyear\ RAS, MNRAS {\bf \@volume},
    \@pagerange\hfil}
  \def\@evenhead{\footnotesize\pl@te\hfill}
  \def\@evenfoot{\hfil\small\copyright\ \@pubyear\ RAS, MNRAS {\bf \@volume},
    \@pagerange}
}

%  ****************************************
%  *         TABLE OF CONTENTS, ETC.      *
%  ****************************************
%
\def\@pnumwidth{1.55em}
\def\@tocrmarg {2.55em}
\def\@dotsep{4.5}
\setcounter{tocdepth}{2}
\def\@undottedtocline#1#2#3#4#5{\ifnum #1>\c@tocdepth
 \else
  \vskip \z@ plus .2pt
  {\hangindent #2\relax
   \rightskip \@tocrmarg \parfillskip -\rightskip
   \parindent #2\relax \@afterindenttrue
   \interlinepenalty\@M \leavevmode
   \@tempdima #3\relax #4\nobreak \hfill \nobreak
   \hbox to\@pnumwidth{\hfil\reset@font\rm \ }\par}\fi}
\def\tableofcontents{\@restonecolfalse
 \if@twocolumn\@restonecoltrue\onecolumn\fi
 \section*{CONTENTS} \@starttoc{toc}
 \if@restonecol\twocolumn\fi \par\vspace{12pt}}
\def\l@part#1#2{\addpenalty{-\@highpenalty}
 \addvspace{2.25em plus 1pt}
 \begingroup
  \parindent \z@ \rightskip \@pnumwidth
  \parfillskip -\@pnumwidth
  {\reset@font\normalsize\rm
   \leavevmode \hspace*{3pc}
   #1\hfil \hbox to\@pnumwidth{\hss \ }}\par
   \nobreak \global\@nobreaktrue
   \everypar{\global\@nobreakfalse\everypar{}}\endgroup}
\def\l@section#1#2{\addpenalty{\@secpenalty}
 \@tempdima 1.5em
 \begingroup
  \parindent \z@ \rightskip \@pnumwidth
  \parfillskip -\@pnumwidth \reset@font\rm \leavevmode
  \advance\leftskip\@tempdima \hskip -\leftskip
  #1\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss \ }\par
 \endgroup}
\def\l@subsection{\@undottedtocline{2}{1.5em}{2.3em}}
\def\l@subsubsection{\@undottedtocline{3}{3.8em}{3.2em}}
\def\l@paragraph{\@undottedtocline{4}{7.0em}{4.1em}}
\def\l@subparagraph{\@undottedtocline{5}{10em}{5em}}
\def\listoffigures{\@restonecolfalse
 \if@twocolumn\@restonecoltrue\onecolumn\fi
 \section*{LIST OF FIGURES\@mkboth{LIST OF FIGURES}{LIST OF FIGURES}}
 \@starttoc{lof} \if@restonecol\twocolumn\fi}
\def\l@figure{\@undottedtocline{1}{1.5em}{2.3em}}
\def\listoftables{\@restonecolfalse
 \if@twocolumn\@restonecoltrue\onecolumn\fi
 \section*{LIST OF TABLES\@mkboth{LIST OF TABLES}{LIST OF TABLES}}
 \@starttoc{lot} \if@restonecol\twocolumn\fi}
\let\l@table\l@figure

%  ****************************************
%  *             BIBLIOGRAPHY             *
%  ****************************************
%

\newcounter{dummy}
\def\thebibliography#1{\section*{REFERENCES}
 \addcontentsline{toc}{section}{REFERENCES}
 \list{}{\usecounter{dummy}%
         \labelwidth\z@
         \leftmargin 1.5em
         \itemsep \z@
         \itemindent-\leftmargin}
 \reset@font\small
 \parindent\z@
 \parskip\z@ plus .1pt\relax
 \def\newblock{\hskip .11em plus .33em minus .07em}
 \sloppy\clubpenalty4000\widowpenalty4000
 \sfcode`\.=1000\relax
}
\let\endthebibliography=\endlist
\def\@biblabel#1{\hspace*{\labelsep}[#1]}

%  ****************************************
%  *              THE INDEX               *
%  ****************************************
%
\newif\if@restonecol
\def\theindex{\section*{INDEX}
 \addcontentsline{toc}{section}{INDEX}
 \reset@font\footnotesize \parindent\z@ \parskip\z@ plus .1pt\relax
 \let\item\@idxitem}
\def\@idxitem{\par\hangindent 1em}
\def\subitem {\par\hangindent 1em \hspace*{1em}}
\def\subsubitem{\par\hangindent 1em\hspace*{1em}}
\def\endtheindex{\if@restonecol\onecolumn\else\clearpage\fi}
\def\indexspace{\par\vskip\baselineskip \relax}

%  ****************************************
%  *             FOOTNOTES                *
%  ****************************************
%
\def\footnoterule{\kern-3\p@ \hrule width 12pc height \z@ \kern 3\p@}

\renewcommand{\thefootnote}{\mbox{{$\fnsymbol{footnote}$}}}

\def\@fnsymbol#1{\ifcase#1\or \mbox{$\star$}\or \dagger\or \ddagger\or
   \S \or \P \or \|\or \mbox{$\star\star$}\or \dagger\dagger
   \or \ddagger\ddagger\or \S\S\or \P\P\or \|\|\else ***
   \fi\relax}

\long\def\@makefntext#1{\parindent 1em\noindent
  $^{\@thefnmark}$\hspace{4pt}#1}

%\long\def\@makefntext#1{\@setpar{\@@par\@tempdima \hsize
% \advance\@tempdima-18pt\parshape \@ne 18pt\@tempdima}\par
% \noindent \hbox to \z@{\hss$^{\@thefnmark}$\hspace{0.5em}}#1}

%  ****************************************
%  *         FIGURES AND TABLES           *
%  ****************************************
%
\setcounter{topnumber}{2}
\def\topfraction{.9}
\setcounter{bottomnumber}{1}
\def\bottomfraction{.9}
\setcounter{totalnumber}{3}
\def\textfraction{.1}
\def\floatpagefraction{.9}
\setcounter{dbltopnumber}{2}
\def\dbltopfraction{.9}
\def\dblfloatpagefraction{.9}

\newif\ifst@rredfloat
\newcounter{table}
\def\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{1}
\def\fstyle@table{\reset@font\small\rm}
\def\ext@table{lot}
\def\fnum@table{Table \thetable}
\def\table{\def\baselinestretch{1}%
  \let\@makecaption=\SFB@maketablecaption%
  \@float{table}\fstyle@table}
\let\endtable\end@float
\@namedef{table*}{\def\baselinestretch{1}\st@rredfloattrue
  \let\@makecaption=\SFB@maketablecaption%
  \@dblfloat{table}\centering\fstyle@table}
\@namedef{endtable*}{\end@dblfloat\st@rredfloatfalse}

\newcounter{figure}
\def\thefigure{\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{2}
\def\fstyle@figure{\reset@font\small\rm}
\def\ext@figure{lof}
\def\fnum@figure{Figure \thefigure}
\def\figure{\def\baselinestretch{1}%
  \let\@makecaption=\SFB@makefigurecaption%
  \@float{figure}\fstyle@figure}
\let\endfigure\end@float
\@namedef{figure*}{\def\baselinestretch{1}\st@rredfloattrue
  \let\@makecaption=\SFB@makefigurecaption%
  \@dblfloat{figure}\centering\fstyle@figure}
\@namedef{endfigure*}{\end@dblfloat\st@rredfloatfalse}

\long\def\SFB@makefigurecaption#1#2{\vskip 6pt
  \setbox\@tempboxa\hbox{\reset@font\small{\bf #1}%
    \if@cont \ -- {\it continued}\else{\bf .}\fi\ {\rm #2}\par}%
 \ifdim \wd\@tempboxa >\hsize
   {\reset@font\small{\bf #1}%
     \if@cont \ -- {\it continued}\else{\bf .}\fi\ {\rm #2}\par}%
 \else
   \ifst@rredfloat
     \hbox to\hsize{\hfill\box\@tempboxa\hfill}%
   \else
     \hbox to\hsize{\hfill\box\@tempboxa\hfill}%
   \fi
 \fi
 \vskip 6pt
 \@contfalse
}

\long\def\SFB@maketablecaption#1#2{\vskip 6pt
  \setbox\@tempboxa\hbox{\reset@font\small{\bf #1}%
    \if@cont \ -- {\it continued}\else{\bf .}\fi\ {\rm #2}\par}%
 \ifdim \wd\@tempboxa >\hsize
    {\reset@font\small{\bf #1}%
    \if@cont \ -- {\it continued}\else{\bf .}\fi\ {\rm #2}\par}%
 \else
   \hbox to\hsize{\box\@tempboxa\hfill}%
 \fi
 \vskip 6pt
 \@contfalse
}

\newif\if@cont
\def\caption{\refstepcounter\@captype \@dblarg{\@caption\@captype}}
\def\contcaption{\@conttrue\SFB@caption\@captype}

\long\def\SFB@caption#1#2{%\par
 \begingroup
  \@parboxrestore
  \reset@font\normalsize
  \@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #2}\par
 \endgroup}

%  ****************************************
%  *           CUP specials               *
%  ****************************************
%
%
%  The following code is taken from authordate.sty, by  David Rhead, of
%  the Cripps Computing Centre (February 1990), with some modifications
%  by ggw.  It is intended for documents
%  that use the author-date citation system.  When used in conjunction with
%  authordate1.bst, ... , authordate4.bst, it allows citations of the
%  form \shortcite{bloggs-60} as well as the usual \cite{bloggs-60}.
%  When
%       ... \cite{bloggs-60} ... \shortcite{bloggs-60} ...
%  appears in the input file,
%       ... (Bloggs, 1960) ... (1960) ...
%  appears in the final document.
%
%  Code taken from apalike.sty.
%
\def\@cite#1#2{(#1\if@tempswa , #2\fi)}
\def\@biblabel#1{}

% Set length of hanging indentation for bibliography entries
%
\newlength{\bibhang}
\setlength{\bibhang}{2em}

%  Define default title and page-head text.
%
\def\bibtitle{References}
\def\bibheadtitle{REFERENCES}

%  Code taken from aaai.sty.
%
% don't box citations, add space between multiple citations, separate with ;
\def\@citex[#1]#2{%
  \if@filesw\immediate\write\@auxout{\string\citation{#2}}\fi
  \def\@citea{}\@cite{\@for\@citeb:=#2\do
    {\@citea\def\@citea{; }\@ifundefined
       {b@\@citeb}{{\reset@font\bf ?}\@warning
       {Citation `\@citeb' on page \thepage \space undefined}}%
{\csname b@\@citeb\endcsname}}}{#1}}
% Allow short (name-less) citations, when used in
% conjunction with a bibliography style that creates labels like
%       \citename{<names>, }<year>
\let\@internalcite\cite
\def\cite{\def\citename##1{##1}\@internalcite}
\def\shortcite{\def\citename##1{}\@internalcite}

% RM for BSP note at end of article
\def\bsp{\medskip\reset@font\normalsize\noindent This paper has been
  produced using the Royal Astronomical Society/Blackwell Science
  \LaTeX\ style file.}


%  ****************************************
%  *                FLEQN                 *
%  ****************************************
%
% FLEQN DOCUMENT-STYLE OPTION - released 9 March 1987
%    for LaTeX version 2.09
% Copyright (C) 1987 by Leslie Lamport
%
% The following commands make the displayed math environments flush left,
% with an indentation of \mathindent from the prevailing left margin.

\def\[{\relax\ifmmode\@badmath\else\begin{trivlist}\item[]\leavevmode
  \hbox to\linewidth\bgroup$
  \displaystyle
  \hskip\mathindent\bgroup\fi}

\def\]{\relax\ifmmode \egroup $\hfil
       \egroup \end{trivlist}\else \@badmath \fi}

\def\equation{\refstepcounter{equation}\trivlist \item[]\leavevmode
  \hbox to\linewidth\bgroup $
  \displaystyle
\hskip\mathindent}


\def\endequation{$\hfil
           \displaywidth\linewidth\@eqnnum\egroup \endtrivlist}

\def\eqnarray{\stepcounter{equation}\let\@currentlabel=\theequation
\global\@eqnswtrue
\global\@eqcnt\z@\tabskip\mathindent\let\\=\@eqncr
\abovedisplayskip\topsep\ifvmode\advance\abovedisplayskip\partopsep\fi
\belowdisplayskip\abovedisplayskip
\belowdisplayshortskip\abovedisplayskip
\abovedisplayshortskip\abovedisplayskip
$$\halign
to \linewidth\bgroup\@eqnsel\hskip\@centering$\displaystyle\tabskip\z@
  {##}$&\global\@eqcnt\@ne \hskip 2\arraycolsep \hfil${##}$\hfil
  &\global\@eqcnt\tw@ \hskip 2\arraycolsep $\displaystyle{##}$\hfil
   \tabskip\@centering&\llap{##}\tabskip\z@\cr}

\def\endeqnarray{\@@eqncr\egroup
 \global\advance\c@equation\m@ne$$\global\@ignoretrue}

\newdimen\mathindent
\mathindent = \z@

%  ****************************************
%  *            MISCELLANEOUS             *
%  ****************************************
%
% DATE
\def\today{\number\day\ \ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December
 \fi \ \number\year}

%  ****************************************
%  *           INITIALIZATION             *
%  ****************************************
%
%
\newif\ifCUPmtlplainloaded
\ifx\CUP@mtlplain@loaded\undefined
\else
  \global\CUPmtlplainloadedtrue
  \input mnsym
\fi
%
\flushbottom
\ps@headings
\ifSFB@galley
 \raggedbottom
 \ps@empty
\fi
\ifSFB@referee
 \raggedbottom
\fi
\pagenumbering{arabic}
\if@twocolumn
 \twocolumn
 \sloppy
\else
 \onecolumn
\fi
\frenchspacing

% end of MN.sty
