%% DELPHI.STY     jea   - 05/11/91
%% Modifications
%%	JNA-1	14 Jan 1992	Remove the parident in the abstract
%%				Reduce the section title size.

\typeout{ }
\typeout{ DELPHI.STY - jea   - 05/11/91}
\typeout{ }
%
\makeatletter
\def\@ptsize{0} 
\@namedef{ds@10pt}{\def\@ptsize{0}}
\@namedef{ds@11pt}{\def\@ptsize{1}}
\@namedef{ds@12pt}{\def\@ptsize{2}}
\def\@mysize{
\ifcase  \@ptsize
% DFNREP10.STY
\lineskip 1pt \normallineskip 1pt
\def\baselinestretch{1}

\def\@normalsize{\@setsize\normalsize{12pt}\xpt\@xpt
\abovedisplayskip 10pt plus2pt minus5pt
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip \z@ plus3pt
\belowdisplayshortskip 6pt plus3pt minus3pt}

\def\small{\@setsize\small{11pt}\ixpt\@ixpt
\abovedisplayskip 8.5pt plus 3pt minus 4pt
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip \z@ plus2pt
\belowdisplayshortskip 4pt plus2pt minus 2pt
\def\@listi{\topsep 4pt plus 2pt minus 2pt\parsep\z@}}

\def\footnotesize{\@setsize\footnotesize{9.5pt}\viiipt\@viiipt
\abovedisplayskip 6pt plus 2pt minus 4pt
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip \z@ plus 1pt
\belowdisplayshortskip 3pt plus 1pt minus 2pt
\def\@listi{\topsep 3pt plus 1pt minus 1pt\parsep\z@}}

\def\scriptsize{\@setsize\scriptsize{8pt}\viipt\@viipt}
\def\tiny{\@setsize\tiny{6pt}\vpt\@vpt}
\def\large{\@setsize\large{14pt}\xiipt\@xiipt}
\def\Large{\@setsize\Large{18pt}\xivpt\@xivpt}
\def\LARGE{\@setsize\LARGE{22pt}\xviipt\@xviipt}
\def\huge{\@setsize\huge{25pt}\xxpt\@xxpt}
\def\Huge{\@setsize\Huge{30pt}\xxvpt\@xxvpt}
\normalsize 

\skip\footins 6pt plus 2pt minus 2pt 
\floatsep 12pt plus 2pt minus 2pt \textfloatsep 20pt plus 2pt minus 4pt
\intextsep 12pt plus 2pt minus 2pt \@maxsep 20pt \dblfloatsep 12pt plus 2pt
minus 2pt \dbltextfloatsep 20pt plus 2pt minus 4pt \@dblmaxsep 20pt 
\@fptop 0pt plus 1fil \@fpsep 8pt plus 2fil \@fpbot 0pt plus 1fil 
\@dblfptop 0pt plus 1fil \@dblfpsep 8pt plus 2fil \@dblfpbot 0pt plus 1fil

\parskip 0pt plus 1pt 
\parindent 15pt 
\topsep 8pt plus 2pt minus 4pt
\partopsep 2pt plus 1pt minus 1pt 
\itemsep\z@
\@lowpenalty 51 \@medpenalty 151 \@highpenalty 301 
\@beginparpenalty -\@lowpenalty \@endparpenalty -\@lowpenalty \@itempenalty
-\@lowpenalty 

\leftmargini 25pt
\leftmarginii 22pt 
\leftmarginiii 18.7pt 
\leftmarginiv 17pt 
\leftmarginv 10pt
\leftmarginvi 10pt
\leftmargin\leftmargini
\labelwidth\leftmargini\advance\labelwidth-\labelsep
\labelsep 5pt
\parsep 4pt plus 2pt minus 1pt

\def\@listi{\parsep\z@}

\def\@listii{\leftmargin\leftmarginii
\labelwidth\leftmarginii\advance\labelwidth-\labelsep
\topsep 4pt plus 2pt minus 1pt}

\def\@listiii{\leftmargin\leftmarginiii
\labelwidth\leftmarginiii\advance\labelwidth-\labelsep
\topsep 2pt plus 1pt minus 1pt 
\partopsep 1pt plus 0pt minus 1pt}

\def\@listiv{\leftmargin\leftmarginiv
\labelwidth\leftmarginiv\advance\labelwidth-\labelsep}

\def\@listv{\leftmargin\leftmarginv
\labelwidth\leftmarginv\advance\labelwidth-\labelsep}

\def\@listvi{\leftmargin\leftmarginvi
\labelwidth\leftmarginvi\advance\labelwidth-\labelsep}
\or %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DFNREP11.STY
\lineskip 1pt \normallineskip 1pt
\def\baselinestretch{1}

\def\@normalsize{\@setsize\normalsize{13.6pt}\xipt\@xipt
\abovedisplayskip 11pt plus3pt minus6pt
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip \z@ plus3pt
\belowdisplayshortskip 6.5pt plus3.5pt minus3pt}

\def\small{\@setsize\small{12pt}\xpt\@xpt
\abovedisplayskip 10pt plus2pt minus5pt
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip \z@ plus3pt
\belowdisplayshortskip 6pt plus3pt minus3pt
\def\@listi{\topsep 6pt plus 2pt minus 2pt\parsep\z@}}

%%PF%%   \def\footnotesize{\@setsize\footnotesize{11pt}\ixpt\@ixpt
\def\footnotesize{\@setsize\footnotesize{10pt}\viiipt\@viiipt
\abovedisplayskip 8pt plus 2pt minus 4pt
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip \z@ plus 1pt
\belowdisplayshortskip 4pt plus 2pt minus 2pt
\def\@listi{\topsep 4pt plus 2pt minus 2pt\parsep\z@}}

\def\scriptsize{\@setsize\scriptsize{9.5pt}\viiipt\@viiipt}
\def\tiny{\@setsize\tiny{7pt}\vipt\@vipt}
\def\large{\@setsize\large{14pt}\xiipt\@xiipt}
\def\Large{\@setsize\Large{18pt}\xivpt\@xivpt}
\def\LARGE{\@setsize\LARGE{22pt}\xviipt\@xviipt}
\def\huge{\@setsize\huge{25pt}\xxpt\@xxpt}
\def\Huge{\@setsize\Huge{30pt}\xxvpt\@xxvpt}
\normalsize 

\skip\footins 6pt plus 2pt minus 2pt 
\floatsep 12pt plus 2pt minus 2pt \textfloatsep 20pt plus 2pt minus 4pt
\intextsep 12pt plus 2pt minus 2pt \@maxsep 20pt \dblfloatsep 12pt plus 2pt
minus 2pt \dbltextfloatsep 20pt plus 2pt minus 4pt \@dblmaxsep 20pt 
\@fptop 0pt plus 1fil \@fpsep 8pt plus 2fil \@fpbot 0pt plus 1fil 
\@dblfptop 0pt plus 1fil \@dblfpsep 8pt plus 2fil \@dblfpbot 0pt plus 1fil

\parskip 0pt plus 1pt 
\parindent 17pt 
\topsep 9pt plus 3pt minus 5pt
\partopsep 3pt plus 1pt minus 2pt 
\itemsep\z@
\@lowpenalty 51 \@medpenalty 151 \@highpenalty 301 
\@beginparpenalty -\@lowpenalty \@endparpenalty -\@lowpenalty \@itempenalty
-\@lowpenalty 

\leftmargini 2.5em
\leftmarginii 2.2em 
\leftmarginiii 1.87em 
\leftmarginiv 1.7em 
\leftmarginv 1em
\leftmarginvi 1em
\leftmargin\leftmargini
\labelwidth\leftmargini\advance\labelwidth-\labelsep
\labelsep .5em
\parsep 4.5pt plus 2pt minus 1pt

\def\@listi{\parsep\z@}

\def\@listii{\leftmargin\leftmarginii
\labelwidth\leftmarginii\advance\labelwidth-\labelsep
\topsep 4.5pt plus 2pt minus 1pt}

\def\@listiii{\leftmargin\leftmarginiii
\labelwidth\leftmarginiii\advance\labelwidth-\labelsep
\topsep 2pt plus 1pt minus 1pt 
\partopsep 1pt plus 0pt minus 1pt}

\def\@listiv{\leftmargin\leftmarginiv
\labelwidth\leftmarginiv\advance\labelwidth-\labelsep}

\def\@listv{\leftmargin\leftmarginv
\labelwidth\leftmarginv\advance\labelwidth-\labelsep}

\def\@listvi{\leftmargin\leftmarginvi
\labelwidth\leftmarginvi\advance\labelwidth-\labelsep}
\or %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DFNREP12.STY
\lineskip 1pt \normallineskip 1pt
\def\baselinestretch{1}

\def\@normalsize{\@setsize\normalsize{14.5pt}\xiipt\@xiipt
\abovedisplayskip 12pt plus3pt minus7pt
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip \z@ plus3pt
\belowdisplayshortskip 6.5pt plus3.5pt minus3pt}

\def\small{\@setsize\small{13.6pt}\xipt\@xipt
\abovedisplayskip 11pt plus3pt minus6pt
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip \z@ plus3pt
\belowdisplayshortskip 6.5pt plus3.5pt minus3pt
\def\@listi{\parsep\z@ \topsep 9pt plus 3pt minus 5pt}}

%%PF%%   \def\footnotesize{\@setsize\footnotesize{12pt}\xpt\@xpt
\def\footnotesize{\@setsize\footnotesize{10pt}\viiipt\@viiipt
\abovedisplayskip 10pt plus2pt minus5pt
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip \z@ plus3pt
\belowdisplayshortskip 6pt plus3pt minus3pt
\def\@listi{\topsep 6pt plus 2pt minus 2pt\parsep\z@}}

\def\scriptsize{\@setsize\scriptsize{9.5pt}\viiipt\@viiipt}
\def\tiny{\@setsize\tiny{7pt}\vipt\@vipt}
\def\TINY{\@setsize\TINY{12pt}\xpt\@xpt}
\def\large{\@setsize\large{18pt}\xivpt\@xivpt}
\def\Large{\@setsize\Large{22pt}\xviipt\@xviipt}
\def\LARGE{\@setsize\LARGE{25pt}\xxpt\@xxpt}
\def\huge{\@setsize\huge{30pt}\xxvpt\@xxvpt}
\let\Huge=\huge
\normalsize 

\skip\footins 8pt plus 2pt minus 4pt 
\floatsep 14pt plus 2pt minus 4pt \textfloatsep 20pt plus 2pt minus 4pt
\intextsep 14pt plus 4pt minus 4pt \@maxsep 20pt \dblfloatsep 14pt plus 2pt
minus 4pt \dbltextfloatsep 20pt plus 2pt minus 4pt \@dblmaxsep 20pt 
\@fptop 0pt plus 1fil \@fpsep 10pt plus 2fil \@fpbot 0pt plus 1fil 
\@dblfptop 0pt plus 1fil \@dblfpsep 10pt plus 2fil \@dblfpbot 0pt plus 1fil

\parskip 0pt plus 1pt 
\parindent 1.5em 
\topsep 10pt plus 4pt minus 6pt
\partopsep 3pt plus 2pt minus 2pt 
\itemsep\z@
\@lowpenalty 51 \@medpenalty 151 \@highpenalty 301 
\@beginparpenalty -\@lowpenalty \@endparpenalty -\@lowpenalty \@itempenalty
-\@lowpenalty 

\leftmargini 2.5em
\leftmarginii 2.2em 
\leftmarginiii 1.87em 
\leftmarginiv 1.7em 
\leftmarginv 1em
\leftmarginvi 1em
\leftmargin\leftmargini
\labelwidth\leftmargini\advance\labelwidth-\labelsep
\labelsep .5em
\parsep 5pt plus 2.5pt minus 1pt

\def\@listi{\parsep\z@}

\def\@listii{\leftmargin\leftmarginii
\labelwidth\leftmarginii\advance\labelwidth-\labelsep
\topsep 5pt plus 2.5pt minus 1pt}

\def\@listiii{\leftmargin\leftmarginiii
\labelwidth\leftmarginiii\advance\labelwidth-\labelsep
\topsep 2.5pt plus 1pt minus 1pt 
\partopsep 1pt plus 0pt minus 1pt}

\def\@listiv{\leftmargin\leftmarginiv
\labelwidth\leftmarginiv\advance\labelwidth-\labelsep}

\def\@listv{\leftmargin\leftmarginv
\labelwidth\leftmarginv\advance\labelwidth-\labelsep}

\def\@listvi{\leftmargin\leftmarginvi
\labelwidth\leftmarginvi\advance\labelwidth-\labelsep}
\fi }
%
%\let\@enumspacing\relax
% TWOSIDE option
\def\ds@twoside{\@twosidetrue \@mparswitchtrue} 
% DRAFT option
% \def\ds@draft{\overfullrule 15pt} 
% TWOCOLUMN option
\newif\if@mytemp \@mytempfalse
\def\ds@twocolumn{\@mytemptrue}
%\@options
%\input cern1\@ptsize.sty\relax
%
% 24 OCT 85; Craig
% '\par' is not allowed to occur as part of an argument (TeXbook, p. 205).
% '\par' may appear as argument (element BL) of TITLE, AUTHOR, etc.
% To get around this I define a macro which expands to '\par'.
%
\def\blpar{\ \par}
%
\def\lb{\lbrack}\def\rb{\rbrack}\let\xxstyle\textstyle

% Collapse citation numbers to ranges.  Non-numeric and undefined labels
% are handled.  No sorting is done.  E.g., 1,3,2,3,4,5,foo,1,2,3,?,4,5
% gives 1,3,2-5,foo,1-3,?,4,5
\newcount\@tempcntc
\def\@citex[#1]#2{\if@filesw\immediate\write\@auxout{\string\citation{#2}}\fi
  \@tempcnta\z@\@tempcntb\m@ne\def\@citea{}\@cite{\@for\@citeb:=#2\do
    {\@ifundefined
       {b@\@citeb}{\@citeo\@tempcntb\m@ne\@citea\def\@citea{,}{\bf ?}\@warning
       {Citation `\@citeb' on page \thepage \space undefined}}%
    {\setbox\z@\hbox{\global\@tempcntc0\csname b@\@citeb\endcsname\relax}%
     \ifnum\@tempcntc=\z@ \@citeo\@tempcntb\m@ne
       \@citea\def\@citea{,}\hbox{\csname b@\@citeb\endcsname}%
     \else
      \advance\@tempcntb\@ne
      \ifnum\@tempcntb=\@tempcntc
      \else\advance\@tempcntb\m@ne\@citeo
      \@tempcnta\@tempcntc\@tempcntb\@tempcntc\fi\fi}}\@citeo}{#1}}
\def\@citeo{\ifnum\@tempcnta>\@tempcntb\else\@citea\def\@citea{,}%
  \ifnum\@tempcnta=\@tempcntb\the\@tempcnta\else
   {\advance\@tempcnta\@ne\ifnum\@tempcnta=\@tempcntb \else \def\@citea{--}\fi
    \advance\@tempcnta\m@ne\the\@tempcnta\@citea\the\@tempcntb}\fi\fi}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  structure definitions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcounter {part}
\newcounter {chapter}
\newcounter {section}[chapter]
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\def\thepart {\arabic{part}}
\def\thechapter {\arabic{chapter}}
\def\normalsection{
   \def\thesection {\thechapter.\arabic{section}}
   \def\thesubsection {\thesection.\arabic{subsection}}
   \def\thesubsubsection {\thesubsection .\arabic{subsubsection}}
   \def\theparagraph {\thesubsubsection.\arabic{paragraph}}
   \def\thesubparagraph {\theparagraph.\arabic{subparagraph}}
}
%%PF%%  %%%%%%%%%%%%
   \def\thesection {\arabic{section}}
   \def\thesubsection {\thesection.\arabic{subsection}}
   \def\thesubsubsection {\thesubsection .\arabic{subsubsection}}
   \def\theparagraph {\thesubsubsection.\arabic{paragraph}}
   \def\thesubparagraph {\theparagraph.\arabic{subparagraph}}
%%PF%%  %%%%%%%%%%%%
\def\specialsection{
   \def\thesection {}
   \def\thesubsection {}
   \def\thesubsubsection {}
   \def\theparagraph {}
   \def\thesubparagraph {}
}
\def\@chapapp{\chapname}
\setcounter{secnumdepth}{3}
\setcounter{tocdepth}{6}
\let\SGMLstate=?           % No restirictions yet
%    F - front matter
%        r - preface    \clearpage in only first one *
%        a - abstract   \clearpage in only first one *
%    B - body
%        p - into Part  - no \clearpage in chapters
%    A - appendix            \clearpage in all chapters  
%    C - back  matter        \clearpage in all chapters   * 
%
%%%%%%%%%%%%%%%%%%%%%%%  P A R T %%%%%%%%%%%%%%%%%%%%%%
\def\part{\cleardoublepage\let\SGMLstate=p%
\global\@topnum\z@ \@ifstar{\@spart}{\@part}}
%
\def\@makeparthead#1{\vspace{25pt}
{\parindent\z@\centering\chapfont\partname{} \thepart\par\edef\@temp{#1}
\ifx\@temp\@empty \else 
{\nobreak \vskip 5pt\centering\mainkapfont#1\par} \fi
\nobreak\vskip 10pt}}
\def\@makesparthead#1{\vspace{25pt}
{\parindent\z@\edef\@temp{#1}\ifx\@temp\@empty \else 
{\nobreak\vskip 5pt\centering\mainkapfont#1\par} \fi
\nobreak\vskip 10pt}}
%
\def\@part#1{\refstepcounter{part}
\typeout{\partname\space\the\c@part.}
\addcontentsline{toc}{part}{\protect\numberline{\thepart}#1} 
\addtocontents{lof}{\protect\addvspace{10pt}}
\addtocontents{lot}{\protect\addvspace{10pt}} 
\if@twocolumn   \@topnewpage[\@makeparthead{#1}] 
\else\@makeparthead{#1}\@afterheading \fi} 
%
\def\@spart#1{\if@twocolumn \@topnewpage[\@makesparthead{#1}]
\else \@makesparthead{#1}\@afterheading\fi}
%
\def\partmark#1{\edef\@temp{#1}\ifx\@temp\@empty\else\markright{#1}\fi}
%%%%%%%%%%%%%%%%%%  C H A P T E R %%%%%%%%%%%%%%%%%%%%%%%%
\def\chapter{\if p\SGMLstate\else\cleardoublepage\fi
\global\@topnum\z@\@ifstar{\@schapter}{\@chapter}}
%
\def\@makechapterhead#1{\vspace{25pt}
\if p\SGMLstate
{\parindent\z@\centering\mainkapfont\thechapter.\space#1\par\nobreak\vskip 10pt}
\else
{\parindent\z@\centering\chapfont\@chapapp{} \thechapter\par 
\nobreak\vskip 5pt\centering\mainkapfont#1\par\nobreak\vskip 10pt}
\fi}
%
\def\@makeschapterhead#1{\vspace{25pt}{\parindent\z@
\centering\mainkapfont#1\par\nobreak\vskip 10pt}}
%
\def\@chapter#1{\refstepcounter{chapter}
\typeout{\@chapapp\space\the\c@chapter.}
\addcontentsline{toc}{chapter}{\protect\numberline{\thechapter}#1} 
\addtocontents{lof}{\protect\addvspace{10pt}}
\addtocontents{lot}{\protect\addvspace{10pt}} 
\if p\SGMLstate\@makechapterhead{#1}
\else
\if@twocolumn \@topnewpage[\@makechapterhead{#1}] 
\else \@makechapterhead{#1}\@afterheading \fi
\fi} 
%
\def\@schapter#1{
\if p\SGMLstate\@makeschapterhead{#1}
\else
\if@twocolumn\@topnewpage[\@makeschapterhead{#1}]
\else\@makeschapterhead{#1}\@afterheading\fi
\fi}
%
\def\chaptermark#1{\edef\@temp{#1}\ifx\@temp\@empty\else\markright{#1}\fi}
%%%%%%%%%%%%%%%%%%% A P P E N D I X %%%%%%%%%%%%%%%%%%%%%%%
\def\appendix{\par\let\SGMLstate=A%
   \setcounter{chapter}{0}
   \setcounter{section}{0}
   \setcounter{subsection}{0}
   \setcounter{subsubsection}{0}
   \setcounter{paragraph}{0}
   \def\@chapapp{\appname}
   \def\thechapter{\Alph{chapter}}
   \def\thesection{\Alph{section}}
}
%%%%%%%%%%%%%%%%%%%%%% O T H E R %%%%%%%%%%%%%%%%%%%%%%%%%%%
%\renewcommand{\@startsection}[6]
%   {\par
%    \if@nobreak
%    \else\addpenalty{-\@highpenalty}\addvspace{#4}\fi
%    \@dblarg{\@sect{#1}{#2}{#3}{#4}{#5}{#6}}}
%
\def\section{\@startsection {section}{1}{\z@}	% JNA-1 Change \huge to \LARGE
    {3.5ex plus 1ex minus .2ex}{2.3ex plus .2ex}{\LARGE\bf}}
\def\subsection{\@startsection{subsection}{2}{\z@}
    {3.25ex plus 1ex minus .2ex}{1.5ex plus .2ex}{\Large\bf}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}
    {3.25ex plus 1ex minus .2ex}{1.5ex plus .2ex}{\large\bf}}
\def\paragraph{\@startsection {paragraph}{4}{\z@}
    {3.25ex plus 1ex minus .2ex}{-1em}{\large\sl}}
\def\subparagraph{\@startsection{subparagraph}{5}{\z@}
    {3.25ex plus 1ex minus .2ex}{-1em}{\large\sl}}
%
%\def\x@startsection#1#2#3#4#5#6{\if@noskipsec \leavevmode \fi
%   \par \@tempskipa #4\relax
%   \@afterindenttrue
%   \ifdim \@tempskipa <\z@ \@tempskipa -\@tempskipa \@afterindentfalse\fi
%   \if@nobreak \everypar{}\else
%     \addpenalty{\@secpenalty}\addvspace{\@tempskipa}\fi \@ifstar
%     {\@ssect{#3}{#4}{#5}{#6}}{\@dblarg{\x@sect{#1}{#2}{#3}{#4}{#5}{#6}}}}
%
%\def\x@sect#1#2#3#4#5#6[#7]#8{
%     \ifnum #2>\c@secnumdepth 
%          \def\@svsec{}
%     \else
%          \refstepcounter{#1}\edef\@svsec{\csname the#1\endcsname\hskip 1em }
%     \fi
%     \@tempskipa #5\relax
%     \ifdim \@tempskipa>\z@
%         \begingroup #6\relax
%         \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty \@M #8\par}
%         \endgroup
%         \csname #1mark\endcsname{#7}
%         \ifnum #2>\c@secnumdepth 
%         \else
%              \addcontentsline
%              {toc}{#1}{\protect\numberline{\csname the#1\endcsname} #7}
%         \fi
%     \else
%         \def\@svsechd{#6\hskip #3\@svsec #8\csname #1mark\endcsname {#7}
%         \ifnum #2>\c@secnumdepth 
%         \else
%              \addcontentsline
%              {toc}{#1}{\protect\numberline{\csname the#1\endcsname} #7}
%         \fi
%         }
%     \fi
%     \@xsect{#5}}
%
%\def\subtitle#1#2{\def\@captype{#1}\refstepcounter\@captype\par
%    \setbox\@tempboxa\hbox{\csname fnum@#1\endcsname~:~\ignorespaces #2}
%   \ifdim \wd\@tempboxa >\hsize \unhbox\@tempboxa\par \else \hbox
%   to\hsize{\hfil\box\@tempboxa\hfil} 
%   \fi\par}
%%%%%%%%%%%%%%%%%%%%%%% I N T E R N A L   N A M E S %%%%%%%%%%%%%%%%%
\newdimen\listwidth
\newdimen\itemwidth
\def\NOTEname{Note:}
\def\REFERENCEname{References}
\def\TOCname{Table of Contents}
\def\FIGname{Figure~}
\def\TABname{Table~}
\def\LOFname{List of Figures}
\def\LOTname{List of Tables}
\def\chapname{Chapter}
\def\partname{Part}
\def\ABSTRACTname{Abstract}
\def\PREFACEname{Preface}
\def\INDEXname{Index}
\def\appname{Appendix}
%%%%%%%%%%%%%%%%%%%%%% TOC, LOF, LOT  %%%%%%%%%%%%%%%%%%%%%%%
\def\@pnumwidth{1.55em}
\def\@tocrmarg {2.55em}
\def\@dotsep{4.5}
\setcounter{tocdepth}{3}
\def\toc#1{\edef\@name{#1} \ifx\@name\@empty \def\@name{\TOCname}\fi
\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
\fi\clearpage\chapter*{\@name}\markright{\@name}
\@starttoc{toc}\if@restonecol\twocolumn\fi}
%
\def\@dotfill{\nobreak\leaders\hbox{$\m@th\mkern\@dotsep mu.\mkern\@dotsep mu$}}
%
\def\l@part#1#2{\pagebreak[3] 
\vskip 1.0em plus 1pt \@tempdima 1.5em \begingroup
\parindent \z@ \rightskip \@pnumwidth 
\parfillskip -\@pnumwidth 
\bf \leavevmode \partname~#1 \@dotfill \hfil \hbox to\@pnumwidth{\hss #2}\par
\endgroup}
\def\l@chapter{\@dottedtocline{0}{0.0em}{1.5em}}
\def\l@section{\@dottedtocline{1}{1.5em}{2.3em}}
\def\l@subsection{\@dottedtocline{2}{3.8em}{3.2em}}
\def\l@subsubsection{\@dottedtocline{3}{7.0em}{4.1em}}
\def\l@paragraph{\@dottedtocline{4}{11.1em}{5em}}
\def\l@subparagraph{\@dottedtocline{5}{16.1em}{6em}}
%
\def\lof#1{\edef\@name{#1} \ifx\@name\@empty \def\@name{\LOFname}\fi
\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
\fi\chapter*{\@name}\markright{\@name}
\@starttoc{lof}\if@restonecol\twocolumn\fi}
\def\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
%
\def\lot#1{\edef\@name{#1} \ifx\@name\@empty \def\@name{\LOTname}\fi
\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
\fi\chapter*{\@name}\markright{\@name}
\@starttoc{lot}\if@restonecol\twocolumn\fi}
\let\l@table\l@figure
%
\def\abstract#1{\edef\@name{#1} \ifx\@name\@empty \def\@name{\ABSTRACTname}\fi
\if a\SGMLstate \else \clearpage\let\SGMLstate=a\fi
\addcontentsline{toc}{chapter}{\@name}\chapter*{\@name}\specialsection}
%
\def\preface#1{\edef\@name{#1} \ifx\@name\@empty \def\@name{\PREFACEname}\fi
\if r\SGMLstate \else \clearpage\let\SGMLstate=r\fi
\addcontentsline{toc}{chapter}{\@name}\chapter*{\@name}\specialsection}
%
\def\backchapter#1{\edef\@name{#1} \ifx\@name\@empty \def\@name{~}\fi
\clearpage\chapter*{\@name}\markright{\@name}
\addcontentsline{toc}{chapter}{\@name}}
%
\def\backmatter{\let\SGMLstate=C%
\specialsection
\addtocontents{toc}{\protect\addvspace{10pt}}
\addtocontents{lof}{\protect\addvspace{10pt}}
\addtocontents{lot}{\protect\addvspace{10pt}} 
}
%
\def\addcontentsline#1#2#3{\if@filesw \begingroup
\def\umnormal{\"}\let\umnormal\umnormal
\let\label\@gobble \let\index\@gobble 
\def\protect##1{\string\string\string##1\string\space\space}
\def\myprotect##1{\string\string\string##1}
\def\umtoc{\myprotect\"}
\let\umtoc\umtoc\let\"\umtoc
\let\empZERO\empZEROcontent
\let\empEINS\empEINScontent
\let\empZWEI\empZWEIcontent
\let\empDREI\empDREIcontent
\let\empVIER\empVIERcontent
\@temptokena{\thepage}%
\edef\@tempa{\write \@auxout{\string\@writefile{#1}{\protect
     \contentsline{#2}{#3}{\the\@temptokena}}}}\@tempa\endgroup\fi}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     Headline, foot and other - DFN origin
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\foot#1{\def\@lfoot{#1}\def\@rfoot{#1}}\def\@lfoot{}\def\@rfoot{}
%
%Headline integrated with page number
%
\def\ps@SGMLprep{
\def\@oddhead{\hbox{}\headfont\rightmark \hfil\pagnumfont\thepage}
\def\@evenhead{\pagnumfont\thepage\hfill \headfont\leftmark\hbox{}}
\def\@oddfoot{}\let\@evenfoot\@oddfoot}
%
%Headline integrated with page number and undeflined
%
\def\ps@SGMLguid{\def\@line{\hbox to\textwidth}
\def\@oddhead{\underline{\@line{\hbox{}\headfont\rightmark 
\hfil\pagnumfont{}page~\thepage}}}
\def\@evenhead{\underline{\@line{\hbox{}\pagnumfont{}page~\thepage
\hfil\headfont\leftmark}}}
\def\@oddfoot{}\let\@evenfoot\@oddfoot}
%
%Headline and pagenumber on bottom of page
%
\def\ps@SGMLman{
\def\@oddhead{\hfil\headfont\rightmark\hbox{}}
\def\@evenhead\@oddhead{\hbox{}\headfont\leftmark\hfil}
\def\@oddfoot{\hss\pagnumfont-- \thepage\ --\hss}\let\@evenfoot\@oddfoot}
%
\def\ps@SGMLwrup{\def\@line{\hbox to\textwidth}
\def\@oddhead{\underline{\@line{\hbox{}\headfont\rightmark 
\hfil\pagnumfont{}page~\thepage}}}
\def\@evenhead{\underline{\@line{\hbox{}\pagnumfont{}page~\thepage
\hfil\headfont\leftmark}}}
\let\@evenhead\@oddhead
\def\@oddfoot{}\let\@evenfoot\@oddfoot}
%
\def\ps@empty{\def\@oddhead{}\def\@oddfoot{}\def\@evenhead{}\def\@evenfoot{}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%	 List, Label  - from LATEX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcount\@enumdepth \@enumdepth = 0
\@definecounter{enumi}
\@definecounter{enumii}
\@definecounter{enumiii}
\@definecounter{enumiv}
\@definecounter{enumv}
\@definecounter{enumvi}
%
\def\boundshift{\advance\listwidth by -\leftmargin%
\advance\itemwidth by -\leftmargin}
%
%-%\def\enumerate{\ifnum \@enumdepth >6 \@toodeep\else\advance\@enumdepth \@ne
%-%\edef\@enumctr{enum\romannumeral\the\@enumdepth}
%-%\list{\csname label\@enumctr\endcsname}
%-%{\usecounter{\@enumctr}\def\makelabel##1{\hss\llap{##1}}}\fi
%-%\boundshift}
%-%\let\endenumerate =\endlist
% ============ enumerate from article.sty
% ENUMERATE
%  Enumeration is done with four counters: enumi, enumii, enumiii
%  and enumiv, where enumN controls the numbering of the Nth level
%  enumeration.  The label is generated by the commands \labelenumi 
%  ... \labelenumiv.  The expansion of \p@enumN\theenumN defines the 
%  output of a \ref command.  
%
% 16 Mar 88 -- changed defs of \labelenum... to use \theenum...

\def\labelenumi{\theenumi.}    
\def\theenumi{\arabic{enumi}}     
 
\def\labelenumii{(\theenumii)}
\def\theenumii{\alph{enumii}}
\def\p@enumii{\theenumi}

\def\labelenumiii{\theenumiii.}
\def\theenumiii{\roman{enumiii}}
\def\p@enumiii{\theenumi(\theenumii)}

\def\labelenumiv{\theenumiv.}
\def\theenumiv{\Alph{enumiv}}     
\def\p@enumiv{\p@enumiii\theenumiii}
% ================= end enumerate
%
\newcount\@itemdepth \@itemdepth = 0
\def\itemize{\ifnum \@itemdepth >6 \@toodeep\else \advance\@itemdepth \@ne
\edef\@itemitem{labelitem\romannumeral\the\@itemdepth}
\list{\csname\@itemitem\endcsname}{\def\makelabel##1{\hss\llap{##1}}}\fi
\boundshift}
\let\enditemize =\endlist
%%
%\def\verse{\let\\=\@centercr 
%\list{}{\itemsep\z@ \itemindent -15pt\listparindent \itemindent 
%\rightmargin\leftmargin\advance\leftmargin 15pt}\item[]}
%\let\endverse\endlist
%%
\def\quotation{\list{}{\listparindent 1.5em 
\itemindent\listparindent
\rightmargin\leftmargin}\item[]}
\let\endquotation=\endlist
%%
%\def\quote{\list{}{\rightmargin\leftmargin}\item[]}
%\let\endquote=\endlist
%%%
\def\descriptionlabel#1{\descriptfont #1 \hfil}
\def\description{\@ifnextchar[{\@desc}{\@desc[10em]}}
\def\@desc[#1]{\list{}{\leftmargin#1
\labelwidth\leftmargin \advance\labelwidth -\labelsep 
\let\makelabel\descriptionlabel}\boundshift}
\def\endmylist{\if@newlist~\@newlistfalse\fi\endlist}      %% 22-jun-1989
\let\enddescription\endmylist                              %% to ignore LATEX 
%%%						           %% error
\let\glossarylist\description
\let\endglossarylist\enddescription
%
\def\NOTE#1{\begin{description}[5em]
    \item[\NOTEname] {\raggedright #1}\end{description}}

%%%%%%%%%%%% L A B E L   M A R K S %%%%%%%%%%%%%%%%%%
\def\theenumi{\arabic{enumi}} \def\labelenumi{\theenumi.}   
\def \p@enumi{\theenumi}
\def\theenumii{\alph{enumii}}    \def\labelenumii{\theenumii.}   
\def \p@enumii{\theenumi\theenumii}
\def\theenumiii{\roman{enumiii}} \def\labelenumiii{\theenumiii.}
\def \p@enumiii{\theenumi\theenumii\theenumiii}
\def\theenumiv{\arabic{enumiv}}  \def\labelenumiv{\theenumiv)} 
\def\p@enumiv{\theenumi\theenumii\theenumiii\theenumiv}
\def\theenumv{\alph{enumv}}      \def\labelenumv{\theenumv)}
\def\p@enumv{\theenumi\theenumii\theenumiii\theenumiv\theenumv}
\def\theenumvi{\roman{enumvi}}   \def\labelenumvi{\theenumvi)}  
\def\p@enumvi{\theenumi\theenumii\theenumiii\theenumiv\theenumv\theenumvi}
% 
%\let\@itemspacing=\relax
\def\labelitemi{$\bullet$}
\def\labelitemii{\bf --}
\def\labelitemiii{$\ast$}
\def\labelitemiv{$\cdot$}
%%%
%\def\itemhyphen{\def\labelitemi{\bf --}
%	\def\labelitemii{\bf --}
%	\def\labelitemiii{\bf --}
%	\def\labelitemiv{\bf --}}
%%
\def\itemsimple{\def\labelitemi{}\def\labelitemii{}\def\labelitemiii{}
\def\labelitemiv{}\def\labelitemv{}\def\labelitemvi{}}
%%%
\def\itemunorder{\def\labelitemi{$\bullet$}\def\labelitemii{\bf --}
\def\labelitemiii{\bf --}\def\labelitemiv{\bf --}
\def\labelitemv{\bf --}\def\labelitemvi{\bf --}}
%%%
%\def\itembullet{\def\labelitemi{$\bullet$}
%	\def\labelitemii{$\bullet$}
%	\def\labelitemiii{$\bullet$}
%	\def\labelitemiv{$\bullet$}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%	DFN origin
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newinsert\topins
\newif\ifp@ge \newif\if@mid
\def\topinsert{\@midfalse\p@gefalse\@ins}
\def\midinsert{\@midtrue\@ins}
\def\pageinsert{\@midfalse\p@getrue\@ins}
\skip\topins=\z@skip % no space added when a topinsert is present
\count\topins=1000 % magnification factor (1 to 1)
\dimen\topins=\maxdimen % no limit per page
\def\@ins{\par\begingroup\setbox\z@\vbox\bgroup} % start a \vbox
\def\endinsert{\egroup % finish the \vbox
  \if@mid \dimen@\ht\z@ \advance\dimen@\dp\z@
    \advance\dimen@12\p@ \advance\dimen@\pagetotal
    \ifdim\dimen@>\pagegoal\@midfalse\p@gefalse\fi\fi
  \if@mid \bigskip\box\z@\bigbreak
  \else\insert\topins{\penalty100 % floating insertion
    \splittopskip\z@skip
    \splitmaxdepth\maxdimen \floatingpenalty\z@
    \ifp@ge \dimen@\dp\z@
    \vbox to\vsize{\unvbox\z@\kern-\dimen@}% depth is zero
    \else \box\z@\nobreak\bigskip\fi}\fi\endgroup}

%\def\@begintheorem#1#2{\global\advance\@listdepth -1\relax
%\list{}{\leftmargin 0pt\labelwidth -\labelsep}\item[{\bf #1\ #2}]\it}
%\def\@endtheorem{\endlist\global\advance\@listdepth 1\relax}
\@addtoreset{equation}{chapter} 
%\def\theequation{\thechapter.\arabic{equation}}
\def\theequation{\arabic{equation}}%jea 5-oct-1991
%
\newbox\@subro
\newcounter{subroutine}
\def\subroutine{\refstepcounter{subroutine}\obeylines\@parboxrestore\par%
\tt\global\setbox\@subro\hbox\bgroup\boxmaxdepth\z@}%
\def\endsubroutine{\egroup\fboxsep=0.5em\fbox{\usebox{\@subro}}\par}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%               I N D E X  - from IDXTEX
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\makeindex{\if@filesw \newwrite\@indexfile
  \immediate\openout\@indexfile=\jobname.idx
  \def\index{\@bsphack\begingroup\@sanitize\@wrindex\@indexfile}\typeout
  {Writing index file \jobname.idx }\fi}

\def\@wrindex#1#2{\let\thepage\relax%
\xdef\@gtempa{\write#1{\string\indexentry{#2}{\thepage}{@\level}}}%
\endgroup\@gtempa%
\if@nobreak\ifvmode\nobreak\fi\fi\@esphack}%
\def\dummyref{\def\@wrindex##1##2{%
\xdef\@gtempa{\write##1{\string\indexentry{##2}{}{@\level}}}\endgroup%
\@gtempa\if@nobreak \ifvmode\nobreak\fi\fi\@esphack}%
}
\def\index{\@bsphack\begingroup\@sanitize\@index}

\def\@index#1{\endgroup\@esphack}

\def\setlevel#1{\xdef\level{LEV#1}}
\def\@namexdef#1{\expandafter\xdef\csname#1\endcsname}
\def\@ldef#1#2{\@namexdef{#1\level}{#2}}
\def\@luse#1{\@nameuse{#1\level}}
%
%    defindex*   -  define the proper , SUB or SUBSUB
%
\setlevel{1}\@ldef{@}{}\@ldef{@@}{}\@ldef{@@@}{}
\setlevel{2}\@ldef{@}{}\@ldef{@@}{}\@ldef{@@@}{}
\setlevel{3}\@ldef{@}{}\@ldef{@@}{}\@ldef{@@@}{}
%
%    index*     - make reference #1 - prefix  #2 - suffix
\def\indexone#1#2{\edef\@tmpa{#1}%
\ifx\@tmpa\@empty\expandafter\index{\@luse{@}#2}%
\else\expandafter\index{\string#1\@luse{@}#2}%
\fi}
%
\def\indextwo#1#2{\edef\@tmpa{\@luse{@}}\edef\@tmpb{\@luse{@@}}%
\ifx\@tmpa\@empty%
\@warning{First level index is not defined for ref. `\@tmpb'}%
\else\edef\@tmpa{#1}\ifx\@tmpa\@empty%
\expandafter\index{\@luse{@}>\@luse{@@}#2}%
\else\expandafter\index{\string#1\@luse{@}>\@luse{@@}#2}\fi%
\fi}
%
\def\indexthree#1#2{\edef\@tmpa{\@luse{@}}\edef\@tmpb{\@luse{@@@}}%
\ifx\@tmpa\@empty%
\@warning{First level index is not defined for ref. `\@tmpb'}%
\else\edef\@tmpa{\@luse{@@}}\ifx\@tmpa\@empty%
\@warning{Second level index is not defined for ref. `\@tmpb'}%
\else\edef\@tmpa{#1}\ifx\@tmpa\@empty%
\expandafter\index{\@luse{@}>\@luse{@@}>\@luse{@@@}#2}%
\else\expandafter\index{\string#1\@luse{@}>\@luse{@@}>\@luse{@@@}#2}\fi\fi%
\fi}
%
%    savindex*  - save proper  in ref@...   reference
%                 and create command com@... for restoring
%                 and create command idx@... for repeating
\def\savindexone#1{\edef\@@tmpa{\@luse{@}}%
\@namedef{com@#1\level}{\@ldef{@}{\csname @@tmpa\endcsname}}%
\@ldef{ref@#1}{\@luse{@}}%
\@namedef{idx@#1\level}{\indexone{}{}}%
}

\def\savindextwo#1{\edef\@@tmpa{\@luse{@}}%
\@namedef{com@#1\level}{\@ldef{@}{\csname @@tmpa\endcsname}
\@ldef{@@}{\csname @@tmpb\endcsname}}%
\@ldef{ref@#1}{\@luse{@@}}%
\@namedef{idx@#1\level}{\indexone{}{}}%
}

\def\savindexthree#1{\edef\@@tmpa{\@luse{@}}%
\edef\@@tmpb{\@luse{@@}}%
\edef\@@tmpc{\@luse{@@}}%
\@namedef{com@#1\level}{\@ldef{@}{\csname @@tmpa\endcsname}%
\@ldef{@@}{\csname @@tmpb\endcsname}%
\@ldef{@@@}{\csname @@tmpc\endcsname}}%
\@ldef{ref@#1}{\@luse{@@@}}%
\@namedef{idx@#1\level}{\indexone{}{}}%
}
%
\def\restindex#1{\@luse{com@#1}}
\def\seeindex#1{\@luse{ref@#1}}
\def\repeatindex#1{\@luse{idx@#1}}
%
%\SGMLindexone{levelnum}{VALUE}{ID}{REFID}{SEE}{SEEID}
%                  #1     #2    #3    #4    #5   #6
\def\SGMLindexone#1#2#3#4#5#6{\setlevel{#1}\@ldef{@}{#2}%
\edef\@tmpa{#4}\ifx\@tmpa\@empty\else\begingroup\restindex{#4}\fi%
\edef\@tmpa{#5}\ifx\@tmpa\@empty%
\edef\@tmpa{#6}\ifx\@tmpa\@empty%
\indexone{}{}%
\else\indexone{}{&\seeindex{#6}}\fi%
\else\indexone{}{&#5}\fi%
\edef\@tmpa{#3}\ifx\@tmpa\@empty\else\savindexone{#3}\fi%
\edef\@tmpa{#4}\ifx\@tmpa\@empty\else\endgroup\fi%
}

\def\SGMLindextwo#1#2#3#4#5#6{\setlevel{#1}\@ldef{@@}{#2}%
\edef\@tmpa{#4}\ifx\@tmpa\@empty\else\begingroup\restindex{#4}\fi%
\edef\@tmpa{#5}\ifx\@tmpa\@empty%
\edef\@tmpa{#6}\ifx\@tmpa\@empty%
\indextwo{}{}\else%
\indextwo{}{&\seeindex{#6}}\fi\else\indextwo{}{&#5}\fi%
\edef\@tmpa{#3}\ifx\@tmpa\@empty\else\savindextwo{#3}\fi%
\edef\@tmpa{#4}\ifx\@tmpa\@empty\else\endgroup\fi%
}

\def\SGMLindexthree#1#2#3#4#5#6{\setlevel{#1}\@ldef{@@@}{#2}%
\edef\@tmpa{#4}\ifx\@tmpa\@empty\else\begingroup\restindex{#4}\fi%
\edef\@tmpa{#5}\ifx\@tmpa\@empty%
\edef\@tmpa{#6}\ifx\@tmpa\@empty%
\indexthree{}{}\else\indexthree{}{&\seeindex{#6}}\fi\else\indexthree{}{&#5}%
\fi\edef\@tmpa{#3}\ifx\@tmpa\@empty\else\savindexthree{#3}\fi%
\edef\@tmpa{#4}\ifx \@tmpa\@empty\else\endgroup\fi%
}

\def\insertindex#1#2{\edef\@tempa{#1}\ifx\@tempa\@empty\else
\def\INDEXname{#1}\fi\@input{\jobname_#2.ind}}
\newif\if@restonecol
\def\theindex{\cleardoublepage\@restonecoltrue\if@twocolumn\@restonecolfalse\fi
 \columnseprule \z@
 \columnsep 35pt\twocolumn[\@makeschapterhead{\INDEXname}]
 \addcontentsline{toc}{section}{\INDEXname}  \typeout{Index.}
 \markboth{\INDEXname}{\INDEXname}\parindent\z@
 \parskip\z@ plus .3pt\relax\let\item\@idxitem
  \def\indexhead##1##2##3{\par\if@nobreak \everypar{}\else
    \addpenalty{\@secpenalty}\addvspace{##1}\fi
    \@xsect{##2}}
    \def\indexindent{\par\hangindent 50pt\hspace*{40pt}}
}

\def\@idxitem{\par\hangindent 40pt}
\def\subitem{\par\hangindent 40pt \hspace*{20pt}}
\def\subsubitem{\par\hangindent 40pt \hspace*{30pt}}
\def\endtheindex{\if@restonecol\onecolumn\else\clearpage\fi}
\def\indexspace{\par \vskip 10pt plus 5pt minus 3pt\relax}


\def\footnoterule{\kern-1\p@ \hrule width .4\columnwidth \kern .6\p@} 
\@addtoreset{footnote}{chapter} 
\let\@footnotenumber\@arabic 
\long\def\@makefntext#1{\parindent 1em\noindent 
 \hbox to 1.8em{\hss$^{\@thefnmark}$}#1}
%\long\def\@makefntext#1#2{\noindent \hangindent 5pt\hbox 
%to 5pt{\hss $^{#1}$}#2}
%\def\@makefnmark#1{\hbox{$^{#1}$}} 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   figure, tables
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%\long\def\@makecaption#1#2{\vskip 5pt \list{}
%{\labelwidth 7em \labelsep 0.5em \rightmargin\z@}\item[#1]#2\endlist}
%
\def\@xfloat#1[#2]{
   \advance \columnwidth -\boxreduction
   \ifhmode \@bsphack\@floatpenalty -\@Mii\else
   \@floatpenalty-\@Miii\fi\def\@captype{#1}\ifinner
      \@parmoderr\@floatpenalty\z@
    \else\@next\@currbox\@freelist{\@tempcnta\csname ftype@#1\endcsname
       \multiply\@tempcnta\@xxxii\advance\@tempcnta\sixt@@n
       \@tfor \@tempa :=#2\do
                        {\if\@tempa h\advance\@tempcnta \@ne\fi
                         \if\@tempa t\advance\@tempcnta \tw@\fi
                         \if\@tempa b\advance\@tempcnta 4\relax\fi
                         \if\@tempa p\advance\@tempcnta 8\relax\fi
         }\global\count\@currbox\@tempcnta}\@fltovf\fi
    \global\setbox\@currbox\vbox\bgroup
    \boxmaxdepth\z@
    \hsize\columnwidth }%\@parboxrestore}

\def\end@float{\egroup
     \@frameframe{\@currbox}            % A.S.
   \ifnum\@floatpenalty <\z@
     \@cons\@currlist\@currbox
     \ifdim \ht\@currbox >\textheight
        \ht\@currbox\textheight \fi
     \ifnum\@floatpenalty < -\@Mii
        \penalty -\@Miv \vbox{}\penalty\@floatpenalty
      \else \vadjust{\penalty -\@Miv \vbox{}\penalty\@floatpenalty}\@esphack
     \fi\fi
     \advance \columnwidth \boxreduction
}
% update box by adding the frame around this box
\newdimen\boxreduction
\def\framefloat{
\def\@frameframe##1{\sbox{##1}{\framebox[\hsize][c]{\usebox{##1}}}}
\boxreduction\fboxsep \advance\boxreduction\fboxsep
}
\def\noframefloat{\def\@frameframe##1{\relax}\boxreduction\z@}\noframefloat
%%%
\setcounter{topnumber}{2}
\def\topfraction{.7}
\setcounter{bottomnumber}{1}
\def\bottomfraction{.3}
\setcounter{totalnumber}{3}
\def\textfraction{.2}
\def\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\def\dbltopfraction{.7}
\def\dblfloatpagefraction{.5}
%
\newcounter{figure}
\def\thefigure{\@arabic\c@figure}
\def\fps@figure{htbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\FIGname \thefigure}
\def\figure{\@float{figure}}
\let\endfigure\end@float
\@namedef{figure*}{\@dblfloat{figure}}
\@namedef{endfigure*}{\end@dblfloat}
%%%%%%%%%%
\newcounter{table}
\def\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\TABname \thetable}
\def\table{\@float{table}}
\let\endtable\end@float
\@namedef{table*}{\@float{table}}
\@namedef{endtable*}{\end@float}
%
\long\def\@makecaption#1#2{\large
\vskip 10pt 
\setbox\@tempboxa\hbox{#1: #2}
\ifdim \wd\@tempboxa >\hsize \unhbox\@tempboxa\par \else \hbox
to\hsize{\hfil\box\@tempboxa\hfil} 
\fi}
%%%%%%%%%%%%%%% Some changed in TABULAR env. %%%%%%%%%%%
\def\@testpach#1{\@chclass \ifnum \@lastchclass=\tw@ 4 \else
    \ifnum \@lastchclass=3 5 \else
     \z@ \if #1c\@chnum \z@ \else
                              \if #1l\@chnum \@ne \else
                              \if #1r\@chnum \tw@ \else
                              \if #1x\@chnum 3    \else
          \@chclass \if #1|\@ne \else
                    \if #1@\tw@ \else
                    \if #1p3 \else \z@ \@preamerr 0\fi
  \fi \fi  \fi  \fi  \fi  \fi  \fi
\fi}

\def\@tabclassz{\ifcase \@lastchclass \@acolampacol \or \@ampacol \or
   \or \or \@addamp \or
   \@acolampacol \or \@firstampfalse \@acol \fi
\edef\@preamble{\@preamble
  \ifcase \@chnum
         \hfil\ignorespaces\@sharp\unskip\hfil
     \or \ignorespaces\@sharp\unskip\hfil
     \or \hfil\hskip\z@ \ignorespaces\@sharp\unskip
     \or \ignorespaces\@sharp\fi}}

\def\nextname{\xdef\name{\name @}}
\def\@namexdef#1{\expandafter\xdef\csname#1\endcsname}
%
% \newtbl - initiate flags as LEFT alignment
% \newrow - initiate \NAME  and flags if any
% \tbl    - rewrite flag for this point and form field
%
% 0 - left, 1 - center, 2- right
\def\newtbl#1{\xdef\name{tab}%
\nextname\@namexdef{\name}{#1}%
\nextname\@namexdef{\name}{#1}%
\nextname\@namexdef{\name}{#1}%
\nextname\@namexdef{\name}{#1}%
\nextname\@namexdef{\name}{#1}%
\nextname\@namexdef{\name}{#1}%
\nextname\@namexdef{\name}{#1}%
\nextname\@namexdef{\name}{#1}%
\nextname\@namexdef{\name}{#1}%
\nextname\@namexdef{\name}{#1}%
\nextname\@namexdef{\name}{#1}}
%
\def\newtblleft{\newtbl{\z@}}
\def\newtblcenter{\newtbl{\@ne}}
\def\newtblright{\newtbl{\tw@}}
%
\def\newrow#1{\edef\@tempa{#1}%
\if L\@tempa\newtblleft\else%
\if C\@tempa\newtblcenter\else%
\if R\@tempa\newtblright\else%
\fi\fi\fi\xdef\name{tab}}
%
\def\tbl#1#2{\nextname\edef\@tempa{#1}%
\if L\@tempa\@namexdef{\name}{\z@}\else%
\if C\@tempa\@namexdef{\name}{\@ne}\else%
\if R\@tempa\@namexdef{\name}{\tw@}\else%
\fi\fi\fi%
\edef\@tempa{\@nameuse{\name}}%
\ifcase \@tempa%
\ignorespaces#2\unskip\hfil\or%
\hfil\ignorespaces#2\unskip\hfil\or%
\hfil\hskip\z@\ignorespaces#2\unskip\or%
\fi}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
%    example, block
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\dummypar{\leftskip\@totalleftmargin\rightskip\z@
\parindent\z@\parfillskip\@flushglue\parskip\z@ }
%*********************** E X A M P L E ********************
\def\example{\dummypar  \def\\{\par}}
\def\endexample{\@restorepar}
%***********************   B O X      ********************
\newcommand{\mybox}[1]{\vskip\fboxsep\def\leavevmode{\noindent}%
\framebox[\hsize][l]{\advance \hsize by -6pt\vbox{\sloppy#1}}%
\vskip \fboxsep}
%
% **************** T I T L E P A G E *******************
%
\def\title#1{\xdef\@title{\@title \par  #1}}\xdef\@title{}
%
\def\author#1{
\begingroup\let\end\relax\let\begin\relax\let\authoref\relax
\edef\@tempa{\@author}
\ifx\@tempa\empty
\xdef\@author{\begin{tabular}[t]{c}#1\end{tabular}}
\else
\xdef\@author{\@tempa\hskip 1pt\begin{tabular}[t]{c}#1\end{tabular}}
\fi\endgroup}
\gdef\@author{}
%
\def\address#1{\gdef\@address{#1}}\gdef\@address{}
%
\def\docnum#1{\gdef\@docnum{#1}}\gdef\@docnum{}
%
\def\date#1{\edef\@temp{#1}
\ifx\@temp\@empty\gdef\@date{\today}\else\gdef\@date{#1}\fi}
\gdef\@date{}
%
\def\cpright#1{\edef\@temp{#1}
\ifx\@temp\@empty\gdef\@cpright{\copyright~\number\year}\else
\gdef\@cpright{\copyright~#1}\fi}\gdef\@cpright{}
%
\def\copynote#1{\gdef\@copynote{#1}}\gdef\@copynote{}
%
\def\security#1{\gdef\@security{#1}}\gdef\@security{}
%
\def\titlepage{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
\else \clearpage \fi \thispagestyle{empty}
%%%PF   \large
\let\footnotesize\normalsize\setcounter{page}{1}\setcounter{footnote}{0}}
\def\endtitlepage{\if@restonecol\twocolumn \else  \fi}
%
\newcounter{instfoot}
\newcounter{notefoot}
%
%  \wfor - loop on words
%
\def\@wfor#1:=#2\do#3{\xdef\@fortmp{#2}\ifx\@fortmp\@empty \else
    \@wforloop#2 \@nil \@@#1{#3}\fi}
\def\@wforloop#1 #2\@@#3#4{\def#3{#1}\ifx #3\@nnil
       \let\@nextwhile=\@fornoop \else
      #4\relax\let\@nextwhile=\@wforloop\fi\@nextwhile#2 \@@#3{#4}}
%
\def\authoref#1{\def\authormark##1{\@nameuse{author@##1}}\def\@tempqq{}%
\hbox{$^{\@wfor\@a:=#1\do{\@tempqq\authormark{\@a}\def\@tempqq{,}})}$}}
%
% \insttfoot - create "inst" footnote for titlepage
%
\def\notetfoot#1#2{%
\@ifundefined{author@#1}{\stepcounter{notefoot}%
\expandafter\xdef\csname author@#1\endcsname{\alph{notefoot}}}{}%
\xdef\@thefnmark{\@nameuse{author@#1}}\@footnotetext{#2}}
%
% \notetfoot - create "note" footnote for titlepage
%
\def\insttfoot#1#2{%
\@ifundefined{author@#1}{\stepcounter{instfoot}%
\expandafter\xdef\csname author@#1\endcsname{\arabic{instfoot}}}{}%
\xdef\@thefnmark{\@nameuse{author@#1}}\@footnotetext{#2}}
%%%%%%%%%
\def\maketitle{
\vfil
\begin{center}
\samepage
\nobreak\null\nobreak\vfill\nobreak
{\titlefont\@title\par}\nobreak\vfill\nobreak
{\titlepagefont\@docnum\par}\nobreak\vfill\nobreak
{\authorfont\@author\par}\nobreak\vfill\nobreak
{\titlepagefont\@address\par}\nobreak\vfill\nobreak
{\titlepagefont\@date\par}\nobreak\vfill\nobreak
{\titlepagefont\@cpright\par}\nobreak\vfill\nobreak
{\titlepagefont\@security\par}\nobreak\null\nobreak
\vfill\nobreak
\end{center}\par
\vfil
\setcounter{footnote}{0} \gdef\@author{}\gdef\@title{}\gdef\@address{}
\gdef\maketitle{} \gdef\tfoot{} }
%    ****************************************
%    *             BIBLIOGRAPHY             *
%    ****************************************
%
% The thebibliography environment executes the following commands:
%
%  \def\newblock{\hskip .11em plus .33em minus .07em} --
%      Defines the `closed' format, where the blocks (major units of 
%      information) of an entry run together.
%
%  \sloppy  -- Used because it's rather hard to do line breaks in 
%      bibliographies,
% 
%  \sfcode`\.=1000\relax --
%      Causes a `.' (period) not toproduce an end-of-sentence space.

%-%\def\thebibliography#1{\section*{References\@mkboth
%-%  {REFERENCES}{REFERENCES}}\list
\def\thebibliography#1{\section*{References}
  \list
  {[\arabic{enumi}]}{\settowidth\labelwidth{[#1]}\leftmargin\labelwidth
    \advance\leftmargin\labelsep
    \usecounter{enumi}}
    \def\newblock{\hskip .11em plus .33em minus .07em}
    \sloppy\clubpenalty4000\widowpenalty4000
    \sfcode`\.=1000\relax}

\let\endthebibliography=\endlist

 \def\@biblabel#1{[#1]\hfill}  % Produces the label for a \bibitem[...]
                               % command. 
 \def\@cite#1{[#1]}            % Produces the output of the \cite command.

%
%\def\DATE#1{\rm\centering{#1}\vskip 0.5cm}
%\def\RULE{\nobreak\hrule\nobreak\vskip 0.5cm\nobreak}

\def\today{\ifcase\month\or
January\or February\or March\or April\or May\or June\or
July\or August\or September\or October\or November\or December\fi
\space\number\day, \number\year}
\def\tomonth{\ifcase\month\or
 January\or February\or March\or April\or May\or June\or
 July\or August\or September\or October\or November\or December\fi
 \space\number\year}
\newcount\minutes
\newcount\hours
\def\timestring{\hours=0\minutes=\time \ifnum\minutes<60\relax\else
                \loop\advance\minutes by -60 \advance\hours by 1
                \ifnum\minutes>60\repeat\fi
                \space\ifnum\hours<10 0\else\relax\fi
                \number\hours :\ifnum\minutes<10 0\else\relax\fi\number\minutes}
\def\dummy#1{}

%%%%%%%%%%%%%%%%%%%%%%%  F O N T   A S S I N G M E N T %%%%%%%%%%%%%
\def\mainkapfont{\Large\bf}     % for PART and CHAPTER headings
\def\subkapfont{\Large\bf}      % for SECTION, SUBSECTION and SUBSUBSECTION
\def\parkapfont{\Large\sl}      % for PARAGRAPH 
\def\subparkapfont{\Large}      % for SUBPARAGRAPH
\def\titlefont{\LARGE\bf}       % for TITLE
\def\authorfont{\Large}         % for authors 
\def\titlepagefont{\Large}      % for TITLE
\def\pagnumfont{\rm}            % for PAGE word and counter
\def\headfont{\normalsize\sc}   % for runheading
\def\descriptfont{\bf}          % for DESCRIPTION and GLOSSARY env.
\def\captfont{\large\rm}              % for PICTURE & FIGURE caption
\def\chapfont{\Large\bf}        % for words PART & CHAPTER
\newfont{\egttt}{cmtt8} % typewriter for LISTING
%\def\3{{\ss}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def \mynoexpand {}
% number of cards per page = 53 for 10pt
\textheight   694.0pt
\textwidth    452.9679pt
% footer
\footheight    12.0pt 
\footskip      24.0pt 
% header
\headheight    12.0pt 
\headsep       30.0pt 
\topmargin    -30.0pt
% margins
\evensidemargin 0pt
\oddsidemargin  0pt
\marginparsep   0pt
\marginparpush  0pt
\marginparwidth 0pt  
% twocolumns
\columnseprule  0pt
\columnsep     10pt
%
\tolerance=9999
\clubpenalty=100000
\widowpenalty=100000
\looseness=2
\raggedbottom
\showboxdepth=-1
\showboxbreadth=-1
%
\ps@empty\pagenumbering{arabic} 
\def\@minipagerestore{\let\@mpfnnumber\@alph } 
\onecolumn 
\arraycolsep 5pt \tabcolsep 3pt \arrayrulewidth .4pt \doublerulesep 2pt 
\tabbingsep \labelsep 
\fboxsep = 3pt \fboxrule = .4pt 
\parskip 1.1ex plus 0.4ex minus 0.2ex
\listwidth =\textwidth
\itemwidth =\textwidth
%
%\def \pagnumfont {\mynoexpand \normalsize \mynoexpand \rm }
%\def \headfont {\mynoexpand \normalsize \mynoexpand \rm }
%\def \titlefont {\mynoexpand \Large \mynoexpand \bf }
%\def \authorfont {\mynoexpand \normalsize \mynoexpand \sc }
%\def \mainkapfont {\mynoexpand \Large \mynoexpand \bf }
%\def \subkapfont {\mynoexpand \normalsize \mynoexpand \bf }
%\def \descriptfont {\mynoexpand \normalsize \mynoexpand \sl }
\def \empZERO #1{{\mynoexpand \normalsize \mynoexpand {#1}}}
\def \empEINS #1{{\mynoexpand \normalsize \mynoexpand \it {#1}}}
\def \empZWEI #1{{\mynoexpand \normalsize \mynoexpand \bf {#1}}}
\def \empDREI #1{{\mynoexpand \underline {#1}}}
%\def \empZEROcontent #1 {{\mynoexpand \normalsize {#1}}}
%\let \empZEROcontent \empZEROcontent
%\def \empEINScontent #1 {{\mynoexpand \normalsize \mynoexpand \it {#1}}}
%\let \empEINScontent \empEINScontent
%\def \empZWEIcontent #1 {{\mynoexpand \normalsize \mynoexpand \bf {#1}}}
%\let \empZWEIcontent \empZWEIcontent
%\def \empDREIcontent #1 {{\mynoexpand \underline {#1}}}
%\let \empDREIcontent \empDREIcontent
%\input chpnum
\def \linespacing  {}
%\if@mytemp {\twocolumn\sloppy\flushbottom}\fi
\makeatother
\makeatletter
\@options\@mysize\gdef\@mysize{}
\if@mytemp {\twocolumn\sloppy\flushbottom}\fi
\vsize=1000pt
\outputpenalty=-10001
\mark{{}{}}
\makeatother
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                 macros definitions for Delphi papers                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% footnote marked with special symbols
  \newcommand{\specfoot}[2]{
  \renewcommand{\thefootnote}{\fnsymbol{footnote}}
  \footnote[#1]{#2}
  \renewcommand{\thefootnote}{\arabic{footnote}}
  }
%
%-----------------------------------------------------------------------
% we define today's date in European format
\def\today{\number\day\space
     \ifcase\month\or
       January\or February\or March\or April\or May\or June\or
       July\or August\or September\or Octobre\or November\or December\fi
     \space\number\year}
%%                            Added at 12:40:24 on 15 Nov 1988 by JOWETT
%-----------------------------------------------------------------------
%
