%% Ceci est le fichier `edpa.cls'
%% Ao^ut 1999 Sept. 1999 Dc. 1999
%% 
%% Les Journes quations aux Drives Partielles (Atlantiques)
%% sont organises par le GDR 1151 CNRS
%% Ses actes sont dits depuis 1998 par le 
%%            Laboratoire de Mathmatiques de l'Universit de Nantes
%%            UMR 6629 UN/CNRS
%%            www.math.sciences.univ-nantes.fr
%% avec le soutien de la 
%%            Cellule MathDoc
%%            UMS 5638 UJF/CNRS
%%            www-mathdoc.ujf-grenoble.fr


\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{edpa}[1999/12/23 v0.14]

\newif\ifProofEDPA   \ProofEDPAtrue

\LoadClass[a4paper,12pt,twoside,onecolumn,final]{article}

\RequirePackage[latin1]{inputenc}

\newif\ifedpaFr \edpaFrfalse
\DeclareOption{en}{\edpaFrfalse}
\DeclareOption{fr}{\edpaFrtrue}

\newif\ifEqSect \EqSectfalse
\DeclareOption{equsect}{\EqSecttrue\renewcommand{\theequation}{\thesection.\arabic{equation}}}

\ProcessOptions

\newtoks\EDPAan  
\newtoks\EDPAjours
\newtoks\EDPAlieu

\newcommand{\EDPAdate}{\href{http://www.math.sciences.univ-nantes.fr/edpa/\the\EDPAan/pdf/\the\EDPAan.pdf}{\small
    \the\EDPAlieu, \the\EDPAjours{} \the\EDPAan}}

\newcommand{\EDPAGDR}{\noindent\begin{minipage}{8cm}
\small
\href{http://www.math.sciences.univ-nantes.fr/edpa/}{\small\color{Rouge} Journ\'ees {\em \'Equations aux d\'eriv\'ees partielles}}\\
\EDPAdate\\
\href{http://www.maths.univ-rennes1.fr/edp/gdr.html}{\small GDR 1151}
(\href{http://www.cnrs.fr}{\small CNRS})
\end{minipage}
\vspace{2cm}}

\setlength{\textwidth}{15cm}
\setlength{\textheight}{23.5cm}
\setlength{\abovedisplayskip}{14pt}
\setlength{\belowdisplayskip}{14pt}
\setlength{\abovedisplayshortskip}{14pt}
\setlength{\belowdisplayshortskip}{14pt}
\setlength{\topmargin}{-.5in}
\setlength{\oddsidemargin}{1cm}
\setlength{\evensidemargin}{0.3cm}

\long\def\abstract#1{\immediate\def\AbExp{#1}}

\def\ps@edpa{\let\@mkboth\@gobbletwo
     \let\@oddhead\@empty\def\@oddfoot{\reset@font\hfil \NumExp--\thepage
     \hfil}\let\@evenhead\@empty\let\@evenfoot\@oddfoot
% Vrifier que l'option twoside fonctionne bien !
% \ifodd\count0\global\setlength{\oddsidemargin}{1cm}
%  \else\global\setlength{\oddsidemargin}{0.45cm}\fi
}

\IfFileExists{data.tex}{\ProofEDPAfalse}%

\ifProofEDPA
\newcommand{\NumExp}{\jobname}
\EDPAan{2000}
\EDPAjours{5-9 juin}
\EDPAlieu{Nantes}
\pagestyle{plain}
\else
\input data
\def\NumExp{\csname\jobname Num\endcsname}
\def\AbExp{\csname\jobname Ab\endcsname}
\pagestyle{edpa}
\fi

\def\HTTPA{}  \def\HTTPB{}
% repris du paquet  hyperref (S. Rathz)
\edef\hyper@tilde{\string~}
\begingroup
  \catcode`\!\active
  \catcode`\&\active
  \catcode`\_\active
  \uccode`\!=`\%
  \uccode`\&=`\#%
\uppercase{\endgroup%
\def\hyper@normalise#1{%
\begingroup%
\catcode`\%\active\def!{\%}%
\catcode`\#\active\def&{\#}%
\catcode`\_\active\def_{\string_}%
\let~\hyper@tilde%
\let\~\hyper@tilde%
\hyper@n@rmalise#1}}
\def\hyper@n@rmalise#1#2{%
\edef\@tempa{\endgroup\noexpand#1{#2}}%
\@tempa}

\def\http{\hyper@normalise\httpp}
\def\hhttp{\hyper@normalise\httpa}
\def\httpp#1{\expandafter\http@a#1\\}
\def\httpa#1{\expandafter\http@a#1\\ \hhttpb}
\def\hhttpb{\hyper@normalise\httpb}
\def\httpb#1{\expandafter\http@b#1\\}
\def\http@a#1\\{\bgroup% 
\let\#\@hyperhash%
\let\%\@percentchar%
\gdef\HTTPA{#1}
\egroup}
\def\http@b#1\\{\bgroup% 
\let\#\@hyperhash%
\let\%\@percentchar%
\gdef\HTTPB{#1}
\egroup}

\def\KW{}
\def\keyword#1{\def\KW{{\em Keywords} : #1}}
\def\MSC{}
\def\msc#1{\if\EDPAan<2000\def\MSC{{\em MSC 1991} : #1}\else
\def\MSC{{\em MSC 2000} : #1}}
\def\THANKS{}
\def\thanks#1{\def\THANKS{#1}}
\def\ADRA{}   \def\ADRB{}
\def\address#1{\def\ADRA{#1}}
\def\aaddress#1#2{\def\ADRA{#1}\def\ADRB{#2}}
\def\MELA{} \def\MELB{}
\def\email#1{\def\MELA{#1}}  
\def\eemail#1#2{\def\MELA{#1}\def\MELB{#2}}

\ifx\pdfoutput\undefined
\def\mailto#1{\texttt{#1}}
\def\homepage#1{#1}
\else
\def\mailto#1{\color{Rouge}\href{mailto:#1}{\texttt{#1}}}
\def\homepage#1{\color{Rouge}\href{http://#1}{#1}}
\fi

% \AtBeginDocument{}

\AtEndDocument{
\medskip
\ifx\@empty\MELB
\noindent{\sc \ADRA}
\par\noindent\mailto{\MELA}%
\par\noindent\homepage{\HTTPA}
\else
\noindent{\sc \ADRA}
\par\noindent\mailto{\MELA}%
\par\noindent\homepage{\HTTPA}
\medskip\par
\noindent{\sc \ADRB}
\par\noindent\mailto{\MELB}%
\par\noindent\homepage{\HTTPB}
\fi
\Verif_Data
   }

\def\maketitle{
\EDPAGDR
  \begin{center}%
    {\LARGE \@title \par}%
    \vspace{1.5em}%
    {\large
      \lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
  \end{center}%
\ifedpaFr
\def\abstractname{R\'esum\'e}
\fi
\begin{quotation}
\small
\begin{center}
{\bf \abstractname}
\end{center}
\AbExp
\end{quotation}
  \ifx\@empty\THANKS\else\insert\footins{\smallskip\scriptsize\THANKS}\fi
  \ifx\@empty\MSC\else\insert\footins{\smallskip\scriptsize\MSC}\fi
  \ifx\@empty\KW\else\insert\footins{\smallskip\scriptsize\KW}\fi
\par\vspace{1.5em}}

\renewcommand\section{\ifEqSect\setcounter{equation}{0}\fi
\setcounter{subsection}{0}
\@startsection {section}{1}{0pt}  %{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
%                                   {2.3ex \@plus.2ex}%
                                   {0.1ex \@plus.2ex}%
                                   {\normalfont\large\bfseries}}
\def\@seccntformat#1{\csname the#1\endcsname.\kern0.5em}
\def\@xsect#1{%
  \@tempskipa #1\relax
  \ifdim \@tempskipa>\z@
    \par \nobreak
    \vskip \@tempskipa
%    \@afterheading     % Dcembre 1999
  \else
    \@nobreakfalse
    \global\@noskipsectrue
    \everypar{%
      \if@noskipsec
        \global\@noskipsecfalse
       {\setbox\z@\lastbox}%
        \clubpenalty\@M
        \begingroup \@svsechd \endgroup
        \unskip
        \@tempskipa #1\relax
        \hskip -\@tempskipa
      \else
        \clubpenalty \@clubpenalty
        \everypar{}%
      \fi}%
  \fi
  \ignorespaces}
\renewcommand \thesection {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\large\bfseries}}

\ifx\pdfoutput\undefined
\newcount\pdfoutput
\pdfoutput0
\newcommand{\href}[2]{{#2}}
\newcommand{\color}[1]{}
\else
\pdfoutput1
\RequirePackage[pdftex,backref,colorlinks=true,%
  pdfpagemode=None,baseurl={http://www.math.sciences.univ-nantes.fr/edpa/},%
  pdfauthor={EDPA GDR 1151/UMR 6629 (Nantes)},pdfcreator={PDFLaTeX+Hyperref},%
  pdfsubject={},pdftitle={},pdfstartview=FitBH]%
  {hyperref}
\RequirePackage{color}
\definecolor{Vert}{rgb}{0,0.3,0}
\definecolor{vert}{rgb}{0,0.5,0}
\definecolor{Rouge}{rgb}{0.9,0.2,0}
%  Rfrences inverses
% \RequirePackage[hyperpageref]{backref}
\def\@xbibitem#1#2\par{\oldb{#1}#2 \newblock%
\hfill [cf. p. {\csname br@#1\endcsname}]\par}
\fi


\def\Verif_Data{
\message{^^J^^J}
\ifx\@empty\HTTP
\message{Macro \string\h ttp pour la page d'accueil / for homepage ^^J}
\fi
\ifx\@empty\MSC
\message{Macro \string\m sc pour la classification mathematique / for MSC ^^J}
\fi
\ifx\@empty\KW
\message{Macro \string\k w pour les mots-cles / for keywords ^^J}
\fi
\message{^^J Voir/see www.math.sciences.univ-nantes.fr/edpa/edpa-cls.html^^J
pour la classe / for the class edpa.cls^^J^^J}
}
\endinput


%% End of file `edpa.cls'.

