%%%%%%%%%%%%%%%%%%%%%% start of cupconf.sty %%%%%%%%%%%%%%%%%%%%%% 
% CUPconf.sty -- CUP conference proceedings style file
% V0.1 released 20 September 1993, by Alison Woollatt
% Copyright (1993) Cambridge University Press

% This software may only be used in the preparation of journal articles
% or books or parts of books to be published by Cambridge University Press.
% Any other use constitutes an infringement of copyright.

%     based on JFM.STY v1.1
%     based on ARTICLE DOCUMENT STYLE
%     by Leslie Lamport
% for LaTeX version 2.09
%
% incorporating also parts of authordate.sty, by David Rhead, of
% the Cripps Computing Centre (February 1990).
%
\newif\ifoldfss
\newif\ifnfssone
\newif\ifnfsstwo
\def\f@s@s{}%
%

\@ifundefined{DeclareFontShape}%
  {%
   \@ifundefined{selectfont}%
    {\global\oldfsstrue\let\reset@font=\relax}% old font selection scheme
    {\global\nfssonetrue\def\f@s@s{with NFSS release 1,\space}}%
  }%
  {\global\nfsstwotrue\def\f@s@s{with NFSS release 2,\space}}%

%
\typeout{Document Style `Cambridge University Press}
\typeout{Conference Proceedings Style' \f@s@s V0.1 20 September 1993}
%
% Journals use two-sided printing.
%
\@twosidetrue
\@mparswitchtrue
\def\ds@draft{\overfullrule 5pt}
%
\@options

%  ****************************************
%  *               FONTS                  *
%  ****************************************
%
\lineskip 1pt
\normallineskip 1pt
\def\baselinestretch{1}
\def\@normalsize{\@setsize\normalsize{12pt}\xpt\@xpt% 10/12
 \abovedisplayskip 5pt plus 1pt minus 1pt
 \belowdisplayskip \abovedisplayskip
 \abovedisplayshortskip 3pt plus 1pt
 \belowdisplayshortskip  \abovedisplayshortskip}
\def\small{\@setsize\small{10pt}\ixpt\@ixpt% 9/10
 \abovedisplayskip 6pt plus 1pt minus 1pt
 \belowdisplayskip \abovedisplayskip
 \abovedisplayshortskip 3pt plus 1pt
 \belowdisplayshortskip  \abovedisplayshortskip % SFB 0.96
}
\def\footnotesize{\small}
\def\abstractsize{\@setsize\abstractsize{11pt}\ixpt\@ixpt}%        9/11
\def\participantsize{\@setsize\participantsize{12pt}\ixpt\@ixpt}% 9/12
\def\indexsize{\@setsize\indexsize{9pt}\viiipt\@viiipt}%         8/9
\def\scriptsize{\@setsize\scriptsize{8pt}\viipt\@viipt}%        7/8
\def\contribsize{\@setsize\contribsize{9pt}\viipt\@viipt}%     7/9
\def\tiny{\@setsize\tiny{6pt}\vpt\@vpt}%                      5/6
\def\large{\@setsize\large{13pt}\xipt\@xipt}%                11/13
\def\bitlarger{\@setsize\bitlarger{14pt}\xiipt\@xiipt}%     12/14
\def\Large{\@setsize\Large{18pt}\xivpt\@xivpt}%            14/18
\def\LARGE{\@setsize\LARGE{19pt}\xviipt\@xviipt}%         17/19
\def\huge{\@setsize\huge{25pt}\xxpt\@xxpt}%              20/25
\def\Huge{\@setsize\Huge{30pt}\xxvpt\@xxvpt}%           25/30

\let\fontswitch=\relax

\ifx\CUP@mtlplain@loaded\undefined
  \newfont{\qsmall}{cmr10 scaled 975} % 9.75pt rm, used in quotations
  \newfont{\qsmit}{cmti10 scaled 975} % 9.75pt italic
  \newfont{\qsbf}{cmbx10 scaled 975} %9.75 pt bold
  \newfont{\qssf}{cmss10 scaled 975}%9.75pt sans
  \newfont{\boldit}{cmbxti10} % bold italic, added by MAW
\else
  \newfont{\qsmall}{mtr10 scaled 975} % 9.75pt rm, used in quotations
  \newfont{\qsmit}{mtti10 scaled 975} % 9.75pt italic
  \newfont{\qsbf}{mtbx10 scaled 975} %9.75 pt bold
  \newfont{\qssf}{mtss10 scaled 975}%9.75pt sans
  \newfont{\boldit}{mtbxti10} % bold italic, added by MAW
\fi
%

%%%%%%%%%% NFSS release 2

\ifnfsstwo
\fi

% End NFSS release 2 code

%%%%%%%%%% NFSS release 1

\ifnfssone
  \ifx\CUP@mtlplain@loaded\undefined
  \fi
\fi

% End NFSS release 1 code


%%%%%%%%%% Old font selection scheme

\ifoldfss
\fi

% End old font selection scheme code

\def\qit{\qsmit \baselineskip 10.75pt}
\def\qbf{\qsbf \baselineskip 10.75pt}
\def\qsf{\qssf \baselineskip 10.75pt}
\def\qrm{\qsmall \baselineskip 10.75pt}
\normalsize

%  ****************************************
%  *            PAGE LAYOUT               *
%  ****************************************
%
% SIDE MARGINS:
\oddsidemargin  2pc
\evensidemargin 2pc
\marginparwidth 2.0cm
\marginparsep 10pt

% VERTICAL SPACING:
\topmargin 2.5pc
\headheight 12pt
\headsep 6pt % ajw (from 8pt)
\topskip 12pt
\footheight 9pt
\footskip 18pt
\newskip\halflineskip
\halflineskip=6pt plus .5pt minus .5pt
\newskip\affilskip % used by authors to separate affiliations on title page
\affilskip=5pt

% DIMENSION OF TEXT: % for trimmed size 247x174mm
\textheight = 49\baselineskip \advance\textheight by \topskip
\textwidth 32pc
\columnsep 10pt
\columnseprule 0pt

% FOOTNOTES:
\footnotesep 0.pt
\skip\footins 9pt plus 3pt

% FLOATS:
% \def\topfigrule{\vskip\floatsep\hbox{\rule{\textwidth}{.5pt}}\vskip-%
% \floatsep}
\floatsep 10pt plus 2pt minus 1pt
\textfloatsep=12pt plus 6pt
\intextsep\floatsep
\@maxsep 15pt
\dblfloatsep\floatsep
\dbltextfloatsep\floatsep
\@dblmaxsep 15pt
\@fptop 0pt plus 0fil
\@fpsep 10pt plus 0fil
\@fpbot 0pt plus 3fil
\@dblfptop 0pt plus 0fil
\@dblfpsep 10pt plus 0fil
\@dblfpbot 0pt plus 3fil
\marginparpush 5pt


%  ****************************************
%  *           PARAGRAPHING               *
%  ****************************************
%
\parskip \z@ plus .3pt
\parindent 1em
\partopsep 0pt plus 1pt
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\@beginparpenalty -\@lowpenalty
\@endparpenalty -\@lowpenalty
\@itempenalty -\@lowpenalty
\clubpenalty=0
\widowpenalty=10000


%  ****************************************
%  *                 PARTS                *
%  ****************************************
%
\def\part{\par \addvspace{4ex}\@afterindentfalse
 \secdef\@part\@spart}
\def\@part[#1]#2{\ifnum \c@secnumdepth >\m@ne
  \refstepcounter{part}
  \addcontentsline{toc}{part}{Part \thepart: #1}
 \else \addcontentsline{toc}{part}{#1}
 \fi
 {\parindent 0pt \centering %changed ggw
  \ifnum \c@secnumdepth >\m@ne
   \reset@font\large\rm PART
   \ifcase\thepart \or ONE \or TWO \or THREE \or FOUR \or FIVE
    \or SIX \or SEVEN \or EIGHT \or NINE \or TEN \else \fi
   \par \nobreak
  \fi
  \reset@font\LARGE\rm #2 \markboth{}{}\par }
 \nobreak \vskip 3ex \@afterheading}
\def\@spart#1{{\parindent 0pt \centering % changed ggw
  \reset@font\LARGE\rm #1\par}
 \nobreak \vskip 3ex \@afterheading}


%  ****************************************
%  *               SECTIONS               *
%  ****************************************
%

\def\@raggedright{\rightskip=\@flushglue \let\\=\@centercr \parindent=0pt}
\def\@raggedcenter{\centering\rightskip=\@flushglue \let\\=\@centercr}
\def\firstsection{\vspace{-\baselineskip}}

%
\def\section{\@startsection{section}{1}{\z@}
 {20pt plus 6pt minus 2pt}%    beforeskip; neg = suppress indent
 {3pt plus 0pt minus 0pt}%     afterskip
 {\reset@font\fontswitch\large\bf\@raggedright}}%     style
\def\subsection{\@startsection{subsection}{2}{\z@}
 {-9pt plus -3pt minus -3pt}
 {3pt plus 0pt minus 0pt}
 {\reset@font\normalsize\it\@raggedcenter}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}
 {9pt plus 3pt minus 3pt}
 {3pt plus 0pt minus 0pt}
 {\raggedright\reset@font\normalsize\it}}
\def\paragraph{}
\def\subparagraph{}
%
\def\emptys@t{}
\def\@sect#1#2#3#4#5#6[#7]#8{%
 \ifnum #2>\c@secnumdepth
  \def\@svsec{}%
 \else
  \refstepcounter{#1}
  \ifnum #2>1% upright rm for numbers in subsections -- jas
   \edef\@svsec{{\noexpand\reset@font\noexpand\rm\csname 
                 the#1\endcsname.}\hskip 0.5em} % ajw 
  \else
                 \def\apphe@d{#8}
   \edef\@svsec{\ifappendix Appendix \fi\csname the#1\endcsname\relax
                 \ifx \apphe@d\emptys@t 
                 \else 
                   .\hskip 0.5em
                 \fi
   }
  \fi
 \fi
 \@tempskipa #5\relax
 \ifdim \@tempskipa>\z@
  \begingroup #6\relax
   \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty \@M #8\par}
  \endgroup
  \csname #1mark\endcsname{#7}%
   \ifnum #2=1% sections only
   \addcontentsline{toc}{#1}
    {\ifnum #2>\c@secnumdepth \else
    \ifappendix Appendix~\csname the#1\endcsname%
    \else \protect\numberline{\csname the#1\endcsname.}#7\fi
    \fi}
  \else
   \addcontentsline{toc}{#1}
     {\ifnum #2>\c@secnumdepth \else
      \protect\numberline{\csname the#1\endcsname.}#7\fi}
  \fi
  \else %
  \def\@svsechd{#6\hskip #3\@svsec #8\csname #1mark\endcsname {#7}
    \addcontentsline{toc}{#1}
     {\ifnum #2>\c@secnumdepth \else
     \protect\numberline{\csname the#1\endcsname.}
    \fi#7}%
  }%
  \fi
 \@xsect{#5}}
\newif\ifappendix \appendixfalse
\def\appendix{\par
 \setcounter{section}{0}
 \def\theequation{\Alph{section}\,\arabic{equation}} % (MAW)
 \def\thesection{Appendix \Alph{section}}
 \def\thesection{\Alph{section}}
 \def\thesubsection{\thesection.\arabic{subsection}}
 \def\thesubsubsection{\thesubsection.\arabic{subsubsection}}
 \appendixtrue}

\setcounter{secnumdepth}{3} % number sections, subsections and subsubsections
                            % but not paragraphs or subparagraphs.

%  ****************************************
%  *       PART & SECTION NUMBERS       *
%  ****************************************
%
\newcounter{part}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
%\newcounter {subparagraph}[paragraph]
\def\thepart          {\arabic{part}}
\def\thesection       {\arabic{section}}
\def\thesubsection    {\thesection.\arabic{subsection}}
\def\thesubsubsection {\thesubsection.\arabic{subsubsection}}
\def\theparagraph     {\thesubsubsection.\arabic{paragraph}}
%\def\thesubparagraph  {\theparagraph.\arabic{subparagraph}}

%  ****************************************
%  *               SKIPS                  *
%  ****************************************
%
\newskip\@indentskip
\newskip\smallindent
\newskip\@footindent
\newskip\@leftskip
\@indentskip=2.5em
\smallindent=1em
\@footindent=\smallindent
\@leftskip=\z@


%  ****************************************
%  *                LISTS                 *
%  ****************************************
%
\leftmargini\z@
\labelsep\z@
\labelwidth\z@
%
% label macros for Range-Left and Range-Right labels
%\def\makeRLlabel#1{\rlap{#1}\hss}
%\def\makeRRlabel#1{\hss\llap{#1}}
\def\makeitemlabel#1{\hspace\labelwidth\hspace\labelsep\hfill #1}
%
% set leftmargin to labelwidth + labelsep of OUTER list:
\def\@listI{\parsep\z@ \topsep\z@ \partopsep\z@ \itemsep\z@ \rightmargin\z@
 \leftmargin\labelwidth \advance\leftmargin\labelsep}
\def\@listi{\@listI \leftmargin\leftmargini \itemindent 1em}
\def\@listii{\@listI \advance\leftmargin 1em}
\def\@listiii{\@listI}
\def\@listiv{\@listI}
\def\@listv{\@listI}
\def\@listvi{\@listI}
\@listi
%
% ITEMIZE
\def\itemize{\ifnum \@itemdepth >3 \@toodeep
 \else \advance\@itemdepth \@ne
  \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
  \list{\csname\@itemitem\endcsname}%
  {\labelsep .5em \settowidth{\labelwidth}{\csname\@itemitem\endcsname}
    \let\makelabel\makeitemlabel}%
 \fi}
\def\labelitemi{$\bullet$} % ggw
\def\labelitemii{$\circ$}
\def\labelitemiii{---} % ggw
\def\labelitemiv{--} % ggw
%
% ENUMERATE
\def\enumerate{\ifnum \@enumdepth >3 \@toodeep
 \else \advance\@enumdepth \@ne
 \edef\@enumctr{enum\romannumeral\the\@enumdepth}\fi
%\@ifnextchar [{\@enumeratetwo}{\@enumeratetwo[(a)]}}
 \@ifnextchar [{\@enumeratetwo}{\@enumeratetwo[i]}}
\def\@enumeratetwo[#1]{%
 \list{\csname label\@enumctr\endcsname}%
  {\settowidth\labelwidth{#1} \labelsep .5em
   \advance\itemindent\labelsep \advance\itemindent\labelwidth
   \usecounter{\@enumctr}}}
%
\def\labelenumi{{\reset@font\rm(}\theenumi{\reset@font\rm)}}
\def\theenumi{{\reset@font\it\alph{enumi}}}
\def\labelenumii{{\reset@font\rm(}{\theenumii}{\reset@font\rm)}}
\def\theenumii{{\reset@font\it\alph{enumii}}}
\def\p@enumii{\theenumi.\theenumii}
\def\labelenumiii{\theenumiii.}
\def\theenumiii{\roman{enumiii}}
\def\p@enumiii{\p@enumii.\theenumiii}
\def\labelenumiv{\theenumiv}
\def\theenumiv{\roman{enumiv}}
\def\p@enumiv{\p@enumiii.\theenumiv}
%
% DESCRIPTION
\def\descriptionlabel#1{\hspace\labelsep \reset@font\bf #1}
\def\description{\list{}{\labelwidth\z@%\itemindent-\leftmargin
  \ifnum\@listdepth=1\else\advance\leftmargin 1em\fi
  \let\makelabel\descriptionlabel}}
\let\enddescription\endlist


%  ****************************************
%  *            DISPLAYED TEXT            *
%  ****************************************
%
% VERSE
\def\verse{\let\\=\@centercr
 \list{}{\itemsep\z@
  \itemindent -\@indentskip
  \listparindent \itemindent
  \rightmargin\leftmargin
  \advance\leftmargin \@indentskip}\item[]}
\let\endverse\endlist
%
% QUOTATION
\def\quotation{\list{}{\listparindent\smallindent
  \itemindent\listparindent
  \leftmargin\z@\rightmargin\leftmargin
  \topsep\halflineskip
  \parsep 0pt plus 1pt}\item[]\qsmall\baselineskip 10.75pt}
\let\endquotation=\endlist
% QUOTE
\def\quote{\par\list{}{\leftmargin\z@\rightmargin\leftmargin}\item[]%
 \qsmall\baselineskip 10.75pt\rule{0pt}{10pt}\ignorespaces}
\let\endquote=\endlist


%  ****************************************
%  *         OTHER ENVIRONMENTS           *
%  ****************************************
%
% THEOREM
% The following modifies two internal routines called by Latex's
% \newtheorem command, which JFM.sty users are encouraged to use
% for their own purposes, such as creating Lemma 1.2,
% Definition 2.3, etc.
%
%\def\theoremlabel#1{\hspace\labelsep \reset@font\sc #1}
%\def\@begintheorem#1#2{\list{}{\topsep\halflineskip \labelsep .5em
% \let\makelabel\theoremlabel}\item[#1\ #2.]\reset@font\it }
%\def\@opargbegintheorem#1#2#3{\list{}{\topsep\halflineskip \labelsep .5em
% \let\makelabel\theoremlabel}\item[#1\ #2\ (#3).]\reset@font\it }
%\def\@endtheorem{\endlist}
%
\def\@begintheorem#1#2{\par\vskip\halflineskip{\reset@font\sc #1\ #2.}\hskip.5em\reset@font\it}
\def\@opargbegintheorem#1#2#3{\par\vskip\halflineskip
 {\reset@font\sc #1\ #2\ (#3).}\hskip.5em\reset@font\it}
\def\@endtheorem{\vskip\halflineskip\par}
%
% A line added to make the guide for authors true (MAW):
\newtheorem{theorem}{Theorem}[section]
%
% PROOF
\newsavebox{\proofbox}
\sbox{\proofbox}{\unitlength 1pt\begin{picture}(7,7)%
  \put(0,0){\framebox(7,7){}}\end{picture}}
%\def\proof{\list{}{\topsep\halflineskip \labelwidth\z@ \labelsep .5em
% \let\makelabel\makeitemlabel} \item[{\reset@font\it Proof.}]}
%\def\endproof{\hspace*{\fill}\usebox{\proofbox}\endlist}
\def\proof{\par\vskip\halflineskip {\reset@font\it Proof.}\hskip.5em\relax}
\def\endproof{\hspace*{\fill}\usebox{\proofbox}\vskip\halflineskip\par}
\@namedef{proof*}{\proof}
\@namedef{endproof*}{\vskip\halflineskip\par}
%
% REMARK works like \newtheorem but without the ability to number,and
% produces displayed paragraph in same style as proof.
\def\newremark#1#2{\newenvironment{#1}{\list{}{\topsep\halflineskip \labelwidth\z@
 \labelsep .5em \let\makelabel\makeitemlabel} \item[{\reset@font\it #2.}]}{\endlist}}
%
% EQUATION and EQNARRAY
%
\def\theequation{\thesection.\arabic{equation}}

% subeqn.sty follows
% Copyright (c) 1990 by Stephen Gildea
% Permission to copy all or part of this work is granted, provided
% that the copies are not made or distributed for resale, and that
% the copyright notice and this notice are retained.

\newtoks\@stequation

\ifoldfss% 
  \def\f@ce{\it}% if OFSS, you can have italic character
  \else
    \ifnfssone%
      \def\f@ce{}% if NFSS1, you can't (yet...)
    \else
      \ifnfsstwo%
        \def\f@ce{}% if NFSS2, you can't (yet...)
      \fi
    \fi
\fi

\def\subequations{\refstepcounter{equation}%
  \edef\@savedequation{\the\c@equation}%
  \@stequation=\expandafter{\theequation}%   %only want \theequation
  \edef\@savedtheequation{\the\@stequation}% % expanded once
  \edef\oldtheequation{\theequation}%
  \setcounter{equation}{0}%
  \def\theequation{\oldtheequation{\f@ce\alph{equation}}}}

\def\endsubequations{\setcounter{equation}{\@savedequation}%
  \@stequation=\expandafter{\@savedtheequation}%
  \edef\theequation{\the\@stequation}\global\@ignoretrue}

% subeqnarray.sty
% Copyright (C) 1988 by Johannes Braams, Dr Neher Laboratories

\newcounter{subequation}[equation]
\def\thesubequation{\theequation{\f@ce\@alph\c@subequation}}

%  \@subeqnnum: Produces the equation number for the
%     subeqnarray environment.  The following definition is for
%     flushright numbers; for flushleft numbers, see leqno.doc.
%     The {\reset@font\rm ... } puts the subequation number in 
%     roman type even if an subeqnarray environment appears in 
%     an italic environment.
%
\def\@subeqnnum{{\reset@font\rm (\thesubequation)}} 
%
%    A new label command to refer to subequations. It works
%    like the \label command and was taken from LaTeX.TeX
%
%  \slabel{FOO} then writes the following on file \@auxout :
%        \newlabel{FOO}{{eval(\@currentlabel)}{eval(\thepage)}}
%
\def\slabel#1{\@bsphack\if@filesw {\let\thepage\relax
   \xdef\@gtempa{\write\@auxout{\string
      \newlabel{#1}{{\thesubequation}{\thepage}}}}}\@gtempa
   \if@nobreak \ifvmode\nobreak\fi\fi\fi\@esphack}
%
%    Here's the subeqnarray environment,
%        it steps the equation counter,
%        sets the subequation counter equal to 1
%        and behaves much like the eqnarray environment.
%
% changed to remove space either side of alignment
\def\subeqnarray{\stepcounter{equation}
\let\@currentlabel=\theequation\global\c@subequation\@ne
\global\@eqnswtrue
\global\@eqcnt\z@\tabskip\@centering\let\\=\@subeqncr
$$\halign to \displaywidth\bgroup\@eqnsel\hskip\@centering
  $\displaystyle\tabskip\z@{##}$&\global\@eqcnt\@ne
%  \hskip 2\arraycolsep \hfil${##}$\hfil
   \hfil${\;##\;}$\hfil
%  &\global\@eqcnt\tw@ \hskip 2\arraycolsep $\displaystyle\tabskip\z@{##}$\hfil
  &\global\@eqcnt\tw@ $\displaystyle\tabskip\z@{##}$\hfil % ajw
  \tabskip\@centering&\llap{##}\tabskip\z@\cr}

\def\endsubeqnarray{\@@subeqncr\egroup
                     $$\global\@ignoretrue}

\def\@subeqncr{{\ifnum0=`}\fi\@ifstar{\global\@eqpen\@M
    \@ysubeqncr}{\global\@eqpen\interdisplaylinepenalty \@ysubeqncr}}

\def\@ysubeqncr{\@ifnextchar [{\@xsubeqncr}{\@xsubeqncr[\z@]}}

\def\@xsubeqncr[#1]{\ifnum0=`{\fi}\@@subeqncr
   \noalign{\penalty\@eqpen\vskip\jot\vskip #1\relax}}

\def\@@subeqncr{\let\@tempa\relax
    \ifcase\@eqcnt \def\@tempa{& & &}\or \def\@tempa{& &}
      \else \def\@tempa{&}\fi
     \@tempa \if@eqnsw\@subeqnnum\refstepcounter{subequation}\fi
     \global\@eqnswtrue\global\@eqcnt\z@\cr}

% Here's the subeqnarray* environment:

\let\@ssubeqncr=\@subeqncr
\@namedef{subeqnarray*}{\def\@subeqncr{\nonumber\@ssubeqncr}\subeqnarray}
\@namedef{endsubeqnarray*}{\global\advance\c@equation\m@ne%
                           \nonumber\endsubeqnarray}

% \jot = 3pt      % Extra space added between lines of an eqnarray  
%                   environment
% The macro \@eqnnum defines how equation numbers are to appear in equations.
% \def\@eqnnum{(\theequation)}  % (the default in LaTeX)
%
% The following substitution causes \eqnarray to give same spacing
% around =,>,<, etc. as in one-line equation.
\def\eqnarray{\stepcounter{equation}\let\@currentlabel=\theequation
\global\@eqnswtrue
\global\@eqcnt\z@\tabskip\@centering\let\\=\@eqncr
$$\halign to \displaywidth\bgroup\@eqnsel\hskip\@centering
  $\displaystyle\tabskip\z@{##}$&\global\@eqcnt\@ne
% \hskip 2\arraycolsep \hfil${##}$\hfil
  \hfil${\;##\;}$\hfil
% &\global\@eqcnt\tw@ \hskip 2\arraycolsep $\displaystyle\tabskip\z@{##}$\hfil 
  &\global\@eqcnt\tw@ $\displaystyle\tabskip\z@{##}$\hfil 
   \tabskip\@centering&\llap{##}\tabskip\z@\cr}
%
% TITLEPAGE
%\def\titlepage{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
%  \else \newpage \fi \thispagestyle{empty}}% \c@page\z@} % ajw
\def\titlepage{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
  \else\fi \thispagestyle{empty}}% \c@page\z@} % ajw
\def\endtitlepage{\if@restonecol\twocolumn \else \newpage \fi}
\arraycolsep 5pt
\tabcolsep 3pt % this is half the space between cols. in a tabular env. ggw
\arrayrulewidth .5pt
\doublerulesep 1.5pt
\tabbingsep \labelsep
%\skip\@mpfootins = \skip\footins
\skip\@mpfootins = 5pt plus .4pt minus .4pt
\fboxsep = 3pt
\fboxrule = .5pt


%  ****************************************
%  *         TITLE AND ABSTRACT           *
%  ****************************************
%
\def\halftitle#1{\gdef\@halftitle{#1}}
\gdef\@halftitle{\@title}

\gdef\@title{}

\def\where#1{\gdef\@where{#1}}
\gdef\@where{}

\def\author@tabular{%
  \def\@halignto{}\@authortable}
\let\endauthor@tabular=\endtabular
\def\@authortable{%
  \leavevmode \hbox \bgroup $\let\@acol=\@tabacol
    \let\@classz=\@tabclassz \let\@classiv=\@tabclassiv
    \let\\=\author@tabcrone
    \ignorespaces \@tabarray}
\def\author@tabcrone{%
  {\ifnum0=`}\fi\@xtabularcr\indexsize\it
  \let\\=\author@tabcrtwo
  \ignorespaces}
\def\author@tabcrtwo{%
  {\ifnum0=`}\fi\@xtabularcr[-3pt]\indexsize\it
  \let\\=\author@tabcrtwo
  \ignorespaces}
\def\also{%
  \end{author@tabular}\vskip 10pt\par
  \begin{author@tabular}[t]{c}}

\def\affiliation#1{\gdef\@affiliation{#1}}
\gdef\@affiliation{}

\def\maketitle{\appendixfalse\@ifnextchar [{\m@ketitleone}{\m@ketitletwo}}%
\def\m@ketitletwo{\m@ketitleone[n]}
\def\m@ketitleone[#1]{
 \par
 \begingroup
%% \def\thefootnote{\fnsymbol{footnote}}
%% \def\@makefnmark{\hbox to 0pt{${\@thefnmark}$\hss}}
%%%   % fnmark now on line -- ggw
\bgroup
  \def\@makefntext##1{\begin{center} \hskip .5em
  \@thefnmark \ ##1\end{center}}
  % footnotes on the title page are centered.
  \newpage \global\@topnum\z@
  \@maketitle{#1}\thispagestyle{titlepage} \@thanks
\egroup
 \endgroup
 \setcounter{footnote}{0}
 \let\maketitle\relax \let\@maketitle\relax \gdef\@affiliation{}
 \gdef\@thanks{}\gdef\@author{}\gdef\@title{}\let\thanks\relax}
 \def\and{{\reset@font\small\bf AND}}%\normalsize

\def\@maketitle#1{
 \newpage
% \vspace*{10pt}
 {\centering \sloppy
  {\reset@font\LARGE\bf \@title \par}
  \vskip 10pt plus 2pt minus 1pt
  {\reset@font\large\bf\baselineskip=12pt By \uppercase{\@author} \par}
  \vskip 8pt plus 1pt
  {\reset@font\small \@affiliation \par}
%  \vskip 8pt plus 2pt minus 1pt
%  {\reset@font\small (Received \@date)}
 \par}
 \vskip 13pt plus 2pt 
}

\def\abstract{\par\reset@font\abstractsize\noindent\ignorespaces}
\def\endabstract{\par\vskip 9pt plus 1pt minus 1pt
 \vbox{\centerline{\rule[4pt]{30pc}{.25pt}}}}

\def\makebooktitle{%
   \begin{titlepage}
   \setcounter{page}{3}
       \begin{center}
       \vspace*{0.9\baselineskip}
       \bitlarger\bf \@halftitle \par
       \vfill
     \end{center}
     \end{titlepage}\addtocounter{page}{1}
     \begin{titlepage}
       \begin{center}
       \vspace*{0.2\baselineskip}
       \huge\bf \@title \par
       \vspace{34pt}
       {\bitlarger \@where \par}
       \vspace{24pt}
       {\large\it Edited by} \\
       {\bitlarger
       \begin{author@tabular}[t]{c}
       \@author
       \end{author@tabular}\par}
       \vfill
       \end{center}
   \end{titlepage}
   \setcounter{footnote}{0} % Reset definitions
 \let\thanks\relax
 \gdef\@thanks{}
 \gdef\@author{}
 \gdef\@shortauthor{}
 \gdef\@title{}
 \let\makebooktitle\relax
} 


%  ****************************************
%  *            PAGE STYLES               *
%  ****************************************
%
\mark{{}{}}

%\def\author@tabular{\def\@halignto{}\@authortable}
%\let\endauthor@tabular\endtabular
%\def\author@tabularcr{{\ifnum0=`}\fi
%   \@xtabularcr[-3pt]\footnotesize\it\ignorespaces}
%\def\@authortable{\leavevmode \hbox \bgroup $\let\@acol\@tabacol
%   \let\@classz\@tabclassz
%   \let\@classiv\@tabclassiv
%   \let\\\author@tabularcr
%   \@tabarray}

\gdef\@author{\mbox{}} % SFB 0.96
\def\author{\@ifnextchar [{\@authortwo}{\@authorone}}
%%% make \and a simple 'and' for \@shortauthor
\def\@authortwo[#1]#2{\gdef\@author{#2}\gdef\@shortauthor{#1}}
\def\@authorone#1{\gdef\@author{#1}
 \begingroup\def\and{and}\gdef\@shortauthor{#1}\endgroup}
\def\shortauthor#1{\gdef\@shortauthor{#1}}
\gdef\@shortauthor{}
\gdef\@title{\mbox{}} % SFB 0.96
\def\title{\@ifnextchar [{\@titletwo}{\@titleone}}
\def\@titletwo[#1]#2{\gdef\@title{#2}\gdef\@shorttitle{#1}}
\def\@titleone#1{\gdef\@title{#1}\gdef\@shorttitle{#1}}
\def\shorttitle#1{\gdef\@shorttitle{#1}}
\gdef\@shorttitle{}
%% SFB 0.96
%\def\volume#1{\gdef\@volume{#1}}
%\gdef\@volume{11}
%\def\pagerange#1{\gdef\@pagerange{#1}}
%\gdef\@pagerange{1--000}

%\edef\@pubyear{\number\year}
%\def\pubyear#1{\def\@pubyear{#1}}

%\def\journal#1{\gdef\@journal{#1}}
%\gdef\@journal{%
%      \vbox to 6pt{\noindent%
%      \parbox[t]{3in}{\reset@font\indexsize{\it J.\ Fluid\ Mech.}
%      (\@pubyear), {\it vol.} \@volume, {\it pp.} \@pagerange\\[2.5pt] %ajw
%      {Copyright \copyright\ \@pubyear\ Cambridge University Press}%
%    }}} %RM
%
% \ps@empty and \ps@plain defined in LATEX.TEX
%
\def\ps@headings{\let\@mkboth\markboth
 \def\@oddhead{\phantom{\rm\thepage}%
   \hfil{{\rm\@shortauthor :}~{\it\@shorttitle}}\hfil\rm\thepage}
     % altered ggw
 \def\@oddfoot{}
 \def\@evenhead{\rm\thepage%
   \hfil{{\rm\@shortauthor :}~{\it\@shorttitle}}\hfil\phantom{\rm\thepage}}
     % altered ggw
 \def\@evenfoot{}
 \def\sectionmark##1{\markboth{##1}{}}
 \def\subsectionmark##1{\markright{##1}}}
\def\ps@myheadings{\let\@mkboth\@gobbletwo
 \def\@oddhead{\phantom{\rm\thepage}%
   \hfil\rightmark\hfil\rm\thepage}
 \def\@oddfoot{}
 \def\@evenhead{\rm\thepage%
   \hfil\leftmark\hfil\phantom{\rm\thepage}}
 \def\@evenfoot{}
 \def\sectionmark##1{}
 \def\subsectionmark##1{}}
\def\ps@titlepage{\let\@mkboth\@gobbletwo\vfuzz=5pt%
 \def\@oddhead{}
 \def\@oddfoot{\mbox{}\hfil{\thepage}\hfil\mbox{}}
 \def\@evenhead{}
 \def\@evenfoot{\mbox{}\hfil{\thepage}\hfil\mbox{}}
 \def\sectionmark##1{}
 \def\subsectionmark##1{}}


%  ****************************************
%  *         TABLE OF CONTENTS, ETC.      *
%  ****************************************
%
%\def\@pnumwidth{1.55em}
%\def\@tocrmarg {2.55em}
\def\@pnumwidth{2em}
\def\@tocrmarg {2em}
\def\@dotsep{4.5}
\setcounter{tocdepth}{4}

\def\mh#1{{\clearpage\centering\bitlarger\bf #1\par\vspace*{0pt}% 
\noindent}}

\def\contentspage{%
  \thispagestyle{titlepage}
    \mh{Contents}
    \def\parthead{%
    \vspace{\baselineskip}%
    \contentsline{section}%
  }
  \def\titl{%
    \vspace{0.5\baselineskip}%
    \contentsline{subsection}%
  }
  \def\auth{\it\contentsline{subsubsection}}
  \def\para{\it\contentsline{paragraph}}
}
\def\endcontentspage{}

\def\participants{%
  \thispagestyle{titlepage}
  \mh{Participants}
  \def\auth{\hspace*{1em}\makebox[12pc][l]}
  \def\affl{}\participantsize
}
\def\endparticipants{}

%\@undottedtocline{LEVEL}{INDENT}{NUMWIDTH}{TITLE}{PAGE}
\def\@undottedtocline#1#2#3#4#5{\ifnum #1>\c@tocdepth
 \else
  \vskip \z@ plus .2pt
  {\hangindent #2\relax
   \rightskip \@tocrmarg \parfillskip -\rightskip
   \parindent #2\relax \@afterindenttrue
   \interlinepenalty\@M \leavevmode
   \@tempdima #3\relax {\reset@font\rm #4}\nobreak \hfill \nobreak
   \hbox to\@pnumwidth{\hfil\reset@font\rm #5}\par}\fi} 
     % page number added -- ggw
\def\tableofcontents{\@restonecolfalse
  \if@twocolumn\@restonecoltrue\onecolumn\fi
  \title{Contents\@mkboth{Contents}{Contents}}
  \@starttoc{toc}\if@restonecol\twocolumn\fi}
%\def\tableofcontents{\@restonecolfalse
% \if@twocolumn\@restonecoltrue\onecolumn\fi
% \vskip 4pt plus .5pt
% \centerline{\reset@font\sc CONTENTS}
% \vskip 3pt
% \@starttoc{toc}
% \if@restonecol\twocolumn\fi \par\vspace{12pt}}
%
\def\l@section#1{\addpenalty{\@secpenalty}
 \@tempdima 2em
 \begingroup
  \parindent \z@ \rightskip \@pnumwidth
  \parfillskip -\@pnumwidth \reset@font\rm \leavevmode
  \advance\leftskip\@tempdima \hskip -\leftskip 
    {\reset@font\bitlarger\bf #1}\nobreak\hfil
  \nobreak\hbox to\@pnumwidth{\hss \mbox{}}\par %page number added -- ggw
 \endgroup}
\def\l@subsection#1{\addpenalty{\@secpenalty}
 \@tempdima 2em
 \begingroup
  \parindent \z@ \rightskip \@pnumwidth
  \parfillskip -\@pnumwidth \reset@font\rm \leavevmode
  \advance\leftskip\@tempdima \hskip -\leftskip 
    {#1}\nobreak\hfil
  \nobreak\hbox to\@pnumwidth{\hss \mbox{}}\par %page number added -- ggw
 \endgroup}
\def\l@subsubsection{\@dottedtocline{3}{2em}{\z@}}
\def\l@paragraph{\@undottedtocline{4}{\z@}{\z@}}
% \def\l@subparagraph{\@undottedtocline{5}{10em}{5em}}
% \def\listoffigures{\@restonecolfalse
%  \if@twocolumn\@restonecoltrue\onecolumn\fi
%  \section*{List of Figures}% altered -- ggw
%  \@starttoc{lof} \if@restonecol\twocolumn\fi}
% \def\l@figure{\@undottedtocline{1}{1.5em}{2.3em}}
% \def\listoftables{\@restonecolfalse
%  \if@twocolumn\@restonecoltrue\onecolumn\fi
%  \section*{List of Tables}% altered -- ggw
%  \@starttoc{lot} \if@restonecol\twocolumn\fi}
% \let\l@table\l@figure


%  ****************************************
%  *              THE INDEX               *
%  ****************************************
%
\newif\if@restonecol
\def\theindex{\section*{Index} % changed to U & lc -- ggw
 \addcontentsline{toc}{section}{Index}
 \reset@font\footnotesize \parindent\z@ \parskip\z@ plus .1pt\relax
 \let\item\@idxitem}
\def\@idxitem{\par\hangindent 1em}
\def\subitem {\par\hangindent 1em \hspace*{1em}}
\def\subsubitem{\par\hangindent 1em\hspace*{1em}}
\def\endtheindex{\if@restonecol\onecolumn\else\clearpage\fi}
\def\indexspace{\par\vskip\baselineskip \relax}


%  ****************************************
%  *             FOOTNOTES                *
%  ****************************************
%
%\def\footnoterule{}
\def\footnoterule{\setcounter{footnote}{0}}% To force numbering to start
%              at 1 on each page.  Works because numbers are
%              assigned at occurrence of the \footnote{} command; this
%              resets counter after they are printed.  This might not work
%              if next footnote falls close enough to page break to have
%              already been 'digested'. --JAS
%\def\@makefntext#1{\hskip1em\@thefnmark\hskip.5em#1}
\def\@makempfntext#1{\hskip1em\@thefnmark\hskip.5em #1}
\def\@makefntext#1{\setbox\@tempboxa\hbox{\hskip1em\@thefnmark\hskip.5em #1}
 \ifdim\wd\@tempboxa>\hsize \unhbox\@tempboxa\else
 \centerline{\unhbox\@tempboxa}\fi}
\long\def\@mpfootnotetext#1{\global\setbox\@mpfootins
    \vbox{\unvbox\@mpfootins \reset@font\footnotesize
    \hsize\columnwidth \@parboxrestore
%  \edef\@currentlabel{\csname p@mpfootnote\endcsname\@thefnmark}\@makefntext
   \edef\@currentlabel{\csname p@mpfootnote\endcsname\@thefnmark}\@makempfntext
     {\rule{\z@}{\footnotesep}\ignorespaces #1\strut}}}
\def\@fnsymbol#1{\ifcase#1\or \dag\or \ddag\or \P\or \|\or
 \dag\dag\or \ddag\ddag\or \P\P\or \|\| \else\@ctrerr\fi\relax}
%   \@makefnmark : A macro to generate the footnote marker from \@thefnmark
%         The default is \hbox{$^\@thefnmark$}, i.e., raised.
\def\@makefnmark{\hbox{\@thefnmark}}% used in text
\def\thempfootnote{\hbox{$^{\fnsymbol{mpfootnote}}$}}


%  ****************************************
%  *         FIGURES AND TABLES           *
%  ****************************************
%
\setcounter{topnumber}{3}
\def\topfraction{.9}
\setcounter{bottomnumber}{0}
\def\bottomfraction{.9}
\setcounter{totalnumber}{3}
\def\textfraction{.1}
\def\floatpagefraction{.9}
\setcounter{dbltopnumber}{3}
\def\dbltopfraction{.9}
\def\dblfloatpagefraction{.5}
%
\long\def\@makecaption#1#2{\vskip 5pt plus .4pt minus .4pt\begingroup\small
  \setbox\@tempboxa\hbox{{\reset@font\sc #1.} #2}
  \ifdim \wd\@tempboxa >2\hsize \unhbox\@tempboxa\par \else
  {\centering \unhbox\@tempboxa\par} \fi \endgroup}
%
\newcounter{table}
\def\thetable{\@arabic\c@table}
\def\fps@table{tp}
\def\ftype@table{1}
\def\ext@table{lot}
\def\fnum@table{Table~\thetable}
%\def\table{\@float{table}\rule{\textwidth}{.5pt}  
%\vskip\floatsep} 

\newif\iffollowon
\def\table{\@float{table}\fstyle@table%
  \iffollowon
  \else
    \vspace*{9.5pt}% replace the space swallowed by TeX
  \fi
  \global\followonfalse
  \rule{\textwidth}{.25pt}\vskip\floatsep\relax % ajw, width of rule
}

\def\followon{\global\followontrue}

\def\plaintable{\@float{table}}
%\let\endtable\end@float

\newif\ifrmrule
\def\endtable{% ajw
  \ifrmrule
    \global\rmrulefalse
  \else 
    \rule{\textwidth}{.25pt}% ajw, width of rule
  \fi
  \end@float
} 

\def\norule{\global\rmruletrue}

\@namedef{table*}{\@dblfloat{table}}
\@namedef{endtable*}{\end@dblfloat}
\def\fstyle@table{\reset@font\small\rm}
\def\fjust@table{\centering}%changed ggw
\def\fcapjust@table{\centering} % ajw
\def\fcapsize@table{\reset@font\small\sc}
\def\fcapstyle@table{\reset@font\small\rm}
%
\newcounter{figure}
\def\thefigure{\@arabic\c@figure}
\def\fps@figure{tp}
\def\ftype@figure{2}
\def\ext@figure{lof}
\def\fnum@figure{Figure~\thefigure}
\def\figure{\@float{figure}}
\let\endfigure\end@float
\@namedef{figure*}{\@dblfloat{figure}}
\@namedef{endfigure*}{\end@dblfloat}
\def\fstyle@figure{\reset@font\small\rm}
\def\fjust@figure{\centering}
\def\fcapjust@figure{\centering} % ajw 
\def\fcapsize@figure{\reset@font\small\sc}
\def\fcapstyle@figure{\reset@font\small\rm}
\newif\ifwide@float
\wide@floatfalse
%
%\@caption{TYPE}[STEXT]{TEXT}
\def\@dblfloat{\wide@floattrue\@float}
\def\end@dblfloat{\if@twocolumn\egroup
 \ifnum\@floatpenalty <\z@ \@cons\@dbldeferlist\@currbox\fi
 \ifnum \@floatpenalty =-\@Mii \@esphack\fi\else\end@float\fi
 \wide@floatfalse}

%this is to preserve the old tabular environment in case it is needed
\let \oldtabular \tabular
\let \endoldtabular \endtabular

\def\tabular{\def\@halignto{to \textwidth}\tabskip=\tabcolsep plus 1fil\@tabular}
% This fixes tabular things so that they are full out l and r; 
% the \tabskip setting is to put tabskip before the first column.
% The following is to adjust the intercolumn spacing to put in
% enough stretch. ggw
\def\@tabarray{\@ifnextchar[{\@tarray}{\@ttarray}}
\def\@tarray[#1]#2{\t@barray[#1]{@{\tabskip=2\tabcolsep plus 3pt}
                                #2}}
\def\@ttarray#1{\t@barray[c]{@{\tabskip=2\tabcolsep plus 3pt}
                                #1 }}
\def\t@barray[#1]#2{\setbox\@arstrutbox=\hbox{\vrule
     height\arraystretch \ht\strutbox
     depth\arraystretch \dp\strutbox
     width\z@}\@mkpream{#2}\edef\@preamble{\halign \noexpand\@halignto
\bgroup \tabskip\z@ \@arstrut \@preamble \tabskip=\tabcolsep plus 1fil \cr}%
\let\@startpbox\@@startpbox \let\@endpbox\@@endpbox
  \if #1t\vtop \else \if#1b\vbox \else \vcenter \fi\fi
  \bgroup \let\par\relax
  \let\@sharp##\let\protect\relax \lineskip\z@\baselineskip\z@\@preamble}


%  ****************************************
%  *           CUP specials               *
%  ****************************************
%
\def\ls{\kern.15em} % for letterspacing; .15em is a hair less than thinspace
\def\ns{\kern.5em} % for name-spacing
\renewcommand{\thefootnote}{\mbox{$\fnsymbol{footnote}$}}
\def\hline{\noalign{\ifnum0=`}\fi \vskip 6pt
 \hrule \@height \arrayrulewidth \vskip 6pt
 \futurelet \@tempa\@xhline}
\def\@xhline{\ifx\@tempa\hline \vskip -12pt
 \vskip \doublerulesep \fi \ifnum0=`{\fi}}
\newenvironment{acknowledgments}{\par\vskip 10pt plus 1pt minus 1pt}{\par}


%  ****************************************
%  *            MISCELLANEOUS             *
%  ****************************************
%
\def\magnification{\afterassignment\m@g\count@}
\def\m@g{\mag\count@
  \hsize6.5truein\vsize8.9truein\dimen\footins8truein}

\def\today{\number\day\ \ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December
 \fi \ \number\year}

\def\goverso{% start a verso page
  \ifodd\c@page\hbox{}\newpage
    \else
  \fi
}

%  ****************************************
%  *           BIBLIOGRAPHY               *
%  ****************************************
% the immediately following code is taken from MSCS.sty, somewhat modified.
% \def\@biblabel#1{#1}
\def\@biblabel#1{} % remove label from bibliography listing
\def\thebibliography#1{%
\def\bibls{\kern.065em}% for letterspacing; normally .15em
\par\vskip 20pt plus 1pt minus 1pt
 \centerline{\reset@font\small\sc R\bibls E\bibls F\bibls E\bibls R\bibls E\bibls N\bibls C\bibls E\bibls S}
 \nobreak
 \vskip 4pt plus .5pt minus .5pt
 \nobreak
%\addcontentsline{toc}{section}{References} % removed for JFM -- jas
 \list{}{\labelwidth\z@ \leftmargin 2em \itemindent -2em \itemsep 3pt}
 \reset@font\small \parindent\z@
 \parskip\z@ plus .1pt\relax
 \def\newblock{\hskip .11em plus .33em minus .07em}
 \sloppy\clubpenalty4000\widowpenalty4000
 \sfcode`\.=1000\relax}
\let\endthebibliography=\endlist

% remove square brackets around citations

\def\@cite#1#2{{#1\if@tempswa , #2\fi}}

%  ****************************************
%  *           INITIALIZATION             *
%  ****************************************
%
\ps@headings
\pagenumbering{arabic}
\onecolumn \let\onecolumn=\relax
\def\twocolumn{\typeout{Two column mode not available with cupproc style}}
\flushbottom
%%%%%%%%%%%%%%%%%%%%%% end of cupconf.sty %%%%%%%%%%%%%%%%%%%%%% 
