%% This is file `newbaki.cls' 
\ProvidesClass{newbaki}
     [2001/01/08 v2.0
     Classe LaTeX pour les seminaires Bourbaki]
\def\filename{bourbaki.cls}
\def\fileversion{2.0}       \def\filedate{2001-01-08}
%%% end of file header
\immediate\write16{%
LaTeX document class `BOURBAKI' (\fileversion, \filedate)}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{smfart}}

\DeclareOption{twocolumn}{\typeout{Desole --- 
      une seule colonne dans le style BOURBAKI.}}
\DeclareOption{openbib}{\typeout{Desole ---
      pas d'option openbib dans le style BOURBAKI.}}
\DeclareOption{fleqn}{\typeout{Desole --- 
      pas d'equations a gauche dans le style BOURBAKI.}}
\DeclareOption{titlepage}{\typeout{Desole ---
      pas d'option titlepage dans le style BOURBAKI.}}
\def\@bbklanguage{2}
\DeclareOption{francais}%
  {\typeout{Style BOURBAKI -- version francaise}\def\@bbklanguage{1}%
   \PassOptionsToClass{francais}{smfart}}
\DeclareOption{english}%
  {\typeout{Style BOURBAKI -- english version}\def\@bbklanguage{0}%
   \PassOptionsToClass{english}{smfart}}

\newif\if@bbkswapnumbers
\DeclareOption{swapnumbers}
  {\typeout{Style BOURBAKI -- numros avant les intituls}%
   \@bbkswapnumberstrue}

\ExecuteOptions{10pt,a4paper,twoside}
\ProcessOptions\relax
\LoadClass{smfart}


\def\subtitle#1{\def\@subtitle{\ignorespaces#1\unskip}}
\def\@subtitle{}

\def\@bbknumero{}
\def\@bbkannee{}
\def\bbknumero#1{\gdef\@bbknumero{#1}}
\def\bbkannee#1{\gdef\@bbkannee{#1}}
\def\@maketitle{%
  \cleardoublepage\thispagestyle{copyright}
  \parindent=0pt \normalfont\normalsize
  \let\@makefnmark\relax  \let\@thefnmark\relax
%% REMERCIEMENTS
  \ifx\@empty\@thanks\else\@footnotetext{\@thanks}\fi
  \topskip0\p@ %% on commence tout en haut.
%% L'ENTETE
  \vtop to 55 true mm{%
    \hbox to\textwidth{S\'eminaire Bourbaki\hfil \@date}
    \hbox to\textwidth{\@bbkannee, n\raise4pt\hbox{\small o} \@bbknumero\hss}
    \vfil
    {\centering\bf
     {\uppercasenonmath\@title \@title\@@par}
     {\ifx\@empty\@subtitle\else\@subtitle\@@par\fi}
     \bigskip
     {\normalfont \@byname\ }\authors\@@par}
    \vfil
    \ifx\@empty\@dedicatory\else{\raggedleft\it\@dedicatory\@@par}\vfil\fi}\par}
\def\labelenumi{(\@arabic\c@enumi)}
\def\theenumi{\@arabic\c@enumi}
\def\labelenumii{(\@alph\c@enumii)}
\def\theenumii{\@alph\c@enumii}
\def\p@enumii{\theenumi}
\def\labelenumiii{(\@roman\c@enumiii)}
\def\theenumiii{\@roman\c@enumiii}
\def\p@enumiii{\theenumi(\theenumii)}
\def\labelenumiv{(\@Alph\c@enumiv)}
\def\theenumiv{\@Alph\c@enumiv}
\def\p@enumiv{\p@enumiii\theenumiii}
\def\labelitemi{$\m@th\bullet$}
\def\labelitemii{\bf --}% \upshape already done by \itemize
\def\labelitemiii{$\m@th\ast$}
\def\labelitemiv{$\m@th\cdot$}

%%% PLEIN DE PARAMETRES (repris d'amsart pour la plupart)
\def\baselinestretch{1.2}
\textwidth=160 true mm
\textheight=245 true mm
\footskip=30pt

\parskip=1pt plus1pt minus 1pt

\partopsep=0pt

\newdimen\addressindent
\addressindent 8truecm


\newcounter{secuppdepth} %% Si on est <= , alors titre en majuscule
\setcounter{secuppdepth}{1} %% parties et sections en majuscules

\def\part{\@startsection{part}{1}%
  \z@{3\linespacing\@plus\linespacing}{2\linespacing}%
  {\raggedright\normalfont\bfseries\smf@boldmath\MakeUppercase}}
\def\section{\@startsection{section}{1}%
  \z@{2\linespacing\@plus\linespacing}{\linespacing}%
  {\raggedright\normalfont\bfseries\smf@boldmath\MakeUppercase}}
\let\specialsection\section
\let\sectionname\@empty
\def\subsection{\@startsection{subsection}{2}%
  \z@{.7\linespacing\@plus.7\linespacing}{.3\linespacing}
  {\normalfont\bfseries\smf@boldmath}}
\let\Subsection\subsection

\def\th@plain{%
  \let\thm@indent\noindent
  \thm@headfont{\normalfont\scshape}%
  \thm@notefont{\normalfont}%
  \thm@preskip.5\linespacing \@plus .5\linespacing
  \thm@postskip\thm@preskip
  \thm@headpunct{\pointrait}
  \itshape }
\def\th@definition{\th@plain }  %  was \upshape 
\def\th@remark{\th@definition \thm@headfont{\itshape} \upshape}

%%%% THEOREMES, DEFINITIONS
\if@bbkswapnumbers\swapnumbers\fi

\theoremstyle{plain}
\newtheorem{defi}{\definame}[section]
\newtheorem{prop}[defi]{\propname}
\newtheorem{theo}[defi]{\theoname}
\newtheorem{conj}[defi]{\conjname}
\newtheorem{coro}[defi]{\coroname}
\newtheorem{fait}[defi]{\faitname}
\theoremstyle{definition}
\newtheorem{lemm}[defi]{\lemmname}
\theoremstyle{remark}
\newtheorem{rema}[defi]{\remaname}
\newtheorem{exem}[defi]{\exemname}
%%%% FIN DU DOCUMENT
\def\@setaddresses{\par
  \nobreak \begingroup
  \parindent \addressindent\normalfont
  \def\author##1{\begingroup
    \addvspace\bigskipamount \indent ##1\par\endgroup}%
  \def\\{\par\nobreak\ignorespaces}%
  \interlinepenalty\@M
  \def\address##1##2{\begingroup
    \par\nobreak\addvspace\medskipamount\indent
    \@ifnotempty{##1}{(\ignorespaces##1\unskip) }%
    {\normalfont\ignorespaces##2}\par\endgroup}%
  \def\curraddr##1##2{\begingroup
    \@ifnotempty{##2}{\nobreak\indent{\itshape Addresse courante}%
      \@ifnotempty{##1}{, \ignorespaces##1\unskip}~:\space
      ##2\par\endgroup}}%
  \def\email##1##2{\begingroup
    \@ifnotempty{##2}{\nobreak\indent{\itshape E-mail}%
      \@ifnotempty{##1}{, \ignorespaces##1\unskip}~:\space\nobreak
      \ttfamily##2\par\endgroup}}%
  \def\urladdr##1##2{\begingroup
    \@ifnotempty{##2}{\nobreak\indent{\itshape URL}%
      \@ifnotempty{##1}{, \ignorespaces##1\unskip}~:\space
      \ttfamily##2\par\endgroup}}%
  \addresses
  \endgroup
}    
%%%% HEADINGS
\def\ps@headings{\let\@mkboth\@gobbletwo
  \let\partmark\@gobble\let\sectionmark\@gobble
  \let\subsectionmark\@gobble
  \let\@oddfoot\@empty\let\@evenfoot\@empty%
 \def\@oddhead{\hfil\normalfont
    \ifnum\c@page=1 \else \@bbknumero-\ifnum\c@page<10 0\fi\the\c@page\fi\hfil}
  \let\@evenhead\@oddhead
}
\def\ps@myheadings{\let\@mkboth\@gobbletwo
  \let\@oddfoot\@empty\let\@evenfoot\@empty
  \def\@oddhead{\null\normalfont\small\rightmark \hfil\thepage}%
  \def\@evenhead{\normalfont\small \thepage\hfil\leftmark\null}%
}
\def\ps@plain{\let\@mkboth\@gobbletwo
     \let\@oddhead\@empty \let\@evenhead\@empty
     \def\@oddfoot{\normalfont\small \hfil\thepage\hfil}%
     \let\@evenfoot\@oddfoot}
\ps@headings
\def\@cite#1#2{\rom{\mdseries[{#1\if@tempswa , #2\fi}]}}
\def\rom#1{\leavevmode\skip@\lastskip\unskip\/%
        \ifdim\skip@=\z@\else\hskip\skip@\fi
   {\upshape#1}}

%%% MISE EN PAGE FINALE

\calclayout

\ifnum\@bbklanguage=0 %% Version anglaise
  \def\@byname{by}
  \def\partname{Part}
  \def\refname{References}
  \def\appendixname{Appendix}
  \def\contentsname{Table of contents}
  \def\figurename{Figure}
  \def\tablename{Table}
  \def\proofname{Proof}
  \def\definame{Definition}
  \def\propname{Proposition}
  \def\theoname{Theorem}
  \def\conjname{Conjecture}
  \def\coroname{Corollary}
  \def\faitname{Fact}
  \def\exemname{Example}
  \def\lemmname{Lemma}
  \def\remaname{Remark}
  \expandafter\ifx\csname ehyph\endcsname\relax
    \else\message{Csure anglaise}\ehyph\fi %% SI MLTeX
\else %% Version francaise
  \def\@byname{par}
  \def\partname{Partie}
  \def\refname{Bibliographie}
  \def\appendixname{Appendice}
  \def\contentsname{Table des mati\`eres}
  \def\figurename{Figure}
  \def\tablename{Table}
  \def\proofname{Preuve}
  \def\definame{D\'efinition}
  \def\propname{Proposition}
  \def\theoname{Th\'eor\`eme}
  \def\conjname{Conjecture}
  \def\coroname{Corollaire}
  \def\faitname{Fait}
  \def\exemname{Exemple}
  \def\lemmname{Lemme}
  \def\remaname{Remarque}
  \expandafter\ifx\csname fhyph\endcsname\relax
    \else\message{Csure franaise}\fhyph\fi %% SI MLTeX
\fi

\def\smf@enddoc{%
  \par\vskip 2\bigskipamount
  \bgroup
  \def\baselinestretch{1}\normalfont
  \raggedright
  \ifx\@empty\@translators\else \@settranslators\medskip \fi
  \ifx\@empty\addresses   \else \@setaddresses             \fi
  \par\egroup}

