%%%%%%%%%%%%%%
%
%  JArticle.cls
%
%  
%  Latex2e article class various journals
%
%  Options:  	JChemPhys	Jounal Of Chemical Physics 
%		JStatPhys	Journal of Statistical Physics
%		JPhys	   	Journal of Physics
%
%
%	(c) 1997 Gabriel Tellez A.
%
%

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{JArticle}[1997/04/25 JArticle class]

\def\Journal{0} % Journal id: 	0 Latex article
%				1 J. Chem. Phys.
%				2 J. Stat. Phys.
%				3 J. Phys.
%

\newif\ifis@preprint
\is@preprintfalse

\DeclareOption{JChemPhys}{\def\Journal{1}}
\DeclareOption{JStatPhys}{\def\Journal{2}}
\DeclareOption{JPhys}{\def\Journal{3}}
\DeclareOption{preprint}{\is@preprinttrue}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax

\ifnum\Journal=3%	J. Phys.
\LoadClass[fleqn]{article}%     fleqn by default.
\else
\LoadClass{article}
\fi
\ifcase\Journal%
\relax% 	0 = latex article
\or
%          	1 = J. Chem. Phys.
%
\InputIfFileExists{JChemPhys.sty}{}{\ClassError{JArticle}{Can't find JChemPhys.sty file}{Press return to use Latex2e standard article class}}
\or
%		2 = J. Stat. Phys.
%
\InputIfFileExists{JStatPhys.sty}{}{\ClassError{JArticle}{Can't find JStatPhys.sty file}{Press return to use Latex2e standard article class}}
\or
%		3 = J. Phys.
%
\InputIfFileExists{JPhys.sty}{}{\ClassError{JArticle}{Can't find JPhys.sty file}{Press return to use Latex2e standard article class}}
\else
\ClassError{JArticle}{Article id \Journal unknown.}{Press return to proceed.}
\fi


