%
%
% $Header: /var/local/devel/macro/camera/camera.cls,v 1.15 2003/09/03 13:41:07 matteo Exp $
%
%
% camera.cls
% written by MrX
% 1997/03/18 2000-08-06
% 
% A very simple LaTeX2e class for writing camera-ready papers for
% conference proceedings.
% Societ\`a Italiana di Fisica  http://www.sif.it
% 
% usage:  \documentclass{camera}
%         \begin{document}
%         \title{...}
%         \author{..., ..., ... \and ...}
%         \organization{...}
%         \maketitle
%         ...
%         \end{document}

\newif\iftoc\tocfalse
\newif\ifb@tt@ll@\b@tt@ll@false
\newwrite\@maintoc
\newtoks\autht@k
\newtoks\titlet@k
%\errorcontextlines=99

% identification
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{camera}[1997/02/05 SIF camera-ready class]

% options
\DeclareOption{bottello}{\b@tt@ll@true}
\DeclareOption{toc}{\toctrue}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions

\def\bottello{\global\b@tt@ll@true}

% opening outfiles
\iftoc
\else
  \immediate\openout\@maintoc\jobname.toc
\fi


% modularity
\LoadClass[11pt]{article}
\setlength{\paperwidth}{17cm}
\setlength{\paperheight}{24cm}
\setlength{\headheight}{1cm}
\addtolength{\headsep}{-1cm}
\sloppy

% Publication data
\let\@procinfo@\@empty
\long\gdef\procinfo#1#2#3{\long\gdef\@procinfo@{%
   {\tiny\sffamily\noindent
     #1\newline #2\newline
 #3\par}}}

\def\ps@procfirst{%
   \let\@evenfoot\@empty
   \def\@oddfoot{\hfill\thepage\hfill}
   \let\@evenhead\@empty
   \def\@oddhead{\vbox to 1cm{\@procinfo@\vfill\null}}
}%

% title stuff

\def\author#1{\global\autht@k={#1}
              \gdef\@author{#1}}
\def\title#1{\global\titlet@k={#1}
             \gdef\@title{#1}}
\renewcommand{\maketitle}
     {\bgroup\let\footnote\thanks
      \thispagestyle{procfirst}
     \iftoc\else
       \ifb@tt@ll@
         \immediate\write\@maintoc{\string\tocsect{\the\titlet@k}{}}
       \else
         \immediate\write\@maintoc{\string\tocit{\thepage}{\the\autht@k}{\the\titlet@k}}
       \fi
     \fi
     {\centering\parbox{\textwidth}{\vspace{1cm}\ifb@tt@ll@\global\b@tt@ll@false\else\centering\LARGE\fi\textbf{\@title}}\par}%
     \vspace{1cm}%
     {\centering\parbox{\textwidth}{\centering\textsc{\@author}}\par}%
     \vspace{1.9cm}%
     {\centering\parbox{\textwidth}{\centering\@organization}\par}%
     \vspace{1.2cm}
     \egroup
     \@thanks
     \let\@thanks\@empty
     \let\@title\@empty
     \let\@author\@empty
     \let\@organization\@empty
}

\gdef\@organization{}
\newcommand{\organization}[1]{\gdef\@organization{#1}}

% page layout
\pagestyle{empty}
\hoffset-1.6cm
\voffset-2.2cm

% Captions
\newcommand\captionsize{\fontsize{10\p@}{11\p@}\selectfont}
\long\def\@makecaption#1#2{%
  \captionsize
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1: #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1: #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

% macros

\AtBeginDocument{\gdef\And{\textup{and}\ \ignorespaces}}
\let\atque\And
\def\and{\textup{and}\ \ignorespaces}
\newcommand{\drm}{\mathrm{d}}        %MATH ONLY
\newcommand{\sy}[1]{\mathrm{#1}}     %MATH ONLY
\let\ab\sy
\newcommand{\tx}[1]{\mbox{#1}}
\newcommand{\un}[1]{{\,\mbox{#1}}}
\newcommand{\chem}[1]{\ensuremath{\mathrm{#1}}}
\newcommand{\acro}[1]{{\normalfont #1}}
\newcommand{\vcomment}[1]{%
  \unskip
  \ifcomments
    \marginpar{%
      \hrule height2pt
      \vspace*{4pt}
      {\raggedright\footnotesize\itshape #1\par}%
      \vspace*{4pt}
      \hrule height2pt
    }%
  \fi
}
\def\@deceased@{\let\@temp@\@makefnmark
                \def\@makefnmark{$^\dag$}\thanks{Deceased.}%
        \let\@makefnmark\@temp@}
\newcommand{\deceased}{\protect\@deceased@}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% It's not a dumb class anymore ;( (isn't it?)

%% Remember... you cannot do anything really foolproof ;)

%% toc stuff 

\iftoc
 \newcounter{pageflag}
 \let\thanks\@gobble
 \let\cartola\@gobble
 \thispagestyle{empty}%
 \pagestyle{empty}%
 \pagenumbering{Roman}%
 \renewcommand{\@maketitle}{%
     \vspace{12pt}%
     \hbox{\hfill
           {\large{CONTENTS}}}%
     \vspace{3cm plus3cm minus2cm}%
     \par
 }
 \renewcommand{\maketitle}{%
    \newpage
    \@maketitle
    \def\ETC{}%
 }
 \def\extratoc#1{\gdef\@@xtr@@{#1}}
 \let\@@xtr@@\@empty
 \newenvironment{thetoc}{%
   \let\footnote\@gobble
   \let\thanks\@gobble
   \small
   \newcommand{\tocex}[3]{%
     \textsc{##2}~--~##3~\textit{(\@@xtr@@)}\dotfill%
       \ifnum\value{pageflag}=0
       \rlap{\hbox to1cm{\quad\hfill page\hfill}\hbox to1cm{\hfill##1}}%
     \else
       \rlap{\hbox to1cm{\quad\hfill$\scriptstyle{``}$\hfill}\hbox to1cm{\hfill##1}}%
     \fi
     \stepcounter{pageflag}
     \par
     \pagebreak[3]%
   }%
   \newcommand{\tocit}[3]{%
     \textsc{##2}~--~##3\dotfill%
       \ifnum\value{pageflag}=0
       \rlap{\hbox to1cm{\quad\hfill page\hfill}\hbox to1cm{\hfill##1}}%
     \else
       \rlap{\hbox to1cm{\quad\hfill$\scriptstyle{``}$\hfill}\hbox to1cm{\hfill##1}}%
     \fi
     \stepcounter{pageflag}
     \par
     \pagebreak[3]%
   }%
   \newcommand{\tocem}[2]{%
     \tocskip
     {##2\dotfill}%
       \ifnum\value{pageflag}=0
       \rlap{\hbox to1cm{\quad\hfill page\hfill}\hbox to1cm{\hfill##1}}%
     \else
       \rlap{\hbox to1cm{\quad\hfill$\scriptstyle{``}$\hfill}\hbox to1cm{\hfill##1}}%
     \fi
     \stepcounter{pageflag}
     \par
     \pagebreak[3]%
   }%
   \newcommand{\tocsect}[2]{%
     \tocskip
     \tocskip
     ##2
     \hskip4pt##1
     \tocskip
     \par
   }%
   \newcommand{\tocskip}{\medskip}%
   \newcommand{\shortnotes}{%
     \tocskip
     \textbf{Note brevi}%
     \par
   }%
   \newcommand{\erratum}{(\textit{Erratum})}%
   \newcommand{\tocpage}{\setcounter{pageflag}{0}}%
   \renewcommand{\arraystretch}{1.3}%
   \parindent=-.5cm
   \leftskip=.5cm
   \rightskip=2cm
   \parskip=0pt plus12pt minus0pt
   \sloppy
   \tocpage
 }{%
   \vfill
 }
\fi




