\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{cththesis}[2004/06/29 v0.1 CTH thesis LaTeX document class]

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{memoir}}
%\ExecuteOptions{swedish,rblu}
\ProcessOptions % process default options
%\LoadClass[titlepage,a4paper]{book}
%\LoadClass[a4paper,10pt,twoside,showtrims,onecolumn,openright]{memoir} %print
\LoadClass[a4paper,10pt,twoside,onecolumn,openright]{memoir} %screen
%\RequirePackage[dvips,xdvi]{graphicx}
%\RequirePackage{ifthen}
%\RequirePackage[swedish,english]{babel}
%\RequirePackage[T1]{fontenc}
%\RequirePackage{fancyhdr}

%\DeclareOption{phd}{\newcommand{\thesistype}{PhD thesis}}
%\DeclareOption{lic}{\newcommand{\thesistype}{Lic thesis}}
%\ProcessOptions

\setstocksize{297mm}{210mm} %print
%\setstocksize{241mm}{171mm} %screen
\settrimmedsize{241mm}{171mm}{*}
%\settrims{1in}{1in}
\setlength{\trimtop}{\stockheight}
\addtolength{\trimtop}{-\paperheight}
\setlength{\trimedge}{\stockwidth}
\addtolength{\trimedge}{-\paperwidth}
\settrims{0.5\trimtop}{0.5\trimedge}

\setlrmarginsandblock{0.125\paperwidth}{*}{1.67}
\setulmarginsandblock{\spinemargin}{\foremargin}{*}
\checkandfixthelayout



\newcommand*{\Feffetrimpictl}{%
  \begin{picture}(0,0)
    \unitlength 1mm
    \thinlines
    \put(-2,0){\line(-1,0){18}}
    \put(0,2){\line(0,1){18}}
  \end{picture}}
\newcommand*{\Feffetrimpictr}{%
  \begin{picture}(0,0)
    \unitlength 1mm
    \thinlines
    \put(2,0){\line(1,0){18}}
    \put(0,2){\line(0,1){18}}
  \end{picture}}
\newcommand*{\Feffetrimpicbl}{%
  \begin{picture}(0,0)
    \unitlength 1mm
    \thinlines
    \put(-2,0){\line(-1,0){18}}
    \put(0,-2){\line(0,-1){18}}
  \end{picture}}
\newcommand*{\Feffetrimpicbr}{%
  \begin{picture}(0,0)
    \unitlength 1mm
    \thinlines
    \put(2,0){\line(1,0){18}}
    \put(0,-2){\line(0,-1){18}}
  \end{picture}}


\newcommand*{\trimFeffemarks}{%
  \let\tmarktl\Feffetrimpictl
  \let\tmarktr\Feffetrimpictr
  \let\tmarkbl\Feffetrimpicbl
  \let\tmarkbr\Feffetrimpicbr
}

%\trimFeffemarks

\chapterstyle{demo}


\pagestyle{ruled}

%\renewcommand{\printchapternum}{\resizebox{!}{15mm}{\chapnumfont\HUGE \thechapter}}
\renewcommand{\printchapternum}{{\chapnumfont\fontsize{60}{60}\selectfont \thechapter}}




