% This is aa.cls
% A&A DOCUMENT CLASS -- version 5.01 for LaTeX2e
%
% LaTeX document class for Astronomy and Astrophysics journal
%
%%
%%
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{aa}[2000/06/20 v5.01
^^JLaTeX document class for Astronomy and Astrophysics journal]
\newcommand\@ptsize{}
\newif\if@restonecol
\newif\if@titlepage
\@titlepagefalse
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}% 
    \setlength\paperwidth  {210mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}%
}
%
\let\if@runhead\iffalse
\DeclareOption{runningheads}{\let\if@runhead\iftrue}
\let\if@envcntreset\iffalse
\DeclareOption{envcountreset}{\let\if@envcntreset\iftrue}
\let\if@envcntsect\iffalse
\DeclareOption{envcountsect}{\let\if@envcntsect\iftrue}
\let\if@referee\iffalse
\DeclareOption{referee}{\let\if@referee\iftrue}
\let\if@nyobjects\iffalse
%
\ExecuteOptions{a4paper,twoside,twocolumn,fleqn,final,10pt,runningheads}
\ProcessOptions
\AtEndOfClass{\mathindent\z@\let\abstract=\aaabstract}
%
\if\@ptsize 0
%
   \renewcommand\normalsize{%
      \@setfontsize\normalsize\@xpt{12}%
      \abovedisplayskip 8.55\p@ \@plus4\p@ \@minus5\p@
      \abovedisplayshortskip \z@ \@plus3\p@
      \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
      \belowdisplayskip \abovedisplayskip
      \let\@listi\@listI}
   \normalsize
   \newcommand\small{%
      \@setfontsize\small\@ixpt{11}%
      \abovedisplayskip 8.5\p@ \@plus3\p@ \@minus4\p@
      \abovedisplayshortskip \z@ \@plus2\p@
      \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
      \def\@listi{\leftmargin\leftmargini
                  \parsep 0\p@ \@plus1\p@ \@minus\p@
                  \topsep 8\p@ \@plus2\p@ \@minus4\p@
                  \itemsep0\p@}%
      \belowdisplayskip \abovedisplayskip
   }
   \newcommand\scriptsize{\@setfontsize\scriptsize\@viipt\@viiipt}
   \newcommand\tiny{\@setfontsize\tiny\@vipt\@viipt} 
   \newcommand\large{\@setfontsize\large\@xipt{13}}
   \newcommand\Large{\@setfontsize\Large\@xivpt{16}}
   \newcommand\LARGE{\@setfontsize\LARGE\@xviipt{20}}
   \newcommand\huge{\@setfontsize\huge\@xxpt{24}}
   \newcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
   %
   \setlength\parindent{15\p@}
   \setlength\smallskipamount{3\p@ \@plus 1\p@ \@minus 1\p@}
   \setlength\medskipamount{6\p@ \@plus 2\p@ \@minus 2\p@}
   \setlength\bigskipamount{12\p@ \@plus 4\p@ \@minus 4\p@}
   \setlength\headheight{12\p@}
   \setlength\headsep   {12\p@} % 
   \setlength\topskip   {10\p@}
   \setlength\footskip{30\p@}
   \setlength\maxdepth{.5\topskip}
   %
   \@settopoint\textwidth
   \setlength\marginparsep {10\p@}
   \setlength\marginparpush{5\p@}
   \setlength\oddsidemargin   {-30\p@}
   \setlength\evensidemargin  {-30\p@}
   \setlength\marginparwidth  {48\p@}
   \setlength\topmargin{-10pt}
   \setlength\footnotesep{8\p@}
   \setlength{\skip\footins}{9\p@ \@plus 4\p@ \@minus 2\p@}
   \setlength\floatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
   \setlength\textfloatsep{18\p@ \@plus 8\p@ \@minus 6\p@}
   \setlength\intextsep   {18\p@ \@plus 2\p@ \@minus 2\p@}
   \setlength\dblfloatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
   \setlength\dbltextfloatsep{18\p@ \@plus 8\p@ \@minus 6\p@}
   \setlength\@fptop{0\p@ }
   \setlength\@fpsep{12\p@ }
   \setlength\@fpbot{0\p@ \@plus 1fil}
   \setlength\@dblfptop{0\p@ }
   \setlength\@dblfpsep{12\p@ }
   \setlength\@dblfpbot{0\p@ \@plus 1fil}
   \setlength\partopsep{2\p@ \@plus 1\p@ \@minus 1\p@}
   \def\@listi{\leftmargin\leftmargini
               \parsep \z@
               \topsep 8\p@ \@plus2\p@ \@minus4\p@
               \itemsep\parsep}
   \let\@listI\@listi
   \@listi
   \def\@listii {\leftmargin\leftmarginii
                 \labelwidth\leftmarginii
                 \advance\labelwidth-\labelsep
                 \topsep    \z@
                 \parsep    \topsep
                 \itemsep   \parsep}
   \def\@listiii{\leftmargin\leftmarginiii
                 \labelwidth\leftmarginiii
                 \advance\labelwidth-\labelsep
                 \topsep    \z@
                 \parsep    \topsep
                 \itemsep   \parsep}
   \def\@listiv {\leftmargin\leftmarginiv
                 \labelwidth\leftmarginiv
                 \advance\labelwidth-\labelsep}
   \def\@listv  {\leftmargin\leftmarginv
                 \labelwidth\leftmarginv
                 \advance\labelwidth-\labelsep}
   \def\@listvi {\leftmargin\leftmarginvi
                 \labelwidth\leftmarginvi
                 \advance\labelwidth-\labelsep}
\else
   \input{size1\@ptsize.clo}
\fi
%
\let\footnotesize\small
%
\setlength{\textwidth}{180mm}
\setlength{\textheight}{694pt} 
%\setlength{\voffset}{-1.2cm}
%
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
%
\setcounter{topnumber}{4}
\renewcommand\topfraction{.9}
\setcounter{bottomnumber}{2}
\renewcommand\bottomfraction{.5}
\setcounter{totalnumber}{6}
\renewcommand\textfraction{.05}
\renewcommand\floatpagefraction{.95}
\setcounter{dbltopnumber}{3}
\renewcommand\dbltopfraction{.9}
\renewcommand\dblfloatpagefraction{.95}
%
\def\ps@headings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\small\rlap{\thepage}\hfil\leftmark\hfil}%
    \def\@oddhead{\small\hfil\rightmark\hfil\llap{\thepage}}%
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
    }
% make indentations changeable
\def\setitemindent#1{\settowidth{\labelwidth}{#1}%
        \leftmargini\labelwidth
        \advance\leftmargini\labelsep
   \def\@listi{\leftmargin\leftmargini
        \labelwidth\leftmargini\advance\labelwidth by -\labelsep
        \parsep=\parskip
        \topsep=\medskipamount
        \itemsep=\parskip \advance\itemsep by -\parsep}}
\def\setitemitemindent#1{\settowidth{\labelwidth}{#1}%
        \leftmarginii\labelwidth
        \advance\leftmarginii\labelsep
\def\@listii{\leftmargin\leftmarginii
        \labelwidth\leftmarginii\advance\labelwidth by -\labelsep
        \parsep=\parskip
        \topsep=\z@
        \itemsep=\parskip \advance\itemsep by -\parsep}}
% labels of description
\def\descriptionlabel#1{\hspace\labelsep #1\hfil}
% adjusted environment "description"
% if an optional parameter (at the first two levels of lists)
% is present, its width is considered to be the widest mark
% throughout the current list.
\def\description{\@ifnextchar[{\@describe}{\list{}{\labelwidth\z@
          \itemindent-\leftmargin \let\makelabel\descriptionlabel}}}
\let\enddescription\endlist
%
\def\describelabel#1{#1\hfil}
\def\@describe[#1]{\relax\ifnum\@listdepth=0
\setitemindent{#1}\else\ifnum\@listdepth=1
\setitemitemindent{#1}\fi\fi
\list{--}{\let\makelabel\describelabel}}
%
\newdimen\logodepth
\logodepth=1.3cm
\newdimen\headerboxheight
\headerboxheight=143pt
\newdimen\betweenumberspace          % dimension for space between
\betweenumberspace=3.33pt            % number and text of titles.
\newdimen\aftertext                  % dimension for space after
\aftertext=5pt                       % text of title.
\newdimen\headlineindent             % dimension for space between
\headlineindent=1.166cm              % number and text of headings.
\def\andname{and}
\def\keywordname{{\sffamily\bfseries Key words.}}
\def\lastandname{, and}
\def\mailname{{\it Correspondence to\/}:}
\def\keywords{\par\addvspace\baselineskip\noindent\keywordname\
\ignorespaces}
\def\email#1{{e-mail: \tt#1}}
%
\newcounter{inst}
\newcounter{auth}
\newdimen\instindent
\newbox\authrun
\newtoks\authorrunning
\newbox\titrun
\newtoks\titlerunning

\def\journalname#1{\gdef\@journalname{#1}}
\gdef\@journalname{Astronomy \&\ Astrophysics}

\def\headnote#1{\gdef\@headnote{#1}}
\def\@headnote{}

\def\dedication#1{\gdef\@dedic{#1}}
\def\@dedic{}

\let\@date\undefined

\def\aaabstract#1{\gdef\@abstract{#1}}

\def\institute#1{\gdef\@institute{#1}}

\def\institutename{\par
 \begingroup
 \parindent=0pt
 \parskip=0pt
 \setcounter{inst}{1}%
 \def\and{\par\stepcounter{inst}%
 \hangindent\instindent
 \noindent
 \hbox to\instindent{\hss$^{\theinst}$\enspace}\ignorespaces}%
 \setbox0=\vbox{\def\thanks##1{}\@institute}
 \ifnum\value{inst}>9\relax\setbox0=\hbox{$^{88}$\enspace}%
                 \else\setbox0=\hbox{$^{8}$\enspace}\fi
 \instindent=\wd0\relax
 \ifnum\value{inst}=1\relax
 \else
   \setcounter{inst}{1}%
   \hangindent\instindent
   \noindent
   \hbox to\instindent{\hss$^{\theinst}$\enspace}\ignorespaces
 \fi
 \small
 \ignorespaces
 \@institute\par
 \endgroup}

\def\offprints#1{\begingroup
\def\protect{\noexpand\protect\noexpand}\xdef\@thanks{\@thanks
\protect\footnotetext[0]{\unskip\hskip-1.5em{\it Send offprint requests
to\/}: \ignorespaces#1}}\endgroup\ignorespaces}

\def\mail#1{\gdef\@mail{#1}}
\def\@mail{}

\def\@thanks{}

\def\@fnsymbol#1{\ifcase#1\or\star\or{\star\star}\or{\star\star\star}%
   \or \dagger\or \ddagger\or
   \mathchar "278\or \mathchar "27B\or \|\or **\or \dagger\dagger
   \or \ddagger\ddagger \else\@ctrerr\fi\relax}

\def\inst#1{\unskip$^{#1}$}
\def\fnmsep{\unskip$^,$}

\def\subtitle#1{\gdef\@subtitle{#1}}
\def\@subtitle{}

\def\msnr#1{\gdef\@msnr{#1}}
\def\@msnr{}

\def\idline#1#2{\gdef\@idline{#1}\setcounter{page}{#2}}
\def\@idline{}
\def\doi#1{\gdef\@doi{#1}}
\def\@doi{(DOI: will be inserted by hand later)}

\def\headnote#1{\gdef\@headnote{#1}}
\def\@headnote{}

\def\ch@ckobl#1#2{\@ifundefined{@#1}
 {\typeout{A\string&A warning: Missing
\expandafter\string\csname#1\endcsname}%
  \csname #1\endcsname{#2}}
 {}}

\newif\if@normhead \@normheadtrue
\def\hugehead{\@normheadfalse
\onecolumn
\let\thanks=\footnote
\long\def\@makefntext##1{\parindent\bibindent
     \columnwidth\textwidth\advance\columnwidth -\columnsep
     \divide\columnwidth\tw@\hsize\columnwidth \linewidth\columnwidth
     \noindent\hbox to\parindent{\hss$\m@th^{\@thefnmark}$ }##1}%
}

\def\maketitle{\par
\ch@ckobl{journalname}{Noname}
\ch@ckobl{date}{the date of receipt and acceptance should be inserted
later}
\ch@ckobl{title}{A title should be given}
\ch@ckobl{author}{Name(s) and initial(s) of author(s) should be given}
\ch@ckobl{institute}{Address(es) of author(s) should be given}
\ch@ckobl{abstract}{An abstract should be given}
\begingroup
%
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{$^{\@thefnmark}$}%
%
 \def\lastand{\ifnum\value{inst}=2\relax
                 \unskip{} \andname\
              \else
                 \unskip, \andname\
              \fi}%
 \def\and{\stepcounter{auth}\relax
          \ifnum\value{auth}=\value{inst}%
             \lastand
          \else
             \unskip,
          \fi}%
 \ifnum \col@number=\@ne
   \@maketitle
 \else
   \twocolumn[\@maketitle]%
 \fi
 \thispagestyle{empty}
 \global\@topnum\z@
 \if@normhead
    \@thanks
 \else
    \twocolumn[\vspace{\@tempdima}]
    \addtocounter{page}{-1}
    \if!\the\authorrunning!
       \authorrunning{ }%
    \fi
 \fi
 \if!\@mail!\else
    \footnotetext[0]{\kern-\bibindent\mailname\
    \ignorespaces\@mail}%
 \fi
%
 \if@runhead
    \def\\{\unskip\ \ignorespaces}\def\inst##1{\unskip{}}%
    \def\thanks##1{\unskip{}}\def\fnmsep{\unskip}%
    \def\object##1{##1}%
    \instindent=\textwidth
    \advance\instindent by-2\headlineindent
    \if!\the\titlerunning!\else
      \edef\@title{\the\titlerunning}%
    \fi
    \global\setbox\titrun=\hbox{\small\rm\unboldmath\ignorespaces\@title}%
    \ifdim\wd\titrun>\instindent
       \typeout{^^JA\string&A Warning: Title too long for running head.}%
       \typeout{Please supply a shorter form with \string\titlerunning
                \space prior to \string\maketitle}%
       \global\setbox\titrun=\hbox{\small\rm
       Title Suppressed Due to Excessive Length}%
    \fi
    \xdef\@title{\copy\titrun}%
%
    \if!\the\authorrunning!
    \else
      \setcounter{auth}{1}%
      \edef\@author{\the\authorrunning}%
    \fi
    \ifnum\value{auth}>2
       \def\stripauthor##1\and##2\endauthor{%
       \protected@xdef\@author{##1\unskip\unskip\if!##2!\else
       \ et al.\fi}}%
       \expandafter\stripauthor\@author\and\endauthor
    \else
       \gdef\and{\unskip\ and \ignorespaces}%
       {\def\and{\noexpand\protect\noexpand\and}%
       \protected@xdef\@author{\@author}}
    \fi
    \global\setbox\authrun=\hbox{\small\unboldmath\@author\unskip:
                                 \unhbox\titrun}%
    \ifdim\wd\authrun>\instindent
%
    \typeout{^^JA\string&A Warning: The running head built automatically
             from \string\author\space and \string\title
             ^^Jexceeds the pagewidth, please supply a shorter form
             ^^Jwith \string\authorrunning\space and/or
             \string\titlerunning\space prior to \string\maketitle}%
    \global\setbox\authrun=\hbox{\small\rm Please give a shorter version
       with: {\tt\string\authorrunning\space}and/or{\tt\space
       \string\titilerunning\space}prior to{\tt\space\string\maketitle}}%
    \fi
    \xdef\@author{\copy\authrun}%
    \markboth{\@author}{\@author}%
 \fi
%
 \endgroup
 \setcounter{footnote}{0}
 \setcounter{footnote}{0}%
 \global\let\thanks\relax
 \global\let\maketitle\relax
 \global\let\@maketitle\relax
 \global\let\@thanks\@empty
 \global\let\@author\@empty
 \global\let\@date\@empty
 \global\let\@title\@empty
 \global\let\@subtitle\@empty
 \global\let\@abstract\@empty
 \global\let\title\relax
 \global\let\author\relax
 \global\let\aabstract\relax
 \global\let\date\relax
 \global\let\and\relax}

\def\AALogo{\setbox254=\hbox{
\setlength{\tabcolsep}{0pt}
\begin{tabular}{l}
\\[-30pt]
{\fontsize{18}{21}\selectfont\sffamily\bfseries Astronomy} \\[-2.5pt]
{\fontsize{16}{12}\selectfont\sffamily\mdseries \kern8pt\&\raisebox{4pt}{\rule{78pt}{1pt}}} \\[-5pt]
{\fontsize{18}{21}\selectfont\sffamily\bfseries Astrophysics}
\end{tabular}}\copy254}

\def\makeheadbox{{
\hbox to\textwidth{%
\if!\@idline!
\hbox to0pt{\vbox{\hsize=40cc
\baselineskip=12pt\hrule\hbox
{\vrule\kern3pt\vbox{\kern3pt
\hb@xt@ 40cc{{\sl\@journalname}\ manuscript no.\hfil}
\if!\@msnr!\hbox{(will be inserted by hand later)}\else
\hb@xt@ 30cc{\hfil\strut\LARGE\bfseries\smash{\@msnr}}\fi
\kern3pt}\hfil\kern3pt\vrule}\hrule}\hss}\hfill
\else
\vbox{\baselineskip=11pt
\hbox{\@idline}
\hbox{\@doi}
\hbox{\small\rm \copyright~ESO~2001}}
\hfill\AALogo
\fi}}}

\def\@maketitle{\newpage
 \normalfont
 \vbox to0pt{\vskip-20pt
 \nointerlineskip
 \makeheadbox\vss}\nointerlineskip
 \if@normhead
    \setbox\authrun=\vbox\bgroup
 \fi
 \begin{center}
  \vskip24pt
 {\LARGE \sffamily\bfseries\boldmath
  \hrule\@height\logodepth\@width\z@
  \pretolerance=10000
 \if!\@headnote!\else
   \noindent
   {\normalfont\itshape\ignorespaces\@headnote\par}\vskip 3.5mm
 \fi
  \noindent\ignorespaces
  \@title \par}\vskip 14pt\relax
 \if!\@subtitle!\else
   {\Large \sffamily\bfseries\boldmath
   \pretolerance=10000
   \noindent\ignorespaces\@subtitle \par}\vskip 14pt
 \fi
 \lineskip .5em
 \setbox0=\vbox{\setcounter{auth}{1}\def\and{\stepcounter{auth} }%
                \hfuzz=2\textwidth\def\thanks##1{}\@author}%
 \value{inst}=\value{auth}%
 \setcounter{auth}{1}%
 {\large \rmfamily\mdseries \noindent\ignorespaces\@author}
 \end{center}
 \vskip6pt
 \leftskip=1cm\rightskip=\leftskip
 \small\rm
 \institutename
 \vskip 12pt \noindent\@date
 \if!\@dedic!\else
    \par
    \normalsize\it
    \addvspace\baselineskip
    \noindent\@dedic
 \fi
 \vskip 12pt
 \noindent{\sffamily\bfseries\abstractname}\ \@abstract
 \if@normhead
    \egroup % end of header box
    \@tempdima=\headerboxheight
    \advance\@tempdima by-\ht\authrun
%   \advance\@tempdima by-\pagetotal
    \ifdim\@tempdima>0pt
       \vrule width0pt height\@tempdima
    \fi
    \unvbox\authrun
    \global\@minipagetrue
    \global\everypar{\global\@minipagefalse\global\everypar{}}
 \else
    \typeout{\the\c@auth\space author names and}
    \typeout{\the\c@inst\space institutes processed}
    \global\@tempdima=\pagetotal
    \global\advance\@tempdima by24pt
 \fi
 \vskip24pt
}
%
\DeclareMathAlphabet{\mathsc}{OT1}{cmr}{m}{sc}
\def\testbx{bx}%
\DeclareRobustCommand{\ion}[2]{%
\relax\ifmmode
\ifx\testbx\f@series
{\mathbf{#1\,\mathsc{#2}}}\else
{\mathrm{#1\,\mathsc{#2}}}\fi
\else\textup{#1\,{\mdseries\textsc{#2}}}%
\fi}
%
\def\clearelargs{\def\1{}\def\2{}\def\3{}\def\4{}\count255=0}
\def\druck@lement#1{{}^{\2}_{\3}\mathrm{#1}{}^{\1}_{\4}{}\if@tempswa$\fi}
\DeclareRobustCommand{\element}{\relax\ifmmode\@tempswafalse
\else$\@tempswatrue\fi\clearelargs\def\?{\phantom{0}}\@lement}
\def\@lement#1{\if#1[\expandafter\f@@dargs\else\druck@lement{#1}\fi}
\def\f@@dargs#1]{\advance\count255by\@ne
\expandafter\def\csname\number\count255\endcsname{#1}\@lement}
%
%\def\vec#1{\ensuremath{\mathbf{#1}}}
\def\vec#1{\ensuremath{\mathchoice{\mbox{\boldmath$\displaystyle#1$}}
{\mbox{\boldmath$\textstyle#1$}}
{\mbox{\boldmath$\scriptstyle#1$}}
{\mbox{\boldmath$\scriptscriptstyle#1$}}}}
%
\def\tens#1{\ensuremath{\mathsf{#1}}}
%
\setcounter{secnumdepth}{3}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand\thesection      {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection .\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
%
\def\sectcounterend{.}

\def\@seccntformat#1{\csname the#1\endcsname\sectcounterend
\hskip\betweenumberspace}

\def\@sect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
        \@hangfrom{\hskip #3\relax\@svsec}%
          \raggedright
          \hyphenpenalty \@M%
          \interlinepenalty \@M #8\@@par}%
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #7}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec #8\hskip\aftertext}%
      \csname #1mark\endcsname{#7}%
      \addcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi
        #7}}%
  \fi
  \@xsect{#5}}

%
% measures and setting of sections
%
\def\section{\@startsection{section}{1}{\z@}%
    {-16dd plus-4pt minus-4pt}{6dd}{\large\sffamily\bfseries}}
\def\subsection{\@startsection{subsection}{2}{\z@}%
    {-16dd}{6dd}{\large\sffamily\itshape}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}%
    {-16dd}{6dd}{\large\sffamily}}
\def\paragraph{\@startsection{paragraph}{4}{\z@}%
    {-16dd}{-1pt}{\normalsize\sffamily}}

\setlength\leftmargini  {\parindent}
\leftmargin  \leftmargini
\setlength\leftmarginii {\parindent}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\setlength\leftmarginv  {.5em}
\setlength\leftmarginvi {.5em}
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\normalfont\bfseries --}
\newcommand\labelitemii{\normalfont\bfseries --}
\newcommand\labelitemiii{$\m@th\bullet$}
\newcommand\labelitemiv{$\m@th\cdot$}

% redefinition of the "\newtheorem" command.
%
% Usage now:
%
%     \newtheorem{env_nam}{caption}[within]{cap_font}{body_font}
% or  \newtheorem{env_nam}[numbered_like]{caption}{cap_font}{body_font}
% or  \newtheorem*{env_nam}{caption}{cap_font}{body_font}
%
% New is "cap_font" and "body_font". It stands for
% fontdefinition of the caption and the text itself.
%
% "\newtheorem*" gives a theorem without number.
%
% A defined newthoerem environment is used as described
% by Lamport.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\@thmcountersep{}
\def\@thmcounterend{.}

\def\newtheorem{\@ifstar{\@sthm}{\@Sthm}}

% definition of \newtheorem with number

\def\@Sthm#1{\@ifnextchar[{\@othm{#1}}{\@nthm{#1}}}

\def\@xnthm#1#2[#3]#4#5{\expandafter\@ifdefinable\csname #1\endcsname
   {\@definecounter{#1}\@addtoreset{#1}{#3}%
   \expandafter\xdef\csname the#1\endcsname{\expandafter\noexpand
     \csname the#3\endcsname \noexpand\@thmcountersep \@thmcounter{#1}}%
   \expandafter\xdef\csname #1name\endcsname{#2}%
   \global\@namedef{#1}{\@thm{#1}{\csname #1name\endcsname}{#4}{#5}}%
                              \global\@namedef{end#1}{\@endtheorem}}}

\def\@ynthm#1#2#3#4{\expandafter\@ifdefinable\csname #1\endcsname
   {\@definecounter{#1}%
   \expandafter\xdef\csname the#1\endcsname{\@thmcounter{#1}}%
   \expandafter\xdef\csname #1name\endcsname{#2}%
   \global\@namedef{#1}{\@thm{#1}{\csname #1name\endcsname}{#3}{#4}}%
                               \global\@namedef{end#1}{\@endtheorem}}}

\def\@othm#1[#2]#3#4#5{%
  \@ifundefined{c@#2}{\@latexerr{No theorem environment `#2'
  defined}\@eha}%
  {\expandafter\@ifdefinable\csname #1\endcsname
  {\global\@namedef{the#1}{\@nameuse{the#2}}%
  \expandafter\xdef\csname #1name\endcsname{#3}%
  \global\@namedef{#1}{\@thm{#2}{\csname #1name\endcsname}{#4}{#5}}%
  \global\@namedef{end#1}{\@endtheorem}}}}

\def\@thm#1#2#3#4{\refstepcounter
    {#1}\@ifnextchar[{\@ythm{#1}{#2}{#3}{#4}}{\@xthm{#1}{#2}{#3}{#4}}}

\def\@xthm#1#2#3#4{\@begintheorem{#2}{\csname the#1\endcsname}{#3}{#4}%
                    \ignorespaces}

\def\@ythm#1#2#3#4[#5]{\@opargbegintheorem{#2}{\csname
       the#1\endcsname}{#5}{#3}{#4}\ignorespaces}

\def\@begintheorem#1#2#3#4{\trivlist
                 \item[\hskip\labelsep{#3#1\ #2\@thmcounterend}]#4}

\def\@opargbegintheorem#1#2#3#4#5{\trivlist
      \item[\hskip\labelsep{#4#1\ #2\ (#3)\@thmcounterend}]#5}

% definition of \newtheorem* without number

\def\@sthm#1#2{\@Ynthm{#1}{#2}}

\def\@Ynthm#1#2#3#4{\expandafter\@ifdefinable\csname #1\endcsname
   {\global\@namedef{#1}{\@Thm{\csname #1name\endcsname}{#3}{#4}}%
    \expandafter\xdef\csname #1name\endcsname{#2}%
    \global\@namedef{end#1}{\@endtheorem}}}

\def\@Thm#1#2#3{\@ifnextchar[{\@Ythm{#1}{#2}{#3}}{\@Xthm{#1}{#2}{#3}}}

\def\@Xthm#1#2#3{\@Begintheorem{#1}{#2}{#3}\ignorespaces}

\def\@Ythm#1#2#3[#4]{\@Opargbegintheorem{#1}
       {#4}{#2}{#3}\ignorespaces}

\def\@Begintheorem#1#2#3{#3\trivlist
                           \item[\hskip\labelsep{#2#1\@thmcounterend}]}

\def\@Opargbegintheorem#1#2#3#4{#4\trivlist
      \item[\hskip\labelsep{#3#1\ (#2)\@thmcounterend}]}

% definition of divers theorem environments

\if@envcntsect
   \def\@thmcountersep{.}
   \newtheorem{theorem}{Theorem}[section]{\bf}{\it}
\else
   \newtheorem{theorem}{Theorem}{\bf}{\it}
   \if@envcntreset
      \@addtoreset{theorem}{section}
   \else
      \@addtoreset{theorem}{chapter}
   \fi
\fi
\newtheorem*{proof}{Proof}{\it}{\rm}
\newtheorem{corollary}[theorem]{Corollary}{\bf}{\it}
\newtheorem{definition}[theorem]{Definition}{\bf}{\rm}
\newtheorem{example}[theorem]{Example}{\it}{\rm}
\newtheorem{exercise}[theorem]{Exercise}{\it}{\rm}
\newtheorem{lemma}[theorem]{Lemma}{\bf}{\it}
\newtheorem{note}[theorem]{Note}{\it}{\rm}
\newtheorem{problem}[theorem]{Problem}{\it}{\rm}
\newtheorem{proposition}[theorem]{Proposition}{\bf}{\it}
\newtheorem{question}[theorem]{Question}{\it}{\rm}
\newtheorem{remark}[theorem]{Remark}{\it}{\rm}
\newtheorem{solution}[theorem]{Solution}{\it}{\rm}

\def\@takefromreset#1#2{%
    \def\@tempa{#1}%
    \let\@tempd\@elt
    \def\@elt##1{%
        \def\@tempb{##1}%
        \ifx\@tempa\@tempb\else
            \@addtoreset{##1}{#2}%
        \fi}%
    \expandafter\expandafter\let\expandafter\@tempc\csname cl@#2\endcsname
    \expandafter\def\csname cl@#2\endcsname{}%
    \@tempc
    \let\@elt\@tempd}

\def\theopargself{\def\@opargbegintheorem##1##2##3##4##5{\trivlist
      \item[\hskip\labelsep{##4##1\ ##2\ ##3}]##5}
                  \def\@Opargbegintheorem##1##2##3##4{##4\trivlist
      \item[\hskip\labelsep{##3##1\ ##2}]}
      }

\def\squareforqed{\hbox{\rlap{$\sqcap$}$\sqcup$}}
\def\qed{\ifmmode\else\unskip\quad\fi\squareforqed}
%
\newdimen\figgap\figgap=1cc
\long\def\@makesidecaption#1#2{%
   \parbox[b]{\@tempdima}{\captionstyle{\floatlegendstyle
                                         #1\floatcounterend}#2}}
\def\sidecaption#1\caption{%
\setbox\@tempboxa=\hbox{#1\unskip}%
\if@twocolumn
 \ifdim\hsize<\textwidth\else
   \ifdim\wd\@tempboxa<\columnwidth
      \typeout{Double column float fits into single column -
            ^^Jyou'd better switch the environment. }%
   \fi
 \fi
\fi
\@tempdima=\hsize
\advance\@tempdima by-\figgap
\advance\@tempdima by-\wd\@tempboxa
\ifdim\@tempdima<3cm
    \typeout{\string\sidecaption: No sufficient room for the legend;
             using normal \string\caption. }%
   \unhbox\@tempboxa
   \let\@capcommand=\@caption
\else
   \let\@capcommand=\@sidecaption
   \leavevmode
   \unhbox\@tempboxa
   \hfill
\fi
\refstepcounter\@captype
\@dblarg{\@capcommand\@captype}}

\long\def\@sidecaption#1[#2]#3{\addcontentsline{\csname
  ext@#1\endcsname}{#1}{\protect\numberline{\csname
  the#1\endcsname}{\ignorespaces #2}}\begingroup
    \@parboxrestore
    \@makesidecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
  \endgroup}
%
% Define \acknowledgements
\def\acknowledgements{\par\addvspace{6pt}\small\rm
\trivlist\item[\hskip\labelsep{\em Acknowledgements.\/}]}
\def\endacknowledgements{\endtrivlist\addvspace{6pt}}
%
\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}
\if@compatibility
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\z@
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
    }
\else
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\@ne
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
     \if@twoside\else
        \setcounter{page}\@ne
     \fi
    }
\fi
\newcommand\appendix{\par
\def\@seccntformat##1{\csname theap##1\endcsname\hskip\betweenumberspace}
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \setcounter{figure}{0}%
  \setcounter{table}{0}%
  \newcommand\theapsection{Appendix \@Alph\c@section:}%
  \newcommand\theapsubsection{\@Alph\c@section.\@arabic\c@subsection.}%
  \newcommand\theapsubsubsection{\theapsubsection\@arabic\c@subsubsection.}%
  \renewcommand\thesection{\@Alph\c@section}%
  \renewcommand\thesubsection{\@Alph\c@section.\@arabic\c@subsection}%
  \renewcommand\thesubsubsection{\thesubsection.\@arabic\c@subsubsection}%
  \renewcommand\theequation{\@Alph\c@section.\@arabic\c@equation}%
  \renewcommand\thefigure{\@Alph\c@section.\@arabic\c@figure}%
  \renewcommand\thetable{\@Alph\c@section.\@arabic\c@table}%
  \@addtoreset{equation}{section}%
  \@addtoreset{figure}{section}%
  \@addtoreset{table}{section}%
  \def\subfigures{\stepcounter{figure}\setcounter{auth}{\value{figure}}%
  \setcounter{figure}{0}%
  \def\thefigure{\@Alph\c@section\@arabic\c@auth\alph{figure}}%
  \def\resetsubfig{\setcounter{figure}{\value{auth}}}}}
%
\setlength\arraycolsep{2.5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand\theequation{\@arabic\c@equation}
\newcounter{figure}
\renewcommand\thefigure{\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename\,\thefigure}
\newenvironment{figure}
               {\@float{figure}}
               {\resetsubfig\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\resetsubfig\end@dblfloat}
\let\resetsubfig\relax
\def\subfigures{\stepcounter{figure}\setcounter{auth}{\value{figure}}%
\setcounter{figure}{0}\def\thefigure{\@arabic\c@auth\alph{figure}}%
\def\resetsubfig{\setcounter{figure}{\value{auth}}}}
\newcounter{table}
\renewcommand\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}

\def \@floatboxreset {%
        \reset@font
        \small
        \@setnobreak
        \@setminipage
}

\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\newcommand\leftlegendglue{}

\def\fig@type{figure}

\newdimen\figcapgap\figcapgap=5pt
\newdimen\tabcapgap\tabcapgap=10pt

\@ifundefined{floatlegendstyle}{\def\floatlegendstyle{\bf}}{}
\def\floatcounterend{.}

\long\def\@caption#1[#2]#3{\par\addcontentsline{\csname
  ext@#1\endcsname}{#1}{\protect\numberline{\csname
  the#1\endcsname}{\ignorespaces #2}}\begingroup
    \@parboxrestore
    \@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
  \endgroup}

\def\capstrut{\vrule\@width\z@\@height\topskip}
\@ifundefined{captionstyle}{\def\captionstyle{\normalfont\small}}{}

\long\def\@makecaption#1#2{%
 \ifx\@captype\fig@type
   \vskip\figcapgap
   \setbox\@tempboxa\hbox{{\floatlegendstyle #1\floatcounterend}
   \capstrut #2}%
   \ifdim \wd\@tempboxa >\hsize
     {\floatlegendstyle #1\floatcounterend} \capstrut #2\par
   \else
     \hbox to\hsize{\leftlegendglue\unhbox\@tempboxa\hfil}%
   \fi
 \else
   {\floatlegendstyle #1\floatcounterend} \capstrut #2\par
   \vskip\tabcapgap
 \fi}
% Define `acknowledgement' environment
\def\acknowledgement{\par\addvspace{17pt}\small\rm
\trivlist\item[\hskip\labelsep
{\it\ackname}]}
\def\endacknowledgement{\endtrivlist\addvspace{6pt}}
% Define `noteadd' environment
\def\noteadd{\par\addvspace{17pt}\small\rm
\trivlist\item[\hskip\labelsep
{\it\noteaddname}]}
\def\endnoteadd{\endtrivlist\addvspace{6pt}}

\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{3}
\newcommand\tableofcontents{%
    \section*{\contentsname
        \@mkboth{%
           \MakeUppercase\contentsname}{\MakeUppercase\contentsname}}%
    \@starttoc{toc}%
    }
\newcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty\@secpenalty
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \setlength\@tempdima{3em}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
       \if@compatibility
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
      \fi
    \endgroup
  \fi}
\newcommand*\l@section[2]{%
  \ifnum \c@tocdepth >\z@
    \addpenalty\@secpenalty
    \addvspace{1.0em \@plus\p@}%
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
    \endgroup
  \fi}
\newcommand*\l@subsection{\@dottedtocline{2}{1.5em}{2.3em}}
\newcommand*\l@subsubsection{\@dottedtocline{3}{3.8em}{3.2em}}
\newcommand*\l@paragraph{\@dottedtocline{4}{7.0em}{4.1em}}
\newcommand*\l@subparagraph{\@dottedtocline{5}{10em}{5em}}
\newcommand\listoffigures{%
    \section*{\listfigurename
      \@mkboth{\MakeUppercase\listfigurename}%
              {\MakeUppercase\listfigurename}}%
    \@starttoc{lof}%
    }
\newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand\listoftables{%
    \section*{\listtablename
      \@mkboth{%
          \MakeUppercase\listtablename}{\MakeUppercase\listtablename}}%
    \@starttoc{lot}%
    }
\let\l@table\l@figure
\newdimen\bibindent
\setlength\bibindent{\parindent}
\def\@biblabel#1{}
\def\@cite#1#2{{#1\if@tempswa , #2\fi}}
\newenvironment{thebibliography}[1]
     {\section*{{\normalsize\refname}
        \@mkboth{\refname}{\refname}}\small
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
           \leftmargin\bibindent
           \setlength{\itemindent}{-\leftmargin}
           \@openbib@code
           \usecounter{enumiv}%
           \let\p@enumiv\@empty
           \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy\clubpenalty4000\widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty
\newenvironment{theindex}
               {\if@twocolumn
                  \@restonecolfalse
                \else
                  \@restonecoltrue
                \fi
                \columnseprule \z@
                \columnsep 35\p@
                \twocolumn[\section*{\indexname}]%
                \@mkboth{\MakeUppercase\indexname}%
                        {\MakeUppercase\indexname}%
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \let\item\@idxitem}
               {\if@restonecol\onecolumn\else\clearpage\fi}
\newcommand\@idxitem{\par\hangindent 40\p@}
\newcommand\subitem{\@idxitem \hspace*{20\p@}}
\newcommand\subsubitem{\@idxitem \hspace*{30\p@}}
\newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}
\newcommand\@makefntext[1]{%
    \noindent
    \hb@xt@\bibindent{\hss\@makefnmark\enspace}#1}
%
\newcommand\listofobjects{\if@nyobjects
  \IfFileExists{\jobname.obj}%
               {\section*{\listobjectname}%
                \@starttoc{obj}}%
               {\begingroup
                   \makeatletter
                   \if@filesw
                      \newwrite\tf@obj
                      \immediate\openout\tf@obj\jobname.obj
                      \relax
                   \fi
                   \global\@nobreakfalse
                \endgroup}\fi
               }
%
\newcommand*\l@obj[2]{\noindent`#1' on page #2\par}
%
\DeclareRobustCommand{\object}[1]{#1\global\let\if@nyobjects\iftrue
\addcontentsline{obj}{obj}{#1}}
%
\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listobjectname{List of Objects}
\newcommand\listtablename{List of Tables}
\newcommand\refname{References}
\newcommand\indexname{Index}
\newcommand\figurename{Fig.}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract.}
\newcommand\ackname{Acknowledgements.}
\newcommand\noteaddname{Note added in proof}
\newcommand\today{}
\edef\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{4mm}
\setlength\columnseprule{0\p@}
\frenchspacing
\clubpenalty=10000
\widowpenalty=10000
\def\thisbottomragged{\def\@textbottom{\vskip\z@ plus.0001fil
\global\let\@textbottom\relax}}
\pagestyle{headings}
\pagenumbering{arabic}
\if@referee
  \setlength{\textwidth}{0.75\textwidth}
  \def\baselinestretch{1.5}
  \let\AALogo\relax
  \onecolumn
  \AtEndDocument{\listofobjects}%
\else
  \twocolumn
\fi
\sloppy
\flushbottom
\def\squareforqed{\hbox{\rlap{$\sqcap$}$\sqcup$}}
\def\sq{\ifmmode\squareforqed\else{\unskip\nobreak\hfil
\penalty50\hskip1em\null\nobreak\hfil\squareforqed
\parfillskip=0pt\finalhyphendemerits=0\endgraf}\fi}

\def\sun{\hbox{$\odot$}}
\def\la{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr<\cr\sim\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
<\cr\sim\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
<\cr\sim\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
<\cr\sim\cr}}}}}
\def\ga{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr>\cr\sim\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
>\cr\sim\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
>\cr\sim\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
>\cr\sim\cr}}}}}
\def\degr{\hbox{$^\circ$}}
\def\arcmin{\hbox{$^\prime$}}
\def\arcsec{\hbox{$^{\prime\prime}$}}
\def\utw{\smash{\rlap{\lower5pt\hbox{$\sim$}}}}
\def\udtw{\smash{\rlap{\lower6pt\hbox{$\approx$}}}}
\def\fd{\hbox{$.\!\!^{\rm d}$}}
\def\fh{\hbox{$.\!\!^{\rm h}$}}
\def\fm{\hbox{$.\!\!^{\rm m}$}}
\def\fs{\hbox{$.\!\!^{\rm s}$}}
\def\fdg{\hbox{$.\!\!^\circ$}}
\def\farcm{\hbox{$.\mkern-4mu^\prime$}}
\def\farcs{\hbox{$.\!\!^{\prime\prime}$}}
\def\fp{\hbox{$.\!\!^{\scriptscriptstyle\rm p}$}}
\def\cor{\mathrel{\mathchoice {\hbox{$\widehat=$}}{\hbox{$\widehat=$}}
{\hbox{$\scriptstyle\hat=$}}
{\hbox{$\scriptscriptstyle\hat=$}}}}
\def\sol{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr\sim\cr<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr\sim\cr
<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr\sim\cr
<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
\sim\cr<\cr}}}}}
\def\sog{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr\sim\cr>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr\sim\cr
>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
\sim\cr>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
\sim\cr>\cr}}}}}
\def\lse{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr<\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
<\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
<\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
<\cr\simeq\cr}}}}}
\def\gse{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr>\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
>\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
>\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
>\cr\simeq\cr}}}}}
\def\grole{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr>\cr\noalign{\vskip-1.5pt}<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
>\cr\noalign{\vskip-1.5pt}<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
>\cr\noalign{\vskip-1pt}<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
>\cr\noalign{\vskip-0.5pt}<\cr}}}}}
\def\leogr{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr<\cr\noalign{\vskip-1.5pt}>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
<\cr\noalign{\vskip-1.5pt}>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
<\cr\noalign{\vskip-1pt}>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
<\cr\noalign{\vskip-0.5pt}>\cr}}}}}
\def\loa{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr<\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
<\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
<\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
<\cr\approx\cr}}}}}
\def\goa{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr>\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
>\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
>\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
>\cr\approx\cr}}}}}
\def\diameter{{\ifmmode\mathchoice
{\ooalign{\hfil\hbox{$\displaystyle/$}\hfil\crcr
{\hbox{$\displaystyle\mathchar"20D$}}}}
{\ooalign{\hfil\hbox{$\textstyle/$}\hfil\crcr
{\hbox{$\textstyle\mathchar"20D$}}}}
{\ooalign{\hfil\hbox{$\scriptstyle/$}\hfil\crcr
{\hbox{$\scriptstyle\mathchar"20D$}}}}
{\ooalign{\hfil\hbox{$\scriptscriptstyle/$}\hfil\crcr
{\hbox{$\scriptscriptstyle\mathchar"20D$}}}}
\else{\ooalign{\hfil/\hfil\crcr\mathhexbox20D}}%
\fi}}

\def\getsto{\mathrel{\mathchoice {\vcenter{\offinterlineskip
\halign{\hfil
$\displaystyle##$\hfil\cr\gets\cr\to\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr\gets
\cr\to\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr\gets
\cr\to\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
\gets\cr\to\cr}}}}}
\def\lid{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr<\cr\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr<\cr
\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr<\cr
\noalign{\vskip1pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
<\cr
\noalign{\vskip0.9pt}=\cr}}}}}
\def\gid{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr>\cr\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr>\cr
\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr>\cr
\noalign{\vskip1pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
>\cr
\noalign{\vskip0.9pt}=\cr}}}}}
\def\bbbr{{\rm I\!R}} %reelle Zahlen
\def\bbbm{{\rm I\!M}}
\def\bbbn{{\rm I\!N}} %natuerliche Zahlen
\def\bbbf{{\rm I\!F}}
\def\bbbh{{\rm I\!H}}
\def\bbbk{{\rm I\!K}}
\def\bbbp{{\rm I\!P}}
\def\bbbone{{\mathchoice {\rm 1\mskip-4mu l} {\rm 1\mskip-4mu l}
{\rm 1\mskip-4.5mu l} {\rm 1\mskip-5mu l}}}
\def\bbbc{{\mathchoice {\setbox0=\hbox{$\displaystyle\rm C$}\hbox{\hbox
to0pt{\kern0.4\wd0\vrule height0.9\ht0\hss}\box0}}
{\setbox0=\hbox{$\textstyle\rm C$}\hbox{\hbox
to0pt{\kern0.4\wd0\vrule height0.9\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptstyle\rm C$}\hbox{\hbox
to0pt{\kern0.4\wd0\vrule height0.9\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptscriptstyle\rm C$}\hbox{\hbox
to0pt{\kern0.4\wd0\vrule height0.9\ht0\hss}\box0}}}}
\def\bbbq{{\mathchoice {\setbox0=\hbox{$\displaystyle\rm
Q$}\hbox{\raise
0.15\ht0\hbox to0pt{\kern0.4\wd0\vrule height0.8\ht0\hss}\box0}}
{\setbox0=\hbox{$\textstyle\rm Q$}\hbox{\raise
0.15\ht0\hbox to0pt{\kern0.4\wd0\vrule height0.8\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptstyle\rm Q$}\hbox{\raise
0.15\ht0\hbox to0pt{\kern0.4\wd0\vrule height0.7\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptscriptstyle\rm Q$}\hbox{\raise
0.15\ht0\hbox to0pt{\kern0.4\wd0\vrule height0.7\ht0\hss}\box0}}}}
\def\bbbt{{\mathchoice {\setbox0=\hbox{$\displaystyle\rm
T$}\hbox{\hbox to0pt{\kern0.3\wd0\vrule height0.9\ht0\hss}\box0}}
{\setbox0=\hbox{$\textstyle\rm T$}\hbox{\hbox
to0pt{\kern0.3\wd0\vrule height0.9\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptstyle\rm T$}\hbox{\hbox
to0pt{\kern0.3\wd0\vrule height0.9\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptscriptstyle\rm T$}\hbox{\hbox
to0pt{\kern0.3\wd0\vrule height0.9\ht0\hss}\box0}}}}
\def\bbbs{{\mathchoice
{\setbox0=\hbox{$\displaystyle     \rm S$}\hbox{\raise0.5\ht0\hbox
to0pt{\kern0.35\wd0\vrule height0.45\ht0\hss}\hbox
to0pt{\kern0.55\wd0\vrule height0.5\ht0\hss}\box0}}
{\setbox0=\hbox{$\textstyle        \rm S$}\hbox{\raise0.5\ht0\hbox
to0pt{\kern0.35\wd0\vrule height0.45\ht0\hss}\hbox
to0pt{\kern0.55\wd0\vrule height0.5\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptstyle      \rm S$}\hbox{\raise0.5\ht0\hbox
to0pt{\kern0.35\wd0\vrule height0.45\ht0\hss}\raise0.05\ht0\hbox
to0pt{\kern0.5\wd0\vrule height0.45\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptscriptstyle\rm S$}\hbox{\raise0.5\ht0\hbox
to0pt{\kern0.4\wd0\vrule height0.45\ht0\hss}\raise0.05\ht0\hbox
to0pt{\kern0.55\wd0\vrule height0.45\ht0\hss}\box0}}}}
\def\bbbz{{\mathchoice {\hbox{$\sf\textstyle Z\kern-0.4em Z$}}
{\hbox{$\sf\textstyle Z\kern-0.4em Z$}}
{\hbox{$\sf\scriptstyle Z\kern-0.3em Z$}}
{\hbox{$\sf\scriptscriptstyle Z\kern-0.2em Z$}}}}
\def\ts{\thinspace}
%
\uchyph=0
\endinput
%%
%% End of file `aa.cls'.
----------
X-Sun-Data-Type: default
X-Sun-Data-Name: paperV4.tex
X-Sun-Encoding-Info: uuencode
X-Sun-Content-Lines: 1312

begin 600 paperV4.tex
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""@HL
 
end
