%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                 %
%    This is a LaTeX class file called FBSart.CLS                 %
%                              (Version 1.0, April 10th, 1999)    %
%                                                                 %
%    Save this file under the name FBSart.cls into your LaTeX     %
%    input directory/folder. It will generate your documents in   %
%    the style required for FEW-BODY SYSTEMS.                     %
%    For further instructions see the manual that can be          %
%    generated by executing the source file EXAMPLE2.TEX.         %
%                                                                 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% based on
%  ARTICLE.CLS Version v1.3y [1998/05/05]
%  with size11.clo
%
% Adapted by
%    Gerhard A. Bachmaier
%    Department of Medical Informatics,
%    Statistics, and Documentation
%    University of Graz
%    Graz, Austria
%
%    for Springer-Verlag  Wien, New York
%
%    Please, send bug reports to:
%    bachmai@email.kfunigraz.ac.at
%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{FBSart}
              [1999/04/10 v1.0]
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
%
\newif\if@secnumeq \@secnumeqfalse
\newif\if@secnumfig \@secnumfigfalse
\newif\if@secnumtab \@secnumtabfalse
\newif\if@appnumeq \@appnumeqtrue
\newif\if@appnumfig \@appnumfigtrue
\newif\if@appnumtab \@appnumtabtrue
\DeclareOption{secnumeq}{\@secnumeqtrue}
\DeclareOption{secnumfig}{\@secnumfigtrue}
\DeclareOption{secnumtab}{\@secnumtabtrue}
\DeclareOption{appnumeq}{\@appnumeqfalse}
\DeclareOption{appnumfig}{\@appnumfigfalse}
\DeclareOption{appnumtab}{\@appnumtabfalse}
%
\DeclareOption{FBSmath}{\input{FBSmath.clo}}
\DeclareOption{ecsub}{\input{ecsub.clo}}
\DeclareOption{FBSedit}{\AtEndOfClass{\input{FBSedit.clo}}}
\DeclareOption{AMSsub}{\AtBeginDocument{%
\@ifundefined{leftrightarrows}{\input{AMSsub.clo}}{\relax}}}
\DeclareOption{allclo}{%
\input{FBSmath.clo}\input{ecsub.clo}
\AtEndOfClass{\input{FBSedit.clo}}
\AtBeginDocument{\@ifundefined{leftrightarrows}{\input{AMSsub.clo}}%
{\ClassWarning{FBSart}{AMSsymb definitions are active, AMSsub not loaded!}}}}
%
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \parindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}%
}
\AtBeginDocument{\@ifundefined{bm}%
{\@ifundefined{openone}{\relax}{%
\ClassWarning{FBSart}{bm.sty not found, bmsub will be used!}%
\input{bmsub.sty}}}{\relax}}
\ExecuteOptions{letterpaper,final}
\ProcessOptions
%
%  twoside+onecolumn are NO options
%
\@twosidetrue
\@mparswitchtrue
\@twocolumnfalse
%
%  11pt size commands; NO option
%
\renewcommand\normalsize{%
   \@setfontsize\normalsize\@xipt{13.6}%
   \abovedisplayskip 11\p@ \@plus3\p@ \@minus6\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6.5\p@ \@plus3.5\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\normalsize
\newcommand\small{%
   \@setfontsize\small\@xpt\@xiipt
   \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 6\p@ \@plus2\p@ \@minus2\p@
               \parsep 3\p@ \@plus2\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\newcommand\footnotesize{%
   \@setfontsize\footnotesize\@ixpt{11}%
   \abovedisplayskip 8\p@ \@plus2\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus\p@
   \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 4\p@ \@plus2\p@ \@minus2\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\newcommand\scriptsize{\@setfontsize\scriptsize\@viiipt{9.5}}
\newcommand\tiny{\@setfontsize\tiny\@vipt\@viipt}
\newcommand\large{\@setfontsize\large\@xiipt{14}}
\newcommand\Large{\@setfontsize\Large\@xivpt{18}}
\newcommand\LARGE{\@setfontsize\LARGE\@xviipt{22}}
\newcommand\huge{\@setfontsize\huge\@xxpt{25}}
\newcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
\setlength\parindent{17\p@}
\setlength\smallskipamount{3\p@ \@plus 1\p@ \@minus 1\p@}
\setlength\medskipamount{6\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\bigskipamount{12\p@ \@plus 4\p@ \@minus 4\p@}
\setlength\headheight{10\p@}
\setlength\headsep   {10\p@}
\setlength\topskip   {11\p@}
\setlength\footskip{0\p@}
\setlength\maxdepth{.5\topskip}
\setlength\textwidth{134mm}
\setlength\textheight{45\baselineskip}
\addtolength\textheight{\topskip}
\addtolength\textheight{11.5pt}% total \textheight=223mm
\setlength\marginparsep{11\p@}
\setlength\marginparpush{5\p@}
\setlength\oddsidemargin   {58\p@}
\setlength\evensidemargin  {58\p@}
\setlength\marginparwidth {100\p@}
\setlength\topmargin{30\p@}
\setlength\footnotesep{7.7\p@}
\setlength{\skip\footins}{10\p@ \@plus 4\p@ \@minus 2\p@}
\setlength\floatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\textfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\intextsep   {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dblfloatsep    {0\p@}
\setlength\dbltextfloatsep{0\p@}
\setlength\@fptop{0\p@ \@plus 1fil}
\setlength\@fpsep{8\p@ \@plus 2fil}
\setlength\@fpbot{0\p@ \@plus 1fil}
\setlength\@dblfptop{0\p@ \@plus 1fil}
\setlength\@dblfpsep{0\p@ \@plus 2fil}
\setlength\@dblfpbot{0\p@ \@plus 1fil}
\setlength\partopsep{3\p@ \@plus 1\p@ \@minus 1\p@}
\def\@listi{\leftmargin\leftmargini
            \parsep 4.5\p@ \@plus2\p@ \@minus\p@
            \topsep 9\p@   \@plus3\p@ \@minus5\p@
            \itemsep4.5\p@ \@plus2\p@ \@minus\p@}
\let\@listI\@listi
\@listi
\def\@listii {\leftmargin\leftmarginii
              \labelwidth\leftmarginii
              \advance\labelwidth-\labelsep
              \topsep    4.5\p@ \@plus2\p@ \@minus\p@
              \parsep    2\p@   \@plus\p@  \@minus\p@
              \itemsep   \parsep}
\def\@listiii{\leftmargin\leftmarginiii
              \labelwidth\leftmarginiii
              \advance\labelwidth-\labelsep
              \topsep    2\p@ \@plus\p@\@minus\p@
              \parsep    \z@
              \partopsep \p@ \@plus\z@ \@minus\p@
              \itemsep   \topsep}
\def\@listiv {\leftmargin\leftmarginiv
              \labelwidth\leftmarginiv
              \advance\labelwidth-\labelsep}
\def\@listv  {\leftmargin\leftmarginv
              \labelwidth\leftmarginv
              \advance\labelwidth-\labelsep}
\def\@listvi {\leftmargin\leftmarginvi
              \labelwidth\leftmarginvi
              \advance\labelwidth-\labelsep}
%
%  end of 11pt definitions
%
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{4}
\renewcommand\topfraction{.9}
\setcounter{bottomnumber}{4}
\renewcommand\bottomfraction{.9}
\setcounter{totalnumber}{8}
\renewcommand\textfraction{.1}
\renewcommand\floatpagefraction{.7}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}
%
\newcommand\SaveFinalPage{%
 \write\@mainaux{\string\SetFinalPage{\arabic{page}}}}
\newcommand\SetFinalPage[1]{\gdef\FinalPage{#1}}
\SetFinalPage{??}
\AtEndDocument{\SaveFinalPage}
\newcounter{volume}
\setcounter{volume}{0}
\newcommand\@year{\number\year}
\newcommand\FBSLogo{\unitlength=1mm
\begin{picture}(33,3)(0,20.5)\put(0,0){\line(1,0){33}}
\put(0,23.5){\line(1,0){33}}\put(16,17.5){\LARGE Few-}
\put(18,14){\Large Body}\put(13,10){\LARGE Systems}
\put(0,5){\hbox to 33mm{\tiny\copyright\ by Springer-Verlag \@year}}
\put(0,2.3){\tiny Printed in Austria}
\end{picture}} % end FBS-Logo
%
\mark{{}{}}
\def\ps@headings{%
  \let\@oddfoot\@empty\let\@evenfoot\@empty
  \def\@evenhead{\hbox{}{\normalfont\rmfamily\footnotesize%
   \thepage \hfil\leftmark}}%
  \def\@oddhead{\hbox{}{\normalfont\rmfamily\footnotesize%
   \rightmark\hfil\thepage}}%
}
\def\ps@myheadings{%
  \let\@oddfoot\@empty\let\@evenfoot\@empty
  \def\@evenhead{{\rmfamily\scriptsize Few-Body Systems\ %
   \thevolume, \thepage--\FinalPage\ (\@year)} \hfil \FBSLogo%
   \ClassWarning{FBSart}{First page of a contribution should be
    preferrably an ODD one!}}
  \def\@oddhead{{\rmfamily\footnotesize Few-Body Systems\ %
   \thevolume, \thepage--\FinalPage\ (\@year)} \hfil \FBSLogo
  \let\@mkboth\@gobbletwo}}
%
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}
\def\FBSfnsymbol#1{\@FBSfnsymbol{\@nameuse{c@#1}}}
\def\@FBSfnsymbol#1{\ifcase#1\or * \or ** \or *** \or \dagger \or %
\dagger\dagger \or \dagger\dagger\dagger \or \ddagger \or \ddagger\ddagger %
\or \ddagger\ddagger\ddagger \else\@ctrerr\fi\relax}
\newcounter{thanks}
\newlength\@fnindent
\newcommand\get@fnindent{%
\ifnum \value{thanks} <3 \setlength{\@fnindent}{.4em} \else%
  \ifnum \value{thanks} <5 \setlength{\@fnindent}{.8em} \else%
    \ifnum \value{thanks} <7 \setlength{\@fnindent}{1.2em} \else%
      \ifnum \value{thanks} <9 \setlength{\@fnindent}{1.6em} \else%
        \setlength{\@fnindent}{2em}%
\fi\fi\fi\fi}
\long\def\@makefntext#1{\@setpar{\get@fnindent\@@par\@tempdima \hsize
  \advance\@tempdima-\@fnindent\parshape \@ne \@fnindent \@tempdima}\par
  \parindent 0pt\noindent
            \hbox to\z@{\hss$\m@th{}^{\@thefnmark}$}#1}
\newcounter{instnum}
\setcounter{instnum}{1}
\renewcommand\theinstnum{\arabic{instnum}}
\newif\if@singleinst \@singleinsttrue
\newcommand\instnr[1]{${}^{#1}$}
\newcommand\thanksnr[1]{\footnotemark[#1]}
\newcommand\comma{${}^,$}
\newcommand\institute[1]{\gdef\@institute{#1}}
\newcommand\instlist[1]{\gdef\@instlist{#1\@singleinstfalse}}

\newcommand\@checkinst{%
\@ifundefined{@institute}{\@singleinstfalse}{\@singleinsttrue}}
\newlength{\@tablength}
\setlength{\@tablength}{129mm}
\renewcommand\and{%
\end{tabular}\par\noindent\vspace{1pt}\addtocounter{instnum}{1}%
\begin{tabular}[t]{@{}p{2mm}@{\,}p{\@tablength}}\hfil${}^{\theinstnum}$&%
}
\newif\if@runa \@runafalse
\newif\if@runt \@runtfalse
\def\runningauthor#1{\gdef\@runningauthor{#1}\@runatrue}
\def\runningtitle#1{\gdef\@runningtitle{#1}\@runttrue}
\def\@runningauthor{Running author(s) undefined!}
\def\@runningtitle{Running title undefined!}
%
\newcommand\maketitle{\par
 \begingroup
   \renewcommand\thefootnote{\FBSfnsymbol{footnote}}%
   \def\@makefnmark{${}^{\@thefnmark}$}%
     \newpage
     \global\@topnum\z@
     \@maketitle
     \setcounter{thanks}{\value{footnote}}
     \thispagestyle{myheadings}\@thanks
 \endgroup
 \setcounter{footnote}{0}%
 \global\let\thanks\relax
 \global\let\maketitle\relax
 \global\let\@maketitle\relax
 \global\let\@thanks\@empty
 \global\let\@author\@empty
 \global\let\@date\@empty
 \global\let\@title\@empty
 \global\let\@institute\@empty
 \global\let\@instlist\@empty
 \global\let\title\relax
 \global\let\author\relax
 \global\let\date\relax
 \global\let\and\relax
 \if@runa
    \setbox0=\hbox{\@runningauthor}
    \ifdim\wd0>127mm\ClassWarning{FBSart}{Running author(s) too %
    long!}\else\relax\fi
 \else
    \ClassWarning{FBSart}{Running author(s) undefined!}
 \fi
 \if@runt
    \setbox0=\hbox{\@runningtitle}
    \ifdim\wd0>127mm\ClassWarning{FBSart}{Running title too %
    long!}\else\relax\fi
 \else
    \ClassWarning{FBSart}{Running title undefined!}
 \fi
 \mark{{\@runningtitle}{\@runningauthor}}
 }
%
\def\@maketitle{%
  \newpage
  \null
  \vskip 17mm%
  \begin{flushleft}%
  {\LARGE \bfseries\@title \par}%
  \vskip 8mm
  \normalsize
   \@author \par\vskip 5mm\noindent
   \@checkinst
   \footnotesize
   \if@singleinst%
     \@institute\par\end{flushleft}%
   \else
     \end{flushleft}
     \footnotesize
     \begin{tabular}[t]{@{}p{2mm}@{\,}p{\@tablength}}\hfil${}^1$&\@instlist
     \end{tabular}\par%
   \fi
  \vskip 4.5mm plus 0.3mm minus 0.3mm}
%
\setcounter{secnumdepth}{3}
\newcounter {part}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand \thepart {\@Roman\c@part}
\renewcommand \thesection {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection .\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
\newcommand\part{\par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}
\newif\if@appendix
\@appendixfalse
\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont\rmfamily
     \ifnum \c@secnumdepth >\m@ne
       \Large\bfseries \partname~\thepart
       \par\nobreak
     \fi
     \huge \bfseries #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 5ex
    \@afterheading}
\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont\rmfamily
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}
\renewcommand\@seccntformat[1]{{\csname the#1\endcsname}\hspace{0.5em}}
\if@appendix
\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\normalfont\small\bfseries}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\small\slshape}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\small}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\normalfont\normalsize}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                       {\normalfont\small}}
\else
\newcommand\section{\@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\normalfont\normalsize\bfseries}}
\newcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\normalsize\slshape}}
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\normalsize}}
\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\normalfont\normalsize}}
\newcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                       {\normalfont\normalsize}}
\fi
\setlength\leftmargini  {2.5em}
\leftmargin  \leftmargini
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\setlength\leftmarginv  {1em}
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}
\newenvironment{abstract}
               {\normalfont\normalsize\list{}{\listparindent 5mm%
                        \itemindent    \listparindent
                        \leftmargin    \listparindent
                        \parsep        \z@ \@plus\p@}%
                \item\relax\noindent{\bfseries \abstractname.}}
               {\endlist\par\vskip 1mm plus 2mm minus 1mm
                \normalfont\normalsize}
\newenvironment{acknowledge}
               {\par\vskip2ex\normalfont\footnotesize
                \noindent \textit{Acknowledgement.}}
               {\par\vskip1ex}
\newenvironment{acknowledgemore}
               {\par\vskip2ex\normalfont\footnotesize
                \noindent \textit{Acknowledgements.}}
               {\par\vskip1ex}
\newenvironment{noteadded}
               {\par\vskip3ex\normalfont\small
               \noindent \textbf{Note Added in Proof}
               \par\normalfont\footnotesize\noindent}
               {\par\vskip1ex}
%
\newcommand\appendix{\par\vskip 3ex plus 1ex minus 3ex%
  \@appendixtrue
  \@afterindentfalse
  \setcounter{section}{0}%
  \setcounter{subsection}{0}
  \setcounter{subsubsection}{0}
  \setcounter{figure}{0}
  \setcounter{table}{0}%
  \renewcommand\thesection{Appendix \Alph{section}:}
  \renewcommand\thesubsection{\Alph{section}.\arabic{subsection}}
  \renewcommand\thesubsubsection{\thesubsection.\arabic{subsubsection}}
  \renewcommand\theequation@prefix{\Alph{section}.}
  \renewcommand\thefigure@prefix{\Alph{section}.}
  \renewcommand\thetable@prefix{\Alph{section}.}
  \if@appnumeq%
    \@secnumeqtrue\@addtoreset{equation}{section}
    \else\@secnumeqfalse\fi
  \if@appnumfig%
    \@secnumfigtrue\@addtoreset{figure}{section}
    \else\@secnumfigfalse\fi
  \if@appnumtab%
   \@secnumtabtrue\@addtoreset{table}{section}
   \else\@secnumtabfalse\fi
  \footnotesize
}
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
%
\newcommand\theequation@prefix\@empty
\if@secnumeq %
  \@addtoreset{equation}{section} %
  \renewcommand\theequation@prefix{\arabic{section}.}
\fi
\renewcommand\theequation{\theequation@prefix\arabic{equation}}%
\newcounter{figure}
\newcommand\thefigure@prefix\@empty
\if@secnumfig %
  \@addtoreset{figure}{section} %
  \renewcommand\thefigure@prefix{\arabic{section}.} %
\fi
\renewcommand \thefigure {\thefigure@prefix\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}
\newcommand\thetable@prefix\@empty
\if@secnumtab %
  \@addtoreset{table}{section} %
  \renewcommand\thetable@prefix{\arabic{section}.} %
\fi
\renewcommand\thetable{\thetable@prefix\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}
%
\newcommand{\beforetab}{\setbox0=\hbox\bgroup\footnotesize}
\newcommand{\aftertab}{\egroup}
\def\captionaftertab[#1]#2{\parbox{\wd0}{\caption[#1]{#2}}\par\copy0}
%\def\preline{\\[-10.3pt]}             %  for \normalsize tables
%\def\postline{\\[-9.5pt]}             %  for \normalsize tables
\def\preline{\\[-8pt]}                 %  for \footnotesize tables
\def\postline{\\[-6pt]}                %  for \footnotesize tables
\def\firsthline{\hline\postline}
\def\midhline{\preline\hline\postline}
\def\lasthline{\preline\hline}
\def\tabstrut{\rule[-3mm]{0mm}{8mm}}
\newcounter{skippage}
\newcounter{temp@page}
\newcounter{temp@figure}
\newcounter{temp@table}
\newcounter{temp@float}
\newcommand\emptyfloatpages[3]{%
 \if #1+#2<1
  \ClassError{FBSart}{No floats selected, command ignored!}{}\relax
 \else
 \if #3<1
   \ClassWarning{FBSart}{Number of empty pages reset to one!}%
   \setcounter{skippage}{1}\else\setcounter{skippage}{#3}\fi
   \ClassInfo{FBSart}{There will be #1 skipped figures.}
   \ClassInfo{FBSart}{There will be #2 skipped tables.}
   \ClassInfo{FBSart}{There will be #3 skipped pages.}
   \setcounter{temp@page}{\thepage}
   \setcounter{temp@figure}{\value{figure}}
   \setcounter{temp@table}{\value{table}}
   \addtocounter{figure}{#1}
   \addtocounter{table}{#2}
   \loop\ifnum\value{skippage}>0 \@emptyfloat\advance\value{skippage}-1\repeat
 \fi}
\newcommand\@emptyfloat{\begin{figure}[p]\vspace*{180mm}\end{figure}}
\newcommand{\floatf}{f}
\newcommand{\floatt}{t}
\newcommand{\addlabel}[4]{% used for \label in \emptyfloat!
\addtocounter{temp@page}{#4}
\setcounter{temp@float}{#3}
\if #2\floatf
  \addtocounter{temp@figure}{\value{temp@float}}
  \def\thetemp@figure{\thefigure@prefix\arabic{temp@figure}}
  \write\@auxout{\string\newlabel{#1}%
  {{\thetemp@figure}{\thetemp@page}}}
\else
  \if #2\floatt
    \addtocounter{temp@table}{\value{temp@float}}
    \def\thetemp@table{\thetable@prefix\arabic{temp@table}}
    \write\@auxout{\string\newlabel{#1}%
    {{\thetemp@table}{\thetemp@page}}}
  \else
     \ClassError{FBSart}{Wrong float type, no label generated!}{}
  \fi
\fi} %
%
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{5\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\normalfont\footnotesize {\bfseries #1.} #2}%
  \ifdim \wd\@tempboxa >\hsize
    {\normalfont\footnotesize {\bfseries #1.} #2}\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{3}
\newcommand\tableofcontents{%
    \section*{\contentsname}
    \@starttoc{toc}%
    }
\newcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty\@secpenalty
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
       \if@compatibility
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
      \fi
    \endgroup
  \fi}
\newcommand*\l@section[2]{%
  \ifnum \c@tocdepth >\z@
    \addpenalty\@secpenalty
    \addvspace{1.0em \@plus\p@}%
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
    \endgroup
  \fi}
\newcommand*\l@subsection{\@dottedtocline{2}{1.5em}{2.3em}}
\newcommand*\l@subsubsection{\@dottedtocline{3}{3.8em}{3.2em}}
\newcommand*\l@paragraph{\@dottedtocline{4}{7.0em}{4.1em}}
\newcommand*\l@subparagraph{\@dottedtocline{5}{10em}{5em}}
\newcommand\listoffigures{%
    \section*{\listfigurename}
    \@starttoc{lof}%
    }
\newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand\listoftables{%
    \section*{\listtablename}
    \@starttoc{lot}%
    }
\let\l@table\l@figure
\newdimen\bibindent
\setlength\bibindent{1.5em}
\newenvironment{thebibliography}[1]
     {\@appendixtrue\section*{\refname}
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty
\def\@biblabel#1{#1.}
% \received#1 can be used at the end of the bibliography
%             environment to insert publication information.
%             There is NO FIX TEXT.
%             Don't forget \end{bibliography} as closing environment.
\def\received#1{\vspace{3mm}%
\hspace*{-\labelwidth}\hspace*{-\labelsep}\normalfont\footnotesize #1}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\refname{References}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract}
\def\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagestyle{headings}
\pagenumbering{arabic}
\frenchspacing
%
\providecommand{\AMS}{{\protect\the\textfont2
A\kern-.1667em\lower.5ex\hbox{M}\kern-.125emS}\,}
\providecommand{\AMSTeX}{\AMS\TeX}
\font \Logo=logo10 scaled \magstep1
\providecommand{\Metafont}{%
{\Logo META}\-{\Logo FONT}}
\endinput
%
% End of file `FBSart.cls'.
%
