%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Name:     ifae.mod.cls                                             %
%                                                                 %
%  Purpose:  Use LaTeX parameters for IFAE 2004 proceedings, with some modifications.      %
%            (N. Amapane  --> M.Cirelli)                                         %
%                                                                 %
%  Portions taken from cmspaper.cls, G. Wrochna (CERN)            %
%                                                                 %   
%                                                                 %
%  Last mod : 02.10.2004                                          %
%                                                                 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\fileversion{0.1}\def\filedate{1 Apr. 2004}
\typeout{IFAE 2004 proceedings style, Version <\fileversion>, <\filedate>}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{ifae}[2004/04/01]
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass{article}
 
% Page size
\setlength{\hoffset}{-1in}
\setlength{\voffset}{-1in}
\setlength{\oddsidemargin}{25mm}
\setlength{\evensidemargin}{25mm}
\setlength{\marginparwidth}{25mm}
\setlength{\marginparsep}{\baselineskip}
\setlength{\topmargin}{20mm}
\setlength{\headheight}{0mm}
\setlength{\headsep}{0mm}
\setlength{\footskip}{9mm}
\setlength{\textwidth}{16cm}
\ifcase \@ptsize
\setlength{\textheight}{57\baselineskip}
\or
\setlength{\textheight}{51\baselineskip}
\or 
\setlength{\textheight}{46\baselineskip}
\fi
\addtolength{\textheight}{\topskip}

% Floats
\renewcommand{\topfraction}{1.0}
\renewcommand{\dbltopfraction}{1.0}
\renewcommand{\bottomfraction}{1.0}
\renewcommand{\textfraction}{0.2}
\setlength{\intextsep}{6pt}
\setlength{\floatsep}{6pt}
\setlength{\textfloatsep}{6pt}
\setlength{\dblfloatsep}{6pt}
\setlength{\dbltextfloatsep}{6pt}

% Nonindented paragraphs
\setlength{\parindent}{0pt}
\setlength{\parskip}{0.5\baselineskip}
 
% Sectioning
\def\section{\@startsection {section}{1}{\z@}%
{ 1\baselineskip plus  .5\baselineskip minus  .25\baselineskip}%
{+0.1pt plus +0.1pt minus +0.1pt}{\reset@font\Large\bfseries}}
 
\def\subsection{\@startsection{subsection}{2}{\z@}%
{ 1\baselineskip plus  .5\baselineskip minus  .25\baselineskip}%
{+0.1pt plus +0.1pt minus +0.1pt}{\reset@font\large\bfseries}}
 
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}%
{ 1\baselineskip plus  .5\baselineskip minus  .25\baselineskip}%
{+0.1pt plus +0.1pt minus +0.1pt}{\reset@font\normalsize\bfseries}}

% Fonts
  \renewcommand{\sfdefault}{phv}        % sansserif  = helvetica
  \renewcommand{\rmdefault}{ptm}        % roman      = times
  \renewcommand{\ttdefault}{pcr}        % typewriter = courier

% Footnotes
\def\footnoterule{\kern-3\p@
 \hrule width .4\columnwidth
 \kern 2.6\p@} 
 
% Prevent using \maketitle
\def\maketitle{
\typeout{Warning: Please do not use \maketitle! Use the header environment instead.}
}

% Definition of environment "header"
\def\header{\clearpage%
\setcounter{footnote}{0}\thispagestyle{empty}
{ astro-ph/0410122 \hfill} %Incontri sulla fisica delle alte energie \hfill Torino, April 14-16, 2004}
\vspace*{5mm}
}

% Collaboration
\def\collaboration#1{\begin{center}{\bfseries\itshape#1}\end{center}}

% Title
\def\title#1{\begin{center}\vskip1.5cm{\huge\sf#1}\vskip1.5em\end{center}}

% Author
\def\@makefnmark{\hbox{$^{\@thefnmark)}$}}
\def\author#1{%
\setcounter{footnote}{0}\def\@currentlabel{}%
\begingroup\def\thefootnote{\arabic{footnote}}
\def\@makefnmark{\hbox{$^{\rm\@thefnmark)}$}}
\global\@topnum\z@ \begin{center}{\lineskip.5em
\begin{tabular}[t]{c}#1\end{tabular}\par}
\end{center}\par\vskip1.5em
\@thanks\endgroup}

% Environment for the list of authors
\newenvironment{Authlist}{\begin{center}}{\end{center}}%

% Affiliation
\@ifundefined{c@instfoot}{\newcounter{instfoot}}{}
\def\Iref#1{$^{\Inst{#1})}$}   \let\Instref=\Iref
\def\Inst#1{\@ifundefined{r@#1}{{\bf ??}}%
{\edef\@tempa{\@nameuse{r@#1}}\expandafter\@car\@tempa \@nil\null}}
\def\IIref#1#2{$^{\Inst{#1},\Inst{#2})}$}  \let\InstInstref=\IIref
\def\IIIref#1#2#3{$^{\Inst{#1},\Inst{#2},\Inst{#3})}$}


\def\Affiliation#1#2{\def\@temp{Authlist}%
    \refstepcounter{instfoot}\label{#1}%
    {\small\it\arabic{instfoot}. #2 }% \\[2ex]%
}

% Footnote comment for authors (acknowledgements, etc.)
\@ifundefined{mathrm}{\newcommand{\mathrm}[1]{{\rm#1}}}{}
\def\Acknow#1{$^{\mathrm{#1})}$} \let\Anotref=\Acknow
\def\Acknowfoot#1#2{\xdef\@thefnmark{#1}\@footnotetext{#2}}

% Abstract
\def\abstract{
\quotation\noindent%
\setlength{\parindent}{0pt}%
\setlength{\parskip}{0.5\baselineskip}%
\ignorespaces {\bf Abstract ---}}
\def\endabstract{\endquotation\par}


\RequirePackage{graphics}
\RequirePackage{epsfig}
 
\endinput
