% Document style 'thesis', created from 11pt report style by
% P. Croyden Nov 1992 changed to .cls on June 1998. Deleted Theorem command.
% LAST CHANGE 21 JULY 1998
%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{thesis}[1998/06/05]
\typeout{Document Class 'thesis'. Released Nov 1992/ Jun 1998}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% ONLY 11pt as in sxthesis.sty
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand\@ptsize{1}
\newif\if@restonecol
\newif\if@titlepage
\newif\if@openright
\@titlepagetrue
\@openrightfalse
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt} \@drafttrue}
\DeclareOption{openright}{\@openrighttrue}
%\DeclareOption{fleqn}{\input{myfleqn.clo}}
\ProcessOptions
%\RequirePackage{fancyheadings}
\RequirePackage{fancyhdr}
%% THIS WILL PROBABLY DEFINE THE SIZES [CHG]
\input{size1\@ptsize.clo}
\setcounter{topnumber}{2}
\renewcommand\topfraction{.7}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.3}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}

\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
% Defines the labels for itemize
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
%...........
\newenvironment{verse}
               {\baselineskip 2.5ex
                \let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\baselineskip 2.5ex
                \list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\newenvironment{quote}
               {\baselineskip 2.5ex
                \list{}{\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}
%%%%%
%%%%%
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
%% ??????
% \newdimen\descriptionmargin  %%% [CHG]
% \descriptionmargin=3em
%%%%%%%%%%%
%%
%%  removed the theorem environment  [CHG]
%%
%%%%%%%%%%%
%
\newcommand{\clearemptydoublepage}{\newpage{\pagestyle{empty}\cleardoublepage}}
\if@compatibility
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\z@
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
    }
\else
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\@ne
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
     \if@twoside\else
        \setcounter{page}\@ne
     \fi
    }
\fi
%
%
% \prepage is to be a numbered \titlepage
\if@compatibility
\newenvironment{prepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{plain}%
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
    }
\else
\newenvironment{prepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \if@openright
        \clearemptydoublepage
      \fi
      \thispagestyle{plain}%
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
    }
\fi

\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}

\newcounter{part}
\newcounter {chapter}
\newcounter {section}[chapter]
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand \thepart {\@Roman\c@part}
\renewcommand \thechapter {\@arabic\c@chapter}
\renewcommand \thesection {\thechapter.\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection .\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
\newcommand\@chapapp{\chaptername}
%
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{2}

\newcommand\tableofcontents{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \clearpage
    \chapter*{\contentsname}%
    \pagestyle{fancy}\thispagestyle{plain}
    %format fancy headings
    \addtolength{\headwidth}{\marginparsep}%
    \addtolength{\headwidth}{\marginparwidth}%
    \markboth{\contentsname}{}
    \if@twoside
       \lhead[\fancyplain{}{\bfseries\thepage}]%
             {\fancyplain{}{\bfseries\leftmark}}%
             \rhead[\fancyplain{}{\bfseries\leftmark}]%
             {\fancyplain{}{\bfseries\thepage}}%
       \cfoot{}
    \else
       \lhead[\fancyplain{}{\bfseries\leftmark}]%
             {\fancyplain{}{\bfseries\leftmark}}%
       \rhead[\fancyplain{}{\bfseries\thepage}]%
             {\fancyplain{}{\bfseries\thepage}}%
       \cfoot{}
    \fi
    \thispagestyle{plain}
    \@starttoc{toc}%
    \if@restonecol\twocolumn\fi
    }
    
\newcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{-\@highpenalty}%
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \setlength\@tempdima{3em}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large  #1 \hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}% %%%%[CHG]
    \endgroup
  \fi}

\newcommand*\l@chapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 1.0em \@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi}

\newcommand*\l@section{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand*\l@subsection{\@dottedtocline{2}{3.8em}{3.2em}}
\newcommand*\l@subsubsection{\@dottedtocline{3}{7.0em}{4.1em}}
\newcommand*\l@paragraph{\@dottedtocline{4}{10em}{5em}}
\newcommand*\l@subparagraph{\@dottedtocline{5}{12em}{6em}}
\newcommand\listoffigures{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \clearpage
    \chapter*{\listfigurename}%
    \pagestyle{fancy}\thispagestyle{plain}
    %format fancy headings
    \addtolength{\headwidth}{\marginparsep}%
    \addtolength{\headwidth}{\marginparwidth}%
    \markboth{\listfigurename}{}
    \if@twoside
       \lhead[\fancyplain{}{\bfseries\thepage}]%
             {\fancyplain{}{\bfseries\leftmark}}%
       \rhead[\fancyplain{}{\bfseries\leftmark}]%
             {\fancyplain{}{\bfseries\thepage}}%
       \cfoot{}
    \else
       \lhead[\fancyplain{}{\bfseries\leftmark}]%
             {\fancyplain{}{\bfseries\leftmark}}%
       \rhead[\fancyplain{}{\bfseries\thepage}]%
             {\fancyplain{}{\bfseries\thepage}}%
       \cfoot{}
    \fi
    \@starttoc{lof}%
    \if@restonecol\twocolumn\fi
    }
\newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand\listoftables{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \clearpage
    \chapter*{\listtablename}%
    \pagestyle{fancy}\thispagestyle{plain}
    %format fancy headings
    \addtolength{\headwidth}{\marginparsep}%
    \addtolength{\headwidth}{\marginparwidth}%
    \markboth{\listtablename}{}
    \if@twoside
       \lhead[\fancyplain{}{\bfseries\thepage}]%
             {\fancyplain{}{\bfseries\leftmark}}%
       \rhead[\fancyplain{}{\bfseries\leftmark}]%
             {\fancyplain{}{\bfseries\thepage}}%
       \cfoot{}
    \else
       \lhead[\fancyplain{}{\bfseries\leftmark}]%
             {\fancyplain{}{\bfseries\leftmark}}%
       \rhead[\fancyplain{}{\bfseries\thepage}]%
             {\fancyplain{}{\bfseries\thepage}}%
       \cfoot{}
    \fi
    \@starttoc{lot}%
    \if@restonecol\twocolumn\fi
    %RTRT
    \clearpage
    %RTRT to have a clear page afterwards
    }
\let\l@table\l@figure
%
% NOT EXACTLY THE SAME.......[CHG]
%  for the bibliography...
\newdimen\bibindent
\setlength\bibindent{1.5em}
\newenvironment{thebibliography}[1]
      {\chapter*{\bibname
        \@mkboth{\bibname}{\bibname}}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty
% WHAT IS THIS FOR ???? -> [CHG]  \newif\if@restonecol
%%%% [CHG] maybe MakeUppercase in the first indexname ???
\newenvironment{theindex}
               {\if@twocolumn
                  \@restonecolfalse
                \else
                  \@restonecoltrue
                \fi
                \columnseprule \z@
                \columnsep 35\p@
                \twocolumn[\@makeschapterhead{\indexname}]%
                \@mkboth{\indexname}%
                        {\indexname}%
                \thispagestyle{empty}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \let\item\@idxitem}
               {\if@restonecol\onecolumn\else\clearpage\fi}
\newcommand\@idxitem{\par\hangindent 40\p@}
\newcommand\subitem{\@idxitem \hspace*{20\p@}}
\newcommand\subsubitem{\@idxitem \hspace*{30\p@}}
\newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}

\renewcommand\footnoterule{%
  \kern-1\p@
  \hrule\@width.4\columnwidth
  \kern .6\p@}
\@addtoreset{footnote}{chapter}

\newcommand\@makefntext[1]{%
              \@setpar{\@@par\@tempdima \hsize
              \advance\@tempdima-10pt\parshape \@ne 10pt \@tempdima}\par
              \parindent 1em\noindent \hbox to \z@{\hss\@makefnmark}#1}
\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\bibname{Bibliography}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{PART}
\newcommand\chaptername{Chapter}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract}
\newcommand\today{}
\edef\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}

\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1: #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1: #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}


\newcounter{figure}[chapter]
\renewcommand \thefigure
     {\ifnum \c@chapter>\z@ \thechapter.\fi \@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}

\newcounter{table}[chapter]
\renewcommand \thetable
     {\ifnum \c@chapter>\z@ \thechapter.\fi \@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}


% The declarations for the titlepage, abstract etc.

\newcommand\maketitle{\begin{titlepage} \rm
\let\footnotesize\small \let\footnoterule\relax \setcounter{page}{0}
\null
\begin{center}
{\large Universit\'e de Gen\`eve}
\end{center}
\vskip 60pt \begin{center}
{\LARGE \bf \@title \par} \vskip 4.5em {\large \bf \lineskip .75em
\begin{tabular}[t]{c}\@author \\
{\normalsize \em \mdseries Departement de Physique Th\'eorique}
\end{tabular}\par}

%\vskip 15em {\em Submitted for the degree of \@qualification \par}
%\vskip 15em {\em Submitted for the degree \mbox{of } \@qualification \par}

\vskip 1.5em {\em \@date \par} \end{center} \par
\@thanks
\vfil
\null
\end{titlepage}
\setcounter{footnote}{0} \let\thanks\relax
\gdef\@thanks{}\let\maketitle\relax}

\newcommand\abstract{
\newcommand\oldbaselineskip{\baselineskip}
\prepage
\addcontentsline{toc}{chapter}{Abstract}
\null
\begin{center} \rm
{\large Universit\'e de Gen\`eve} \par
\vskip 4ex
\textbf{\Large \@title} \par
\vskip 1ex
\textbf{\large \@author} \par
\vskip 1.5ex

{\em Submitted for the degree of \@qualification} \par
% {\em Submitted for the degree \mbox{of } \@qualification} \par

{\em \@date} \par
\vskip 3ex
{\LARGE \bfseries Abstract}
\end{center}
\baselineskip 2.5ex}
\def\endabstract{\baselineskip\oldbaselineskip\gdef\@author{}\gdef\@title{}
\par\vfil\null\endprepage}

% Initially the pagenumbering should be roman
\pagenumbering{roman}

% The following command resets the pagenumbering style and
% the value of the pagenumber.
%
\if@twoside
  \newcommand{\headform}{\addtolength{\headwidth}{\marginparsep}%
     \addtolength{\headwidth}{\marginparwidth}%
     \renewcommand{\chaptermark}[1]{\markboth{##1}{\@chapapp\ \thechapter}}%
     \renewcommand{\sectionmark}[1]{\markright{\thesection\ ##1}}%
     \lhead[\fancyplain{}{\bfseries\thepage}]%
           {\fancyplain{}{\bfseries\rightmark}}%
     \rhead[\fancyplain{}{\bfseries\leftmark}]%
           {\fancyplain{}{\bfseries\thepage}}%
     \cfoot{}
     }
\else
  \newcommand{\headform}{\addtolength{\headwidth}{\marginparsep}%
     \addtolength{\headwidth}{\marginparwidth}%
     \renewcommand{\chaptermark}[1]{\markboth{##1}{}}%
     \renewcommand{\sectionmark}[1]{\markboth{\thesection\ ##1}{}}%
     \lhead[\fancyplain{}{\bfseries\leftmark}]%
           {\fancyplain{}{\bfseries\leftmark}}%
     \rhead[\fancyplain{}{\bfseries\thepage}]%
           {\fancyplain{}{\bfseries\thepage}}%
     \cfoot{}
     }
\fi
%
\newcommand\starttext{\clearpage\pagenumbering{arabic}
     \pagestyle{fancy}
     \headform
     }

\newcommand\acknowledgments{\prepage \rm
%RTRT
%\addcontentsline{toc}{chapter}{Ackowledgments}
%RTRT
\null\vspace*{50pt}
\begin{center}
{\LARGE \bfseries Acknowledgments}
\end{center}}
\let\endacknowledgments\endprepage

\newcommand\declaration{\prepage \rm
\addcontentsline{toc}{chapter}{Declaration}
\null\vspace*{50pt}
\begin{center}
{\LARGE \bfseries Declaration}
\end{center}}
\let\enddeclaration\endprepage

% Titlepage etc ends here

\ps@plain \onecolumn \if@twoside\else\raggedbottom\fi

\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{1.5}

%%%%%%%% DELETE ????? [CHG]
%\def\@normalsize{\@setsize\normalsize{13.6pt}\xipt\@xipt
%\setlength\abovedisplayskip{11\p@ \@plus 3\p@ \@minus 6\p@}
%\setlength\belowdisplayskip{\abovedisplayskip}
%\setlength\abovedisplayshortskip{\z@ \@plus 3\p@}
%\setlength\belowdisplayshortskip{6.5\p@ \@plus 3.5\p@ \@minus 3\p@}
%
%\def\small{\@setsize\small{12pt}\xpt\@xpt
%\abovedisplayskip 10pt plus2pt minus5pt\belowdisplayskip \abovedisplayskip
%\abovedisplayshortskip \z@ plus3pt\belowdisplayshortskip 6pt plus3pt minus3pt
%\def\@listi{\topsep 6pt plus 2pt minus 2pt\parsep 3pt plus 2pt minus 1pt
%\itemsep \parsep}}
%\def\footnotesize{\@setsize\footnotesize{11pt}\ixpt\@ixpt
%\abovedisplayskip 8pt plus 2pt minus 4pt\belowdisplayskip \abovedisplayskip
%\abovedisplayshortskip \z@ plus 1pt\belowdisplayshortskip 4pt plus 2pt minus
%2pt
%\def\@listi{\topsep 4pt plus 2pt minus 2pt\parsep 2pt plus 1pt minus 1pt
%\itemsep \parsep}}
%\def\scriptsize{\@setsize\scriptsize{9.5pt}\viiipt\@viiipt}
%\def\tiny{\@setsize\tiny{7pt}\vipt\@vipt}
%\def\large{\@setsize\large{14pt}\xiipt\@xiipt}
%\def\Large{\@setsize\Large{18pt}\xivpt\@xivpt}
%\def\LARGE{\@setsize\LARGE{22pt}\xviipt\@xviipt}
%\def\huge{\@setsize\huge{25pt}\xxpt\@xxpt}
%\def\Huge{\@setsize\Huge{30pt}\xxvpt\@xxvpt}
\normalsize

\if@twoside
      \setlength\oddsidemargin{12mm}
      \setlength\evensidemargin{-5mm}      %{0\p@}
      \setlength\marginparwidth{0\p@}
    \else
      \setlength\oddsidemargin{18mm}
      \setlength\evensidemargin{18mm}
      \setlength\marginparwidth{0pt}
\fi
\setlength\marginparsep{0pt}
\setlength\topmargin{0pt}
\setlength\headheight{14pt}
%\setlength\headsep{3ex}
\setlength\footskip{30pt}
\setlength\textheight{23.5cm}
\setlength\textwidth{15.4cm}
\setlength\columnsep{10pt}
\setlength\columnseprule{0pt}
\setlength\footnotesep{12pt}
\setlength{\skip\footins}{6pt plus 2pt minus 2pt}
\setlength\floatsep{12pt plus 2pt minus 2pt}
\setlength\textfloatsep{20pt plus 2pt minus 4pt}
\setlength\intextsep{12pt plus 2pt minus 2pt}
\setlength\dblfloatsep{12pt plus 2pt minus 2pt}
\setlength\dbltextfloatsep{20pt plus 2pt minus 4pt}
\setlength\@fptop{0pt plus 1fil}
\setlength\@fpsep{8pt plus 2fil}
\setlength\@fpbot{0pt plus 1fil}
\setlength\@dblfptop{0pt plus 1fil}
\setlength\@dblfpsep{8pt plus 2fil}
\setlength\@dblfpbot{0pt plus 1fil}
\setlength\marginparpush{5pt}

% only want month and year
\renewcommand{\today}{
\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi,
  \space \number\year}

\setlength\parskip{0pt plus 1pt}
\setlength\parindent{15pt}
\setlength\topsep{9pt plus 3pt minus 5pt}
\setlength\partopsep{3pt plus 1pt minus 2pt}
\setlength\itemsep{4.5pt plus 2pt minus 1pt}
\@lowpenalty 51 \@medpenalty 151 \@highpenalty 301
\@beginparpenalty -\@lowpenalty \@endparpenalty -\@lowpenalty \@itempenalty
-\@lowpenalty

%RTRT
\newcommand{\PBS}[1]{\let\temp=\\#1\let\\=\temp}

\def\part{\clearemptydoublepage \thispagestyle{empty} \if@twocolumn \onecolumn
\@tempswatrue \else \@tempswafalse \fi \hbox{}\vfil \bgroup \centering
\secdef\@part\@spart}
\def\@part[#1]#2#3#4#5{\ifnum \c@secnumdepth >-2\relax \refstepcounter{part}
\addcontentsline{toc}{part}{\thepart \hspace{1em}#1}\else
\addcontentsline{toc}{part}{#1}\fi \markboth{}{}
%\ifnum \c@secnumdepth >-2\relax \Large \rm Part \thepart \par \vskip 20pt \fi
%\Large \rm #1 \@endpart}
%RTRT begin
\normalsize \begin{tabular}{p{3cm} >{\normalsize} p{7cm}}
 & #3 \\
 & \hspace{2cm} \\ 
 & \PBS\raggedleft\hspace{0pt} #4 \\
 & \PBS\raggedleft\hspace{0pt} #5
\end{tabular} 
\par 
\ifnum \c@secnumdepth >-2\relax \vspace*{\stretch{1}} \Large \rm Part \thepart \par \vskip 20pt \fi
\Large \rm #1 
\vspace*{\stretch{2}}
\@endpart}
%RTRT end
\def\@endpart{\par\egroup \vfil\newpage \if@twoside \hbox{}
\thispagestyle{empty}
\newpage
\fi \if@tempswa \twocolumn \fi}
\def\@spart#1{\Large \rm #1\@endpart}
%\def\@makechapterhead#1{ \vspace*{50pt} {\centering \ifnum
%\c@secnumdepth >\m@ne \rm \large \@chapapp{} \thechapter \par
%\vskip 15pt \fi \large \rm #1\par
%\nobreak \vskip 40pt } }
\newcommand{\@makechapterhead}[1]{%
  \vspace*{1.32cm}%
  {\parindent\z@ \raggedleft \normalfont
    \ifnum \c@secnumdepth >\m@ne
        \huge\textbf{\@chapapp{}} \Huge\textbf{\thechapter}
        \par\nobreak
        \vskip 1.2ex
    \fi
    \interlinepenalty\@M
    \Huge\bfseries #1\par\nobreak
    \vskip 1ex
    \rule{\linewidth}{0.2mm}%
    \vskip 15\p@
  }}
%\def\@makeschapterhead#1{ \vspace*{50pt} {\centering \rm \large #1\par
%\nobreak \vskip 40pt } }
\newcommand{\@makeschapterhead}[1]{%
  \vspace*{1.32cm}%
  {\parindent \z@ \raggedleft
    \normalfont
    \interlinepenalty\@M
    \Huge\bfseries #1\par\nobreak
    \vskip 1ex
    \rule{\linewidth}{0.2mm}%
    \vskip 15\p@
  }}

\newcommand\chapter{
\clearpage
\if@openright\clearemptydoublepage\fi
\thispagestyle{empty} \global\@topnum\z@
\@afterindentfalse \secdef\@chapter\@schapter}
\def\@chapter[#1]#2{\ifnum \c@secnumdepth >\m@ne
                        \refstepcounter{chapter}
                        \typeout{\@chapapp\space\thechapter.}
                        \addcontentsline{toc}{chapter}{\protect
                                   \numberline{\thechapter}#1}
                     \else
                        \addcontentsline{toc}{chapter}{#1}%
                     \fi
\chaptermark{#1}
\addtocontents{lof}{\protect\addvspace{10pt}}
\addtocontents{lot}{\protect\addvspace{10pt}}
\if@twocolumn
\@topnewpage[\@makechapterhead{#2}]
\else \@makechapterhead{#2}
\@afterheading \fi}
\newcommand\@schapter[1]{\markboth{#1}{#1}
  \addcontentsline{toc}{chapter}{#1}%
  \if@twocolumn \@topnewpage[\@makeschapterhead{#1}]
  \else \@makeschapterhead{#1}
  \@afterheading\fi}

\newcommand{\section}{\@startsection {section}{1}{\z@}{-3.5ex plus -1ex minus
-.2ex}{2.3ex plus .2ex}{\Large \rm \bfseries}}
\newcommand{\subsection}{\@startsection{subsection}{2}{\z@}{-3.25ex plus -1ex minus
-.2ex}{1.5ex plus .2ex}{\large \rm \bf}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}{-3.25ex plus
-1ex minus -.2ex}{1.5ex plus .2ex}{\normalsize \rm \bf}}
\def\paragraph{\@startsection
{paragraph}{4}{\z@}{3.25ex plus 1ex minus .2ex}{-1em}{\normalsize \rm}}
\def\subparagraph{\@startsection
{subparagraph}{4}{\parindent}{3.25ex plus 1ex minus
.2ex}{-1em}{\normalsize \rm}}
\setcounter{secnumdepth}{2}
\def\appendix{\par
\setcounter{chapter}{0}
\setcounter{section}{0}
\def\@chapapp{Appendix}
\def\thechapter{\Alph{chapter}}}

\leftmargini 2.5em
\leftmarginii 2.2em \leftmarginiii 1.87em \leftmarginiv 1.7em \leftmarginv 1em
\leftmarginvi 1em
\leftmargin\leftmargini
\labelwidth\leftmargini\advance\labelwidth-\labelsep
\labelsep .5em
\parsep 4.5pt plus 2pt minus 1pt
\def\@listi{\leftmargin\leftmargini}
\def\@listii{\leftmargin\leftmarginii
\labelwidth\leftmarginii\advance\labelwidth-\labelsep
\topsep 4.5pt plus 2pt minus 1pt
\parsep 2pt plus 1pt minus 1pt
\itemsep \parsep}
\def\@listiii{\leftmargin\leftmarginiii
\labelwidth\leftmarginiii\advance\labelwidth-\labelsep
\topsep 2pt plus 1pt minus 1pt
\parsep \z@ \partopsep 1pt plus 0pt minus 1pt
\itemsep \topsep}
\def\@listiv{\leftmargin\leftmarginiv
\labelwidth\leftmarginiv\advance\labelwidth-\labelsep}
\def\@listv{\leftmargin\leftmarginv
\labelwidth\leftmarginv\advance\labelwidth-\labelsep}
\def\@listvi{\leftmargin\leftmarginvi
\labelwidth\leftmarginvi\advance\labelwidth-\labelsep}



\newtheorem{thm}{\sc Theorem.}[section]
\newtheorem{lem}[thm]{\sc Lemma.}
\newtheorem{prop}[thm]{\sc Proposition.}
\newtheorem{defn}[thm]{\sc Definition.}
\newtheorem{conj}[thm]{\sc Conjecture.}
\newtheorem{example}[thm]{\sc Example.}

\@addtoreset{thm}{chapter}

% Set up the proof and claim environments.

\def\proof{\trivlist \item[\hskip \labelsep{\sc Proof.}]}
\let\endproof\endtrivlist
\def\claim{\trivlist \item[\hskip \labelsep{\sc Claim}]}
\let\endclaim\endtrivlist

\def\qualification#1{\gdef\@qualification{#1}}

% These are the new table of contents definitions

\def\insertline#1#2{\ifnum 1>\c@tocdepth \else
\vskip \z@ plus .2pt
{\hangindent 0pt\relax \rightskip \@tocrmarg \parfillskip -\rightskip
\parindent 0pt\relax\@afterindenttrue
\interlinepenalty\@M
\leavevmode
\@tempdima 2.3em\relax
#1\leaders\hbox{$\m@th \mkern \@dotsep mu.\mkern \@dotsep mu$}\hfill
\hbox to2em{\hfil\rm #2}\par}\fi}

\def\appendices{\pagebreak[3]
\vskip 1.0em plus 1pt \@tempdima 1.5em \begingroup
\parindent \z@
{\normalsize \rm \mbox{APPENDICES}}\hfil\par
\endgroup}

\@addtoreset{equation}{chapter}
\def\theequation{\thechapter.\arabic{equation}}

\newfont{\mytt}{cmtt10}

\def\program#1{\par\vspace{\topskip}\begingroup\@goprog\input#1
  \vspace{\topskip}\endgroup}
\def\@goprog{\mytt\baselineskip 2.5ex
  \def\par{\leavevmode\endgraf} \catcode`\`=\active
  \obeylines \let\do\@makeother \dospecials \obeyspaces}
{\obeyspaces\global\let =\ }
{\catcode`\`=\active\gdef`{\relax\lq}}
