\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{epl}[2002/03/06 v0.9.4 Europhysics Letters class]
%
% stefano@sif.it
%

%
% flags %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newif\ifepl@hyper\epl@hyperfalse
\newif\ifepl@preprint\epl@preprintfalse
\newif\ifepl@gotshorttitle\epl@gotshorttitlefalse
\newif\ifepl@gotshortauthor\epl@gotshortauthorfalse
\newif\ifepl@book\epl@bookfalse
\newif\ifepl@figures\epl@figuresfalse
\newif\ifepl@overfull\epl@overfullfalse
\newif\ifepl@cite\epl@citefalse
\newif\ifepl@bm\epl@bmfalse
\newif\ifepl@issuetoc\epl@issuetocfalse
\newif\ifepl@indices\epl@indicesfalse
\newif\ifepl@volpacsindex\epl@volpacsindexfalse
\newif\ifepl@volalphaindex\epl@volalphaindexfalse
\newif\ifepl@info\epl@infofalse
\newif\ifepl@forth\epl@forthfalse
\newif\ifepl@erratum\epl@erratumfalse
\newif\ifepl@comment\epl@commentfalse
\newif\ifepl@reply\epl@replyfalse
\newif\ifepl@addendum\epl@addendumfalse
%
% class options %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\DeclareOption{nohyper}{%
  \typeout{hyper style: no hyper}
  \epl@hyperfalse
}
\DeclareOption{hyper}{%
  \typeout{hyper style: hyperTeX}%
  \PassOptionsToPackage{hypertex}{hyperref}%
  \epl@hypertrue
}
\DeclareOption{pdf}{%
  \typeout{hyper style: pdf}%  
  \PassOptionsToPackage{dvips}{hyperref}%
  \epl@hypertrue
}
\DeclareOption{preprint}{%
  \typeout{epl preprint}%
  \epl@preprinttrue
}
\DeclareOption{published}{%
  \epl@preprintfalse
}
\DeclareOption{debug}{%
  \setcounter{errorcontextlines}{99}%
}
\DeclareOption{overfull}{%
  \epl@overfulltrue
}
\DeclareOption{figures}{%
  \epl@figurestrue
}
\DeclareOption{nofigures}{%
  \epl@figuresfalse
}
\DeclareOption{cite}{%
  \epl@citetrue
}
\DeclareOption{nocite}{%
  \epl@citefalse
}
\DeclareOption{bm}{%
  \epl@bmtrue
}
\DeclareOption{nobm}{%
  \epl@bmfalse
}
\DeclareOption{issuetoc}{%
  \epl@issuetoctrue
}
\DeclareOption{indices}{%
  \epl@indicestrue
}
\DeclareOption{volpacsindex}{%
  \epl@volpacsindextrue
}
\DeclareOption{volalphaindex}{%
  \epl@volalphaindextrue
}
\DeclareOption{info}{%
  \epl@infotrue
}
\DeclareOption{forth}{%
  \epl@forthtrue
}
\DeclareOption{erratum}{%
  \epl@erratumtrue
}
\DeclareOption{comment}{%
  \epl@commenttrue
}
\DeclareOption{reply}{%
  \epl@replytrue
}
\DeclareOption{addendum}{%
  \epl@addendumtrue
}
\ExecuteOptions{nohyper,preprint,figures,cite,bm}
\ProcessOptions\relax
%
% modules %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\LoadClass[b5paper,twoside]{article}
\ifepl@hyper\RequirePackage{hyperref}\fi
\ifepl@figures\RequirePackage{graphicx}\fi
\ifepl@bm\RequirePackage{bm}\else\let\bm\mathbf\fi
\ifepl@cite
  \RequirePackage{cite}%
  \renewcommand{\citeleft}{\bgroup\normalfont[}%
  \renewcommand{\citeright}{]\egroup}%
\fi
%
% ??? %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\ifepl@overfull
  \setlength{\overfullrule}{5pt}%
\fi
%
% ??? %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newcounter{epl@tmpcnt@a}
%
% page dimensions %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% textwidth, textheight %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\setlength\textwidth{14.3cm}
\@settopoint\textwidth
\setlength\textheight{48\baselineskip}
\addtolength\textheight{\topskip}
%
% oddsidemargin, evensidemargin, marginparwidth, %%%%%%%%%%%%%%%%%%%%%%%%%%
% topmargin                                      %%%%%%%%%%%%%%%%%%%%%%%%%%
%
\setlength\oddsidemargin{2cm}
\setlength\evensidemargin{\paperwidth}
\addtolength\evensidemargin{-\textwidth}
\addtolength\evensidemargin{-\oddsidemargin}
\addtolength\oddsidemargin{-1in}
\addtolength\evensidemargin{-1in}
\setlength\marginparwidth{1cm}
\setlength\topmargin{1.5cm}
\addtolength\topmargin{-1in}
\@settopoint\oddsidemargin
\@settopoint\marginparwidth
\@settopoint\evensidemargin
\@settopoint\topmargin
%
% titlepage %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newlength{\epl@titleindent}
\setlength\epl@titleindent{9mm}
%
% titlepage style %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\DeclareTextCommandDefault{\textcopyright}{\textcircled{\sffamily c}}
\def\ps@epl@titlepage{%
   \def\@oddfoot{%
      \vbox to0pt{%
         \vspace{-20pt}%
         \noindent\hbox{\footnotesize\copyright\ EDP Sciences}%
         \vfill
      }%
   }%
   \let\@evenfoot\@empty%
   \let\@evenhead\@empty%
   \def\@oddhead{\epl@banner}%
   \let\@mkboth\@gobbletwo
   \let\sectionmark\@gobble
   \let\subsectionmark\@gobble
}
%
% banner (issue) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newcommand{\issue}[5]{%
   \def\epl@banner{\epl@banner@makeup{#1}{#2}{#3}{#4}{#5}}%
}
\ifepl@preprint
   \def\epl@banner@makeup#1#2#3#4#5{%
      Europhysics Letters\hfill\textsf{PREPRINT}%
   }
\else
   \def\epl@banner@makeup#1#2#3#4#5{%
      \ifepl@hyper\else\let\realpageref\pageref\fi
      \raisebox{-18pt}[0pt][0pt]{%
        \makebox[0pt][l]{%
          \textit{Europhys.\ Lett.}, \textbf{#1} (#2), 
          \xdef\epl@tmp@a{\realpageref{epl@first@page}}%
          \xdef\epl@tmp@b{\realpageref{epl@last@page}}%
          \ifx\epl@tmp@a\epl@tmp@b
            p.\ \realpageref{epl@first@page}%
          \else
            pp.\ \realpageref{epl@first@page}--\realpageref{epl@last@page}%
          \fi
          \ (#3)%
        }%
      }%
      \ifepl@erratum
        \raisebox{-36pt}[0pt][0pt]{%
          \makebox[0pt][l]{\textit{Erratum}}%
        }%
      \fi
      \ifepl@addendum
        \raisebox{-36pt}[0pt][0pt]{%
          \makebox[0pt][l]{\textit{Addendum}}%
        }%
      \fi
      \ifepl@comment
        \raisebox{-36pt}[0pt][0pt]{%
          \makebox[0pt][l]{\textit{Comment}}%
        }%
      \fi
      \ifepl@reply
        \raisebox{-36pt}[0pt][0pt]{%
          \makebox[0pt][l]{\textit{Reply}}%
        }%
      \fi
      {\footnotesize EUROPHYSICS LETTERS}\hfill#5%
      \setcounter{page}{#4}%
   }
   \AtBeginDocument{\label{epl@first@page}}%
   \AtEndDocument{\label{epl@last@page}}%
\fi
\def\epl@banner{%
   \epl@banner@makeup{\ClassWarningNoLine{epl}{No volume/issue data}???}
                     {???}{???}{1}{???}%
}
\def\epl@shortbanner{{\scriptsize EUROPHYSICS LETTERS}}
%
% title %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\renewcommand{\title}[1]{%
  \def\epl@title{\epl@title@makeup{#1}}%
  \ifepl@gotshorttitle\else
    \def\epl@shorttitle{\epl@shorttitle@makeup{#1}}%
  \fi
}
\def\epl@title{\epl@title@makeup{\ClassWarningNoLine{epl}{No title}???}}
\def\epl@title@makeup#1{{\Large\bfseries #1\par}}
\newcommand{\shorttitle}[1]{%
   \def\epl@shorttitle{\epl@shorttitle@makeup{#1}}%
   \epl@gotshorttitletrue
}
\def\epl@shorttitle{%
   \epl@shorttitle@makeup{%
      \ClassWarningNoLine{epl}{No short title}%
      ???%
      \gdef\epl@shorttitle{\epl@shorttitle@makeup{???}}%
   }%
}
\def\epl@shorttitle@makeup#1{%
   \let\thanks\@gobble
   \let\footnote\@gobble
   \textsc{#1}%
}
%
% author %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newcommand{\etal}{\unskip\ \emph{et al.}}
\renewcommand{\author}[1]{%
  \def\epl@author{\epl@author@makeup{#1}}%
  \ifepl@gotshortauthor\else
    \def\epl@shortauthor{\epl@shortauthor@makeup{#1}}%
  \fi
}
\def\epl@author{\epl@author@makeup{\ClassWarningNoLine{epl}{No author}???}}
\def\epl@author@makeup#1{%
  \setcounter{epl@cnt@and}{0}
  \def\inst##1{\unskip\hspace{1pt}\nolinebreak${}^{##1}$}%
  \def\[##1]{\inst{##1}}%
  \renewcommand{\and}{%
    \unskip
    \stepcounter{epl@cnt@and}%
    \epl@and{\theepl@cnt@and}%
    \
  }%
  {\scshape #1}\par
  \epl@writeaux@cnt@and{\theepl@cnt@and}%
}
\newcommand{\shortauthor}[1]{%
  \def\epl@shortauthor{\epl@shortauthor@makeup{#1}}%
  \epl@gotshortauthortrue
}
\def\epl@shortauthor{%
  \epl@shortauthor@makeup{%
     \ClassWarningNoLine{epl}{No short author}%
     ???%
     \gdef\epl@shortauthor{\epl@shortauthor@makeup{???}}%
  }%
}
\def\epl@shortauthor@makeup#1{%
  \setcounter{epl@cnt@and}{0}%
  \let\thanks\@gobble
  \let\footnote\@gobble
  \let\inst\@gobble
  \def\[##1]{\inst{##1}}%
  \renewcommand{\and}{%
    \unskip
    \stepcounter{epl@cnt@and}%
    \epl@and{\theepl@cnt@and}%
    \
  }%
  {\scshape\small #1}%
}
\newcounter{epl@cnt@and}
\setcounter{epl@cnt@and}{0}
\newcounter{epl@cnt@and@aux}
\setcounter{epl@cnt@and@aux}{0}
\def\epl@and#1{\ifnum#1<\theepl@cnt@and@aux,\else{\normalfont\ and}\fi}
\def\epl@writeaux@cnt@and#1{%
  \protected@write\@auxout{}{%
    \string\setcounter{epl@cnt@and@aux}{#1}%
  }%
}
%
% institute %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%\let\inst\@gobble
\newcommand{\institute}[1]{\def\epl@institute{\epl@institute@makeup{#1}}}
\def\epl@institute{%
   \epl@institute@makeup{\ClassWarningNoLine{epl}{No institute}???}%
}
\def\epl@institute@makeup#1{%
  \def\inst##1{\unskip${}^{##1}$\hspace{0.5em}\ignorespaces}%
  \def\[##1]{\inst{##1}}%
  {\itshape #1}\par
}
%
% received-accepted %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newcommand{\rec}[2]{\def\epl@received{\epl@received@makeup{#1}{#2}}}
\newcommand{\recff}[2]{%
   \def\epl@received{\epl@received@makeup{#1}{in final form #2}}%
}
\def\epl@received{%
   \epl@received@makeup{\ClassWarningNoLine{epl}
                                           {No received/accepted dates}???}
                       {???}%
}
\ifepl@preprint
   \def\epl@received@makeup#1#2{}
\else
   \def\epl@received@makeup#1#2{(received #1; accepted #2)\par}
\fi
%
% erratumof %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newcommand{\erratumof}[5]{%
  \def\epl@erratumof{\epl@erratumof@makeup{#1}{#2}{#3}{#4}{#5}}%
}
\def\epl@erratumof{%
   \epl@erratumof@makeup{%
     \ClassWarningNoLine{epl}{Missing erratumof}???%
   }{???}{???}{???}%
}
\def\epl@erratumof@makeup#1#2#3#4#5{%
  (\textit{Europhys.\ Lett.}, \textbf{#1} (#2),\
  \xdef\epl@tmp@a{#3}%
  \xdef\epl@tmp@b{#4}%
  \ifx\epl@tmp@a\epl@tmp@b p.\ #3\else pp.\ #3--#4\fi\ (#5))\par
}%
%
% addendumof %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newcommand{\addendumof}[5]{%
  \def\epl@addendumof{\epl@addendumof@makeup{#1}{#2}{#3}{#4}{#5}}%
}
\def\epl@addendumof{%
   \epl@addendumof@makeup{%
     \ClassWarningNoLine{epl}{Missing addendumof}???%
   }{???}{???}{???}%
}
\def\epl@addendumof@makeup#1#2#3#4#5{%
  (\textit{Europhys.\ Lett.}, \textbf{#1} (#2),\
  \xdef\epl@tmp@a{#3}%
  \xdef\epl@tmp@b{#4}%
  \ifx\epl@tmp@a\epl@tmp@b p.\ #3\else pp.\ #3--#4\fi\ (#5))\par
}%
%
% PACS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newlength{\epl@pacs@indent}
\setlength{\epl@pacs@indent}{18.3ex}
\newcommand{\pacs}[2]{%
  \def\epl@pacs@warning{}
  \protected@xdef\epl@pacs{\epl@pacs\epl@pacs@markup{#1}{#2}}%
}
\def\epl@pacs@warning{\ClassWarningNoLine{epl}{No PACS}}
\def\epl@pacs{\epl@pacs@warning}
\def\epl@pacs@markup#1#2{%
  \bgroup
    \setlength\parindent{-\epl@pacs@indent}%
    \addtolength\leftskip{\epl@pacs@indent}%
    \small
    \protect\makebox[\epl@pacs@indent]{PACS.\ \texttt{#1}\hfill\ --\ }%
    #2.%
    \par
  \egroup
}
%
% titlepage footnotes %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\epl@titlefnmark{%
   \ifcase\thefootnote
      \or{*}\or{*}{*}\or{*}{*}{*}\or
      {*}\protect\raisebox{-0.8ex}[0pt][0pt]{%
            \protect\makebox[0pt][c]{$\scriptstyle{*}$}%
         }{*}\or
      \protect\raisebox{-0.8ex}[0pt][0pt]{%
        \protect\makebox{$\scriptstyle{*}$}%
        \protect\raisebox{0.8ex}[0pt][0pt]{\protect\makebox[0pt][c]{$\scriptstyle{*}$}}%
        \protect\makebox{$\scriptstyle{*}$}%
      }%
   \fi
}
\newenvironment{fnmark}[1]{%
  \setcounter{epl@tmpcnt@a}{\thefootnote}%
  \def\@makefnmark{#1}%
}{%
  \setcounter{footnote}{\theepl@tmpcnt@a}%
}
\newcommand{\deceased}{\begin{fnmark}{\ensuremath{^\dagger}}\footnote{Deceased.}\end{fnmark}}
%
% titlepage shrinking/enlarging %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newlength{\epl@title@skip}
\newlength{\epl@author@skip}
\newlength{\epl@inst@skip}
\newlength{\epl@received@skip}
\newlength{\epl@pacs@skip}
\newlength{\epl@abstract@skip}
\newlength{\epl@text@skip}
\setlength{\epl@title@skip}{2pc plus0pc minus0pc}
\setlength{\epl@author@skip}{1pc plus2pt minus1pt}
\setlength{\epl@inst@skip}{3pt plus2pt minus1pt}
\setlength{\epl@received@skip}{1pc plus2pt minus1pt}
\setlength{\epl@pacs@skip}{1pc plus2pt minus1pt}
\setlength{\epl@abstract@skip}{3pc plus6pt minus3pt}
\setlength{\epl@text@skip}{3pc plus6pt minus3pt}
\newlength{\epl@tmplen@a}
\newcommand{\shrinkfirstpage}[1]{%
  \setlength{\epl@tmplen@a}{\baselineskip}%
  \multiply\epl@tmplen@a #1
  \ifnum#1>4
    \divide\epl@tmplen@a 14
    \addtolength{\epl@author@skip}{-\epl@tmplen@a}%
 %   \addtolength{\epl@inst@skip}{-\epl@tmplen@a}%
    \addtolength{\epl@received@skip}{-\epl@tmplen@a}%
    \addtolength{\epl@pacs@skip}{-\epl@tmplen@a}%
    \addtolength{\epl@abstract@skip}{-6\epl@tmplen@a}%
    \addtolength{\epl@text@skip}{-5\epl@tmplen@a}%
  \else
    \divide\epl@tmplen@a 2
    \addtolength{\epl@abstract@skip}{-\epl@tmplen@a}%
    \addtolength{\epl@text@skip}{-\epl@tmplen@a}%
  \fi
}
\newcommand{\enlargefirstpage}[1]{%
  \setlength{\epl@tmplen@a}{\baselineskip}%
  \multiply\epl@tmplen@a #1
  \ifnum#1>4
    \divide\epl@tmplen@a 14
    \addtolength\epl@author@skip{\epl@tmplen@a}%
    \addtolength\epl@inst@skip{\epl@tmplen@a}%
    \addtolength\epl@received@skip{\epl@tmplen@a}%
    \addtolength\epl@pacs@skip{\epl@tmplen@a}%
    \addtolength\epl@abstract@skip{5\epl@tmplen@a}%
    \addtolength\epl@text@skip{5\epl@tmplen@a}%
  \else
    \divide\epl@tmplen@a 2
    \addtolength\epl@abstract@skip{\epl@tmplen@a}%
    \addtolength\epl@text@skip{\epl@tmplen@a}%
  \fi
}
%
% maketitle %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\renewcommand{\maketitle}{%
  \thispagestyle{epl@titlepage}
  \begingroup
    \let\thanks\footnote
    \setcounter{footnote}{0}%
    \def\@makefnmark{\ensuremath{(^{\epl@titlefnmark})}}%
    \def\@makefntext##1{%
      \parindent 1em%
      \noindent
      \hb@xt@2.3em{\hss\@makefnmark} ##1%
    }
    \parindent=0pt
    \ifepl@info\epl@jobinfo\par\fi
    \vspace*{\epl@title@skip}
    \epl@title
    \vspace{\epl@author@skip}
    \bgroup
      \leftskip=\epl@titleindent
      \epl@author
      \vspace{\epl@inst@skip}
      \epl@institute
      \vspace{\epl@received@skip}
      \ifepl@erratum
        \epl@erratumof
      \else
        \ifepl@addendum
          \epl@addendumof
        \else
          \epl@received
        \fi
      \fi
      \vspace{\epl@pacs@skip}
      \epl@pacs
      \vspace{\epl@abstract@skip}
    \egroup
  \endgroup
  \@topnum=0
  \setcounter{footnote}{0}%
}
%
% abstract
%
\def\epl@abstract@name{\noindent\textbf{Abstract.} -- }
\def\epl@abstract@makeup{\small\leftskip=\epl@titleindent}
\renewenvironment{abstract}{%
  \epl@abstract@makeup
  \epl@abstract@name
}{%
  \par
  \vspace{\epl@text@skip}
}
%
% pagestyle %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\ps@epl@empty{%
  \let\@oddfoot\@empty
  \let\@evenfoot\@empty
  \let\@oddhead\@empty
  \let\@evenhead\@empty
  \let\@mkboth\@gobbletwo
  \let\sectionmark\@gobble
  \let\subsectionmark\@gobble
}
\def\ps@epl{%
   \let\@oddfoot\@empty\let\@evenfoot\@empty
   \def\@evenhead{%
     {\normalsize\bfseries \thepage}\hfil\epl@shortbanner
   }%
   \def\@oddhead{%
     \epl@shortauthor:\ \epl@shorttitle\hfil{\normalsize\bfseries\thepage}%
   }%
   \let\@mkboth\@gobbletwo
   \let\sectionmark\@gobble
   \let\subsectionmark\@gobble
}
\pagestyle{epl}

%
% footnotes %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\renewcommand{\footnoterule}{\kern3pt\hrule width\textwidth\kern3pt}
\def\@makefnmark{\ensuremath{(^{\thefootnote})}}%
\def\@makefntext#1{%
   \parindent 1em%
   \noindent
   \hb@xt@1.6em{\hss\@makefnmark}#1%
}
%
% sections %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newlength\epl@section@vskip
\setlength\epl@section@vskip{6pt plus2pt minus0pt}
\newlength\epl@section@hsep
\setlength\epl@section@hsep{10pt plus1pt minus0pt}
\newlength\epl@section@indent
\setlength\epl@section@indent{\parindent}
\setcounter{secnumdepth}{0}
\renewcommand{\section}[1]{\epl@section{\epl@section@makeup{#1}}}
\def\epl@section{%
   \@startsection{section}{1}{\epl@section@indent}%
                 {\epl@section@vskip}%
                 {-\epl@section@hsep}%
                 {\normalfont\normalsize\itshape}%
}
\def\epl@section@makeup#1{\textit{#1.} --}
\renewcommand{\part}{\ClassError{epl}{No `part' sectioning allowed}}
\renewcommand{\subsection}{\ClassError{epl}{No subsections allowed}}
\renewcommand{\subsubsection}{\ClassError{epl}{No subsubsections allowed}}
\renewcommand{\paragraph}{\ClassError{epl}{No paragraphs allowed}}
\renewcommand{\subparagraph}{\ClassError{epl}{No subparagraphs allowed}}

%
% bibliography %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newif\ifepl@got@and\epl@got@andfalse
\renewcommand{\and}{\unskip\global\epl@got@andtrue{\normalfont\ and\ }\ignorespaces}
\renewcommand{\refname}{REFERENCES}
\newlength\epl@bibsection@indent
\setlength\epl@bibsection@indent{0pt}
\newlength\epl@bibsection@prevskip
\setlength\epl@bibsection@prevskip{18pt plus4pt minus2pt}
\newlength\epl@bibsection@postvskip
\setlength\epl@bibsection@postvskip{12pt plus2pt minus2pt}
\def\epl@bibsection{%
   \@startsection{section}{1}{\epl@bibsection@indent}%
                 {\epl@bibsection@prevskip}%
                 {\epl@bibsection@postvskip}%
                 {\epl@bibsection@makeup}{}%
}
\def\epl@bibsection@makeup#1{\noindent\normalfont\small\refname}
\renewenvironment{thebibliography}[1]{%
  \epl@bibsection%
  \begin{list}{%
    \@biblabel{\@arabic\c@enumiv}%
  }{%
    \small
    \parsep0pt
    \parindent0pt
    \listparindent0pt
    \itemindent0pt
    \itemsep0pt
    \labelsep8pt
    \settowidth\labelwidth{\@biblabel{#1}}%
    \leftmargin\labelwidth
    \advance\leftmargin\labelsep
    \usecounter{enumiv}%
    \let\p@enumiv\@empty
    \renewcommand{\theenumiv}{\@arabic\c@enumiv}%
  }%
  \sloppy
  \clubpenalty4000
  \widowpenalty4000
  \sfcode`\.\@m
}%
{%
  \def\@noitemerr{\@latex@warning{Empty `thebibliography' environment}}%
  \end{list}%
}
\let\epl@org@bibitem\bibitem
\def\bibitem{\epl@bookfalse\epl@org@bibitem}
%
% bibliography macros %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newcommand{\Name}[1]{{\scshape #1},}
\newcommand{\Review}[1]{\epl@bookfalse{\itshape #1},}
\newcommand{\Vol}[1]{%
  \ifepl@book\unskip, Vol.~{\bfseries #1}\else{\bfseries #1}\fi
}
\newcommand{\Year}[1]{\ifepl@book#1\else(#1)\fi}
\newcommand{\Page}[1]{%
  \ifepl@book\unskip,\ {\normalfont p.~#1}\else{\normalfont #1}\fi
}
\newcommand{\Pages}[2]{%
  \ifepl@book\unskip,\ {\normalfont pp.~#1-#2}\else{\normalfont #1-#2}\fi
}
\newcommand{\Book}[1]{\epl@booktrue{\itshape #1}}
\newcommand{\Publ}[1]{\ifepl@book\unskip\ \fi{\normalfont(#1)}}
\newcommand{\Editor}[1]{%
  \epl@got@andfalse
  \ifepl@book\unskip,\ {\normalfont edited by}\ {\scshape #1}%
  \else
    {\scshape #1}\ {\normalfont (Editor\ifepl@got@and s\fi)},%
  \fi
}
\newcommand{\Section}[1]{%
  \ifepl@book\unskip,\ {\normalfont sect.~#1}\else{\normalfont sect.~#1}\fi
}
\let\And\and
\newcommand{\REVIEW}[4]{\Review{#1} \Vol{#2} \Year{#3} \Page{#4}}
\newcommand{\SAME}[3]{\Vol{#1} \Year{#2} \Page{#3}}
%
% floats %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newif\ifepl@tablecaption\epl@tablecaptionfalse
\newlength\epl@textfloat@skip
\setlength\epl@textfloat@skip{20pt plus 8pt minus 10pt}
\setcounter{topnumber}{1}
\renewcommand{\topfraction}{.97}
\setcounter{bottomnumber}{1}
\renewcommand{\bottomfraction}{.97}
\setcounter{totalnumber}{3}
\renewcommand{\textfraction}{.03}
\renewcommand{\floatpagefraction}{.88}
\setlength{\textfloatsep}{\epl@textfloat@skip}
\def\epl@floattextsize{\small}
\renewcommand{\figurename}{Fig.}
\renewcommand{\tablename}{\textsc{Table}}
\renewcommand{\thetable}{\Roman{table}}
\newlength\epl@caption@skip
\newlength\epl@caption@noskip
\setlength{\epl@caption@skip}{10pt}
\setlength{\epl@caption@noskip}{0pt}
\long\def\@makecaption#1#2{%
  \vspace{\abovecaptionskip}%
  \epl@floattextsize
  #1 -- \ifepl@tablecaption\emph{#2}\else#2\fi\par
  \vspace{\belowcaptionskip}%
}
\def\@floatboxreset{%
  \reset@font
  \epl@floattextsize
  \@setminipage
}
\renewenvironment{table}{%
  \epl@tablecaptiontrue
  \setlength{\abovecaptionskip}{\epl@caption@noskip}%
  \setlength{\belowcaptionskip}{\epl@caption@skip}%
  \@float{table}%
}{%
  \end@float
}
\renewenvironment{table*}{%
  \bgroup
  \epl@tablecaptiontrue
  \setlength{\abovecaptionskip}{\epl@caption@noskip}%
  \setlength{\belowcaptionskip}{\epl@caption@skip}%
  \@dblfloat{table}%
}{%
  \end@dblfloat
  \egroup
}
\renewenvironment{figure}{%
  \epl@tablecaptionfalse
  \ifepl@figures
    \setcounter{epl@cnt@fig}{\thefigure}%
    \epl@topfigsfalse
  \fi
  \setlength{\abovecaptionskip}{\epl@caption@skip}%
  \setlength{\belowcaptionskip}{\epl@caption@noskip}%
  \@float{figure}%
}{%
  \end@float
}
\renewenvironment{figure*}{%
  \epl@tablecaptionfalse
  \ifepl@figures
    \setcounter{epl@cnt@fig}{\thefigure}%
    \epl@multiplefiguresfalse
    \epl@topfigsfalse
  \fi
  \setlength{\abovecaptionskip}{\epl@caption@skip}%
  \setlength{\belowcaptionskip}{\epl@caption@noskip}%
  \@dblfloat{figure}%
}{%
  \end@dblfloat
}
%
% floats shrinking/enlarging %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newcommand{\shrinkfloats}[1]{%
  \setlength{\epl@tmplen@a}{\baselineskip}%
  \multiply\epl@tmplen@a #1
  \divide\epl@tmplen@a 4
  \addtolength{\epl@textfloat@skip}{-2\epl@tmplen@a}%
  \addtolength{\epl@caption@skip}{-\epl@tmplen@a}%
  \setlength{\textfloatsep}{\epl@textfloat@skip}%
}
\newcommand{\enlargefloats}[1]{%
  \setlength{\epl@tmplen@a}{\baselineskip}%
  \multiply\epl@tmplen@a #1
  \divide\epl@tmplen@a 4
  \addtolength{\epl@textfloat@skip}{2\epl@tmplen@a}%
  \addtolength{\epl@caption@skip}{\epl@tmplen@a}%
  \setlength{\textfloatsep}{\epl@textfloat@skip}%
}
%
% acknowledgments %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newcommand{\acknowledgments}{%
  \par
  \vspace{\epl@acknowledgments@skip}%
  \centerline{$\ast\ast\ast$}%
  \vspace{\epl@acknowledgments@skip}%
  \par
}
\let\acknowledgements\acknowledgments
\let\stars\acknowledgments
%
% acknowledgments shrinking/enlarging %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newlength\epl@acknowledgments@skip
\setlength{\epl@acknowledgments@skip}{1pc plus2pt minus 2pt}
\newcommand{\shrinkacknowledgments}[1]{%
  \ifcase#1
    \or\addtolength{\epl@acknowledgments@skip}{-6pt}%
    \or\addtolength{\epl@acknowledgments@skip}{-12pt}%
    \else\ClassWarning{epl}{%
           Argument to \protect\shrinkacknowledgments\space must be 1 or 2%
         }%
  \fi
}
\newcommand{\enlargeacknowledgments}[1]{%
  \ifcase#1
    \or\addtolength{\epl@acknowledgments@skip}{6pt}%
    \or\addtolength{\epl@acknowledgments@skip}{12pt}%
    \else\ClassWarning{epl}{%
           Argument to \protect\enlargeacknowledgments\space must be 1 or 2%
         }%
  \fi
}
\let\shrinkacknowledgements\shrinkacknowledgments
\let\enlargeacknowledgements\enlargeacknowledgments
%
% additional macros %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%\newcommand{\email}[1]{%
%  E-mail: \ifepl@hyper{\href{mailto:#1}{\texttt{#1}}}\else\texttt{#1}\fi
%}
\newcommand{\email}[1]{\texttt{#1}}
\newcommand{\upd}{\mathrm{d}}
\let\drm\upd
\newcommand{\ab}[1]{\mathrm{#1}}
\newcommand{\tx}[1]{{\mbox{#1}}}
\newcommand{\vect}[1]{\bm{#1}}
\newcommand{\tens}[1]{\mathsf{#1}}
\newcommand{\un}[1]{\ensuremath{\unskip\,\mathrm{#1}}}
\newcommand{\chem}[1]{\ensuremath{\mathrm{#1}}}
\newcommand{\mth}[1]{\ensuremath{#1}}
\newcommand{\acro}[1]{\textmd{#1}}
%
% figures %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\ifepl@figures
\newif\ifepl@topfigs\epl@topfigsfalse
\newcommand{\topfigs}{\epl@topfigstrue}
\newif\ifepl@multiplefigure\epl@multiplefigurefalse
\newcounter{epl@cnt@fig}
\setcounter{epl@cnt@fig}{0}
\newcommand{\onefigure}[2][]{%
  \stepcounter{epl@cnt@fig}%
  \hbox to\hsize{\hfill\includegraphics*[#1]{#2}\hfill}%
}
\newcommand{\twofigures}[3][]{%
  \hbox to\hsize{%
    \vbox{%
       \hbox{\includegraphics*[#1]{#2}}%
       \stepcounter{epl@cnt@fig}%
       \hbox{\small\figurename\ \theepl@cnt@fig}%
    }%
    \hfill
    \vbox{%
       \hbox{\includegraphics*[#1]{#3}}%
       \stepcounter{epl@cnt@fig}%
       \hbox{\small\figurename\ \theepl@cnt@fig}}%
    \hfill
  }%
}
\newcommand{\threefigures}[4][]{%
  \hbox to\hsize{%
    \vbox{%
       \hbox{\includegraphics*[#1]{#2}}%
       \stepcounter{epl@cnt@fig}%
       \hbox{\small\figurename\ \theepl@cnt@fig}%
    }%
    \hfill
    \vbox{%
       \hbox{\includegraphics*[#1]{#3}}%
       \stepcounter{epl@cnt@fig}%
       \hbox{\small\figurename\ \theepl@cnt@fig}}%
    \hfill
    \vbox{%
       \hbox{\includegraphics*[#1]{#4}}%
       \stepcounter{epl@cnt@fig}%
       \hbox{\small\figurename\ \theepl@cnt@fig}}%
    \hfill
  }%
}
\newcommand{\oneimage}[2][]{
  \ifepl@multiplefigure\else\stepcounter{epl@cnt@fig}\fi
  \hbox to\hsize{%
    \hbox{\includegraphics*[#1]{#2}}\hfill
  }%
  \epl@multiplefiguretrue
}
\newcommand{\twoimages}[3][]{
  \ifepl@multiplefigure\else\stepcounter{epl@cnt@fig}\fi
  \hbox to\hsize{%
    \hbox{\includegraphics*[#1]{#2}}\hfill
    \hbox{\includegraphics*[#1]{#3}}\hfill
  }%
  \epl@multiplefiguretrue
}
\newcommand{\threeimages}[4][]{
  \ifepl@multiplefigure\else\stepcounter{epl@cnt@fig}\fi
  \hbox to\hsize{%
    \hbox{\includegraphics*[#1]{#2}}\hfill
    \hbox{\includegraphics*[#1]{#3}}\hfill
    \hbox{\includegraphics*[#1]{#4}}\hfill
  }%
  \epl@multiplefiguretrue
}
\newcommand{\fourimages}[5][]{
  \ifepl@multiplefigure\else\stepcounter{epl@cnt@fig}\fi
  \hbox to\hsize{%
    \hbox{\includegraphics*[#1]{#2}}\hfill
    \hbox{\includegraphics*[#1]{#3}}\hfill
    \hbox{\includegraphics*[#1]{#4}}\hfill
    \hbox{\includegraphics*[#1]{#5}}\hfill
  }%
  \epl@multiplefiguretrue
}
\fi %epl@figures
%
% issuetoc %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\ifepl@issuetoc
  %
  % pagestyle
  %
  \pagestyle{epl@empty}
  %
  % banner
  %
  \newlength\epl@issuetocbanner@skip
  \setlength\epl@issuetocbanner@skip{0.2pc}
%  \def\epl@issuetoc@banner{\large\textbf{Table of Contents}\par}
  \def\epl@issuetoc@banner{\large\ \par}
  \renewcommand{\maketitle}{%
    \begingroup
      \parindent=0pt
      \epl@issuetoc@banner
      \vspace{\epl@issuetocbanner@skip}%
    \endgroup
  }
  %
  % useless commands
  %
  \let\thanks\@gobble
  \let\footnote\@gobble
  \let\inst\@gobble
  \let\[\@gobble
  %
  % body
  %
  \def\epl@issuetocsize{\small}
  \newlength\epl@issuetocsection@skip
  \setlength\epl@issuetocsection@skip{0.3pc}
  \newlength\epl@issuetocitem@skip
  \setlength\epl@issuetocitem@skip{0.1pc}
  \newlength\epl@issuetoc@rightmargin
  \setlength\epl@issuetoc@rightmargin{10mm}
  \newenvironment{issuetoc}{%
    \hfill page\par
    \begin{list}{}{
      \setlength{\leftmargin}{10mm}%
      \setlength{\rightmargin}{\epl@issuetoc@rightmargin}%
      \setlength{\listparindent}{0pt}%
      \setlength{\itemindent}{-3mm}%
      \setlength{\labelsep}{3mm}%
      \setlength{\labelwidth}{4mm}%
      \setlength{\itemsep}{\epl@issuetocitem@skip}%
      \setlength{\parsep}{0pt}%
      \setlength{\topsep}{0pt}%
      \setlength{\parskip}{0pt}%
    }%
  }{%
    \end{list}%
  }
  \newcommand{\tocsection}[2]{%
    \item[\textbf{#1}] \unskip\textit{#2}\par
    \renewcommand{\tocsection}[2]{%
      \vspace{\epl@issuetocsection@skip}%
      \item[\textbf{##1}] \textit{##2}\par
    }%
  }
  \newcommand{\tocitem}[4]{%
    \item {\epl@issuetocsize\textsc{#2} -- #3\hfill
          \rlap{\hbox to\epl@issuetoc@rightmargin{\hfill\textbf{#4}}}\par}
  }
  \newcommand{\tocerratum}[4]{%
    \item {\epl@issuetocsize\textsc{#2} -- #3 (\emph{Erratum})\hfill
          \rlap{\hbox to\epl@issuetoc@rightmargin{\hfill\textbf{#4}}}\par}
  }
  \newcommand{\tocaddendum}[4]{%
    \item {\epl@issuetocsize\textsc{#2} -- #3 (\emph{Addendum})\hfill
          \rlap{\hbox to\epl@issuetoc@rightmargin{\hfill\textbf{#4}}}\par}
  }
  \newcommand{\tocvar}[2]{%
    \item {\epl@issuetocsize #1\hfill
          \rlap{\hbox to\epl@issuetoc@rightmargin{\hfill\textbf{#2}}}\par}
  }
  \newcommand{\tocforth}[2]{%
    \item {\epl@issuetocsize List of papers accepted up to #1 to appear in
                       forthcoming issues\hfill
          \rlap{\hbox to\epl@issuetoc@rightmargin{\hfill\textbf{#2}}}\par}
  }
  \newcommand{\toccontinued}{%
    \tocskip
    \item {\epl@issuetocsize \emph{Contents continued on cover page 3}\hfill\par}
    \pagebreak
    \item {\epl@issuetocsize \emph{Contents (continued)}\hfill\par}
  }
  \let\tocskip\medskip
  \nofiles
  \pagestyle{empty}
  \sloppy
  %
  % enlarge/shrink
  %
  \newcommand{\tocsize}[1]{%
    \def\epl@issuetocsize{#1}%
  }
  \newcommand{\addtobannerskip}[1]{%
    \addtolength{\epl@issuetocbanner@skip}{#1}%
  }
  \newcommand{\addtosectionskip}[1]{%
    \addtolength{\epl@issuetocsection@skip}{#1}%
  }
  \newcommand{\addtoitemskip}[1]{%
    \addtolength{\epl@issuetocitem@skip}{#1}%
  }
\fi
%
% info %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\ifepl@info
  \def\epl@jobinfo{%
    \noindent
    \raisebox{5pc}[0pt][0pt]{%
      \makebox[0pt][l]{%
        \hspace{\textwidth}%
        \makebox[0pt][r]{%
          {\sffamily\bfseries{\Huge\jobname}
          \number\year-\number\month-\number\day}%
        }%
      }%
    }%
  }%
\fi
%
% eqnarray %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newdimen\epl@eqnarraycolsep
\setlength{\epl@eqnarraycolsep}{.3em}
\def\eqnarray{%
   \stepcounter{equation}%
   \def\@currentlabel{\p@equation\theequation}%
   \global\@eqnswtrue
   \m@th
   \global\@eqcnt\z@
   \tabskip\@centering
   \let\\\@eqncr
   $$\everycr{}\halign to\displaywidth\bgroup
       \hskip\@centering$\displaystyle\tabskip\z@skip{##}$\@eqnsel
      &\global\@eqcnt\@ne\hskip \tw@\epl@eqnarraycolsep \hfil${##}$\hfil
      &\global\@eqcnt\tw@ \hskip \tw@\epl@eqnarraycolsep
         $\displaystyle{##}$\hfil\tabskip\@centering
      &\global\@eqcnt\thr@@ \hb@xt@\z@\bgroup\hss##\egroup
         \tabskip\z@skip
      \cr
}
%
% largetabular %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newenvironment{largetabular}[2][]{%
  \begin{tabular*}{\textwidth}[#1]{@{\extracolsep{\fill}}#2@{}}%
}{%
  \end{tabular*}
}
%
% forthcoming %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\ifepl@forth
  \nofiles
  %
  % pagestyle
  %
  \pagestyle{epl@empty}
  %
  % banner
  %
  \newlength\epl@forth@banner@skip
  \setlength\epl@forth@banner@skip{2pc}
  \def\epl@forth@banner{\large\textit{Papers accepted up to \epl@forth@date\ to appear in forthcoming issues}\par}
  \renewcommand{\maketitle}{%
    \begingroup
      \parindent=0pt
      \epl@forth@banner
      \vspace{\epl@forth@banner@skip}%
    \endgroup
  }
  \renewcommand{\date}[1]{\def\epl@forth@date{#1}}
  %
  % body
  %
  \newlength\epl@forth@item@skip
  \setlength\epl@forth@item@skip{4pt plus1pt minus1pt}
  \newenvironment{forth}{%
    \parindent=0pt
    \footnotesize
    \sloppy
    \frenchspacing
    \reversemarginpar
    \setlength{\marginparwidth}{3.6em}
    \setlength{\marginparsep}{.8em}
  }{%
  }
  \newcommand{\forthitem}[5][]{%
    \setcounter{footnote}{1}
    \def\epl@forth@footnote{}%
    \pagebreak[3]%
    \vspace{\epl@forth@item@skip}%
    \textbf{#3}\par\nopagebreak
    \ifepl@info
      \marginpar{{\sffamily\bfseries#2}\ \small#1\ }%
    \fi
    {%
      \def\inst##1{\unskip\hspace{1pt}\nolinebreak${}^{##1}$}%
      \textit{#4}\par\nopagebreak
    }%
    {%
      \def\inst##1{\unskip${}^{##1}$}%
      #5
    }%
    \epl@forth@footnote\par
  }
  \def\[#1]{\inst{#1}}
  \renewcommand{\and}{\unskip\ and\ \ignorespaces}
  \let\And\and
  \def\@makefnmark{\ensuremath{(^{\epl@titlefnmark})}}
  \def\epl@forth@footnote{}
  \renewcommand{\footnote}[1]{%
    \@makefnmark
    \protected@xdef\epl@forth@footnote{%
      \epl@forth@footnote{\par\protect\nopagebreak\@makefnmark\ #1}%
    }%
    \stepcounter{footnote}%
  }
  \let\thanks\footnote
  %
  % enlarge/shrink
  %
  \newcommand{\addtobannerskip}[1]{%
    \addtolength{\epl@issuetocbanner@skip}{#1}%
  }
  \newcommand{\addtoitemskip}[1]{%
    \addtolength{\epl@issuetocitem@skip}{#1}%
  }
\fi
%
% volpacsindex %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\ifepl@volpacsindex
  \nofiles
  %
  % useless commands
  %
  \let\thanks\@gobble
  \let\footnote\@gobble
  \let\inst\@gobble
  \let\[\@gobble
  %
  %
  %
  \def\epl@index@size{\small}
  \newlength\epl@indexsection@skip
  \setlength\epl@indexsection@skip{12pt plus6pt minus2pt}
  \newlength\epl@indexsubsection@skip
  \setlength\epl@indexsubsection@skip{12pt plus3pt minus2pt}
  \newlength\epl@indexitem@skip
  \setlength\epl@indexitem@skip{0pt}
  \newlength\epl@index@leftmargin
  \setlength\epl@index@leftmargin{36pt}
  \newlength\epl@index@pagenumwidth
  \setlength\epl@index@pagenumwidth{19pt}
  %
  % pagestyle
  %
  \thispagestyle{epl@empty}
  \pagestyle{epl}
  %
  % banner
  %
  \newlength\epl@indexbanner@skip
  \setlength\epl@indexbanner@skip{4pc}
  \def\epl@index@banner{{\Large Subject index}\par}
  \renewcommand{\maketitle}{%
    \begingroup
      \parindent=0pt
      \epl@index@banner
      \vspace{\epl@indexbanner@skip}%
    \endgroup
  }
  \def\@oddhead{%
    \epl@shorttitle@makeup{subject index}\hfil{\normalsize\bfseries\thepage}%
  }
  %
  %
  %
  \newenvironment{volpacsindex}{
    \leftskip=\epl@index@leftmargin
    \parindent=-\epl@index@leftmargin
    \sloppy
    \epl@index@size
  }{%
  }
  \newcommand{\indexsection}[2]{%
    \vspace{\epl@indexsection@skip}%
    \begingroup
      \leftskip=.5\epl@index@leftmargin
      \parindent=-.5\epl@index@leftmargin
        \leavevmode\hbox to\leftskip{\textbf{#1.}\hfill}\textbf{#2}\par
    \endgroup
    \nopagebreak
  }
  \newcommand{\indexsubsection}[2]{%
    \vspace{\epl@indexsubsection@skip}%
    \begingroup
      \leftskip=.5\epl@index@leftmargin
      \parindent=-.5\epl@index@leftmargin
        \leavevmode\hbox to\leftskip{\textbf{#1.}\hfill}\textit{#2}\par
    \endgroup
    \nopagebreak
    \leavevmode\hbox to\epl@index@pagenumwidth{\hfill page}\par\nopagebreak
  }
  \newcommand{\indexitem}[4]{
    \vspace{\epl@indexitem@skip}%
    \leavevmode
    \hbox to\epl@index@leftmargin{%
      \hbox to\epl@index@pagenumwidth{\hfill #4}%
      \hfill
    }%
    #3, \textit{#2}%
    \par
  }
  \newcommand{\indexerratum}[4]{
    \vspace{\epl@indexitem@skip}%
    \leavevmode
    \hbox to\epl@index@leftmargin{%
      \hbox to\epl@index@pagenumwidth{\hfill #4}%
      \hfill
    }%
    #3 (\emph{Erratum}), \textit{#2}%
    \par
  }
  \newcommand{\indexaddendum}[4]{
    \vspace{\epl@indexitem@skip}%
    \leavevmode
    \hbox to\epl@index@leftmargin{%
      \hbox to\epl@index@pagenumwidth{\hfill #4}%
      \hfill
    }%
    #3 (\emph{Addendum}), \textit{#2}%
    \par
  }
  \let\indexskip\medskip
  %
  % enlarge/shrink
  %
  \newcommand{\indexsize}[1]{%
    \def\epl@index@size{#1}%
  }
  \newcommand{\addtobannerskip}[1]{%
    \addtolength{\epl@indexbanner@skip}{#1}%
  }
  \newcommand{\addtosectionskip}[1]{%
    \addtolength{\epl@indexsection@skip}{#1}%
  }
  \newcommand{\addtosubsectionskip}[1]{%
    \addtolength{\epl@indexsubsection@skip}{#1}%
  }
  \newcommand{\addtoitemskip}[1]{%
    \addtolength{\epl@indexitem@skip}{#1}%
  }
  %
  %
  %
\fi
%
% volalphaindex %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
  %
  % ARGH does not work after the \ifepl@volalphaindex
  %
  \newif\ifepl@pageflag\epl@pageflagtrue
  \def\epl@checkpagelabel{%
    \ifepl@pageflag
      \epl@pagelabel
      \epl@pageflagfalse
    \fi
  }
\ifepl@volalphaindex
  \nofiles
  %
  % useless commands
  %
  \let\thanks\@gobble
  \let\footnote\@gobble
  \let\inst\@gobble
  \let\[\@gobble
  %
  %
  %
  \def\epl@index@size{\small}
  \newlength\epl@indexsection@skip
  \setlength\epl@indexsection@skip{12pt plus6pt minus2pt}
  \newlength\epl@indexsubsection@skip
  \setlength\epl@indexsubsection@skip{12pt plus3pt minus2pt}
  \newlength\epl@indexitem@skip
  \setlength\epl@indexitem@skip{0pt plus1pt}
  \newlength\epl@index@leftmargin
  \setlength\epl@index@leftmargin{36pt}
  \newlength\epl@index@pagenumwidth
  \setlength\epl@index@pagenumwidth{19pt}
  %
  % pagestyle
  %
  \def\ps@epl{%
     \let\@oddfoot\@empty\let\@evenfoot\@empty
     \def\@evenhead{%
       \global\epl@pageflagtrue
       {\normalsize\bfseries \thepage}\hfil\epl@shortbanner
     }%
     \def\@oddhead{%
       \global\epl@pageflagtrue
       \epl@shorttitle@makeup{author index}\hfil{\normalsize\bfseries\thepage}%
     }%
     \let\@mkboth\@gobbletwo
     \let\sectionmark\@gobble
     \let\subsectionmark\@gobble
  }
  \thispagestyle{epl@empty}
  \pagestyle{epl}
  %
  % banner
  %
  \newlength\epl@indexbanner@skip
  \setlength\epl@indexbanner@skip{4pc}
  \def\epl@index@banner{{\Large Author index}\par}
  \renewcommand{\maketitle}{%
    \begingroup
      \parindent=0pt
      \epl@index@banner
      \vspace{\epl@indexbanner@skip}%
      \suppressfloats[t]%
    \endgroup
  }
  %
  %
  %
  \newenvironment{volalphaindex}{
    \leftskip=\epl@index@leftmargin
    \parindent=-\epl@index@leftmargin
    \sloppy
    \epl@index@size
    \epl@first@pagelabel
  }{%
  }
  \newcommand{\indexsection}[2]{%
    \vspace{\epl@indexsection@skip}%
    \textbf{#1.}\ \textit{#2}\par
    \nopagebreak
  }
  \newcommand{\indexsubsection}[2]{%
    \vspace{\epl@indexsubsection@skip}%
    \textbf{#1.}\ \textit{#2}\par
    \nopagebreak
  }
  \def\epl@pagelabel{%
    \begin{figure}[t]
      \leavevmode
      \hbox to\epl@index@pagenumwidth{\hfill page}%
      \par
      \vspace{-1.6pc}
    \end{figure}
  }
  \def\epl@first@pagelabel{%
    \hbox to\epl@index@pagenumwidth{\hfill page}%
  }
  \newcommand{\indexitem}[4]{%
    \epl@checkpagelabel
    \vspace{\epl@indexitem@skip}%
    \leavevmode
    \hbox to\epl@index@leftmargin{%
      \hbox to\epl@index@pagenumwidth{\hfill #2}%
      \hfill
    }%
    \textsc{#3}\par
    \nopagebreak
    \noindent #4\par
  }
  \newcommand{\indexitemref}[4]{
    \ifepl@pageflag
      \epl@pagelabel
      \epl@pageflagfalse
    \fi
    \vspace{\epl@indexitem@skip}%
    \leavevmode
    \hbox to\epl@index@leftmargin{%
      \hbox to\epl@index@pagenumwidth{\hfill #2}%
      \hfill
    }%
    \textsc{#3}\ (see \textsc{#4})\par
  }
  \newcommand{\indexerratum}[4]{%
    \epl@checkpagelabel
    \vspace{\epl@indexitem@skip}%
    \leavevmode
    \hbox to\epl@index@leftmargin{%
      \hbox to\epl@index@pagenumwidth{\hfill #2}%
      \hfill
    }%
    \textsc{#3}\par
    \nopagebreak
    \noindent #4 (\emph{Erratum})\par
  }
  \newcommand{\indexaddendum}[4]{%
    \epl@checkpagelabel
    \vspace{\epl@indexitem@skip}%
    \leavevmode
    \hbox to\epl@index@leftmargin{%
      \hbox to\epl@index@pagenumwidth{\hfill #2}%
      \hfill
    }%
    \textsc{#3}\par
    \nopagebreak
    \noindent #4 (\emph{Addendum})\par
  }
  \let\indexskip\medskip
  %
  % enlarge/shrink
  %
  \newcommand{\indexsize}[1]{%
    \def\epl@index@size{#1}%
  }
  \newcommand{\addtobannerskip}[1]{%
    \addtolength{\epl@indexbanner@skip}{#1}%
  }
  \newcommand{\addtosectionskip}[1]{%
    \addtolength{\epl@indexsection@skip}{#1}%
  }
  \newcommand{\addtoitemskip}[1]{%
    \addtolength{\epl@indexitem@skip}{#1}%
  }
  %
  %
  %
\fi
%
%
%
\ifepl@indices
  \nofiles
  \pagestyle{empty}
  \thispagestyle{empty}
  \newcommand{\volume}[2]{%
    \def\epl@vol{#1}%
    \def\epl@year{#2}%
  }
  \renewcommand{\maketitle}{%
    \vspace*{2pc}
    {\Large AUTHOR AND SUBJECT INDICES VOL.\ \epl@vol, \epl@year}\par
  }
\fi

