\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{newFNLstyle}[2001/1/16 Greg Harmer -- Uni Adelaide]
\RequirePackage{calc}

\typeout{Modified by Greg Harmer, 2000}


\newcommand\docsize{10pt}
\DeclareOption{10pt}{\renewcommand\docsize{10pt}}
\DeclareOption{11pt}{\renewcommand\docsize{11pt}}
\DeclareOption{12pt}{\renewcommand\docsize{12pt}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ExecuteOptions{10pt}  
\ProcessOptions
\LoadClass[\docsize]{article} 


% MARGINS:
\textheight 7.8in
\textwidth  5.0in
\topmargin  0.9in
\setlength\headsep{15pt}
\setlength\headheight{10pt}
%\setlength\topskip{0pt}
\newlength{\FNLheaderlift}
\setlength{\FNLheaderlift}{\headsep+\headheight+0.8\baselineskip}

% Just horizontally cetre it
\setlength\oddsidemargin{0.5\paperwidth-0.5\textwidth-1.0in}
\setlength\evensidemargin{\oddsidemargin}

%\oddsidemargin = 0.5\oddsidemargin

%\if@twoside                 % Values for two-sided printing:
%   \oddsidemargin = \evensidemargin
%   \addtolength\oddsidemargin{-30pt}
%   \addtolength\evensidemargin{-30pt}
%\else                       % Values for one-sided printing:
%   \oddsidemargin = \evensidemargin
%   \addtolength\oddsidemargin{-30pt}
%   \addtolength\evensidemargin{-30pt}
%\fi
%%\marginparsep 0.125in       % Horizontal space between outer margin and
\marginparsep 5mm        % marginal note
\setlength\marginparwidth{3.0cm}                     

\parindent=15pt

% Marginal comments
\newcommand{\Q}[1]{\marginpar[\vspace*{-4mm}\flushright{\rule[-1mm]{\marginparwidth}{0.5mm}}\\{\footnotesize\sf{#1}}\\{\rule[2mm]{\marginparwidth}{0.5mm}}]{\vspace*{-4mm}\flushleft\rule[-1mm]{\marginparwidth}{0.5mm}\\{\footnotesize\sf{#1}}\\\rule[2mm]{\marginparwidth}{0.5mm}}}


\renewcommand\maketitle{%\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@0.5em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
      %gph \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \thispagestyle{empty}
    \@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax}


\newcommand\volnumpagesyear[4]{\newcommand\vol{Vol.~#1}%
                               \newcommand\num{No.~#2}%
                               \newcommand\pages{#3}%
                               \newcommand\yr{(#4)}}
\newcommand\dates[3]{\newcommand\recdate{Received\space(#1)}%
                     \newcommand\revdate{Revised\space(#2)}%
                     \newcommand\accdate{Accepted\space(#3)}}
\newcommand\thisjournal{Fluctuation and Noise Letters}
\newcommand\publisher{World Scientific Publishing Company}

\def\and{\MakeLowercase{and}\space}

\def\authone{}\long\def\authorsone#1{\def\authone{#1}}
\def\affone{}\long\def\affiliationone#1{\def\affone{#1}}
\def\mailone{}\long\def\mailingone#1{\def\mailone{#1}}

\def\authtwo{}\long\def\authorstwo#1{\def\authtwo{#1}}
\def\afftwo{}\long\def\affiliationtwo#1{\def\afftwo{#1}}
\def\mailtwo{}\long\def\mailingtwo#1{\def\mailtwo{#1}}

\def\auththree{}\long\def\authorsthree#1{\def\auththree{#1}}
\def\affthree{}\long\def\affiliationthree#1{\def\affthree{#1}}
\def\mailthree{}\long\def\mailingthree#1{\def\mailthree{#1}}

\def\authfour{}\long\def\authorsfour#1{\def\authfour{#1}}
\def\afffour{}\long\def\affiliationfour#1{\def\afffour{#1}}
\def\mailfour{}\long\def\mailingfour#1{\def\mailfour{#1}}

\def\authfive{}\long\def\authorsfive#1{\def\authfive{#1}}
\def\afffive{}\long\def\affiliationfive#1{\def\afffive{#1}}
\def\mailfive{}\long\def\mailingfive#1{\def\mailfive{#1}}


\def\@maketitle{%
  \setcounter{page}{1}
  \parindent=0pt%
  \vspace*{-\FNLheaderlift}%
  {\footnotesize\thisjournal\par
    \vol,\space\num\space\yr\space\pages\par
    \copyright\space\publisher\par}
  \vspace{1.5in} %2em%
  \let \footnote \thanks
  \centering%
  {\bf\@title\par}%
  \vspace{0.37in}
    \footnotesize%
    %\vskip 1.5em%
    %{\large
    %  \lineskip .5em%
    %  \begin{tabular}[t]{c}%
    %    \@author
    %  \end{tabular}\par}%
    %\vskip 1em%
    %\authone\par%\@author\par%
    \makeauthorlist%
    %\large \@date}\par
    \vspace{0.225in}%
    \recdate\par\revdate\par\accdate\par
    \vspace{0.21in}}

\newcommand\makeauthorlist{%
  \vspace{-10pt}
  \author{%
  \ifx\@empty\authone\else\vspace{10pt}\authone\\[2pt]
  \ifx\@empty\affone\else\emph{\affone}\\ \fi
  \ifx\@empty\mailone\else\emph{\mailone}\\ \fi\fi}
  \ifx\@empty\@author\else\@author\fi
%
  \author{%
  \ifx\@empty\authtwo\else\vspace{10pt}\authtwo\\[2pt]
  \ifx\@empty\afftwo\else\emph{\afftwo}\\ \fi
  \ifx\@empty\mailtwo\else\emph{\mailtwo}\\ \fi\fi}
  \ifx\@empty\@author\else\@author\fi
%
  \author{%
  \ifx\@empty\auththree\else\vspace{10pt}\auththree\\[2pt]
  \ifx\@empty\affthree\else\emph{\affthree}\\ \fi
  \ifx\@empty\mailthree\else\emph{\mailthree}\\ \fi\fi}
  \ifx\@empty\@author\else\@author\fi
%
  \author{%
  \ifx\@empty\authfour\else\vspace{10pt}\authfour\\[2pt]
  \ifx\@empty\afffour\else\emph{\afffour}\\ \fi
  \ifx\@empty\mailfour\else\emph{\mailfour}\\ \fi\fi}
  \ifx\@empty\@author\else\@author\fi
%
  \author{%
  \ifx\@empty\authfive\else\vspace{10pt}\authfive\\[2pt]
  \ifx\@empty\afffive\else\emph{\afffive}\\ \fi
  \ifx\@empty\mailfive\else\emph{\mailfive}\\ \fi\fi}
  \ifx\@empty\@author\else\@author\fi}


\def\keywordstext{Please enter some key words}
\long\def\keywords#1{\def\keywordstext{#1}}

\renewenvironment{abstract}
  {\list{}{\footnotesize\listparindent 15pt%\z@%1.5em%
      \itemindent    0pt%\listparindent
      \leftmargin    1.5pc%
      \rightmargin   \leftmargin%
      \parsep        0pt%\z@ \@plus\p@
      \topsep        0pt%\z@ \@plus\p@
      \itemsep       5pt}%
  \item\relax}
  {\item\relax\emph{Keywords}:\space\keywordstext%
    \endlist}
  

\def\ps@myheadings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\footnotesize\itshape\leftmark\hfil}%       %EVEN PAGE
    \def\@oddhead{\hfil{\footnotesize\itshape\rightmark}}%     %ODD PAGE
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
    }
\pagestyle{empty}


\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}
\renewcommand\@makefntext[1]{%
    \parindent 1em%
    \noindent
    \hb@xt@0.5em{\hss\@makefnmark}#1}


\renewcommand\section{\@startsection%
   {section}% sec-name
   {1}% level
   {\z@}% indent
   {-11pt \@plus -3pt \@minus 1pt}%-3.5ex \@plus -1ex \@minus -.2ex}% pre-skip
   {4pt}%{2.3ex \@plus.2ex}% post-skip
   {\normalfont\normalsize\bfseries}} % style
\renewcommand{\@seccntformat}[1]{\@nameuse{the#1}.\quad}

\renewcommand\subsection{\@startsection%
  {subsection}{2}{\z@}%
   {-11pt \@plus -3pt \@minus 1pt}%-3.5ex \@plus -1ex \@minus -.2ex}% pre-skip
   {4pt}%{2.3ex \@plus.2ex}% post-skip
  {\normalfont\normalsize\bfseries\itshape}}
\renewcommand\thesubsection{\textup{\thesection.\@arabic\c@subsection}}
\renewcommand{\@seccntformat}[1]{\@nameuse{the#1}\textup{.}\quad}

\renewcommand\subsubsection{\@startsection%
  {subsubsection}{3}{\z@}%
   {-11pt \@plus -3pt \@minus 1pt}%-3.5ex \@plus -1ex \@minus -.2ex}% pre-skip
   {4pt}%{2.3ex \@plus.2ex}% post-skip
  {\normalfont\normalsize\itshape}}
\renewcommand\thesubsubsection{{\normalfont{\normalsize\thesubsection .\@arabic\c@subsubsection}}}


\renewcommand\figurename{Fig}

\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\long\def\@makecaption#1#2{%
  \footnotesize%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1. #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1. #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}



\renewenvironment{thebibliography}[1]
     {\section*{\refname}%
     \small\baselineskip=11pt%
     \frenchspacing%
     %\setlength{\itemsep}{0pt}
     %\setlength{\parsep}{0pt}
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m%
      \setlength{\parsep}{0pt}\setlength{\itemsep}{0pt}}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}


\renewcommand\appendixname{Appendix}
\renewcommand\appendix{\par
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \setcounter{figure}{0}
  \setcounter{table}{0}
          %\setcounter{lemma}{0}
          %\setcounter{theorem}{0}
          %\setcounter{corollary}{0}
          %\setcounter{definition}{0}
  \setcounter{equation}{0}
  \renewcommand{\thefigure}{\Alph{section}.\arabic{figure}}
  \renewcommand{\thetable}{\Alph{section}.\arabic{table}}
          %\renewcommand{\theappendixc}{\Alph{c@section}}
          %\renewcommand{\thelemma}{\Alph{c@section}.\arabic{lemma}}
          %\renewcommand{\thetheorem}{\Alph{c@section}.\arabic{theorem}}
          %\renewcommand{\thedefinition}{\Alph{c@section}.\arabic{definition}}
          %\renewcommand{\thecorollary}{\Alph{c@section}.\arabic{corollary}}
  \renewcommand{\theequation}{\Alph{section}.\arabic{equation}}
  \gdef\thesection{\appendixname\space\@Alph\c@section}
  \gdef\thesubsection{\normalfont\normalsize\bfseries%
    \@Alph\c@section.\@arabic\c@subsection}
  \gdef\thesubsubsection{\normalfont\normalsize%
    \@Alph\c@section.\@arabic\c@subsection.\@arabic\c@subsubsection}}


\setcounter{topnumber}{2}
\renewcommand\topfraction{.7}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.3}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.8}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}



%---------------------------------------------------------------------------
%---------------------------------------------------------------------------
%---------------------------------------------------------------------------
%---------------------------------------------------------------------------

% Stuff from the old style file
% Modified a little

%LIST ENVIRONMENTS
\newcounter{itemlistc}
\newcounter{romanlistc}
\newcounter{alphlistc}
\newcounter{arabiclistc}
\newenvironment{itemlist}
    	{\setcounter{itemlistc}{0}
	 \begin{list}{$\bullet$}
	{\usecounter{itemlistc}
	 \setlength{\parsep}{0pt}
	 \setlength{\itemsep}{0pt}}}{\end{list}}

\newenvironment{romanlist}
	{\setcounter{romanlistc}{0}
	 \begin{list}{(\roman{romanlistc})}
	{\usecounter{romanlistc}
	 \setlength{\parsep}{0pt}
	 \setlength{\itemsep}{0pt}}}{\end{list}}

\newenvironment{alphlist}
	{\setcounter{alphlistc}{0}
	 \begin{list}{(\alph{alphlistc})}
	{\usecounter{alphlistc}
	 \setlength{\parsep}{0pt}
	 \setlength{\itemsep}{0pt}}}{\end{list}}

\newenvironment{arabiclist}
	{\setcounter{arabiclistc}{0}
	 \begin{list}{\arabic{arabiclistc}}
	{\usecounter{arabiclistc}
	 \setlength{\parsep}{0pt}
	 \setlength{\itemsep}{0pt}}}{\end{list}}



\endinput
