%%
%% This is file `caps.cls'
%%
%% Cambridge Astrophysics Series class for use with CUPBOOK.CLS
%% Copyright (1997) Cambridge University Press
%%
%% by Mark A. Reed
%%   based on CAPS.STY v0.1 (for LaTeX 2.09).
%%
%% Bugs (in the case of unchanged files) should be reported to
%% texline@cup.cam.ac.uk
%%
%% This software may only be used in the preparation of journal articles
%% or books or parts of books to be published by Cambridge University Press.
%% Any other use constitutes an infringement of copyright.
%%
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
%%

\NeedsTeXFormat{LaTeX2e}[1996/06/01]
\ProvidesClass{caps}[1997/05/09 v1.0 Cambridge Astrophysics Series document class]

\PassOptionsToClass{cup8a}{cupbook}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{cupbook}}
\ProcessOptions\relax
\LoadClass{cupbook}[1995/11/30]

\let\capsloaded\@empty % caps option is loaded

% sizes available (truesize)
% \tiny          5/6
% \scriptsize    7/8
% \footnotesize  8/9
% \affilsize     8/10
% \refsize       8.5/10
% \small         9/10
% \enotesize     \small
% \tablesize     \small
% \smallish      9/11
% \quotesize     9.5/12 (list size)
% \authorsize    9.5/12.5
% \normalsize    10/12.5
% \listsize      \normalsize
% \normalsmall   10/12
% \large         11/14
% \sectionsize   11/12.5
% \Large         12/17
% \chaptitlesize 20/25
% \LARGE         \chaptitlesize
% \chapnumsize   24/25
% \huge          \chapnumsize
% \Huge          \huge

\renewcommand\normalsize{\SFB@baseskip 12.5\p@
  \@setfontsize\normalsize\@xpt{\SFB@baseskip}%
  \SFB@setskips{\SFB@baseskip}%
  \let\@listi\@listI
}
\tiny\normalsize

\AtBeginDocument{%
  \@ifundefined{CUPTimesloaded}
    {\newcommand\gillsrm[1]{{\normalsf #1}}%
     \newcommand\gillsbf[1]{{\normalsf\bfseries #1}}}
    {\newcommand\gillsrm[1]{{\usefont{OT1}{xgn}{m}{n}#1}}%
     \newcommand\gillsbf[1]{{\usefont{OT1}{xgn}{b}{n}#1}}%
     \SFB@truesizetrue}%
}

\newcommand\normalrm{\normalfont\rmfamily}
\newcommand\normalsf{\normalfont\sffamily}
\newcommand\normaltt{\normalfont\ttfamily}
\newcommand\normalbf{\normalfont\bfseries}
\newcommand\normalit{\normalfont\itshape}
\newcommand\normalsl{\normalfont\slshape}
\newcommand\normalsc{\normalfont\scshape}
\newcommand\normalbfit{\normalfont\bfseries\itshape}

\setlength\textheight{45\baselineskip}
\addtolength\textheight{\topskip}
\setlength\SFB@measure{30.5pc}
\setlength\textwidth{\SFB@measure}

\ifSFB@landscape
  \setlength\textwidth{\textheight}
  \setlength\textheight{\SFB@measure}
\fi

\setlength\parskip{\z@ \@plus .25\p@ \@minus .001\p@}

\newcommand\ls{\kern.15em} % for letterspacing
\newcommand\ns{\kern.5em} % for name-spacing

\@ifundefined{seename}{\newcommand\seename{see}}{}
\newcommand\see[2]{{\em \seename\/} #1}
\newcommand\seealso[2]{{\em see also\/} #1}
\newcommand\seeunder[2]{{\em see under\/} #1}
\newcommand\itand[1]{{\normalit and\/}#1}
\newcommand\Chapbf[2]{{\normalbf Ch.~#1}}{}
\newcommand\Chap[2]{Ch.~#1}{}

\newenvironment{theobjectindex}
  {\the@index{Object index}}
  {\par\endthe@index}

\newif\if@chptxt
\newbox\@chptxtbox

\newenvironment{chaptertext}
  {\global\@chptxttrue\global\setbox\@chptxtbox=\vbox\bgroup
   \hsize=\textwidth\small\normalrm\noindent\ignorespaces}
  {\egroup}

\renewcommand\the@index[1]{\@restonecoltrue
  \if@twocolumn\@restonecolfalse\fi
  \columnseprule\z@
  \columnsep 1pc%
  \twocolumn[\vspace*{11\p@}\mbox{}\par\@makeschapterhead{#1}]%
  \@mkboth{#1}{#1}%
  \typeout{#1.}%
  \ifSFB@indentsty
    \ifdim\SFB@indent>\z@
      \addcontentsline{toc}{schapter}{\protect\numberline{\mbox{}}#1}%
    \else
     \addcontentsline{toc}{schapter}{#1}%
    \fi
  \else
    \addcontentsline{toc}{schapter}{#1}%
  \fi
  \thispagestyle{plain}%
  \footnotesize\normalrm\raggedright
  \parindent\z@
  \parskip\z@ \@plus.3\p@
  \let\item\@idxitem
}

\renewcommand\numberline[1]{\hbox to\@tempdima{\hfil#1\hspace*{0.5em}}}

\renewcommand\@schapter[1]{%
  \ifSFB@addtoc
    \ifSFB@indentsty
      \ifdim\SFB@indent>\z@
        \addcontentsline{toc}{schapter}{\protect\numberline{\mbox{}}#1}%
      \else
        \addcontentsline{toc}{schapter}{#1}%
      \fi
    \else
      \addcontentsline{toc}{schapter}{#1}%
    \fi
  \fi
  \ifSFB@multisty
    \markboth{#1}{#1}%
    \gdef\SFB@endnotehead{\relax}%
  \else
    \chaptermark{#1}%
    \gdef\SFB@endnotehead{#1}%
  \fi
  \if@twocolumn
    \@topnewpage[\@makeschapterhead{#1}]%
  \else
    \@makeschapterhead{#1}%
    \@afterheading
  \fi
  \normalsize\normalrm
}

\edef\SFB@widefigzero{%
  \noexpand\@xfloat{figure}[\fps@figure]\noexpand\SFB@widefloat}
\edef\SFB@widetabzero{%
  \noexpand\@xfloat{table}[\fps@table]\noexpand\SFB@widefloat}

\setcounter{topnumber}{2}
\renewcommand\topfraction{.95}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.5}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.05}
\renewcommand\floatpagefraction{.95}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.95}
\renewcommand\dblfloatpagefraction{.95}

\newcommand\quotebullet{\bullet}

\ifSFB@truesize
  \DeclareMathSizes{8.5}{8.5}{6}{5}
  \DeclareMathSizes{9.5}{9.5}{7}{5}
  \DeclareMathSizes{24}{24}{20}{17}
  \newcommand\quotesize{\@setfontsize\quotesize{9.5}{12}}
  \newcommand\authorsize{\@setfontsize\authorsize{9.5}{12.5}}
  \newcommand\refsize{\@setfontsize\refsize{8.5}{10}}
  \newcommand\chapnumsize{\@setfontsize\chapnumsize{24}{25}}
\else
  \newcommand\quotesize{\@setfontsize\quotesize\@ixpt{12}}% 9.5pt->9pt
  \newcommand\authorsize{\@setfontsize\authorsize\@ixpt{12.5}}% 9.5pt->9pt
  \newcommand\refsize{\@setfontsize\refsize\@viiipt{10}}% 8.5pt->8pt
  \newcommand\chapnumsize{\@setfontsize\chapnumsize\@xxvpt{25}}% 24pt->25pt
\fi

\newcommand\affilsize{\@setfontsize\authorsize\@viiipt{10}}
\newcommand\sectionsize{\@setfontsize\sectionsize\@xipt{12.5}}
\newcommand\chaptitlesize{\@setfontsize\chaptitlesize\@xxpt{25}}

\def\@chapter[#1]#2{%
  \ifnum \c@secnumdepth >\m@ne
    \refstepcounter{chapter}%
    \typeout{\@chapapp\space\thechapter.}%
    \ifSFB@multisty
      \ifx\@shortauthor\@empty
        \addcontentsline{toc}{chapter}{\protect\numberline{\thechapter}#1}%
      \else
        \addcontentsline{toc}{chapter}{\protect\numberline{\thechapter}#1%
          \tocnewline{\normalit \@shortauthor\/}}%
      \fi
    \else
      \ifSFB@appendix
        \addcontentsline{toc}{chapter}{\protect\SFB@numberline{\thechapter}#1}%
      \else
        \addcontentsline{toc}{chapter}{\protect\numberline{\thechapter}#1}%
      \fi
    \fi
  \else
    \addcontentsline{toc}{chapter}{#1}%
  \fi
  \ifSFB@multisty
    \markboth{\@shortauthor}{#1}%
    \gdef\SFB@endnotehead{\relax}%
  \else
    \chaptermark{#1}%
    \gdef\SFB@endnotehead{\@chapapp\ \thechapter}%
  \fi
  \if@twocolumn
    \@topnewpage[\@makechapterhead{#2}]%
  \else
    \@makechapterhead{#2}%
    \@afterheading
  \fi
  \ifSFB@multisty
    \global\let\@author\@empty
    \global\let\@shortauthor\@empty
  \fi
}

\newcommand\makequoteRRlabel[1]{\hss\llap{\quotesize\normalrm #1}}
\renewcommand\theenumi{{\normalrm (\arabic{enumi})}}

\def\@enumeratetwo[#1]{\quotesize\normalrm
  \list{\csname label\@enumctr\endcsname}%
    {\settowidth\labelwidth{#1}%
     \leftmargin\labelwidth \advance\leftmargin\labelsep
     \usecounter{\@enumctr}%
     \let\makelabel\makequoteRRlabel}%
}

\def\@enumerateone{\quotesize\normalrm
  \list{\csname label\@enumctr\endcsname}%
    {\usecounter{\@enumctr}%
     \ifSFB@indentsty
       \ifdim\SFB@indent=\z@ \leftmargin 3em\fi
     \else
       \leftmargin 3em%
     \fi
     \let\makelabel\makequoteRRlabel}%
}

\renewenvironment{itemize}
  {\ifnum \@itemdepth >\thr@@ \@toodeep \else
     \advance\@itemdepth \@ne
     \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
     \quotesize\normalrm
     \list{\csname\@itemitem\endcsname}%
       {\advance\leftmargin 1pc\itemindent -1pc%
        \def\makelabel##1{\hss\llap{##1}}}%
   \fi}
  {\endlist}

\renewcommand\labelitemi{\quotesize\normalrm $\quotebullet$}

\renewenvironment{quote}
  {\list{}{\leftmargin\z@ \rightmargin\z@ \itemindent 1em%
  \topsep 0.5\baselineskip}\item[]\quotesize\normalrm}
  {\endlist}

\renewcommand\author@tabcrone{%
  {\ifnum0=`}\fi\@xtabularcr[-2.5\p@]\affilsize\normalit
  \ifSFB@titlepage
    \let\\\SFBauthor@tabcrtwo
  \else
    \let\\\author@tabcrtwo
  \fi
  \ignorespaces
}

\renewcommand\author@tabcrtwo{%
  {\ifnum0=`}\fi\@xtabularcr[-2.5\p@]\affilsize\normalit
  \ifSFB@titlepage
    \let\\\SFBauthor@tabcrtwo
  \else
    \let\\\author@tabcrtwo
  \fi
  \ignorespaces
}

\newcommand\authorand{%
  \end{author@tabular}\vskip -5\p@\par
  \ifSFB@indentsty
    \begin{author@tabular}[t]{@{}l@{}}%
  \else
    \begin{author@tabular}[t]{c}%
 \fi
}

\newif\ifdeepchapter

\renewcommand\@makechapterhead[1]{%
  {\normalsize\normalrm
   \parindent \z@
   \vspace*{-1.5\baselineskip}%
   \ifnum \c@secnumdepth >\m@ne
     \raisebox{0.5\baselineskip}[\z@][\z@]{\mbox{\hspace*{\SFB@indent}}%
     \begin{minipage}[t]{\textwidth}%
       \raggedright
       \ifSFB@appendix
         {\chapnumsize\normalrm Appendix \thechapter\par}%
       \else
         {\chapnumsize\gillsbf{\thechapter\par}}%
       \fi
       \hspace*{-\SFB@indent}\rule{\textwidth}{0.25\p@}%
       \vskip -.5\p@
       {\chaptitlesize\gillsrm{#1}\par}%
       \nobreak
       \vskip 10.5\p@
       \authorsize\normalrm
       \begin{author@tabular}[t]{@{}l@{}}
         \let\and\authorand \@author
       \end{author@tabular}
       \par
       \vspace{8.5\p@}%
       \ifdeepchapter
         \hspace*{-\SFB@indent}\rule{\textwidth}{0.25\p@}%
       \fi
     \end{minipage}}%
   \else
     \raisebox{0.5\baselineskip}[\z@][\z@]{\mbox{\hspace*{\SFB@indent}}%
     \begin{minipage}[t]{\textwidth}%
       \raggedright
       {\chapnumsize\gillsbf{\mbox{}}\par}%
       \hspace*{-\SFB@indent}\rule{\textwidth}{0.25\p@}%
       \vskip -.5\p@
       {\chaptitlesize\gillsrm{#1}\par}%
       \nobreak
       \vskip 14.5\p@
       \ifdeepchapter
        \hspace*{-\SFB@indent}\rule{\textwidth}{0.25\p@}%
       \fi
     \end{minipage}}%
   \fi
   \par \nobreak
   \vskip 10.5\baselineskip% 2.5 less than the first line of text
   \vskip -25\p@
   \ifdeepchapter \else
     \rule{\textwidth}{0.25\p@}%
     \vskip 2\baselineskip% caps change
   \fi
  }%
  \deepchapterfalse
}

\renewcommand\@makeschapterhead[1]{%
  {\normalsize\normalrm
   \parindent \z@
   \vspace*{-1.5\baselineskip}%
   \raisebox{0.5\baselineskip}[\z@][\z@]{\mbox{\hspace*{\SFB@indent}}%
   \begin{minipage}[t]{\textwidth}%
     \raggedright
     {\chapnumsize\gillsbf{\mbox{}}\par}%
     \hspace*{-\SFB@indent}\rule{\textwidth}{0.25\p@}%
     \vskip -.5\p@
     {\chaptitlesize\gillsrm{#1}\par}%
     \nobreak
   \end{minipage}}%
   \par \nobreak
   \vskip 10.5\baselineskip
   \vskip -25\p@
   \rule{\textwidth}{0.25\p@}%
   \vskip 2\baselineskip
   \if@chptxt
     \addvspace{24\p@ \@plus 2\p@}\unvbox\@chptxtbox
     \addvspace{6\p@}\global\@chptxtfalse
   \fi}%
}

\def\@startsection#1#2#3#4#5#6{% FROM LATEX.LTX (see MTS)
  \if@noskipsec \leavevmode \fi
  \par
  \@tempskipa #4\relax
  \@afterindenttrue
  \ifdim \@tempskipa <\z@
    \@tempskipa -\@tempskipa \@afterindentfalse
  \fi
  \if@nobreak
    \everypar{}%
    \ifnum#2=\tw@ \vskip 6\p@ \@plus1\p@\fi
    \ifnum#2=\thr@@ \vskip 6\p@ \@plus1\p@\fi
  \else
    \addpenalty\@secpenalty\addvspace\@tempskipa
  \fi
  \@ifstar
    {\@ssect{#2}{#3}{#4}{#5}{#6}}%
    {\@dblarg{\@sect{#1}{#2}{#3}{#4}{#5}{#6}}}}

\def\@ssect#1#2#3#4#5#6{% FROM LATEX.LTX (see MTS)
  \@tempskipa #4\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #5{%
        \@hangfrom{\hskip #2}%
          \interlinepenalty\@M
          \ifnum#1=\@ne {#6}\else #6\fi\@@par}%
    \endgroup
  \else
    \def\@svsechd{#5{\hskip #2\relax \ifnum#1=\@one {#6}\else #6\fi}}%
  \fi
  \@xsect{#4}}

\def\@afterheading{% FROM LATEX.LTX
  \global\@nobreaktrue
  \everypar{%
    \if@nobreak
      \global\@nobreakfalse
      \clubpenalty \@M
      \if@afterindent \hskip\SFB@indent \fi
      \hskip -\parindent
    \else
      \clubpenalty \@clubpenalty
      \everypar{}%
    \fi}}

\def\@seccntformat#1{\csname the#1\endcsname\quad}% FROM LATEX.LTX

\def\@sect#1#2#3#4#5#6[#7]#8{% FROM LATEX.LTX
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
        \@hangfrom{%
          \ifnum#2=\@ne \rlap{\@svsec}\hskip #3%
          \else
            \ifnum#2=\tw@ \rlap{\@svsec}\hskip #3%
            \else
              \hskip #3\relax\@svsec
            \fi
          \fi
          \interlinepenalty \@M #8\@@par}}%
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #7}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec #8}%
      \csname #1mark\endcsname{#7}%
      \addcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi
        #7}}%
  \fi
  \@xsect{#5}}

\renewcommand\section{%
  \@startsection {section}{1}{\SFB@indent}
    {12.5\p@ \@plus3.5\p@ \@minus2\p@}{0.001\p@}
    {\sectionsize\normalbf\SFB@hangraggedright}%
}

\renewcommand\subsection{%
  \@startsection{subsection}{2}{\SFB@indent}
    {12.5\p@ \@plus3.5\p@ \@minus2\p@}{0.001\p@}
    {\normalsize\normalbfit\SFB@hangraggedright}%
}

\renewcommand\subsubsection{%
  \@startsection{subsubsection}{3}{\SFB@indent}
    {12.5\p@ \@plus3.5\p@ \@minus2\p@}{0.001\p@}
    {\normalsize\normalit\SFB@hangraggedright}%
}

\renewcommand\paragraph{%
  \@startsection{paragraph}{4}{\SFB@indent}
    {12.5\p@ \@plus3.5\p@ \@minus2\p@}{-1pc}
    {\normalsize\normalit\SFB@raggedright}%
}

\renewcommand\subparagraph{%
  \@startsection{subparagraph}{5}{\SFB@indent}
    {13\p@ \@plus3.5\p@ \@minus2\p@}{-0.5em}
    {\normalsize\normalit\SFB@raggedright}%
}

\newcommand\xhead{%
  \@startsection{xhead}{6}{\SFB@indent}
    {-10\p@ \@plus-3.5\p@ \@minus-2\p@}{0.001\p@ \@plus 1\p@}
    {\small\normalbf\SFB@raggedright}%
}

\newcommand\yhead{%
  \@startsection{yhead}{7}{\SFB@indent}
    {-13\p@ \@plus-3.5\p@ \@minus-2\p@}{0.001\p@ \@plus 1\p@}
    {\small\normalbfit\SFB@raggedright}%
}

\newcounter{xhead}
\newcounter{yhead}
\let\xheadmark\@gobble
\let\yheadmark\@gobble

\setlength\footskip{22\p@}

\newenvironment{contfigure}
  {\let\@makecaption\make@contfigure@caption
   \SFB@floatindent=\SFB@indent
   \@ifnextchar[{\SFB@figone}{\SFB@figzero}}
  {\endSFB@float\end@float}

\newenvironment{contfigure*}
  {\let\@makecaption\make@contfigure@caption
   \@ifnextchar[{\SFB@widefigone}{\SFB@widefigzero}}
  {\endSFB@widefloat\end@float}

\newcommand\contfig@fmt[2]{%
  \small\normalrm #1 ({\normalit cont.})\enskip #2%
}

\newcommand\make@contfigure@caption[2]{\vskip 10\p@
  \addtocounter{figure}{-1}%
  \setbox\@tempboxa\hbox{\contfig@fmt{#1}{#2}}%
  \ifdim \wd\@tempboxa >\hsize
    {\contfig@fmt{#1}{#2}\par}%
  \else
    \ifSFB@indentsty
      \hbox to\hsize{\box\@tempboxa\hfill}\par
    \else
      \hbox to\hsize{\hfil\box\@tempboxa\hfil}\par
    \fi
  \fi
}

\renewenvironment{table}
  {\@footindent\z@
   \let\@makecaption\make@table@caption
   \SFB@floatindent=\SFB@indent
   \@ifnextchar[{\SFB@tabone}{\SFB@tabzero}}
  {\endSFB@float\end@float}

\renewenvironment{table*}
  {\@footindent\z@
   \let\@makecaption\make@table@caption
   \let\SFB@currenthline\SFB@fullhline
   \@ifnextchar[{\SFB@widetabone}{\SFB@widetabzero}}
  {\endSFB@widefloat\end@float}

\newenvironment{conttable}
  {\@footindent\z@
   \let\@makecaption\make@conttable@caption
   \SFB@floatindent=\SFB@indent
   \@ifnextchar[{\SFB@tabone}{\SFB@tabzero}}
  {\endSFB@float\end@float}

\newenvironment{conttable*}
  {\let\@makecaption\make@conttable@caption
   \@footindent\z@
   \let\SFB@currenthline\SFB@fullhline
   \@ifnextchar[{\SFB@widetabone}{\SFB@widetabzero}}
  {\endSFB@widefloat\end@float}

\newcommand\conttab@fmt[2]{%
  \normalrm #1\ ({\normalit cont.})\enskip
    \normalit #2%
}

\newcommand\make@conttable@caption[2]{\vskip 10\p@
  \addtocounter{table}{-1}%
  \setbox\@tempboxa\hbox{\conttab@fmt{#1}{#2}}%
  \ifdim \wd\@tempboxa >\hsize
    {\ifSFB@indentsty \raggedright\else \centering\fi
     \conttab@fmt{#1}{#2}\par}%
  \else
    \ifSFB@indentsty
      \hbox to\hsize{\box\@tempboxa\hfill}\par
    \else
      \hbox to\hsize{\hfil\box\@tempboxa\hfil}\par
    \fi
  \fi
  \vspace*{2.5\p@}\par
}

\renewcommand\SFB@float{\SFB@floatwidth \textwidth
  \addtolength{\SFB@floatwidth}{-\SFB@floatindent}%
  \hspace*{\SFB@floatindent}\minipage{\SFB@floatwidth}%
  \ifSFB@indentsty\raggedright\else\centering\fi\smallish}

\renewcommand\SFB@widefloat{\minipage{\textwidth}\raggedright\smallish}

\setcounter{tocdepth}{1}
\renewcommand\@pnumwidth{2.55em}
\renewcommand\@tocrmarg {3.55em}

\let\tocnewline\relax
\let\l@xhead\@gobbletwo
\let\l@yhead\@gobbletwo

\renewcommand*\l@chapter[2]{\pagebreak[3]%
  \def\tocnewline{\newline}%
  \vspace{\baselineskip}%
  \@tempdima \SFB@toclmarg
  \begingroup
    \parindent \z@  \rightskip \@pnumwidth  \parfillskip -\@pnumwidth
    \leavevmode
    \advance \leftskip \@tempdima  \hskip -\leftskip
    \ifSFB@firstTOCentry
      {\normalbf #1}\nobreak\hfil \nobreak
       \hbox to\@pnumwidth{\hss {\normalit page\/} #2}\par
      \global\SFB@firstTOCentryfalse
    \else
      {\normalbf #1}\nobreak\hfil \nobreak
       \hbox to\@pnumwidth{\hss #2}\par
    \fi
  \endgroup
}

\renewcommand*\l@schapter[2]{\pagebreak[3]%
  \@tempdima \SFB@toclmarg
  \begingroup
    \parindent \z@  \rightskip \@pnumwidth  \parfillskip -\@pnumwidth
    \leavevmode
    \advance \leftskip \@tempdima
    \ifSFB@firstTOCentry
      {\normalit #1}\nobreak\hfil \nobreak
       \hbox to\@pnumwidth{\hss {\normalit page\/} #2}\par
      \global\SFB@firstTOCentryfalse
    \else
      {\normalit #1}\nobreak\hfil \nobreak
       \hbox to\@pnumwidth{\hss #2}\par
    \fi
  \endgroup
}

\renewcommand\@fnsymbol[1]{\ifcase#1\or ^\ast\or \dagger\or \ddagger\or
   \S \or \P \or \|\or \dagger\dagger
   \or \ddagger\ddagger\or \S\S\or \P\P\or \|\|\else *\fi\relax}

\renewenvironment{thebibliography}[1]%
  {\chapter*{Bibliography}%
   \typeout{Bibliography.}%
   \bibliographylist}
  {\endlist}

\newenvironment{thebibliography*}[1]%
  {\chapter*{Bibliography}%
   \typeout{Bibliography.}%
   \bibliographyliststar{#1}}
  {\endlist}

\renewenvironment{thereferences}[1]
  {\section*{References}%
   \vspace*{2.5\p@}%
   \addcontentsline{toc}{schapter}{{\normalrm References}}%
   \bibliographylist}
  {\endlist}

\newenvironment{thereferences*}[1]
  {\section*{References}%
   \vspace*{2.5\p@}%
   \addcontentsline{toc}{schapter}{{\normalrm References}}%
   \bibliographyliststar{#1}}
  {\endlist}

\newenvironment{bibliographyliststar}[1]
  {\refsize\normalrm
   \raggedright
   \list{\@biblabel{\arabic{enumiv}}}%
   {\settowidth\labelwidth{\@biblabel{#1}}%
    \leftmargin\labelwidth
    \advance\leftmargin\labelsep
    \usecounter{enumiv}%
    \let\p@enumiv\@empty
    \def\theenumiv{\arabic{enumiv}}%
   \itemsep \z@ \@plus .1\p@}%
   \parindent\z@
   \parskip\z@ \@plus .1\p@\relax
   \sloppy\clubpenalty4000\widowpenalty4000%
   \sfcode`\.=\@m}
  {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}

\renewenvironment{bibliographylist}
  {\refsize\normalrm
   \raggedright
   \list{}{\usecounter{enumiv}\labelwidth\z@
     \leftmargin 1em%
     \itemsep \z@ \@plus .1\p@
     \itemindent-\leftmargin}%
   \parindent\z@
   \parskip\z@ \@plus .1\p@
   \sloppy\clubpenalty4000\widowpenalty4000%
   \sfcode`\.=\@m}
  {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}

\newcommand\newblock{\hskip .11em \@plus .33em \@minus .07em}

\def\ps@headings{\let\@mkboth\markboth
  \def\@evenhead{\listsize\normalbfit
                 \rlap{\upshape\thepage}\hspace*{\SFB@indent}%
                 \leftmark \hfill}%
  \def\@oddhead {\listsize\normalbfit
                 \hspace*{\SFB@indent}\rightmark\hfil {\upshape\thepage}}%
  \let\@evenfoot\@empty
  \let\@oddfoot\@empty
  \def\chaptermark##1{\markboth{##1}{##1}}%
  \def\sectionmark##1{\markright{\ifnum\c@secnumdepth>\z@
    \thesection\enskip\fi ##1}}%
}

\def\ps@myheadings{\let\@mkboth\@gobbletwo
  \def\@evenhead{\listsize\normalbfit
                 \rlap{\upshape\thepage}\hspace*{\SFB@indent}%
                 \leftmark \hfill}%
  \def\@oddhead {\listsize\normalbfit
                 \hspace*{\SFB@indent}\rightmark\hfil {\upshape\thepage}}%
  \let\@evenfoot\@empty
  \let\@oddfoot\@empty
  \let\chaptermark\@gobble
  \let\sectionmark\@gobble
  \let\subsectionmark\@gobble
}

\def\ps@plain{\let\@mkboth\@gobbletwo
  \let\@evenhead\@empty
  \let\@oddhead\@empty
  \def\@evenfoot{\listsize\normalbf\thepage\hfill}%
  \def\@oddfoot {\listsize\normalbf\hfill\thepage}%
}

\pagestyle{headings}
\pagenumbering{arabic}

\endinput

% end of file caps.cls

