% This is rqaa.cls
% Based on A&A DOCUMENT CLASS -- version 5.3 for LaTeX2e
%
% LaTeX document class modifying the Astronomy and Astrophysics journal
% style to omit logo, DOI and ESO copyright notice. Simply type
%
%   \documentclass[<options>]{rqaa}
%
% instead of
%
%   \documentclass[<options>]{aa}
%
% and optionally define
%
%   \idline{<your text>}{<number of your first page>}
%
% before making the title.
%
%%
%%
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{rqaa}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{aa}}
\ProcessOptions
\LoadClass{aa}
\AtEndOfClass{\idline{\relax}{1}\renewcommand{\makeheadbox}{{
                \hbox to\textwidth{%
                \vbox{\baselineskip=11pt
                \hbox{\@idline}
                \hbox{}
                \hbox{}}
                \hfill\mbox{}}}}}
\endinput
%%
%% End of file `rqaa.cls'.
