% LaTeX-Klasse fuer die Doktorarbeit von M. Ahr
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{madoc}[2002/02/21 
        LaTeX-Klasse fuer die Doktorarbeit von M. Ahr]
% Unbekannte Optionen an report weiterreichen
\DeclareOption*{%
        \PassOptionsToClass{\CurrentOption}{report}%
}
\ProcessOptions\relax
% Standardklasse report mit geeigneten Optionen laden 
\LoadClass[twoside,a4paper,12pt]{report}
% Benoetigte Pakete laden
\RequirePackage{a4}
% Seitenraender und Textbreite in metrischen Einheiten anstatt
% Zolls. Seitenhoehe bleibt wie's ist. 
\oddsidemargin 2.65 cm
\evensidemargin 2.65 cm
\marginparwidth 2 cm
\marginparsep 0.3 cm
\textwidth 15.6 cm
% Extrazoll bei Seitenraendern abziehen
\advance \oddsidemargin by -1 in
\advance \evensidemargin by -1 in 
% Figure x. und Table x. fett drucken
\def\fnum@figure{{\bfseries \figurename~\thefigure}}
\def\fnum@table{{\bfseries \tablename~\thetable}}
% Befehle fuer Kapitelueberschriften so umdefinieren dass
% Sans-Serif-Fonts verwendet werden 
\renewcommand\part{%
  \if@openright
    \cleardoublepage
  \else
    \clearpage
  \fi
  \thispagestyle{plain}%
  \if@twocolumn
    \onecolumn
    \@tempswatrue
  \else
    \@tempswafalse
  \fi
  \null\vfil
  \secdef\@part\@spart}

\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >-2\relax
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    \markboth{}{}%
    {\centering
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >-2\relax
       \normalfont\sffamily\Huge\bfseries \partname~\thepart
       \par
       \vskip 20\p@
     \fi
     \normalfont\sffamily\Huge\bfseries #2\par}%
    \@endpart}
\def\@spart#1{%
    {\centering
     \interlinepenalty \@M
     \normalfont
     \Huge \bfseries #1\par}%
    \@endpart}
\def\@endpart{\vfil\newpage
              \if@twoside
               \if@openright
                \null
                \thispagestyle{empty}%
                \newpage
               \fi
              \fi
              \if@tempswa
                \twocolumn
              \fi}
\renewcommand\chapter{\if@openright\cleardoublepage\else\clearpage\fi
                    \thispagestyle{plain}%
                    \global\@topnum\z@
                    \@afterindentfalse
                    \secdef\@chapter\@schapter}
\def\@chapter[#1]#2{\ifnum \c@secnumdepth >\m@ne
                         \refstepcounter{chapter}%
                         \typeout{\@chapapp\space\thechapter.}%
                         \addcontentsline{toc}{chapter}%
                                   {\protect\numberline{\thechapter}#1}%
                    \else
                      \addcontentsline{toc}{chapter}{#1}%
                    \fi
                    \chaptermark{#1}%
                    \addtocontents{lof}{\protect\addvspace{10\p@}}%
                    \addtocontents{lot}{\protect\addvspace{10\p@}}%
                    \if@twocolumn
                      \@topnewpage[\@makechapterhead{#2}]%
                    \else
                      \@makechapterhead{#2}%
                      \@afterheading
                    \fi}
\def\@makechapterhead#1{%
% Abstand zwischen oberem Rand und Kapitelueberschrift
\vspace*{50\p@}%
  {\parindent \z@ \raggedright \normalfont
    \ifnum \c@secnumdepth >\m@ne
% Normale Kapitelueberschriften
        \normalfont\sffamily\huge\bfseries  \@chapapp\space \thechapter
        \par\nobreak
        \vskip 20\p@
    \fi
    \interlinepenalty\@M
    \normalfont\sffamily\Huge\bfseries #1\par\nobreak
    \vskip 40\p@
  }}
\def\@schapter#1{\if@twocolumn
                   \@topnewpage[\@makeschapterhead{#1}]%
                 \else
                   \@makeschapterhead{#1}%
                   \@afterheading
                 \fi}
\def\@makeschapterhead#1{%
%  \vspace*{50\p@}%
  {\parindent \z@ \raggedright
    \normalfont
    \interlinepenalty\@M
    \normalfont\sffamily\Huge\bfseries #1\par\nobreak
    \vskip 40\p@
  }}
\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\normalfont\sffamily\Large\bfseries}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\sffamily\large\bfseries}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\sffamily\normalsize\bfseries}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\normalfont\sffamily\normalsize\bfseries}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                      {\normalfont\sffamily\normalsize\bfseries}}

