%%
%% This is file `rmaa.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% rmaa.dtx  (with options: `package')
%% 
%% PLEASE DO NOT EDIT THIS FILE! It is generated automatically from
%% the file rmaa.dtx using the accompanying Makefile and rmaa.ins
%% Any hand-edited changes will be lost
%% 
%% A LaTeX document class for the RevMexAA
%% 
%% Author: William Henney (w.henney@astrosmo.unam.mx)
%% 
%% Latest version available from: http://www.astrosmo.unam.mx/rmaa
%% 
%% Copyright (C) 1999-2003 Instituto de Astronomia, UNAM, Mexico
%% 
%% This program is free software; you can redistribute it and/or
%% modify it under the terms of the GNU General Public License
%% as published by the Free Software Foundation; either version 2
%% of the License, or (at your option) any later version.
%% 
%% This program is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%% GNU General Public License for more details.
%% 
%% You should have received a copy of the GNU General Public License
%% along with this program; if not, write to the Free Software
%% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

\newcommand{\rmaa@version}{3.14}
\newcommand{\rmaa@date}{2003/02/06}
\NeedsTeXFormat{LaTeX2e}[1995/06/01]
\ProvidesClass{rmaa}[\rmaa@date\space v\rmaa@version\space RevMexAA article
class]
\newif\if@proof
\@prooffalse
\newif\if@journal
\@journaltrue
\newif\if@proceedings
\@proceedingsfalse
\newif\if@manuscript
\@manuscriptfalse
\newif\if@guide
\@guidefalse
\newif\if@preprint
\@preprintfalse
\newif\if@rmtwocol
\@rmtwocoltrue
\newif\if@biblist
\@biblistfalse
\newif\if@book
\@bookfalse
\newif\if@natbib
\@natbibtrue
\newif\if@rmcite
\@rmcitefalse
\newif\if@titlevisible
\@titlevisibletrue
\newif\if@abstractpresent
\@abstractpresentfalse
\newif\if@printbanner
\@printbannerfalse
\newif\if@suppressfulladdresses
\@suppressfulladdressesfalse
\newif\if@newstyle
\@newstylefalse
\newif\if@debug
\@debugfalse
\DeclareOption{manuscript}{\typeout{Manuscript for referee}
  \@manuscripttrue\@journalfalse\@rmtwocolfalse
  \PassOptionsToClass{12pt}{article}}
\DeclareOption{journal}{\typeout{Main journal option}%
  \@journaltrue\@rmtwocoltrue}
\DeclareOption{guide}{\typeout{User guide option}%
  \@guidetrue\@journalfalse\@rmtwocoltrue}
\DeclareOption{preprint}{\typeout{Preprint option}%
  \@preprinttrue}
\DeclareOption{proof}{\typeout{Author proof option}%
  \@prooftrue}
\DeclareOption{proceedings}{\typeout{Proceedings option}%
  \@proceedingstrue\@journalfalse\@rmtwocoltrue\@newstyletrue}
\DeclareOption{book}{\typeout{Whole issue option}%
  \@booktrue}
\DeclareOption{nonatbib}{\typeout{Turn off natbib support (required
    for compatibility with old rmaacite package).}%
  \@natbibfalse}
\DeclareOption{newstyle}{\typeout{Use new layout style}%
  \@newstyletrue}
\DeclareOption{oldstyle}{\typeout{Use old layout style}%
  \@newstylefalse}
\DeclareOption{debug}{\typeout{Loads of annoying messages}%
  \@debugtrue}
\DeclareOption{twocolumn}{\@rmtwocoltrue}
\DeclareOption{onecolumn}{\@rmtwocolfalse}
\DeclareOption{twoside}{\PassOptionsToClass{\CurrentOption}{article}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ExecuteOptions{twoside,article} \ProcessOptions\relax
\if@book
\if@rmtwocol\LoadClass[twocolumn]{book}\else\LoadClass{book}\fi
\newcommand{\abstract}{\relax}
\newcommand{\@maketitle}{\relax}
\else
\if@rmtwocol\LoadClass[twocolumn]{article}\else\LoadClass{article}\fi
\fi
\if@natbib
\RequirePackage[longnamesfirst]{natbib}[1999/02/25]
\bibpunct{(}{)}{;}{a}{}{,}
\newcommand\bibfont{\small}
\renewcommand\bibsection{\section*{REFERENCES}}
\setlength\bibsep{0pt}
\setlength\bibhang{1.5em}
\bibliographystyle{authordate}
\fi
\RequirePackage{graphicx}
\RequirePackage{ifthen}
\IfFileExists{babel.sty}{%
  \RequirePackage[english]{babel}
  %% reinstate the definition of \@roman so as not to break .idx files
  \@ifundefined{org@@roman}{\relax}{\renewcommand{\@roman}[1]{\org@@roman{##1}}}
  }{%
  \typeout{Package babel.sty not found - don't worry about this}}
\IfFileExists{dcolumn.sty}{%
  \RequirePackage{dcolumn}
  }{%
  \typeout{Package dcolumn.sty not found - you will not be able to
    align columns on decimal points in tables}}
\IfFileExists{booktabs.sty}{%
  \RequirePackage{booktabs}
  }{%
  \typeout{Package booktabs.sty not found - your tables will not look
    as pretty as they ought too.}
  }
\IfFileExists{makeidx.sty}{%
  \RequirePackage{makeidx}
}{%
  \typeout{Package makeidx.sty not found - Author Index may not work.}
  }
%% commented out for moment since requires more modern version of LaTeX
%%\RequirePackage[latin1]{inputenc}
\IfFileExists{url.sty}{%
  \RequirePackage{url}
  \newcommand\email{\begingroup \urlstyle{rm}\Url}
  }{%
  \typeout{Package url.sty not found - line breaks in email addresses
    will not work properly.}
  \newcommand\email[1]{#1}
  }
\newif\if@needaddresses
\@needaddressestrue
\newif\if@frontmatter
\@frontmatterfalse
\newif\if@inpreamble
\@inpreambletrue
\newif\if@firstauthor
\@firstauthortrue
\newif\if@firstaffil
\@firstaffiltrue
\newif\if@firstaltaffil
\@firstaltaffiltrue
\newif\if@firstkwd
\@firstkwdtrue
\newif\if@noexpandADS
\@noexpandADSfalse
\newif\if@sessiontitlepages
\@sessiontitlepagesfalse
\newcommand{\@rmaaEmpty}{}
\newcommand{\@rmaaArg}{}
\providecommand{\MakeUpperCase}[1]{\uppercase{#1}}
\providecommand{\textsuperscript}[1]{\ensuremath{^\textrm{#1}}}
\providecommand{\textbackslash}{\ensuremath{\backslash}}
\providecommand{\protected@xdef}{%
        \let\@@protect\protect
        \let\protect\@unexpandable@protect
        \afterassignment\restore@protect
        \xdef}
\providecommand{\restore@protect}{\let\protect\@@protect}
\providecommand{\@unexpandable@protect}{\noexpand\protect\noexpand}
\providecommand{\hb@xt@}{\hbox to}
\setlength{\textwidth}{169mm}
\setlength{\@tempdima}{\paperwidth}
\addtolength{\@tempdima}{-\textwidth}
\setlength{\oddsidemargin}{0.5\@tempdima}
\addtolength{\oddsidemargin}{-1in}
\setlength{\evensidemargin}{\oddsidemargin}
\setlength{\textheight}{225mm}
\setlength{\topmargin}{-1in}
\addtolength{\topmargin}{14mm}
\setlength{\columnsep}{9.5mm}
\setlength{\headsep}{0.7cm}
\setlength{\footskip}{0.75cm}
\setlength{\parindent}{1.5em}
\newcommand\@set@scalable@length[4]{%
  %% arg #1: NAME of length without leading `\'
  %%
  %% arg #2: default VALUE
  \expandafter\newlength\csname @#1@default\endcsname
  \expandafter\setlength\csname @#1@default\endcsname{#2}%
  \expandafter\newlength\csname @@#1@@default\endcsname
  \expandafter\setlength\csname @@#1@@default\endcsname{#2}%
  %% arg #3: default STRETCH
  \expandafter\newlength\csname @#1@stretch\endcsname
  \expandafter\setlength\csname @#1@stretch\endcsname{#3}%
  \expandafter\newlength\csname @@#1@@stretch\endcsname
  \expandafter\setlength\csname @@#1@@stretch\endcsname{#3}%
  %% arg #4: default SHRINK
  \expandafter\newlength\csname @#1@shrink\endcsname
  \expandafter\setlength\csname @#1@shrink\endcsname{#4}%
  \expandafter\newlength\csname @@#1@@shrink\endcsname
  \expandafter\setlength\csname @@#1@@shrink\endcsname{#4}%
  %%
  %% User-defined scale \@NAME@scale is unity by default
  \expandafter\gdef\csname @#1@scale\endcsname{1}%
  %% Package-defined scale \@NAME@SCALE is unity by default
  \expandafter\gdef\csname @#1@SCALE\endcsname{1}%
  %%
  %% internal command \@reset@NAME should expand to
  %% \setlength\@@NAME@@default{\@NAME@SCALE\@NAME@default}
  %% \setlength\NAME{\@NAME@scale\@@NAME@@default}
  %% in other words: scale x SCALE x default
  \expandafter\gdef\csname @reset@#1\endcsname{%
    \expandafter\setlength\csname @@#1@@default\endcsname{%
      \csname @#1@SCALE\endcsname \csname @#1@default\endcsname
      }
    \expandafter\setlength\csname @@#1@@stretch\endcsname{%
      \csname @#1@SCALE\endcsname \csname @#1@stretch\endcsname
      }
    \expandafter\setlength\csname @@#1@@shrink\endcsname{%
      \csname @#1@SCALE\endcsname \csname @#1@shrink\endcsname
      }
    \expandafter\setlength\csname #1\endcsname{%
      \csname @#1@scale\endcsname \csname @@#1@@default\endcsname
      \@plus
      \csname @#1@scale\endcsname \csname @@#1@@stretch\endcsname
      \@minus
      \csname @#1@scale\endcsname \csname @@#1@@shrink\endcsname
      }}
  %%
  %% User command \NAMEScale should expand to
  %% {\renewcommand\@NAME@scale{#1}\@reset@NAME}
  \expandafter\gdef\csname #1Scale\endcsname##1{%
    \expandafter\gdef\csname @#1@scale\endcsname{##1}%
    \csname @reset@#1\endcsname}
  %%
  %% Package command \NAME@set@SCALE should expand to
  %% {\renewcommand\@NAME@SCALE{#1}\@reset@NAME}
  \expandafter\gdef\csname #1@set@SCALE\endcsname##1{%
    \expandafter\gdef\csname @#1@SCALE\endcsname{##1}%
    \csname @reset@#1\endcsname}
  %%
  %% initialize at default values with \@reset@NAME
  \csname @reset@#1\endcsname
  }
\@set@scalable@length{parskip}{0\p@}{0.3\p@}{0\p@}
\newlength{\abovesectionskip}
\newlength{\belowsectionskip}
\newlength{\aboveparaskip}
\newlength{\belowparaskip}
\@set@scalable@length{abovesectionskip}{3.5ex}{4ex}{2ex}
\@set@scalable@length{belowsectionskip}{2.3ex}{0ex}{2ex}
\@set@scalable@length{aboveparaskip}{3.25ex}{2ex}{0.5ex}
\@set@scalable@length{belowparaskip}{-1em}{\z@}{\z@}
\@set@scalable@length{floatsep}{12\p@}{4\p@}{4\p@}
\@set@scalable@length{textfloatsep}{20\p@}{4\p@}{8\p@}
\@set@scalable@length{intextsep}{12\p@}{4\p@}{4\p@}
\@set@scalable@length{dblfloatsep}{12\p@}{4\p@}{4\p@}
\@set@scalable@length{dbltextfloatsep}{20\p@}{4\p@}{8\p@}
\@set@scalable@length{abovecaptionskip}{10\p@}{\z@}{\z@}
\newlength{\@before@title@skip}
\newlength{\@before@author@skip}
\newlength{\@between@author@skip}
\newlength{\@before@abstract@skip}
\newlength{\@after@abstracthead@skip}
\newlength{\@between@abstract@skip}
\newlength{\@before@kwd@skip}
\@set@scalable@length{@before@title@skip}{2em}{\z@}{\z@}
\@set@scalable@length{@before@author@skip}{1.5em}{\z@}{\z@}
\@set@scalable@length{@between@author@skip}{0.5em}{\z@}{\z@}
\@set@scalable@length{@before@abstract@skip}{3ex}{1ex}{0.5ex}
\@set@scalable@length{@after@abstracthead@skip}{1ex}{\z@}{\z@}
\@set@scalable@length{@between@abstract@skip}{2ex}{1ex}{0.5ex}
\@set@scalable@length{@before@kwd@skip}{1ex}{0.5ex}{0.2ex}
\newcommand{\@package@default@lengths}{%
  \ifthenelse{\boolean{@rmtwocol}}{%
    %% twocolumn mode
    \abovesectionskip@set@SCALE{0.5}
    \belowsectionskip@set@SCALE{0.5}
    \aboveparaskip@set@SCALE{0.5}
    \belowparaskip@set@SCALE{1}
    \floatsep@set@SCALE{0.5}
    \textfloatsep@set@SCALE{0.5}
    \intextsep@set@SCALE{0.5}
    \dblfloatsep@set@SCALE{0.5}
    \dbltextfloatsep@set@SCALE{0.5}
    }{%
    %% onecolumn mode
    \abovesectionskip@set@SCALE{1}
    \belowsectionskip@set@SCALE{1}
    \aboveparaskip@set@SCALE{1}
    \belowparaskip@set@SCALE{1}
    \floatsep@set@SCALE{1}
    \textfloatsep@set@SCALE{1}
    \intextsep@set@SCALE{1}
    \dblfloatsep@set@SCALE{1}
    \dbltextfloatsep@set@SCALE{1}
    }%
  }
\@package@default@lengths
\newcommand{\RescaleLengths}[1]{%
  \RescaleSecLengths{#1}\RescaleFloatLengths{#1}\RescaleTitleLengths{#1}}
\newcommand{\RescaleSecLengths}[1]{%
%% sections
  \abovesectionskipScale{#1}
  \belowsectionskipScale{#1}
  \aboveparaskipScale{#1}
  }
\newcommand{\RescaleFloatLengths}[1]{%
%% floats
  \floatsepScale{#1}
  \textfloatsepScale{#1}
  \intextsepScale{#1}
  \dblfloatsepScale{#1}
  \dbltextfloatsepScale{#1}
  \abovecaptionskipScale{#1}
  }
\newcommand{\RescaleTitleLengths}[1]{%
%% maketitle
  \@before@title@skipScale{#1}
  \@before@author@skipScale{#1}
  \@between@author@skipScale{#1}
  \@before@abstract@skipScale{#1}
  \@after@abstracthead@skipScale{#1}
  \@between@abstract@skipScale{#1}
  \@before@kwd@skipScale{#1}
  }

\newlength{\MSextramargin}
\setlength{\MSextramargin}{0.3in}
\if@manuscript
   \renewcommand{\baselinestretch}{1.5}
   \addtolength{\textwidth}{-2\MSextramargin}
   \addtolength{\oddsidemargin}{\MSextramargin}
   \setlength{\evensidemargin}{\oddsidemargin}
   \addtolength{\textheight}{-2\MSextramargin}
   \addtolength{\topmargin}{\MSextramargin}
   \raggedright
\fi
\renewcommand{\fps@figure}{tp}
\renewcommand{\fps@table}{tp}
\newcommand{\rmaa@AuthorWidthFrac}{1.0}
\newcommand{\rmaa@AbstractWidthFrac}{0.75}
\if@newstyle\renewcommand{\rmaa@AbstractWidthFrac}{1.0}\fi
%%\widowpenalty=10000
%%\clubpenalty=10000
\hbadness=10000
\vbadness=10000
\setlength\hfuzz{\maxdimen}
\setlength\vfuzz{\maxdimen}
\newcommand{\rmaa@AffilStyle}[1]{{\normalsize\rmfamily#1}}
\newcommand{\rmaa@PagesStyle}[1]{{\normalsize\rmfamily#1}}
\newcommand{\rmaa@YearStyle}[1]{{\normalsize\rmfamily#1}}
\newcommand{\rmaa@VolumeStyle}[1]{{\normalsize\rmfamily\bfseries#1}}
\newcommand{\rmaa@VolumenStyle}[1]{{\Large\sffamily\bfseries#1}}
\newcommand{\rmaa@JournalNameStyle}[1]{{\normalsize\itshape#1}}
\newcommand{\rmaa@ReceivedStyle}[1]{{\normalsize\rmfamily\itshape#1}}
\newcommand{\rmaa@AbstractHeaderStyle}[1]{%
  {\normalsize\rmfamily\MakeUpperCase{#1}}}
\newcommand{\rmaa@TitleStyle}[1]{%
  {\large\bfseries\rmfamily\boldmath\MakeUpperCase{#1}\par}}
\newcommand{\rmaa@FrontSecStyle}[1]{%
  {\normalsize\bfseries\rmfamily\MakeUpperCase{#1}}}
\newcommand{\rmaa@TOCTitleStyle}[1]{\MakeUpperCase{#1}}
\newcommand{\rmaa@TOCPartStyle}[1]{\rmaa@TOCTitleStyle{#1}}
\newcommand{\rmaa@IndexTitleStyle}[1]{#1}
\newcommand{\rmaaTOCAuthorStyle}[1]{%
  {\itshape#1}}
\newcommand{\rmaaIndexAuthorStyle}[1]{%
  \protect\mbox{\bfseries#1}}
\ifthenelse{\boolean{@newstyle}}{
  \newcommand{\rmaa@KeywordStyle}[1]{%
    {\small\bfseries\MakeUpperCase{\raggedright #1}}}
  \newcommand{\rmaa@KeywordHeaderStyle}[1]{%
    {\small\itshape#1}}}
{
  \newcommand{\rmaa@KeywordStyle}[1]{%
    {\normalsize\bfseries{\raggedright #1}}}
  \newcommand{\rmaa@KeywordHeaderStyle}[1]{%
    {\normalsize\itshape#1}}}
\newcommand{\ps@rmaa}{%
  \renewcommand\@oddfoot{\relax}%
  \renewcommand\@evenfoot{\relax}%
  \renewcommand\@evenhead{\rlap{\thepage}\hfil\@shortauthor\hfil}%
  \renewcommand\@oddhead{\hfil\@shorttitle\hfil\llap{\thepage}}
  }
\newcommand{\ps@rmaafirstpage}{%
  \renewcommand\@oddfoot{\hfil\thepage}%
  \renewcommand\@evenfoot{\thepage\hfil}%
  \renewcommand\@oddhead{%
    \if@preprint
    \if@proceedings \textsc{To appear in ``\@conftitle{}
      (\rmaa@YearStyle{\@year})''}\hfil \textit{RevMexAA(SC)}
    \else\textsc{To appear in} \@journalname\hfil\fi
    \else\if@guide
    \textsc{Documentation} (\rmaa@YearStyle{\@year})\hfil
    \else
    \@journalname, \rmaa@VolumeStyle{\@volume},
    \rmaa@PagesStyle{\@artpages}\
    \if@manuscript\textbf{MS\#\@MSnum}\ \fi\fi
    (\rmaa@YearStyle{\@year})\hfil
    \fi}%
  \renewcommand\@evenhead{\@oddhead}}
\pagestyle{rmaa}
\newif\if@setresumen
\newcommand{\resumen}[1]{%
%%  \renewcommand{\@resumen}{{\selectlanguage{spanish}#1}}%
  \renewcommand{\@resumen}{{\ignorespaces#1}}%
  \@setresumentrue}
\renewcommand{\abstract}[1]{%
  \renewcommand{\@abstract}{{\ignorespaces#1}}
  \renewcommand\ADS@abstract{#1}
%% Not a good idea, since then author macros are not expanded and
%% cause errors later. However, by not doing it we are vulnerable to
%% fragile commands.....
  \if@noexpandADS\@onelevel@sanitize{\ADS@abstract}\fi
  \@abstractpresenttrue
  }
\newcommand{\ADSnoexpand}{\@noexpandADStrue}
\newcommand{\boldabstract}[1]{%
  \gdef\ADS@abstract{#1}%
  \renewcommand{\@abstract}{#1}%
  \if@noexpandADS\@onelevel@sanitize{\ADS@abstract}\fi%
  \noindent\textbf{\boldmath #1}
  }
\newcommand{\@resumen}{%
  \@setresumenfalse
  \ClassWarningNoLine{rmaa}{No resumen specified - this will be
    translated by the editors}%
  \textbf{El resumen ser\'a traducido al espa\~nol por los editores.} }
\newcommand{\@abstract}{\ClassWarningNoLine{rmaa}{No abstract specified}}
\newcommand{\@rawtitle}{Raw Title}
\newcommand{\@TOCtitle}{\rmaa@TOCTitleStyle{Title for TOC}}
\newcommand{\rmaaIndexTitle}{\rmaa@IndexTitleStyle{Title for index}.}
\newcommand{\@TOCaftertitle}{}
\renewcommand{\title}[1]{%
  \renewcommand{\@rawtitle}{#1}
  \let\ADS@title=\@rawtitle
  \renewcommand{\@title}{\rmaa@TitleStyle{#1}}%
  \renewcommand{\@TOCtitle}{\rmaa@TOCTitleStyle{#1}\@TOCaftertitle}%
  \renewcommand{\rmaaIndexTitle}{\rmaa@IndexTitleStyle{#1\@TOCaftertitle}.}%
  }
\newcommand{\affil}[1]{%
  \\[1.5ex]\rmaa@AffilStyle{#1}\\[1.5ex]%
  \if@firstaffil\gdef\ADS@affil{#1}\@firstaffilfalse\fi%
  }
\renewcommand{\and}{and\\[1.5ex]}
\newcommand{\altaffil}[1]{%
  \if@firstaltaffil\gdef\ADS@affil{#1}\@firstaltaffilfalse\fi%
  \thanks{#1}}
\newcommand{\altaffilmark}[1]{\textsuperscript{#1}}
\newcommand{\altaffiltext}[2]{%
  \if@firstaltaffil\gdef\ADS@affil{#2}\@firstaltaffilfalse\fi
  \stepcounter{footnote}%
  \protected@xdef\@thanks{\@thanks
    \protect\footnotetext[#1]{#2}}}
\newcommand{\@kwdsep}{ --- }
\newcommand{\ADS@kwdsep}{, }
\newcommand{\addkeyword}[1]{%
  \if@firstkwd%
  \renewcommand\@keywords{\uppercase{#1}}
  {\ADS@sanitize\def\ion{\plainion}\gdef\ADS@keywords{#1}}
  \@firstkwdfalse
  \else%
  \edef\@keywords{\@keywords\@kwdsep \uppercase{#1}}%
  {\ADS@sanitize\def\ion{\plainion}\xdef\ADS@keywords{\ADS@keywords\ADS@kwdsep #1}}%
  \fi}
\newcommand{\ADS@sanitize}{%
  \def\mathrm{}
  \def\@{\ }
  \def~{\ }
  \def\langle{<}
  \def\rangle{>}
  \def\log{log }
  \def\sin{sin }
  \def\cos{cos }
  \def\tan{tan }
  \def\fd{^d.}
  \def\fh{^h.}
  \def\fm{^m.}
  \def\fs{^s.}
  \def\fdg{.}
  \def\farcm{'.}
  \def\farcs{''.}
  \def\arcdeg{}
  }
\newcommand{\keywords}[1]{%
  \renewcommand{\ADS@keywords}{#1}
  \renewcommand{\@keywords}{\uppercase{#1}}
  }
\newcommand{\@keywordheader}{\rmaa@KeywordHeaderStyle{Key Words:}}
\newcommand{\@keywords}{%
  \ClassWarningNoLine{rmaa}{No keywords specified}%
  Keywords go here
  }
\newcommand{\shorttitle}[1]{%
  \renewcommand\@shorttitle{\MakeUpperCase{#1}}}
\newcommand{\shortauthor}[1]{%
  \renewcommand\@shortauthor{\MakeUpperCase{#1}}}
\newcommand{\@shorttitle}{SHORT TITLE GOES HERE}
\newcommand{\@shortauthor}{SHORT AUTHOR GOES HERE}

\newlength{\@fulladdheight}
\newlength{\@fulladddepth}
\newsavebox{\@fulladdbox}
%% \fulladdresses command modified (11 May 2000) so that we can put
%% \fulladdresses{} in the article to suppress the output of the
%% addresses
\newcommand{\@FinalFigure}{\relax}
\newcommand{\FinalFigure}[1]{\renewcommand{\@FinalFigure}{#1}}
\newcommand{\fulladdresses}[1]{%
  \renewcommand{\@rmaaArg}{#1}
  \ifx\@rmaaArg\@rmaaEmpty
     \renewcommand{\@fulladdresses}{}
  \else
     \renewcommand{\@fulladdresses}{
       \normalsize%
       \ifx\@FinalFigure\relax\else\vfill\@FinalFigure\vfill\fi
%%       \vspace*{1ex}
       %% do addresses as a list (copied from thebibliography environment)
       \list{\null}{\leftmargin 1.5em\topsep\z@\labelwidth\z@\labelsep\z@\itemindent -1.5em
         \itemsep\z@\parsep\z@\usecounter{enumi}}
       \sloppy\clubpenalty4000\widowpenalty4000
       \sfcode`\.=1000\relax
       #1
       \endlist
       }
  \fi
  }
\newcommand{\@fulladdresses}{Full addresses go here}
\newcommand{\suppressfulladdresses}{\@suppressfulladdressestrue\@needaddressesfalse}

\newcommand{\@outputaddressesifnecessary}{%
  \ClassInfo{rmaa}{Calling @outputaddressesifnecessary}
  \ifthenelse{\boolean{@needaddresses}}{%
    %% If in one column style, or in the first column of a two column
    %% style then we can try to put it on this page
    \ifthenelse{\boolean{@firstcolumn} \or \not\boolean{@rmtwocol}}{%
      \@outputaddresses}{%
      %% otherwise give warning it will be on a separate page
      \ClassWarning{rmaa}{Full addresses will go on a separate
        page (please see User Guide for how to remedy this)}}%
    %% If we haven't managed yet, put it on its own page
    \ifthenelse{\boolean{@needaddresses}}{%
      \if@debug{\ClassWarning{rmaa}{In this silly bit!}}\fi
      \clearpage\vfill\@outputaddresses}{}%
    }{
    %% If we don't need them, we still might need to do the eoa hook
    \ifthenelse{\boolean{@suppressfulladdresses}}{%
      \if@debug{\ClassWarning{rmaa}{XXX}}\fi
%%      \if@book\else\@endofarticlehook\null\fi
      }{}
    }%
  }

\newcommand{\outputfulladdresses}{\@outputaddressesifnecessary}

\newcommand{\adjustfinalcols}{\if@twocolumn\goodbreak\@outputaddresses\newpage\noindent\fi}

\newcommand{\@outputaddresses}{%
  % Allow option of suppressing the full addresses, in which case
  % we just run the hook if we are not in a book style
  \if@suppressfulladdresses
%%     \if@book\else\@endofarticlehook\null\fi
  \else
  %% save the full addresses in a box for output later
  \sbox{\@fulladdbox}{\parbox{\textwidth}{\@fulladdresses}}
  % calculate height of address box
  \settoheight{\@fulladdheight}{\usebox{\@fulladdbox}}
  \settodepth{\@fulladddepth}{\usebox{\@fulladdbox}}
  \addtolength{\@fulladdheight}{\@fulladddepth}
  \if@debug
  { \typeout{Address total height: \the\@fulladdheight}
    \typeout{Text height: \the\pagetotal}
    \typeout{Goal height: \the\pagegoal}
    }
  \fi
  % reuse \@fulladdheight to mean the total height of text+addresses
  \addtolength{\@fulladdheight}{\pagetotal}
%%  \addtolength{\@fulladdheight}{-\baselineskip}
  \if@debug\typeout{Adjusted text + addresses height: \the\@fulladdheight}\fi
  % check it will fit on current page
  \ifdim\@fulladdheight<\pagegoal
     %% must shift it to the left
     %% to compensate for the hanging indentation in the reference list.
     %% NOTE: this is not foolproof!
     %% NB. This will give overfull hbox warnings, which is a bit ugly.
     \vfill\noindent\if@biblist\hspace*{-\leftmargin}\fi
     \usebox{\@fulladdbox}
     % Set this to show we've done it
     \@needaddressesfalse
     % and assume we are at the end of the article
     % so that we do the EOA hook if not in the book style
%%     \if@book\else\@endofarticlehook\fi
  \else
     % if not, just do nothing. With luck, this function will get
     % called again on the next page
     \if@debug{\typeout{Holding over full addresses to next page}}\fi
  \fi\fi
  }

\newcommand{\@rawauthors}{Raw Authors}
\newcommand{\rmaaTOCauthors}{\noexpand\rmaaTOCAuthorStyle{Author list for TOC}}
\newcommand{\listofauthors}[1]{%
  \renewcommand{\@rawauthors}{#1}
  \renewcommand\rmaaTOCauthors{\noexpand\rmaaTOCAuthorStyle{#1}}}
\newcommand\@isortkey{}
\newcommand\@emptykey{empty}
\newcommand\indexauthor[2][empty]{
  \renewcommand\@isortkey{#1}
  \ifx\@isortkey\@emptykey \renewcommand\@isortkey{#2}\fi
  \index{\@isortkey @{{\rmaaIndexAuthorStyle{#2}}\hskip1em plus1em minus0.4em
      \rmaaIndexTitle\hskip1em plus2em minus0.4em\penalty-100
      \rmaaTOCauthors}}}
%%\def\indexauthor@deferlist{\relax}
%%\long\def\indexauthor#1{
%%  \def\@@name{#1} \toks0=\expandafter{\@@name}
%%  \toks1=\expandafter{\indexauthor@deferlist}
%%  \protected@xdef\indexauthor@deferlist{%
%%    \the\toks1
%%    \noexpand\index{\the\toks0@{\noexpand\rmaaIndexAuthorStyle{\the\toks0}\noexpand\hskip1em plus1em minus0.4em
%%        \rmaaIndexTitle\noexpand\hskip1em plus2em minus0.4em\noexpand\penalty-100
%%        \rmaaTOCauthors}}
%%  }
%%  \indexauthorADS{#1}
%%  }
%%\xdef\indexauthor@deferlist{}
\newcommand\indexauthorADS[1]{%
  \if@firstauthor\protected@xdef\ADS@authorinitial{\firstletter{#1}}\fi
  \protected@xdef\ADS@authors{\ADS@authors\if@firstauthor\else ; \fi
    #1}
  \@firstauthorfalse
}

\newcommand{\KillAllAccents}{\def\'{}\def\`{}\def\~{}\def\.{}\def\i{i}}
\newcommand\firstletter[1]{\@car #1\@nil}
\newcommand{\SetVolume}[1]{%
  \renewcommand{\@volume}{#1}
  \edef\ADS@volume{\PadToFourWithDots{#1}}
  \renewcommand{\@volumen}{\rmaa@VolumenStyle{volumen #1}}%
  }
\newcommand{\SetMSnumber}[1]{\renewcommand{\@MSnum}{#1}}
\newcommand{\SetFirstPage}[1]{\setcounter{page}{#1}}
\newcommand{\SetYear}[1]{%
  \renewcommand{\@year}{#1}
  \renewcommand{\ADS@year}{#1}
  \renewcommand{\@anyo}{\rmaa@VolumenStyle{#1}}
  }
\newcommand{\ReceivedDate}[1]{\renewcommand{\@received}{#1}}
\newcommand{\AcceptedDate}[1]{\renewcommand{\@accepted}{#1}}
\newcommand{\@volume}{00}
\newcommand{\@volumen}{\rmaa@VolumenStyle{00}}
\newcommand{\@artpages}{%
  \pageref{RMAAFirstPage}--\pageref{RMAALastPage}}
\newcommand{\@year}{2001}
\newcommand{\@anyo}{\rmaa@VolumenStyle{2001}}
\newcommand{\@journalname}{\rmaa@JournalNameStyle{%
    \if@proceedings\RMAASClong\else\RMAAlong\fi}}
\newcommand{\@received}{\today}
\newcommand{\@accepted}{\today}
\newcommand{\@MSnum}{000000}
\newcommand{\@reunionplace}{Lugar de la reuni\'on}
\newcommand{\@reuniondate}{Fecha de la reuni\'on}
\newcommand{\@conftitle}{Conference Title}
\newcommand{\SetReunion}[2]{\renewcommand{\@reunionplace}{#1}\renewcommand{\@reuniondate}{#2}}
\newcommand{\SetConfTitle}[1]{\renewcommand{\@conftitle}{#1}}
\newcommand{\@editors}{Juan Ram\'on de la Fuente and ``El Mosh''}
\newcommand{\SetEditors}[1]{\renewcommand{\@editors}{#1}}
\newcommand{\@editores}{Juan Ram\'on de la Fuente y ``El Mosh''}
\newcommand{\SetEditores}[1]{\renewcommand{\@editores}{#1}}
\newcommand{\@mes}{mes de la publicaci\'on}
\newcommand{\SetMes}[1]{\renewcommand{\@mes}{\rmaa@VolumenStyle{#1}}}

\newif\if@arenotes
\@arenotesfalse
\newcounter{notecounter}
\setcounter{notecounter}{0}
\newcommand\NotesList{}
\newcommand\Note[1]{%
  \if@proof{%
    \@arenotestrue%
    \stepcounter{notecounter}%
    \if@inpreamble\else{%
      \NoteMark{\arabic{notecounter}}%
    }\fi
    \protected@xdef\NotesList{\NotesList
      \protect\item #1}%
  }\fi%
}
\newcommand\Changed[2]{Changed ``#1'' to ``#2''.}
\newcommand\NoteMark[1]{%
  \ifinner
  \raisebox{1ex}[0pt][0pt]{\makebox[0pt][l]{\framebox{\footnotesize\bfseries
        N#1}}}%
  \else
  \marginpar{\framebox{\footnotesize\bfseries N#1}}%
  \fi
}
\newcommand\RefNote[1]{\if@proof\NoteMark{\ref{#1}}\relax\fi}
\newcommand\NoteLabel{\protect\label}
\newcommand\OutputNotes{%
  \bgroup
  \onecolumn
  \section*{EDITORIAL NOTES}
  \begin{enumerate}
    \NotesList
  \end{enumerate}
  \egroup
}
\DeclareRobustCommand\cs[1]{\texttt{\char`\\#1}}

\newcommand{\SetADSBibCode}[1]{\renewcommand{\ADS@BibCode}{#1}}
\newcommand{\ADS@BibCode}
{\ADS@year\ADS@journal\ADS@volume.\PadToFourWithDots{\ADS@firstpage}\ADS@authorinitial}
\newcommand{\ADS@year}{2001}
\newcommand{\ADS@journal}{\if@proceedings RMxAC\else RMxAA\fi}
\newcommand{\ADS@volume}{....}
\newcommand{\ADS@firstpage}{....}
\newcommand{\ADS@authorinitial}{A}
\newcommand{\ADS@journalname}{%
  \if@proceedings\@conftitle\space (Eds. \@editors) \fi%
  Revista Mexicana de Astronoma y Astrofsica%
  \if@proceedings\space (Serie de Conferencias)\fi%
  \space Vol. \@volume, pp. \ADS@firstpage--\ADS@lastpage\space (\@year)%
  \space (http://www.astroscu.unam.mx/\~{}rmaa/)
  }
\let\ADS@title=\@rawtitle
\newcommand{\ADS@keywords}{No keywords specified}
\newcommand{\ADS@abstract}{No abstract specified}
\newcommand{\ADS@authors}{}
\newcommand{\ADS@website}{http://www.astrosmo.unam.mx/rmaa/}
\newcommand{\ADS@url}
{\ADS@website\ADS@journal\ADS@volume\ADS@number/PDF/\ADS@journal\ADS@volume\ADS@number\_\articlename.pdf}
\newcommand{\ADS@number}{}
\newcommand{\ADS@fulldate}{00/\ADS@year}
\newcommand{\ADS@lastpage}{00}
\newcommand{\ADS@copyright}{(C) \ADS@year; Instituto de Astronoma,
  Universidad Nacional Autnoma de Mxico}
\newcommand{\SetNumber}[1]{\renewcommand{\ADS@number}{-#1}}
\newcommand{\SetWebsite}[1]{\renewcommand{\ADS@website}{#1}}
\newcommand{\SetMonthNumeric}[1]{\renewcommand{\ADS@fulldate}{#1/\ADS@year}}
\newcommand{\ADS@references}{}
\newcommand{\ADS@affil}{}
\edef\EndBib{\expandafter\@gobble\string\\end\string{thebibliography\string}}
\edef\StartBib{\expandafter\@gobble\string\\begin\string{thebibliography\string}}
\edef\StartBibX{\expandafter\@gobble\string\\begin\string{thebibliography\string}\string{\string}}
\newif\ifAnotherLine
\newif\ifInBib
\def\makeOther#1{\catcode`#1=12\relax}
\newread\tf@biblio
\newcommand{\RereadBiblio}{%
  \begingroup
  \immediate\openin\tf@biblio=\articlename
  \AnotherLinetrue\InBibfalse
  \makeOther\ \makeOther\\\makeOther\$%
  \makeOther\#\makeOther\^\makeOther\^^K%
  \makeOther\_\makeOther\^^A\makeOther\%%
  \makeOther\~\makeOther\{\makeOther\}\makeOther\&%
  \endlinechar-1\relax
  \loop
  \read\tf@biblio to \Line
  \ifx\Line\EndBib\AnotherLinefalse\InBibfalse\fi
  \ifeof\tf@biblio \AnotherLinefalse\fi
  \ifInBib
  \ifx\Line\empty\else\xdef\ADS@references{\ADS@references\Line^^J}\fi
  \fi
  \ifx\Line\StartBib\InBibtrue\fi
  \ifx\Line\StartBibX\InBibtrue\fi
  \ifAnotherLine\repeat
  \immediate\closein\tf@biblio
  \endgroup
  }
\newcommand{\PadToFourWithDots}[1]{%
  \ifnum #1 > 999 #1%
  \else\ifnum #1 > 99 .#1%
  \else\ifnum #1 > 9 ..#1%
  \else ...#1%
  \fi\fi\fi}
%%  \ifnum \count0 > 999 #1%
%%  \else\ifnum \count0 > 99 .#1%
%%  \else\ifnum \count0 > 9 ..#1%
%%  \else ...#1%
%%  \fi\fi\fi}
\newcommand{\ADSfield}[2]{\relax}
\newcommand{\ADSvfield}[2]{\relax}
%%\renewcommand{\ADSfield}[12]{\%#1 #2}
\newcommand{\ADS@dumpdata}
{
  \ADS@write{\string\begin{ADSarticle}}
  \ADS@WRITE{\string\ADSfield{R}{\ADS@BibCode}}
  \ADS@write{\string\ADSfield{A}{\ADS@authors}}
  {\ADS@sanitize\ADS@write{\string\ADSfield{F}{AA(\ADS@affil)}}}
  \ADS@write{\string\ADSfield{J}{\ADS@journalname}}
  \ADS@write{\string\ADSfield{D}{\ADS@fulldate}}
  \ADS@write{\string\ADSfield{L}{\ADS@lastpage}}
  \ADS@write{\string\ADSfield{T}{\ADS@title}}
  \ADS@write{\string\ADSfield{C}{\ADS@copyright}}
  \ADS@write{\string\ADSfield{U}{\ADS@url}}
  \ADS@write{\string\ADSfield{K}{\ADS@keywords}}
  {\ADS@sanitize\ADS@write{\string\ADSfield{B}{\ADS@abstract}}}
  \ADS@write{\string\ADSfield{Z}{\ADS@references}}
  \ADS@write{\string\end{ADSarticle}}
  }
%%\newcommand{\ADS@write}[1]{\if@book\addtocontents{ads}{#1}\fi}
%%\newcommand{\ADS@openfile}{\@starttoc{ads}}
\newcommand{\ADS@write}[1]{\set@display@protect\immediate\write\tf@ads{#1}}
\newcommand{\ADS@WRITE}[1]{\immediate\write\tf@ads{#1}}
\newcommand{\ADS@openfile}{%
  \newwrite\tf@ads%
  \immediate\openout\tf@ads\jobname.ads\relax
  \ADS@WRITE{\ADS@preamble}}
\newcommand{\ADS@closefile}{\ADS@WRITE{\ADS@postamble}}
\def\ADS@preamble{%
  %%  \string\documentclass{article}
  %%  \string\begin{document}
  }
\def\ADS@postamble{%
  %%  \string\end{document}
  \string%\string% Local Variables:^J
  \string%\string% mode: LaTeX^J
  \string%\string% mode: Font-lock^J
  \string%\string% End:^J
  }
\if@book\AtEndDocument{\ADS@closefile}\else
\AtBeginDocument{\@begofarticlehook}
\AtEndDocument{\@endofarticlehook}
\fi
\newcommand{\@begofarticlehook}{%
  \if@frontmatter\frontlabel{RMAAFirstPage}\else\label{RMAAFirstPage}\fi%
  \xdef\ADS@firstpage{\@arabic{\c@page}}%
  \if@book\else\makeindex\fi % needed so default index is defined in stand-alone articles
%%  \indexauthor@deferlist
%%  \xdef\indexauthor@deferlist{}
  \@inpreamblefalse
  }
\newcommand{\@endofarticlehook}{%
  \if@debug{\ClassWarning{rmaa}{***Doing Hook***}}\fi
  \if@debug{\ClassWarning{rmaa}{ADSabstract is: \ADS@abstract}}\fi
  \clearpage\rmaa@lastpagelabel\if@book\ADS@dumpdata\fi
  \ifx\NotesList\@rmaaEmpty\else\OutputNotes\fi
  \if@debug{\ClassWarning{rmaa}{Notes list is: \NotesList}}\fi
}
\newcommand{\rmaa@lastpagelabel}{%
  \addtocounter{page}{-1}%
  \immediate\write\@auxout{\string
    \newlabel{\articlename:RMAALastPage}{{}{\thepage}}}%
  \edef\ADS@lastpage{\thepage}%
  \addtocounter{page}{1}}

\let\latexonecolumn=\onecolumn
\let\latextwocolumn=\twocolumn
\renewcommand{\onecolumn}{\@rmtwocolfalse\@package@default@lengths\latexonecolumn}
\renewcommand{\twocolumn}{\@rmtwocoltrue\@package@default@lengths\latextwocolumn}

\renewcommand{\maketitle}{\par
  \begingroup
  %%  \renewcommand\thefootnote{\fnsymbol{footnote}}%
%%  \def\@makefnmark{\hbox to\z@{$\m@th^{\@thefnmark}$\hss}}%
  \def\@makefnmark{\textsuperscript{\@thefnmark}\hspace{-0.2em}}%
  \long\def\@makefntext##1{\parindent 1em\noindent
    \hbox to1.8em{\hss$\m@th^{\@thefnmark}$}##1}%
  \if@rmtwocol
  { \if@debug{\ClassWarning{rmaa}{TWO COLUMN}}\fi
    \twocolumn[\@maketitle]%
    }
  \else
  { \if@debug{\ClassWarning{rmaa}{ONE COLUMN}}\fi
    \newpage
    \global\@topnum\z@   % Prevents figures from going at top of page.
    \if@manuscript \@MSmaketitle \else \@maketitle \fi
    }
  \fi
  \if@manuscript\else\thispagestyle{rmaafirstpage}\@thanks\fi
  \ifx\NotesList\@rmaaEmpty\else{%
    \NoteMark{1--\arabic{notecounter}}\vspace*{-2\baselineskip}%
  }\fi%
  \endgroup
  %%  \setcounter{footnote}{0}%
  \let\thanks\relax\let\affil\relax\let\altaffil\relax
  \let\maketitle\relax\let\@maketitle\relax
  \gdef\@thanks{}\gdef\@author{}\gdef\@title{}}

\newlength{\@kwhwidth}\newlength{\@kwtwidth}
\renewcommand{\@maketitle}{%
  \newpage
  \null
  \vskip\@before@title@skip%
  \begin{center}%
    {\@title \par}%
    \vskip\@before@author@skip%
    \parbox{\rmaa@AuthorWidthFrac\textwidth}{\centering
      \lineskip\@between@author@skip%
      \@author
      \par}
    %% this should be replaced with `Submitted to...' for preprints
    \if@journal
    \if@preprint
    \rmaa@ReceivedStyle{Submitted to RevMexAA \@received}
    \else
    \rmaa@ReceivedStyle{Received \@received; accepted \@accepted}
    \fi
    \fi
    \if@manuscript
    \rmaa@ReceivedStyle{Submitted to RevMexAA \@received}
    \fi
    \if@guide
    \rmaa@ReceivedStyle{Version \rmaa@version, \rmaa@date}
    \fi
    \vskip\@before@abstract@skip%
    \if@abstractpresent
    \parbox{\rmaa@AbstractWidthFrac\textwidth}{%
      \setlength{\parindent}{0.9cm}%
      \centerline{\rmaa@AbstractHeaderStyle{Resumen}}\par%
      \vskip\@after@abstracthead@skip%
      \if@newstyle\noindent\fi\@resumen
      \if@setresumen\else\@abstract\fi % append english abstract if
                                       % spanish one not set
      \vskip\@between@abstract@skip%
      \centerline{\rmaa@AbstractHeaderStyle{Abstract}}\par%
      \vskip\@after@abstracthead@skip%
      \if@newstyle\noindent\fi\@abstract
      \vskip\@before@kwd@skip%
      % Format the Key Words with hanging indentation:
      % They are put in a \parbox with width equal to the line width
      % minus the width of the header.
      { % Widths of keyword
        \settowidth{\@kwhwidth}{\@keywordheader~}   % header and
        \setlength{\@kwtwidth}{\linewidth}          % keyword text
        \addtolength{\@kwtwidth}{-\@kwhwidth}       %
        \noindent\@keywordheader~\parbox[t]{\@kwtwidth}{%
          \rmaa@KeywordStyle{\boldmath\uppercase{\@keywords}}}}%
      }
      \fi
  \end{center}%
  \vspace*{\afterkwdskip}
  \par
  }
\newlength{\afterkwdskip}\setlength{\afterkwdskip}{\z@}
\newcommand{\@MSmaketitle}{%
  \newpage
  \thispagestyle{rmaafirstpage}
  \setlength{\parindent}{0pt}
  \null\vskip 2ex
  \begin{center}
    \@title\par
    \@author\par
    \rmaa@ReceivedStyle{Submitted to RevMexAA \@received}\par
  \end{center}
  \@thanks
  \centerline{\rmaa@AbstractHeaderStyle{Resumen}}
  \@resumen\par\vskip 1 ex
  \centerline{\rmaa@AbstractHeaderStyle{Abstract}}
  \@abstract\par\vskip 1ex
  \@keywordheader~\rmaa@KeywordStyle{\uppercase{\@keywords}}\par
  }


\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {\abovesectionskip}%
                                   {\belowsectionskip}%
                                   %% how do we get upper case here
                                   {\centering\reset@font\normalsize}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {\abovesectionskip}%
                                     {\belowsectionskip}%
                                     {\centering\reset@font\normalsize\itshape}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {\abovesectionskip}%
                                     {\belowsectionskip}%
                                     {\centering\reset@font\normalsize\itshape}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {\aboveparaskip}%
                                    {\belowparaskip}%
                                    {\reset@font\normalsize\bfseries}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                      {\aboveparaskip}%
                                      {\belowparaskip}%
                                      {\reset@font\normalsize\bfseries}}

\setcounter{secnumdepth}{3}

\renewcommand{\thesubsection}{{\upshape\thesection.\@arabic\c@subsection}}
\renewcommand{\thesubsubsection}{\thesubsection{\upshape.\@arabic\c@subsubsection}}

\def\@seccntformat#1{\csname the#1\endcsname .\hskip 0.4em}

\def\@sect#1#2#3#4#5#6[#7]#8{
  \ifnum #2>\c@secnumdepth
     \let\@svsec\@empty
  \else
     \refstepcounter{#1}%
     \let\@@protect\protect
     \def\protect{\noexpand\protect\noexpand}%
     \edef\@svsec{\@seccntformat{#1}}%
     \let\protect\@@protect
  \fi
  \ifnum #2=1
     \def\sec@upcase##1{\uppercase{##1}}
  \else
     \def\sec@upcase##1{\relax{##1}}
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
     \begingroup #6\relax
          \@hangfrom{\hskip #3\relax\@svsec}%
                    {\interlinepenalty \@M \sec@upcase{#8}\par}%
     \endgroup
     \csname #1mark\endcsname{#7}
     \if@guide
        \addcontentsline{toc}{#1}{%
          \ifnum #2>\c@secnumdepth \else
             \protect\numberline{\csname the#1\endcsname}
          \fi
          #7}%
     \fi
  \else
     \def\@svsechd{#6\hskip #3\relax  %% \relax added 2 May 90
       \@svsec #8\csname #1mark\endcsname{#7}
       \if@guide
          \addcontentsline{toc}{#1}{%
            \ifnum #2>\c@secnumdepth \else
               \protect\numberline{\csname the#1\endcsname}%
            \fi
            #7}%
       \fi
       }%
  \fi
  \@xsect{#5}}


%%
\renewcommand{\thetable}{\@arabic\c@table}
\renewcommand{\thefigure}{\@arabic\c@figure}
\renewcommand{\figurename}{Fig.}
\renewcommand{\tablename}{TABLE}
\renewcommand{\fnum@table}{TABLE~\thetable}
\renewcommand{\fnum@figure}{Fig.~\thefigure}

\long\def\@makefigcap#1#2{%
  \if@proceedings\else\small\fi
  \if@newstyle\small\fi
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1. #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1. #2 \par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

\long\def\@maketabcap#1#2{%
  \hbox to\hsize{\hfil #1 \hfil}
  \vskip 6pt
  \centering\MakeUpperCase{#2}\par
  \vskip 6pt}

\newlength{\@rottabcapwidth}
\long\def\@makerottabcap#1#2{%
  \setbox\@tempboxa\hbox{\MakeUpperCase{#2}}%
  \ifdim\wd\@tempboxa >.8\vsize
     \setlength\@rottabcapwidth{.8\vsize}
  \else
     \setlength\@rottabcapwidth{\wd\@tempboxa}
  \fi
  \rotatebox{90}{%
    \begin{minipage}{\vsize}\centering
      \begin{minipage}{\@rottabcapwidth}\centering
        #1\\ \vskip 6pt \MakeUpperCase{#2}
      \end{minipage}%
    \end{minipage}
    }%
  \hskip 6pt
  }

\newenvironment{Sideways}
    {\begin{sideways}\begin{minipage}{\vsize}\centering}
    {\end{minipage}\end{sideways}}

\newenvironment{Sidewaystable}
{%
  \let\oldcaption=\caption%
  \def\caption{
    \def\@captype{table}\renewcommand{\@makecaption}{\@maketabcap}
    \oldcaption}
  \begin{sidewaystable}\centering}
  {\end{sidewaystable}\let\caption=\oldcaption}
\newenvironment{Sidewaystable*}
{%
  \let\oldcaption=\caption%
  \def\caption{
    \def\@captype{table}\renewcommand{\@makecaption}{\@maketabcap}
    \oldcaption}
  \begin{sidewaystable*}\centering}
  {\end{sidewaystable*}\let\caption=\oldcaption}

\renewenvironment{figure}
                 {\renewcommand{\@makecaption}{\@makefigcap}\@float{figure}}
                 {\end@float}
\renewenvironment{figure*}
                 {\renewcommand{\@makecaption}{\@makefigcap}\@dblfloat{figure}}
                 {\end@dblfloat}
\renewenvironment{table}
                 {\renewcommand{\@makecaption}{\@maketabcap}\@float{table}}
                 {\end@float}
\renewenvironment{table*}
                 {\renewcommand{\@makecaption}{\@maketabcap}\@dblfloat{table}}
                 {\end@dblfloat}

\long\def\@caption#1[#2]#3{%
  \par
%%  \addcontentsline{\csname ext@#1\endcsname}{#1}%
%%    {\protect\numberline{\csname the#1\endcsname}{\ignorespaces #2}}%
  \begingroup
    \@parboxrestore
    \if@minipage
      \@setminipage
    \fi
    \normalsize
    \@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
  \endgroup}

\renewcommand{\arraystretch}{1.15}
\setlength{\doublerulesep}{0.4pt}

\newcommand{\tablecols}[1]{\renewcommand{\@tablecols}{#1}}
\newcommand{\@tablecols}{1}
\newcommand{\tabcaptioncontinued}{%
  \multicolumn{\@tablecols}{c}{\addtocounter{table}{-1}TABLE~\thetable\ (CONTINUED)} \\ \\
  }

\newcommand\tablenotemark[1]{$^\mathrm{#1}$}
\newcommand\tablenote[2]{\if@proceedings\else\small\fi ${}^\mathrm{#1}$ #2}
\newcommand\tablenoteskip{\\[0.5\baselineskip]}

\newcommand{\tabnotemark}[1]{\textsuperscript{\lowercase{#1}}}
\newcommand{\tabnotetextTWO}[4]{%
  \multicolumn{\@tablecols}{l}{%
    \parbox{0.5\tabnotewidth}{\small\textsuperscript{#1}#2}%
    \parbox{0.5\tabnotewidth}{\small\textsuperscript{#3}#4}%
    }%
  \\}
\newcommand{\tabnotetext}[2]{%
  \multicolumn{\@tablecols}{@{}p{\tabnotewidth}@{}}{\small\textsuperscript{#1}#2}\\}
\newlength{\tabnotewidth}

\newlength{\beforebiblioskip}
\setlength{\beforebiblioskip}{0pt}
\newlength{\afterbiblioskip}
\setlength{\afterbiblioskip}{0pt}
\renewenvironment{thebibliography}{%
  \if@book\RereadBiblio\fi
%%  \vspace*{\beforebiblioskip}
  \section*{REFERENCES} \frenchspacing
%%  \vspace*{\afterbiblioskip}
  \small
  \list{\null}{\leftmargin 1.5em\labelwidth\z@\labelsep\z@\itemindent -1.5em
    \itemsep\z@\parsep\z@\usecounter{enumi}}
  \sloppy\clubpenalty4000\widowpenalty4000
  \sfcode`\.=1000\relax\@biblisttrue}
{\endlist\@biblistfalse\normalsize\@outputaddressesifnecessary}
\newcommand{\articlename}{anon}
\let\oldcite=\cite
\let\oldnocite=\nocite
\let\oldref=\ref
\let\oldpageref=\pageref
\let\oldlabel=\label
\renewcommand{\ref}[1]{\oldref{\articlename:#1}%
  \if@debug{\ClassInfo{rmaa}{Reference to \articlename:#1}}\fi}
\renewcommand{\pageref}[1]{\oldpageref{\articlename:#1}%
  \if@debug{\ClassInfo{rmaa}{Page reference to \articlename:#1}}\fi}
\renewcommand{\label}[1]{\oldlabel{\articlename:#1}%
  \if@debug{\ClassInfo{rmaa}{Label for \articlename:#1}}\fi}
\renewcommand{\nocite}[1]{\@bsphack
  \@for\@citeb:=#1\do{%
    \edef\@citeb{\expandafter\@firstofone\@citeb:\articlename}%
    \if@filesw\immediate\write\@auxout{\string\citation{\@citeb}}\fi
    \@ifundefined{b@\@citeb:\articlename}{\G@refundefinedtrue
      \@latex@warning{Citation `\@citeb' undefined}}{}}%
  \@esphack}
\renewcommand{\cite}[1]{\oldcite{#1:\articlename}}

\def\lbibcite#1#2#3{\global\@namedef{b@#1}{#2}
                    \global\@namedef{by@#1}{#3}}

\if@natbib\def\@extra@b@citeb{:\articlename}\fi
%%\else
\let\oldbibitem\bibitem
\newcommand{\@rmaaBibArg}{}
\newcommand{\@rmaaSpace}{ }
\newcounter{rmaabib}
\if@natbib
\renewcommand{\bibitem}[2][ABC(2003)]{%
  \renewcommand{\@rmaaBibArg}{#2}
  \ifx\@rmaaBibArg\@rmaaEmpty
     \addtocounter{rmaabib}{1}
     \oldbibitem[#1]{\thermaabib:\articlename}
  \else\ifx\@rmaaBibArg\@rmaaSpace
     \addtocounter{rmaabib}{1}
     \oldbibitem[#1]{\thermaabib:\articlename}
  \else
     \oldbibitem[#1]{#2:\articlename}
  \fi\fi
  \renewcommand{\@rmaaBibArg}{}
  }
\else
\renewcommand{\bibitem}[1]{%
  \renewcommand{\@rmaaBibArg}{#1}
  \ifx\@rmaaBibArg\@rmaaEmpty
     \addtocounter{rmaabib}{1}
     \oldbibitem{\articlename:\thermaabib}
  \else\ifx\@rmaaBibArg\@rmaaSpace
     \addtocounter{rmaabib}{1}
     \oldbibitem{\articlename:\thermaabib}
  \else
     \oldbibitem{\articlename:#1}
  \fi\fi
  \renewcommand{\@rmaaBibArg}{}
  }
\fi
%%\fi

\newcommand{\@redefinebibitem}{%
  \let\oldbibitem\bibitem
  \let\oldcite\cite
  \let\oldpcite\pcite
  \let\oldscite\scite
  \def\bibitem[##1<##2>]##3{%
    \renewcommand{\@rmaaBibArg}{##3}
    \ifx\@rmaaBibArg\@rmaaEmpty
       \addtocounter{rmaabib}{1}
       \oldbibitem[##1<##2>]{\thermaabib:\articlename}
    \else\ifx\@rmaaBibArg\@rmaaSpace
       \addtocounter{rmaabib}{1}
       \oldbibitem[##1<##2>]{\thermaabib:\articlename}
    \else
       \oldbibitem[##1<##2>]{##3:\articlename}
    % trust the author here
%%       \oldbibitem[##1<##2>]{##3}
    \fi\fi
    }
  }

\newcommand{\HyperTOCEntry}[3]{\relax}
\newcommand{\HyperTOCpart}[1]{\relax}
\newcommand{\HyperTOCmeeting}[3]{\relax}
\newcommand{\HyperTOCeditors}[1]{\relax}
\newcommand{\HyperTOCpreamble}{\relax}

\if@book
%% environment for including the individual articles
\newcommand{\@fiddleauthors}[2]{\relax}
\renewcommand{\theequation}{\@arabic\c@equation}
\newenvironment{articles}%
{ \begingroup % make it a group so that author definitions do not
              % spill over
  \gdef\ADS@authors{}
  \pagestyle{rmaa}
  \renewenvironment{document}{%
    \@begofarticlehook
    \addtocounter{chapter}{1}%
    \addcontentsline{toc}{chapter}{%
      \protect\@fiddleauthors{\@TOCtitle}{\rmaaTOCauthors}}%
    \addtocontents{htc}{\protect\HyperTOCEntry{\@rawtitle}{\@rawauthors}{\articlename}}
    }{\relax}
  \renewcommand{\documentclass}[2][foo]{\relax}
  \renewcommand{\usepackage}[2][foo]{%
    \def\@packagename{##2}\def\@rmaacitename{rmaacite}%
    \ifx\@packagename\@rmaacitename
    \@rmcitetrue\ClassInfo{rmaa}{This paper uses rmaacite}
    \makeatletter\input{rmaacite.sty}\makeatother % read it in here so that all changes
    \else                                         % are local to paper
    \if@debug\ClassWarning{rmaa}{Package \@packagename\space was requested by \articlename\space}\fi
    \fi}
  %% Don't allow individual articles to mess with the pages, volume or year
  \renewcommand{\SetFirstPage}[1]{\relax}
  \renewcommand{\SetYear}[1]{\relax}
  \renewcommand{\SetVolume}[1]{\relax}
  %% Don't allow individual articles to change these
  \renewcommand{\nonstopmode}{\relax}
  \renewcommand{\scrollmode}{\relax}
  \renewcommand{\outputplates}{\relax}
  %% XXXX need to check if using rmaacite and act accordingly
  %% avoid multiple declarations of the same length
  \let\oldnewlength=\newlength
  \renewcommand{\newlength}[1]{%
    \edef\reserved@a{\expandafter\@gobble\string ##1}%
    \@ifundefined{\reserved@a}{%
      \oldnewlength{##1}}{%
      \if@debug{\ClassInfo{rmaa}{\reserved@a\space already defined: doing nothing}}\fi%
      \relax}}%
  \renewcommand\newcommand{\providecommand}
  }%
{\endgroup\onecolumn}

\newcommand{\article}[2][]{%
  % optional first argument is extra text to put in brackets after title in TOC
  % e.g. ``Invited Talk'' or ``Poster''
  \renewcommand{\articlename}{#2}
  % reset loads of counters
  \setcounter{footnote}{0}
  \setcounter{figure}{0}
  \setcounter{table}{0}
  \setcounter{section}{0}
  \setcounter{equation}{0}
  \setcounter{rmaabib}{0}
  \gdef\ADS@authors{}%
  \gdef\ADS@affil{}%
  \gdef\ADS@references{}%
  \@firstauthortrue
  \@firstaffiltrue
  \@firstaltaffiltrue
  \@firstkwdtrue
  \@rmcitefalse
  \if@suppressfulladdresses\else\@needaddressestrue\fi
  \renewcommand{\@rmaaArg}{#1}
  \ifx\@rmaaArg\@rmaaEmpty
     \renewcommand{\@TOCaftertitle}{}
  \else
     \renewcommand{\@TOCaftertitle}{ (#1)}
  \fi
  \if@journal\clearpage\thispagestyle{empty}\cleardoublepage\fi
%% Now input the file, then run the end-of-article hook (reinstated 28
  %% Sep 2001)
  {\input{\@articledir/\articlename.tex}\@endofarticlehook}}
\newcommand{\session}[1]{
  %% this does nothing except write an entry in the TOC
  \addcontentsline{toc}{part}{\rmaa@TOCPartStyle{#1}}
  \addtocontents{htc}{\protect\HyperTOCpart{#1}}
  %% and also makes sure we start on an odd page (added 06 Jun 2000)
  \clearpage\thispagestyle{empty}\cleardoublepage
  \stepcounter{part}
  \if@sessiontitlepages{%
    \onecolumn
    \thispagestyle{empty}
    \renewcommand{\articlename}{Section\thepart TitlePage}
    \label{RMAAFirstPage}
    \make@session@title{#1}
    \label{RMAALastPage}
    \clearpage\thispagestyle{empty}\cleardoublepage
  }\fi
  }
\newcommand{\make@session@title}[1]{%
  {%
    \setlength\parindent{0pt}
    \vspace*{\stretch{1}}
    \rule{\linewidth}{1mm}
    \begin{flushright}\Huge\bfseries\boldmath
      #1
    \end{flushright}
    \rule{\linewidth}{1mm}
    \vspace*{\stretch{2}}
  }
}
\newcommand{\SessionTitlePages}{\@sessiontitlepagestrue}
\newcommand{\BoldSessionTitles}{%
  \renewcommand{\rmaa@TOCPartStyle}[1]{\textbf{\rmaa@TOCTitleStyle{##1}}}
  }
\newcommand{\ArticleDir}[1]{\renewcommand{\@articledir}{#1/}\graphicspath{{1/}}}
\newcommand{\@articledir}{.}
\newcommand{\ps@rmaafront}{% page style for front matter:  page # in each foot
  \renewcommand\@oddfoot{\hfil{\thepage}}%
  \renewcommand\@evenfoot{{\thepage}\hfil}%
  % shorttitle in both heads
  \renewcommand\@evenhead{\hfil\@shorttitle\hfil}%
  \renewcommand\@oddhead{\@evenhead}
  }
\newcommand{\ps@rmaafrontfirstpage}{% page style for first page of front matter
  % page # in each foot, on outside edge
  \renewcommand\@oddfoot{\hfil\thepage}%
  \renewcommand\@evenfoot{\thepage\hfil}%
  % nothing in the even heads
  \renewcommand\@evenhead{\relax}%
  \renewcommand\@oddhead{\relax}%
  }
%% slight modification to the standard \frontmatter and \mainmatter
%% commands, just to set the \pagestyle
\renewcommand\frontmatter{%
  \latexonecolumn
  \cleardoublepage
  \@frontmattertrue
  \@mainmatterfalse
  \pagenumbering{roman}
  \pagestyle{rmaafront}
  \addtocounter{page}{2} % leave space for the title page
  }
\renewcommand\mainmatter{%
  \pagestyle{empty}
  \if@rmtwocol\twocolumn\fi
  \cleardoublepage
  \@frontmatterfalse
  \@mainmattertrue
  \pagenumbering{arabic}
  \pagestyle{rmaa}
  }
\renewcommand\backmatter{%
  \clearpage\pagestyle{empty}\cleardoublepage
  \@mainmatterfalse
  %% put extra space in the TOC
  \addtocontents{toc}{\bigskip}
  }
\newcommand{\notitle}{\@titlevisiblefalse} \newcommand{\shortname}{}
\newenvironment{frontsection}[3][]{%
  \begingroup
  \renewcommand{\shortname}{#1}
  \ifx\shortname\@rmaaEmpty
     \renewcommand{\articlename}{#2}
  \else
     \renewcommand{\articlename}{\shortname}
  \fi
  \@begofarticlehook
  \@titlevisibletrue % default
  \thispagestyle{rmaafrontfirstpage}
  \listofauthors{} % blank out this in case it is not specified
  \title{{#2}}\shorttitle{#2}\shortauthor{#2}
  #3 % evaluate the command given as second mandatory arg
  \addcontentsline{toc}{chapter}{\protect\@fiddleauthors{\@TOCtitle}{\rmaaTOCauthors}}%
  \addtocontents{htc}{\protect\HyperTOCEntry{\@rawtitle}{\@rawauthors}{\articlename}}
  \if@titlevisible
     \vspace*{1cm}\centerline{\rmaa@FrontSecStyle{\@title}}\vspace*{1cm}
  \fi
  \setlength{\parskip}{3ex}
  }{\frontlabel{RMAALastPage}\clearpage\endgroup}
%% Definition of the command \frontlabel, which rights out something like `F4' to
%% the .aux file, instead of `\textlatin  {i}'. This is so it is easy to post-process
%% the file for making PS files of individual sections
\newcommand{\frontlabel}[1]{%
  \@bsphack
  \protected@write\@auxout{}%
     {\string\newlabel{\articlename:#1}{{}{F\@arabic{\c@page}}}}
  \@esphack
  }
%% User command to say X, Y, Z,\\ Editors of the Proceedings
\newcommand{\EditorSignature}{\vspace*{\parskip}\rightline{\@editors}%
  \rightline{Editors of the proceedings}}
%% Fiddle with \thesection, etc. so that they don't include the chapter number
%% Basically go back to the `article' definitions of these
\renewcommand{\thesection}{\@arabic\c@section}
\renewcommand{\thefigure}{\@arabic\c@figure}
\renewcommand{\thetable}{\@arabic\c@table}

\newcommand{\@oldargs}{}
\newcommand{\@newargs}{}
%% add TOC entry for each paper

%% Formatting of the table of contents
%% dimensions of various parts
\newlength{\TOCtextwidth}\setlength{\TOCtextwidth}{12.65cm}
\newlength{\TOCpagenumwidth}\setlength{\TOCpagenumwidth}{1.3cm}
\newlength{\TOCentrywidth}\setlength{\TOCentrywidth}{\TOCtextwidth}
\addtolength{\TOCentrywidth}{-\TOCpagenumwidth}
\newlength{\TOCextramargin}\setlength{\TOCextramargin}{1.25cm}
\newcommand{\TOCbox}[1]{\hspace{\TOCextramargin}\parbox{\TOCtextwidth}{#1}\par}
\newlength{\TOCextramarginx}\setlength{\TOCextramarginx}{\TOCextramargin}\addtolength{\TOCextramarginx}{4.3cm}
\newlength{\TOCtextwidthx}\setlength{\TOCtextwidthx}{\TOCtextwidth}\addtolength{\TOCtextwidthx}{-4.3cm}
\newcommand{\TOCboxx}[1]{\hspace{\TOCextramarginx}\parbox{\TOCtextwidthx}{#1}\par}

\newcommand{\RMAAbannerimage}{rmsc.ps}
\renewcommand\tableofcontents{%
  \renewcommand{\articlename}{CONTENTS}
  \begingroup
  \@begofarticlehook
  \if@twocolumn
     \@restonecoltrue\onecolumn
  \else
     \@restonecolfalse
  \fi
  %% 9pt for journal style
  \if@proceedings\else\small\fi
  \if@newstyle\small\fi %% same for new style
  \if@proceedings\thispagestyle{rmaafrontfirstpage}\else\thispagestyle{empty}\fi
  \shortauthor{Contents}\shorttitle{Contents}
  \vspace*{18mm}
  \if@printbanner
  %% put in the banner header (need to get better image of this)
     \TOCbox{\hspace*{-0.15cm}\includegraphics[width=0.9\TOCtextwidth]{\RMAAbannerimage}}
     \vspace*{8mm}
  %% volume and publication date (should really be in funny font)
     \TOCboxx{\@volumen\\[2mm] \@mes\ \@anyo}
  \else
  %% put in the banner header (need to get better image of this)
     \TOCbox{\hspace*{-0.15cm}\includegraphics[width=0.9\TOCtextwidth]{\RMAAbannerimage}}
     \vspace*{12.5mm}
  %% volume and publication date (should really be in funny font)
     \TOCboxx{~\\[2mm] ~}
  \fi
  \vspace*{16mm}
  %% This is the command that fiddles with the TOC entry so that the
  %% title is flushleft but the authors are flushright
  \renewcommand{\@fiddleauthors}[2]{%
    % first put the paper title
    \renewcommand{\\}{\relax} % temporarily turn off explicit line breaks just in case
    \renewcommand{\altaffilmark}[1]{\relax} % ditto with this
    \renewcommand{\textsuperscript}[1]{\relax} % ditto with this
    ##1
    % now save the author list in a box
    \sbox\@tempboxa{##2}%
    % check that box is shorter than the total width available for the entry
    \ifdim \wd\@tempboxa <\TOCentrywidth
       % if so, then put it right here, flush against right margin
       \penalty10000\hskip1em plus10em\penalty0\hbox{}\nobreak\hfill\box\@tempboxa
       % Note that we force a space of at least 1em between title and authorlist,
       % stretchable to 11em since we may have very short titles but still with an
       % authorlist too long to go on the same line.  The only linebreak allowed is
       % directly before the authorlist.
    \else
       % if it is too long, we set the original authorlist text in its own parbox
       \par\vskip1ex\parbox[b]{\TOCentrywidth}{\raggedleft ##2}
    \fi
    }
  \@starttoc{toc}%
  \if@restonecol\twocolumn\fi
  \frontlabel{RMAALastPage}
  \clearpage
  \thispagestyle{empty}
  \cleardoublepage % make sure we start on an odd page
  \endgroup

  %%% ALSO, do the HTML TOC
  %% The file that will be used to make the HTML TOC
  \@starttoc{htc}
  %% All the stuff in this file does nothing in the book style
  \addtocontents{htc}{\protect\HyperTOCmeeting{\@conftitle}{\@reunionplace}{\@reuniondate}}
  \addtocontents{htc}{\protect\HyperTOCeditors{\@editors}}
  \addtocontents{htc}{\protect\HyperTOCpreamble}
  \addtocontents{htc}{\protect\HyperTOCEntry{Table of Contents}{}{\articlename}}

  %% and the ADS file
  \ADS@openfile
  }
%% This is now much simpler
\renewcommand\l@chapter[2]{%TOC entry for articles
  \ifnum \c@tocdepth >\m@ne
    \vskip 1.0em \@plus\p@
    \TOCbox{%
      \parbox[b]{\TOCentrywidth}{#1}\parbox[b]{\TOCpagenumwidth}{\hfill#2}
    }
  \fi}
\renewcommand\l@part[2]{%TOC entry for sessions: centered, no page number
  \ifnum \c@tocdepth >\m@ne
    \vskip 1.5em \@plus1.5em \goodbreak
    \TOCbox{%
      \parbox[b]{\TOCentrywidth}{\hfil#1\hfil}\hfill
    }
  \fi\nobreak}

\newcommand{\@makeminititle}{%
  \newpage
  \null
  \vskip 3em%
  \begin{center}%
    {\@title \par}%
  \end{center}
  \vskip 3em%
  }

%% Formatting theindex
%% strongly encourage page breaks between index entries
\renewcommand{\@idxitem}{\par\penalty-1000\hangindent.45cm}
\renewcommand{\indexspace}{\par\penalty-1000\vskip 10\p@ \@plus15\p@ \@minus3\p@\relax}
\renewenvironment{theindex}{%
  %% first, make sure we start on an odd page (06 Jun 2000)
  \clearpage\thispagestyle{empty}\cleardoublepage
  %% this looks a bit like an article but is two columns and without abstract, etc
  \renewcommand{\articlename}{INDEX}
  \title{Author Index}\shortauthor{Author Index}\shorttitle{Author Index}
  \listofauthors{}
  \addcontentsline{toc}{chapter}{\protect\@fiddleauthors{\@TOCtitle}{\rmaaTOCauthors}}%
  \addtocontents{htc}{\protect\HyperTOCEntry{\@rawtitle}{\@rawauthors}{\articlename}}
  \pagestyle{rmaa}
  \thispagestyle{rmaafirstpage}
  \@begofarticlehook
  %% 9pt for journal style
  \if@proceedings\else\small\fi
  \if@newstyle\small\fi
  \twocolumn[\@makeminititle]
  %% vertical spacing (see also definition of \@idxitem and \indexspace
  \parskip\z@ \@plus .6\p@\relax % allow quite a lot of leaway here to avoid breaks inside entries
  %% horizontal spacing, breaking and glue parameters (see also the stuff in the definition
  %% of \indexauthor
  \parindent\z@
  \exhyphenpenalty10000 % don't break on explicit hyphens, it always looks bad
  \rightskip=0pt plus.2em % allow a tiny bit of leeway at the ends of lines
  \spaceskip.3333em plus.5em minus.15em % a lot of leeway between words
  \xspaceskip.5em plus.5em minus.4em % this seems to have no effect
  \let\item\@idxitem
  \renewcommand{\\}{\relax} % temporarily turn off explicit line breaks just in case
  \renewcommand{\altaffilmark}[1]{\relax} % ditto with this
  \renewcommand{\textsuperscript}[1]{\relax} % ditto with this
  }{\label{RMAALastPage}\clearpage} % clearpage necessary so that we know about \shortauthor

%% Formatting the poster abstracts
\RequirePackage{multicol}
\newenvironment{abstracts}[1][Abstracts of Contributed Papers]{%
  %% First, make sure we start on an odd page (06 Jun 2000)
  \clearpage\thispagestyle{empty}\cleardoublepage
  %%
  \renewcommand{\articlename}{ABSTRACTS}
  \title{#1}\shortauthor{Abstracts}\shorttitle{Abstracts}
  \listofauthors{}
  \addcontentsline{toc}{chapter}{\protect\@fiddleauthors{\@TOCtitle}{\rmaaTOCauthors}}%
  \addtocontents{htc}{\protect\HyperTOCEntry{\@rawtitle}{\@rawauthors}{\articlename}}
  \pagestyle{rmaa} % this now seems necessary (06 Jun 2000)
  \thispagestyle{rmaafirstpage}
%%  \twocolumn[\@makeminititle]
  \renewcommand{\abstract}[1]{\renewcommand{\@abstract}{##1}\@writeabstract}
  \renewcommand{\title}[2][]{%
    \renewcommand{\@rmaaArg}{##1}
    \ifx\@rmaaArg\@rmaaEmpty
       \renewcommand{\@TOCaftertitle}{}
    \else
       \renewcommand{\@TOCaftertitle}{ (\@rmaaArg)}
    \fi
    \renewcommand{\@title}{\rmaa@TOCTitleStyle{##2}}%
    \renewcommand{\@TOCtitle}{\rmaa@TOCTitleStyle{##2}\@TOCaftertitle}%
    \renewcommand{\rmaaIndexTitle}{\rmaa@IndexTitleStyle{##2\@TOCaftertitle.}}%
    }
  \renewcommand{\author}[1]{\let\@thanks\@empty\renewcommand\@author{##1} }
  \renewcommand{\footnotetext}[2][XX]{\par\noindent\textsuperscript{##1}~##2}
  \renewcommand{\footnoterule}{\kern-3\p@ \hrule \@width 3em \kern 2.6\p@}
  \@begofarticlehook
  \begin{multicols}{2}[\@makeminititle]
  \begingroup
  \setcounter{footnote}{0}
  }% and at the end of the environment....
  {\endgroup\end{multicols}\listofabstracts\label{RMAALastPage}\clearpage}
%% auxiliary commands used:
%% \@writeabstract does all the actual formatting
\newcommand{\@writeabstract}{%
  \addcontentsline{loa}{abstract}{\protect\@fiddleauthors{\@TOCtitle}{\rmaaTOCauthors}}%
  \begin{center}\@title\par\@author\end{center}
  \@abstract
  \par\noindent\footnoterule\nobreak\footnotesize\@thanks
  \par\noindent\hrulefill\goodbreak
  \vskip 1cm \@plus0.5cm
  \endgroup % this pair is to make each abstract a self-contained group
  \begingroup
  \setcounter{footnote}{0}
  }
%% List of abstracts (stuff written to .loa file)
\newcommand{\listofabstracts}{%
  \begin{multicols}{2}[%
    \vskip 1.5cm \vfill % leave at least 1.5 cm and go to bottom of page if possible
    \centerline{\MakeUpperCase{List of Abstracts}}
    \vskip 1.5cm \@plus0.5cm
    ][6cm] % this makes it start a new page if there is not at least 6cm of space
    \renewcommand{\@fiddleauthors}[2]{##1\hskip1em plus2em minus0.4em\penalty-100  ##2}
    \parindent\z@
%%    \parskip.5\p@ \@plus .7\p@\relax % allow quite a lot of leaway here to avoid breaks inside entries
    \parskip3\p@ \@plus 1\p@ \@minus 1\p@\relax % allow quite a lot of leaway here to avoid breaks inside entries
    \renewcommand{\\}{\relax} % temporarily turn off explicit line breaks just in case
    \renewcommand{\altaffilmark}[1]{\relax} % ditto with this
    \@starttoc{loa}
  \end{multicols}
  }
\newcommand*{\l@abstract}[2]{%
  \par\penalty-1000
  #1\hskip 1em\penalty0\null\nobreak\hfill#2}

%% end definitions for book styles
\fi

\newcommand\ColorOnlineOnly{%
  \textsc{Note: this figure is available in color in the electronic
    version of this article, obtainable from}
  \texttt{http://\discretionary{}{}{}www.\discretionary{}{}{}astroscu.\discretionary{}{}{}unam.\discretionary{}{}{}mx/\discretionary{}{}{}\~{}rmaa/}.}
%% Plates
%% Define 2 counters: plate is the number in the whole document, plateloop is used
%% internally by \outputplates
\newcounter{plate}
\newcounter{plateloop}
%% Currently limited to 15 plates in document
%% when we do a label, we need to write to \newlabel entries to the .aux file, one
%% that says RMAAPlateX so that it can be referred to in \ouputplates, and one that
%% says articlename:RMAAPlateX so that the dvips program can find it and asociate it
%% with the right article
\newcommand{\@platelabeli}{\oldlabel{RMAAPlate1}\label{RMAAPlate1}}
\newcommand{\@platelabelii}{\oldlabel{RMAAPlate2}\label{RMAAPlate2}}
\newcommand{\@platelabeliii}{\oldlabel{RMAAPlate3}\label{RMAAPlate3}}
\newcommand{\@platelabeliv}{\oldlabel{RMAAPlate4}\label{RMAAPlate4}}
\newcommand{\@platelabelv}{\oldlabel{RMAAPlate5}\label{RMAAPlate5}}
\newcommand{\@platelabelvi}{\oldlabel{RMAAPlate6}\label{RMAAPlate6}}
\newcommand{\@platelabelvii}{\oldlabel{RMAAPlate7}\label{RMAAPlate7}}
\newcommand{\@platelabelviii}{\oldlabel{RMAAPlate8}\label{RMAAPlate8}}
\newcommand{\@platelabelix}{\oldlabel{RMAAPlate9}\label{RMAAPlate9}}
\newcommand{\@platelabelx}{\oldlabel{RMAAPlate10}\label{RMAAPlate10}}
\newcommand{\@platelabelxi}{\oldlabel{RMAAPlate11}\label{RMAAPlate11}}
\newcommand{\@platelabelxii}{\oldlabel{RMAAPlate12}\label{RMAAPlate12}}
\newcommand{\@platelabelxiii}{\oldlabel{RMAAPlate13}\label{RMAAPlate13}}
\newcommand{\@platelabelxiv}{\oldlabel{RMAAPlate14}\label{RMAAPlate14}}
\newcommand{\@platelabelxv}{\oldlabel{RMAAPlate15}\label{RMAAPlate15}}
\newcommand{\@outputplatelabeli}{\oldlabel{RMAAOutputPlate1}}
\newcommand{\@outputplatelabelii}{\oldlabel{RMAAOutputPlate2}}
\newcommand{\@outputplatelabeliii}{\oldlabel{RMAAOutputPlate3}}
\newcommand{\@outputplatelabeliv}{\oldlabel{RMAAOutputPlate4}}
\newcommand{\@outputplatelabelv}{\oldlabel{RMAAOutputPlate5}}
\newcommand{\@outputplatelabelvi}{\oldlabel{RMAAOutputPlate6}}
\newcommand{\@outputplatelabelvii}{\oldlabel{RMAAOutputPlate7}}
\newcommand{\@outputplatelabelviii}{\oldlabel{RMAAOutputPlate8}}
\newcommand{\@outputplatelabelix}{\oldlabel{RMAAOutputPlate9}}
\newcommand{\@outputplatelabelx}{\oldlabel{RMAAOutputPlate10}}
\newcommand{\@outputplatelabelxi}{\oldlabel{RMAAOutputPlate11}}
\newcommand{\@outputplatelabelxii}{\oldlabel{RMAAOutputPlate12}}
\newcommand{\@outputplatelabelxiii}{\oldlabel{RMAAOutputPlate13}}
\newcommand{\@outputplatelabelxiv}{\oldlabel{RMAAOutputPlate14}}
\newcommand{\@outputplatelabelxv}{\oldlabel{RMAAOutputPlate15}}
\newcommand{\@platerefi}{\oldpageref{RMAAPlate1}}
\newcommand{\@platerefii}{\oldpageref{RMAAPlate2}}
\newcommand{\@platerefiii}{\oldpageref{RMAAPlate3}}
\newcommand{\@platerefiv}{\oldpageref{RMAAPlate4}}
\newcommand{\@platerefv}{\oldpageref{RMAAPlate5}}
\newcommand{\@platerefvi}{\oldpageref{RMAAPlate6}}
\newcommand{\@platerefvii}{\oldpageref{RMAAPlate7}}
\newcommand{\@platerefviii}{\oldpageref{RMAAPlate8}}
\newcommand{\@platerefix}{\oldpageref{RMAAPlate9}}
\newcommand{\@platerefx}{\oldpageref{RMAAPlate10}}
\newcommand{\@platerefxi}{\oldpageref{RMAAPlate11}}
\newcommand{\@platerefxii}{\oldpageref{RMAAPlate12}}
\newcommand{\@platerefxiii}{\oldpageref{RMAAPlate13}}
\newcommand{\@platerefxiv}{\oldpageref{RMAAPlate14}}
\newcommand{\@platerefxv}{\oldpageref{RMAAPlate15}}
\newcounter{figplatei}
\newcounter{figplateii}
\newcounter{figplateiii}
\newcounter{figplateiv}
\newcounter{figplatev}
\newcounter{figplatevi}
\newcounter{figplatevii}
\newcounter{figplateviii}
\newcounter{figplateix}
\newcounter{figplatex}
\newcounter{figplatexi}
\newcounter{figplatexii}
\newcounter{figplatexiii}
\newcounter{figplatexiv}
\newcounter{figplatexv}
%% Printed output should use the counter `plate'
\renewcommand{\theplate}{\@arabic\c@plate}
\renewcommand{\theplateloop}{\@arabic\c@plateloop}
%% Command to output all the saved plates in this paper
\newcommand{\outputplates}{%
  \setcounter{plateloop}{0}
  \if@book\else\@endofarticlehook\fi % not entirely sure why, but this
                                     % seems to be needed
  \clearpage % first output the last page of text
  % now set pagestyle for blank even pages and make sure we start on an odd page
  \pagestyle{empty}
  \cleardoublepage
  \onecolumn
  \parindent\z@
  % first put in an extra sheet
  % the main purpose of this is so there is always a blank even page before
  % each plate for filling in the PS file if the article has an odd number
  % of pages (see splitbook.sh)
  \null\vfil\centerline{PLATES}\vfil\clearpage\pagestyle{rmaaplate}\cleardoublepage
  % output each plate in turn
  \@whilenum\value{plateloop}<\value{plate}\do{%
    \addtocounter{plateloop}{1}
    % restore the figure counter from \@figcounti, \@figcountii, etc
    \setcounter{figure}{\value{figplate\roman{plateloop}}}
    % spew out the plate (in its own group for safety)
    {\csname @plate\roman{plateloop}\endcsname\par}
    }
  \pagestyle{rmaa}
  % reset the page number as if nothing had happened
  \addtocounter{page}{-\value{plate}}
  \addtocounter{page}{-\value{plate}}
  }
\newcommand\figcaption{%
  \def\@captype{figure}
  \renewcommand{\@makecaption}{\@makefigcap}
  \caption}
\newcommand\tabcaption{%
  \def\@captype{table}
  \renewcommand{\@makecaption}{\@maketabcap}
  \caption}

\newcommand{\plate}[2][1]{%
  %% User command to make a plate page:
  %% Mandatory argument is what goes on the plate - this should not
  %% include any floating environments (e.g. figure). Instead, \figcaption
  %% should be used to do the captions.
  %% Optional argument is the number of figures (i.e. captions) on the plate
  %% page (default is 1). This is necessary for incrementing the figure counter.
  %%
  %% Note that we have to use a \gdef rather than an \xdef when we
  %% save the plate output in a command. This means that in the book styles when it
  %% comes to spewing out the plate, we will have forgotten about any user macros
  %% that may have been defined. This can be got round by repeating the macros inside the plate.
  %% (Presumably, one would use a \newcommand rather than \renewcommand if they were new.)
  % increment global and local counters
  \addtocounter{plate}{1}
  % write appropriate label to .aux file
  \csname @platelabel\roman{plate}\endcsname
  % define a global macro called \@platei, \@plateii, \@plateiii, \@plateiv, ...
  \expandafter\gdef\csname @plate\roman{plate}\endcsname{%
    \csname @outputplatelabel\roman{plateloop}\endcsname
    \null\vfil #2 \vfil
    \cleardoublepage
    }
  % save the current shortauthor and shorttitle
  % need to be \xdef to take current values of \@shortauthor, etc
  \expandafter\xdef\csname @shorta\roman{plate}\endcsname{\@shortauthor}
  \expandafter\xdef\csname @shortt\roman{plate}\endcsname{\@shorttitle}
  % save the current value of the figure counter for later use in \outputplates
  \setcounter{figplate\roman{plate}}{\value{figure}}
  % increment the figure counter according to the optional argument
  \addtocounter{figure}{#1}
  }
%% page style for plate pages
\newcommand{\ps@rmaaplate}{%
  % Plate X (see page Y) in the foot
  \renewcommand\@oddfoot{\hfil\csname @shorta\roman{plateloop}\endcsname\
    (see page~\csname @plateref\roman{plateloop}\endcsname)\hfil}%
  \renewcommand\@evenfoot{\relax}%
  % nothing in even heads (blank pages)
  \renewcommand\@evenhead{\relax}
  % short title and page num in the odd heads
  \renewcommand\@oddhead{\hfil\csname @shortt\roman{plateloop}\endcsname%
    \hfil\llap{PLATE~\theplateloop}}
  }

%% Things for the User Guide
\if@guide
%% stolen from doc.sty
\def\MakeShortVerb#1{%
  \expandafter\ifx\csname cc\string#1\endcsname\relax
  \@shortvrbinfo{Made }{#1}%
  \add@special{#1}%
  \expandafter
  \xdef\csname cc\string#1\endcsname{\the\catcode`#1}%
  \begingroup
  \catcode`\~\active  \lccode`\~`#1%
  \lowercase{%
    \global\expandafter\let
    \csname ac\string#1\endcsname~%
    \gdef~{\verb~}}%
  \endgroup
  \global\catcode`#1\active
  \else
  \@shortvrbinfo\@empty{#1 already}%
  \fi}
\def\DeleteShortVerb#1{%
  \expandafter\ifx\csname cc\string#1\endcsname\relax
  \else
  \@shortvrbinfo{Deleted }{#1 as}%
  \rem@special{#1}%
  \global\catcode`#1\csname cc\string#1\endcsname
  \global \expandafter\let \csname cc\string#1\endcsname \relax
  \ifnum\catcode`#1=\active
  \begingroup
  \catcode`\~\active   \lccode`\~`#1%
  \lowercase{%
    \global\expandafter\let\expandafter~%
    \csname ac\string#1\endcsname}%
  \endgroup \fi \fi}
\def\@shortvrbinfo#1#2{%
  \PackageInfo{doc}{%
    #1\expandafter\@gobble\string#2 a short reference
    for \string\verb}}
\def\add@special#1{%
  \rem@special{#1}%
  \expandafter\gdef\expandafter\dospecials\expandafter
  {\dospecials \do #1}%
  \expandafter\gdef\expandafter\@sanitize\expandafter
  {\@sanitize \@makeother #1}}
\def\rem@special#1{%
  \def\do##1{%
    \ifnum`#1=`##1 \else \noexpand\do\noexpand##1\fi}%
  \xdef\dospecials{\dospecials}%
  \begingroup
  \def\@makeother##1{%
    \ifnum`#1=`##1 \else \noexpand\@makeother\noexpand##1\fi}%
  \xdef\@sanitize{\@sanitize}%
  \endgroup}
%% define | as shortcut for \verbatim
\MakeShortVerb{\|}
%% comand to specify arguments to LaTeX commands
\newcommand{\rmArg}[1]{%
  \ensuremath{\langle}{\scriptsize \textsf{\MakeUpperCase{#1}}}\ensuremath{\rangle}}
\providecommand{\BibTeX}{{\rmfamily B\kern-.05em%
    \textsc{i\kern-.025em b}\kern-.08em%
    T\kern-.1667em\lower.7ex\hbox{E}\kern-.125emX}}
%% Environment for code examples
\newenvironment{Code}{%
  \begin{list}{}{\setlength{\leftmargin}{0.05\columnwidth}}
  \item[]}{\end{list}}
\fi

\newcommand{\RMAA}{RevMexAA}
\newcommand{\RMAAlong}{Revista Mexicana de Astronom\'{\i}a y Astrof\'{\i}sica}
\newcommand{\RMAASC}{RevMexAA(SC)}
\newcommand{\RMAASClong}{\RMAA\ (Serie de Conferencias)}
\newcommand{\ibidrule}{\rule[-0.03cm]{4.7em}{.01cm}.\ }
\newcommand{\ThisVolume}[1]{%
  \@year, \if@proceedings\RMAASC\else\RMAA\fi, \@volume,
  \if@book\oldpageref{#1:RMAAFirstPage}\else 000\fi\ (this volume)}
\newcommand{\etal}{et al.\@}
\def\acknowledgments{\vskip 3ex plus .8ex minus .4ex}
\let\acknowledgements=\acknowledgments                  % second spelling
\let\jnl@style=\rm
\def\ref@jnl#1{{\jnl@style#1}}
\DeclareRobustCommand\aj{\ref@jnl{AJ}}
\DeclareRobustCommand\araa{\ref@jnl{ARA\&A}}
\DeclareRobustCommand\apj{\ref@jnl{ApJ}}
\DeclareRobustCommand\apjl{\ref@jnl{ApJ}}
\DeclareRobustCommand\apjs{\ref@jnl{ApJS}}
\DeclareRobustCommand\ao{\ref@jnl{Appl.~Opt.}}
\DeclareRobustCommand\apss{\ref@jnl{Ap\&SS}}
\DeclareRobustCommand\aap{\ref@jnl{A\&A}}
\DeclareRobustCommand\aapr{\ref@jnl{A\&A~Rev.}}
\DeclareRobustCommand\aaps{\ref@jnl{A\&AS}}
\DeclareRobustCommand\azh{\ref@jnl{AZh}}
\DeclareRobustCommand\baas{\ref@jnl{BAAS}}
\DeclareRobustCommand\jrasc{\ref@jnl{JRASC}}
\DeclareRobustCommand\memras{\ref@jnl{MmRAS}}
\DeclareRobustCommand\mnras{\ref@jnl{MNRAS}}
\DeclareRobustCommand\pra{\ref@jnl{Phys.~Rev.~A}}
\DeclareRobustCommand\prb{\ref@jnl{Phys.~Rev.~B}}
\DeclareRobustCommand\prc{\ref@jnl{Phys.~Rev.~C}}
\DeclareRobustCommand\prd{\ref@jnl{Phys.~Rev.~D}}
\DeclareRobustCommand\pre{\ref@jnl{Phys.~Rev.~E}}
\DeclareRobustCommand\prl{\ref@jnl{Phys.~Rev.~Lett.}}
\DeclareRobustCommand\pasp{\ref@jnl{PASP}}
\DeclareRobustCommand\pasj{\ref@jnl{PASJ}}
\DeclareRobustCommand\qjras{\ref@jnl{QJRAS}}
\DeclareRobustCommand\skytel{\ref@jnl{S\&T}}
\DeclareRobustCommand\solphys{\ref@jnl{Sol.~Phys.}}
\DeclareRobustCommand\sovast{\ref@jnl{Soviet~Ast.}}
\DeclareRobustCommand\ssr{\ref@jnl{Space~Sci.~Rev.}}
\DeclareRobustCommand\zap{\ref@jnl{ZAp}}
\DeclareRobustCommand\nat{\ref@jnl{Nature}}
\DeclareRobustCommand\iaucirc{\ref@jnl{IAU~Circ.}}
\DeclareRobustCommand\aplett{\ref@jnl{Astrophys.~Lett.}}
\DeclareRobustCommand\apspr{\ref@jnl{Astrophys.~Space~Phys.~Res.}}
\DeclareRobustCommand\bain{\ref@jnl{Bull.~Astron.~Inst.~Netherlands}}
\DeclareRobustCommand\fcp{\ref@jnl{Fund.~Cosmic~Phys.}}
\DeclareRobustCommand\gca{\ref@jnl{Geochim.~Cosmochim.~Acta}}
\DeclareRobustCommand\grl{\ref@jnl{Geophys.~Res.~Lett.}}
\DeclareRobustCommand\jcp{\ref@jnl{J.~Chem.~Phys.}}
\DeclareRobustCommand\jgr{\ref@jnl{J.~Geophys.~Res.}}
\DeclareRobustCommand\jqsrt{\ref@jnl{J.~Quant.~Spec.~Radiat.~Transf.}}
\DeclareRobustCommand\memsai{\ref@jnl{Mem.~Soc.~Astron.~Italiana}}
\DeclareRobustCommand\nphysa{\ref@jnl{Nucl.~Phys.~A}}
\DeclareRobustCommand\physrep{\ref@jnl{Phys.~Rep.}}
\DeclareRobustCommand\physscr{\ref@jnl{Phys.~Scr}}
\DeclareRobustCommand\planss{\ref@jnl{Planet.~Space~Sci.}}
\DeclareRobustCommand\procspie{\ref@jnl{Proc.~SPIE}}
\let\astap=\aap
\let\apjlett=\apjl
\let\apjsupp=\apjs
\let\applopt=\ao
\def\phn{\phantom{0}}
\def\phd{\phantom{.}}
\def\phs{\phantom{\ensuremath{-}}}
\def\phm#1{\phantom{#1}}
%%\def\sun{\hbox{$\odot$}}
\DeclareRobustCommand\sun{\ensuremath{\odot}}
%%\def\earth{\hbox{$\oplus$}}
\DeclareRobustCommand\earth{\ensuremath{\oplus}}
%%\def\lesssim{\mathrel{\hbox{\rlap{\hbox{\lower4pt\hbox{$\sim$}}}\hbox{$<$}}}}
%%\def\gtrsim{\mathrel{\hbox{\rlap{\hbox{\lower4pt\hbox{$\sim$}}}\hbox{$>$}}}}
\DeclareRobustCommand\lesssim{\mathrel{\hbox{\smaller\smaller\rlap{\hbox{\lower3pt\hbox{$\sim$}}}\raise1.5pt\hbox{$<$}}}}
\DeclareRobustCommand\gtrsim{\mathrel{\hbox{\smaller\smaller\rlap{\hbox{\lower3pt\hbox{$\sim$}}}\raise1.5pt\hbox{$>$}}}}
%%\def\lta{\mathrel{\spose{\lower 3pt\hbox{$\mathchar"218$}}
%%     \raise 2.0pt\hbox{$\mathchar"13C$}}}
%%\def\gta{\mathrel{\spose{\lower 3pt\hbox{$\mathchar"218$}}
%%     \raise 2.0pt\hbox{$\mathchar"13E$}}}
\DeclareRobustCommand\sq{\hbox{\rlap{$\sqcap$}$\sqcup$}}
%%\def\arcdeg{\hbox{$^\circ$}}
%%\def\arcmin{\hbox{$^\prime$}}
%%\def\arcsec{\hbox{$^{\prime\prime}$}}
\DeclareRobustCommand\arcdeg{\ensuremath{^\circ}}
\DeclareRobustCommand\arcmin{\ensuremath{^\prime}}
\DeclareRobustCommand\arcsec{\ensuremath{^{\prime\prime}}}
%%\def\fd{\hbox{$.\!\!^{\rm d}$}}
%%\def\fh{\hbox{$.\!\!^{\rm h}$}}
%%\def\fm{\hbox{$.\!\!^{\rm m}$}}
%%\def\fs{\hbox{$.\!\!^{\rm s}$}}
%%\def\fdg{\hbox{$.\!\!^\circ$}}
%%\def\farcm{\hbox{$.\mkern-4mu^\prime$}}
%%\def\farcs{\hbox{$.\!\!^{\prime\prime}$}}
%%\def\fp{\hbox{$.\!\!^{\scriptscriptstyle\rm p}$}}
\DeclareRobustCommand\fd{\ensuremath{.\!\!^\mathrm{d}}}
\DeclareRobustCommand\fh{\ensuremath{.\!\!^\mathrm{h}}}
\DeclareRobustCommand\fm{\ensuremath{.\!\!^\mathrm{m}}}
\DeclareRobustCommand\fs{\ensuremath{\mkern0.5mu.\mkern-5mu^\mathrm{s}\mkern-1mu}}
\DeclareRobustCommand\fdg{\ensuremath{.\!\!^\circ}}
\DeclareRobustCommand\farcm{\ensuremath{.\mkern-4mu^\prime}}
\DeclareRobustCommand\farcs{\ensuremath{\mkern1mu.\mkern-6mu^{\prime\prime}\mkern-1.5mu}}
%%\DeclareRobustCommand\farcs{\ensuremath{.\!\!^{\prime\prime}}}
\DeclareRobustCommand\fp{\ensuremath{.\!\!^{\scriptscriptstyle\rm p}}}
%%\def\micron{\hbox{$\mu$m}}
\DeclareRobustCommand\micron{\ensuremath{\mu\mathrm{m}}}
\let\la=\lesssim
\let\ga=\gtrsim
%%\def\case#1#2{\hbox{$\frac{#1}{#2}$}}
%%\def\slantfrac#1#2{\hbox{$\,^#1\!/_#2$}}
%%\def\onehalf{\slantfrac{1}{2}}
%%\def\onethird{\slantfrac{1}{3}}
%%\def\twothirds{\slantfrac{2}{3}}
%%\def\onequarter{\slantfrac{1}{4}}
%%\def\threequarters{\slantfrac{3}{4}}
\DeclareRobustCommand\case[2]{\ensuremath{\frac{#1}{#2}}}
\DeclareRobustCommand\slantfrac[2]{\ensuremath{\,^#1\!/_#2}}
\DeclareRobustCommand\onehalf{\slantfrac{1}{2}}
\DeclareRobustCommand\onethird{\slantfrac{1}{3}}
\DeclareRobustCommand\twothirds{\slantfrac{2}{3}}
\DeclareRobustCommand\onequarter{\slantfrac{1}{4}}
\DeclareRobustCommand\threequarters{\slantfrac{3}{4}}
%%\def\ubvr{\hbox{$U\!BV\!R$}}
%%\def\ub{\hbox{$U\!-\!B$}}
%%\def\bv{\hbox{$B\!-\!V$}}
%%\def\vr{\hbox{$V\!-\!R$}}
%%\def\ur{\hbox{$U\!-\!R$}}
\DeclareRobustCommand\ubvr{\ensuremath{U\!BV\!R}}
\DeclareRobustCommand\ub{\ensuremath{U\!-\!B}}
\DeclareRobustCommand\bv{\ensuremath{B\!-\!V}}
\DeclareRobustCommand\vr{\ensuremath{V\!-\!R}}
\DeclareRobustCommand\ur{\ensuremath{U\!-\!R}}
%% New version of the \ion command, that actually works!
\DeclareRobustCommand\ion[2]{%
  \mbox{#1\kern0.2em%
    \smaller\rmfamily%
    \edef\@tempa{\@car#2\@nil}%
    \ifcat1\@tempa%
    \@Roman{#2}%
    \else%
    \uppercase{#2}%
    \fi}}
\newcounter{IonStage}
\DeclareRobustCommand\plainion[2]{\setcounter{IonStage}{#2}#1 \Roman{IonStage}}
%%\def\ion#1#2{\ensuremath{\mathrm{#1}\;}{\protect\small\rm\@Roman{#2}}}
\def\nodata{ ~$\cdots$~ }
\let\@small=\small
\let\@normalsize=\normalsize
\let\@footnotesize=\footnotesize
\let\@scriptsize=\scriptsize
\let\@tiny=\tiny
\let\@large=\large
\let\@Large=\Large
\let\@LARGE=\LARGE
\let\@huge=\huge
\let\@Huge=\Huge
\newcommand{\smaller}{\small}
\renewcommand{\normalsize}{\renewcommand{\smaller}{\small}\@normalsize}
\renewcommand{\small}{\renewcommand{\smaller}{\footnotesize}\@small}
\renewcommand{\footnotesize}{\renewcommand{\smaller}{\scriptsize}\@footnotesize}
\renewcommand{\scriptsize}{\renewcommand{\smaller}{\tiny}\@scriptsize}
\renewcommand{\tiny}{\renewcommand{\smaller}{\tiny}\@tiny}
\renewcommand{\large}{\renewcommand{\smaller}{\normalsize}\@large}
\renewcommand{\Large}{\renewcommand{\smaller}{\large}\@Large}
\renewcommand{\LARGE}{\renewcommand{\smaller}{\Large}\@LARGE}
\renewcommand{\huge}{\renewcommand{\smaller}{\LARGE}\@huge}
\renewcommand{\Huge}{\renewcommand{\smaller}{\huge}\@Huge}













\endinput
%%
%% End of file `rmaa.cls'.
