\NeedsTeXFormat{LaTeX2e}[1995/06/01]

\ProvidesClass{npcs}[2001/02/21]
%

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax
%
\LoadClass[12pt,a4paper,twoside]{article}
%
\RequirePackage{calc}
%%
\AtBeginDocument{\label{firstpage}}
%
%    Issue publication info

%    \issueinfo{330}% volume number
%    {2}% issue number
%    {July}% month
%    {1995}% year
\def\issueinfo#1#2#3{%
  \def\issuevol@{#1}\def\issueno@{#2}%
  \def\issueyear@{#3}}
%
\issueinfo{10}{3}{2001}

\setlength{\marginparpush}{0pt}
\setlength{\marginparsep}{0pt}
\setlength{\marginparwidth}{0pt}
\setlength{\footskip}{0pt}
\setlength{\headheight}{\baselineskip}
\setlength{\oddsidemargin}{0pt}
\setlength{\textwidth}{165mm}
\setlength{\evensidemargin}{\paperwidth - \textwidth - \oddsidemargin - (1in + \hoffset)*2}
\setlength{\textheight}{250mm - \topskip}
\newcounter{tmp}
\setcounter{tmp}{\textheight}
\newcounter{tmpc}
\setcounter{tmpc}{\baselineskip}
\setcounter{tmp}{\value{tmp}/\value{tmpc}}
\setlength{\textheight}{\baselineskip*\value{tmp} + \topskip}
\setlength{\topmargin}{(\paperheight - \textheight - \headheight - \headsep)/2 - 1in}
%
\def\NPCS{{\sffamily NPCS}}
%
\def\ps@firstpageheadings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\sffamily\leftmark}%
    \def\@oddhead{\sffamily\rightmark}%
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
    }
%
\gdef\thecatchlines{%
\vbox to\headheight{\vss
%\hbox to\textwidth{%\hss
%\uppercase
%{Nonlinear Phenomena in Complex Systems}, %
%Vol. \issuevol@, 
%No. \issueno@
%(\issueyear@) \pageref{firstpage} --- \pageref{lastpage}
}
\hss
}%
\def\runauthor#1{\gdef\@runauthor{#1}} \let\@runauthor\relax
\def\runtitle#1{\gdef\@runtitle{#1}}   \let\@runtitle\relax
%
\let\maketitle\relax
\def\topmatter{%
 \begingroup
\def\footnote##1##{\thanks}
   \def\@makefnmark{\hbox{$\m@th^{\@thefnmark}$}}%
     \global\@topnum\z@\newpage
     \markboth{\thecatchlines}{\thecatchlines}%
     \vspace*{-2.5\baselineskip}
     %\leftline{\small\textsf{\copyright{} Institute of Physics of the National Academy of Sciences of Belarus}}
     \vspace*{3\baselineskip}
}
%
\def\endtopmatter{\thispagestyle{firstpageheadings}\@thanks
 \endgroup
 \let\maketitle\relax
 \let\@maketitle\relax
 \gdef\@thanks{}\gdef\@author{}\gdef\@title{}\let\thanks\relax
 \vskip18pt
 }
%
\def\@evenhead{\def\and{ \& }\underline{\hbox to\textwidth{\strut\rm \thepage\quad{\footnotesize\slshape\sffamily\@runauthor}\hfil}}}
\def\@oddhead{\underline{\hbox to\textwidth{\strut\hfil {\footnotesize\slshape\sffamily\@runtitle}\quad\rm\thepage}}}
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
\def\@evenfoot{}
\def\@oddfoot{}
%
\def\nohyphen{\pretolerance=10000 \tolerance=10000
\hyphenpenalty=10000 \exhyphenpenalty=10000}
%
\newif\if@address \@addressfalse
\newif\if@institution \@institutionfalse
\newif\if@email \@emailfalse
\def\sep{\unskip, }\def\and{\unskip~and }
\let\@ldthanks\thanks
\def\elem@nothanks#1\thanks{\futurelet\@peektok\elem@thanks}
\def\elem@thanks{\ifx\@peektok\relax\else \expandafter\elem@morethanks\fi}
%
\def\elem@morethanks#1{\@ldthanks{#1}\elem@nothanks}
\gdef\@title{}
\def\title#1{\vspace*{5pt}\vbox{\let\thanks\@gobble\nohyphen\raggedright%
\centering\Large\bfseries #1\expandafter\elem@nothanks#1\thanks\relax}}
\def\author#1{\vskip20pt\centering{\let\thanks\@gobble\small\expandafter{ #1}
\expandafter\elem@nothanks#1\thanks\relax}\vskip5pt}
\def\institution#1{\vbox{\centering\footnotesize\sl #1}}
\def\address#1{\vbox{\centering\footnotesize\rm #1}}
\def\telfax#1{\if@email\vskip0pt\else\vskip0pt\@emailtrue\fi%
               \centerline{\mbox{\footnotesize\sf \ #1}}}
\def\email#1{\if@email\vskip0pt\else\vskip0pt\@emailtrue\fi%
               \centerline{\mbox{\footnotesize\sf E-mail:\ #1}}}
\def\abstract{\vskip20pt\bgroup\begin{center}\footnotesize
\begin{minipage}{\textwidth*\real{0.8}}\ignorespaces\textbf{Abstract. }}
\def\endabstract{\end{minipage}\end{center}\egroup}
\def\pacs#1{\begin{center}\vskip-5pt\parbox{\textwidth*\real{0.8}}{\footnotesize
\textbf{PACS:} #1.}\end{center}}
\def\msc#1{\begin{center}\vskip-5pt\parbox{\textwidth*\real{0.8}}{\footnotesize
\textbf{2000 MSC:} #1.}\end{center}}
\def\keywords#1{\begin{center}\vskip-5pt\parbox{\textwidth*\real{0.8}}{\footnotesize
\textbf{Key words:} #1.}\end{center}}

\def\section{\@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\large\bfseries}}
\def\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalsize\bfseries}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\normalsize\bfseries\itshape}}
\def\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\normalfont\normalsize\itshape}}
\def\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                      {\normalfont\normalsize\sl}}

%
\gdef\theoremstyle#1{%
   \@ifundefined{th@#1}{\@warning
          {Unknown theoremstyle `#1'. Using `plain'}%
          \theorem@style{plain}}%
      {\theorem@style{#1}}%
      \begingroup
        \csname th@\the\theorem@style \endcsname
      \endgroup}
\global\let\@begintheorem\relax
\global\let\@opargbegintheorem\relax
\newtoks\theorem@style
\global\theorem@style{plain}
\gdef\theorembodyfont#1{%
   \def\@tempa{#1}%
   \ifx\@tempa\@empty
    \theorem@bodyfont{}%
   \else
    \theorem@bodyfont{\reset@font#1}%
   \fi
   }
\newtoks\theorem@bodyfont
\global\theorem@bodyfont{}
\gdef\theoremheaderfont#1{\gdef\theorem@headerfont{#1}%
       \gdef\theoremheaderfont##1{%
        \typeout{\string\theoremheaderfont\space should be used
                 only once.}}}
\ifx\upshape\undefined
\gdef\theorem@headerfont{\bfseries}
\else \gdef\theorem@headerfont{\normalfont\bfseries}\fi
\begingroup
\gdef\th@plain{\normalfont\itshape
  \def\@begintheorem##1##2{%
        \item[\hskip\labelsep \theorem@headerfont ##1\ ##2.]}%
\def\@opargbegintheorem##1##2##3{%
   \item[\hskip\labelsep \theorem@headerfont ##1\ ##2\ ##3.]}}
\endgroup
\gdef\@xnthm#1#2[#3]{\expandafter\@ifdefinable\csname #1\endcsname
   {%
    \@definecounter{#1}\@newctr{#1}[#3]%
    \expandafter\xdef\csname the#1\endcsname
      {\expandafter \noexpand \csname the#3\endcsname
       \@thmcountersep \@thmcounter{#1}}%
    \def\@tempa{\global\@namedef{#1}}%
    \expandafter \@tempa \expandafter{%
      \csname th@\the \theorem@style
            \expandafter \endcsname \the \theorem@bodyfont
     \@thm{#1}{#2}}%
    \global \expandafter \let \csname end#1\endcsname \@endtheorem
   }}
\gdef\@ynthm#1#2{\expandafter\@ifdefinable\csname #1\endcsname
   {\@definecounter{#1}%
    \expandafter\xdef\csname the#1\endcsname{\@thmcounter{#1}}%
    \def\@tempa{\global\@namedef{#1}}\expandafter \@tempa
     \expandafter{\csname th@\the \theorem@style \expandafter
     \endcsname \the\theorem@bodyfont \@thm{#1}{#2}}%
    \global \expandafter \let \csname end#1\endcsname \@endtheorem}}
\gdef\@othm#1[#2]#3{%
  \expandafter\ifx\csname c@#2\endcsname\relax
   \@nocounterr{#2}%
  \else
   \expandafter\@ifdefinable\csname #1\endcsname
   {\expandafter \xdef \csname the#1\endcsname
     {\expandafter \noexpand \csname the#2\endcsname}%
    \def\@tempa{\global\@namedef{#1}}\expandafter \@tempa
     \expandafter{\csname th@\the \theorem@style \expandafter
     \endcsname \the\theorem@bodyfont \@thm{#2}{#3}}%
    \global \expandafter \let \csname end#1\endcsname \@endtheorem}%
  \fi}
\gdef\@thm#1#2{\refstepcounter{#1}%
   \trivlist
   \@topsep \theorempreskipamount               % used by first \item
   \@topsepadd \theorempostskipamount           % used by \@endparenv
   \@ifnextchar [%
   {\@ythm{#1}{#2}}%
   {\@begintheorem{#2}{\csname the#1\endcsname}\ignorespaces}}
\global\let\@xthm\relax
\newskip\theorempreskipamount
\newskip\theorempostskipamount
\global\setlength\theorempreskipamount{12pt plus 5pt minus 3pt}
\global\setlength\theorempostskipamount{8pt plus 3pt minus 1.5pt}
\global\let\@endtheorem=\endtrivlist
\@onlypreamble\@xnthm
\@onlypreamble\@ynthm
\@onlypreamble\@othm
\@onlypreamble\newtheorem
\@onlypreamble\theoremstyle
\@onlypreamble\theorembodyfont
\@onlypreamble\theoremheaderfont
\theoremstyle{plain}
%
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1. #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1. #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
%
\renewenvironment{thebibliography}[1]
     {\footnotesize\section*{\refname
        \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
%
\newtheorem{theorem}{Theorem}[section]
\newtheorem{lemma}{Lemma}[section]
\newtheorem{definition}{Definition}[section]
\newtheorem{prop}{Proposition}[section]
\newtheorem{cor}{Corollary}[section]
%{\theorembodyfont{\normalfont}
\newtheorem{remark}{Remark}[section]
\newtheorem{example}{Example}[section]
%}
%
\DeclareRobustCommand{\qed}{%
  \ifmmode % if math mode, assume display: omit penalty etc.
  \else \leavevmode\unskip\penalty9999 \hbox{}\nobreak\hfill
  \fi
  \quad\hbox{\qedsymbol}}
\newcommand{\openbox}{\leavevmode
  \hbox to.77778em{%
  \hfil\vrule
  \vbox to.675em{\hrule width.6em\vfil\hrule}%
  \vrule\hfil}}
\newcommand{\qedsymbol}{\openbox}
%
\def\@addpunct#1{\ifnum\spacefactor>\@m \else#1\fi}
\newenvironment{proof}[1][\proofname]{\par
  \normalfont
  \topsep6\p@\@plus6\p@ \trivlist
  \item[\hskip\labelsep\itshape
    #1\@addpunct{.}]\ignorespaces
}{%
  \qed\endtrivlist
}
\newcommand{\proofname}{Proof}
%
\let\@newpf\proof \let\proof\relax \let\endproof\relax
\newenvironment{pf}{\@newpf[\indent\proofname]}{\qed\endtrivlist}
\newenvironment{pf*}[1]{\@newpf[#1]}{\qed\endtrivlist}

%renew counter ecuation
%\makeatletter\@addtoreset{equation}{section}
%\renewcommand{\theequation}{\arabic{section}.\arabic{equation}}
\makeatletter
\renewcommand{\@seccntformat}[1]{%
\csname the#1\endcsname.\hspace{0.5em}}
%\makeatother
\def\artj#1#2#3#4#5#6{#1. #2. {\it #3}, {\bf #4} #5#6.}
\def\artjwn#1#2#3#4#5#6{#1. #2. {\it #3}, {\bf #4}, #5#6.}
\def\artp#1#2#3#4#5#6{#1. #2. In: {\it #3},  #4, #5#6.}
\def\book#1#2#3#4#5#6{#1. #2 {\it #3}. #4, #5#6.}
\def\artall#1#2#3#4#5#6{#1 #2 {\it #3} #4 #5#6.}
%
\def\receive#1{%
  \ifx\@empty\@receive \def\@receive{#1}%
  \else\g@addto@macro\@receive{\and#1}\fi}
%
\let\@receive=\@empty
\def\@setreceive{\par\begingroup
%  \addvspace{6\p@\@plus9\p@}%
  \hbox to\columnwidth{\hss\normalfont\footnotesize\it
    Received %
    \@receive}
  \endgroup
}
%
\def\revised#1{%
  \ifx\@empty\@revised \def\@revised{#1}%
  \else\g@addto@macro\@revised{\and#1}\fi}
%
\let\@revised=\@empty
\def\@setrevised{\par\begingroup
%  \addvspace{6\p@\@plus9\p@}%
  \hbox to\columnwidth{\hss\normalfont\footnotesize\it
    Revised %
    \@revised}
  \endgroup
}
\def\enddoc@text{\ifx\@empty\@receive \else\@setreceive\fi
\ifx\@empty\@revised \else\@setrevised\fi}
\AtEndDocument{\label{lastpage}\vskip20pt\raggedright\enddoc@text}
%\endinput
%\renewcommand{\theequation}{\arabic{equation}}
\def\figurename{Fig.}%
