% ckm.cls
% Some parts from espcrc2.sty v2.8 2000/07/24
% JMF 16 April 2002
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{ckm}[2003/04/16 v0.0.1 CKM Workshop Proceedings]

\newif\if@preprint \@preprintfalse
\DeclareOption{preprintstyle}  % preprint option will give one column:
 {\@preprinttrue               % default is two columns
  \PassOptionsToClass{12pt}{article}}
\DeclareOption{proceedings}    % will be the default
 {\PassOptionsToClass{fleqn,10pt,twoside}{article}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}} % undeclared
                                                              % options go
                                                              % to article
\ExecuteOptions{proceedings}   % default
\ProcessOptions

\LoadClass{article}
\RequirePackage{graphicx}


\oddsidemargin  -0.25in
\evensidemargin\oddsidemargin

\topmargin      2mm
\headheight     12pt              % height of running headl
\headsep        21pt              % space between running head and text
\footskip       0pt               % Baseline-baseline distance between
                                  % running footline and last line of text.
\textheight 9.3in
\textwidth 6.75in

\columnsep 7mm                   % Horizontal space between columns
\columnseprule 0pt               % No vertical rule between columns

\parskip\medskipamount
\parindent0pt

% SECTIONS
\newdimen\@bls                    % \@b(ase)l(ine)s(kip)
\@bls=\baselineskip               % \@bls ~= \baselineskip for \normalsize
\advance\@bls -1ex                % (fudge term)
\newdimen\@eps                    %
\@eps=0.0001pt                    %

\def\section{\@startsection{section}{1}{\z@}
  {1.5\@bls plus 0.5\@bls}{1\@bls}{\large\bf}}
\def\subsection{\@startsection{subsection}{2}{\z@}
  {1\@bls plus 0.25\@bls}{\@eps}{\normalsize\bf}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}
  {1\@bls plus 0.25\@bls}{\@eps}{\normalsize\bf}}
\def\paragraph{\@startsection{paragraph}{4}{\parindent}
  {1\@bls plus 0.25\@bls}{0.5em}{\normalsize\bf}}
\def\subparagraph{\@startsection{subparagraph}{4}{\parindent}
  {1\@bls plus 0.25\@bls}{0.5em}{\normalsize\bf}}


% FIGURES AND TABLES
\long\def\@makecaption#1#2{% modified from article.cls
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\small\textbf{#1}. #2}%
  \ifdim \wd\@tempboxa >\hsize
    \small\textbf{#1}. #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

%\long\def\@makefigurecaption#1#2{\vskip\@bls\small \textbf{#1}. #2}
%\long\def\@maketablecaption#1#2{\vskip\@bls\small \textbf{#1}. #2}
%\def\fnum@figure{Figure \thefigure}
%\def\figure{\let\@makecaption\@makefigurecaption \@float{figure}}
%\@namedef{figure*}{\let\@makecaption\@makefigurecaption \@dblfloat{figure}}
% \def\fnum@table{Table \thetable}
%\def\table{\let\@makecaption\@maketablecaption \@float{table}}
%\@namedef{table*}{\let\@makecaption\@maketablecaption \@dblfloat{table}}

\floatsep 20pt plus 4pt minus 4pt % Space between adjacent floats moved
                                  % to top or bottom of text page.
\textfloatsep=\floatsep           % Space between main text and floats
                                  % at top or bottom of page.
\intextsep=\floatsep              % Space between in-text figures and 
                                  % text.

\renewcommand{\floatpagefraction}{0.55}    % min fraction of float
\renewcommand{\dblfloatpagefraction}{0.55} % page to be occupied by floats

% FOOTNOTE
\long\def\@makefntext#1{\parindent 1em\noindent\hbox{${}^{\@thefnmark}$}#1}

% EQUATION
\mathindent=0em

% TITLE
\def\maketitle{\begingroup        % Initialize generation of front-matter
%   \let\thanks\@gobble
    \def\thefootnote{\fnsymbol{footnote}}%
    \newpage\thispagestyle{front}\global\@topnum\z@
    \@maketitle \@thanks
  \endgroup
  \let\maketitle\relax \let\@maketitle\relax
  \gdef\@thanks{}\let\thanks\relax
  \gdef\@address{}\gdef\@author{}\gdef\@title{}\let\address\relax}

\def\justify@on{\let\\=\@normalcr
  \leftskip\z@ \@rightskip\z@ \rightskip\@rightskip}

\newbox\fm@box                    % Box to capture front-matter in

\def\@maketitle{%                 % Actual formatting of \maketitle
  \global\setbox\fm@box=\vbox\bgroup
    \vskip 8mm                    % 930715: 8mm white space above title
    \raggedright                  % Front-matter text is ragged right
    \hyphenpenalty\@M             % and is not hyphenated.
    {\Large \@title \par}         % Title set in larger font. 
    \vskip\@bls                   % One line of vertical space after title.
    {\normalsize                  % each author set in the normal 
     \@author \par}               % typeface size 
    \vskip\@bls                   % One line of vertical space after author(s).
    {\parskip\smallskipamount
    \@address}                     % all addresses
  \egroup
  \if@preprint
    \vspace*{1pc}
    \unvbox\fm@box
    \vskip1.3\@bls
    \unvbox\abstract@box
    \vskip 2pc
  \else
   \twocolumn[%                   % Front-matter text over 2 columns.
    \unvbox\fm@box                % Unwrap contents of front-matter box
    \vskip1.3\@bls                   % add 1 line of vertical space, 
    \unvbox\abstract@box          % unwrap contents of abstract boxes,
    \vskip 2pc]                   % and add 2pc of vertical space
  \fi}

\newcommand{\address}[2][]{\@addtoaddress{#1}{#2}}
\newcommand{\addressmark}[1]{\@makeadmark{#1}}
\def\@makeadmark#1{\hbox{$^{\rm #1}$}}   

\def\@addtoaddress#1#2{\begingroup
  \let\\=\relax
  \def\protect{\noexpand\protect\noexpand}\xdef\@address{\@address
  \protect\addresstext{#1}{#2}}\endgroup}
\def\@address{}

\def\addresstext#1#2{\leavevmode \begingroup
  \raggedright \hyphenpenalty\@M \@makeadmark{#1}#2\par \endgroup
  \vskip\@bls}

% ABSTRACT
\newbox\abstract@box              % Box to capture abstract in

\def\abstract{%
  \global\setbox\abstract@box=\vbox\bgroup
  \small\rm
  \ignorespaces}
\def\endabstract{\par \egroup}

% BIBLIOGRAPHY -- modified from article.cls
\def\@biblabel#1{#1.}
\renewenvironment{thebibliography}[1]
     {\section*{\refname
        \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \itemsep\z@ \parsep\z@
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \raggedright
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}

% Collapse citation numbers to ranges.  
\newcount\@tempcntc
\def\@citex[#1]#2{\if@filesw\immediate\write\@auxout{\string\citation{#2}}\fi
  \@tempcnta\z@\@tempcntb\m@ne\def\@citea{}\@cite{\@for\@citeb:=#2\do
    {\@ifundefined
       {b@\@citeb}{\@citeo\@tempcntb\m@ne\@citea
        \def\@citea{,\penalty\@m\ }{\bf ?}\@warning
       {Citation `\@citeb' on page \thepage \space undefined}}%
    {\setbox\z@\hbox{\global\@tempcntc0\csname b@\@citeb\endcsname\relax}%
     \ifnum\@tempcntc=\z@ \@citeo\@tempcntb\m@ne
       \@citea\def\@citea{,\penalty\@m}
       \hbox{\csname b@\@citeb\endcsname}%
     \else
      \advance\@tempcntb\@ne
      \ifnum\@tempcntb=\@tempcntc
      \else\advance\@tempcntb\m@ne\@citeo
      \@tempcnta\@tempcntc\@tempcntb\@tempcntc\fi\fi}}\@citeo}{#1}}

\def\@citeo{\ifnum\@tempcnta>\@tempcntb\else\@citea
  \def\@citea{,\penalty\@m}%
  \ifnum\@tempcnta=\@tempcntb\the\@tempcnta\else
   {\advance\@tempcnta\@ne\ifnum\@tempcnta=\@tempcntb \else
\def\@citea{--}\fi
    \advance\@tempcnta\m@ne\the\@tempcnta\@citea\the\@tempcntb}\fi\fi}

% PAGE STYLES
\def\confname#1{\gdef\@confname{#1}}
%\def\@confname{\@latex@error{No \noexpand\confname given}\@ehc}
\let\@confname\relax

\def\ps@ckmplain{\let\@mkboth\@gobbletwo
     \def\@oddhead{\reset@font\sf\@confname\hfil\thepage}%
     \def\@evenhead{\reset@font\sf\thepage\hfil\@confname}%
     \let\@oddfoot\@empty
     \let\@evenfoot\@oddfoot}
\def\ps@front{\let\@mkboth\@gobbletwo
     \def\@oddhead{\reset@font\sf\@confname
     \hfil \includegraphics[bb=0 23 85 35]{logo.eps}}%
%     \hfil \flushleft{\hspace{-6mm}HU-EP-03/26, SFB/CPP-03-09}
     \let\@evenhead\@oddhead
     \let\@oddfoot\@empty
     \let\@evenfoot\@oddfoot}


% INITIALIZATION
\sloppy                         % paragraphs can be loosely set
\emergencystretch=1pc           % (with 1 pc extra for emergencies)
\flushbottom                    % pages of equal length
\ps@ckmplain                    % modified 'plain' page style
