\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{ar2e}[1997/08/13 v1.0 Standard LaTeX document class]
\newcommand\@ptsize{}
\newif\if@restonecol
\newif\if@titlepage
\@titlepagefalse
\newif\if@openbib
\@openbibfalse
\newif\ifcitepar
\citeparfalse
\DeclareOption{nocitepar}
   {\global\citepartrue}
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\DeclareOption{titlepage}{\@titlepagetrue}
\DeclareOption{notitlepage}{\@titlepagefalse}
\DeclareOption{onecolumn}{\@twocolumnfalse}
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\DeclareOption{openbib}{\@openbibtrue}
\ExecuteOptions{letterpaper,10pt,onecolumn,final,twoside}
\ProcessOptions
%\input{size1\@ptsize.clo}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\renewcommand\normalsize{%
   \@setfontsize\normalsize\@xipt{13pt}
   \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\normalsize
\newcommand\small{%
   \@setfontsize\small\@xpt{12}%
   \abovedisplayskip 8.5\p@ \@plus3\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus2\p@
   \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 4\p@ \@plus2\p@ \@minus2\p@
               \parsep \z@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\newcommand\footnotesize{%
   \@setfontsize\footnotesize\@ixpt{11}%
   \abovedisplayskip 6\p@ \@plus2\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus\p@
   \belowdisplayshortskip 3\p@ \@plus\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 3\p@ \@plus\p@ \@minus\p@
               \parsep \z@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\newcommand\scriptsize{\@setfontsize\scriptsize\@viiipt\@xpt}
\newcommand\tiny{\@setfontsize\tiny\@vpt\@vipt}
\newcommand\large{\@setfontsize\large\@xiipt{14}}
\newcommand\Large{\@setfontsize\Large\@xivpt{18}}
\newcommand\LARGE{\@setfontsize\LARGE\@xviipt{22}}
\newcommand\huge{\@setfontsize\huge\@xxpt{25}}
\newcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
%
\setlength\parindent{1em}
\setlength\headheight{10\p@}
\setlength\headsep   {12\p@}
\setlength\topskip   {10\p@}
\setlength\footskip{30\p@}
\setlength\maxdepth{.5\topskip}
\setlength\@maxdepth\maxdepth
\setlength\textwidth{32pc}\advance\hoffset2pc
\setlength\textheight{54pc}\advance\voffset-5pc

\setlength\oddsidemargin{-2pc}
\setlength\evensidemargin{7pc}
\setlength\topmargin{4pc}
\setlength\marginparwidth{130\p@}
\setlength\marginparsep{11\p@}
\setlength\marginparpush{5\p@}

\setlength\footnotesep{6.65\p@}
\setlength{\skip\footins}{9\p@ \@plus 4\p@ \@minus 2\p@}
\setlength\floatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\textfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\intextsep   {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dblfloatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\@fptop{0\p@ \@plus 1fil}
\setlength\@fpsep{8\p@ \@plus 2fil}
\setlength\@fpbot{0\p@ \@plus 1fil}
\setlength\@dblfptop{0\p@ \@plus 1fil}
\setlength\@dblfpsep{8\p@ \@plus 2fil}
\setlength\@dblfpbot{0\p@ \@plus 1fil}
\setlength\partopsep{0\p@}
\def\@listI{\leftmargin\leftmargini
            \parsep \z@
            \topsep 8\p@ \@plus2\p@ \@minus4\p@
            \itemsep4\p@ \@plus2\p@ \@minus\p@}
\let\@listi\@listI
\@listi
\def\@listii {\leftmargin\leftmarginii
              \labelwidth\leftmarginii
              \advance\labelwidth-\labelsep
              \topsep    4\p@ \@plus2\p@ \@minus\p@
              \parsep \z@
              \itemsep   \parsep}
\def\@listiii{\leftmargin\leftmarginiii
              \labelwidth\leftmarginiii
              \advance\labelwidth-\labelsep
              \topsep    2\p@ \@plus\p@\@minus\p@
              \parsep    \z@
              \partopsep \p@ \@plus\z@ \@minus\p@
              \itemsep   \topsep}
\def\@listiv {\leftmargin\leftmarginiv
              \labelwidth\leftmarginiv
              \advance\labelwidth-\labelsep}
\def\@listv  {\leftmargin\leftmarginv
              \labelwidth\leftmarginv
              \advance\labelwidth-\labelsep}
\def\@listvi {\leftmargin\leftmarginvi
              \labelwidth\leftmarginvi
              \advance\labelwidth-\labelsep}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{2}
\setlength\parskip{0\p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{1}
\renewcommand\topfraction{.1}
\setcounter{bottomnumber}{5}
\renewcommand\bottomfraction{.1}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.9}
\renewcommand\floatpagefraction{1}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.1}
\renewcommand\dblfloatpagefraction{.1}

\long\def\@makecaption#1#2{
 \vskip 10pt 
 \setbox\@tempboxa\hbox{#1: #2}
 \ifdim \wd\@tempboxa >\hsize #1: #2\par \else \hbox
to\hsize{\hfil\box\@tempboxa\hfil} 
 \fi}
\def\figurebox#1#2{\hfill\fboxsep0pt\fbox{\vbox to #1{\hsize#2\hskip#2}}\hfill}

\def\Caption{\refstepcounter\@captype \@dblarg{\@caption\@captype}}
\long\def\@caption#1[#2]#3{%
  \par
  \addcontentsline{\csname ext@#1\endcsname}{#1}%
    {\protect\numberline{\csname the#1\endcsname}{\ignorespaces #2}}%
  \begingroup
    \@parboxrestore
    \if@minipage
      \@setminipage
    \fi
    \normalsize
    \@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
  \endgroup}

\def\toprule{\hline}
\def\colrule{\hline}
\def\botrule{\hline}


\if@twoside
    \def\ps@headings{%
      \let\@oddfoot\@empty\let\@evenfoot\@empty
      \def\@evenhead{\thepage\hfil\slshape\leftmark}%
      \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
      \let\@mkboth\markboth
      \def\sectionmark##1{%
        \markboth {\uppercase{\ifnum \c@secnumdepth >\z@
            \thesection.\hskip 1em\relax\fi
            ##1}}{}}%
      \def\subsectionmark##1{%
        \markright {\ifnum \c@secnumdepth >\@ne
            \thesubsection\hskip 1em\relax \fi
            ##1}}}
\else
    \def\ps@headings{%
      \let\@oddfoot\@empty
      \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
      \let\@mkboth\markboth
      \def\sectionmark##1{%
        \markright {\uppercase{\ifnum \c@secnumdepth >\m@ne
            \thesection\hskip 1em\relax \fi
            ##1}}}}
\fi
%%%
\def\ps@plain{\let\@mkboth\@gobbletwo
\def\@oddhead{\hfill\footnotesize\@jname\ \@jyear\ 
\@jvol\qquad\@arinfo\hfill}\def\@oddfoot{\rm\hfil\thepage
\hfil}\let\@evenhead\@oddhead\let\@evenfoot\@oddfoot}
%
%%%
\def\jname#1{\gdef\@jname{#1}}
\def\jvol#1{\gdef\@jvol{#1}}
\def\jyear#1{\gdef\@jyear{#1}}
\def\ARinfo#1{\gdef\@arinfo{#1}}
\jname{}\jyear{}\jvol{}\ARinfo{}
%
\def\ps@myheadings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\thepage\hfil\slshape\leftmark}%
    \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
    }
\if@titlepage
  \newcommand\maketitle{\begin{titlepage}%
  \let\footnotesize\small
  \let\footnoterule\relax
  \null\vfil
  \vskip 60\p@
  \begin{center}%
    {\LARGE \@title \par}%
    \vskip 3em%
    {\large
     \lineskip .75em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
      \vskip 1.5em%
    {\large \@date \par}%       % Set date in \large size.
  \end{center}\par
  \@thanks
  \vfil\null
  \end{titlepage}%
  \setcounter{footnote}{0}%
  \let\thanks\relax\let\maketitle\relax
  \gdef\@thanks{}\gdef\@author{}\gdef\@title{}}
\else
\newcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\fnsymbol{footnote}}%
    \def\@makefnmark{\hbox to\z@{$\m@th^{\@thefnmark}$\hss}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hbox to1.8em{\hss$\m@th^{\@thefnmark}$}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{plain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \let\thanks\relax
  \let\maketitle\relax\let\@maketitle\relax
  \gdef\@thanks{}\gdef\@author{}\gdef\@title{}}
\def\@maketitle{%
\newpage\null\vskip2em
\begin{center}{\LARGE\bf\@title \par}\vskip2em
{\large\it\begin{tabular}[t]{@{}p{\textwidth}@{}}\@author\end{tabular}}\vskip2em
{\small\unvbox\keywordsbox\par}\end{center}\vskip 2em%
{\unvbox\abstractbox\par}
\tableofcontents}
\fi
\def\affiliation#1{\\{\raggedright\upshape\footnotesize#1\par}\\[6pt]}
\def\@keywords{}
\newbox\keywordsbox
\newenvironment{keywords}{%
  \global\setbox\keywordsbox\vbox\bgroup\footnotesize\noindent\@hangfrom{KEYWORDS:\ }}{%
		\egroup}
\def\@abstract{}
\newbox\abstractbox
\newenvironment{abstract}{\global\setbox\abstractbox\vbox\bgroup\parindent0pt\footnotesize
{\bf ABSTRACT:}\ \noindent}{\egroup}
\setcounter{secnumdepth}{3}
\newcounter {part}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand\thepart          {\Roman{part}}
\renewcommand\thesection       {\arabic{section}}
\renewcommand\thesubsection    {\thesection.\arabic{subsection}}
\renewcommand\thesubsubsection {\thesubsection .\arabic{subsubsection}}
\renewcommand\theparagraph     {\thesubsubsection.\arabic{paragraph}}
\renewcommand\thesubparagraph  {\theparagraph.\arabic{subparagraph}}
\newcommand\part{\par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}

\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \reset@font
     \ifnum \c@secnumdepth >\m@ne
       \Large\bfseries \partname~\thepart
       \par\nobreak
     \fi
     \huge \bfseries #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 3ex
    \@afterheading}
\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \reset@font
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}
\def\@endpart{\vfil\newpage
              \if@twoside
                \hbox{}%
                \thispagestyle{empty}%
                \newpage
              \fi
              \if@tempswa
                \twocolumn
              \fi}
\newcommand\section{\@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\reset@font\large\bfseries}}
\newcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\reset@font\large\it}}
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\reset@font\normalsize}}
\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\reset@font\normalsize\bfseries}}
\newcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                      {\reset@font\normalsize\bfseries}}
\if@twocolumn
  \setlength\leftmargini  {2em}
\else
  \setlength\leftmargini  {2.5em}
\fi
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\if@twocolumn
  \setlength\leftmarginv  {.5em}
  \setlength\leftmarginvi {.5em}
\else
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\fi
\setlength\leftmargin    {\leftmargini}
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\arabic{enumi}}
\renewcommand\theenumii{\alph{enumii}}
\renewcommand\theenumiii{\roman{enumiii}}
\renewcommand\theenumiv{\Alph{enumiv}}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{$\m@th\bullet$}
\newcommand\labelitemii{\normalfont\bfseries --}
\newcommand\labelitemiii{$\m@th\ast$}
\newcommand\labelitemiv{$\m@th\cdot$}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
\newenvironment{verse}
               {\let\\=\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item[]}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@}%
                \item[]}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item[]}
               {\endlist}
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \if@compatibility
        \setcounter{page}{0}
      \else
        \setcounter{page}{1}%
      \fi}%
    {\if@restonecol\twocolumn \else \newpage \fi
      \setcounter{page}{1}%
    }
\newcommand\appendix{\par
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \renewcommand\thesection{\Alph{section}}}
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand\theequation{\arabic{equation}}
\newcounter{figure}
\renewcommand\thefigure{\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}
\renewcommand\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1: #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1: #2\par
  \else
    \hbox to\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\gdef\cal{\protect\pcal}
\newcommand{\pcal}{\@fontswitch{\relax}{\mathcal}}
\gdef\mit{\protect\pmit}
\newcommand{\pmit}{\@fontswitch{\relax}{\mathnormal}}
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg {2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{2}
\newcommand\tableofcontents{%
    \par\addvspace{24pt plus3pt minus3pt}%
    \noindent{\normalsize\contentsname}%
    \vskip6pt
    \@starttoc{toc}}
\def\numberline#1{}
\newcommand\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{\@secpenalty}%
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \setlength\@tempdima{3em}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hbox to\@pnumwidth{\hss #2}}\par
       \nobreak
       \if@compatibility
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}
      \fi
    \endgroup
  \fi}
\newcommand\l@section[2]{%
  \ifnum \c@tocdepth >\z@
    \addpenalty{\@secpenalty}%
    \addvspace{1.0em \@plus\p@}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode\small
      #1\nobreak\leaders\hbox{$\m@th \mkern \@dotsep mu.\mkern \@dotsep
       mu$}\hfill \nobreak\hbox to\@pnumwidth{\hss #2}\par
    \endgroup
  \fi}
\newcommand\l@subsection[2]{%
  \ifnum \c@tocdepth > 1
    \addpenalty{\@secpenalty}%
    \setlength\@tempdima{14pt}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leftskip\@tempdima\footnotesize
      \leavevmode{\itshape#1}\nobreak\leaders\hbox{$\m@th \mkern \@dotsep mu.\mkern \@dotsep
       mu$}\hfill \nobreak\hbox to\@pnumwidth{\hss #2}\par
    \endgroup
  \fi}
%\newcommand\l@subsection   {\@dottedtocline{2}{1.5em}{2.3em}}
\newcommand\l@subsubsection{\@dottedtocline{3}{3.8em}{3.2em}}
\newcommand\l@paragraph    {\@dottedtocline{4}{7.0em}{4.1em}}
\newcommand\l@subparagraph {\@dottedtocline{5}{10em}{5em}}
\newcommand\listoffigures{%
    \section*{\listfigurename
      \@mkboth{\uppercase{\listfigurename}}%
              {\uppercase{\listfigurename}}}%
    \@starttoc{lof}%
    }
\newcommand\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand\listoftables{%
    \section*{\listtablename
      \@mkboth{\uppercase{\listtablename}}{\uppercase{\listtablename}}}%
    \@starttoc{lot}%
    }
\let\l@table\l@figure
%
%%% Begin cite.sty
\edef\citenum{% to restore funny codes
  \catcode\string`\string ` \the\catcode\string`\`
  \catcode\string`\string ' \the\catcode\string`\'
  \catcode\string`\string = \the\catcode\string`\=
  \catcode\string`\string _ \the\catcode\string`\_
  \catcode\string`\string : \the\catcode\string`\:}
\catcode\string`\`12
\catcode`\'12
\catcode`\=12
\catcode`\_8
\catcode`\:12

%   Handle optional variations:  [verbose,nospace,space,nosort,noadjust],
%   \citeform,\citeleft,\citeright,\citemid,\citepunct,\citedash
%
%   Set defaults:

%   [ on the left.
\@ifundefined{citeleft}{\let\citeleft=[}{}

%   ] on the right:
\@ifundefined{citeright}{\let\citeright=]}{}

%   , (comma space) before note
\@ifundefined{citemid}{\def\citemid{,\penalty\@medpenalty\ }}{}

%   , (comma thin-space) between entries; [nospace] eliminates the space
\@ifundefined{citepunct}{
   \def\citepunct{,\penalty\@m\hskip.13emplus.1emminus.1em}%
 }{}

%   -- (endash) designating range of numbers:
% (using \hbox avoids easy \exhyphenpenalty breaks)
\@ifundefined{citedash}{\def\citedash{\hbox{--}\penalty\@m }}{}

%   Each number left as-is:
\@ifundefined{citeform}{\def\citeform{}}{}

%   Do not repeat warnings.  [verbose] reverses
\let\oc@verbo\relax

\@ifundefined{DeclareOption}{}%
{ \toks@={\def\oc@verbo#1#2#3#4{}}
  \DeclareOption{verbose}{\the\toks@}
  \DeclareOption{nospace}{\def\citepunct{,\penalty\@m}}
  \DeclareOption{space}{\def\citepunct{,\penalty\@highpenalty\ }}
  \DeclareOption{nosort}{\def\@addto@cite@list
   {\edef\@cite@list{\@cite@list \@celt{\@B@citeB}}}}
  \DeclareOption{sort}{\let\@cite@list\relax}% default!
  \DeclareOption{noadjust}{\let\cite@adjust\@empty}% Don't change spaces
  \DeclareOption{adjust}{\let\cite@adjust\relax}% adjust space before [ ]
  %\ProvidesPackage{cite}[1999/04/23 \space  v 3.8]
  \ProcessOptions }

%----------------------
% \citen uses \@nocite to ignore spaces after commas, and write the aux file
% \citation. \citen then loops over the citation tags, using \@make@cite@list
% to make a sorted list of numbers.  Finally, \citen executes \@citelist to
% compress ranges of numbers and print the list. \citen can be used by itself
% to give citation numbers without the brackets and other formatting; e.g.,
% "See also ref.~\citen{junk}."
%
\edef\citen{\noexpand\protect \expandafter\noexpand\csname citen \endcsname}

\@namedef{citen }#1{%
\begingroup
\let\@safe@activesfalse\@empty
\@nocite{#1}% ignores spaces, writes to .aux file, returns #1 in \@no@sparg
\@tempcntb\m@ne    % \@tempcntb tracks highest number
\let\@h@ld\relax   % nothing held from list yet
\let\@citea\@empty % no punctuation preceding first
\let\@celt\delimiter % an unexpandable, but identifiable, token
\def\@cite@list{}% % empty list to start
\@for \@citeb:=\@no@sparg\do{\@make@cite@list}% make a sorted list of numbers
% After sorted citelist is made, execute it to compress citation ranges.
\@tempcnta\m@ne    % no previous number
\let\@celt\@compress@cite \@cite@list % output number list with compression
\@h@ld % output anything held over
\endgroup}

% For each citation, check if it is defined and if it is a number.
% if a number: insert it in the sorted \@cite@list
% otherwise: output it immediately.
%
\def\@make@cite@list{%
 \expandafter\let \expandafter\@B@citeB
          \csname b@\@citeb\@extra@b@citeb \endcsname
 \ifx\@B@citeB\relax % undefined: output ? and warning
    \@citea {\bf{?}}\let\@citea\citepunct \G@refundefinedtrue
    \@warning {Citation `\@citeb' on page \thepage\space undefined}%
    \oc@verbo \global\@namedef{b@\@citeb\@extra@b@citeb}{?}%
 \else %  defined               % remove previous line to repeat warnings
    \ifcat _\ifnum\z@<0\@B@citeB _\else A\fi % a positive number, put in list
       \@addto@cite@list
    \else % citation is not a number, output immediately
       \@citea \citeform{\@B@citeB}%
       \let\@citea\citepunct
 \fi\fi}

% Regular definition for adding entry to cite list, with sorting

\@ifundefined{@addto@cite@list}{% sort option either declared or defaulted
  \def\@addto@cite@list{\@tempcnta\@B@citeB \relax
     \ifnum \@tempcnta>\@tempcntb % new highest, add to end (efficiently)
        \edef\@cite@list{\@cite@list \@celt{\@B@citeB}}%
        \@tempcntb\@tempcnta
     \else % arbitrary number: insert appropriately
        \edef\@cite@list{\expandafter\@sort@celt \@cite@list \@gobble @}%
     \fi}
%
% \@sort@celt inserts number (\@tempcnta) into list of \@celt{num} (#1{#2})
% \@celt must not be expandable; list should end with two vanishing tokens.
%
  \def\@sort@celt#1#2{\ifx \@celt #1% parameters are \@celt {num}
       \ifnum #2<\@tempcnta % number goes later in list
          \@celt{#2}%
          \expandafter\expandafter\expandafter\@sort@celt % continue
       \else % number goes here
          \@celt{\number\@tempcnta}\@celt{#2}% stop comparing
    \fi\fi}
}% end sort option definitions
{}% nosort definition is done in options processing

% Check if each number follows previous and can be put in a range
%
\def\@compress@cite#1{%  % This is executed for each number
  \advance\@tempcnta\@ne % Now \@tempcnta is one more than the previous number
  \ifnum #1=\@tempcnta   % Number follows previous--hold on to it
     \ifx\@h@ld\relax    % first pair of successives
        \edef\@h@ld{\@citea \noexpand\citeform{#1}}%
     \else               % compressible list of successives
        \def\@h@ld{\citedash \citeform{#1}}%
     \fi
  \else   %  non-successor -- dump what's held and do this one
     \@h@ld \@citea \citeform{#1}\let\@h@ld\relax
  \fi \@tempcnta#1\let\@citea\citepunct
}

\edef\cite{\noexpand\protect\expandafter\noexpand\csname cite \endcsname}

\@namedef{cite }{\@ifnextchar [{\@tempswatrue\@citex}{\@tempswafalse\@citex[]}}

%  Make \@citex refer to \citen:
%
\def\@citex[#1]#2{\@cite{\citen{#2}}{#1}}%

%  Replacement for \@cite which defines the formatting normally done
%  around the citation list.  Minor changes can
%  be done by changing \citeleft, \citemid, and \citeright; but in other
%  cases it might be necessary to redefine the whole macro.
%
\def\@cite#1#2{\leavevmode \cite@adjust
  \citeleft{#1\if@tempswa \citemid #2\fi
  \spacefactor\@m % punctuation in note doesn't affect outside
  }\citeright}

%  Put a penalty before the citation, and adjust the spacing: if no space
%  already or if there is extra space due to some punctuation, then change
%  to one inter-word space.
%
\@ifundefined{cite@adjust}{\def\cite@adjust{%
  \@tempskipa\lastskip \edef\@tempa{\the\@tempskipa}\unskip
  \ifnum\lastpenalty=\z@ \penalty\@highpenalty \fi
  \ifx\@tempa\@zero@skip \spacefactor1001 \fi % if no space before, set flag
  \ifnum\spacefactor>\@m \ \else \hskip\@tempskipa \fi}}{}

\edef\@zero@skip{\the\z@skip}

% \nocite: This is changed to ignore *ALL* spaces and be robust.  The
% parameter list, with spaces removed, is `returned' in \@no@sparg, which
% is used by \citen.
%
\edef\nocite{\noexpand\protect\expandafter\noexpand\csname nocite \endcsname}

\@namedef{nocite }#1{\@bsphack \@nocite{#1}%
 \@for \@citeb:=\@no@sparg\do{\@ifundefined{b@\@citeb\@extra@b@citeb}%
    {\G@refundefinedtrue\@warning{Citation `\@citeb' undefined}%
    \oc@verbo \global\@namedef{b@\@citeb\@extra@b@citeb}{?}}{}}%
 \@esphack}

\def\@nocite#1{\xdef\@no@sparg{\@ignsp#1 \! }% remove *ALL* spaces
 \if@filesw \immediate\write\@auxout {\string\citation {\@no@sparg}}\fi}

% for ignoring *ALL* spaces in the input.  This presumes there are no
% \outer tokens and no \if-\fi constructs in the parameter.  Spaces inside
% braces are retained.
%
\def\@ignsp#1 {\ifx\!#1\@empty\else #1\expandafter\@ignsp\fi}

\let\nocitecount\relax  % in case \nocitecount was used for drftcite

\@ifundefined{@extra@b@citeb}{\def\@extra@b@citeb{}}{}
%  in case no fancy bib package (chapterbib) defines this

\@ifundefined{G@refundefinedtrue}{\let\G@refundefinedtrue\relax}{}

\citenum % execute restore-catcodes

% Aliases:
\let\citenum\citen
\let\citeonline\citen
%%%%% end cite.sty
\ifcitepar
	\def\@cite#1#2{{#1\if@tempswa , #2\fi}}
	\def\@biblabel#1{#1.}
	\newdimen\bibindent
	\bibindent=1.5em
	\newenvironment{thebibliography}[1]{%
				%\twocolumn
	   \footnotesize
	   \section*{\footnotesize\it Literature Cited}%
	   \def\@tempa{#1}%
	   \ifx\@tempa\@empty
	   \list{}{\def\@biblabel##1{##1}\labelwidth0pt\leftmargin1em\itemindent-1em\itemsep0pt\labelsep0pt
				\usecounter{enumiv}%
				\let\p@enumiv\@empty}%
	   \else
	   \list{\@biblabel{\arabic{enumiv}}}%
			   {\settowidth\labelwidth{\@biblabel{#1}}%
				\leftmargin\labelwidth\itemsep0pt
				\advance\leftmargin\labelsep
				\usecounter{enumiv}%
				\let\p@enumiv\@empty
				\renewcommand\theenumiv{\arabic{enumiv}}}%
	   \fi
		  \if@openbib
			\renewcommand\newblock{\par}
		  \else
			\renewcommand\newblock{\hskip .11em \@plus.33em \@minus.07em}%
		  \fi
		  \sloppy\clubpenalty4000\widowpenalty4000%
		  \sfcode`\.=\@m}
		 {\def\@noitemerr
		   {\@latex@warning{Empty `thebibliography' environment}}%
		  \endlist}
	\newcommand\newblock{}

	\def\@lbibitem[#1]#2{\item[\@biblabel{}\hfill]\if@filesw
		  {\let\protect\noexpand
		   \immediate
		   \write\@auxout{\string\bibcite{#2}{#1}}}\fi\ignorespaces}
\else
	\def\@cite#1#2{({#1\if@tempswa , #2\fi})}
	\def\@biblabel#1{#1.}
	\newdimen\bibindent
	\bibindent=1.5em
	\newenvironment{thebibliography}[1]{%
				%\twocolumn
	   \footnotesize
	   \section*{\footnotesize\it Literature Cited}%
	   \def\@tempa{#1}%
	   \ifx\@tempa\@empty
	   \list{}{\def\@biblabel##1{##1}\labelwidth0pt\leftmargin1em\itemindent-1em\itemsep0pt\labelsep0pt
				\usecounter{enumiv}%
				\let\p@enumiv\@empty}%
	   \else
	   \list{\@biblabel{\arabic{enumiv}}}%
			   {\settowidth\labelwidth{\@biblabel{#1}}%
				\leftmargin\labelwidth\itemsep0pt
				\advance\leftmargin\labelsep
				\usecounter{enumiv}%
				\let\p@enumiv\@empty
				\renewcommand\theenumiv{\arabic{enumiv}}}%
	   \fi
		  \if@openbib
			\renewcommand\newblock{\par}
		  \else
			\renewcommand\newblock{\hskip .11em \@plus.33em \@minus.07em}%
		  \fi
		  \sloppy\clubpenalty4000\widowpenalty4000%
		  \sfcode`\.=\@m}
		 {\def\@noitemerr
		   {\@latex@warning{Empty `thebibliography' environment}}%
		  \endlist}
	\newcommand\newblock{}

	\def\@lbibitem[#1]#2{\item[\@biblabel{}\hfill]\if@filesw
		  {\let\protect\noexpand
		   \immediate
		   \write\@auxout{\string\bibcite{#2}{#1}}}\fi\ignorespaces}
\fi
%%%%%
\newenvironment{theindex}
               {\if@twocolumn
                  \@restonecolfalse
                \else
                  \@restonecoltrue
                \fi
                \columnseprule \z@
                \columnsep 35\p@
                \twocolumn[\section*{\indexname}]%
                \@mkboth{\uppercase{\indexname}}%
                        {\uppercase{\indexname}}%
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \let\item\@idxitem}
               {\if@restonecol\onecolumn\else\clearpage\fi}
\newcommand\@idxitem  {\par\hangindent 40\p@}
\newcommand\subitem   {\par\hangindent 40\p@ \hspace*{20\p@}}
\newcommand\subsubitem{\par\hangindent 40\p@ \hspace*{30\p@}}
\newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule width .4\columnwidth
  \kern 2.6\p@}
\long\def\@makefntext#1{%
    \parindent 1em%
    \noindent
    \hbox to 1.8em{\hss\@makefnmark}#1}
\newcommand\contentsname{CONTENTS}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\refname{References}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract}
%%
\newenvironment{extract}{%
\par\leftskip1pc\rightskip1pc\small}{\par\leftskip0pc\rightskip0pc}
%
%%
\newcommand\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagestyle{myheadings}
\pagenumbering{arabic}      % Arabic page numbers
\raggedbottom
\newdimen\nomenspace\nomenspace=6pt
\newdimen\tempdima\newbox\tempbox
\def\nomenentry#1#2{%
\setbox\tempbox=\vbox{\hsize\tempdim\raggedright#2\endgraf}
\hbox to 20pc{\hbox to\tempdima{#1\hfill}=\hskip3pt\vtop{\hsize\tempdim\raggedright#2\endgraf%
\ifdim\ht\tempbox>1.5\baselineskip\vskip2pt\fi}}}
\def\nomensection#1{\vskip12pt\noindent{#1}\vskip6pt}
\newenvironment{nomenclature}[1]{%
\lineskip0pt\normallineskip0pt\setbox\tempbox=\hbox{#1}%
\tempdima\wd\tempbox\advance\tempdima\nomenspace\advance\tempdima6pt
\tempdim20pc\advance\tempdim-\tempdima\advance\tempdim-8pt
\section*{Nomenclature}}{\par\addvspace{12pt plus 6pt}}
%
\newbox\tempbox
\newenvironment{note}{%
\setbox\tempbox\vbox\bgroup\hsize\marginparwidth\raggedright
\noindent{\bf Note to Editor:}\\}{%
\egroup\marginpar{\box\tempbox}}
%
% \usepackage{ulem} -----> For AR CE'ing
% Added on 12th, Feb-2001
%
\def\revise#1#2{\sout{#1}\ {\bf#2}}
\def\urevise#1#2{\uline{#1}\ {\bf#2}}
\def\uurevise#1#2{\uuline{#1}\ {\bf#2}}
\def\uwrevise#1#2{\uwave{#1}\ {\bf#2}}
\def\xrevise#1#2{\xout{#1}\ {\bf#2}}
%
% Added on 22nd, Jan-2001
%
%\def\strikeout#1{$\setbox\z@\hbox{#1}\dp\z@\z@\m@th\raise2.5pt\hbox{\rlap{\vrule height.5pt width\wd\z@}}\hbox{\box\z@}$}
%\def\strikeout#1{\sout{#1}}
%
% Added on 1st, Jun-2001
\def\cfig#1{{#1}}
\def\url#1{{\tt#1}}
%
\if@twoside
\else
  \raggedbottom
\fi
\if@twocolumn
  \twocolumn
  \sloppy
  \flushbottom
\else
  \onecolumn
\fi
%%%%%%%%%%%%%
%%
%% This is file `natbib.sty',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% natbib.dtx  (with options: `package,all')
%% 
%% Full documentation can be obtained by LaTeXing the source file:
%%   natbib.dtx.
%% 
%% Only a few abbreviated comments remain here to describe the usage.
%% 
\NeedsTeXFormat{LaTeX2e}[1994/06/01]
%\ProvidesPackage{natbib}
%        [1998/02/19 6.8 (PWD)]
%%-------------------------------------------------------------------
%% NOTICE:
%% This file may be used for non-profit purposes.
%% It may not be distributed in exchange for money,
%%   other than distribution costs.
%%
%% The author provides it `as is' and does not guarantee it in any way.
%%
%% Natbib coding copyright (C) 1994--1998 Patrick W. Daly
%% Max-Planck-Institut f\"ur Aeronomie
%% Max-Planck-Str. 2
%% D-37191 Katlenburg-Lindau
%% Germany
%%
%% E-mail: daly@linmpi.mpg.de
%%-----------------------------------------------------------
 % This package reimplements the LaTeX \cite command to be used for various
 % citation styles, both author-year and numerical. It accepts BibTeX
 % output intended for many other packages, and therefore acts as a
 % general, all-purpose citation-style interface.
 %
 % With standard numerical .bst files, only numerical citations are
 % possible. With an author-year .bst file, both numerical and
 % author-year citations are possible.
 %
 % If author-year citations are selected, \bibitem must have one of the
 %   following forms:
 %   \bibitem[Jones et al.(1990)]{key}...
 %   \bibitem[Jones et al.(1990)Jones, Baker, and Williams]{key}...
 %   \bibitem[Jones et al., 1990]{key}...
 %   \bibitem[\protect\citeauthoryear{Jones, Baker, and Williams}{Jones
 %       et al.}{1990}]{key}...
 %   \bibitem[\protect\citeauthoryear{Jones et al.}{1990}]{key}...
 %   \bibitem[\protect\astroncite{Jones et al.}{1990}]{key}...
 %   \bibitem[\protect\citename{Jones et al., }1990]{key}...
 %   \harvarditem[Jones et al.]{Jones, Baker, and Williams}{1990}{key}...
 %
 % This is either to be made up manually, or to be generated by an
 % appropriate .bst file with BibTeX.
 %                            Author-year mode     ||   Numerical mode
 % Then, \citet{key}  ==>>  Jones et al. (1990)    ||   Jones et al. [21]
 %       \citep{key}  ==>> (Jones et al., 1990)    ||   [21]
 % Multiple citations as normal:
 % \citep{key1,key2}  ==>> (Jones et al., 1990; Smith, 1989) || [21,24]
 %                           or  (Jones et al., 1990, 1991)  || [21,24]
 %                           or  (Jones et al., 1990a,b)     || [21,24]
 % \cite{key} is the equivalent of \citet{key} in author-year mode
 %                         and  of \citep{key} in numerical mode
 % Full author lists may be forced with \citet* or \citep*, e.g.
 %       \citep*{key}      ==>> (Jones, Baker, and Williams, 1990)
 % Optional notes as:
 %   \citep[chap. 2]{key}    ==>> (Jones et al., 1990, chap. 2)
 %   \citep[e.g.,][]{key}    ==>> (e.g., Jones et al., 1990)
 %   \citep[see][pg. 34]{key}==>> (see Jones et al., 1990, pg. 34)
 %  (Note: in standard LaTeX, only one note is allowed, after the ref.
 %   Here, one note is like the standard, two make pre- and post-notes.)
 %   \citealt{key}          ==>> Jones et al. 1990
 %   \citealt*{key}         ==>> Jones, Baker, and Williams 1990
 %   \citealp{key}          ==>> Jones et al., 1990
 %   \citealp*{key}         ==>> Jones, Baker, and Williams, 1990
 % Additional citation possibilities (both author-year and numerical modes)
 %   \citeauthor{key}       ==>> Jones et al.
 %   \citeauthor*{key}      ==>> Jones, Baker, and Williams
 %   \citeyear{key}         ==>> 1990
 %   \citeyearpar{key}      ==>> (1990)
 %   \citetext{priv. comm.} ==>> (priv. comm.)
 % Note: full author lists depends on whether the bib style supports them;
 %       if not, the abbreviated list is printed even when full requested.
 %
 % Defining the citation style of a given bib style:
 % Use \bibpunct (in the preamble only) with 6 mandatory arguments:
 %    1. opening bracket for citation
 %    2. closing bracket
 %    3. citation separator (for multiple citations in one \cite)
 %    4. the letter n for numerical styles, s for superscripts
 %        else anything for author-year
 %    5. punctuation between authors and date
 %    6. punctuation between years (or numbers) when common authors missing
 %   One optional argument is the character coming before post-notes. It
 %   appears in square braces before all other arguments. May be left off.
 %   Example (and default) \bibpunct[,]{(}{)}{;}{a}{,}{,}
 %
 % To make this automatic for a given bib style, named newbib, say, make
 % a local configuration file, natbib.cfg, with the definition
 %   \newcommand{\bibstyle@newbib}{\bibpunct...}
 % Then the \bibliographystyle{newbib} will cause \bibstyle@newbib to
 % be called on THE NEXT LATEX RUN (via the aux file).
 %
 % Such preprogrammed definitions may be invoked in the text (preamble only)
 %  by calling \citestyle{newbib}. This is only useful if the style specified
 %  differs from that in \bibliographystyle.
 %
 % With \citeindextrue and \citeindexfalse, one can control whether the
 % \cite commands make an automatic entry of the citation in the .idx
 % indexing file. For this, \makeindex must also be given in the preamble.
 %
 % LaTeX2e Options: (for selecting punctuation)
 %   round  -  round parentheses are used (default)
 %   square -  square brackets are used   [option]
 %   curly  -  curly braces are used      {option}
 %   angle  -  angle brackets are used    <option>
 %   colon  -  multiple citations separated by colon (default)
 %   comma  -  separated by comma
 %   authoryear - selects author-year citations (default)
 %   numbers-  selects numerical citations
 %   super  -  numerical citations as superscripts
 %   sort   -  sorts multiple citations according to order in ref. list
 %   sort&compress   -  like sort, but also compresses numerical citations
 %   longnamesfirst  -  makes first citation full author list
 %   sectionbib - puts bibliography in a \section* instead of \chapter*
 % Punctuation so selected dominates over any predefined ones.
 % LaTeX2e options are called as, e.g.
 %        \usepackage[square,comma]{natbib}
 % LaTeX the source file natbib.dtx to obtain more details
 % or the file natnotes.tex for a brief reference sheet.
 %-----------------------------------------------------------
\@ifclassloaded{aguplus}{\PackageError{natbib}
  {The aguplus class already includes natbib coding,\MessageBreak
   so you should not add it explicitly}
  {Type <Return> for now, but then later remove\MessageBreak
   the command \protect\usepackage{natbib} from the document}
  \endinput}{}
\@ifclassloaded{nlinproc}{\PackageError{natbib}
  {The nlinproc class already includes natbib coding,\MessageBreak
   so you should not add it explicitly}
  {Type <Return> for now, but then later remove\MessageBreak
   the command \protect\usepackage{natbib} from the document}
  \endinput}{}
\@ifclassloaded{egs}{\PackageError{natbib}
  {The egs class already includes natbib coding,\MessageBreak
   so you should not add it explicitly}
  {Type <Return> for now, but then later remove\MessageBreak
   the command \protect\usepackage{natbib} from the document}
  \endinput}{}
 % Define citation punctuation for some author-year styles
 % One may add and delete at this point
 % Or put additions into local configuration file natbib.cfg
\newcommand\bibstyle@chicago{\bibpunct{(}{)}{;}{a}{,}{,}}
\newcommand\bibstyle@named{\bibpunct{[}{]}{;}{a}{,}{,}}
\newcommand\bibstyle@agu{\bibpunct{[}{]}{;}{a}{,}{,~}}%Amer. Geophys. Union
\newcommand\bibstyle@egs{\bibpunct{(}{)}{;}{a}{,}{,}}%Eur. Geophys. Soc.
\newcommand\bibstyle@agsm{\bibpunct{(}{)}{,}{a}{}{,}\gdef\harvardand{\&}}
\newcommand\bibstyle@kluwer{\bibpunct{(}{)}{,}{a}{}{,}\gdef\harvardand{\&}}
\newcommand\bibstyle@dcu{\bibpunct{(}{)}{;}{a}{;}{,}\gdef\harvardand{and}}
\newcommand\bibstyle@aa{\bibpunct{(}{)}{;}{a}{}{,}} %Astronomy & Astrophysics
\newcommand\bibstyle@pass{\bibpunct{(}{)}{;}{a}{,}{,}}%Planet. & Space Sci
\newcommand\bibstyle@anngeo{\bibpunct{(}{)}{;}{a}{,}{,}}%Annales Geophysicae
\newcommand\bibstyle@nlinproc{\bibpunct{(}{)}{;}{a}{,}{,}}%Nonlin.Proc.Geophys.
 % Define citation punctuation for some numerical styles
\newcommand\bibstyle@cospar{\bibpunct{/}{/}{,}{n}{}{}%
     \gdef\NAT@biblabelnum##1{##1.}}
\newcommand\bibstyle@esa{\bibpunct{(}{)}{,}{n}{}{}%
     \gdef\NAT@biblabelnum##1{##1.\hspace{1em}}%
     \gdef\NAT@citenum##1##2##3{\NAT@@open \if\relax##2\relax\else
       ##2\ \fi Ref.~##1\if\relax##3\relax\else\NAT@cmt\
       ##3\fi\NAT@@close\endgroup}}
\newcommand\bibstyle@nature{\bibpunct{}{}{,}{s}{}{\textsuperscript{,}}%
     \gdef\NAT@biblabelnum##1{##1.}}
 % The standard LaTeX styles
\newcommand\bibstyle@plain{\bibpunct{[}{]}{,}{n}{}{,}}
\let\bibstyle@alpha=\bibstyle@plain
\let\bibstyle@abbrv=\bibstyle@plain
\let\bibstyle@unsrt=\bibstyle@plain
 % The author-year modifications of the standard styles
\newcommand\bibstyle@plainnat{\bibpunct{[}{]}{,}{a}{,}{,}}
\let\bibstyle@abbrvnat=\bibstyle@plainnat
\let\bibstyle@unsrtnat=\bibstyle@plainnat
\newif\ifNAT@numbers \NAT@numbersfalse
\newif\ifNAT@super \NAT@superfalse
\DeclareOption{numbers}{\NAT@numberstrue
   \ExecuteOptions{square,comma,nobibstyle}}
\DeclareOption{super}{\NAT@supertrue\NAT@numberstrue
   \ExecuteOptions{nobibstyle}}
\DeclareOption{authoryear}{\NAT@numbersfalse
   \ExecuteOptions{round,colon,bibstyle}}
\DeclareOption{round}{%
      \renewcommand\NAT@open{(} \renewcommand\NAT@close{)}
   \ExecuteOptions{nobibstyle}}
\DeclareOption{square}{%
      \renewcommand\NAT@open{[} \renewcommand\NAT@close{]}
   \ExecuteOptions{nobibstyle}}
\DeclareOption{angle}{%
      \renewcommand\NAT@open{$<$} \renewcommand\NAT@close{$>$}
   \ExecuteOptions{nobibstyle}}
\DeclareOption{curly}{%
      \renewcommand\NAT@open{\{} \renewcommand\NAT@close{\}}
   \ExecuteOptions{nobibstyle}}
\DeclareOption{comma}{\renewcommand\NAT@sep{,}
   \ExecuteOptions{nobibstyle}}
\DeclareOption{colon}{\renewcommand\NAT@sep{;}
   \ExecuteOptions{nobibstyle}}
\DeclareOption{nobibstyle}{\let\bibstyle=\@gobble}
\DeclareOption{bibstyle}{\let\bibstyle=\@citestyle}
\newif\ifNAT@openbib \NAT@openbibfalse
\DeclareOption{openbib}{\NAT@openbibtrue}
\DeclareOption{sectionbib}{\def\NAT@sectionbib{on}}
\def\NAT@sort{0}
\DeclareOption{sort}{\def\NAT@sort{1}}
\DeclareOption{range}{\def\NAT@sort{2}}
\@ifpackageloaded{cite}{\PackageWarningNoLine{natbib}
  {The `cite' package should not be used\MessageBreak
   with natbib. Use option `sort' instead}\ExecuteOptions{sort}}{}
\newif\ifNAT@longnames\NAT@longnamesfalse
\DeclareOption{longnamesfirst}{\NAT@longnamestrue}
\renewcommand\bibstyle[1]{\@ifundefined{bibstyle@#1}{\relax}
     {\csname bibstyle@#1\endcsname}}
\AtBeginDocument{\global\let\bibstyle=\@gobble}
\let\@citestyle\bibstyle
\newcommand\citestyle[1]{\@citestyle{#1}\let\bibstyle\@gobble}
\@onlypreamble{\citestyle}\@onlypreamble{\@citestyle}
\newcommand\bibpunct[7][,]%
  {\gdef\NAT@open{#2}\gdef\NAT@close{#3}\gdef
   \NAT@sep{#4}\global\NAT@numbersfalse\ifx #5n\global\NAT@numberstrue
   \else
   \ifx #5s\global\NAT@numberstrue\global\NAT@supertrue
   \fi\fi
   \gdef\NAT@aysep{#6}\gdef\NAT@yrsep{#7}%
   \gdef\NAT@cmt{#1}%
   \global\let\bibstyle\@gobble
  }
\@onlypreamble{\bibpunct}
\newcommand\NAT@open{(} \newcommand\NAT@close{)}
\newcommand\NAT@sep{;}
\ProcessOptions
\newcommand\NAT@aysep{,} \newcommand\NAT@yrsep{,}
\newcommand\NAT@cmt{,}
\newcommand\NAT@cite%
    [3]{\ifNAT@swa\NAT@@open\if\relax#2\relax\else#2\ \fi
        #1\if\relax#3\relax\else\NAT@cmt\ #3\fi\NAT@@close\else#1\fi\endgroup}
\newcommand\NAT@citenum%
    [3]{\ifNAT@swa\NAT@@open\if\relax#2\relax\else#2\ \fi
        #1\if\relax#3\relax\else\NAT@cmt\ #3\fi\NAT@@close\else#1\fi\endgroup}
\newcommand\NAT@citesuper[3]{\ifNAT@swa
\unskip\hspace{1\p@}\textsuperscript{#1}%
   \if\relax#3\relax\else\ (#3)\fi\else #1\fi\endgroup}
\providecommand
  \textsuperscript[1]{\mbox{$^{\mbox{\scriptsize#1}}$}}
\providecommand\@firstofone[1]{#1}
\newcommand\NAT@citexnum{}
\def\NAT@citexnum[#1][#2]#3{%
 \NAT@sort@cites{#3}%
 \let\@citea\@empty
  \@cite{\def\NAT@num{-1}\let\NAT@last@yr\relax\let\NAT@nm\@empty
    \@for\@citeb:=\NAT@cite@list\do
    {\edef\@citeb{\expandafter\@firstofone\@citeb}%
     \if@filesw\immediate\write\@auxout{\string\citation{\@citeb}}\fi
     \@ifundefined{b@\@citeb\@extra@b@citeb}{%
       {\reset@font\bfseries?}
        \NAT@citeundefined\PackageWarning{natbib}%
       {Citation `\@citeb' on page \thepage \space undefined}}%
     {\let\NAT@last@num\NAT@num\let\NAT@last@nm\NAT@nm
      \NAT@parse{\@citeb}%
      \ifNAT@longnames\@ifundefined{bv@\@citeb\@extra@b@citeb}{%
        \let\NAT@name=\NAT@all@names
        \global\@namedef{bv@\@citeb\@extra@b@citeb}{}}{}%
      \fi
      \ifNAT@full\let\NAT@nm\NAT@all@names\else
        \let\NAT@nm\NAT@name\fi
      \ifNAT@swa
       \ifnum\NAT@ctype=2\relax\@citea
        \hyper@natlinkstart{\@citeb}\NAT@test{2}\hyper@natlinkend\else
       \ifnum\NAT@sort>1
         \begingroup\catcode`\_=8
            \ifcat _\ifnum\z@<0\NAT@num _\else A\fi
              \global\let\NAT@nm=\NAT@num \else \gdef\NAT@nm{-2}\fi
            \ifcat _\ifnum\z@<0\NAT@last@num _\else A\fi
              \global\@tempcnta=\NAT@last@num \global\advance\@tempcnta by\@ne
              \else \global\@tempcnta\m@ne\fi
         \endgroup
         \ifnum\NAT@nm=\@tempcnta
           \ifx\NAT@last@yr\relax
             \edef\NAT@last@yr{\@citea \mbox{\NAT@num}}%
           \else
             \edef\NAT@last@yr{--\penalty\@m\mbox{\NAT@num}}%
           \fi
         \else
           \NAT@last@yr \@citea \mbox{\NAT@num}%
           \let\NAT@last@yr\relax
         \fi
       \else
         \@citea \mbox{\hyper@natlinkstart{\@citeb}\NAT@num
                    \hyper@natlinkend}%
       \fi
       \fi
       \def\@citea{\NAT@sep\penalty\@m\NAT@space}%
      \else
        \ifcase\NAT@ctype\relax
          \ifx\NAT@last@nm\NAT@nm \NAT@yrsep\penalty\@m\NAT@space\else
          \@citea \NAT@test{1}\ \NAT@@open
          \if\relax#1\relax\else#1\ \fi\fi \NAT@mbox{%
          \hyper@natlinkstart{\@citeb}\NAT@num\hyper@natlinkend}%
          \def\@citea{\NAT@@close\NAT@sep\penalty\@m\ }%
        \or\@citea
          \hyper@natlinkstart{\@citeb}\NAT@test{1}\hyper@natlinkend
          \def\@citea{\NAT@sep\penalty\@m\ }%
        \or\@citea
          \hyper@natlinkstart{\@citeb}\NAT@test{2}\hyper@natlinkend
          \def\@citea{\NAT@sep\penalty\@m\ }%
        \fi
      \fi
      }}%
      \ifnum\NAT@sort>1\NAT@last@yr\fi
      \ifNAT@swa\else\ifnum\NAT@ctype=0\if\relax#2\relax\else
      \NAT@cmt\ #2\fi \NAT@@close\fi\fi}{#1}{#2}}
\newcommand\NAT@test[1]{\ifnum#1=1 \ifx\NAT@nm\NAT@noname
  {\reset@font\bfseries(author?)}\PackageWarning{natbib}
  {Author undefined for citation`\@citeb'
   \MessageBreak
   on page \thepage}\else \NAT@nm \fi
  \else \if\relax\NAT@date\relax
  {\reset@font\bfseries(year?)}\PackageWarning{natbib}
  {Year undefined for citation`\@citeb'
   \MessageBreak
   on page \thepage}\else \NAT@date \fi \fi}
\newcommand\NAT@citex{}
\def\NAT@citex%
  [#1][#2]#3{%
  \NAT@sort@cites{#3}%
  \let\@citea\@empty
  \@cite{\let\NAT@nm\@empty\let\NAT@year\@empty
    \@for\@citeb:=\NAT@cite@list\do
    {\edef\@citeb{\expandafter\@firstofone\@citeb}%
     \if@filesw\immediate\write\@auxout{\string\citation{\@citeb}}\fi
     \@ifundefined{b@\@citeb\@extra@b@citeb}{\@citea%
       {\reset@font\bfseries ?}\NAT@citeundefined
                 \PackageWarning{natbib}%
       {Citation `\@citeb' on page \thepage \space undefined}}%
     {\let\NAT@last@nm=\NAT@nm\let\NAT@last@yr=\NAT@year
     \NAT@parse{\@citeb}%
      \ifNAT@longnames\@ifundefined{bv@\@citeb\@extra@b@citeb}{%
        \let\NAT@name=\NAT@all@names
        \global\@namedef{bv@\@citeb\@extra@b@citeb}{}}{}%
      \fi
     \ifNAT@full\let\NAT@nm\NAT@all@names\else
       \let\NAT@nm\NAT@name\fi
     \ifNAT@swa\ifcase\NAT@ctype
       \ifx\NAT@last@nm\NAT@nm\NAT@yrsep
          \ifx\NAT@last@yr\NAT@year
            \hyper@natlinkstart{\@citeb}\NAT@exlab\hyper@natlinkend
          \else\unskip\
            \hyper@natlinkstart{\@citeb}\NAT@date\hyper@natlinkend
          \fi
       \else\@citea\hyper@natlinkstart{\@citeb}{\NAT@nm}\NAT@aysep
       \ \NAT@date\hyper@natlinkend \fi
       \or\@citea\hyper@natlinkstart{\@citeb}%
         {\NAT@nm}\hyper@natlinkend
       \or\@citea\hyper@natlinkstart{\@citeb}%
         \NAT@date\hyper@natlinkend\fi \def\@citea{\NAT@sep\ }%
     \else\ifcase\NAT@ctype
       \ifx\NAT@last@nm\NAT@nm\NAT@yrsep
          \ifx\NAT@last@yr\NAT@year
            \hyper@natlinkstart{\@citeb}\NAT@exlab\hyper@natlinkend
          \else\unskip\
            \hyper@natlinkstart{\@citeb}\NAT@date\hyper@natlinkend
          \fi
       \else\@citea\hyper@natlinkstart{\@citeb}%
         {\NAT@nm}\ \NAT@@open\if\relax#1\relax\else#1\ \fi
         \NAT@date\hyper@natlinkend\fi
       \or\@citea\hyper@natlinkstart{\@citeb}%
         {\NAT@nm}\hyper@natlinkend
       \or\@citea\hyper@natlinkstart{\@citeb}%
         \NAT@date\hyper@natlinkend\fi \def\@citea{\NAT@@close\NAT@sep\ }%
     \fi
     }}\ifNAT@swa\else\if\relax#2\relax\else\NAT@cmt\ #2\fi
     \NAT@@close\fi}{#1}{#2}}
\newif\ifNAT@par \NAT@partrue
\newcommand\NAT@@open{\ifNAT@par\NAT@open\fi}
\newcommand\NAT@@close{\ifNAT@par\NAT@close\fi}
\newcommand\shortcites[1]{%
  \@bsphack\@for\@citeb:=#1\do
  {\edef\@citeb{\expandafter\@firstofone\@citeb}%
   \global\@namedef{bv@\@citeb\@extra@b@citeb}{}}\@esphack}
\newcommand\NAT@biblabel[1]{\hfill}
\newcommand\NAT@biblabelnum[1]{[#1]}
\def\@tempa#1{[#1]}
\ifx\@tempa\@biblabel\let\@biblabel\@empty\fi
\newcommand\NAT@bibsetnum[1]{\settowidth\labelwidth{\@biblabel{#1}}%
   \setlength{\leftmargin}{\labelwidth}\addtolength{\leftmargin}{\labelsep}%
   \setlength{\itemsep}{\bibsep}\setlength{\parsep}{\z@}%
   \ifNAT@openbib
     \addtolength{\leftmargin}{\bibindent}%
     \setlength{\itemindent}{-\bibindent}%
     \setlength{\listparindent}{\itemindent}%
     \setlength{\parsep}{0pt}%
   \fi
}
\newlength{\bibhang}
\setlength{\bibhang}{1em}
\newlength{\bibsep}
{\@listi \global\bibsep\itemsep \global\advance\bibsep by\parsep}

\newcommand\NAT@bibsetup%
   [1]{\setlength{\leftmargin}{\bibhang}\setlength{\itemindent}{-\leftmargin}%
       \setlength{\itemsep}{\bibsep}\setlength{\parsep}{\z@}}
\newcommand\NAT@set@cites{\ifNAT@numbers
  \ifNAT@super \let\@cite\NAT@citesuper
     \def\NAT@mbox##1{\unskip\nobreak\hspace{1\p@}\textsuperscript{##1}}%
     \let\citeyearpar=\citeyear
     \let\NAT@space\relax\else
     \let\NAT@mbox=\mbox
     \let\@cite\NAT@citenum \def\NAT@space{ }\fi
  \let\@citex\NAT@citexnum
  \ifx\@biblabel\@empty\let\@biblabel\NAT@biblabelnum\fi
  \let\@bibsetup\NAT@bibsetnum
  \def\natexlab##1{}%
 \else
  \let\@cite\NAT@cite
  \let\@citex\NAT@citex
  \ifx\@biblabel\@empty\let\@biblabel\NAT@biblabel\fi
  \let\@bibsetup\NAT@bibsetup
  \def\natexlab##1{##1}%
 \fi}
\AtBeginDocument{\NAT@set@cites}
\AtBeginDocument{\ifx\SK@def\@undefined\else
\ifx\SK@cite\@empty\else
  \SK@def\@citex[#1][#2]#3{\SK@\SK@@ref{#3}\SK@@citex[#1][#2]{#3}}\fi
\ifx\SK@citeauthor\@undefined\def\HAR@checkdef{}\else
  \let\citeauthor\SK@citeauthor
  \let\citefullauthor\SK@citefullauthor
  \let\citeyear\SK@citeyear\fi
\fi}
\AtBeginDocument{\@ifpackageloaded{hyperref}{%
  \ifnum\NAT@sort=2\def\NAT@sort{1}\fi}{}}
\newif\ifNAT@full\NAT@fullfalse
\newif\ifNAT@swa
\DeclareRobustCommand\citet
   {\begingroup\NAT@swafalse\def\NAT@ctype{0}\NAT@partrue
     \@ifstar{\NAT@fulltrue\NAT@citetp}{\NAT@fullfalse\NAT@citetp}}
\newcommand\NAT@citetp{\@ifnextchar[{\NAT@@citetp}{\NAT@@citetp[]}}
\newcommand\NAT@@citetp{}
\def\NAT@@citetp[#1]{\@ifnextchar[{\@citex[#1]}{\@citex[][#1]}}
\DeclareRobustCommand\citep
   {\begingroup\NAT@swatrue\def\NAT@ctype{0}\NAT@partrue
         \@ifstar{\NAT@fulltrue\NAT@citetp}{\NAT@fullfalse\NAT@citetp}}
\DeclareRobustCommand\cite
    {\begingroup\def\NAT@ctype{0}\NAT@partrue\NAT@swatrue
      \@ifstar{\NAT@fulltrue\NAT@cites}{\NAT@fullfalse\NAT@cites}}
\newcommand\NAT@cites{\@ifnextchar [{\NAT@@citetp}{%
     \ifNAT@numbers\else
     \NAT@swafalse
     \fi
    \NAT@@citetp[]}}
\DeclareRobustCommand\citealt
   {\begingroup\NAT@swafalse\def\NAT@ctype{0}\NAT@parfalse
         \@ifstar{\NAT@fulltrue\NAT@citetp}{\NAT@fullfalse\NAT@citetp}}
\DeclareRobustCommand\citealp
   {\begingroup\NAT@swatrue\def\NAT@ctype{0}\NAT@parfalse
         \@ifstar{\NAT@fulltrue\NAT@citetp}{\NAT@fullfalse\NAT@citetp}}
\DeclareRobustCommand\citeauthor
   {\begingroup\NAT@swafalse\def\NAT@ctype{1}\NAT@parfalse
    \@ifstar{\NAT@fulltrue\NAT@citetp}{\NAT@fullfalse\NAT@citetp}}
\DeclareRobustCommand\citeyear
   {\begingroup\NAT@swafalse\def\NAT@ctype{2}\NAT@parfalse\NAT@citetp}
\DeclareRobustCommand\citeyearpar
   {\begingroup\NAT@swatrue\def\NAT@ctype{2}\NAT@partrue\NAT@citetp}
\newcommand\citetext[1]{\NAT@open#1\NAT@close}
\DeclareRobustCommand\citefullauthor
   {\citeauthor*}
\renewcommand\nocite[1]{\@bsphack
  \@for\@citeb:=#1\do{%
    \edef\@citeb{\expandafter\@firstofone\@citeb}%
    \if@filesw\immediate\write\@auxout{\string\citation{\@citeb}}\fi
    \if*\@citeb\else
    \@ifundefined{b@\@citeb\@extra@b@citeb}{%
       \NAT@citeundefined \PackageWarning{natbib}%
       {Citation `\@citeb' undefined}}{}\fi}%
  \@esphack}
\newcommand\NAT@parse[1]{{%
     \let\protect=\@unexpandable@protect\let~\relax
     \let\active@prefix=\@gobble
     \xdef\NAT@temp{\csname b@#1\@extra@b@citeb\endcsname}}%
     \expandafter\NAT@split\NAT@temp
     \expandafter\NAT@parse@date\NAT@date??????@@%
     \ifciteindex\NAT@index\fi
}
\newcommand\NAT@split[4]{%
  \gdef\NAT@num{#1}\gdef\NAT@name{#3}\gdef\NAT@date{#2}%
  \gdef\NAT@all@names{#4}%
  \ifx\NAT@noname\NAT@all@names \gdef\NAT@all@names{#3}\fi}
\newcommand\NAT@parse@date{}
\def\NAT@parse@date#1#2#3#4#5#6@@{%
  \ifnum\the\catcode`#1=11\def\NAT@year{}\def\NAT@exlab{#1}\else
  \ifnum\the\catcode`#2=11\def\NAT@year{#1}\def\NAT@exlab{#2}\else
  \ifnum\the\catcode`#3=11\def\NAT@year{#1#2}\def\NAT@exlab{#3}\else
  \ifnum\the\catcode`#4=11\def\NAT@year{#1#2#3}\def\NAT@exlab{#4}\else
    \def\NAT@year{#1#2#3#4}\def\NAT@exlab{{#5}}\fi\fi\fi\fi}
\newcommand\NAT@index{}
\let\NAT@makeindex=\makeindex
\renewcommand\makeindex{\NAT@makeindex
  \renewcommand\NAT@index{\@bsphack\begingroup
     \def~{\string~}\@wrindex{\NAT@idxtxt}}}
\newcommand\NAT@idxtxt{\NAT@name\ \NAT@open\NAT@date\NAT@close}
\newif\ifciteindex \citeindexfalse
\newcommand\citeindextype{default}
\newcommand\NAT@index@alt{{\let\protect=\noexpand\let~\relax
  \xdef\NAT@temp{\NAT@idxtxt}}\expandafter\NAT@exp\NAT@temp\@nil}
\newcommand\NAT@exp{}
\def\NAT@exp#1\@nil{\index[\citeindextype]{#1}}

\AtBeginDocument{%
\@ifpackageloaded{index}{\let\NAT@index=\NAT@index@alt}{}}
\newcommand\NAT@ifcmd{\futurelet\NAT@temp\NAT@ifxcmd}
\newcommand\NAT@ifxcmd{\ifx\NAT@temp\relax\else\expandafter\NAT@bare\fi}
\def\NAT@bare#1(#2)#3()#4\@nil#5{%
  \if\relax#2\relax
  \expandafter\NAT@apalk#1, , \@nil{#5}\else
  \stepcounter{NAT@ctr}%
  \NAT@wrout{\arabic {NAT@ctr}}{#2}{#1}{#3}{#5}
\fi
}
\newcommand\NAT@wrout[5]{%
\if@filesw
      {\let\protect\noexpand\let~\relax
       \immediate
       \write\@auxout{\string\bibcite{#5}{{#1}{#2}{{#3}}{{#4}}}}}\fi
\ignorespaces}
\def\NAT@noname{{}}
\renewcommand\bibitem{%
  \@ifnextchar[{\@lbibitem}{%
    \global\NAT@stdbsttrue
    \stepcounter{NAT@ctr}\@lbibitem[\arabic{NAT@ctr}]}}
\def\@lbibitem[#1]#2{%
   \@ifundefined{b@#2\@extra@b@citeb}{\def\NAT@num{}}{\NAT@parse{#2}}%
   \item[\hfil\hyper@natanchorstart{#2}\@biblabel{\NAT@num}%
    \hyper@natanchorend]%
    \NAT@ifcmd#1()()\@nil{#2}}
\ifx\SK@lbibitem\@undefined\else
   \let\SK@lbibitem\@lbibitem
   \def\@lbibitem[#1]#2{%
     \SK@lbibitem[#1]{#2}\SK@\SK@@label{#2}\ignorespaces}\fi
\newif\ifNAT@stdbst \NAT@stdbstfalse

\AtEndDocument
  {\ifNAT@stdbst\if@filesw\immediate\write\@auxout{\string
   \global\string\NAT@numberstrue}\fi\fi
  }
\providecommand\bibcite{}
\renewcommand\bibcite[2]{\@ifundefined{b@#1\@extra@binfo}\relax
     {\NAT@citemultiple
      \PackageWarningNoLine{natbib}{Citation `#1' multiply defined}}%
  \global\@namedef{b@#1\@extra@binfo}{#2}}
\AtEndDocument{\NAT@swatrue\renewcommand\bibcite[2]%
                         {\NAT@testdef{#1}{#2}}}
\newcommand\NAT@testdef[2]{%
  \def\NAT@temp{#2}\expandafter \ifx \csname b@#1\@extra@binfo\endcsname
    \NAT@temp \else \ifNAT@swa \NAT@swafalse
       \PackageWarningNoLine{natbib}{Citation(s) may have
          changed.\MessageBreak
          Rerun to get citations correct}\fi\fi}
\newcommand\NAT@apalk{}
\def\NAT@apalk#1, #2, #3\@nil#4{\if\relax#2\relax
  \global\NAT@stdbsttrue
  \NAT@wrout{#1}{}{}{}{#4}\else
  \stepcounter{NAT@ctr}%
  \NAT@wrout{\arabic {NAT@ctr}}{#2}{#1}{}{#4}\fi}
\newcommand\citeauthoryear{}
\def\citeauthoryear#1#2#3()()\@nil#4{\stepcounter{NAT@ctr}\if\relax#3\relax
   \NAT@wrout{\arabic {NAT@ctr}}{#2}{#1}{}{#4}\else
   \NAT@wrout{\arabic {NAT@ctr}}{#3}{#2}{#1}{#4}\fi}
\newcommand\citestarts{\NAT@open}
\newcommand\citeends{\NAT@close}
\newcommand\betweenauthors{and}
\newcommand\astroncite{}
\def\astroncite#1#2()()\@nil#3{\stepcounter{NAT@ctr}\NAT@wrout{\arabic
{NAT@ctr}}{#2}{#1}{}{#3}}
\newcommand\citename{}
\def\citename#1#2()()\@nil#3{\expandafter\NAT@apalk#1#2, \@nil{#3}}
\newcommand\harvarditem[4][]%
    {\if\relax#1\relax\bibitem[#2(#3)]{#4}\else
        \bibitem[#1(#3)#2]{#4}\fi }
\newcommand\harvardleft{\NAT@open}
\newcommand\harvardright{\NAT@close}
\newcommand\harvardyearleft{\NAT@open}
\newcommand\harvardyearright{\NAT@close}
\AtBeginDocument{\providecommand{\harvardand}{and}}
\newcommand\harvardurl[1]{\textbf{URL:} \textit{#1}}
\providecommand\bibsection{}
\@ifundefined{chapter}%
  {\renewcommand\bibsection{\section*{\refname
    \@mkboth{\MakeUppercase{\refname}}{\MakeUppercase{\refname}}}}}
  {\@ifundefined{NAT@sectionbib}%
    {\renewcommand\bibsection{\chapter*{\bibname
     \@mkboth{\MakeUppercase{\bibname}}{\MakeUppercase{\bibname}}}}}
    {\renewcommand\bibsection{\section*{\bibname
     \ifx\@mkboth\@gobbletwo\else\markright{\MakeUppercase{\bibname}}\fi}}}}
\@ifclassloaded{amsart}%
  {\renewcommand\bibsection{\section*{\refname}}{}}{}
\@ifclassloaded{amsbook}%
  {\renewcommand\bibsection{\section*{\bibname}}{}}{}
\@ifundefined{bib@heading}{}{\let\bibsection\bib@heading}
\newcounter{NAT@ctr}
\renewenvironment{thebibliography}[1]{%
	   \def\@tempa{#1}\bibfont\bibsection\parindent \z@%
	   \ifx\@tempa\@empty
	      \list{}{\def\@biblabel##1{}\labelwidth0pt\leftmargin1em\itemindent-1em\itemsep0pt\labelsep0pt
       \usecounter{enumiv}%
       \let\p@enumiv\@empty}%
    \else
       \list
       {\@biblabel{\arabic{NAT@ctr}}}{\@bibsetup{#1}%
       \setcounter{NAT@ctr}{0}}%
    \fi
    \ifNAT@openbib
      \renewcommand\newblock{\par}
    \else
      \renewcommand\newblock{\hskip .11em \@plus.33em \@minus.07em}%
    \fi
    \sloppy\clubpenalty4000\widowpenalty4000
    \sfcode`\.=1000\relax
    \let\citeN\cite \let\shortcite\cite
    \let\citeasnoun\cite
 }{\def\@noitemerr{%
  \PackageWarning{natbib}
     {Empty `thebibliography' environment}}%
  \endlist\vskip-\lastskip}
\let\bibfont=\relax
\providecommand\reset@font{\relax}
\providecommand\bibname{Bibliography}
\providecommand\refname{References}
\newcommand\NAT@citeundefined{\gdef \NAT@undefined {%
    \PackageWarningNoLine{natbib}{There were undefined citations}}}
\let \NAT@undefined \relax
\newcommand\NAT@citemultiple{\gdef \NAT@multiple {%
    \PackageWarningNoLine{natbib}{There were multiply defined citations}}}
\let \NAT@multiple \relax
\AtEndDocument{\NAT@undefined\NAT@multiple}
\providecommand\@mkboth[2]{}
\providecommand\MakeUppercase{\uppercase}
\providecommand{\@extra@b@citeb}{}
\gdef\@extra@binfo{}
\providecommand\hyper@natanchorstart[1]{}
\providecommand\hyper@natanchorend{}
\providecommand\hyper@natlinkstart[1]{}
\providecommand\hyper@natlinkend{}
\@ifpackageloaded{babel}{\PackageWarningNoLine{natbib}{%
If you use both babel and natbib\MessageBreak
then load babel AFTER natbib}}{}
\AtBeginDocument{\@ifpackageloaded{babel}{%
\bbl@redefine\@citex[#1][#2]#3{%
  \@safe@activestrue\org@@citex[#1][#2]{#3}\@safe@activesfalse}%
}{}}
\ifnum\NAT@sort>0
\newcommand\NAT@sort@cites[1]{%
\@tempcntb\m@ne
\let\@celt\delimiter
\def\NAT@num@list{}%
\def\NAT@cite@list{}%
\def\NAT@nonsort@list{}%
\@for \@citeb:=#1\do{\NAT@make@cite@list}%
\edef\NAT@cite@list{\NAT@cite@list\NAT@nonsort@list}%
\edef\NAT@cite@list{\expandafter\NAT@xcom\NAT@cite@list @@}}
\begingroup \catcode`\_=8
\gdef\NAT@make@cite@list{%
     \edef\@citeb{\expandafter\@firstofone\@citeb}%
    \@ifundefined{b@\@citeb\@extra@b@citeb}{\def\NAT@num{A}}%
    {\NAT@parse{\@citeb}}%
      \ifcat _\ifnum\z@<0\NAT@num _\else A\fi
       \@tempcnta\NAT@num \relax
       \ifnum \@tempcnta>\@tempcntb
          \edef\NAT@num@list{\NAT@num@list \@celt{\NAT@num}}%
          \edef\NAT@cite@list{\NAT@cite@list\@citeb,}%
          \@tempcntb\@tempcnta
       \else
          \let\NAT@@cite@list=\NAT@cite@list \def\NAT@cite@list{}%
          \edef\NAT@num@list{\expandafter\NAT@num@celt \NAT@num@list \@gobble @}%
          {\let\@celt=\NAT@celt\NAT@num@list}%
       \fi
    \else
       \edef\NAT@nonsort@list{\NAT@nonsort@list\@citeb,}%
 \fi}
\endgroup
\def\NAT@celt#1{\ifnum #1<\@tempcnta
  \xdef\NAT@cite@list{\NAT@cite@list\expandafter\NAT@nextc\NAT@@cite@list @@}%
  \xdef\NAT@@cite@list{\expandafter\NAT@restc\NAT@@cite@list}%
 \else
  \xdef\NAT@cite@list{\NAT@cite@list\@citeb,\NAT@@cite@list}\let\@celt\@gobble%
 \fi}
\def\NAT@num@celt#1#2{\ifx \@celt #1%
     \ifnum #2<\@tempcnta
        \@celt{#2}%
        \expandafter\expandafter\expandafter\NAT@num@celt
     \else
        \@celt{\number\@tempcnta}\@celt{#2}%
  \fi\fi}
\def\NAT@nextc#1,#2@@{#1,}
\def\NAT@restc#1,#2{#2}
\def\NAT@xcom#1,@@{#1}
\else
 \newcommand\NAT@sort@cites[1]{\edef\NAT@cite@list{#1}}\fi
\InputIfFileExists{natbib.cfg}
       {\typeout{Local config file natbib.cfg used}}{}
%% 
%% <<<<< End of decommented file <<<<<<
%%
%% End of file `natbib.sty'.
\bibpunct[]{(}{)}{,}{a}{}{,}
%%%%%%%%%%%%%
\endinput
%% 
%% End of file `areviews.cls'.
