% OXFORD UNIVERSITY PRESS
% LaTeX style file
% Name: LMS.STY
% Last updated: November 1994
% Version number: 2.0
% Copyright Oxford University Press 1994
% Authors: Ian Hall and Richard Preston



\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{lms}
               [1994/07/13 v1.2u
OUP LaTeX LMS2 class]
\RequirePackage{latexsym}
\typeout{Using LMS.sty Version 2.0 <1 November 1994>}

% ***************
% Error message *
% ***************
\def\@monog2error#1%
   {\errhelp{This is a standard LaTeX command, 
             but it isn't suitable in an OUP monograph.
             ^^JTry pressing return, and it'll probably be ignored.}%
    \typeout{Style error. \space See `Typesetting your book using LaTeX'.}%
    \errmessage{#1}}

% ****************************************
% Page dimensions, lineskips, type sizes *
% ****************************************
\pagenumbering{arabic} 
\lineskip 1pt \normallineskip 1pt
\def\baselinestretch{1}
	
\@twosidetrue 
\@mparswitchtrue 


\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}

\renewcommand\normalsize{\@setfontsize\normalsize\@xpt\@xiipt
	\abovedisplayskip 6pt minus 1pt
	\belowdisplayskip \abovedisplayskip
	\abovedisplayshortskip \z@ 
	\belowdisplayshortskip 6pt minus 1pt
	\let\@listi\@listI} 
\newcommand\small{\@setfontsize\small\@ixpt{10}%
	\abovedisplayskip 4pt minus1pt
	\belowdisplayskip\abovedisplayskip
	\abovedisplayshortskip \z@
	\belowdisplayshortskip 4pt minus1pt
	\def\@listi{\parsep \z@
	\itemsep\z@
	\topsep 3pt minus 1pt}}
\newcommand\footnotesize{\@setfontsize\footnotesize\@viiipt{9}%
	\abovedisplayskip 2pt minus1pt
	\belowdisplayskip \abovedisplayskip
	\abovedisplayshortskip \z@ 
	\belowdisplayshortskip 2pt minus1pt
	\def\@listi{\leftmargin\leftmargini
	\topsep 3pt minus 1pt
	\parsep \z@
	\itemsep\z@}}
\def\scriptsize{\@setsize\scriptsize{9pt}\viiipt\@viiipt}
\def\tiny{\@setsize\tiny{7pt}\vipt\@vipt}
\def\large{\@setsize\large{14pt}\xiipt\@xiipt}   % B
\def\Large{\@setsize\Large{16pt}\xivpt\@xivpt}   % A
\def\LARGE{\@setsize\LARGE{20pt}\xviipt\@xviipt} % Chap
\def\huge{\@setsize\huge{30pt}\xxvpt\@xxvpt}
\let\Huge=\huge
\normalsize 
\def\sl{\it}
\def\em{\it}
%\font\upright=cmb10

\oddsidemargin  59pt   % Left margin on odd-numbered pages
\evensidemargin 59pt   % Left margin on even-numbered pages
\marginparwidth 85pt   %
\marginparsep 10pt

\topmargin 27pt \headheight 8pt 
\headsep 12pt \footskip 30pt \topskip 10pt

\textheight = 44\baselineskip    % 45 lines on a full page of text
\advance\textheight by \topskip  %
\textwidth 29pc                  %
\columnsep 2 pc \columnseprule 0pt

\footnotesep 8.4pt 
\skip\footins 10.8pt plus 4pt minus 2pt 
\marginparpush 7pt 

\parskip 0pt % No stretching between paragraphs
\parindent 1.5em \partopsep 3pt plus 2pt minus 2pt
\@lowpenalty 51 \@medpenalty 151 \@highpenalty 301 
\@beginparpenalty -\@lowpenalty
\@endparpenalty -\@lowpenalty
\@itempenalty -\@lowpenalty 
\clubpenalty\@M
\widowpenalty\@M
\displaywidowpenalty\@M
\predisplaypenalty\@M
\postdisplaypenalty 500
\interlinepenalty 0
\brokenpenalty 2000

% **********************
% The author's options *
% **********************
\def\@ptsize{0}
\@namedef{ds@11pt}{\@monog2error{Monographs have to be 10pt}}
\@namedef{ds@12pt}{\@monog2error{Monographs have to be 10pt}}
\def\ds@twoside{}
\def\ds@draft{\overfullrule 5pt}
\@options
\relax

% *********************
% Sectioning commands *
% *********************

% Counters
\newcounter{part}
\newcounter{chapter}
\newcounter{section}[chapter]
\newcounter{subsection}[section]
\newcounter{subsubsection}[subsection]
\newcounter{paragraph}[subsubsection]
\newcounter{subparagraph}[paragraph]
\setcounter{topnumber}{1}
\setcounter{bottomnumber}{1}

% Form of the numbers
\def\thepart{\Roman{part}}
\def\thechapter{\arabic{chapter}}
\def\thesection{\ifnum\c@section < \@ne\relax\thechapter
	\else \thechapter.\arabic{section}\fi}
\def\thesubsection{\thesection.\arabic{subsection}}
\def\thesubsubsection{\thesubsection.\arabic{subsubsection}}
\def\theparagraph{\thesubsubsection.\arabic{paragraph}}
\def\thesubparagraph{\theparagraph.\arabic{subparagraph}}
\def\@chapapp{Chapter}
%	
% Section macros. 
% NB Font size and style for
% Section numbers is defined explicitly in
% \thesection, \thesubsection, etc.
%
\def\part{\cleardoublepage
	\thispagestyle{empty}
  	\if@twocolumn
     		\onecolumn
	     	\@tempswatrue
     		\else \@tempswafalse
  	\fi
	\secdef\@part\@spart}
\def\@part[#1]#2{\ifnum \c@secnumdepth >-2 \relax
       	\refstepcounter{part}
	\addcontentsline{toc}{part}{\thepart%
	\hspace{1em}#1}\else
 	\addcontentsline{toc}{part}{#1}\fi
	\markboth{}{}
	{\centering
	\ifnum \c@secnumdepth >-2 \relax
	\huge Part \thepart
	\par \addvspace{18pt} \fi
	\Huge #2 \par} \@endpart}
\def\@endpart{\vfil\newpage
	\if@twoside
	\null
	\thispagestyle{empty}
	\newpage
	\fi
	\if@tempswa
	\twocolumn
	\fi}
\def\@spart#1{{\centering
	\Huge #1\par} \@endpart}
\def\chapter{\clearpage \setcounter{equation}{0}
	\thispagestyle{empty} \global\@topnum\z@
	\@afterindentfalse \secdef\@chapter\@schapter} 
\def\@chapter[#1]#2{\ifnum \c@secnumdepth >\m@ne
	\refstepcounter{chapter}
	\typeout{\@chapapp\space\thechapter.}
	\addcontentsline{toc}{chapter}{\protect
	\numberline{\thechapter}#1}\else
	\addcontentsline{toc}{chapter}{#1}\fi
	\chaptermark{#1}
	\if@twocolumn
	\@topnewpage[\@makechapterhead{#2}] 
	\else \@makechapterhead{#2}
	\@afterheading \fi} 
\def\@schapter#1{\if@twocolumn \@topnewpage[\@makeschapterhead{#1}]
	\else \@makeschapterhead{#1} \chaptermark{#1}
	\@afterheading\fi}
\def\@makechapterhead#1{%
	\null\vskip 24pt
	\begin{flushleft}
	\LARGE\ifappend Appendix\ \fi
	\bf\thechapter\\[6pt]
	{\LARGE\bf #1}\\[6pt]
	\rule{\textwidth}{1pt}
	\end{flushleft}
	\vskip 12pt}
\def\@makeschapterhead#1{%
	\null\vskip 24pt
	\begin{flushleft}
		{\LARGE\bf #1}\\[6pt]
	\rule{\textwidth}{1pt}
	\end{flushleft}
	\vskip 12pt}
\def\section{\secdef\@section\@ssection}
\def\@ssection#1{\@startsection{section}{2}{\z@}
	{-12pt plus -1ex minus -3pt}{4pt minus1pt}{\small\rm}*{\uppercase{#1}}}
\def\@section{\@ifnextchar[{\@secopt}{\@secnoopt}}
\def\@secnoopt#1{\@startsection{section}{2}{\z@}
	{-12pt plus -1ex minus -3pt}{4pt minus1pt}{\rm}[#1]{\small\uppercase{#1}}}
\def\@secopt[#1]#2{\@startsection{section}{2}{\z@}
	{-12pt plus -1ex minus -3pt}{4pt minus1pt}{\rm}[#1]{\small\uppercase{#2}}}
\def\subsection{\@startsection{subsection}{2}{\z@}
	{-2ex plus -.1ex minus -.1ex}{5pt}
	{\normalsize\bf}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}
	{-1.5ex plus -.1ex minus -.1ex}{3pt}
	{\normalsize\it}}
\def\paragraph{\@startsection
	{paragraph}{4}{\z@}{12pt}{-1em}{\normalsize\it}}
\def\subparagraph{\@startsection
	{subparagraph}{4}{\parindent}{1ex}{-1em}{\normalsize\it} \hskip 12pt}
\setcounter{secnumdepth}{3}

% *******************
% Running headlines *
% *******************
\mark{{}{}} 
\def\@leftmark#1#2{#1}
\def\@rightmark#1#2{#2}
\def\ps@headings
	{\let\@mkboth\markboth
	\def\@oddfoot{}%
	\def\@evenfoot{}%
	\def\@evenhead{\rm\thepage\hfil\it\leftmark}
	\def\@oddhead{\it\rightmark\hfil\rm\thepage}%
	\global\def\sectionmark##1{\markright{##1}}%
	\global\def\chaptermark##1{\@mkboth{##1}{##1}}%
	\def\subsectionmark##1{}}
	         
\def\ps@myheadings
	  {\@monog2error{The page style `myheadings' is not available}}

% ********************
% Figures and tables *
% ********************
% \@caption redefined so entries in Table of figs and tables
% appear as Table 1.1 [Caption] etc, rather than 1.1 [Caption]
\long\def\@caption#1[#2]#3{\par\addcontentsline{\csname ext@#1\endcsname}
	{#1}{\protect\numberline{\bf\csname fnum@#1\endcsname}
	{\ignorespaces #2}}
	\begingroup
	\@parboxrestore
	\normalsize
	\@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
	\endgroup}

\long\def\@makecaption#1#2{%
	\rightskip 0pt plus -1fil% 	To give centred
	\leftskip 0pt plus 1fil%	last line to
	\parfillskip 0pt plus 2fil%	paragraph
	\vskip 6pt 
	\setbox\@tempboxa\hbox{\small\bf #1.\enspace\rm #2}
	\ifdim \wd\@tempboxa >\hsize 
		\unhbox\@tempboxa\par
		\else
		\hbox to\hsize{\hfil\box\@tempboxa\hfil} 
	\fi}

\long\def\@tablecaption#1#2{%
	\rightskip 0pt plus -1fil
	\leftskip 0pt plus 1fil
	\parfillskip 0pt plus 2fil
	\setbox\@tempboxa\hbox{\bf #1\enspace\rm #2}
	\ifdim \wd\@tempboxa>\hsize
		\unhbox\@tempboxa\par
		\else
		\hbox to\hsize{\hfil\box\@tempboxa\hfil}
	\fi\vskip 6pt}

% \tableparts definition
\newbox\@tempboxb
\def\tableparts#1#2{% title, tabular environment
	\hbox to\linewidth{\hss\vbox{%
	\setbox\@tempboxb\hbox{#2}\hsize\wd\@tempboxb 
	\ifdim\hsize<3in \hsize=3in \relax \fi \linewidth=\hsize
	#1\par
	\hfil\box\@tempboxb\hfil
	}\hss}}

\newcounter{figure}[chapter]
\def\thefigure{\thechapter.\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{Fig.\ \thefigure}
\def\figure{\@float{figure}}
\let\endfigure\end@float
\@namedef{figure*}{\@dblfloat{figure}}
\@namedef{endfigure*}{\end@dblfloat}
\newcounter{table}[chapter]
\def\thetable{\thechapter.\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{Table\ \thetable}
\def\table{\let\@makecaption\@tablecaption\@float{table}}
\let\endtable\end@float
\@namedef{table*}{\@dblfloat{table}}
\@namedef{endtable*}{\end@dblfloat}

% *******************************************
% Modifications to the equation environment *
% *******************************************
\@addtoreset{equation}{section}
\def\theequation{\thesection.\arabic{equation}}
\arraycolsep 1.5pt \tabcolsep 6pt \arrayrulewidth .4pt \doublerulesep 2pt 
\tabbingsep\labelsep 

% *******************************
% New theorem-like environments *
% *******************************
%%% RmS 91/08/14 Moved \it after \item to make it work with NFSS

\def\exampleenvir{example}
\def\notesenvir{notes}
\def\Notes{Notes}
\def\Example{Example}
\def\theoremfont{\ifx\@currenvir\exampleenvir
	\def\theoremf@nt{\rm}\else
	\ifx\@currenvir\notesenvir
	\def\theoremf@nt{\rm}\else
	\def\theoremf@nt{\it}\fi\fi
	}
\def\@endtheorem{\endtrivlist}
\@addtoreset{definition}{chapter}
\newtheorem{definition}{Definition}[section]
\newtheorem{theorem}[definition]{Theorem}
\newtheorem{lemma}[definition]{Lemma}
\newtheorem{example}[definition]{Example}
\newtheorem{proposition}[definition]{Proposition}
\newtheorem{corollary}[definition]{Corollary}
\newtheorem{notes}[definition]{Notes}
\newtheorem{remark}[definition]{Remark}
\def\@begintheorem#1#2{\theoremfont\trivlist 
	\item[\hskip \labelsep{\bf #1\ #2}]\theoremf@nt}
\def\@opargbegintheorem#1#2#3{\theoremfont\trivlist
	\item[\hskip \labelsep{\bf #1\ #2\ (#3)}]\theoremf@nt}
\def\enunciation#1{\def\testchar{#1}
	\ifx\testchar\Notes\def\theoremf@nt{\rm}\else
	\ifx\testchar\Example\def\theoremf@nt{\rm}\else
	\def\theoremf@nt{\it}\fi\fi
	\stepcounter{definition}\trivlist 
	\item[\hskip\labelsep{\bf #1\ \thedefinition}]\theoremf@nt}
\def\endenunciation{\endproof}
\def\followon#1{\trivlist \item[\hskip\labelsep{\bf #1\ }]}
\def\endfollowon{\endtrivlist}
\def\bull{$\Box$}
\def\endmark{\hskip 2em\bull\par}
\def\proof{\trivlist \item[\hskip\labelsep{\bf Proof\ }]}

\def\endproof{\null\hfill\endmark\endtrivlist}

%Changed by JC Wood to get endmark always on right-hand margin:

%\def\endproof{\null\hspace*{\fill}\endmark\endtrivlist}

%NOw incorporated in m file

% ******************************
% List numbering and lettering *
% ******************************
\def\labelenumi{{\rm\arabic{enumi}.}}
\def\theenumi{\arabic{enumi}} 
\def\labelenumii{{\rm (\alph{enumii})}}
\def\theenumii{\alph{enumii}}
\def\p@enumii{\theenumi}
\def\labelenumiii{{\rm\roman{enumiii}.}}
\def\theenumiii{\roman{enumiii}}
\def\p@enumiii{\theenumi(\theenumii)}
\def\labelenumiv{{\rm\Alph{enumiv}.}}
\def\theenumiv{\Alph{enumiv}} 
\def\p@enumiv{\p@enumiii\theenumiii}

\def\labelitemi{$\bullet$}
\def\labelitemiv{\bf --}
\def\labelitemii{$\ast$}
\def\labelitemiii{$\circ$}
	
\def\descriptionlabel#1{\hspace\labelsep \bf #1}
\def\description{\list{}{\labelwidth\z@ \itemindent-\leftmargin
	 \let\makelabel\descriptionlabel}}
\let\enddescription\endlist

\leftmargini 2em
\leftmarginii 2.2em\leftmarginiii 1.87em\leftmarginiv 1.7em
\leftmarginv 1em
\leftmarginvi 1em
\leftmargin\leftmargini
\labelsep .5em
\labelwidth 1em
\advance\labelwidth-\labelsep
\def\@listI{\leftmargin\leftmargini 
	\parsep 0pt plus 1pt\listparindent 1.5em
	\topsep 3pt plus .5pt\itemsep\z@}
\let\@listi\@listI
\@listi 
\def\@listii{\leftmargin\leftmarginii
	\labelwidth\leftmarginii\advance\labelwidth-\labelsep
	\topsep 1pt plus .5pt
	\parsep \z@
	\itemsep\z@}
\def\@listiii{\leftmargin\leftmarginiii
	\labelwidth\leftmarginiii\advance\labelwidth-\labelsep
	\topsep 1pt plus .5pt
	\parsep \z@
	\partopsep 1pt plus 0pt minus 1pt
	\itemsep\z@}
\def\@listiv{\leftmargin\leftmarginiv
	 \labelwidth\leftmarginiv\advance\labelwidth-\labelsep}
\def\@listv{\leftmargin\leftmarginv
	 \labelwidth\leftmarginv\advance\labelwidth-\labelsep}
\def\@listvi{\leftmargin\leftmarginvi
	 \labelwidth\leftmarginvi\advance\labelwidth-\labelsep}

% ******************************************
% Verse, quotation, and quote environments *
% ******************************************
\def\verse{\let\\=\@centercr 
	\list{}{\itemsep\z@ \itemindent -1.5em\listparindent \itemindent 
	\rightmargin\leftmargin\advance\leftmargin 1.5em}\item[]}
\let\endverse\endlist
\def\quotation{\small\list{}{%  Quotations in small type
	\topsep 3pt      %
	\leftmargin 0pt  % Quotations use the full text width
	\listparindent 1.5em % After first paragraph, indent
	\itemindent 0pt
	\rightmargin\leftmargin \parsep 0pt}\item[]}
\let\endquotation=\endlist
\def\quote{\small\list{}{% Quotes in small type
	\topsep 3pt
	\leftmargin 0pt % Quotes use the full text width
	\listparindent 1.5em
	\parsep 0pt     % Paragraphs separated by space, not indented
	\rightmargin\leftmargin}\item[]}
\let\endquote=\endlist

\skip\@mpfootins = \skip\footins
\fboxsep = 3pt \fboxrule = .4pt 

% *******************
% Table of contents *
% *******************
\def\numberline#1{\advance\hangindent\@tempdima\hbox
		to\@tempdima{#1\hfil}\ignorespaces}
\def\@pnumwidth{5em}
\def\@tocrmarg{2.55em}
\def\@dotsep{4.5}
\setcounter{tocdepth}{4}
\def\tableofcontents{
	\chapter*{Contents}
	\@starttoc{toc}}
\def\l@part#1#2{\addpenalty{-\@highpenalty}
	\addvspace{2.25em}
	\begingroup\@tempdima 2em
	\parindent \z@ \rightskip \@pnumwidth
	\parfillskip -\@pnumwidth
	\leavevmode\large \sc
	\hfil #1 \hfil \null\par
	\nobreak\global\@nobreaktrue
	\everypar{\global\@nobreakfalse\everypar{}}
	\endgroup}
\def\l@chapter#1#2{\addpenalty{\@secpenalty}
	\addvspace{2ex plus 1pt}
	\begingroup\@tempdima 2.25em 
	\parindent \z@ \rightskip \@pnumwidth
	\parfillskip -\@pnumwidth 
	\leavevmode\bf #1\hfil\hbox to\@pnumwidth{\hss \rm #2}\par
	\endgroup}
\def\l@section#1#2{\ifnum\c@tocdepth<3%
	\relax\else\addpenalty{\@secpenalty}
	\begingroup\@tempdima 3em 
	\parindent \z@ \rightskip \@pnumwidth
	\leftskip 2.25em\parfillskip -\@pnumwidth 
	\leavevmode\rm #1\hfil\hbox to\@pnumwidth{\hss #2}\par
	\endgroup\fi}
\def\l@subsection#1#2{\ifnum\c@tocdepth<4%
	\relax\else\addpenalty{\@secpenalty}
	\begingroup\@tempdima 3.25em 
	\parindent \z@ \rightskip \@pnumwidth
	\leftskip 5.25em
	\parfillskip -\@pnumwidth \labelsep 1em
	\leavevmode\rm #1\hfil\hbox to\@pnumwidth{\hss #2}\par
	\endgroup\fi}
\def\l@subsubsection#1#2{\relax}%	%Subsubsection and below
\def\l@paragraph#1#2{\relax}%		%should not appear in the
\def\l@subparagraph#1#2{\relax}%	%Contents list
\def\listoffigures{
	\chapter*{Figures}
	\@starttoc{lof}}
\def\l@figure#1#2{\addpenalty{\@secpenalty}
	\addvspace{1.0ex plus 1pt}
	\begingroup\@tempdima 5em 
	\parindent \z@ \rightskip \@pnumwidth
	\parfillskip -\@pnumwidth
	\leavevmode \small #1\hfil \hbox to\@pnumwidth{\hss #2}\par
	\endgroup}

% ****************
% List of Tables *
% ****************
\def\listoftables{
	\chapter*{Tables}
	\@starttoc{lot}}
\def\l@table#1#2{\addpenalty{\@secpenalty}
	\addvspace{1.0ex plus 1pt}
	\begingroup\@tempdima 5em 
	\parindent \z@ \rightskip \@pnumwidth
	\parfillskip -\@pnumwidth
	\leavevmode\small #1\hfil\hbox to\@pnumwidth{\hss #2}\par
	\endgroup}

\def\thebibliography#1 {\begingroup\section*{References}
 \list{}{\leftmargin 2em
 \itemindent -\leftmargin
 \labelwidth 0pt
 \labelsep 1pc
 \itemsep 6pt}
\def\newblock{\hskip .11em plus .33em minus -.07em}
 \sloppy\clubpenalty4000\widowpenalty4000
 \sfcode`\.=1000\relax}
\let\endlist\endgroup
\let\endthebibliography=\endlist


% *******
% Index *
% *******
\newif\if@restonecol
\def\theindex{\@restonecoltrue\if@twocolumn\@restonecolfalse\fi
	\columnseprule \z@
	\columnsep 35pt\twocolumn
 	\chapter*{Index}
 	\@mkboth{Index}{Index}\parindent\z@
 	\parskip\z@ plus .3pt\relax\let\item\@idxitem}
\def\@idxitem{\par\hangindent 40pt}
\def\subitem{\par\hangindent 40pt \hspace*{20pt}}
\def\subsubitem{\par\hangindent 40pt \hspace*{30pt}}
\def\endtheindex{\if@restonecol\onecolumn\else\clearpage\fi}
\def\indexspace{\par\vskip 10pt plus 5pt minus 3pt\relax}
	
% ***********
% Footnotes *
% ***********
\def\footnoterule{\kern-3\p@ 
	\hrule width .4\columnwidth height\z@
 	\kern2.6\p@} 
% Reset the footnote counter for each page
\@addtoreset{footnote}{page}
% Footnotes to use *, + etc.
\def\@makefnmark{\hbox{$^{\fnsymbol{footnote}}$}}
	\long\def\@makefntext#1{\parindent 1em\noindent
	\hbox to 1.8em{\hss$^{\fnsymbol{footnote}}$}#1}

% ********
% Floats *
% ********
\floatsep 18pt
\textfloatsep 12pt
\intextsep 12pt
%\@maxsep 18pt
\dblfloatsep 18pt
\dbltextfloatsep 12pt
%\@dblmaxsep 12pt 
\@fptop 0pt plus 1fil
\@fpsep 10pt plus 2fil
\@fpbot 0pt plus 1fil 
\@dblfptop 0pt plus 1fil
\@dblfpsep 10pt plus 2fil
\@dblfpbot 0pt plus 1fil
\setcounter{topnumber}{2}
\def\topfraction{.9}
\setcounter{bottomnumber}{2}
\def\bottomfraction{.9}
\setcounter{totalnumber}{3}
\def\textfraction{.1}
\def\floatpagefraction{.9}
\setcounter{dbltopnumber}{2}
\def\dbltopfraction{.9}
\def\dblfloatpagefraction{.9}
	
% ************
% Title page *
% ************
% (not needed in final printing)
\def\titlepage{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
	\else \newpage \fi \thispagestyle{empty}\c@page\z@}
\def\endtitlepage{\if@restonecol\twocolumn \else \newpage \fi}
	
\def\maketitle{\par
	\begingroup
\def\thefootnote{\fnsymbol{footnote}}
\def\@makefnmark{\hbox to 0pt{$^{\@thefnmark}$\hss}} 
	\if@twocolumn 
	\twocolumn[\@maketitle] 
	\else \newpage
	\global\@topnum\z@ \@maketitle \fi\thispagestyle{plain}\@thanks
	\endgroup
	\setcounter{footnote}{0}
	\let\maketitle\relax
	\let\@maketitle\relax
\gdef\@thanks{}\gdef\@author{}\gdef\@title{}\let\thanks\relax}
\def\@maketitle{\newpage
	\null\vskip 2em
 	\begin{center}
	{\huge\@title\par}\vskip 1.5em {\Large\lineskip .5em
	\begin{tabular}[t]{c}\@author 
	\end{tabular}\par} 
	\vskip 1em {\Large\@date} 
	\end{center}
	\par
	\vskip 1.5em}

% **********
% Abstract * 
% **********
\def\abstract{\if@twocolumn
	\section*{Abstract}
	\else \small 
	\begin{center}
	{\bf Abstract\vspace{-.5em}\vspace{0pt}} 
	\end{center}
	\quotation 
	\fi}
\def\endabstract{\if@twocolumn\else\endquotation\fi}
	
% ******
% Date *
% ******
\def\today{\ifcase\month\or
	January\or February\or March\or April\or May\or June\or
	July\or August\or September\or October\or November\or December\fi
	\space\number\day, \number\year}

% **********
% Appendix *
% **********
\newif\ifappend % Are we in the Appendix?
\def\appendix{\par
	\setcounter{chapter}{0}
	\setcounter{section}{0}
	\setcounter{subsection}{0}
	\appendtrue
\def\@chapapp{Appendix}
\def\thechapter{\Alph{chapter}}}
	
% **************************
% Useful additional macros *
% **************************
% BACKGROUND environment and OPENING environment

% Background reading (Unnumbered list)
% also with a section* heading
\def\thebackground#1{\section*{Background reading}%
	\list{}{\leftmargin 2em
	\itemindent -\leftmargin
	\labelwidth\z@ \labelsep 1pc
	\itemsep\z@
	\parsep \itemsep}}
\let\endthebackground=\endlist

% Quotes at chapter openings
\def\opening{\small\list{}
	{\leftmargin 1em \rightmargin\leftmargin
	\parsep 6pt
	\listparindent 0pt
	\topsep 6pt
	\itemindent\listparindent}\item[]}
\let\endopening=\endlist

% And finally...
\ps@headings
\onecolumn