
%%% degm.cls v0.5 is a modified version of degm.cls that has the
%%% theorem environment slightly changed, version of Feb. 9, 2002        %%%
 

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{degm}
         [2001/01/15 v0.5 Verlag Walter de Gruyter]
\DeclareOption*{%
    \PassOptionsToClass  {\CurrentOption}{article}}
\ProcessOptions
\LoadClass[a4paper,twoside]{article}
 

\textheight192mm
\textwidth125mm

\vbadness=10000
\hbadness=10000
\topskip=12pt
\parindent=0.5cm
\parskip=0pt
\widowpenalty=10000
\clubpenalty=10000
\hfuzz=1.5pt
\setlength\headheight{8.5\p@}
\setlength\headsep{6mm}




%%%%%%%%%%%%%
\oddsidemargin=0pt
\evensidemargin=0pt
\topmargin=0pt
\marginparsep=0pt
\marginparwidth=0pt
%%%%%%%%%%%%%%%%

\renewcommand{\@seccntformat}[1]{\csname the#1\endcsname}


%\renewcommand\large{\@setfontsize\large\@xiipt{14.4}}
%\renewcommand\Large{\@setfontsize\Large\@xivpt{16}}
%\renewcommand\LARGE{\@setfontsize\LARGE\@xviipt{20}}

\renewcommand\normalsize{%
   \@setfontsize\normalsize\@xpt\@xiipt
   \abovedisplayskip 6\p@ \@plus1\p@
   \abovedisplayshortskip 6\p@ \@plus1\p@
   \belowdisplayshortskip 6\p@ \@plus1\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\normalsize

\renewcommand\ps@headings{%
  \let\@oddfoot\@empty\let\@evenfoot\@empty
  \def\@evenhead{\small\itshape[Page \thepage]\hfil}%
  \def\@oddhead{\hfil\small\itshape[Page \thepage]}%
  \let\@mkboth\markboth
  \def\sectionmark##1{%
    \markboth {\uppercase{\ifnum \c@secnumdepth >\z@
        \thesection.\relax\fi
        ##1}}{}}%
  \def\subsectionmark##1{%
    \markright {\ifnum \c@secnumdepth >\@ne
        \thesubsection\relax \fi
        ##1}}}


\renewcommand\ps@myheadings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\thepage\hfil\small\leftmark\hfil}%
    \def\@oddhead{\hfil{\small\rightmark}\hfil\thepage}%
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
    }

\def\myfnsymbol#1{\expandafter\@myfnsymbol\csname c@#1\endcsname}

\def\@myfnsymbol#1{\ensuremath{\ifcase#1\or *\or \ddagger\or **\or
   \mathsection\or \mathparagraph\or \|\or **\or \dagger\dagger
   \or \ddagger\ddagger \else\@ctrerr\fi}}


\renewcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\myfnsymbol{footnote}}%
    \def\@makefnmark{\hbox to\z@{$\m@th^{\@thefnmark}$\hss}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hbox to1.8em{\hss$\m@th^{\@thefnmark}$}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{headings}
    \@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \let\thanks\relax
  \let\maketitle\relax\let\@maketitle\relax
  \gdef\@thanks{}\gdef\@author{}\gdef\@title{}}


\renewcommand\@maketitle{%
  \newpage
%  \null
%  \vskip 2em%
  \begin{center}%
    {\LARGE\bfseries \@title \par}%
    \vskip 24\p@%
        {\Large\itshape
      \lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
%    \vskip 1em%
%    {\large \@date}%
  \end{center}%
  \par
  \vskip 60\p@}
  

\def\@sect#1#2#3#4#5#6[#7]#8{\ifnum #2>\c@secnumdepth
     \let\@svsec\@empty\else
     \refstepcounter{#1}%
     \let\@@protect\protect
     \def\protect{\noexpand\protect\noexpand}%
     \edef\@svsec{\@seccntformat{#1}}%
     \let\protect\@@protect\fi
     \@tempskipa #5\relax
      \ifdim \@tempskipa>\z@
      {#6\relax{\interlinepenalty \@M \@svsec #8\par}}%
               \csname #1mark\endcsname{#7}\addcontentsline
         {toc}{#1}{\ifnum #2>\c@secnumdepth \else
                      \protect\numberline{\csname the#1\endcsname}\fi
                    #7}\else
        \def\@svsechd{#6%\hskip #3\relax  %% \relax added 2 May 90
                   \@svsec #8\csname #1mark\endcsname
                      {#7}\addcontentsline
                           {toc}{#1}{\ifnum #2>\c@secnumdepth \else
                           \protect\numberline{\csname the#1\endcsname}%
                                     \fi
                       #7}}\fi
     \@xsect{#5}}


\def\@ssect#1#2#3#4#5{\@tempskipa #3\relax
   \ifdim \@tempskipa>\z@
     {#4%
        {\interlinepenalty \@M #5\par}%
     }
   \else \def\@svsechd{#4%\hskip #1
    \relax
                        #5}\fi
    \@xsect{#3}}



\renewcommand\section{\@startsection {section}{1}{\z@}%
                                  {-36\p@ \@plus -1\p@ \@minus -4\p@}%
                                  {12\p@ \@plus 1\p@}%                                      
                                   {\reset@font\Large\bfseries\centering}}%

\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-24\p@ \@plus -1\p@ \@minus -4\p@}%
                                     {8\p@ \@plus 1\p@}%12
                                     {\reset@font\large\bfseries\centering}}

\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {3.25ex \@plus 1ex \@minus .2ex}%
                                     {-1.5ex \@plus .2ex}%
                                     {\reset@font\normalsize\bfseries}}

\renewenvironment{abstract}{\noindent\small{\bfseries\abstractname.}%
        }%
        {\vskip 11\p@}

\newenvironment{classification}{\noindent\small 2000 Mathematics Subject Classification:}{\vskip 12\p@}

\def\@lbibitem[#1]#2{\item[\hfill\@biblabel{#1}]\if@filesw
      {\let\protect\noexpand
       \immediate
       \write\@auxout{\string\bibcite{#2}{#1}}}\fi\ignorespaces}



\renewenvironment{thebibliography}[1]
     {\section*{\reset@font\fontsize{11.6}{13.6pt}\bfseries\refname
        \@mkboth{\uppercase{\refname}}{\uppercase{\refname}}}%
      \list{\@biblabel{\arabic{enumiv}}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \setlength{\leftmargin}{\labelwidth}
            \labelsep2mm
            \itemsep4pt
        \topsep\z@
            \parsep\z@
            \advance\leftmargin\labelsep
                        \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\arabic{enumiv}}}%
            \sloppy\clubpenalty4000\widowpenalty4000%
      \sfcode`\.=\@m
      \small}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}


\def\@seccntformat#1{\csname the#1\endcsname.\hskip 0.25em}



\pagestyle{myheadings}


%%%%%%%MACROS%%%%%%%%%%%%%%%%%%%%%%

\newskip\aline \newskip\halfaline
\aline=12pt plus 1pt minus 1pt
\halfaline=6pt plus 1pt minus 1pt
\def\skipaline{\vskip\aline}
\def\skiphalfaline{\vskip\halfaline}

\def\qedbox{$\rlap{$\sqcap$}\sqcup$}
\def\qed{\nobreak\hfill\penalty250 \hbox{}\nobreak\hfill\qedbox\skipaline}


\def\Proof{\ifdim\lastskip<\aline\removelastskip\skipaline\fi
\noindent\it Proof. \rm}




%%%%%%%%%%%%optional mathoperators%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%\def\Ker{\mathop{\operator@font Ker}\nolimits}
%%\def\Subg{\mathop{\operator@font Subg}\nolimits}
%%\def\Con{\mathop{\operator@font Con}\nolimits}
%%\def\rank{\mathop{\operator@font rank}\nolimits}
%%\def\core{\mathop{\operator@font core}\nolimits}
%%\def\SL{\mathop{\operator@font SL}\nolimits}
%%\def\GL{\mathop{\operator@font GL}\nolimits}
%%\def\ker{\mathop{\operator@font ker}\nolimits}

%%% the following definitions can also be placed in the LaTeX-file
%%% using this code directly after \documentstyle{degm}.
%%% In this case the comments before \makeatletter and \makeatother
%%% have to be removed

%\makeatletter

%%%% load some packages
 
\RequirePackage{thmproc}
\RequirePackage{amsmath}
\RequirePackage{amssymb}
\RequirePackage{ifthen}
 

%%%%%%%%%proof environment%%%%%%%

\def\@addpunct#1{\ifnum\spacefactor>\@m \else#1\fi}

\newenvironment{proof}[1][\proofname]{\par
  \normalfont
  \topsep6\p@\@plus6\p@ \trivlist
  \item[\hskip\labelsep\itshape
    #1\@addpunct{.}]\ignorespaces
}{\proof@ending\endtrivlist\par}

\newcommand{\proofname}{Proof}
\newcommand{\proof@ending}{\hfill\qedbox}  
\newcommand{\BoxedProofs}{\renewcommand{\proof@ending}{\hfill\ensuremath{\Box}}}
\newcommand{\NonBoxedProofs}{\renewcommand{\proof@ending}{\hfill\qedbox}}

\def\itemitemitem{\par\indent\indent\hangindent3\parindent\textindent}

\newskip\aline \newskip\halfaline
\aline=12pt plus 1pt minus 1pt
\halfaline=6pt plus 1pt minus 1pt
\def\skipaline{\vskip\aline}
\def\skiphalfaline{\vskip\halfaline}
\def\skh{\skiphalfaline}

% Definition of list environment lst and lststyles

\newcommand{\@lstlabel}{}
\newcommand{\lstlabel}[1]{\renewcommand{\@lstlabel}{#1}}
\newcommand{\@lsttemplate}{}
\newcommand{\lsttemplate}[1]{\renewcommand{\@lsttemplate}{#1}}
\newenvironment{lst}%
{\renewcommand{\theenumi}{\@lstlabel}%
  \begin{list}%
    {\@lstlabel}%
    {\usecounter{enumi}%
      \settowidth{\labelwidth}{\@lsttemplate}%
      \setlength{\leftmargin}{\labelwidth}%
      \setlength{\labelsep}{0pt}%
      \setlength{\topsep}{\medskipamount}%
      \setlength{\parsep}{0pt}%
      \setlength{\itemsep}{0pt}%
      \setlength{\itemindent}{0pt}%
      \setlength{\listparindent}{\parindent}}}
  {\end{list}}
\newcommand{\deflststyle}[2]{\expandafter\newcommand\expandafter{\csname @@#1@@\endcsname}{#2}}
\newcommand{\lststyle}[1]{\csname @@#1@@\endcsname}
\deflststyle{}{
  \lsttemplate{}
  \lstlabel{}}
\deflststyle{ }{
  \lsttemplate{\hspace{\parindent}}
  \lstlabel{}}
\deflststyle{--}{
  \lsttemplate{\hspace{\parindent}}
  \lstlabel{\,--\hfill}}
\deflststyle{a.}{
  \lsttemplate{\textnormal{\,b.\ \ }}
  \lstlabel{\textnormal{\,\alph{enumi}.\hfill}}}
\deflststyle{a)}{
  \lsttemplate{\textnormal{\,b). }}
  \lstlabel{\textnormal{\,\alph{enumi})\hfill}}}
\deflststyle{(a)}{
  \lsttemplate{\textnormal{(b)\ \ }}
  \lstlabel{\textnormal{(\alph{enumi})\hfill\ \ }}}
\deflststyle{1.}{
  \lsttemplate{\textnormal{\,0.\ \ }}
  \lstlabel{\textnormal{\hfill\arabic{enumi}.\ \ }}}
\deflststyle{1)}{
  \lsttemplate{\textnormal{\,0)\ \ }}
  \lstlabel{\textnormal{\hfill\arabic{enumi})\ \ }}}
\deflststyle{(1)}{
  \lsttemplate{\textnormal{(0)\ \ }}
  \lstlabel{\textnormal{\hfill(\arabic{enumi})\ \ }}}
\deflststyle{i.}{
  \lsttemplate{\textnormal{\,iii.\ \ }}
  \lstlabel{\textnormal{\hfill\roman{enumi}.\ \ }}}
\deflststyle{i)}{
  \lsttemplate{\textnormal{\,iii)\ \ }}
  \lstlabel{\textnormal{\hfill\roman{enumi})\ \ }}}
\deflststyle{(i)}{
  \lsttemplate{\textnormal{(iii)\ \ }}
  \lstlabel{\textnormal{\hfill(\roman{enumi})\ \ }}}
\lststyle{(a)} % default style

% define block environment as short for trivlist
\newenvironment{block}{\begin{trivlist}\item{}}{\end{trivlist}}

% define remarks this might be superfluous
% because subsection* does more or less the same job
\newcommand{\newremark}[3]{\newenvironment{#1}{
    \begin{block}\textbf{#2.}#3{}}{\end{block}}}

% define commands for the last page

 
% marginal note for authors

\marginparwidth2cm
\reversemarginpar
\newcommand{\note}[1]{\mbox{}\marginpar{
    \hspace{0pt}\raggedright\sffamily\tiny
    \textbf{Note for the author(s).}\\#1}}

% redefine subsection and subsection* so that subsectionto
% are typeset with a dot at the end

\let\s@bsection=\subsection
\newcommand{\c@mda}[2][]{\s@bsection[#1]{#2.}}
\newcommand{\c@mdb}[1]{\s@bsection*{#1.}}
\renewcommand{\subsection}{\secdef\c@mda\c@mdb}
 
 
% set simple quotations and references in textnormal
% original commands are still accesible under \oldcite, \oldref and \oldpageref

\let\oldcite=\cite
\renewcommand{\cite}[2][no@ption]
{\ifthenelse{\equal{#1}{no@ption}}{\textnormal{\oldcite{#2}}}{\oldcite[#1]{#2}}}
\let\oldref=\ref
\renewcommand{\ref}[1]{\textnormal{\oldref{#1}}}
\let\oldpageref=\ref
\renewcommand{\pageref}[1]{\textnormal{\oldpageref{#1}}}

%\makeatother

\let\@contact=\empty
\newcommand{\contact}[2][]{
  \expandafter\gdef\expandafter\@contact\expandafter{%
    \@contact
  \small
  \begin{block}#2\\[.5em]
  \ifthenelse{\equal{#1}{}}{}{Email: #1}\end{block}
  }}
\newcommand{\makelastpage}{\medskip
  \ifx\empty\@contact\empty\noindent
  \makeatother
  Use \texttt{\textbackslash contact[peter@smith.name]\{Peter Smith, York\}}\par
  \makeatletter
  \else\@contact\fi}

\endinput

