theta := proc (s_k, k, A, B)
local j, aux1, aux2, aux3, dnom, diff1, jmax;
if k = 0 then
  A [ k ] := s_k;
  RETURN (s_k)
elif k > 0 then
  jmax := iquo (2 * k + 1, 3);
  if (modp (k, 2) = 0) then
    aux2    := 0;
    aux1    := A [ 0 ];
    A [ 0 ] := s_k;
    for j from 1 to jmax do
      aux3 := aux2;
      aux2 := aux1;
      if j < jmax then
        aux1 := A [ j ]
      fi;
      if (modp (j, 2) = 0) then
        dnom    := normal (A [ j - 1 ] - 2 *
                           B [ j - 1 ] + aux2);
        A [ j ] := normal (aux3 + (B [ j - 2 ] - aux3) *
                          (A [ j - 1 ] - B [ j - 1 ]) / dnom)
      else
        diff1   := normal (A [ j - 1 ] - B [ j - 1 ]);
        A [ j ] := normal (aux3 + 1 / diff1)
      fi
    od;
      if (modp (jmax, 2) = 0) then
        RETURN (A [ jmax ])
      else
        RETURN (A [ jmax - 1 ])
      fi
  else
    aux2    := 0;
    aux1    := B [ 0 ];
    B [ 0 ] := s_k;
    for j from 1 to jmax do
      aux3 := aux2;
      aux2 := aux1;
      if j < jmax then
        aux1 := B [ j ]
      fi;
      if (modp (j, 2) = 0) then
        dnom    := normal (B [ j - 1 ] - 2 *
                           A [ j - 1 ] + aux2);
        B [ j ] := normal (aux3 + (A [ j - 2 ] - aux3) *
                          (B [ j - 1 ] - A [ j - 1 ]) / dnom)
      else
        diff1   := normal (B [ j - 1 ] - A [ j - 1 ]);
        B [ j ] := normal (aux3 + 1 / diff1)
      fi;
    od;
    if (modp (jmax, 2) = 0) then
      RETURN (B [ jmax ])
    else
      RETURN (B [ jmax - 1 ])
    fi;
  fi;
fi;
end;
