% This software may only be used in the preparation of Ergodic Theory and
% Dynamical Systems to be published by Cambridge University Press.
% Any other use constitutes an infringement of copyright.
%
% Created by Alistair Smith, Sunrise Setting Ltd, 27 February 1999
% etds.cls --- For Ergod. Th. & Dynam. Sys. 

\def\update{1999/07/21 v1.0}

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{etds}[\update\ Ergod. Th. & Dynam. Sys.]

\newcommand\hmmax{0}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass{article}
%\RequirePackage{times}
%\RequirePackage[cmbold]{mathtime}
\RequirePackage{pifont,latexsym,ifthen,theorem}
\RequirePackage{amsfonts,amssymb,amsbsy,amsmath,amscd}
\RequirePackage[dvips]{graphics}
\RequirePackage{bm}
\RequirePackage[errorshow]{tracefnt}

\renewcommand{\normalsize}{\fontsize{10}{13pt}\selectfont}
\renewcommand{\small}{\fontsize{9}{11pt}\selectfont}
\renewcommand{\footnotesize}{\fontsize{8}{10pt}\selectfont}
\renewcommand{\scriptsize}{\fontsize{7}{9pt}\selectfont}
\renewcommand{\tiny}{\fontsize{5}{6pt}\selectfont}
\renewcommand{\large}{\fontsize{12}{14pt}\selectfont}
\renewcommand{\Large}{\fontsize{13}{18pt}\selectfont}
\renewcommand{\LARGE}{\fontsize{17}{22pt}\selectfont}
\renewcommand{\huge}{\fontsize{20}{26pt}\selectfont}
\renewcommand{\Huge}{\fontsize{25}{30pt}\selectfont}

%Page and general

\@twosidetrue
\flushbottom
\parindent 12pt
\textwidth 30pc
%\textheight 575pt
\textheight 572pt
\topmargin 0pt
\headsep 15pt
\headheight 20pt
%\footskip 22pt
\footskip 34pt
\hyphenpenalty=1000
\pretolerance=8000
\tolerance=9500
\hbadness=8000
\vbadness=8000
\setlength{\abovedisplayskip}{8\p@ plus2\p@ minus5\p@}
\setlength{\belowdisplayskip}{\abovedisplayskip}
\setlength{\abovedisplayshortskip}{\z@ plus3\p@}
\setlength{\belowdisplayshortskip}{6\p@ plus3\p@ minus3\p@}
\setcounter{topnumber}{5}
\def\topfraction{1}
\setcounter{bottomnumber}{5}
\def\bottomfraction{.8}
\setcounter{totalnumber}{10}
\def\textfraction{0}
\def\floatpagefraction{.8}

\theorembodyfont{\itshape}
\theoremheaderfont{\scshape}
\setlength{\theorempreskipamount}{6pt plus 2pt}
\setlength{\theorempostskipamount}{6pt plus 2pt}

\begingroup \makeatletter
\gdef\th@plain{\normalfont\itshape
  \def\@begintheorem##1##2{%
        \item[\hskip\labelsep \theorem@headerfont ##1\ {##2.}]}%
\def\@opargbegintheorem##1##2##3{%
   \item[\hskip\labelsep \theorem@headerfont ##1\ ##2\ (##3)]}}
\endgroup

\def\refname{References}
\def\figurename{\textsc{Figure}}
\def\tablename{\textsc{Table}}
\def\abstractname{Abstract}

% Title page

% print integer as a zero filled 2 digit field
\def\twodigits#1{\ifnum #1 < 10{0#1}\else{#1}\fi}

% print integer as a zero filled 4 digit field
\def\fourdigits#1{\ifnum #1 < 10{000#1}\else
  \ifnum #1 < 100{00#1}\else
    \ifnum #1 < 1000{0#1}\else{#1}\fi
  \fi
\fi}

%First page catchline
%ETDS{first page}{last page}{vol}{year}
\def\ETDS#1#2#3#4{
\gdef\@mymainhead{\parbox[t]{\textwidth}{\normalsize\textit{Ergod.\ Th.\ \&\ Dynam.\ Sys.}\ (#4),\ \textbf{#3},\ \ifnum #1 = #2 #2 \else #1--#2\fi\\
\normalsize\textit{Printed\ in\ the\ United\ Kingdom \hfill\copyright\ #4\ Cambridge\ University\ Press}}}%
\setcounter{page}{#1}}

\def\ps@myplain{\let\@mkboth\@gobbletwo
  \def\@oddhead{\@mymainhead}
  \def\@evenhead{}
  \def\@oddfoot{\scriptsize\textit{Prepared using \textsf{etds.cls} [Version: \update]}\hfill}
\def\@evenfoot{}
}

\thispagestyle{myplain}

%Headers and footers for non-title pages

\def\runningheads#1#2{\markboth{#1}{#2}}

\def\ps@etds{
\let\@mkboth\@gobbletwo
\def\@evenhead{\normalsize%
\thepage\hfill\textit{\leftmark}\hfill\phantom{\thepage}}
\def\@oddhead{\normalsize%
\phantom{\thepage}\hfill\textit{\rightmark}\hfill\thepage}
\def\@evenfoot{\scriptsize\textit{Prepared using \textsf{etds.cls}}\hfill}
\def\@oddfoot{\@evenfoot}
}

\pagestyle{etds}

%%%%%%%%%
%Title, author, etc

\def\title#1{\addtocounter{footnote}{1}
\vspace*{12pt}\begin{center}%
\LARGE\textbf{#1}\par
\vspace*{10pt}}

\def\author#1{\vspace*{6pt}\normalsize #1\par\vspace*{3pt}}

\def\address#1{\textit{#1}}

\def\recd#1{\vspace*{13pt plus 6pt minus 6pt}%
(\textit{Received #1})\par\end{center}}

\def\abstract{\vspace*{33pt plus6pt minus 7pt}\noindent\textit{\abstractname}. \ignorespaces}%
\def\endabstract{\par\vspace{12\p@ plus6\p@ minus12\p@}}

\def\nosections{\vspace{30\p@ plus12\p@ minus12\p@}
\noindent\ignorespaces}

%define section heads etc for style

\def\thesection{\arabic{section}}
\def\thesubsection{\thesection.\arabic{subsection}}
\def\thesubsubsection{\thesubsection.\arabic{subsubsection}}
%\def\theparagraph{\thesubsubsection.\arabic{paragraph}}
%\def\thesubparagraph{\theparagraph.\arabic{subparagraph}}

%%%%%%%%%%%
\renewcommand{\section}{\makeatletter
\renewcommand{\@seccntformat}[1]{{\em{\csname the##1\endcsname.}}\hspace{1em}}
\makeatother
\@startsection
{section}%           the name
{1}%                 the level
{\z@}%               the indent
{-3.5ex plus -1ex minus -.2ex}%  the beforeskip
{+0.01pt}%     the afterskip
{\noindent\normalsize\itshape}}% the style 
%%
%%
\def\subsection{
\@startsection
{subsection}%           the name
{2}%                 the level
{\z@}%               the indent
{-3.5ex plus -1ex minus -.2ex}%  the beforeskip
{-1em}%     the afterskip
{\noindent\normalsize\itshape}}% the style 
%%
%%
\def\subsubsection{
\@startsection
{subsubsection}%           the name
{3}%                 the level
{\z@}%               the indent
{-3.5ex plus -1ex minus -.2ex}%  the beforeskip
{-1em}%     the afterskip
{\normalsize\itshape}}% the style 
%%%%%%%%%%%%%%%%%%%%%%


%%
%lists etc
\def\enumerate{\ifnum \@enumdepth >3 \@toodeep\else
      \advance\@enumdepth \@ne 
      \edef\@enumctr{enum\romannumeral\the\@enumdepth}\list
      {\csname label\@enumctr\endcsname}{\usecounter
        {\@enumctr}\parsep=0pt\leftmargin=24pt
\labelsep=4pt\labelwidth=\leftmargin
\advance\labelwidth-\labelsep\topsep=0pt\partopsep=0pt
\itemsep=0pt\def\makelabel##1{\hbox to\labelwidth{##1\hss}}}\fi}

%%%%%%%%%%%%%%%%
%Footnotes
\renewcommand{\footnoterule}{}
%\long\def\@makefntext#1{\parindent 1em%
%\noindent{$\m@th^{\@thefnmark}$}#1}
\def\@makefnmark{\hbox{${\fnsymbol{footnote}}\m@th$}}
\newcounter{myfn}[page]
\renewcommand{\thefootnote}{\fnsymbol{footnote}}
\long\def\@makefntext#1{\setcounter{footnote}{\value{myfn}}%
\parindent 1em%
\noindent{$\m@th{\@thefnmark}$}\ #1%
\stepcounter{myfn}\addtocounter{footnote}{1}}

%Figure and tables

\long\def\@makecaption#1#2{\vspace*{8pt}{%
\setbox0=\vbox{\footnotesize\baselineskip=9pt\rm #1.\ #2}%
\setbox0=\vbox{\unvbox0 \setbox1=\lastbox%
\setbox1=\hbox to \textwidth{\hfill\unhbox1\hfill}\box1}%
\box0}\par\vspace*{3pt}}

\newcommand{\ms}{\noalign{\vspace{3\p@ plus2\p@ minus1\p@}}}
\newcommand{\boldarrayrulewidth}{1\p@}

\def\topline{\noalign{\ifnum0=`}\fi\hrule \@height
\boldarrayrulewidth \futurelet \@tempa\@xhline}
\def\@xhline{\ifx\@tempa\hline\vskip \doublerulesep\fi
\ifnum0=`{\fi}}

% Weighted rules for tables
\newcommand{\toprule}{\ms\topline\ms}
\newcommand{\midrule}{\ms\hline\ms}
\newcommand{\bottomrule}{\ms\topline}

%%%%%%%%%%%%%%%%%%

%Acks
\def\ack{\subsubsection*{Acknowledgement.}}%
\def\acks{\subsubsection*{Acknowledgements.}}

%references

\def\makelabel#1{\hbox to\labelwidth{#1\hss}}
\def\thebibliography#1{\vspace{26pt plus6pt minus7pt}
  \begin{center}
\textsc{\refname}\end{center}\vspace*{6pt}%
\list{[{\bf\arabic{enumi}}]}{\def\makelabel##1{{\bf##1}\hss}\topsep=0\p@\parsep=0\p@
 \partopsep=0\p@\itemsep=0\p@
 \labelsep=12\p@\itemindent=0\p@
 \settowidth\labelwidth{\footnotesize[#1]}%
 \leftmargin\labelwidth
 \advance\leftmargin\labelsep
 \advance\leftmargin -\itemindent
 \usecounter{enumi}}\footnotesize
 \def\newblock{\ }
 \sloppy\clubpenalty4000\widowpenalty4000
 \sfcode`\.=1000\relax}
\let\endthebibliography=\endlist
\def\numrefs#1{\begin{thebibliography}{#1}}
\def\endnumrefs{\end{thebibliography}}

% Macro to used for references in the Harvard system

\newenvironment{thereferences}{\vspace{26pt plus6pt minus7pt}
  \begin{center}
{\sc \refname}\end{center}\vspace*{6pt}\list{}{\topsep=0\p@\parsep=0\p@
\partopsep=0\p@\itemsep=0\p@\labelsep=0\p@\itemindent=-18\p@
\labelwidth=0\p@\leftmargin=18\p@
}\footnotesize\rm
\def\newblock{\ }
\sloppy\clubpenalty4000\widowpenalty4000
\sfcode`\.=1000\relax}{\endlist}

\renewcommand{\@cite}[2]{[{\textbf{#1}}\ifthenelse{\boolean{@tempswa}}{, #2}{}]}
\def\@biblabel#1{[#1]}

%Macros for author/addresses
\def\affil#1{\ifcase#1\or $\dagger$\or $\ddagger$\or
   $\S$\or $\P$\or $\|$\or **\or $\dagger\dagger$
   \or $\ddagger\ddagger$\else\fi}

\def\affilnum#1{\ifcase#1\or $\dagger$\or $\ddagger$\or
   $\S$\or $\P$\or $\|$\or **\or $\dagger\dagger$
   \or $\ddagger\ddagger$\else\fi}

\def\email#1{(e-mail: #1)}

%Other macros
\def\dssty{\displaystyle}
\def\ssty{\scriptstyle}
\def\dfrac{\displaystyle\frac}
\def\bprop{\begin{prop}}
\def\eprop{\end{prop}}
\def\blem{\begin{lema}}
\def\elem{\end{lema}}
\def\bth{\begin{theo}}
\def\eth{\end{theo}}
\def\bcor{\begin{cor}}
\def\ecor{\end{cor}}
\def\proc#1{\medbreak\noindent{\it #1}\hspace{1ex}\ignorespaces}
\def\ep{\noindent{\hfill $\Box$}}
\def\mb{\medbreak}
\def\ben{\begin{enumerate}}
\def\een{\end{enumerate}}
\def\nn{\notag\\}
\def\erg{{\it Ergod. Th. \&\ Dynam. Sys.}}


