%%
%% osuthesis.cls
%%
%% Created (11/17/02): Rick Mohr
%%
%% This is a LaTeX2e document class for OSU dissertations that
%% (hopefully) complies with the graduate school requirements.
%%
%% This class is based on the standard LaTeX class `book'.

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{osuthesis}


% Dissertation style options are
% 1) ms (default is off)
% 2) draft (default is off)

% Use package 'ifthen' to get \boolean type commands
\RequirePackage{ifthen}

% Create new boolean parameters and set default values
\newboolean{@phd}
\setboolean{@phd}{true}
\newboolean{@ms}
\setboolean{@ms}{false} 
\newboolean{@draft}
\setboolean{@draft}{false} 

% Declare the available options for the document class
% and define code to execute for each option.
\DeclareOption{ms}{\setboolean{@ms}{true} \setboolean{@phd}{false}}
\DeclareOption{draft}{\setboolean{@draft}{true}}

% Process the options.
\ProcessOptions
 
% Load the book class in 12pt, letterpaper, titlepage, onecolumn
\LoadClass[12pt,letterpaper,titlepage,oneside,onecolumn]{book}



% Now we begin (re)defining commands/parameters to match the
% grad school requirements.

%  ************************
%  **   INITIALIZATION   **
%  ************************

\newcommand{\UseBookClass}{}

% Remove all header and margin note stuff
\setlength{\topmargin}{0pt}
\setlength{\headheight}{0pt}
\setlength{\headsep}{0pt}
\setlength{\marginparsep}{0pt}
\setlength{\marginparwidth}{0pt}

% Margins: top = 1.0in, bottom = 1.0in, left = 1.5in, right = 1.0in
% Text height is less than 9in, but when \footskip is added, this places
% page number at 9in from top leaving 1in bottom margin.
\setlength{\textheight}{8.6in}
\setlength{\footskip}{0.4in}
\setlength{\oddsidemargin}{0.5in}
\setlength{\evensidemargin}{0.5in}
\setlength{\textwidth}{6.0in}

% Set up single and double spacing commands
\newcommand{\startsinglespace}[1][\normalsize]{%
   \renewcommand{\baselinestretch}{1}\small\large#1}
\newcommand{\startdoublespace}[1][\normalsize]{%
   \renewcommand{\baselinestretch}{2}\small\large#1}

% Set up double spacing and page style when document begins.
\AtBeginDocument{
   \startsinglespace
   \pagestyle{plain}%
   \if@draft
      \draftinit
   \fi
}


%  ************************************
%  **   COMMANDS FOR DRAFT OPTION   **
%  ************************************

\newcommand{\draftinit}{
   \setlength{\headheight}{1pt}
   \newlength{\vlineheight}
   \setlength{\vlineheight}{\textheight}
   \addtolength{\vlineheight}{\footskip}
   \newcommand*{\ps@draft}{%
      \renewcommand*{\@oddhead}{\rule[-\vlineheight]{0.5pt}{\vlineheight}%
                                \hrulefill
                                \rule[-\vlineheight]{0.5pt}{\vlineheight}}%
      \renewcommand*{\@evenhead}{\@oddhead}%
      \renewcommand*{\@oddfoot}{\hrulefill ~\thepage~ \hrulefill}%
      \renewcommand*{\@evenfoot}{\@oddfoot}%
   }%
   \renewcommand*{\ps@empty}{\ps@draft}%
   \pagestyle{draft}%
}
\newcommand{\drafttext}{DRAFT}


%  *******************
%  **   TITLEPAGE   **
%  *******************

% Several variables come from report.cls :
% \@author, \@title

% Define some new parameters and the commands
% to set them.

\newcommand{\@authordegrees}{}
\newcommand{\authordegrees}[1]{\renewcommand{\@authordegrees}{#1}}
\newcommand{\@degree}{Doctor of Philosophy}
\newcommand{\@degreeabbrev}{Ph.D.}
\newcommand{\@committee}{Dissertation}
\newcommand{\@thesis}{DISSERTATION}
\newcommand{\@unit}{}
\newcommand{\unit}[1]{\renewcommand{\@unit}{#1}}
\newcommand{\@graduationyear}{\year}

% Committee member related commands
\newcommand{\@adviser}{Adviser}
\newcommand{\@advisername}{}
\newcommand{\advisername}[1]{\renewcommand{\@advisername}{#1}}
\newboolean{@coadviser}
\setboolean{@coadviser}{false}
\newcommand{\@coadviser}{Co-Adviser}
\newcommand{\@coadvisername}{}
\newcommand{\coadvisername}[1]
   {\setboolean{@coadviser}{true} \renewcommand{\@coadvisername}{#1}}
\newcommand{\@member}{}
\newcommand{\member}[1]{\edef\@member{\@member \vskip 3pt #1}}

% Redefine the \maketitle command so that it formats the
% way we want it to.
\renewcommand{\maketitle}{%
   \begin{titlepage}%
      \vspace*{1in}
      \begin{center}
         \startsinglespace
         \if@draft
            \vskip -72pt
            \fbox{{\LARGE\sc \drafttext{} -- \today}}
            \vskip 20pt
         \fi
         {\Large {{\@title}} \par}
         \vspace{0.5in}
         {\large {\@thesis} \par}
         \vspace{0.5in}
         {\large Presented in Partial Fulfillment of the Requirements for\\
         \vspace{8pt}
         the Degree \@degree{} in the\\ 
         \vspace{8pt}
         Graduate School of The Ohio State University}
         \vspace{20pt}
         {\large By\par}
         \vspace{10pt}
         {\large \lineskip .75em
         \begin{tabular}[t]{c}\@author , \@authordegrees
         \end{tabular}\par} 
         \vspace{10pt}
         {\large * * * * *\par}
         \vspace{10pt}
         {\large The Ohio State University\par}
         \vspace{5pt} {\large \number\@graduationyear \par}
      \end{center}
      \par
      \if@coadviser
         \vspace{10pt}
      \else
         \vspace{25pt}
      \fi
      \begin{minipage}[t]{3.0in}
         \startsinglespace
         {\large \@committee{} Committee:}
         \vskip 3pt
         \@advisername, \@adviser
         \if@coadviser
            \vskip 3pt
            \@coadvisername, \@coadviser
         \fi
         \@member
      \end{minipage} \ \hfill \
      \begin{minipage}[t]{2.0in}
         \startsinglespace
         \begin{center}
            {\large Approved by} \\
            \if@coadviser
               \vspace{15pt}
            \else
               \vspace{30pt}
            \fi
            \makebox[2in][c]{\leaders\hrule\hskip 2.0in}
            \vspace{1pt}
            \if@coadviser
               {\@adviser \\}
               \vspace{10pt}
               \makebox[2in][c]{\leaders\hrule\hskip 2.0in}
               \vspace{1pt}
               {\@coadviser \\}
            \else
               {\@adviser \\}
            \fi
            \vspace{3pt}
            \@unit
         \end{center}
      \end{minipage}
   \end{titlepage}
   \clearpage
}

%  ***************************
%  **   EXTERNAL ABSTRACT   **
%  ***************************

% Define an externalabstract environment for
% control over whether or not copies of the
% external abstract are produced.
\newenvironment{externalabstract}{%
  \clearpage
  \setcounter{page}{1}
  \pagenumbering{arabic}
  \begin{center}
    \startsinglespace[\large]
    \vspace*{1.0in}
    \vspace*{-\baselineskip}
    \@title
    \par
    \startdoublespace
    By \\
    \@author , \@degreeabbrev \\
    The Ohio State University, {\number\@graduationyear}\\
    \if@coadviser
       \@advisername , \@coadviser\\
       \@coadvisername , \@coadviser\\
    \else
       \@advisername , \@adviser\\
    \fi
  \end{center}
  \startdoublespace
  \vspace{\baselineskip}
}
{ \clearpage
}


%  *******************
%  **   COPYRIGHT   **
%  *******************

% The \makecopyright command takes one argument, true or false.
% If false, a blank page is included.
\newcommand{\makecopyright}{%
   \thispagestyle{empty}%
   \vspace*{\fill}%
   \begin{center}%
   \copyright \ Copyright by\\
   \@author\\
   {\number\@graduationyear}%
   \end{center}%
   \vspace*{\fill}%
   \clearpage
}

\newcommand{\skipcopyright}{\thispagestyle{empty}~\clearpage}


%  ********************
%  **   DEDICATION   **
%  ********************

\newcommand{\dedication}[1]{
  \clearpage
  \addcontentsline{toc}{chapter}{Dedication}%
  \vspace*{\fill}%
  \begin{center} #1 \end{center}%
  \vspace*{\fill}%
}


%  **************
%  **   VITA   **
%  **************

% Define command to add dated items to vita
\newcommand{\dateitem}[2]{
   \noindent #1 \dotfill \parbox[t]{2.75in}{#2}%
   \par~\par}


%  ***************************
%  **   TABLE OF CONTENTS   **
%  ***************************

\renewcommand{\contentsname}{Table of Contents}

\addtocontents{toc}{\startsinglespace}
\addtocontents{toc}{~\hfill\underline{Page}}
\addtocontents{toc}{}

\renewcommand{\tableofcontents}{%
   \chapter*{\contentsname}%
   \@starttoc{toc}%
}

\newcommand{\chapterDivider}{Chapters:}
\newcommand{\appendixDivider}{Appendices:}
\newcommand{\tocdivider}{\chapterDivider}

\renewcommand\l@chapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 1.0em \@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\dotfill \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
      \vskip 0.5em
      \penalty\@highpenalty
    \endgroup
  \fi}



%  ********************************
%  **   LIST OF FIGURES/TABLES   **
%  ********************************

\addtocontents{lof}{\noindent\underline{\figurename}\hfill\underline{Page}}

\renewcommand{\listoffigures}{%
   \chapter{\listfigurename}%
   \@starttoc{lof}%
}

\renewcommand*{\l@figure}{%
   \vskip\baselineskip
   \startsinglespace\@dottedtocline{1}{1.5em}{2.3em}%
} 


\addtocontents{lot}{\noindent\underline{\tablename}\hfill\underline{Page}}

\renewcommand{\listoftables}{%
    \chapter{\listtablename}%
    \@starttoc{lot}%
}

\renewcommand*{\l@table}{\l@figure}


%  ******************
%  **   CHAPTERS   **
%  ******************

\renewcommand{\chapter}{%
   \clearpage
   \suppressfloats
   \secdef\@chapter\@schapter
}

\renewcommand{\@chapter}[2][]{%
   % Add table of contents entry
   \if@mainmatter
      \refstepcounter{chapter}%
      \typeout{\@chapapp\space\thechapter.}%
      \ifnum\value{chapter}=1
         \addtocontents{toc}{\vskip\baselineskip\noindent\tocdivider\vskip 0pt}
      \fi
      \addcontentsline{toc}{chapter}{\protect\numberline{\thechapter}#1}%
   \else
      \addcontentsline{toc}{chapter}{#1}%
   \fi
   % Create chapter head
   \begin{center}
      \startsinglespace[\Large]
      \vspace*{1in}%
      \vspace*{-\baselineskip}%
      \if@mainmatter
          \bfseries \MakeUppercase{\@chapapp \space \thechapter} \\
          \vspace*{2\baselineskip}
      \fi
      \bfseries \MakeUppercase{#2}
   \end{center}%
   \@endchapterhead
}

\renewcommand{\@schapter}[1]{%
   % Create chapter head
   \begin{center}%
      \startsinglespace[\Large]
      \vspace*{1in}%
      \vspace*{-\baselineskip}%
      \bfseries \MakeUppercase{#1}
   \end{center}%
   \@endchapterhead
}

\newcommand{\@endchapterhead}{
   \startsinglespace
   \vspace*{4\baselineskip}
   \vspace*{-\baselineskip}
}



%  ******************
%  **   APPENDIX   **
%  ******************

\let\oldappendix\appendix
\renewcommand{\appendix}{\oldappendix
   \renewcommand{\tocdivider}{\appendixDivider}
}


%  **********************
%  **   BIBLIOGRAPHY   **
%  **********************

\renewenvironment{thebibliography}[1]{%
   \chapter*{\bibname}%
   % Add bibliography to table of contents
   % and use single spacing within entries
   \addcontentsline{toc}{chapter}{\bibname}
   \startsinglespace
   % Everything else is the same
   \list{\@biblabel{\@arabic\c@enumiv}}%
   {\settowidth\labelwidth{\@biblabel{#1}}%
   \leftmargin\labelwidth
   \advance\leftmargin\labelsep
   \@openbib@code
   \usecounter{enumiv}%
   \let\p@enumiv\@empty
   \renewcommand\theenumiv{\@arabic\c@enumiv}}%
   \sloppy
   \clubpenalty4000
   \@clubpenalty \clubpenalty
   \widowpenalty4000%
   \sfcode`\.\@m
}
{\def\@noitemerr
   {\@latex@warning{Empty `thebibliography' environment}}%
   \endlist
} 


%  ************************
%  **   FIGURES/TABLES   **
%  ************************
\renewenvironment{figure}{%
   \@float{figure}%
   \begin{minipage}{6.0in}
   \startsinglespace
}
{\end{minipage}
 \end@float
 %\vspace{-\baselineskip}
} 

\renewenvironment{table}{%
   \@float{table}%
   \begin{minipage}{6.0in}
   \startsinglespace
}
{\end{minipage}
 \end@float  
 %\vspace{-\baselineskip}%
}

\renewcommand{\textfraction}{0.5}

\setlength{\abovecaptionskip}{\baselineskip}
\setlength\floatsep    {3.0\baselineskip \@plus 2pt \@minus 2pt}
\setlength\textfloatsep{3.0\baselineskip \@plus 2pt \@minus 2pt}
\setlength\intextsep   {3.0\baselineskip \@plus 2pt \@minus 2pt}



%  *******************
%  **   FOOTNOTES   **
%  *******************

\setlength{\footnotesep}{\baselineskip}
\renewcommand\@makefntext[1]{%
    \noindent
    \startsinglespace[\footnotesize]
    \hb@xt@1.0em
    {\hss\@makefnmark}#1}


%  ********************
%  **   QUOTATIONS   **
%  ********************

\renewenvironment{quotation}{%
   \list{}{\listparindent 1.5em%
           \itemindent \listparindent
           \rightmargin \leftmargin
           \parsep \z@ \@plus\p@}%
   \item\relax
   \startsinglespace
}
{\endlist \vspace{-\baselineskip}}

\renewenvironment{quote}{%
   \list{}{\rightmargin\leftmargin}%
   \item\relax
   \startsinglespace
}
{\endlist\vspace{-\baselineskip}}                


%    ****************************************
%    *      MASTER'S THESIS SUPPORT         *
%    ****************************************

\if@ms
   \renewcommand{\@degree}{Master of Science}
   \renewcommand{\@degreeabbrev}{M.S.}
   \renewcommand{\@committee}{Master's Examination}
   \renewcommand{\@thesis}{A Thesis}
\fi


%   *********************
%   *    PAGE BREAKS    *
%   *********************

% This should help prevent single lines from ending or beginning a page.
\widowpenalty 10000
\clubpenalty 10000

% This prevents hyphenation of last word on page.
\brokenpenalty=10000

\endinput
%%
%% End osuthesis.cls
%%
