\ProvidesClass{pazh}
\newif\if@manuscript \@manuscriptfalse
\newif\if@twoside

\DeclareOption{a4paper}{\def\@papersize{a4paper}}
\DeclareOption{letterpaper}{\def\@papersize{letterpaper}}
\DeclareOption{twoside}{\@twosidetrue}
\DeclareOption{oneside}{\@twosidefalse}
\DeclareOption{manuscript}{
  \@manuscripttrue
  }

\ExecuteOptions{a4paper,twoside}
\ProcessOptions

\if@twoside
  \def\@sidetype{twoside}
\else
  \def\@sidetype{oneside}
\fi

\if@manuscript
 \LoadClass[\@papersize,\@sidetype,12pt]{article}
 \RequirePackage[doublespacing]{setspace}
 \RequirePackage[nolists,nomarkers]{endfloat}
 \def\pazhtablesize{\scriptsize}
\else
 \LoadClass[\@papersize,\@sidetype,twocolumn]{article}
 \def\pazhtablesize{\footnotesize}
\fi



% Journal info
\def\journalinfo#1#2#3#4{
  \gdef\@pazhyear{#1}
  \gdef\@pazhvolume{#2}
  \gdef\@pazhno{#3}
  \gdef\@pazhpage{#4}
  \pazhlastpage
  }
\def\pazhlastpage{
  \@ifnextchar[{\setpazhlastpage}
  {\gdef\@pazhlastpage{\@pazhpage}}}
\def\setpazhlastpage[#1]{\gdef\@pazhlastpage{#1}}
\journalinfo{2003}{29}{5}{298}[303] % - fake info

% Misc macros
\def\@pazh@back@one@line{\vspace{-\baselinestretch\baselineskip}}


% Page layout
\setlength{\columnsep}{5mm}

\if@twoside
 \usepackage[\@papersize,twoside,twosideshift=-0.1in,textheight=233mm,headheight=0pt,headsep=5mm,footskip=9mm,textwidth=173mm]{geometry}
\else
 \usepackage[\@papersize,textheight=233mm,headheight=0pt,headsep=5mm,footskip=9mm,textwidth=173mm]{geometry}
\fi
\sloppy


% Title
\newenvironment{pazhtitle}{
  \large\bfseries
  \list{}{\rightmargin 0.05\linewidth\leftmargin\rightmargin}%
  \MakeUppercase
\item\relax}{\endlist}

% email
\def\email#1{\textsuperscript{*}\gdef\@email{#1}}
\def\@@email#1{
  \let\oldthefootnote\thefootnote
  \renewcommand\thefootnote{\relax}
  \footnotetext{\hspace{-\parindent}\textsuperscript{*}e-mail: #1}
  \let\thefootnote\oldthefootnote
  \setcounter{footnote}{0}
  }
\def\submitted#1{\gdef\@submitted{#1}}
\def\author#1{%
  \gdef\@author{#1}
  }
% MAKETITLE MACRO
\def\@maketitle{%
  \newpage
  \null
  \if@manuscript\else
   % \vskip -8mm
   \@pazh@back@one@line
   %      
   \noindent{\small\itshape  ASTRONOMY LETTERS, \@pazhyear, 
    vol.~\@pazhvolume, no.~\@pazhno, p.~\@pazhpage--\@pazhlastpage}\par
   %  
   \@pazh@back@one@line\vspace{7mm}
   \def\linerule{\noindent\makebox[\linewidth]{\hrulefill}}
   \linerule\par\vspace{-\baselinestretch\baselineskip}\vspace{1mm}\linerule
   % 
   \@pazh@back@one@line\vskip 9mm
   %\noindent {\small\itshape PAZH.CLS 30.12.01}
  \fi
 % 
  \begin{center}% 
    \begin{minipage}{0.885\linewidth}
      %     footnotes;   
      \let\footnotesize=\small
      \def\address##1{\textsuperscript{##1}}%
      \def\addresstext##1##2{\footnotetext[##1]{\itshape ##2}}%
      \def\thefootnote{\@arabic\c@footnote}
      \def\thempfootnote{\@arabic\c@mpfootnote}
      \let\footnoterule\relax
      \long\def\@footnotetext##1{%
        \global\setbox\@mpfootins\vbox{%
          \unvbox\@mpfootins
          \reset@font\footnotesize
          \@parboxrestore
          \centerline{
            \protected@edef\@currentlabel
            {\csname p@mpfootnote\endcsname\@thefnmark}%
            \color@begingroup
            \@makefntext{%
              \rule\z@\footnotesep\ignorespaces##1\@finalstrut\strutbox}%
            \color@endgroup}}}
      \begin{center}
        %  
        {\large\bfseries \MakeUppercase\@title\par
          \if@manuscript\else\@pazh@back@one@line\fi}%
        \if@manuscript\else\vskip 8mm\fi
        % 
        {\bfseries
          \if@manuscript\else\makebox[0pt][r]{\textcopyright~\number\year}~~~\fi
          \@author\par
          \vskip 1em}
      \end{center}
    \end{minipage}  %    minipage  
  %  \par\medskip{\footnotesize    \@submitted}%
  \end{center}%
  \vskip 2mm
  \par
  \begin{pazhabstract}\the\abstract@toks\end{pazhabstract}
  \vskip 1.5em
  \if@manuscript\else\setcounter{page}{\@pazhpage}\fi
  }

% Abstract: the code to take the contents of the abstract environemnt is
% taken from tugboat.dtx
\newtoks\abstract@toks  \abstract@toks{}
\let\if@abstract\iffalse
\def\abstract{\def\@abstract@{abstract}%
  \ifx\@currenvir\@abstract@
  \else
    \TBError{\string\abstract\space is illegal:%
      \MessageBreak
      use \string\begin{\@abstract@} instead}%
      {\@abstract@\space may only be used as an environment}
  \fi
  \global\let\if@abstract\iftrue
  {\ifnum0=`}\fi
  \@abstract@getbody
}
% endabstract calls maketitle and puts email; maketitle typesets the title
% text
\def\endabstract{\maketitle\@@email{\@email}}
%%%
\long\def\@abstract@getbody#1\end{%
  \global\abstract@toks\expandafter{\the\abstract@toks#1}%
  \@abstract@findend}
\def\@abstract@findend#1{%
  \def\@tempa{#1}%
  \ifx\@tempa\@abstract@
    \expandafter\@abstract@end
  \else
    \def\@tempb{document}%
    \ifx\@tempa\@tempb
      \TBError{\string\begin{\@abstract@}
          ended by \string\end{\@tempb}}%
        {You've forgotten \string\end{\@abstract@}}
    \else
       \global\abstract@toks\expandafter{\the\abstract@toks\end{#1}}%
       \expandafter\expandafter\expandafter\@abstract@getbody
    \fi
  \fi}
\def\@abstract@end{\ifnum0=`{\fi}%
  \expandafter\end\expandafter{\@abstract@}}
%% The way abstract is typeset
\newenvironment{pazhabstract}{
  \def\keywords##1{\medskip\emph{Keywords:}~~##1\medskip}
  \def\englishkeywords##1{\medskip\emph{Keywords:}~~##1\medskip}
  \def\englishtitle##1{{\raggedright\uppercase{##1,}}}
  \def\englishauthors##1{{\raggedright\emph{by ##1}\par}}
  \small
  \list{}{\rightmargin 0.0575\linewidth\leftmargin\rightmargin}%
\item\relax}{\endlist}

% Sections
\setcounter{secnumdepth}{0}


\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {5.0mm \@plus 1ex \@minus .2ex}%
                                   {1.0mm \@plus.2ex}%
                     {\normalfont\centering\MakeUppercase}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {1.0ex\@plus 1ex \@minus .2ex}%
                                     {1.0ex \@plus .2ex}%
                                     {\centering\normalfont\itshape}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {3.25ex\@plus 1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\raggedright\itshape\normalsize}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                     {3.25ex\@plus 1ex \@minus -.2ex}%
                                     {0.5ex \@plus .2ex}%
                                     {\raggedright\slshape\small}}

% Captions
\AtBeginDocument{
  \def\figurename{Fig.}%
  \def\tablename{Table}%
}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\footnotesize {\bfseries #1.} #2}%
  \ifdim \wd\@tempboxa >\hsize
  \footnotesize {\bfseries #1.} #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

% Acknowledgements

\def\akcnowledgements{\bigskip}

% References
\def\refvolume{v}
\def\refpage{p}
\def\reference#1{\emph{#1}\@reference}
\def\@reference{\@ifnextchar[{\@engreference}{\@rusreference}}
\def\@rusreference#1{\space/\kern-0.2em/ {#1.}}
%\def\@engreference[#1]#2{\space(#1) /\kern-0.2em/ #2.}
\def\@engreference[#1]#2{\space(#1), #2.}

%\def\journal#1#2#3#4{{#1, #2, \refvolume.~#3, \refpage.~#4}}
\def\journal#1#2#3#4{{#1 ~#2, #3, (#4)}}

\def\apj{Astrophys. J.}
\def\asa{Astron. Astrophys.}
\def\pazh{\def\refvolume{}\def\refpage{}   . .}


\renewenvironment{thebibliography}[1]{
  \def\@biblabel#1{\relax}%
  \section{REFERENCES}
  \medskip
  \list{
    \@biblabel{\@arabic\c@enumiv.~}
  }%
  {
    \@openbib@code
    \parindent=0pt \parskip=0pt \parsep=1pt
    \bibindent=0pt
    \small\interlinepenalty \@M  % AV
    \frenchspacing    % AV - to get right spacing after ``et al.''
    \hyphenpenalty=10000
    \itemindent=-10pt   %     ,  
    \itemsep=0pt                            %
    \listparindent=0pt                      %
    \settowidth\labelwidth{\@biblabel{#1}}  %
    \labelsep=0pt                           %
    \leftmargin=1.0em
    \advance\leftmargin\labelsep
    \usecounter{enumiv}%
    \let\p@enumiv\@empty
    \renewcommand\theenumiv{\@arabic\c@enumiv}}%
  \sloppy\clubpenalty4000\widowpenalty4000%
  \sfcode`\.\@m}
{\def\@noitemerr{\@latex@warning{Empty `thebibliography' environment}}%
  \endlist}

% HEADINGS

\def\shortauthor#1{\gdef\@shortauthor{#1}}\shortauthor{}
\def\shorttitle#1{\gdef\@shorttitle{#1}}\shorttitle{}

\if@manuscript\else
 \RequirePackage{fancyhdr}
 \AtBeginDocument{\pagestyle{fancy}}

% Twoside
 \fancyhead{}
 \fancyhead[CE]{\@shortauthor}
 \fancyhead[LE]{\thepage}
 \fancyhead[RO]{\thepage}
 \fancyhead[CO]{\@shorttitle}
 \fancyfoot[CO]{}\fancyfoot[CE]{}
 \fancyfoot[CO]{}\fancyfoot[CE]{}
 \fancyfoot[RO]{\small ASTRONOMY ~LETTERS
   \quad vol.~\@pazhvolume \quad  no.~\@pazhno \quad \@pazhyear \quad}
 \fancyfoot[LE]{\small\quad ASTRONOMY ~LETTERS 
   \quad vol.~\@pazhvolume \quad  no.~\@pazhno \quad \@pazhyear}
 \renewcommand{\headrulewidth}{0pt}
\fi

%
\RequirePackage{indentfirst}
\RequirePackage{amsmath,amssymb}

% Symbols
\def\le{\leqslant}
\def\ge{\geqslant}
