(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     25103,        668]*)
(*NotebookOutlinePosition[     25777,        692]*)
(*  CellTagsIndexPosition[     25733,        688]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(M4 = Show[M1, M2]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 9.52381 0.934087 0.330768 [
[.21429 .26005 -12 -9 ]
[.21429 .26005 12 0 ]
[.40476 .26005 -12 -9 ]
[.40476 .26005 12 0 ]
[.59524 .26005 -12 -9 ]
[.59524 .26005 12 0 ]
[.78571 .26005 -12 -9 ]
[.78571 .26005 12 0 ]
[.97619 .26005 -9 -9 ]
[.97619 .26005 9 0 ]
[1.025 .27255 0 -6.59375 ]
[1.025 .27255 10.125 6.59375 ]
[.01131 .02448 -30 -4.5 ]
[.01131 .02448 0 4.5 ]
[.01131 .10717 -24 -4.5 ]
[.01131 .10717 0 4.5 ]
[.01131 .18986 -30 -4.5 ]
[.01131 .18986 0 4.5 ]
[.01131 .35524 -30 -4.5 ]
[.01131 .35524 0 4.5 ]
[.01131 .43794 -24 -4.5 ]
[.01131 .43794 0 4.5 ]
[.01131 .52063 -30 -4.5 ]
[.01131 .52063 0 4.5 ]
[.01131 .60332 -12 -4.5 ]
[.01131 .60332 0 4.5 ]
[.02381 .64303 -14.25 0 ]
[.02381 .64303 14.25 13.1875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .27255 m
.21429 .2788 L
s
[(0.02)] .21429 .26005 0 1 Mshowa
.40476 .27255 m
.40476 .2788 L
s
[(0.04)] .40476 .26005 0 1 Mshowa
.59524 .27255 m
.59524 .2788 L
s
[(0.06)] .59524 .26005 0 1 Mshowa
.78571 .27255 m
.78571 .2788 L
s
[(0.08)] .78571 .26005 0 1 Mshowa
.97619 .27255 m
.97619 .2788 L
s
[(0.1)] .97619 .26005 0 1 Mshowa
.125 Mabswid
.07143 .27255 m
.07143 .2763 L
s
.11905 .27255 m
.11905 .2763 L
s
.16667 .27255 m
.16667 .2763 L
s
.2619 .27255 m
.2619 .2763 L
s
.30952 .27255 m
.30952 .2763 L
s
.35714 .27255 m
.35714 .2763 L
s
.45238 .27255 m
.45238 .2763 L
s
.5 .27255 m
.5 .2763 L
s
.54762 .27255 m
.54762 .2763 L
s
.64286 .27255 m
.64286 .2763 L
s
.69048 .27255 m
.69048 .2763 L
s
.7381 .27255 m
.7381 .2763 L
s
.83333 .27255 m
.83333 .2763 L
s
.88095 .27255 m
.88095 .2763 L
s
.92857 .27255 m
.92857 .2763 L
s
.25 Mabswid
0 .27255 m
1 .27255 L
s
gsave
1.025 .27255 -61 -10.5938 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 21.1875 translate 1 -1 scale
63.000 13.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(L) show
69.125 13.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .02448 m
.03006 .02448 L
s
[(-2.75)] .01131 .02448 1 0 Mshowa
.02381 .10717 m
.03006 .10717 L
s
[(-2.5)] .01131 .10717 1 0 Mshowa
.02381 .18986 m
.03006 .18986 L
s
[(-2.25)] .01131 .18986 1 0 Mshowa
.02381 .35524 m
.03006 .35524 L
s
[(-1.75)] .01131 .35524 1 0 Mshowa
.02381 .43794 m
.03006 .43794 L
s
[(-1.5)] .01131 .43794 1 0 Mshowa
.02381 .52063 m
.03006 .52063 L
s
[(-1.25)] .01131 .52063 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(-1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04101 m
.02756 .04101 L
s
.02381 .05755 m
.02756 .05755 L
s
.02381 .07409 m
.02756 .07409 L
s
.02381 .09063 m
.02756 .09063 L
s
.02381 .12371 m
.02756 .12371 L
s
.02381 .14024 m
.02756 .14024 L
s
.02381 .15678 m
.02756 .15678 L
s
.02381 .17332 m
.02756 .17332 L
s
.02381 .2064 m
.02756 .2064 L
s
.02381 .22294 m
.02756 .22294 L
s
.02381 .23947 m
.02756 .23947 L
s
.02381 .25601 m
.02756 .25601 L
s
.02381 .28909 m
.02756 .28909 L
s
.02381 .30563 m
.02756 .30563 L
s
.02381 .32217 m
.02756 .32217 L
s
.02381 .3387 m
.02756 .3387 L
s
.02381 .37178 m
.02756 .37178 L
s
.02381 .38832 m
.02756 .38832 L
s
.02381 .40486 m
.02756 .40486 L
s
.02381 .4214 m
.02756 .4214 L
s
.02381 .45447 m
.02756 .45447 L
s
.02381 .47101 m
.02756 .47101 L
s
.02381 .48755 m
.02756 .48755 L
s
.02381 .50409 m
.02756 .50409 L
s
.02381 .53717 m
.02756 .53717 L
s
.02381 .5537 m
.02756 .5537 L
s
.02381 .57024 m
.02756 .57024 L
s
.02381 .58678 m
.02756 .58678 L
s
.02381 .00794 m
.02756 .00794 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -75.25 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 21.1875 translate 1 -1 scale
63.000 13.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(LogV) show
87.500 13.313 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.17513 0 m
.19174 .0745 L
.22736 .19065 L
.26161 .27282 L
.29806 .33663 L
.33316 .38154 L
.37046 .41712 L
.4064 .44342 L
.44097 .46372 L
.47775 .48157 L
.51316 .49618 L
.54722 .50847 L
.58347 .52013 L
.61837 .53026 L
.65547 .54009 L
.69121 .54883 L
.72558 .55666 L
.76216 .56447 L
.79738 .57155 L
.8348 .57866 L
.87086 .58516 L
.90556 .59112 L
.94246 .59718 L
.97619 .60249 L
s
[ .04 .04 ] 0 setdash
.11905 .27255 m
.15382 .31726 L
.19174 .35403 L
.22736 .38166 L
.26161 .404 L
.29806 .42449 L
.33316 .44178 L
.37046 .45814 L
.4064 .47231 L
.44097 .48474 L
.47775 .49687 L
.51316 .50767 L
.54722 .51733 L
.58347 .52695 L
.61837 .53564 L
.65547 .54433 L
.69121 .55224 L
.72558 .55945 L
.76216 .56675 L
.79738 .57345 L
.8348 .58023 L
.87086 .58648 L
.90556 .59225 L
.94246 .59814 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012Q000`40O003h00OogOj/GOj003oMoZa
MoX00?mgn[5gnP00ogOj/GOj003oMoZaMoX0035gnP03001gnWOj03AgnP03001gnWOj0?mgnTIgnP00
<GOj00<007OjMoX0=7Oj00<007OjMoX0ogOjAWOj000aMoX00`00MoYgnP0eMoX00`00MoYgnP3oMoY5
MoX0035gnP8003IgnP03001gnWOj0?mgnTEgnP00<GOj00<007OjMoX0=GOj00<007OjMoX0ogOjAGOj
000aMoX00`00MoYgnP0eMoX00`00MoYgnP3oMoY5MoX000YgnPH000EgnP8000QgnP03001gnWOj00Ag
nP@000MgnP03001gnWOj03IgnP03001gnWOj0?mgnTAgnP002WOj00<007OjMoX00WOj00<007OjMoX0
0gOj0P0027Oj00<007OjMoX00gOj00<007OjMoX00WOj00<007OjMoX017Oj00<007OjMoX0=WOj00<0
07OjMoX0ogOjA7Oj000;MoX00`00MoYgnP0AMoX00`00MoYgnP08MoX00`00MoYgnP04MoX00`00MoYg
nP0fMoX00`00MoYgnP3oMoY4MoX000agnP03001gnWOj015gnP03001gnWOj00MgnP03001gnWOj00Ag
nP<003IgnP03001gnWOj0?mgnTAgnP0000=gnP00000010001WOj00<007OjMoX047Oj00<007OjMoX0
1gOj00<007OjMoX017Oj00<007OjMoX0=gOj00<007OjMoX0ogOj@gOj000>MoX00`00MoYgnP0?MoX0
0`00MoYgnP03MoX40007MoX00`00MoYgnP0gMoX00`00MoYgnP3oMoY3MoX000YgnP03001gnWOj009g
nP03001gnWOj00mgnP03001gnWOj009gnP03001gnWOj00QgnP03001gnWOj03MgnP03001gnWOj0?mg
nT=gnP002WOj00<007OjMoX00WOj00<007OjMoX02WOj00<007OjMoX00WOj00<007OjMoX00WOj00<0
07OjMoX027Oj00<007OjMoX0=gOj00<007OjMoX0ogOj@gOj000;MoX4000=MoX60004MoX50006MoX0
0`00MoYgnP0hMoX00`00MoYgnP3oMoY2MoX0035gnP8003UgnP03001gnWOj0?mgnT9gnP00<GOj00<0
07OjMoX0>7Oj00<007OjMoX0ogOj@WOj000aMoX00`00MoYgnP0hMoX00`00MoYgnP3oMoY2MoX0035g
nP03001gnWOj03UgnP03001gnWOj0?mgnT5gnP00<GOj00<007OjMoX0>GOj00<007OjMoX0ogOj@GOj
000aMoX00`00MoYgnP0iMoX00`00MoYgnP3oMoY1MoX0035gnP8003YgnP03001gnWOj0?mgnT5gnP00
<GOj00<007OjMoX0>WOj00<007OjMoX0ogOj@7Oj000aMoX00`00MoYgnP0jMoX00`00MoYgnP3oMoY0
MoX0035gnP03001gnWOj03YgnP03001gnWOj0?mgnT1gnP00<GOj00<007OjMoX0>WOj00<007OjMoX0
ogOj@7Oj000aMoX00`00MoYgnP0kMoX00`00MoYgnP3oMoXoMoX0035gnP8003agnP03001gnWOj0?mg
nSmgnP00<GOj00<007OjMoX0>gOj00<007OjMoX0ogOj?gOj000aMoX00`00MoYgnP0lMoX00`00MoYg
nP3oMoXnMoX0035gnP03001gnWOj03agnP03001gnWOj0?mgnSignP00<GOj00<007OjMoX0?7Oj00<0
07OjMoX0ogOj?WOj000aMoX00`00MoYgnP0mMoX00`00MoYgnP3oMoXmMoX0035gnP8003ignP03001g
nWOj0?mgnSegnP00<GOj00<007OjMoX0?GOj00<007OjMoX0ogOj?GOj000aMoX00`00MoYgnP0mMoX0
0`00MoYgnP3oMoXmMoX001=gnPH000EgnP8000IgnP@000MgnP03001gnWOj03ignP03001gnWOj0?mg
nSagnP004gOj00<007OjMoX00WOj00<007OjMoX00gOj0P001GOj00<007OjMoX00WOj00<007OjMoX0
17Oj00<007OjMoX0?WOj00<007OjMoX0ogOj?7Oj000DMoX00`00MoYgnP0CMoX00`00MoYgnP04MoX0
0`00MoYgnP0nMoX00`00MoYgnP3oMoXlMoX001EgnP03001gnWOj019gnP03001gnWOj00AgnP<003mg
nP03001gnWOj0?mgnS]gnP002WOj1P001WOj00<007OjMoX04GOj00<007OjMoX017Oj00<007OjMoX0
?gOj00<007OjMoX0ogOj>gOj000GMoX00`00MoYgnP0<MoX40007MoX00`00MoYgnP0oMoX00`00MoYg
nP3oMoXkMoX001=gnP03001gnWOj009gnP03001gnWOj00]gnP03001gnWOj00QgnP03001gnWOj041g
nP03001gnWOj0?mgnSYgnP004gOj00<007OjMoX00WOj00<007OjMoX02gOj00<007OjMoX027Oj00<0
07OjMoX0@7Oj00<007OjMoX0ogOj>WOj000DMoX4000>MoX50006MoX00`00MoYgnP10MoX00`00MoYg
nP3oMoXjMoX0035gnP80045gnP03001gnWOj0?mgnSYgnP00<GOj00<007OjMoX0@GOj00<007OjMoX0
ogOj>GOj000aMoX00`00MoYgnP11MoX00`00MoYgnP3oMoXiMoX0035gnP03001gnWOj045gnP03001g
nWOj0?mgnSUgnP00<GOj00<007OjMoX0@WOj00<007OjMoX0ogOj>7Oj000aMoX00`00MoYgnP12MoX0
0`00MoYgnP3oMoXhMoX0035gnP8004=gnP03001gnWOj0?mgnSQgnP00<GOj00<007OjMoX0@gOj00<0
07OjMoX0ogOj=gOj000aMoX00`00MoYgnP13MoX00`00MoYgnP3oMoXgMoX0035gnP03001gnWOj04=g
nP03001gnWOj0?mgnSMgnP00<GOj00<007OjMoX0@gOj00<007OjMoX0ogOj=gOj000aMoX00`00MoYg
nP14MoX00`00MoYgnP3oMoXfMoX0035gnP8004EgnP03001gnWOj0?mgnSIgnP00<GOj00<007OjMoX0
A7Oj00<007OjMoX0ogOj=WOj000aMoX00`00MoYgnP15MoX00`00MoYgnP3oMoXeMoX0035gnP03001g
nWOj04EgnP03001gnWOj0?mgnSEgnP00<GOj00<007OjMoX0AGOj00<007OjMoX0ogOj=GOj000aMoX0
0`00MoYgnP16MoX00`00MoYgnP3oMoXdMoX0035gnP8004MgnP03001gnWOj0?mgnSAgnP00<GOj00<0
07OjMoX0AWOj00<007OjMoX0ogOj=7Oj000aMoX00`00MoYgnP16MoX00`00MoYgnP3oMoXdMoX000Yg
nPH000EgnP8000EgnPH000AgnP@000MgnP03001gnWOj04MgnP03001gnWOj0?mgnS=gnP002WOj00<0
07OjMoX00WOj00<007OjMoX00gOj0P001GOj00<007OjMoX00WOj00D007OjMoYgnP0000AgnP03001g
nWOj00AgnP03001gnWOj04MgnP03001gnWOj0?mgnS=gnP002gOj00<007OjMoX03gOj00<007OjMoX0
2WOj00<007OjMoX017Oj00<007OjMoX0AgOj00<007OjMoX0ogOj<gOj000<MoX00`00MoYgnP0?MoX0
0`00MoYgnP09MoX00`00MoYgnP04MoX00`00MoYgnP18MoX00`00MoYgnP3oMoXbMoX00003MoX00000
00@000IgnP03001gnWOj00mgnP03001gnWOj00QgnP03001gnWOj00AgnP<004QgnP03001gnWOj0?mg
nS9gnP003WOj00<007OjMoX03gOj00<007OjMoX00gOj10001gOj00<007OjMoX0B7Oj00<007OjMoX0
ogOj<WOj000:MoX00`00MoYgnP02MoX00`00MoYgnP0:MoX00`00MoYgnP02MoX00`00MoYgnP02MoX0
0`00MoYgnP08MoX00`00MoYgnP19MoX00`00MoYgnP3oMoXaMoX000YgnP03001gnWOj009gnP03001g
nWOj00YgnP03001gnWOj009gnP03001gnWOj009gnP03001gnWOj00QgnP03001gnWOj04UgnP03001g
nWOj0?mgnS5gnP002gOj10003WOj10001GOj1@001WOj00<007OjMoX0BWOj00<007OjMoX0ogOj<7Oj
000aMoX00`00MoYgnP1:MoX00`00MoYgnP3oMoX`MoX0035gnP8004]gnP03001gnWOj0?mgnS1gnP00
<GOj00<007OjMoX0BgOj00<007OjMoX0ogOj;gOj000aMoX00`00MoYgnP1;MoX00`00MoYgnP3oMoX_
MoX0035gnP03001gnWOj04agnP03001gnWOj0?mgnRignP00<GOj00<007OjMoX0C7Oj00<007OjMoX0
ogOj;WOj000aMoX00`00MoYgnP1<MoX00`00MoYgnP3oMoX^MoX0035gnP8004ignP03001gnWOj0?mg
nRegnP00<GOj00<007OjMoX0<gOj10001WOj0P001WOj100017Oj1P009GOj10001WOj0P001WOj1000
1WOj10009WOj10001WOj0P001WOj10001WOj10009WOj10001WOj0P001WOj10001GOj1000:gOj1000
1WOj0P001GOj1`005WOj000aMoX00`00MoYgnP0bMoX00`00MoYgnP02MoX00`00MoYgnP03MoX20005
MoX00`00MoYgnP02MoX01000MoYgnWOj0P000gOj00<007OjMoX08WOj00<007OjMoX00WOj00<007Oj
MoX00gOj0P001GOj00<007OjMoX00WOj00<007OjMoX01GOj00<007OjMoX097Oj00<007OjMoX00WOj
00<007OjMoX00gOj0P001GOj00<007OjMoX00WOj00<007OjMoX00WOj00<007OjMoX00WOj00<007Oj
MoX08WOj00<007OjMoX00WOj00<007OjMoX00gOj0P001GOj00<007OjMoX00WOj00D007OjMoYgnP00
00AgnP03001gnWOj02MgnP03001gnWOj009gnP03001gnWOj00=gnP8000QgnP03001gnWOj01MgnP00
<GOj00<007OjMoX0<WOj00<007OjMoX00WOj00<007OjMoX02WOj00<007OjMoX00WOj00<007OjMoX0
0WOj00<007OjMoX09WOj00<007OjMoX00WOj00<007OjMoX02WOj00<007OjMoX00WOj00<007OjMoX0
1GOj00<007OjMoX097Oj00<007OjMoX00WOj00<007OjMoX02WOj00<007OjMoX00WOj00<007OjMoX0
0WOj00<007OjMoX00WOj00<007OjMoX08WOj00<007OjMoX00WOj00<007OjMoX02WOj00<007OjMoX0
0WOj00D007OjMoYgnP0000AgnP03001gnWOj02MgnP03001gnWOj009gnP03001gnWOj00egnP03001g
nWOj01MgnP00<GOj00<007OjMoX0<WOj00<007OjMoX00WOj00<007OjMoX02WOj00<007OjMoX00WOj
00<007OjMoX00WOj0P009gOj00<007OjMoX00WOj00<007OjMoX02WOj00<007OjMoX00WOj00@007Oj
MoYgnPH002EgnP03001gnWOj009gnP03001gnWOj00YgnP03001gnWOj009gnP03001gnWOj009gnP80
00=gnP03001gnWOj029gnP03001gnWOj009gnP03001gnWOj00YgnP03001gnWOj009gnP05001gnWOj
MoX00004MoX00`00MoYgnP0WMoX00`00MoYgnP02MoX00`00MoYgnP0=MoX00`00MoYgnP0GMoX0035g
nP03001gnWOj039gnP03001gnWOj009gnP03001gnWOj00YgnP03001gnWOj009gnP03001gnWOj00=g
nP8002IgnP03001gnWOj009gnP03001gnWOj00YgnP03001gnWOj009gnP03001gnWOj009gnP04001g
nWOj000VMoX00`00MoYgnP02MoX00`00MoYgnP0:MoX00`00MoYgnP02MoX00`00MoYgnP02MoX00`00
MoX00002000UMoX00`00MoYgnP02MoX00`00MoYgnP0:MoX00`00MoYgnP02MoX00`00MoYgnP02MoX4
000ZMoX00`00MoYgnP02MoX00`00MoYgnP0=MoX00`00MoYgnP0GMoX0035gnP8003=gnP03001gnWOj
009gnP03001gnWOj00YgnP03001gnWOj009gnP03001gnWOj00=gnP03001gnP0002EgnP03001gnWOj
009gnP03001gnWOj00YgnP03001gnWOj009gnP03001gnWOj009gnP04001gnWOj000VMoX00`00MoYg
nP02MoX00`00MoYgnP0:MoX00`00MoYgnP02MoX00`00MoYgnP02MoX00`00MoYgnP0WMoX00`00MoYg
nP02MoX00`00MoYgnP0:MoX00`00MoYgnP02MoX01@00MoYgnWOj000017Oj00<007OjMoX09gOj00<0
07OjMoX00WOj00<007OjMoX03GOj00<007OjMoX05gOj000aMoX00`00MoYgnP0bMoX00`00MoYgnP02
MoX00`00MoYgnP0:MoX00`00MoYgnP02MoX01@00MoYgnWOj00000WOj00<007Oj000097Oj00<007Oj
MoX00WOj00<007OjMoX02WOj00<007OjMoX00WOj00<007OjMoX00gOj00<007Oj00009WOj00<007Oj
MoX00WOj00<007OjMoX02WOj00<007OjMoX00WOj00<007OjMoX00gOj00<007OjMoX09WOj00<007Oj
MoX00WOj00<007OjMoX02WOj00<007OjMoX00WOj00D007OjMoYgnP0000AgnP03001gnWOj02MgnP03
001gnWOj009gnP03001gnWOj00egnP03001gnWOj01MgnP00<GOj00<007OjMoX0<WOj00<007OjMoX0
0WOj00<007OjMoX02WOj00<007OjMoX00WOj00D007OjMoYgnP00009gnP03001gnP0002AgnP03001g
nWOj009gnP03001gnWOj00YgnP03001gnWOj009gnP03001gnWOj00=gnP03001gnP0002IgnP03001g
nWOj009gnP03001gnWOj00YgnP03001gnWOj009gnP03001gnWOj00AgnP03001gnWOj02EgnP03001g
nWOj009gnP03001gnWOj00YgnP03001gnWOj009gnP05001gnWOjMoX00004MoX00`00MoYgnP0WMoX0
0`00MoYgnP02MoX00`00MoYgnP0;MoX3000IMoX0035gnP03001gnWOj03=gnP@000ignP@000EgnP@0
02IgnP@000ignP@000MgnP8002MgnP@000ignP@000QgnP<002EgnP@000ignP@000EgnP@002]gnP@0
011gnP03001gnWOj01MgnP00<GOj00<007OjMoX0DGOj00<007OjMoX0ogOj:GOj000aMoX00`00MoYg
nP1AMoX00`00MoYgnP3oMoXYMoX0035gnP8005=gnP03001gnWOj0?mgnRQgnP00<GOj00<007OjMoX0
DWOj00<007OjMoX0ogOj:7Oj000aMoX00`00MoYgnP1BMoX00`00MoYgnP3oMoXXMoX0035gnP03001g
nWOj05=gnP03001gnWOj0?mgnQYgnPL000IgnP00<GOj00<007OjMoX0DgOj00<007OjMoX0ogOj77Oj
00D007OjMoYgnP0000IgnP00<GOj00<007OjMoX0E7Oj00<007OjMoX0ogOj6gOj00D007OjMoYgnP00
00IgnP00:7Ojo`00L0003WOj00D007OjMoYgnP0000IgnP00<GOj00<007OjMoX03WOj00<007OjMoX0
3gOj0P003gOj00<007OjMoX03gOj00<007OjMoX03WOj0P0047Oj00<007OjMoX03WOj00<007OjMoX0
3WOj00<007OjMoX03gOj00<007OjMoX03WOj00<007OjMoX03gOj00<007OjMoX03WOj00<007OjMoX0
3gOj00<007OjMoX03WOj00<007OjMoX03WOj00<007OjMoX03gOj00<007OjMoX03WOj00<007OjMoX0
3gOj00<007OjMoX03WOj00<007OjMoX03WOj00<007OjMoX05GOj00<007OjMoX027Oj000aMoX00`00
MoYgnP0RMoX00`00MoYgnP0NMoX00`00MoYgnP0?MoX00`00MoYgnP0`MoX00`00MoYgnP13MoX00`00
MoYgnP13MoX00`00MoYgnP12MoX00`00MoYgnP0EMoX00`00MoYgnP08MoX0035gnP03001gnWOj029g
nP03001gnWOj035gnP03001gnWOj0?mgnQUgnP03001gnWOj00QgnP00<GOj00<007OjMoX08gOj00<0
07OjMoX0<7Oj00<007OjMoX0ogOj5gOj1@0027Oj000aMoX00`00MoYgnP0TMoX00`00MoYgnP0`MoX0
0`00MoYgnP3oMoXSMoX0035gnP8002IgnP03001gnWOj02mgnP03001gnWOj0?mgnR=gnP00<GOj00<0
07OjMoX09WOj00<007OjMoX0;gOj00<007OjMoX0ogOj8WOj000aMoX00`00MoYgnP0WMoX00`00MoYg
nP0_MoX00`00MoYgnP3oMoXQMoX0035gnP03001gnWOj02MgnP03001gnWOj02mgnP03001gnWOj0?mg
nR5gnP00<GOj00<007OjMoX0:7Oj00<007OjMoX0;gOj00<007OjMoX0ogOj87Oj000aMoX00`00MoYg
nP0YMoX00`00MoYgnP0^MoX00`00MoYgnP3oMoXPMoX0035gnP8005agnP03001gnWOj0?mgnQmgnP00
<GOj00<007OjMoX0FgOj00<007OjMoX0ogOj7gOj000aMoX00`00MoYgnP1LMoX00`00MoYgnP3oMoXN
MoX0035gnP03001gnWOj05agnP03001gnWOj0?mgnQignP00<GOj00<007OjMoX0GGOj00<007OjMoX0
ogOj7GOj000aMoX00`00MoYgnP1NMoX00`00MoYgnP3oMoXLMoX0035gnP8005mgnP03001gnWOj0?mg
nQagnP00<GOj00<007OjMoX0GgOj00<007OjMoX0ogOj6gOj000aMoX00`00MoYgnP1OMoX00`00MoYg
nP3oMoXKMoX0035gnP03001gnWOj061gnP03001gnWOj0?mgnQYgnP00<GOj00<007OjMoX0<gOj00<0
07OjMoX0:WOj00<007OjMoX0ogOj6WOj000aMoX00`00MoYgnP0dMoX00`00MoYgnP0ZMoX00`00MoYg
nP3oMoXIMoX0035gnP8003IgnP03001gnWOj02YgnP03001gnWOj0?mgnQQgnP00<GOj00<007OjMoX0
=WOj00<007OjMoX0:WOj00<007OjMoX0ogOj5gOj000aMoX00`00MoYgnP0gMoX00`00MoYgnP0YMoX0
0`00MoYgnP3oMoXGMoX000YgnPL000AgnP8000QgnP03001gnWOj00AgnP@000MgnP03001gnWOj03Qg
nP03001gnWOj02UgnP03001gnWOj0?mgnQIgnP003GOj00<007OjMoX01GOj0P0027Oj00<007OjMoX0
0gOj00<007OjMoX00WOj00<007OjMoX017Oj00<007OjMoX0>GOj00<007OjMoX0:GOj00<007OjMoX0
ogOj5GOj000=MoX00`00MoYgnP0?MoX00`00MoYgnP08MoX00`00MoYgnP04MoX00`00MoYgnP0jMoX0
0`00MoYgnP0YMoX00`00MoYgnP3oMoXDMoX000egnP03001gnWOj011gnP03001gnWOj00MgnP03001g
nWOj00AgnP<003]gnP03001gnWOj02QgnP03001gnWOj0?mgnQAgnP0000=gnP00000010001WOj00<0
07OjMoX047Oj00<007OjMoX01gOj00<007OjMoX017Oj00<007OjMoX0?7Oj0P00:GOj00<007OjMoX0
ogOj4gOj000=MoX00`00MoYgnP0@MoX00`00MoYgnP03MoX40007MoX00`00MoYgnP0nMoX00`00MoYg
nP0WMoX00`00MoYgnP3oMoXBMoX000egnP03001gnWOj015gnP03001gnWOj009gnP03001gnWOj00Qg
nP03001gnWOj06UgnP03001gnWOj0?mgnQ5gnP002gOj0`003WOj00<007OjMoX00WOj00<007OjMoX0
0WOj00<007OjMoX027Oj00<007OjMoX0JGOj00<007OjMoX0ogOj4GOj000=MoX00`00MoYgnP0<MoX6
0004MoX50006MoX00`00MoYgnP1ZMoX00`00MoYgnP3oMoX@MoX0035gnP8006agnP03001gnWOj0?mg
nPmgnP00<GOj00<007OjMoX0K7Oj00<007OjMoX0ogOj3WOj000aMoX00`00MoYgnP1/MoX00`00MoYg
nP3oMoX>MoX0035gnP03001gnWOj06egnP03001gnWOj0?mgnPegnP00<GOj00<007OjMoX0KWOj00<0
07OjMoX0ogOj37Oj000aMoX00`00MoYgnP19MoX00`00MoYgnP0SMoX00`00MoYgnP3oMoX;MoX0035g
nP8004]gnP8002AgnP03001gnWOj0?mgnPYgnP00<GOj00<007OjMoX0C7Oj00<007OjMoX08WOj00<0
07OjMoX0ogOj2GOj000aMoX00`00MoYgnP1=MoX2000SMoX00`00MoYgnP3oMoX8MoX0035gnP03001g
nWOj04mgnP80029gnP03001gnWOj0?mgnPMgnP00<GOj00<007OjMoX0DGOj00<007OjMoX087Oj00<0
07OjMoX0ogOj1WOj000aMoX00`00MoYgnP1BMoX2000QMoX2003oMoX6MoX0035gnP8005EgnP03001g
nWOj021gnP03001gnWOj0?mgnP=gnP00<GOj00<007OjMoX0EGOj0P008GOj00<007OjMoX0ogOj0WOj
000aMoX00`00MoYgnP1iMoX00`00MoYgnP3oMoX1MoX0035gnP03001gnWOj07YgnP03001gnWOj0?mg
nP00<GOj00<007OjMoX0NgOj00<007OjMoX0oWOj000aMoX00`00MoYgnP1lMoX00`00MoYgnP3mMoX0
035gnP8007ignP800?egnP00<GOj00<007OjMoX0OgOj00<007OjMoX0nWOj000aMoX00`00MoYgnP1R
MoX00`00MoYgnP0KMoX2003jMoX001=gnPL000AgnP8000IgnP@000MgnP03001gnWOj06=gnP8001eg
nP03001gnWOj0?MgnP005WOj00<007OjMoX01GOj0P001GOj00<007OjMoX00WOj00<007OjMoX017Oj
00<007OjMoX0IGOj0P0077Oj00<007OjMoX0mWOj000FMoX00`00MoYgnP0AMoX00`00MoYgnP04MoX0
0`00MoYgnP1WMoX2000KMoX2003fMoX001IgnP03001gnWOj015gnP03001gnWOj00AgnP<006UgnP80
01]gnP03001gnWOj0?=gnP002WOj1P001WOj00<007OjMoX04GOj00<007OjMoX017Oj00<007OjMoX0
JgOj0P006WOj0P00lgOj000FMoX00`00MoYgnP0=MoX40007MoX00`00MoYgnP1]MoX3000IMoX00`00
MoYgnP3`MoX001IgnP03001gnWOj00egnP03001gnWOj00QgnP03001gnWOj08YgnP800?1gnP0057Oj
0`003gOj00<007OjMoX027Oj00<007OjMoX0S7Oj0P00kWOj000FMoX00`00MoYgnP0=MoX50006MoX0
0`00MoYgnP2>MoX00`00MoYgnP3[MoX0035gnP80091gnP800>]gnP00<GOj00<007OjMoX0TGOj00<0
07OjMoX0j7Oj000aMoX00`00MoYgnP1mMoX2000CMoX2003XMoX0035gnP03001gnWOj07mgnP8001=g
nP800>IgnP00<GOj00<007OjMoX0PGOj0P004gOj0P00i7Oj000aMoX00`00MoYgnP23MoX3000BMoX2
003RMoX0035gnP8008MgnP80019gnP800>1gnP00<GOj00<007OjMoX0R7Oj0`004GOj0P00gWOj000a
MoX00`00MoYgnP2NMoX2003LMoX0035gnP03001gnWOj0:1gnP800=YgnP00<GOj00<007OjMoX0XWOj
0`00egOj000aMoX00`00MoYgnP2UMoX2003EMoX0035gnP8009UgnP8000egnP800==gnP00<GOj00<0
07OjMoX0VWOj0`0037Oj0P00dGOj000aMoX00`00MoYgnP2MMoX2000<MoX2003?MoX0035gnP03001g
nWOj09mgnP<000]gnP800<egnP00<GOj00<007OjMoX0XWOj0`002WOj0`00bWOj000aMoX00`00MoYg
nP2UMoX2000;MoX30037MoX0035gnP800;IgnP@00<=gnP00<GOj00<007OjMoX0^GOj0`00`7Oj000a
MoX00`00MoYgnP2lMoX3002mMoX000YgnPL000AgnP8000EgnPH000AgnP@000MgnP03001gnWOj0;Ag
nP<000QgnP<00;YgnP003GOj00<007OjMoX01GOj0P001GOj00<007OjMoX00WOj00D007OjMoYgnP00
00AgnP03001gnWOj00AgnP03001gnWOj0;MgnP@000MgnP@00;IgnP003GOj00<007OjMoX03GOj00<0
07OjMoX02WOj00<007OjMoX017Oj00<007OjMoX0^gOj10001gOj0`00/gOj000=MoX00`00MoYgnP0>
MoX00`00MoYgnP09MoX00`00MoYgnP04MoX00`00MoYgnP2oMoX20008MoX3002`MoX00003MoX00000
00@000IgnP03001gnWOj00mgnP03001gnWOj00QgnP03001gnWOj00AgnP<00<5gnP8000UgnP<00:eg
nP003GOj00<007OjMoX047Oj00<007OjMoX00gOj10001gOj00<007OjMoX0cgOj1000ZGOj000=MoX0
0`00MoYgnP0<MoX00`00MoYgnP02MoX00`00MoYgnP02MoX00`00MoYgnP08MoX00`00MoYgnP3CMoX3
002VMoX000]gnP<000ignP03001gnWOj009gnP03001gnWOj009gnP03001gnWOj00QgnP03001gnWOj
0=IgnP<00:=gnP003GOj00<007OjMoX03GOj10001GOj1@001WOj00<007OjMoX0d7Oj10001GOj0`00
X7Oj000aMoX00`00MoYgnP3DMoX50003MoX4002LMoX0035gnP800=YgnP@000=gnP<009UgnP00<GOj
00<007OjMoX0gGOj0`000gOj1000UGOj000aMoX00`00MoYgnP3WMoX4002AMoX0035gnP03001gnWOj
0>]gnP@008egnP00<GOj00<007OjMoX0kGOj1`00R7Oj000aMoX00`00MoYgnP3_MoX90024MoX0035g
nP800?EgnPP0081gnP00<GOj00<007OjMoX0nGOj2000NgOj000aMoX00`00MoYgnP3oMoX2MoX4001g
MoX0035gnP03001gnWOj0?mgnPIgnP@007=gnP00<GOj00<007OjMoX0ogOj2WOj1P00KGOj000aMoX0
0`00MoYgnP3oMoX?MoX7001WMoX0035gnP800?mgnQAgnPT0065gnP00<GOj00<007OjMoX0ogOj5gOj
0`000WOj1000GGOj000aMoX00`00MoYgnP3oMoXPMoX5001HMoX0035gnP03001gnWOj0?mgnREgnPH0
059gnP00<GOj00<007OjMoX0ogOj:WOj1`00C7Oj000aMoX00`00MoYgnP3oMoX^MoX:0015MoX0035g
nP800?mgnS=gnPD00003MoX0000000@003mgnP00<GOj00<007OjMoX0ogOj?WOj1P00>GOj000UMoX7
0005MoX00`00MoYgnP3oMoY4MoX4000eMoX002QgnP03001gnWOj00IgnP03001gnWOj0?mgnTMgnPD0
035gnP00:7Oj00<007OjMoX01WOj00<007OjMoX0ogOjC7Oj2000:GOj000XMoX00`00MoYgnP06MoX0
0`00MoYgnP3oMoYAMoX:000RMoX001agnPH000IgnP03001gnWOj00IgnP<00?mgnWegnP00:7Oj00<0
07OjMoX01WOj00<007OjMoX0ogOjOGOj000XMoX00`00MoYgnP06MoX00`00MoYgnP3oMoYmMoX002Ig
nP<000QgnP03001gnWOj0?mgnWegnP00:7Oj00<007OjMoX01WOj00<007OjMoX0ogOjOGOj000aMoX0
0`00MoYgnP3oMoYmMoX00?mgn[5gnP00ogOj/GOj003oMoZaMoX00?mgn[5gnP00ogOj/GOj003oMoZa
MoX00?mgn[5gnP00ogOj/GOj003oMoZaMoX00?mgn[5gnP00ogOj/GOj003oMoZaMoX003=gnP@00?mg
nWYgnP00=gOj00<007OjMoX0ogOjMgOj000gMoX00`00MoYgnP3oMoYgMoX0021gnPL000AgnP@000Ag
nP<00003MoX007Oj00EgnP800?mgnW5gnP008WOj00D007OjMoYgnP0000=gnP03001gnWOj009gnP04
001gnWOj0003MoX20006MoX2003oMoYaMoX0029gnP05001gnWOjMoX00003MoX00`00MoYgnP02MoX0
1000MoYgnP0017Oj00<007OjMoX00gOj00@007OjMoX00?mgnW1gnP008WOj00D007OjMoYgnP0000=g
nP03001gnWOj009gnP04001gnWOj0004MoX00`00MoYgnP03MoX01000MoYgnP00ogOjL7Oj000RMoX0
0`00MoYgnP05MoX00`00MoYgnP02MoX01000MoYgnP000gOj0P0017Oj00<007OjMoX00WOj00<007Oj
MoX0ogOjKGOj000RMoX00`00MoYgnP06MoX40004MoX300000gOj00000003MoX00`00MoYgnP02MoX0
0`00MoYgnP3oMoY]MoX0029gnP03001gnWOj01MgnP03001gnWOj009gnP03001gnWOj0?mgnVegnP00
87Oj1@005WOj0`000WOj0`00ogOjKWOj003oMoZaMoX00?mgn[5gnP00ogOj/GOj003oMoZaMoX00?mg
n[5gnP00ogOj/GOj003oMoZaMoX00?mgn[5gnP00ogOj/GOj003oMoZaMoX00?mgn[5gnP00\
\>"],
  ImageRangeCache->{{{0, 431}, {265.875, 0}} -> {-0.0142298, -2.86892, \
0.000430562, 0.0123972}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 511}},
WindowSize->{562, 393},
WindowMargins->{{44, Automatic}, {27, Automatic}},
Magnification->1.5
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 50, 1, 42, "Input"],
Cell[1792, 54, 23162, 606, 279, 6482, 396, "GraphicsData", "PostScript", \
"Graphics"],
Cell[24957, 662, 130, 3, 41, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

