%%
%% This is file `rcdj.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% classes.dtx  (with options: `rcdj')
%%
%% This is a generated file.
%%
%% Copyright 1993 1994 1995 1996 1997
%% The LaTeX3 Project and any individual authors listed elsewhere
%% in this file.
%%
%% For further copyright information, and conditions for modification
%% and distribution, see the file legal.txt, and any other copyright
%% notices in this file.
%%
%% This file is part of the LaTeX2e system.
%% ----------------------------------------
%%   This system is distributed in the hope that it will be useful,
%%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
%%
%%   For error reports concerning UNCHANGED versions of this file no
%%   more than one year old, see bugs.txt.
%%
%%   Please do not request updates from us directly.  Primary
%%   distribution is through the CTAN archives.
%%
%%
%% IMPORTANT COPYRIGHT NOTICE:
%%
%% You are NOT ALLOWED to distribute this file alone.
%%
%% You are allowed to distribute this file under the condition that it
%% is distributed together with all the files listed in manifest.txt.
%%
%% If you receive only some of these files from someone, complain!
%%
%%
%% Permission is granted to copy this file to another file with a
%% clearly different name and to customize the declarations in that
%% copy to serve the needs of your installation, provided that you
%% comply with the conditions in the file legal.txt.
%%
%% However, NO PERMISSION is granted to generate or to distribute a
%% modified version of this file under its original name.
%%
%% You are NOT ALLOWED to change this file.
%%
%%
%% MODIFICATION ADVICE:
%%
%% If you want to customize this file, it is best to make a copy of
%% the source file(s) from which it was produced.  Use a different
%% name for your copy(ies) and modify the copy(ies); this will ensure
%% that your modifications do not get overwritten when you install a
%% new release of the standard system.  You should also ensure that
%% your modified source file does not generate any modified file with
%% the same name as a standard file.
%%
%% You can then easily distribute your modifications by distributing
%% the modified and renamed copy of the source file, taking care to
%% observe the conditions in legal.txt; this will ensure that other
%% users can safely use your modifications.
%%
%% You will also need to produce your own, suitably named, .ins file to
%% control the generation of files from your source file; this file
%% should contain your own preambles for the files it generates, not
%% those in the standard .ins files.
%%
%% The names of the source files used are shown above.
%%
%%
%%
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
%%
%%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{rcdj}
              [1996/10/31 v01.002
 Standard LaTeX document class]
\newcommand\@ptsize{}
\newcounter{addressnumber}
\newif\if@restonecol
\newif\if@titlepage
\newif\if@graphics
\newif\if@frame
\@titlepagefalse
\def\received#1{\gdef\@received{#1}}
  \def\@received{\@latex@warning@no@line{ \noexpand\received}}
\def\journal#1{\gdef\@journal{#1}}
  \def\@journal{\@latex@warning@no@line{ \noexpand\journal}}
\def\doi#1{\gdef\@doi{#1}}
  \def\@doi{\@latex@warning@no@line{ \noexpand\doi}}
\def\smalltitle#1{\gdef\@smalltitle{#1}}
  \def\@smalltitle{\@latex@warning@no@line{ \noexpand\smalltitle given}}
\def\amsmsc#1{\gdef\@amsmsc{#1}}
  \def\@amsmsc{\@latex@warning@no@line{ \noexpand\amsmsc}}
\def\address#1#2{\addtocounter{addressnumber}{1}
     \expandafter\gdef\csname @address\alph{addressnumber}\endcsname
     {{\bf\normalsize#1}\smallskip\\
        \bf\scriptsize\ignorespaces #2\par}}
  \def\@address{\@latex@error{ \noexpand\address}\@ehc}
\long\def\acce#1{\gdef\@acce{#1}}
  \long\def\@acce{\@latex@error{ \noexpand\acce}\@ehc}
\def\dedicate#1{\gdef\@dedicate{#1}}
  \def\@dedicate{\@latex@warning@no@line{ \noexpand\dedicate}}

\if@compatibility\else
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\fi
\if@compatibility
  \renewcommand\@ptsize{0}
\else
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\fi
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\if@compatibility\else
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\fi
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{frame}{\@frametrue}
\if@compatibility\else
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\fi
\DeclareOption{titlepage}{\@titlepagetrue}
\DeclareOption{graph}{\@graphicstrue}
\if@compatibility\else
\DeclareOption{notitlepage}{\@titlepagefalse}
\fi
\if@compatibility\else
\DeclareOption{onecolumn}{\@twocolumnfalse}
\fi
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}%
}
\ExecuteOptions{a4paper,11pt,twoside,onecolumn,final}
\ProcessOptions
\input{size1\@ptsize.clo}
\input rcdfont.fd
%%%%%%%%
\oddsidemargin=-2.4mm
\evensidemargin=-8.4mm
\textwidth=170mm
\topmargin=-10.4mm
\textheight=239mm
\footskip=22pt
\parindent=2em
%%%%%%%%
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{2}
\renewcommand\topfraction{.7}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.3}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}
\def\@hrule{}
\def\@vrule{}
\if@frame
  \def\@vrule{\smash{\hbox to 0pt
       {\hss\rule[-1.1\textheight]{0.2pt}{1.2\textheight}\hss}}}%
  \def\@hrule{\hbox to 0pt
       {\hss\smash{\rule{1.05\textwidth}{0.2pt}\rlap{\rule{1cm}{0.2pt}}}}}%
\fi
\if@twoside
 \def\ps@headings{%
          \def\@@oddfoot{\hbox to
              \textwidth{\rcdsmall\rule{0pt}{12pt}\hfil\@journal\hfil\llap{\thepage}}}%
      \def\@oddfoot{\vtop to \headheight  {\hrule\@@oddfoot\vss}}%
          \def\@@evenfoot{\hbox to
              \textwidth{\rcdsmall\rlap{\thepage}\hfil\rule{0pt}{12pt}\@journal\hfil}}%
      \def\@evenfoot{\vtop to \headheight  {\hrule\@@evenfoot\vss}}%
          \def\@@evenhead{\hbox to \textwidth{%
          \@vrule\rlap{\smash{\raisebox{1mm}{\cfig{semblema}}}}\hfil
                   {\rcdsmall\@author}\strut\hfil\@vrule}}%
      \def\@evenhead{\vtop to \headheight  {\@@evenhead\hrule\vss}%
            \vtop to 0pt{\vskip\headsep\@hrule\vskip\textheight\@hrule\vss}}%
          \def\@@oddhead{\hbox to \textwidth{\@vrule\hfil
              {\rcdsmall\@smalltitle}\hfil\strut%
      \llap{\smash{\raisebox{1mm}{\cfig{semblema}}}}\@vrule}}%
      \def\@oddhead{\vtop to \headheight{\@@oddhead\hrule\vss}%
             \vtop to 0pt{\vskip\headsep\@hrule\vskip\textheight\@hrule\vss}}%
      \let\@mkboth\markboth
      \let\sectionmark\@gobble
      \let\subsectionmark\@gobble}
\else
  \def\ps@headings{%
    \let\@oddfoot\@empty
    \def\@oddhead{{\slshape\rightmark}\hfil{\rcdsmall\thepage}}%
    \let\@mkboth\markboth
    \def\sectionmark##1{%
      \markright {\MakeUppercase{%
        \ifnum \c@secnumdepth >\m@ne
          \thesection\quad
        \fi
        ##1}}}}
\fi
\def\ps@myheadings{%
    \let\@oddhead\@empty\let\@evenhead\@empty
          \def\@@oddfoot{\hbox to
       \textwidth{\rcdsmall\rule{0pt}{12pt}\hfil\@journal\hfil\llap{\thepage}}}%
      \def\@oddfoot{\vtop to \headheight  {\hrule\@@oddfoot\vss}}%
          \def\@@evenfoot{\hbox to
       \textwidth{\rcdsmall\rlap{\thepage}\hfil\rule{0pt}{12pt}\@journal\hfil}}%
      \def\@evenfoot{\vtop to \headheight  {\hrule\@@evenfoot\vss}}%
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble}
\if@titlepage
 \newcommand\maketitle{%
  \begin{titlepage}%
    \let\footnotesize\small
    \let\footnoterule\relax
    \let \footnote \thanks
    \null\vfil
    \vskip 60\p@
    \begin{center}%
      {\LARGE \@title \par}%
      \vskip 3em%
      {\large
      \lineskip .75em%
        \begin{tabular}[t]{c}%
          \@author
        \end{tabular}\par}%
      \vskip 1.5em%
    {\large \@date \par}%       % Set date in \large size.
  \end{center}\par
  \@thanks
  \vfil\null
  \end{titlepage}%
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\date\relax
  \global\let\and\relax
}
\else
\newcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@0em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{myheadings}\@thanks
 \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\date\relax
  \global\let\and\relax}
\newcounter{addressnum}
\def\theaddressnum{\alph{addressnum}}
\def\@maketitle{%
  \clearpage
  \null
   \let \footnote \thanks
   \renewcommand{\thefootnote}{}
   \footnotetext{Mathematics Subject Classification \@amsmsc}
   \parbox[t]{12cm}{%
     \loop\addtocounter{addressnum}{1}
         \expandafter\csname @address\theaddressnum\endcsname\vskip4mm
         \ifnum\value{addressnum}<\value{addressnumber}%
     \repeat}\hfill
   \raisebox{-11pt}[0pt][0pt]{\cfig{bemblema.eps}}
   \vskip-2mm 
   \begin{flushleft}%
         {\baselineskip20pt\rcdbig\@title\par}%
   \end{flushleft}
  {\par\footnotesize \it Received\ \@date} \hfill DOI: \@doi
  \vskip 2.5em
  \ifx\@empty\@acce
  \else
  \par\noindent\parbox{\textwidth}{\parindent=2em
                        \footnotesize
                        \hrule\vspace*{2mm}
                        \par\noindent\ignorespaces
                        \@acce
                        \vspace*{2mm}
                        \hrule}
   \fi
   \ifx\@empty\@dedicate
       \else
         \begin{flushright}
            \itshape{\@dedicate}
         \end{flushright}
   \fi
  \vskip 1em
 }
\fi
%%%%%%%%%
\setcounter{secnumdepth}{3}
\newcounter {part}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand \thepart {\@Roman\c@part}
\renewcommand \thesection {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection .\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
\newcommand\part{\par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}
\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >\m@ne
       \Large\bfseries \partname~\thepart
       \par\nobreak
     \fi
     \huge \bfseries #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 3ex
    \@afterheading}
\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}
%
\def\section{\@startsection{section}{1}{\z@}{3.5ex plus 1ex minus .2ex}
        {2.3ex plus.2ex}{\reset@font\Large\bf\raggedright\boldmath}}
\def\subsection{\@startsection{subsection}{2}{\z@}{2.75ex plus 1ex minus .2ex}
        {1.5ex plus.2ex}{\reset@font\large\bf\raggedright\boldmath}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}{2.25ex plus 1ex
        minus.2ex}{1.5ex plus.2ex}{\reset@font\normalsize\bf\raggedright\boldmath}}
\def\paragraph{\@startsection{paragraph}{4}{\parindent}{1.25ex plus 0.5ex
        minus.2ex}{-1em plus -.1em}{\normalfont\bfseries\boldmath}}
\def\subparagraph{\@startsection{subparagraph}{5}{\parindent}{0.75ex plus 0.5ex
        minus.2ex}{-0.75em plus -.1em}{\normalfont\normalsize\bfseries\boldmath}}
%%
\def\@aftersepkern{\kern-.5em}
\def\postsection{.\@aftersepkern}
\def\postsubsection{.\@aftersepkern}
\def\postsubsubsection{.\@aftersepkern}
\def\postparagraph{.\@aftersepkern}
\def\postsubparagraph{.\@aftersepkern}
\def\presection{}
\def\presubsection{}
\def\presubsubsection{}
\def\preparagraph{}
\def\presubparagraph{}
%%
%% sections...
%%
\def\@sect#1#2#3#4#5#6[#7]#8{\ifnum #2>\c@secnumdepth
 \let\@svsec\@empty\else\refstepcounter{#1}
  \edef\@svseca{\csname the#1\endcsname \csname post#1\endcsname%
  \@ifempty{#8}{\ }{\hskip1em}}%
   \def\@svsec{\csname pre#1\endcsname\@svseca}\fi
   \@tempskipa #5\relax\ifdim \@tempskipa>\z@
   \begingroup
       #6\relax\@hangfrom{\hskip#3\relax\@svsec}%
            {\interlinepenalty \@M \ignorespaces#8\par}%
   \endgroup
      \csname #1mark\endcsname{\protect\ignorespaces #7}%
\addcontentsline{toc}{#1}{\ifnum #2>\c@secnumdepth \else
    \protect\numberline{\csname pre#1\endcsname%
           \csname the#1\endcsname\csname post#1\endcsname}\fi
\protect\ignorespaces #7}%
   \else
        \def\@svsechd{#6\hskip #3\relax\@svsec #8\csname #1mark\endcsname
 {\protect\ignorespaces #7}\addcontentsline{toc}{#1}{%
  \ifnum #2>\c@secnumdepth
    \else
         \protect\numberline{\csname pre#1\endcsname%
           \csname the#1\endcsname\csname post#1\endcsname}%
    \fi\protect\ignorespaces #7}}\fi\@afterindentfalse\@xsect{#5}}
%%
\def\@ssect#1#2#3#4#5{\@tempskipa #3\relax
   \ifdim \@tempskipa>\z@
     \begingroup
       #4\@hangfrom{\hskip #1}{\interlinepenalty \@M\ignorespaces #5\par}
     \endgroup
   \else
     \def\@svsechd{#4\hskip #1\relax\ignorespaces #5}\fi\@afterindentfalse\@xsect{#3}}
%%
\long\def\caption#1{%
   \refstepcounter{figure}%
   \@ifempty{#1}{\hb@xt@\hsize{\hss{\small\fnum@figure}\hss}}
    {\setbox\@tempboxa\hbox{{\small\fnum@figure. #1}}
    \ifdim \wd\@tempboxa > \hsize%
       {\parbox[t]{\hsize}{{\small\mbox{\fnum@figure}. #1\par}}}%
    \else
       \hb@xt@\hsize{\hss\box\@tempboxa\hss}\fi}}
\if@twocolumn
  \setlength\leftmargini  {2em}
\else
  \setlength\leftmargini  {2.5em}
\fi
\leftmargin  \leftmargini
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\if@twocolumn
  \setlength\leftmarginv  {.5em}
  \setlength\leftmarginvi {.5em}
\else
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\fi
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
\if@titlepage
  \newenvironment{abstract}{%
      \titlepage
      \null\vfil
      \@beginparpenalty\@lowpenalty
      \begin{center}%
        \bfseries \abstractname
        \@endparpenalty\@M
      \end{center}}%
     {\par\vfil\null\endtitlepage}
\else
  \newenvironment{abstract}{%
      \if@twocolumn
        \section*{\abstractname}%
      \else
        \small
        \begin{center}%
          {\bfseries \abstractname\vspace{-.5em}\vspace{\z@}}%
        \end{center}%
        \quotation
      \fi}
      {\if@twocolumn\else\endquotation\fi}
\fi
\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}
\if@compatibility
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\z@
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
    }
\else
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\@ne
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
     \if@twoside\else
        \setcounter{page}\@ne
     \fi
    }
\fi
\newcommand\appendix{\par
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \renewcommand\theequation{\thesection.\@arabic\c@equation}
  \renewcommand\thesection{\@Alph\c@section}}
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand \theequation {%
  \ifnum \c@section >\z@
         \@arabic\c@section.\@arabic\c@equation
   \else 
         \@arabic\c@equation
   \fi}
\@addtoreset{equation}{section}
\newcounter{figure}
\renewcommand \thefigure {\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}
\renewcommand\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1. #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1. #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{0}
\newcommand\tableofcontents{%
  \clearpage\vspace*{5mm}
     \begin{flushleft}
        \rcdbig\MakeUppercase{\contentsname}
     \end{flushleft}
    \vspace*{7mm}
    \@starttoc{to}%
   }
\newcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty\@secpenalty
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \setlength\@tempdima{3em}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
       \if@compatibility
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
      \fi
    \endgroup
  \fi}
\newcommand{\eng}[3]{\addtocontents{to}{\contentsline{section}
  {{\mdseries\scshape\protect\ignorespaces #1}\protect\\%
    \protect\ignorespaces #2}{#3}}}
\newcommand*\l@section[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty\@secpenalty
    \addvspace{2.0em \@plus4\p@\@minus2pt}%
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      #1\nobreak\mdseries\leaders\hb@xt@0.8em{\hss.\hss}\hfil
                 \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
    \endgroup
  \fi}
\newcommand*\l@subsection{\@dottedtocline{2}{1.5em}{2.3em}}
\newcommand*\l@subsubsection{\@dottedtocline{3}{3.8em}{3.2em}}
\newcommand*\l@paragraph{\@dottedtocline{4}{7.0em}{4.1em}}
\newcommand*\l@subparagraph{\@dottedtocline{5}{10em}{5em}}
\newcommand\listoffigures{%
    \section*{\listfigurename
      \@mkboth{\MakeUppercase\listfigurename}%
              {\MakeUppercase\listfigurename}}%
    \@starttoc{lof}%
    }
\newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand\listoftables{%
    \section*{\listtablename
      \@mkboth{%
          \MakeUppercase\listtablename}{\MakeUppercase\listtablename}}%
    \@starttoc{lot}%
    }
\let\l@table\l@figure
\newdimen\bibindent
\setlength\bibindent{0.5em}
\newenvironment{thebibliography}[1]
     {\section*{\begin{center}\refname\end{center}}%%
      \footnotesize
      \begin{multicols}{2}
      \def\author##1{{\em ##1}. }      
      \def\title##1{{##1}. }
      \def\journal{\@ifnextchar*{\@journala}{\@journalb}}
      \def\@journala*##1{##1 }
      \def\@journalb##1{##1. }
      \def\publisher{\@ifnextchar*{\@publishera}{\@publisherb}}
      \def\@publishera*##1{##1 }
      \def\@publisherb##1{##1. }
      \def\no##1{\No##1. }
      \def\year##1{##1. }
      \def\translation##1{(##1) }
      \def\volume##1{V.~##1. }
      \def\page##1{P.~\mbox{##1}.}
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000
        \sfcode`.=1000}
     {\def\@noitemerr
       {\@latex@warning{Environment `thebibliography' empty}}%
      \endlist
      \end{multicols}
      }
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty
\newcommand\@idxitem{\par\hangindent 40\p@}
\newcommand\subitem{\@idxitem \hspace*{20\p@}}
\newcommand\subsubitem{\@idxitem \hspace*{30\p@}}
\newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}
\newcommand\@makefntext[1]{%
    \parindent 1em%
    \noindent
    \hb@xt@1.8em{\hss\@makefnmark}#1}
\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\refname{References}
\newcommand\indexname{Index}
\newcommand\figurename{Fig.}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract}
\newcommand{\cotan}{\mathop{\rm cotan}\nolimits}
\newcommand{\cotanh}{\mathop{\rm cotanh}\nolimits}
\newcommand\today{}
\edef\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagestyle{headings}
\pagenumbering{arabic}
\if@twoside
  \tolerance=2000
  \hbadness=1500
  \flushbottom
\else
  \raggedbottom
\fi
\if@twocolumn
  \twocolumn
  \sloppy
  \flushbottom
\else
  \onecolumn
\fi

%%% definition cyrillic No 

\usepackage[T2A,OT1]{fontenc}
\usepackage{amsmath,amssymb}
\usepackage{multicol,wrapfig}
\usepackage{colordvi,verbatim}
\usepackage{rcdcom,rcdthm}
\usepackage[graph]{rcdgraph}

\DeclareRobustCommand{\No}{%
   \ifmmode{\nfss@text{{\fontencoding{T2A}\selectfont\textnumero}}}\else
        {\fontencoding{T2A}\selectfont\textnumero}\fi}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\renewcommand\proofname{Proof}

\rcdthmsep=\medskipamount
\newrcdthm{teo}{Theorem}
\newrcdthm{cla}{Claim}
\newrcdthm{hyp}{Hypotesis}
\newrcdthm{lem}{Lemma}
\newrcdthm{cor}{Corollary}
\newrcdthm{pro}{Proposition}
\newrcdthm{con}{Conjecture}
\newrcdthm[definition]{fed}{Definition}
\newrcdthm[remark]{rem}{Remark}
\newrcdthm[example]{com}{Comment}
\newrcdthm[example]{exl}{Example}
\newrcdthm[definition]{sta}{Statement}
\newrcdthm[example]{sol}{Solution}

\endinput
%%
%% End of file `rcdj.cls'.
%%
