%----------------------------------------------------------------------
% Abstract class 'caspy' for Python Conference Administration System
%
% CASPy - Python Conference Administration System
%
% Copyright (C) 2001-2003 Ray Osborn
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU Lesser General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU Lesser General Public License for more details.
%
% You should have received a copy of the GNU Lesser General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
% USA.
%----------------------------------------------------------------------
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{casabs}
[2003/05/25 v1.3 Abstract class for Conference Administration System]
\LoadClass[12pt,letterpaper]{article}

\usepackage{amssymb}
\usepackage{ifthen}

\setlength{\topskip}{0in}
\setlength{\headheight}{0in}
\setlength{\textheight}{9in}
\setlength{\textwidth}{6in}
\setlength{\oddsidemargin}{0in}
\providecommand{\thanks}{}
\renewcommand{\thanks}[1]{\footnote{#1}}
\renewcommand{\thempfootnote}{\fnsymbol{mpfootnote}}
\pagestyle{empty}

%Transfer argument of \title command to \CAS@title
\renewcommand{\title}[1]{\newcommand{\CAS@title}{#1}}

%Transfer argument of \author command to TeX commands
%of the form \author@n, with optional labels stored in \authorlabel@n
\newcounter{author}
\renewcommand{\author}[2][]
{
   \stepcounter{author}
   \@namedef{author@\theauthor}{#2}
   \@namedef{authorlabel@\theauthor}{#1}
}

%Transfer argument of \address command to TeX commands
%of the form \address@n, with optional labels stored in \addresslabel@n
\newcounter{address}
\newcommand{\address}[2][]
{
   \stepcounter{address}
   \@namedef{address@\theaddress}{#2}
   \@namedef{addresslabel@\theaddress}{#1}
}

%Transfer argument of \contact commands to \CAS@contact
\newcommand{\contact}[1]{\newcommand{\CAS@contact}{#1}} 
\newcommand{\contactaddress}[1]{\newcommand{\CAS@address}{#1}}
\newcommand{\contactphone}[1]{\newcommand{\CAS@phone}{#1}}
\newcommand{\contactfax}[1]{\newcommand{\CAS@fax}{#1}}
\newcommand{\contactemail}[1]{\newcommand{\CAS@email}{#1}} 

%Determine preferred presentation from argument to \presentation command
\newcommand{\CAS@oralbox}%
   {\framebox{\rule[-1pt]{0pt}{9pt}\parbox{9pt}{\hfill}}}
\newcommand{\CAS@posterbox}%
   {\framebox{\rule[-1pt]{0pt}{9pt}\parbox{9pt}{\hfill}}}
\newcommand{\CAS@invitedbox}%
   {\framebox{\rule[-1pt]{0pt}{9pt}\parbox{9pt}{\hfill}}}
\newcommand{\presentation}[1]
{
   \ifthenelse{\equal{oral}{#1}}
   {
      \renewcommand{\CAS@oralbox}%
         {\framebox{\rule[-1pt]{0pt}{9pt}\parbox{9pt}{$\times$}}}
   }
   {\relax}
   \ifthenelse{\equal{poster}{#1}}
   {
      \renewcommand{\CAS@posterbox}%
         {\framebox{\rule[-1pt]{0pt}{9pt}\parbox{9pt}{$\times$}}}
   }
   {\relax}
   \ifthenelse{\equal{invited}{#1}}
   {
      \renewcommand{\CAS@invitedbox}%
         {\framebox{\rule[-1pt]{0pt}{9pt}\parbox{9pt}{$\times$}}}
   }
   {\relax}
}

%Transfer argument of \category command to \CAS@category
\newcommand{\category}[1]{\newcommand{\CAS@category}{#1}} 

%Transfer argument of \keywords command to \CAS@keywords
\newcommand{\keywords}[1]{\newcommand{\CAS@keywords}{#1}} 

%Define the abstract environment to output all the information collected
\renewenvironment{abstract}
{%Commands for the beginning of the abstract environment
   \begin{center}
      Abstract Submitted to the\\
      SCES '04 - The International Conference on Strongly Correlated Electron Systems\\
      Universit\"at Karlsruhe (TH)\\
      July 26-30, 2004\\
   \end{center}
   \vspace{3ex}
   \begin{minipage}[t][5in][t]{6in}
      \begin{center}
      \begin{large}
         \begin{bfseries} \CAS@title\\ \end{bfseries}
      \end{large}
      \vspace{1ex}
      \newcounter{c@author}
      \ifthenelse{\value{address}=1}
      {%No address references required if there is only one
         \@nameuse{author@1}%
         \stepcounter{c@author}%
         \whiledo{\value{c@author}<\value{author}}%
            {\stepcounter{c@author}, \@nameuse{author@\thec@author}}\\%
      }
      {%Add address references after the author's name
         \@nameuse{author@1}${}^{\ref{\@nameuse{authorlabel@1}}}$%
         \stepcounter{c@author}%
         \whiledo{\value{c@author}<\value{author}}%
            {\stepcounter{c@author}, \@nameuse{author@\thec@author}%
             ${}^{\ref{\@nameuse{authorlabel@\thec@author}}}$%
         }
      }
      \ifthenelse{\value{address}>0}
      {
         \ifthenelse{\value{address}=1}
         {%Output the address without any reference symbols
            {\slshape\small \@nameuse{address@1}}
         }
         {%Output the addresses as an enumerated list
            \newcounter{c@address}
            \begin{list}
               {{}$^{\arabic{c@address}}$}
               {\usecounter{c@address}%
                \setlength{\itemindent}{0pt}%
                \setlength{\itemsep}{0pt}%
                \setlength{\labelsep}{0.1in}%
                \setlength{\labelwidth}{0.2in}%
                \setlength{\leftmargin}{0.4in}
                \setlength{\parsep}{0pt}%
                \setlength{\rightmargin}{\leftmargin}
                \setlength{\topsep}{2pt}%
                \slshape\small}
               \whiledo{\value{c@address}<\value{address}}
               {
                  \item \label{\@nameuse{addresslabel@\thec@address}}%
                  \@nameuse{address@\thec@address}%
               }
            \end{list}
         }
      }
      {
         \relax
      }
      \end{center}
}
{%Commands for the end of the abstract environment
   \end{minipage}
   \rule{6in}{1pt}
   \begin{center}
   \ifthenelse{\equal{\CAS@keywords}{}}
   {\relax}   
   {{\slshape Keywords : }\CAS@keywords \\}
   \vspace{0.5ex}
   \ifthenelse{\equal{\CAS@category}{}}
   {\relax}   
   {{\slshape Category: }\CAS@category \\}
   \vspace{1ex}
   \begin{small}
   \begin{tabular}[t]{p{3in}r}
      Submitted : \today & Preferred presentation : oral \CAS@oralbox\\
                         & poster \CAS@posterbox\\
                         & invited \CAS@invitedbox\\
                         & \\
   \end{tabular}
   \framebox[6in]
   {
      \parbox[t]{3in}{\CAS@contact \\ \CAS@address}
      \parbox[t]{2.5in}{Email: \CAS@email \\
                        Tel: \CAS@phone \\
                        Fax: \CAS@fax}
   }
   \end{small}
   \end{center}
}
%%
%% End of file `casabs.cls'.
