%  Parts of this were taken from gtart.cls, by Colin Rourke, and from
%  amsart.cls 
% 
%%  Check for fairly recent version of latex2e :
%
\NeedsTeXFormat{LaTeX2e}[1994/12/01]
%
\LoadClass[12pt]{article} 
\usepackage{amsthm} 
\usepackage{amsmath} 
\pagestyle{headings}
%
%                *** hyperref stuff ***
%
\usepackage[bookmarks=false,pdfstartview=FitBH,dvips]{hyperref}  
%
%   \arxiv and \MR are for use in the biblio eg:
%   \arxiv{math.GT/0102334}  \MR{2002j:32027}
%
\def\qua{\stdspace}  %  useful abbreviation 
\def\arxiv#1{\texttt{\href{http://arxiv.org/abs/#1}{arXiv:#1}}}
\def\MR#1{\ignorespaces\qua\href{http://www.ams.org/mathscinet-getitem?mr=#1}{\textsc{mr}#1}}
\def\ZBL#1{ \href{http://www.emis.de/MATH-item?#1}{\textsc{zbl}#1}} 
%
%   \email and \urladdr are for use in addresses in the topmatter
%   (use \urladdr NOT \url as in non-hyperref version)
%
\def\email#1{\def\theasciiemail{#1}\gtemail{{\href{mailto:#1}{#1}}}}
\def\urladdr#1{\def\theasciiurl{#1}\gturl{\url{#1}}}
\let\emailaddress\email\let\emailaddr\email     % aliases
\let\urladdress\urladdr                         % alias
\def\gtemail#1{\def\theemail{#1}}
\def\gturl#1{\def\theurl{#1}}
\def\mailto#1{\href{mailto:#1}{#1}}
%
%  NOTE  these work only for single addresses. For multiple addresses 
%        use \gtemail and \gturl as in the following examples:
%
%     \gtemail{\mailto{cohen@math.lsu.edu}, \mailto{gdenham@uwo.ca},
%       \mailto{a.suciu@neu.edu}}
%     
%     \gturl{\url{http://www.math.lsu.edu/~cohen/},
%       \url{http://www.math.uwo.ca/~gdenham},
%       \url{http://www.math.neu.edu/~suciu/}}
%   
%  NOTE: all multiple email and URL commands in gtart.cls
%        are disabled.
%    
%   To get a general link use \url directly eg:
%    \url{http://ms.unimelb.edu.au/~snap}
%    this comes out \tt by default and treats ~'s correctly
%    You can also use \href{}{} to roll your own (eg to get a
%    different font) but note that the second parameter does
%    not treat ~'s correctly, which should be typed \char'176.
%
%    Automatically linked refs to GTP papers -- syntax is eg:
%    \gtref{Volnum}{Volyr}{Papernum}{Startpage}{Finpage}
%    eg:    \gtmrefl1{1998}{19}{383}{411}
%
%    Abbreviated versions:
%
\def\gtref#1#2#3#4#5{\href%
{http://www.maths.warwick.ac.uk/gt/GTVol#1/paper#3.abs.html}%
{Geom. Topol. \textbf{#1} (#2), #4--#5}}
\def\agtref#1#2#3#4#5{\href%
{http://www.maths.warwick.ac.uk/agt/AGTVol#1/agt-#1-#3.abs.html}%
{Algebr. Geom. Topol. \textbf{#1} (#2), #4--#5}}
\def\gtmref#1#2#3#4#5{\href%
{http://www.maths.warwick.ac.uk/gt/GTMon#1/paper#3.abs.html}%
{Geom. Topol. Monogr. \textbf{#1} (#2), #4--#5}}
%
%   Long versions:
%
\def\gtrefl#1#2#3#4#5{\href%
{http://www.maths.warwick.ac.uk/gt/GTVol#1/paper#3.abs.html}%
{Geometry and Topology #1 (#2) #4--#5}}
\def\agtrefl#1#2#3#4#5{\href%
{http://www.maths.warwick.ac.uk/agt/AGTVol#1/agt-#1-#3.abs.html}%
{Algebraic and Geometric Topology #1 (#2) #4--#5}}
\def\gtmrefl#1#2#3#4#5{\href%
{http://www.maths.warwick.ac.uk/gt/GTMon#1/paper#3.abs.html}%
{Geometry and Topology Monographs #1 (#2) #4--#5}}
%
%                  *** End of hyperref stuff ***
%
%  Basic layout :
%
\newskip\stdskip                      % standard vertical space
\stdskip=6.6pt plus3.3pt minus3.3pt    
%
% \flushbottom                           
\setlength{\parindent}{0pt}            
\setlength{\parskip}{\stdskip}
\setlength{\medskipamount}{\stdskip}
% \setlength{\mathsurround}{0.8pt}     
\setlength{\labelsep}{0.75em} 
% 
% from fullpage.sty: (but shrunk!) 
% 
\topmargin .25in
% \advance \topmargin by -\headheight
% \advance \topmargin by -\headsep
\textheight 7.9in
\oddsidemargin .25in
\evensidemargin \oddsidemargin
\marginparwidth 0.5in
\textwidth 6in
% \advance\hoffset by -3mm 	% for A4 
% \topmargin 0in
% 
\newcommand{\stdspace}{\hskip 0.75em plus 0.15em \ignorespaces}
% 
% GT-style theorem environments (using amsthm), but with:
% - periods after theorem heads
% - added `noname' environment (empty \thmname)
% 
\newtheoremstyle{plain}{14pt plus6.3pt minus6.3pt}{7.4pt plus3pt minus3pt}%
{\sl}{}{\bf}{.}{0.75em}{\thmname{#1}\thmnumber{ #2}\thmnote{\rm\stdspace(#3)}}
%
\newtheoremstyle{definition}{14pt plus6.3pt minus6.3pt}{7.4pt plus3pt minus3pt}%
{\rm}{}{\bf}{.}{0.75em}{\thmname{#1}\thmnumber{ #2}\thmnote{\sl\stdspace#3}}
%
\newtheoremstyle{remark}{14pt plus6.3pt minus6.3pt}{7.4pt plus3pt minus3pt}%
{\rm}{}{\bf}{.}{0.75em}{\thmname{#1}\thmnumber{ #2}\thmnote{\sl\stdspace#3}}
%
\newtheoremstyle{noname}{14pt plus6.3pt minus6.3pt}{7.4pt plus3pt minus3pt}%
{\rm}{}{\bf}{.}{0.75em}{\thmnumber{#2}\thmnote{\sl{ #3}}}
%
\renewenvironment{proof}[1][\proofname]{\par
  \normalfont
  \topsep\stdskip \trivlist
  \item[\hskip\labelsep\sl
    #1]\ignorespaces
}{%
  \qed\endtrivlist\par
}
\renewcommand{\proofname}{Proof.}
% 
%                 Knuth's \square macro :
%
\def\sqr#1#2{{\vcenter{\vbox{\hrule  height.#2pt
	\hbox{\vrule width.#2pt height#1pt \kern#1pt \vrule width.#2pt}
	\hrule height.#2pt}}}}
%
\def\sq{\sqr55}        %    A small square for end-of-proofs. 
\def\qedsymbol{$\sq$}  %   (Define other size squares by varing the
%                      %   the two numbers.)
% 
% Bold equation numbers (under amsmath) 
% 
  \def\tagform@#1{\maketag@@@{%
   \textbf{(\ignorespaces#1\unskip\@@italiccorr)}}}%
   \renewcommand{\eqref}[1]{\textup{\maketag@@@{(\ignorespaces%
	{\ref{#1}}\unskip\@@italiccorr)}}}
% 
% the following is adapted from amsart (for section headings) 
% 
\def\@startsection#1#2#3#4#5#6{%
 \if@noskipsec \leavevmode \fi
 \par \@tempskipa #4\relax
 \@afterindenttrue
 \ifdim \@tempskipa <\z@ \@tempskipa -\@tempskipa \@afterindentfalse\fi
 \if@nobreak \everypar{}\else
     \addpenalty\@secpenalty\addvspace\@tempskipa\fi
 \@ifstar{\@dblarg{\@sect{#1}{\@m}{#3}{#4}{#5}{#6}}}%
         {\@dblarg{\@sect{#1}{#2}{#3}{#4}{#5}{#6}}}%
}
%\def\@secnumfont{\mdseries}
\def\@secnumfont{\bfseries}
\def\@sect#1#2#3#4#5#6[#7]#8{%
  \edef\@toclevel{\ifnum#2=\@m 0\else\number#2\fi}%
  \ifnum #2>\c@secnumdepth \let\@secnumber\@empty
  \else \@xp\let\@xp\@secnumber\csname the#1\endcsname\fi
 \ifnum #2>\c@secnumdepth
   \let\@svsec\@empty
 \else
    \refstepcounter{#1}%
    \edef\@svsec{\ifnum#2<\@m
       \@ifundefined{#1name}{}{%  %% this empty slot is where section
			          %% symbol goes. 
         \ignorespaces\csname #1name\endcsname\space}\fi
       \@nx\textup{%
      \@nx\@secnumfont 
         \csname the#1\endcsname.}\enspace
    }%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@ % then this is not a run-in section heading
    \begingroup #6\relax
    \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty\@M #8\par}%
    \endgroup
    \ifnum#2>\@m \else \@tocwrite{#1}{#8}\fi
  \else
  \def\@svsechd{#6\hskip #3\@svsec
    \@ifnotempty{#8}{\ignorespaces#8\unskip
       \@addpunct.}%
    \ifnum#2>\@m \else \@tocwrite{#1}{#8}\fi
  }%
  \fi
  \global\@nobreaktrue
  \@xsect{#5}}
\let\@ssect\relax
\def\section{\@startsection{section}{1}%
  \z@{.7\baselineskip\@plus\baselineskip}{.5\baselineskip}%
  {\normalfont\bfseries\centering}} 
% 
% The following is adapted from amsart.cls (for table of contents) 
% 
\let\sectionname\@empty
\newdimen\baselineskip
\newcommand\newswitch[2][False]{%
  \expandafter\@ifdefinable\csname ?@#2\endcsname{%
    \global\expandafter\let\csname ?@#2\expandafter\endcsname
      \csname @#1\endcsname
  }%
}
\newcommand{\setFalse}[1]{%
  \expandafter\let\csname ?@#1\endcsname\@False
}
\newcommand{\setTrue}[1]{%
  \expandafter\let\csname ?@#1\endcsname\@True
}

\renewcommand{\@pnumwidth}{1.6em}
\renewcommand{\@tocrmarg}{2.6em}
\setcounter{tocdepth}{2}
\newswitch{toc}
\newcommand\contentsnamefont{\bfseries}
\def\@starttoc#1#2{\begingroup
  \setTrue{#1}%
  \par\removelastskip\vskip\z@skip
  \@startsection{}\@M\z@{\baselineskip\@plus\baselineskip}%
    {.5\baselineskip}{\centering\contentsnamefont}{#2}%
  \ifx\contentsname#2%
  \else \addcontentsline{toc}{section}{#2}\fi
  \makeatletter
  \@input{\jobname.#1}%
  \if@filesw
    \@xp\newwrite\csname tf@#1\endcsname
    \immediate\@xp\openout\csname tf@#1\endcsname \jobname.#1\relax
  \fi
  \global\@nobreakfalse \endgroup
  \addvspace{32\p@\@plus14\p@}%
  \let\tableofcontents\relax
}
\def\contentsname{Contents}
\def\tableofcontents{%
  \@starttoc{toc}\contentsname
}
\AtBeginDocument{%
  \@for\@tempa:=-1,0,1,2,3\do{%
    \@ifundefined{r@tocindent\@tempa}{%
      \@xp\gdef\csname r@tocindent\@tempa\endcsname{0pt}}{}%
  }%
}
\def\@writetocindents{%
  \begingroup
  \@for\@tempa:=-1,0,1,2,3\do{%
    \immediate\write\@auxout{%
      \string\newlabel{tocindent\@tempa}{%
        \csname r@tocindent\@tempa\endcsname}}%
  }%
  \endgroup}
\AtEndDocument{\@writetocindents}

\let\indentlabel\@empty
\def\@tochangmeasure#1{\sbox\z@{#1}%
  \ifdim\wd\z@>\csname r@tocindent\@toclevel\endcsname\relax
    \@xp\xdef\csname r@tocindent\@toclevel\endcsname{\the\wd\z@}%
  \fi
}
\def\@toclevel{0}
\def\@tocline#1#2#3#4#5#6#7{\relax
  \ifnum #1>\c@tocdepth % then omit
  \else
    \par \addpenalty\@secpenalty\addvspace{#2}%
    \begingroup \hyphenpenalty\@M
    \@ifempty{#4}{%
      \@tempdima\csname r@tocindent\number#1\endcsname\relax
    }{%
      \@tempdima#4\relax
    }%
    \parindent\z@ \leftskip#3\relax \advance\leftskip\@tempdima\relax
    \rightskip\@pnumwidth plus4em \parfillskip-\@pnumwidth
    #5\leavevmode\hskip-\@tempdima #6\nobreak\relax
    \hfil\hbox to\@pnumwidth{\@tocpagenum{#7}\hspace{1pc}}\par
% {1pc} is right indentation 
    \nobreak
    \endgroup
  \fi}
\def\@tocpagenum#1{\hss{\mdseries #1}}
\def\@tocwrite#1{\@xp\@tocwriteb\csname toc#1\endcsname{#1}}
\def\@tocwriteb#1#2#3{%
  \begingroup
    \def\@tocline##1##2##3##4##5##6{%
      \ifnum##1>\c@tocdepth
      \else \sbox\z@{##5\let\indentlabel\@tochangmeasure##6}\fi}%
    \csname l@#2\endcsname{#1{\csname#2name\endcsname}{\@secnumber}{}}%
  \endgroup
  \addcontentsline{toc}{#2}%
    {\protect#1{\csname#2name\endcsname}{\@secnumber}{#3}}}
\def\l@section{\@tocline{1}{-\parskip}{1pc}{}{}} 
% {-\parskip} removes extra line spacing
% {1pc} is left indentation 
\newcommand{\tocsection}[3]{%     This command writes each toc entry 
  \indentlabel{\@ifnotempty{#2}{\ignorespaces#1 #2.\quad}}#3}
%% \def\l@subsection{\@tocline{2}{0pt}{1pc}{5pc}{}}
%% \let\tocsubsection\tocsection
%% \def\l@subsubsection{\@tocline{3}{0pt}{1pc}{7pc}{}}
%% \let\tocsubsubsection\tocsection
%% \let\l@paragraph\l@subsubsection
%% \let\tocparagraph\tocsection
%% \let\l@subparagraph\l@subsubsection
%% \let\tocsubparagraph\tocsection
%% \def\l@part{\@tocline{-1}{12pt plus2pt}{0pt}{}{\bfseries}}
%% \let\tocpart\tocsection
%% \def\l@chapter{\@tocline{0}{8pt plus1pt}{0pt}{}{}}
%% \let\tocchapter\tocsection
%% \newcommand{\tocappendix}[3]{%
%%   \indentlabel{#1\@ifnotempty{#2}{ #2}.\quad}#3}


% 
% headings and end matter (address, email only) 
% [note - pages are all odd in maxart, for some reason] 
% 
\renewcommand{\@oddhead}{\scriptsize \ifnum\count0 > \@ne
    \MakeUppercase{
    \ifodd\count0  \hfil \ifx\theshorttitle\relax \thetitle
      \else\theshorttitle\fi \hfil \thepage 
    \else \thepage \hfil \theauthors \hfil 
    \fi} \fi} 
%% \renewcommand{\@oddfoot}{\small \ifnum\count0 = \@ne 
%%     \hfil\sl {\tiny Version of \today}\fi}
\AtEndDocument{\par \nobreak \begingroup
  \footnotesize \interlinepenalty\@M
    \begingroup
      \par\addvspace\bigskipamount\indent
      \scshape\ignorespaces\theaddress\par
    \endgroup
    \begingroup
      \nobreak\indent{\slshape E-mail}\/:\space
      \ttfamily\theemail\par
    \endgroup
  \endgroup} 
%
%  Some useful abbreviations :
%
\newcommand{\co}{\colon\thinspace}    %  Colon with correct spacing for maps.
\newcommand{\np}{\newpage}            %  Forced page break (new page).
\newcommand{\nl}{\hfil\break}         %  New line.
\newcommand{\cl}{\centerline}         %  Centerline
%
%  Define the various ingredients of the title page and cope with
%  all reasonable alternative syntax including amsart and article
%  style :
%
\def\title{\let\\\par\@ifnextchar[\doubletitle\singletitle}
 \def\doubletitle[#1]#2{\def\thetitle{#2}\def\theshorttitle{#1}}
 \def\singletitle#1{\def\thetitle{#1}}
\def\shorttitle#1{\def\theshorttitle{#1}}
%
\def\author{\@ifnextchar[\doubleauthor\singleauthor}
\def\singleauthor#1{\edef\previousauthors{\theauthors}
 \ifx\theauthors\relax\def\theauthors{#1}\else
 \def\theauthors{\previousauthors\par#1}\fi}
\def\doubleauthor[#1]#2{\singleauthor{#2}}
\let\authors\author\let\secondauthor\author        % aliases
\def\shortauthors#1{\def\theshortauthors{#1}}
%
\def\address#1{{\let\newline\par\xdef\previousaddresses{\theaddress}}
 \ifx\theaddress\relax\def\theaddress{#1}\else
 \def\theaddress{\previousaddresses\par\vskip 2pt\par#1}\fi}
\let\addresses\address                             % alias
\def\secondaddress#1{{\let\newline\par\xdef\previousaddresses{\theaddress}}
 \ifx\theaddress\relax\def\theaddress{#1}\else
 \def\theaddress{\previousaddresses\par{\rm and}\par#1}\fi}   
%
\def\email#1{\edef\previousemails{\theemail}
 \ifx\theemail\relax\def\theemail{#1}\else
 \def\theemail{\previousemails\hskip 0.75em\relax#1}\fi}
\let\emails\email\let\emailaddress\email\let\emailaddr\email  % aliases
\def\secondemail#1{\edef\previousemails{\theemail}
 \ifx\theemail\relax\def\theemail{#1}\else
 \def\theemail{\previousemails\hskip 0.75em{\rm and}\hskip 0.75em
 \relax#1}\fi}
%
\def\url#1{\edef\previousurls{\theurl}
 \ifx\theurl\relax\def\theurl{#1}\else
 \def\theurl{\previousurls\hskip 0.75em\relax#1}\fi}
\let\urls\url\let\urladdress\url\let\urladdr\url      % aliases
\def\secondurl#1{\edef\previousurls{\theurl}
 \ifx\theurl\relax\def\theurl{#1}\else
 \def\theurl{\previousurls\hskip 0.75em{\rm and}\hskip 0.75em
 \relax#1}\fi}
%
\long\def\abstract#1\end#2#3\end#4%
{\expandafter\ifx\csname#2\endcsname\abstract
\long\gdef\theabstract{#1}\end{abstract}#3\end{#4}\else
\long\gdef\theabstract{#1\end{#2}#3}\end{abstract}\fi}
\def\endabstract{\relax}
%
\def\primaryclass#1{\def\theprimaryclass{#1}}
\let\subjclass\primaryclass                        % alias
\def\secondaryclass#1{\def\thesecondaryclass{#1}}
\def\keywords#1{\def\thekeywords{#1}}
%
%  Set \\ to \par and title page items to \relax to initialise macros :
%
\let\\\par\let\thetitle\relax\let\theauthors\relax
\let\theaddress\relax\let\theemail\relax\let\theurl\relax
\let\theabstract\relax\let\theprimaryclass\relax
\let\thesecondaryclass\relax\let\thekeywords\relax
%
%
\long\def\makeshorttitle{    % start of definition of \makeshorttitle

\vglue 0.2truein   % top margin

% title :
%
{\parskip=0pt\leftskip 0pt plus 1fil\def\\{\par\smallskip}{\large
\bf\thetitle}\par\medskip} 

\vglue 0.05truein 

% authors :
%
{\parskip=0pt\leftskip 0pt plus 1fil\def\\{\par}{\sc\theauthors}
\par\medskip}%
 
\vglue 0.03truein 

% % *commented out by max*
% % address(es) email's and URL's (with switches to detect whether the
% % optional items have been used) :
% %
% {\small\parskip=0pt
% {\leftskip 0pt plus 1fil\def\\{\par}{\sl\theaddress}\par}
% \ifx\theemail\relax\else  % email address?
% \vglue 5pt \def\\{\stdspace{\rm and}\stdspace} 
% \cl{Email:\stdspace\tt\theemail}\fi
% \ifx\theurl\relax\else    % URL given?
% \vglue 5pt \def\\{\stdspace{\rm and}\stdspace} 
% \cl{URL:\stdspace\tt\theurl}\fi\par}

% \vglue 10pt 
% {\small\leftskip 25pt\rightskip 25pt{\bf Abstract}\stdspace\theabstract

% {\bf AMS Classification}\stdspace\theprimaryclass
% \ifx\thesecondaryclass\relax\else; \thesecondaryclass\fi\par
% {\bf Keywords}\stdspace \thekeywords\par}
% \vglue 7pt

\ifx\theabstract\relax\else
\vglue 10pt 
{\small\leftskip 25pt\rightskip 25pt{\bf Abstract.}\stdspace\theabstract
\vglue 7pt}
\fi

}    % end of definition of \makeshorttitle
%
\let\maketitle\makeshorttitle      %% alias
%
%
%  A few definitions to adapt (or disable) various items from amsart 
%  style (not already covered above) :
%
\def\bysame{\leavevmode\hbox to3em{\hrulefill}\thinspace}
%
%   End of macros for basic title page layout
%
%
%   Some hacks to get various items of style correct :
%
%   Set footnotes in 10pt type:
%
\let\@footnote@\footnote
\def\footnote#1{\@footnote@{\small #1}}
\let\fnote\footnote    % useful abbreviation for \footnote
%
%  Set captions in 10pt type  (hack of excerpt from latex.ltx) :
%
\long\def\@caption#1[#2]#3{\par\addcontentsline{\csname
  ext@#1\endcsname}{#1}{\protect\numberline{\csname
  the#1\endcsname}{\ignorespaces #2}}\begingroup
    \@parboxrestore
    \small
    \@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
  \endgroup}
%
%  Command to suppress the colon in captions (hack from article.cls) :
%
\def\nocolon{%
\long\def\@makecaption##1##2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{##1##2}%
  \ifdim \wd\@tempboxa >\hsize
    ##1##2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}}
%
%
%  Set displayskips to correct values :
%
\let\@document@\document
\def\document{\@document@%
\setlength{\abovedisplayskip}{\stdskip}
\setlength{\belowdisplayskip}{\stdskip}}  
%
%
%  Get the biblio style correct (10pt with small gaps):
%
\let\@thebibliography@\thebibliography
\def\thebibliography#1 {\@thebibliography@{999}\small\parskip0pt % 
plus2pt\relax}
%
%
%  Get item spacing reasonable :
%
\let\@itemize@\itemize
\def\itemize{\@itemize@\parskip 0pt\relax}
\def\@listi{\leftmargin28.5pt\parsep 0pt\topsep 0pt 
 \itemsep4pt plus3pt minus2pt}
\let\@listI\@listi
\@listi
%
\def\items{\bgroup\itemize}             % for comptibility 
\def\enditems{\enditemize\egroup}       % with gtmacros 
\let\itemb\item                         % (plain tex format)
%
%  Get enumeration labels like plain or amstex :
%
\renewcommand{\labelenumi}{{\rm (\theenumi)}}
%
%  and spacing to match \itemize: 
%
\let\@enumerate@\enumerate
\def\enumerate{\@enumerate@\parskip 0pt\relax}
%
\endinput
%



