%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%% JHEP.cls 3.1.2 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% This file is Copyright JHEP 2002:  it can be freely distributed  but
%% NOT modified preserving its name, even in similar forms.
%% 
%% JHEP3.cls is a LaTeX2e class file used to typeset manuscripts in JHEP
%% style. It was written by F. Nesti as a (radical) modification of the
%% class `article.cls' from distribution 960601 of LaTeX2e.
%% 
%% For bugs, comments, suggestions email to nesti@medialab.sissa.it
%% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  ***:to do  **?:question  ...:to choose  XXX:to delete  ???:unknown %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{JHEP3} [2003/01/03 v3.1.2 LaTeX document class - F.N.]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\logo{\raisebox{-10.5\p@}{\hb@xt@85\p@{\special{psfile=JHEPlogo.eps}\hfil}}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%% NEW SWITCHES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newif\if@preprint\@preprinttrue		% DEFAULT IS PREPRINT!
\newif\if@draft   \@draftfalse			% DEFAULT IS NOT DRAFT
\newif\if@hyper   \@hypertrue			% DEFAULT IS HYPER
\newif\if@proc	  \@procfalse			% DEFAULT IS NOT PROC

%\newif\if@title\@titlefalse			%
\newif\if@author\@authorfalse			%
\newif\if@abstract\@abstractfalse		% FOR FRONTMATTER DECLARATIONS
\newif\if@keywords\@keywordsfalse		%
\newif\if@todotoc\@todotocfalse			%
\newif\if@rece\@recefalse			%
\newif\if@revi\@revifalse			%
\newif\if@acce\@accefalse			%
\newif\if@Jcopy\@Jcopyfalse			%
\newif\if@JHEP\@JHEPfalse			%
\newif\if@conf\@conffalse			%
\newif\if@Jspecialurl\@Jspecialurlfalse
%\newif\if@restonecol
\@twocolumnfalse

\if@compatibility
    \setlength\paperheight {297mm}%		% DEFAULT FOR LATEX209 IS a4
    \setlength\paperwidth  {210mm}%
\else						% CHOSE PAPER:
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}{\@OImess{}}		% IGNORED a5
\DeclareOption{b5paper}{\@OImess{}}		% IGNORED b5
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}{\@OImess{}}		% IGNORED landscape
\fi

\newcommand\@ptsize{1}                          % DEFAULT SIZE IS 11 PT

\DeclareOption{proceedings}{\@preprintfalse\@proctrue
			   \renewcommand\@ptsize{1}% PROCS: 11 PT
			   \AtBeginDocument{\@todotocfalse}}
\DeclareOption{published}{\@preprintfalse}

\DeclareOption{hyper}{\@hypertrue}	% HYPER IS 11 PT
%\DeclareOption{screen}{\@hypertrue}	% HYPER IS 11 PT
\DeclareOption{nohyper}{\@hyperfalse}	% PAPER IS ALSO 11 PT (v1.3)
\DeclareOption{paper}{\@hyperfalse}	% PAPER IS ALSO 11 PT
\DeclareOption{11pt}{\renewcommand\@ptsize{1}\ExecuteOptions{@FONT}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}\ExecuteOptions{@FONT}}
\if@compatibility\else                          % LATEX2.09 HAS NO 10PT 
\DeclareOption{10pt}{\renewcommand\@ptsize{0}\ExecuteOptions{@FONT}}% v1.4
\fi       				% CHOSEN TO FREE MEMORY LATER:
\DeclareOption{@FONT}{\if@preprint              % IF PREPRINT ALLOW ANY,
                        \else			% IF PROCEEDINGS OR PUBLISHED: 
%			\if@proc		% 
%			\renewcommand\@ptsize{0}\@NFmess{10pt}% ALWAYS 10PT
%			\else
			\renewcommand\@ptsize{1}\@NFmess{11pt}% ALWAYS 11PT
                        \fi%\fi
			}
                        
\if@compatibility\else
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}\fi
\DeclareOption{twoside}{\if@preprint\if@hyper\@OImess{ in hyper-mode}
				    \else\@twosidetrue\@mparswitchtrue\fi
			\else			% FOR PROCEED./PUBLIC.:
			\@OImess{ in published papers}
			\fi}
\DeclareOption{notoc}{\if@preprint		% to disable TOC
			\AtBeginDocument{\@todotocfalse}
			\else
			\if@proc\@OImess{ is automatic for proceedings}
			\else\@OImess{ in JHEP papers}\fi\fi}
\DeclareOption{draft}{\setlength\overfullrule{5pt}% EXTENDED DRAFT
	\newcount\hour\newcount\minute
	\hour=\time \divide\hour by60 \minute=\time
	{\multiply\hour by60 \global\advance\minute by-\hour}
	\edef\militarytime{\number\hour:\ifnum\minute<10 0\fi\number\minute}
	\let\old@eqnnum\@eqnnum
	\def\@eqnnum{\old@eqnnum\rlap{\kern\marginparsep
				\if@twocolumn\if@firstcolumn
				  \kern-2\marginparsep\kern-\columnwidth\
				  \llap\bgroup\else\bgroup\fi
				\else
				\if@twoside\ifodd\c@page
				  \kern-2\marginparsep\kern-\textwidth
				  \llap\bgroup\else\bgroup\fi
				\else\bgroup\fi				
				\fi
				\sf\scriptsize\@eqnlabel\egroup}%
				\gdef\@eqnlabel{}}
	\let\@eqnlabel\relax
	\def\math@note#1{\gdef\@eqnlabel{LAB: #1}}
	\def\norm@note#1#2{\special{}% SORRY AGAIN.
			 \ifinner{\ifdim\baselineskip=\z@% IN ARRAY..
					\baselineskip18\p@\fi%%
				\ifhmode%   ATTENTION TO RESTRICTED VMODE!
				\raisebox{.5\baselineskip}[\z@][\z@]{%
					\rlap{\sf\scriptsize #2}}%
				\else\vskip-\baselineskip%
				\raisebox{-.6\baselineskip}[\z@][\z@]{%
						\rlap{\sf\scriptsize #2}}%
				\fi}%
			 \else\marginpar{\raggedright\if@twoside\ifodd\c@page%
					\raggedleft\fi\fi\sf\scriptsize #1#2}%
			 \fi}%
	\AtBeginDocument{\newbox\drft@box\setbox\drft@box=\hbox{%
			\framebox[\textwidth]{\sf\small JHEP 3.1 DRAFT 
			\ttfamily(\cur@opt)\hfill\sf\bfseries\jobname\sf, 
			\today, \militarytime}}}
	\@drafttrue}

%\if@compatibility\else
%\DeclareOption{final}{\setlength\overfullrule{\z@}} % ***? NO FINAL?
%\fi
\DeclareOption{titlepage}{\@OImess{}}		% IGNORED
\if@compatibility\else
\DeclareOption{notitlepage}{\@OImess{}}		% IGNORED
\fi
\if@compatibility\else
\DeclareOption{onecolumn}{\@OImess{}}		% IGNORED
\fi
\DeclareOption{twocolumn}{\@OImess{}}		% IGNORED
\DeclareOption{leqno}{\@OImess{}}	%\input{leqno.clo}} IGNORED ...
\DeclareOption{fleqn}{\@OImess{}}	%\input{fleqn.clo}} IGNORED ...
\DeclareOption{openbib}{\@OImess{}}		% IGNORED


%%%%%%%%%%%%%%%%%%%%%%%%%%%%% MESSAGES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand\JHEP@mess[1]{\typeout{Class JHEP Message: \protect#1.}}%
\newcommand\JHEP@warn[1]{\ClassWarning{JHEP}{#1}}
\newcommand\JHEP@warnl[1]{\ClassWarningNoLine{JHEP}{#1}}
\newcommand\JHEP@igno[1]{\JHEP@warn{IGNORED \protect#1}}
\newcommand\JHEP@ignol[1]{\JHEP@warnl{IGNORED \protect#1}}
\newcommand\@OImess[1]{\JHEP@ignol{OPTION '\CurrentOption'#1}}
\newcommand\@NFmess[1]{\JHEP@mess{Normalsize set to #1}}
\newcommand\@ENVwarn[1]{\JHEP@warn{Please use \protect#1 in place 
						of LaTeX environment}}
%%%%%%%%%%%%%%%%%%%%%%%%%% PROCESS OPTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%
\ExecuteOptions{a4paper,oneside,hyper} %WERE ALSO 10pt,onecolumn
\ProcessOptions

%%%%%%%%%%%%%%%%%%%%%%%%%% REQUIRED PACKAGES %%%%%%%%%%%%%%%%%%%%%%%%%%
\RequirePackage{amssymb}
%\RequirePackage{cite}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% START CODE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\input{size1\@ptsize.clo}
\renewcommand{\baselinestretch}{1.1}\normalsize
\setlength\lineskip{1\p@}
\setlength\parindent{1.2\parindent}	% AT 12pt 1.5em BECOMES 1.8em=tocindent
\setlength\normallineskip{1\p@}
\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\widowpenalty 1000
\clubpenalty 1000

\setcounter{topnumber}{3}
\renewcommand\topfraction{.95} % default .7
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.6} %.2		% .6 ???***
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.05}
\renewcommand\floatpagefraction{1}
\setcounter{dbltopnumber}{3}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{1}

\textwidth  .72\paperwidth	% WIDTH OF TEXT, REMAINS .28% FOR MARGINS
%
\setlength\@tempdima{.76\paperheight}	% HEIGHT OF TEXT WITH FOOTNOTES
\divide\@tempdima\baselineskip		% EXCLUDING HEAD (AND FOOT)
\@tempcnta=\@tempdima			% rounded to integer (#lines-1)
\setlength\textheight{\@tempcnta\baselineskip}
\addtolength\textheight{\topskip}

\voffset -1in
\topmargin   .05\paperheight	% FROM TOP OF PAGE TO TOP OF HEADING (0=1inch)
\headheight  .02\paperheight	% HEIGHT OF HEADING BOX.
\headsep     .03\paperheight	% VERT. SPACE BETWEEN HEAD AND TEXT.
\footskip    .07\paperheight	% FROM END OF TEX TO BASE OF FOOTER. (40pt)

\marginparsep 9\p@		% HOR. SPACE BETWEEN TEXT AND MARGINAL NOTE
\marginparpush 6\p@		% MIN. VERT. SPACE BETWEEN MARGINAL NOTES

\hoffset -1in				% TO ADJUST WITH PAPER:
\if@twoside				% IF TWO-SIDED:
	\oddsidemargin .13\paperwidth	% LEFT MARGIN FOR ODD PAGES (10)
	\evensidemargin .15\paperwidth	% LEFT MARGIN FOR EVEN PAGES (30)
	\marginparwidth .10\paperwidth	% TEXTWIDTH OF MARGINALNOTES
	\reversemarginpar		% BECAUSE OF TITLEPAGE.
\else					% IF ONE-SIDED:
	\oddsidemargin .14\paperwidth	% LEFT MARGIN FOR ODD PAGES (20)
	\evensidemargin .14\paperwidth	% LEFT MARGIN FOR EVEN PAGES (20)
	\marginparwidth .11\paperwidth	% TEXTWIDTH OF MARGINALNOTES
\fi					%
%%%%%%%%%%%%%%%%%%%%%%% HYPER (AND DRAFT) STUFF %%%%%%%%%%%%%%%%%%%%%%%
%\let\textref\@gobble
%\if@hyper			% IF NOHYPER WE DO LESS DAMAGE AS POSSIBLE.***
\@ifundefined{pdfoutput}{}{\input pdfcolor.tex} % PDFTEX has \pdfoutput 

\bgroup\catcode`\#=12\gdef\hash{#}\egroup	% DEFINED \hash=#.
%\fi
\def\H@tilde{\string~}
\newcommand{\href}[2]{\rule{0pt}{0pt}\bgroup\let~\H@tilde
			\if@hyper\@ifundefined{pdfoutput}{%
				    \noexpand\special{html:<A href="#1">}%
				  }{%
				    \def\hash{}%
				    \pdfannotlink attr{%/C [0 .7 .9]
					/Border [0 0 0]} goto name{#1}%
					\pdfsetcolor{.9 .9 0 0}%
%
				  }\fi
			{#2}\rule{0pt}{0pt}\egroup
			\if@hyper\@ifundefined{pdfoutput}{%
				    \special{html:</A>}%
				  }{%
				    \Black\pdfendlink
				  }\fi
		     }

\newcommand{\name}[1]{\if@hyper\@ifundefined{pdfoutput}{%
				    \noexpand\special% NAME HAS NO TAGGED TEXT HERE.
					{html:<A name="#1">}\special{html:</A>}%
				  }{%
				    \pdfdest name{#1} fith%
				  }\fi
		     }
\newcommand{\base}[1]{\if@hyper\bgroup\let~\H@tilde
			\noexpand\special	% BASE HAS NO TAGGED TEXT.
			{html:<base href="#1">}\egroup\fi}
%------------------------------------------------------------------%
% SECTION TAGS and  THEIR REFERENCE IN TOC \d@t will be '.' for sections only
\if@hyper
\renewcommand{\@seccntformat}[1]{\name{sec\csname the#1\endcsname}%
				 \csname the#1\endcsname\d@t\hspace{1ex}}
\renewcommand{\numberline}[1]{\hb@xt@\@tempdima{\href
			      {\hash\hyp@typ#1}{#1}\d@t\hfil}}
\else
\renewcommand{\@seccntformat}[1]{\csname the#1\endcsname\d@t\hspace{1ex}}
\renewcommand{\numberline}[1]{\hb@xt@\@tempdima{#1\d@t\hfil}}
\fi
%------------------------------------------------------------------%
% CITATION TAGS ARE TOGETHER WITH BIB STUFF.
% CITATION HREF
\def\@citex[#1]#2{%			% UNFORTUNATELY REDEFINED!!!!
  \let\@citea\@empty
  \@cite{\@for\@citeb:=#2\do
    {\@citea\def\@citea{,\penalty\@m\ }%
     \edef\@citeb{\expandafter\@firstofone\@citeb}%
     \if@filesw\immediate\write\@auxout{\string\citation{\@citeb}}\fi
     \@ifundefined{b@\@citeb}{\mbox{\reset@font\bfseries ?}%
	\G@refundefinedtrue
	\@latex@warning
	  {Citation `\@citeb' on page \thepage \space undefined}}%
	{\edef\tmp@bn{\csname b@\@citeb\endcsname}%
	 \hbox{\href{\hash bib\tmp@bn}{\tmp@bn}}}}}{#1}%		% **HYPER**
	 \if@draft\norm@note{CIT: }{#2}\fi			% **DRAFT**
	 }

%-----------------------------------------------------------------%
% LABEL, REF AND PAGEREF, TEXTREF, ~ COMPATIBLE:
\let\old@label\label						% OLD LATEX COMMAND.
\def\label{\bgroup\catcode`\>=15\catcode`\"=15 \@@label}		
\newcommand{\@@label}[1]{\egroup\name{ref-#1}%		% LABEL IN HYPER TAG.
			 \old@label{#1}%		% 
			 \if@draft%			% DRAFT:
			 \ifmmode\math@note{#1}%
			 \else\norm@note{}{LAB: #1}\fi%
			 \fi%
			 }
\if@hyper
\let\old@ref\ref \let\old@pageref\pageref		% OLD LATEX COMMANDS.
\renewcommand{\ref}[1]{\@ifundefined{r@#1}{}{\href{\hash ref-#1}}%
		       {\old@ref{#1}}} % LABEL INSIDE HREF.
\renewcommand{\pageref}[1]{\@ifundefined{r@#1}{}{%	% UNDEFINED => NO HREF
	      \edef\tmp@ref{\noexpand\@secondoftwo\csname r@#1\endcsname}%
	      \href{\hash pag\tmp@ref}}{\old@pageref{#1}}}
\fi
\newcommand{\textref}[2]{\@ifundefined{r@#1}
			{%
			\protect\G@refundefinedtrue
			\nfss@text{\reset@font\bfseries ?#2?}%
   			\@latex@warning{Reference `#1' on page \thepage \space
				             undefined}}
			{\vrule height \z@ width \z@\href{\hash ref-#1}{#2}}}
%------------------------------------------------------------------%
%%%%%%%%%%%%%%%%%%%%%%%%%% END HYPER-STUFF %%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%% JHEP HEADINGS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\ps@JHEP{% 			
    \def\@oddfoot{\ifnum\thepage=0\ifnum\Jacce@year>2001\if@JHEP
		\Jcopyright@box\fi\hfill % copyright only on front page of published papers
		\if@Jspecialurl\unhbox\Jspecial@url\else\if@JHEP\unhbox\Jpaper@url\fi\fi\fi %possible url
		\else\reset@font\hfil-- \thepage\ --\hfil\fi} % page numbers on other pages
    \if@draft\edef\cur@opt{\@curroptions}\fi
    \def\@oddhead{\name{pag\thepage}\hfil\if@draft\copy\drft@box\fi}
    \if@proc
	\def\@oddhead{\name{pag\thepage}%
		      \smash{\if@draft\raise 2.5em\rlap{\copy\drft@box}\fi
		      	     \vbox{\hsize=\textwidth\noindent
			     \copy\conf@box\hfill
			     \copy\@firstaubox\vskip.17em \hrule}}%
		      }%
    \fi
    \if@twoside\let\@evenhead\@oddhead\let\@evenfoot\@oddfoot\fi
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
    }
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% TITLE PAGE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\maketitle{\JHEP@ignol{\maketitle}}
\newcommand\auto@maketitle{\begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{\hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \let\footnote\thanks%
	\newpage				%
	\if@proc				% IF PROCEEDINGS: 
	 \global\let\@nodocument\relax		% LaTeX FOULED:)
	\@maketitle				% 
	 \@thanks				% TITLE THANKS IN 1st COLUMN
	 \let\@evenfoot\@empty			% NO PAGENO.
 	 \let\@oddfoot\@empty
	 \setcounter{page}{1}%
	 \thispagestyle{empty}%			% PROCS HAVE NO PAGENUMBER
	\else
	 \@maketitle				% CALL ACTUAL FORMATTING
	 \@thanks				% TITLE THANKS
	 %\let\@evenfoot\@empty			% NO PAGENO.
 	 %\let\@oddfoot\@empty
	 \thispagestyle{JHEP} 
 	 \setcounter{page}\z@
	 \newpage				% FINE PAGINA
	\fi	
  \endgroup
  \setcounter{footnote}{0}%			
  \if@todotoc					% IF THERE IS A SECTION
      \noindent\rule\textwidth{.1pt}		% THEN MAKE TOC...
      \vskip 2em \@plus 3ex \@minus 3ex
      \tableofcontents
      \vskip 2em \@plus 3ex \@minus 3ex
      \noindent\rule\textwidth{.1pt}
      \vskip 2em \@plus 3ex \@minus 3ex
  \fi
  \if@preprint\else
  	\if@proc
	  \gdef\tableofcontents{\JHEP@igno{\tableofcontents\space there is no toc in proceedings}}
  	\else
	  \gdef\tableofcontents{\JHEP@igno{\tableofcontents\space is automatic}}
  	\fi
  \fi
  \global\let\thanks\@gobble
%  \setbox\@tmpbox=\vbox{\rm\@author}%		% FOR PROCS RESET HEADERS
%  \global\let\maketitle\relax			% NO LONGER EXISTS.
  \global\let\@maketitle\relax			%
  \global\let\@thanks\@empty			%
  \global\let\@author\@empty			% KILL ALL 
  \global\let\@date\@empty			%
  \global\let\@title\@empty			%
  \global\let\@abstract\@empty			%
  \global\let\title\relax			%
  \global\let\author\relax			%
  \global\let\date\relax			%
  \global\let\and\relax				%
  \global\let\email\@gobble
  \global\let\received\relax
  \global\let\revised\relax
  \global\let\accepted\relax
  \global\let\JHEPcopydate\relax
  \global\let\JHEPspecialurl\relax
  \global\let\keywords\relax
  \global\let\endkeywords\relax
}
%%%%%%%%%%%%%%%%%%%%%%%%%% ACTUAL TITLEPAGE %%%%%%%%%%%%%%%%%%%%%%%%%%%
\newskip\titlesk@pa \newskip\titlesk@ja		% Skips for titlepage
\newskip\titlesk@pb \newskip\titlesk@jb		%
\newskip\titlesk@pc \newskip\titlesk@jc		%
\newskip\titlesk@pd				%
\titlesk@pa= 1.6em plus .4em%			% Before title (papers)
\titlesk@pb= 2em   plus .06em minus  .5ex%	% Between title/rule
\titlesk@pc= 2em   plus .05em minus 1.2ex%	% Before authors
\titlesk@pd= 2em   plus .06em minus  .5ex%	% After proc rule      	 
\titlesk@ja= 1.6em plus .4fil%			% Before title (proceedings)
\titlesk@jb= 2em   plus .06fil minus  .5ex%	% Between title/rule
\titlesk@jc= 2em   plus .05fil minus 1.2ex%	% Before authors

\def\@maketitle{%				% PAGE IS FLUSHED LEFT
\begin{flushleft}%				% PAY ATTENTION TO \par'S
%header for preprints
\if@preprint					%%% PREPRINT HEADER: 
\vskip-7em					%
\underline{\tiny Preprint typeset 		%
                 in JHEP style -		%
  		\if@hyper{HYPER VERSION}	%
		\else{PAPER VERSION}\fi } 	%
\normalsize\hfill%				% *** MAYBE PUT IN A ZERO BOX
\begin{tabular}[t]{r}\@preprint\end{tabular}% % PREPRINT NUMBERS
\else						%
  % header for proceedings
  \if@proc					%%% PROCEEDINGS: LOGO ETC..
    \vskip-4.48em\hfill\copy\conf@box
    \vskip-.7\baselineskip\logo\hrulefill
    \vskip-.4\baselineskip\hskip32\p@%	        % *** IDEM BOXIZE
		{\tiny PROCEEDINGS}
  \else
  % 					        %%% PUBLISHED: LOGO  ETC..
  %header for published (after 2001)
    \ifnum\Jacce@year>2001
       \vskip-7em\hfill
       {\small\scshape Published by Institute of Physics 
	               Publishing for SISSA/ISAS}
       \vskip-.7\baselineskip\logo\hrulefill
       \vskip-1.5\baselineskip\hskip21.73\p@%	% *** IDEM BOXIZE
       \hfill{\parbox[t]{30em}{\begin{flushright}\setlength\baselineskip{11pt}\footnotesize
				\Jrece@cs\\
				\if@revi\Jrevi@cs\\\fi
				\Jacce@cs
			      \end{flushright}}}%
    \else
    % header for published (december 2001)  *** TO BE REMOVED IN JHEP4...
    \vskip-7em\hfill{\small\Jrece@cs{\it,\ }\Jacce@cs
    \vskip-.7\baselineskip\logo\hrulefill
    \vskip-.5\baselineskip\hskip23\p@%	% *** IDEM BOXIZE
 		{\tiny \if@hyper{HYPER VERSION}\else{PAPER VERSION}\fi}
    \if@revi\hfill\Jrevi@cs\fi}

    \fi
  \fi
\fi\null
% end headers
% title page: skips are different for procs (p) and jhep or preprints (j)
% see above
  \if@proc
   \vskip \titlesk@pa
  \else
   \vskip \titlesk@ja		   % vspace before title
  \fi
% TITLE 
  {\LARGE \sffamily                
        \bfseries                  
        \@title\par}%                large sans-serif bf
  \if@proc
    \vskip \titlesk@pb             
  \else
    \vskip \titlesk@jb             % vspace between title and rule
  \fi
  \if@proc
% RULE
    \hrule height \p@%               for proc = 1pt
  \else
    \hrule height 1.5\p@%            otherwise = 1.5pt.
  \fi
  \if@proc
    \vskip \titlesk@pb             
  \else
    \vskip \titlesk@jb		   % vspace between rule and authors
  \fi
% AUTHORS\\ADDRESSES
  \vskip-\auth@skip
  {\normalsize \bfseries \sffamily
	\@author \par}                            
  \if@proc
    \vskip \titlesk@pc
  \else
    \vskip \titlesk@jc             % vspace between authors and abstract
  \fi
% ABSTRACT IF PRESENT (SHOULD)
  \if@proc
    \centerline{\parbox{.9\textwidth}%	% narrower abstract for proceedings
		    {\abstract@cs}}%
  \else
    \parbox\textwidth{\abstract@cs}%	
  \fi
  \normalsize
% KEYWORDS IF PRESENT
  \if@keywords	
    \if@proc
	\vskip \titlesk@pc	   
    \else
	\vskip .9\titlesk@jc	   % vspace between abstract and keywords
    \fi
    \par
    \@keywords				
  \fi
% DEDICATION, IF PRESENT
  \dedic@box				
% RULE (only for procs)
  \if@proc
    \vskip \titlesk@pb
    \hrule height 1\p@
    \vskip \titlesk@pd
  \fi
\end{flushleft}%			% FINISHED.
}
%%%%%%%%%%%%%%%%%%%%%%%%%%% STANDARD STUFF %%%%%%%%%%%%%%%%%%%%%%%%%%%%
\setcounter{secnumdepth}{3}
\newcounter {part}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand\thepart         {\@Roman\c@part}
\renewcommand\thesection      {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection.\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
%%%%%%%%%%%%%%%%%%%%%%%%%%% SECTION FORMATS %%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand\secstyle{\bfseries}
\def\ts@flag{\let\d@t.%					% Sections get ``.''
	     \immediate\write\@auxout			% IF THERE IS A SECTION
	     {\string\global\string\@todotoctrue}}	% THEN SIGNAL IN AUX.

\newcommand\part{\par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}

\def\@part[#1]#2{\ts@flag
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%			% DAMN LATEX !!! BELOW,
      \addcontentsline{toc}{part}{\string\href	% UNFORTUNATELY, NO NUMBERLINE:
				  {\string\hash\space part\the\c@part}%
				  {\thepart}\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >\m@ne
       \name{part\the\c@part}\Large\bfseries \partname~\thepart
       \par\nobreak
     \fi
     \huge \bfseries #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 3ex
    \@afterheading\let\d@t\relax}
\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}

\newcommand\section{\@startsection{section}{1}{\z@}%
                                   {-3.5ex \@plus -1.3ex \@minus -.7ex}%
                                   {2.3ex \@plus.4ex \@minus .4ex}%
                                   {\normalfont\large\secstyle}}
\newcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                   {-2.3ex\@plus -1ex \@minus -.5ex}%
                                   {1.2ex \@plus .3ex \@minus .3ex}%
                                   {\normalfont\normalsize\secstyle}}
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                   {-2.3ex\@plus -1ex \@minus -.5ex}%
                                   {1ex \@plus .2ex \@minus .2ex}%
                                   {\normalfont\normalsize\secstyle}}
\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                   {1.75ex \@plus1ex \@minus.2ex}%
                                   {-1em}%
                                   {\normalfont\normalsize\bfseries}}
\newcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                   {1.75ex \@plus1ex \@minus .2ex}%
                                   {-1em}%
                                   {\normalfont\normalsize\bfseries}}

% ---- turnaround for sections with figures ------ %
\def\bef@sec{\iffigprocessing\JHEP@warnl{Floating figure \the\ffigcount\space
						and startsection colliding}\fi
	     \iftabprocessing\JHEP@warnl{Floating table \the\ftabcount\space
						and startsection colliding}\fi
	     \edef\bef@everypar{\the\everypar}}	% HACK FOR FLOATS AND \everypar
\def\aft@sec{\let\d@t\relax			% RESTORE: NO DOTTED SUBSECS..
	     \edef\tmp@everypar{\the\everypar}% % DELETED CLUBPENALTY, BELOW.
	     \everypar\expandafter{\bef@everypar{\tmp@everypar}}}% RESTORE.
\let\old@sec\section				%
\let\old@ssec\subsection			%
\let\old@sssec\subsubsection			% OLD SECTIONING COMMANDS.
\let\old@par\paragraph				%
\let\old@spar\subparagraph			%
% ------- new forms ------- %
\renewcommand{\section}{\secdef\JHEP@sec\JHEP@secs}
\renewcommand{\subsection}{\secdef\JHEP@ssec\JHEP@ssecs}
\renewcommand{\subsubsection}{\secdef\JHEP@sssec\JHEP@sssecs}
\renewcommand{\paragraph}{\secdef\JHEP@par\JHEP@pars}
\renewcommand{\subparagraph}{\secdef\JHEP@spar\JHEP@spars}
% ---- unstarred forms ---- %
\def\JHEP@sec[#1]#2{\ts@flag\bef@sec\old@sec[#1]{#2}\aft@sec}
\def\JHEP@ssec[#1]#2{\bef@sec\old@ssec[#1]{#2}\aft@sec}
\def\JHEP@sssec[#1]#2{\bef@sec\old@sssec[#1]{#2}\aft@sec}
\def\JHEP@par[#1]#2{\bef@sec\old@par[#1]{#2}\aft@sec}
\def\JHEP@spar[#1]#2{\bef@sec\old@spar[#1]{#2}\aft@sec}
% ----- starred forms ----- %
\def\JHEP@secs#1{\bef@sec\old@sec*{#1}\aft@sec}
\def\JHEP@ssecs#1{\bef@sec\old@ssec*{#1}\aft@sec}
\def\JHEP@sssecs#1{\bef@sec\old@sssec*{#1}\aft@sec}
\def\JHEP@pars#1{\bef@sec\old@par*{#1}\aft@sec}
\def\JHEP@spars#1{\bef@sec\old@spar*{#1}\aft@sec}
% ----- end hack for sections with floats --------%

\if@twocolumn
  \setlength\leftmargini  {2em}
\else
  \setlength\leftmargini  {2.5em}
\fi
\leftmargin  \leftmargini
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{$\m@th\bullet$}
\newcommand\labelitemii{\normalfont\bfseries --}
\newcommand\labelitemiii{$\m@th\ast$}
\newcommand\labelitemiv{$\m@th\cdot$}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
%%%%%%%%%%%%%%%%%%%%%%%%%% AUTHORS/ADDRESSES %%%%%%%%%%%%%%%%%%%%%%%%%%
% *** After proceedings, the authors go in a hbox. => \break does not work!!
% *** if no address nobody closes the box!
\newif\if@speaker\@speakerfalse
\newif\if@dblspeak\@dblspeakfalse
\newtoks\prev@t
\newtoks\cur@t
\newbox\@firstaubox
\newskip\addr@skip\addr@skip=\if@proc .6em\@plus.02em\@minus.3ex
			     \else .6em\@plus.02fil\@minus.3ex \fi
\newskip\auth@skip\auth@skip=\if@proc .6em\@plus.03em\@minus.2ex
			     \else .6em\@plus.03fil\@minus.2ex \fi
\renewcommand\@author{\parskip\z@
%		      \def\@noaddr{\setbox\@tmpbox\vbox\bgroup\let\\\par}%
		      \def\\{\egroup			% CLOSE & aftergroup!
			\par				% FIRST TIME \\=>ADDR.
			\vskip\addr@skip		% GLUE UNDER AUTHOR
			\hskip1em%			% ADDRESS INDENT
			\vbox\bgroup\hsize=.9\textwidth	% 
			\small\it\raggedright		% STYLE FOR ADDRESSES
			\def\\{\par\leavevmode\ignorespaces}%\let\\\relax%
			\leavevmode\ignorespaces}%
			}
\renewcommand\author[1]{%
		\global\@authortrue			%
		\prev@t=\expandafter{\@author}%		% TWO TOKEN LISTS.
		\cur@t={\vskip\auth@skip		% glue before auth.
			\vtop\bgroup #1\egroup		% ACTUAL AUTH.\\ADD.
			\par}%				%
		\long\xdef\@author{\the\prev@t\the\cur@t}%STORE ALL IN \@AUTHOR
		}
%%%%%%%%%%%%%%%%%%%%%%%%%%%% SPEAKER %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand\speaker[1]{\if@speaker\global\@dblspeaktrue\fi
			\global\@speakertrue
			\global\setbox\@firstaubox
			\hbox{\let\thanks\@gobble
				\let\footnote\@gobble 
				\rm #1}%
			#1\thanks{Speaker.}\
			}%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% CONFERENCE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newbox\conf@box
\newcommand\conference[1]{\global\setbox\conf@box\hbox{%
			 \itshape #1}\@conftrue}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% RECEIVED %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand\received[1]{\gdef\Jrece@cs{{\scshape\receivedname} 
                                       {\itshape #1}}\@recetrue}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% REVISED %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand\revised[1]{\gdef\Jrevi@cs{{\scshape\revisedname}
                                      {\itshape #1}}\@revitrue}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% PUBLISHED %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand\accepted[1]{\gdef\Jacce@cs{{\scshape\acceptedname}
                                       {\itshape #1}}\@accetrue}
%%%%%%%%%%%%%%%%%%%%%%%%%% COPYRIGHT DATE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newbox\Jcopy@date
\newcommand\JHEPcopydate[1]{\global\setbox\Jcopy@date
                        \hbox{\scriptsize #1}\global\@Jcopytrue}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% DEDICATED %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\gdef\dedic@box{\relax}
\newcommand\dedicated[1]{\gdef\dedic@box{\vskip2em minus 1.2ex
                              \vbox{\small\it\raggedleft #1}}}
%%%%%%%%%%%%%%%%%%%%%%%%%%% ACKNOWELEDGMENTS %%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand\acknowledgments{\section*{\acknowlname}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% EMAIL %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand\email[1]{{\tt\href{mailto:#1}{#1}}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% PREPRINT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\let\@preprint\relax
\newcommand\preprint[1]{\long\gdef\@preprint{#1}} 
%%%%%%%%%%%%%%%%% SPECIAL URL overrides paper@url %%%%%%%%%%%%%%%%%%%%%
\newbox\Jspecial@url
\newcommand\JHEPspecialurl[1]{\global\setbox\Jspecial@url\hbox{\tiny\ttfamily
			#1}\@Jspecialurltrue}
%%%%%%%%%%%%%%%%%%%%%%%%% FILE NAME AND URL %%%%%%%%%%%%%%%%%%%%%%%%%%%
\global\newbox\Jacce@month
\global\newcount\Jacce@year
\global\newbox\Jacce@number
\def\Jsplit@ident#1(#2)#3.{\global\setbox\Jacce@month\hbox{\tiny\ttfamily #1}
			  \global\Jacce@year= #2
			  \global\setbox\Jacce@number\hbox{\tiny\ttfamily #3}

\newbox\Jpaper@url
\gdef\Jfile@name{\hbox{\tiny\ttfamily
		jhep\unhcopy\Jacce@month\the\Jacce@year\unhcopy\Jacce@number}}

\global\setbox\Jpaper@url\hbox{\tiny\ttfamily 
		http://jhep.sissa.it/archive/papers/\Jfile@name/\Jfile@name.pdf}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% COPYRIGHT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\gdef\Jcopyright@box{\hbox{\if@preprint\else{\scriptsize $\copyright$
		SISSA/ISAS\ \if@Jcopy\unhbox\Jcopy@date\else\the\year\fi}\fi}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% ABSTRACT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% *** For beton! We need a cs, not a box. Maybe also for refs.. %%%%%%

\newcommand{\abstract}[1]%		% ABSTR. IN NORMALSIZE
	{\gdef\abstract@cs{		% cs FOR WHOLE ABSTRACT
	{\if@proc\small\else\fi
	\noindent{\scshape\abstractname}\ \ignorespaces #1}}
	\normalsize
	\global\@abstracttrue}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% KEYWORDS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\@keywords{\relax}%                   % CS FOR WHOLE KEYWORDS
\def\keywords{\bgroup\gdef\@comma{,}\catcode`\ =\active\catcode`,=\active
		\@@keywords}
\begingroup
\catcode`\ =\active\catcode`,=\active\global
\def\@@keywords#1{\gdef\@keywords{\noindent{\scshape\keywordsname}
		\bgroup\def, {+}\def {_}%	%ATTENTION: NO EXPANSION.
		\href{http://jhep.sissa.it/stdsearch?keywords=#1}%
						{\let,\@comma\let \ #1}.
		\egroup}\egroup\global\@keywordstrue}%
\endgroup
%%%%%%%%%%%%%%%%%%%%%%%%%% OTHER ENVIRONMENTS %%%%%%%%%%%%%%%%%%%%%%%%%
\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% THEOREMS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newif\if@twothms\@twothmsfalse

\if@preprint%\ifx\@thmcountersep\@undefined
%\def\@xthm#1#2{\@begintheorem{#2}{\csname the#1\endcsname.}\ignorespaces}% after thm number
\else									 % if published or proc
\def\@xthm#1#2{\@begintheorem{#2\if@twothms\else.\fi}			 % theorems are numbered
		{\if@twothms\csname the#1\endcsname.\fi}		 % only if more than one
		\ifnum \csname the#1\endcsname>1 \immediate\write\@auxout% and not within sections
				{\string\global\string\@twothmstrue}\fi
		\ignorespaces}
\fi

\newcommand\Proof{\noindent\emph{Proof.}\ }

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% APPENDIX %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand\appendix{\par
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \renewcommand\thesection{\@Alph\c@section}}

%%%%%%%%%%%%%%%%%%%%%%%%%%% SOME MORE LENGHTS %%%%%%%%%%%%%%%%%%%%%%%%%
\setlength\arraycolsep{2\p@}		% TO MATCH eqnarrays<->equations
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% THE EQUATION %%%%%%%%%%%%%%%%%%%%%%%%%%%%
\renewcommand\theequation{\ifnum\c@section=0\else\thesection.\fi
			  \@arabic\c@equation}

%%%%%%%%%%%%%%%%%%%%%%%%%%%% FIGURES, TABLES %%%%%%%%%%%%%%%%%%%%%%%%%%
\newcounter{figure}
\renewcommand\thefigure{\@arabic\c@figure}
\def\fps@figure{Htbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\newenvironment{figure}
               {\@ENVwarn{\FIGURE{...}}\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@ENVwarn{\FIGURE{...}}\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}
\renewcommand\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\newenvironment{table}
               {\@ENVwarn{\TABLE{...}}\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@ENVwarn{\TABLE{...}}\@dblfloat{table}}
               {\end@dblfloat}
%%-----------------------------------------------------------------%%
\newcommand{\FIGURE}[2][v]{\begin{floatingfigure}[#1]#2
                                        \end{floatingfigure}}
\newcommand{\TABLE}[2][v]{\begin{floatingtable}[#1]{#2}
                                        \end{floatingtable}}
\newcommand{\EPSFIGURE}[3][v]{\begin{floatingfigure}[#1]\epsfig{file=#2}
                                        \caption{#3}\end{floatingfigure}}
\newcommand{\TABULAR}[4][v]{\begin{floatingtable}[#1]{\begin{tabular}{#2}
					#3\end{tabular}}\caption{#4}
                                        \end{floatingtable}}
%Check below, and put automatic width ***
\newcommand{\DOUBLEFIGURE}[5][ht]{\@dblfloat{figure}[#1]\centerline{%
		\parbox{.45\textwidth}{\centerline{\epsfig{file=#2}}}~~~~
		\parbox{.45\textwidth}{\centerline{\epsfig{file=#3}}}}
		\centerline{\parbox[t]{.45\textwidth}{\caption{#4}}~~~~
		\parbox[t]{.45\textwidth}{\caption{#5}}}\end@dblfloat}
\newcommand{\DOUBLETABLE}[5][ht]{\@dblfloat{table}[#1]\centerline{%
		\parbox{.45\textwidth}{\centerline{#2}}~~~~
		\parbox{.45\textwidth}{\centerline{#3}}}
		\centerline{\parbox[t]{.45\textwidth}{\caption{#4}}~~~~
		\parbox[t]{.45\textwidth}{\caption{#5}}}\end@dblfloat}
%%%%%%---------------- FROM FLOATFLT PACKAGE ------------------%%%%%%%%
%% Original file `floatflt.sty', modified by F.Nesti <nesti@sissa.it> to:
%% be inserted in JHEP.cls;
%% correct float placement when shifting past pages;
%% correct incompatibility with \marginpar;
%% correct incompatibility with \@startsection;
%% correct persisting indentation in following pars;
%% let float also at beginning of pages; 
%% avoid the widht specification.
%% 
%% Original was 1994-1996 by Mats Dahlgren <matsd@physchem.kth.se>. 
%% 
%%%%%%%%\NeedsTeXFormat{LaTeX2e}[1994/06/01]		%LEFT THIS STUFF TO 
%%%%%%%%\ProvidesPackage{floatflt}[1996/02/27 v. 1.3]	%RECONVERT TO PACKAGE.
\newcounter{OptionTest}
\if@twoside
 \setcounter{OptionTest}{0}
\else							% POS: 2side=p/1side=r
 \setcounter{OptionTest}{1}
\fi
%%%%%%%%\DeclareOption{rflt}{\setcounter{OptionTest}{1}}
%%%%%%%%\DeclareOption{lflt}{\setcounter{OptionTest}{2}} % CHOSEN.
%%%%%%%%\DeclareOption{vflt}{\setcounter{OptionTest}{0}}
%%%%%%%%\DeclareOption*{\OptionNotUsed}
%%%%%%%%\ProcessOptions
\newbox\@tmpbox
\newbox\figbox
\newbox\tabbox
\newbox\pagebox
\newcount\ffigcount
\newcount\ftabcount
\newcount\hangcount
\newcount\nosuccesstryfig
\newcount\nosuccesstrytab
\newdimen\figgutter   \figgutter=1truepc
\newdimen\tabgutter   \tabgutter=1truepc
\newdimen\fl@wd
\newdimen\fl@ht
%\newdimen\fl@gut
\newdimen\htdone      \htdone=\z@
\newdimen\pageht
\newdimen\startpageht
\newdimen\floatfltwidth
\newdimen\fltitemwidth
\newif\iftryingfig     \tryingfigfalse
\newif\iftryingtab     \tryingtabfalse
\newif\ifdoingfig      \doingfigfalse
\newif\ifdoingtab      \doingtabfalse
\newif\iffigprocessing \figprocessingfalse
\newif\iftabprocessing \tabprocessingfalse
\newif\ifpageafterfig  \pageafterfigfalse
\newif\ifpageaftertab  \pageaftertabfalse
\newif\ifoddpages
\newif\ifoutput
\newtoks\outputpretest
\def\@captype{}
%%---------------- ORRIBLE HACKS, SORRY -------------------------%%
\let\old@marginpar\marginpar				% 
\renewcommand\marginpar[1]{{\outputpretest={\outputtrue}% REDEF \marginpar.
			    \old@marginpar{#1}}}	%
\def\g@addto#1#2{{\toks@\expandafter{#1#2}%
		  \xdef#1{\the\toks@}}}%
\def\postpone@captions{%			%
%	\global\let\tmp@label\label		% REDEF \caption AND 
	\global\let\tmp@caption\caption		% \label, LATER.
	\global\let\later@capt\relax		% UN PO' PESANTI 
	\gdef\later@label{}%			% MA D'ALTRONDE...
	\let\J@ref\ref\def\ref{\protect\J@ref}% % protect ref in captions.. 
	\renewcommand\caption{\@ifnextchar[\J@@caption\J@caption}%
	\newcommand\J@caption[1]{\gdef\later@capt{\tmp@caption{##1}}}% LOCAL!!
	\newcommand\J@@caption[2][v]%
				{\gdef\later@capt{\tmp@caption[##1]{##2}}}% LOCAL!!
	\renewcommand\@@label[1]{\egroup\name{ref-##1}%	% TAG WHERE CALLED, AT LEAST,
			       \if@draft\norm@note{}{LAB: ##1}\fi% & DRAFTNOTE.
			       \g@addto\later@label{\old@label{##1}}}%
			}
\AtEndDocument{\iftryingfig\JHEP@warnl{Floating figure \the\ffigcount\space
					remains undone}\fi
		\iftryingtab\JHEP@warnl{Floating table \the\ftabcount\space
					remains undone}\fi
		\if@JHEP\ifnum\Jacce@year>2001\if@Jcopy\else
		\ifnum\the\Jacce@year=\the\year\else
		\JHEP@warnl{The acceptance date
		\the\Jacce@year\space is different from today's
		\the\year}\fi\fi\fi\fi} % the copyright date must be that
			  %  of publication if it differs from the one in the
		 	  % identifier it can be forced using command \JHEPcopydate
%%----------------- FIGURE ---------------------------------------%%
\newenvironment{floatingfigure}[1][v]%
{\@tfor \@tempa :=#1\do {\xdef\@fside{\@tempa}}%
 \global\advance\ffigcount by 1%
 \iffigprocessing {\count0=\ffigcount\advance\count0 by -1%
   		   \JHEP@warnl{Floating figures \the\count0\space\space and
       			\the\ffigcount\space colliding}}\fi
 \iftabprocessing  \JHEP@warnl{Floating table \the\ftabcount\space and 
			floating figure \the\ffigcount\space colliding}\fi
 \postpone@captions
 \global\setbox\@tmpbox=\hbox\bgroup% begin of figbox %HBOX FOR AUTO WIDTH!
}
{%
\egroup%				% CALCULATE WIDTH (NO CAPTION FOR NOW)
\global\setlength{\floatfltwidth}{\the\wd\@tmpbox}%
% New behavior:	wd < .6 columnwidth => floatflt.
%		wd < columnwidth    => float{figure}
%		wd > columnwidth    => dblfloat{figure}
\ifdim\floatfltwidth<.6\columnwidth%	% IF NOT TOO WIDE OK:
 \global\setbox\figbox=\vbox{\hsize=\floatfltwidth
			     \def\@captype{figure}%
			     \noindent\unhbox\@tmpbox
			     \later@capt\later@label}%
 \global\figprocessingtrue
 \global\everypar={\tryfig\oldeverypar}% must be set globally!
 \figinsert\par
\else%					% ELSE NORMAL LATEX FIGURE, SIGH.
% \JHEP@mess{Floating figure \the\ffigcount\space is 
%			wide becomes a LaTeX float}%
 \if\@fside v \def\@fside{ht}\fi
 \ifdim\floatfltwidth<\columnwidth
    \def\@@tempa{\@float{figure}[}\let\@@tempb\end@float
 \else
    \def\@@tempa{\@dblfloat{figure}[}\let\@@tempb\end@dblfloat
 \fi
 \expandafter\@@tempa\@fside]\center\unhbox\@tmpbox\later@capt\later@label\@@tempb
\fi
}
%%------------ TABLE ----------------------------------------------%%
\newenvironment{floatingtable}[1][v]%
{\@tfor \@tempa :=#1\do {\global\edef\@tside{\@tempa}}%
 \global\advance\ftabcount by 1%
 \iftabprocessing {\count0=\ftabcount\advance\count0 by -1%
     		   \JHEP@warnl{Floating tables \the\count0\space
            		\space and \the\ftabcount \space colliding}}\fi
 \iffigprocessing  \JHEP@warnl{Floating figure \the\ffigcount\space and 
			floating table \the\ftabcount\space colliding}\fi
 \postpone@captions
 \global\setbox\@tmpbox=\hbox\bgroup% begin of tabbox, ACTUALLY AN HBOX.
}
{%
\egroup% end of \tabbox, 		% ACTUALLY \@tmpbox
\global\setlength{\floatfltwidth}{\the\wd\@tmpbox}%
\ifdim\floatfltwidth<.6\columnwidth%	% IF NOT TOO WIDE OK:
  \global\setbox\tabbox=\vbox{\hsize=\floatfltwidth
			     \def\@captype{table}%
			     \noindent\unhbox\@tmpbox
			     \later@capt\later@label}%
  \global\tabprocessingtrue
  \global\everypar={\trytab\oldeverypar}%
  \tabinsert\par%
\else%					% ELSE NORMAL LATEX TABLE.
%  \JHEP@mess{Floating table \the\ftabcount\space is 
%			wide becomes a LaTeX float}%
  \ifdim\floatfltwidth<1.1\columnwidth
    \if\@tside v \def\@tside{ht}\fi
    \def\@@tempa{\@float{table}[}\let\@@tempb\end@float
  \else
    \if\@tside v \def\@tside{t}\fi
    \def\@@tempa{\@dblfloat{table}[}\let\@@tempb\end@dblfloat
  \fi
  \expandafter\@@tempa\@tside]%		% ACTUALLY CALL THE LATEX FLOAT
  \center\unhbox\@tmpbox\later@capt\later@label
  \@@tempb
\fi%
}
%----------- prepare for tries ----------------------------%
\def\figinsert{%
   \global\nosuccesstryfig=0%
   \global\outputpretest={\do@test}%
   \global\tryingfigtrue \global\doingfigfalse%
   \global\pageafterfigfalse}%
\def\tabinsert{%
   \global\nosuccesstrytab=0%
   \global\outputpretest={\do@test}%
   \global\tryingtabtrue \global\doingtabfalse%
   \global\pageaftertabfalse}%
%----------- init -----------------------------------------%
\AtBeginDocument{%
 \edef\oldoutput{\the\output}
 \output={\the\outputpretest\ifoutput\oldoutput\fi}%
 \outputpretest={\outputtrue}%
 \edef\oldeverypar{\the\everypar}% PERCHE' NESSUNO LO RIMETTE PIU' A POSTO?***
}
%---- tests during \outputpretest -------------------------%
\def\do@test{%
   \ifnum\outputpenalty=-10005
%	\output
     \setbox\pagebox=\vbox{\unvbox255}%
     \global\pageht=\ht\pagebox
     \global\outputfalse
     \unvbox\pagebox
     \dimen0=\pageht\advance\dimen0 by 2 \baselineskip
     \ifdim\dimen0>\vsize\pagebreak[4]\global\pageht\z@\fi
   \else
     \global\outputtrue
     \ifnum\outputpenalty>-\@Mi			%ie \marginpar's give penalty.
	\ifdoingtab\global\pageaftertabtrue\fi
	\ifdoingfig\global\pageafterfigtrue\fi
     \fi
   \fi}%
%-------- check for side ----------------------------------%
\def\chk@side#1{% DEFINED \fl@sid, BUT IF CHOSEN A DEFAULT, ELIMINATE ALL ***
	{\edef\fl@sid{#1}%
	  \if\fl@sid r\global\oddpagestrue\fi
          \if\fl@sid l\global\oddpagesfalse\fi
          \if\fl@sid p%
              \ifodd\c@page\global\oddpagesfalse
                \else\global\oddpagestrue\fi
          \fi
          \if\fl@sid v%
             \ifnum\theOptionTest=0%
                 \ifodd\c@page\global\oddpagesfalse
                   \else\global\oddpagestrue\fi
             \else
                  \ifodd\theOptionTest\global\oddpagestrue
                    \else\global\oddpagesfalse\fi
             \fi
          \fi
         }}%
%-------- get point in page -------------------------------%
\def\get@pageht{{\everypar={\relax}\setbox0=\lastbox
       		\parindent=\wd0 \parskip=\z@ \par
         	\penalty-10005 \leavevmode}}%
%-------- try at everypar ---------------------------------%
\def\tryfig{%
	\global\fl@ht\ht\figbox
	\global\fl@wd\wd\figbox
	\global\let\fl@gut\figgutter
      \iftryingfig
	\get@pageht
	\dimen0=\vsize
	\advance\dimen0 by -\pageht
	\advance\dimen0 by -2\baselineskip
	\ifdim\dimen0>\fl@ht
	  \chk@side\@fside
	  \dimen0=0.3\baselineskip
	  \vrule depth \dimen0 width \z@%height 1.5\baselineskip
	  \vadjust{\kern -\dimen0
	  \vtop to \dimen0{%
             \baselineskip=\dimen0
             \vss \vbox to 1ex{%
             \ifoddpages
               \hb@xt@\hsize{\hss\copy\figbox}%
             \else% leftsetting
               \hb@xt@\hsize{\copy\figbox\hss}%
             \fi
             \vss}\null}}%
	  \global\tryingfigfalse
	  \global\doingfigtrue
	  \global\startpageht=\pageht
	  \global\htdone=\z@
	  \dohang
	  \ifnum\nosuccesstryfig>0%
	   \JHEP@mess{Flt. fig. \the\ffigcount\space set on page \the\count0, 
	 		shifted \the\nosuccesstryfig\space par(s) forward}%
%	  \else
%	   \JHEP@mess{Floating figure \the\ffigcount\space 
%			set on page \the\count0}%
	  \fi
	\else
          \global\advance\nosuccesstryfig by 1
	\fi
      \else%				% IF NOT TRYING
	\ifdoingfig
	  \get@pageht
	  \global\htdone=\pageht
	  \global\advance\htdone by -\startpageht
	  \ifpageafterfig
	    \global\doingfigfalse% IN CASE A PAGEBREAK JUST BELOW?
	  \else
	    \dimen0=\fl@ht
	    \advance\dimen0 by .85\baselineskip	% .85 ENOUGH: WE ARE AT NEW PAR
%	    \typeout{FLOAT HT: \the\dimen0, HTDONE: \the\htdone}
	    \ifdim\htdone<\dimen0%
		\dohang
	    \else
		\global\doingfigfalse
	    \fi
	  \fi
	  \ifdoingfig\else\global\figprocessingfalse\fi% IF NO MORE DOING.
	\else
	  \global\outputpretest={\outputtrue}% NOT RESTORE EVPAR IF NOT DOING?
	\fi%			% END IF DOING
      \fi%			% END IF TRYING
}
\def\trytab{%
	\global\fl@ht\ht\tabbox
	\global\fl@wd\wd\tabbox
	\global\let\fl@gut\tabgutter
       \iftryingtab
	\get@pageht
       \dimen0=\vsize
       \advance\dimen0 by -\pageht
       \advance\dimen0 by -2\baselineskip
       \ifdim\dimen0>\fl@ht
	 \chk@side\@tside
         \dimen0=0.3\baselineskip
         \vrule depth \dimen0 width \z@
         \vadjust{\kern -\dimen0
         \vtop to \dimen0{%
             \baselineskip=\dimen0
             \vss \vbox to 1ex{%
             \ifoddpages
               \hb@xt@\hsize{\hss\copy\tabbox}%
             \else% leftsetting
               \hb@xt@\hsize{\copy\tabbox\hss}%
             \fi
             \vss}\null}}%
       \global\tryingtabfalse
       \global\doingtabtrue
       \global\startpageht=\pageht
       \global\htdone=\z@
       \dohang
       \ifnum\nosuccesstrytab>0%
	\JHEP@mess{Flt. tab. \the\ftabcount\space set on page \the\count0, 
			shifted \the\nosuccesstrytab\space par(s) forward}%
%       \else
%	\JHEP@mess{Floating table \the\ftabcount\space 
%			set on page \the\count0}%
       \fi
     \else
       \global\advance\nosuccesstrytab by 1
     \fi
     \else
     \ifdoingtab
       \get@pageht
    \global\htdone=\pageht
    \global\advance\htdone by -\startpageht
    \ifpageaftertab
      \global\doingtabfalse
    \else
      \dimen0=\fl@ht
      \advance\dimen0 by .85\baselineskip	% .85 ENOUGH: WE ARE AT NEW PAR
      \ifdim\htdone<\dimen0%
         \dohang
      \else
         \global\doingtabfalse
      \fi
    \fi
    \ifdoingtab\relax\else\global\tabprocessingfalse\fi
  \else
    \global\outputpretest={\outputtrue}%
  \fi
\fi
}
%----- hanging lord -----------------------------%
\def\dohang{%
   \dimen0=\fl@ht
   \advance\dimen0 by -\htdone
   \advance\dimen0 by 1.999\baselineskip	% (16/12/98) WAS 1.49 BUT
   \hangcount=\dimen0				% TEX ROUNDS ON STRICT INTEGERS
   \divide\hangcount by \baselineskip		% IN THIS DIVISION!
%	\typeout{HANGCOUNT: \the\hangcount.}
%   \ifnum\hangcount > 0	% IF ZERO ALSO INDENT MUST BE NULL. (7/6/97)
     \dimen0=\fl@wd
     \advance\dimen0 by \fl@gut
     \ifoddpages
       \global\hangindent=-\dimen0% placing right
     \else 
       \global\hangindent=\dimen0% placing left
     \fi
   \global\hangafter=-\hangcount
%   \fi
}
%----------------------- TWO NEWITEMS ---------------------%
\newcommand{\fltitem}[2][\z@]{\setlength{\fltitemwidth}{\linewidth}%
  \addtolength{\fltitemwidth}{-\floatfltwidth}%
  \addtolength{\fltitemwidth}{-0.5em}%
  \item \parbox[t]{\fltitemwidth}{#2}\\[#1]}
\newcommand{\fltditem}[3][\z@]{\setlength{\fltitemwidth}{\linewidth}%
  \addtolength{\fltitemwidth}{-\floatfltwidth}%
  \addtolength{\fltitemwidth}{-0.5em}%
  \item[#2] \parbox[t]{\fltitemwidth}{#3}\\[#1]}
%%%%%%\endinput
%% 
%% End of ex-file `floatflt.sty'.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% CAPTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{8\p@}
\setlength\belowcaptionskip{0\p@}
\long\def\@makecaption#1#2{%
  \if@hyper{\edef\@pippo{the\@captype}
	    \name{\@captype\expandafter\csname\@pippo\endcsname}}\fi%
  \vskip\abovecaptionskip
 {\let\label\@gobble%				% FN 10.2.97 REMOVED LATEX BUG:
  \let\index\@gobble%				% LARGE CAPTIONS PROCESS LABEL
  \let\glossary\@gobble%			% TWO TIMES.
  \sbox\@tempboxa{\small {\bfseries #1:} #2}%	% 
  \global\dimen0\wd\@tempboxa}%			%
  \ifdim \dimen0 >\hsize
    \small {\bfseries #1:} #2\par
  \else
    \global\@minipagefalse \sbox\@tempboxa{\small {\bfseries #1:} #2}%
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% FONTS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% TOC %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand\tocsecs{}
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{3}
\newcommand\tableofcontents{%
    \section*{\contentsname\label{-TOC-}}
%        \@mkboth{%
%           \MakeUppercase\contentsname}{\MakeUppercase\contentsname}%
    \@starttoc{toc}%
    \gdef\tableofcontents{\JHEP@igno{\tableofcontents\space already done}}}
\newcommand*\l@part[2]{\def\hyp@typ{part}%	
  \ifnum \c@tocdepth >-2\relax
    \addpenalty\@secpenalty
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \setlength\@tempdima{3em}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries \tocsecs#1\hfil \hb@xt@\@pnumwidth{\hss
		\href{\hash pag#2}{#2}}}\par
       \nobreak
       \if@compatibility
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
      \fi
    \endgroup
  \fi}
\newcommand*\l@section[2]{\def\hyp@typ{sec}%
  \ifnum \c@tocdepth >\z@
    \addpenalty\@secpenalty
    \addvspace{1.0em \@plus\p@}%
    \setlength\@tempdima{1.8em}%	%WIDTH OF SECT. N.
    \begingroup
      \let\d@t.%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
        \tocsecs#1\nobreak\hfil %HREF HERE WOULD GET ALSO THE TITLE(...)
        \nobreak\hb@xt@\@pnumwidth{\hss \href{\hash pag#2}{#2}}\par
    \endgroup
  \fi}

\newcommand*\l@subsection{\def\hyp@typ{sec}\@tocline{2}{1.8em}{2.3em}}
\newcommand*\l@subsubsection{\def\hyp@typ{sec}\@tocline{3}{4.1em}{3.1em}}
\newcommand*\l@paragraph{\def\hyp@typ{sec}\@tocline{4}{7.2em}{4.3em}}
\newcommand*\l@subparagraph{\def\hyp@typ{sec}\@tocline{5}{10.5em}{5em}}

\if@hyper
  \let\old@dtl\@dottedtocline
  \def\@dottedtocline#1#2#3#4#5{\old@dtl{#1}{#2}{#3}{#4}{%
						\href{\hash pag#5}{#5}}}
\fi

\def\@tocline#1#2#3#4#5{%
  \ifnum #1>\c@tocdepth \else
    \vskip \z@ \@plus.2\p@
    {\leftskip #2\relax \rightskip \@tocrmarg \parfillskip -\rightskip
     \parindent #2\relax\@afterindenttrue
     \interlinepenalty\@M
     \leavevmode
     \@tempdima #3\relax
     \advance\leftskip \@tempdima \null\nobreak\hskip -\leftskip
     {#4}\nobreak
     %\leaders\hbox{$\m@th
     %   \mkern \@dotsep mu\hbox{.}\mkern \@dotsep
     %	   mu$}
     \hfill
     \nobreak
     \hb@xt@\@pnumwidth{\hfil\normalfont \normalcolor \href{\hash pag#5}{#5}}%
     \par}%
  \fi}


%%%%%%%%%%%%%%%%%%%%%% LIST OF FIGURES AND TABLES %%%%%%%%%%%%%%%%%%%%%
\if@draft			% ONLY IF DRAFT! ... 
 \newcommand\listoffigures{%
     \section*{\listfigurename
       \@mkboth{\MakeUppercase\listfigurename}%
               {\MakeUppercase\listfigurename}}%
     \@starttoc{lof}%
     }
 \newcommand*\l@figure{\def\hyp@typ{figure}\@dottedtocline{1}{1.5em}{2.3em}}
 \newcommand\listoftables{%
     \section*{\listtablename
       \@mkboth{%
           \MakeUppercase\listtablename}{\MakeUppercase\listtablename}}%
     \@starttoc{lot}%
     }
 \newcommand*\l@table{\def\hyp@typ{table}\@dottedtocline{1}{1.5em}{2.3em}}
\else
 \newcommand\listoffigures{\JHEP@ignol{List of figures (draft mode only)}}
 \newcommand\listoftables{\JHEP@ignol{List of tables (draft mode only)}}
\fi
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% BIBLIOGRAPHY %%%%%%%%%%%%%%%%%%%%%%%%%%%%***
\newdimen\bibindent
\setlength\bibindent{1.5em}
\newenvironment{thebibliography}[1]%	%UNFORTUNATELY MODIFIED..
     {\bgroup\raggedright\small\section*{\refname
        \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}}%
      \list{\name{bib\@arabic\c@enumiv}% HOPE!
	    \@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy\clubpenalty4000\widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist\egroup}
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\if@draft
 \let\old@bbt\@bibitem\let\old@lbbt\@lbibitem% LOOK THE DISASTER HERE BELOW.
 \def\@lbibitem[#1]#2{\old@lbbt[#1]{#2}\reversemarginpar{\sf\bfseries\small#2}}
 \def\@bibitem#1{\old@bbt{#1}\reversemarginpar{\sf\bfseries\small#1}}
\fi
\let\@openbib@code\@empty
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% JOURNALS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\@spires#1{\href{http://www-spires.slac.stanford.edu/spires/find/hep/www?j=#1}} 
%                               	%PITY THAT target IS NOT IMPLEMENTED.
\catcode`\%=12
\catcode`\|=14
\newcommand\apa[3]    {\@spires{APASA%2C#1%2C#3}
		{{\it Acta Phys.\ Austriaca }{\bf #1} (#2) #3}}
\newcommand\apas[3]    {\@spires{APAUA%2C#1%2C#3}
		{{\it Acta Phys.\ Austriaca, Suppl.\ }{\bf #1} (#2) #3}}
\newcommand\appol[3] {\@spires{APPOA%2C#1%2C#3}
		{{\it Acta Phys.\ Polon.\ }{\bf #1} (#2) #3}}
\newcommand\advm[3]  {\@spires{ADMTA%2C#1%2C#3}
		{{\it Adv.\ Math.\ }{\bf #1} (#2) #3}}
\newcommand\adnp[3]   {\@spires{ANUPB%2C#1%2C#3}
		{{\it Adv.\ Nucl.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\adp[3]   {\@spires{ADPHA%2C#1%2C#3}
		{{\it Adv.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\atmp[3] {\@spires{00203%2C#1%2C#3}
		{{\it Adv.\ Theor.\ Math.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\am[3]    {\@spires{ANMAA%2C#1%2C#3}
		{{\it Ann.\ Math.\ }{\bf #1} (#2) #3}}
\newcommand\ap[3]    {\@spires{APNYA%2C#1%2C#3}
		{{\it Ann.\ Phys.\ (NY) }{\bf #1} (#2) #3}}
\newcommand\araa[3] {\@spires{ARAAA%2C#1%2C#3}
		{{\it Ann.\ Rev.\ Astron.\ \& Astrophys.\ }{\bf #1} (#2) #3}}
\newcommand\arnps[3] {\@spires{ARNUA%2C#1%2C#3}
		{{\it Ann.\ Rev.\ Nucl.\ Part.\ Sci.\ }{\bf #1} (#2) #3}}
\newcommand\asas[3]   {\@spires{AAEJA%2C#1%2C#3}
		{{\it Astron.\ Astrophys.\ }{\bf #1} (#2) #3}}
\newcommand\asj[3]   {\@spires{ANJOA%2C#1%2C#3}
		{{\it Astron.\ J.\ }{\bf #1} (#2) #3}}
\newcommand\app[3]   {\@spires{APHYE%2C#1%2C#3}
		{{\it Astropart.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\apj[3]    {\@spires{ASJOA%2C#1%2C#3}
		{{\it Astrophys.\ J. }{\bf #1} (#2) #3}}
\newcommand\baas[3]   {\@spires{AASBA%2C#1%2C#3}
		{{\it Bull.\ Am.\ Astron.\ Soc.\ }{\bf #1} (#2) #3}}
\newcommand\bams[3]   {\@spires{BAMOA%2C#1%2C#3}
		{{\it Bull.\ Am.\ Math.\ Soc.\ }{\bf #1} (#2) #3}}
\newcommand\blms[3]   {\@spires{LMSBB%2C#1%2C#3}
		{{\it Bull.\ London Math.\ Soc.\ }{\bf #1} (#2) #3}}
\newcommand\cjm[3]  {\@spires{CJMAA%2C#1%2C#3}
		{{\it Can.\ J.\ Math.\ }{\bf #1} (#2) #3}}
\newcommand\cqg[3]   {\@spires{CQGRD%2C#1%2C#3}
		{{\it Class.\ and Quant.\ Grav.\ }{\bf #1} (#2) #3}}
\newcommand\cmp[3]   {\@spires{CMPHA%2C#1%2C#3}
		{{\it Commun.\ Math.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\ctp[3]   {\@spires{CTPMD%2C#1%2C#3}
		{{\it Commun.\ Theor.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\cag[3]   {\@spires{00142%2C#1%2C#3}
		{{\it Commun.\ Anal.\ Geom.\ }{\bf #1} (#2) #3}}
\newcommand\cpam[3]   {\@spires{CPAMA%2C#1%2C#3}
		{{\it Commun.\ Pure Appl.\ Math.\ }{\bf #1} (#2) #3}}
\newcommand\cpc[3]   {\@spires{CPHCB%2C#1%2C#3}
		{{\it Comput.\ Phys.\ Commun.\ }{\bf #1} (#2) #3}}
\newcommand\dmj[3]   {\@spires{DUMJA%2C#1%2C#3}
		{{\it Duke Math.\ J. }{\bf #1} (#2) #3}}
\newcommand\epjc[3]  {\@spires{EPHJA%2CC#1%2C#3}
		{{\it Eur.\ Phys.\ J. }{\bf C #1} (#2) #3}}
\newcommand\epjd[3]  {\@spires{EPHJD%2CC#1%2C#3}
		{{\it Eur.\ Phys.\ J. Direct.\ }{\bf C #1} (#2) #3}}
\newcommand\epl[3]    {\@spires{EULEE%2C#1%2C#3}
		{{\it Europhys.\ Lett. }{\bf #1} (#2) #3}}
\newcommand\forp[3]    {\@spires{FPYKA%2C#1%2C#3}
		{{\it Fortschr.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\faa[3]    {\@spires{FAAPB%2C#1%2C#3}
		{{\it Funct.\ Anal.\ Appl.\ }{\bf #1} (#2) #3}}
\newcommand\grg[3]    {\@spires{GRGVA%2C#1%2C#3}
		{{\it Gen.\ Rel.\ Grav.\ }{\bf #1} (#2) #3}}
\newcommand\hpa[3]   {\@spires{HPACA%2C#1%2C#3}
		{{\it Helv.\ Phys.\ Acta }{\bf #1} (#2) #3}}
\newcommand\ijmpa[3] {\@spires{IMPAE%2CA#1%2C#3}
		{{\it Int.\ J.\ Mod.\ Phys.\ }{\bf A #1} (#2) #3}}
\newcommand\ijmpb[3] {\@spires{IMPAE%2CB#1%2C#3}
		{{\it Int.\ J.\ Mod.\ Phys.\ }{\bf B #1} (#2) #3}}
\newcommand\ijmpc[3] {\@spires{IMPAE%2CC#1%2C#3}
		{{\it Int.\ J.\ Mod.\ Phys.\ }{\bf C #1} (#2) #3}}
\newcommand\ijmpd[3] {\@spires{IMPAE%2CD#1%2C#3}
		{{\it Int.\ J.\ Mod.\ Phys.\ }{\bf D #1} (#2) #3}}
\newcommand\ijtp[3] {\@spires{IJTPB%2CB#1%2C#3}
		{{\it Int.\ J.\ Theor.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\invm[3]  {\@spires{INVMB%2C#1%2C#3}
		{{\it Invent.\ Math.\ }{\bf #1} (#2) #3}}
\newcommand\jag[3]   {\@spires{00124%2C#1%2C#3}
		{{\it J.\ Alg.\ Geom.\ }{\bf #1} (#2) #3}}
\newcommand\jams[3]   {\@spires{00052%2C#1%2C#3}
		{{\it J.\ Am.\ Math.\ Soc.\ }{\bf #1} (#2) #3}}
\newcommand\jap[3]   {\@spires{JAPIA%2C#1%2C#3}
		{{\it J.\ Appl.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\jdg[3]   {\@spires{JDGEA%2C#1%2C#3}
		{{\it J.\ Diff.\ Geom.\ }{\bf #1} (#2) #3}}
\newcommand\jgp[3]   {\@spires{JGPHE%2C#1%2C#3}
		{{\it J.\ Geom.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\jhep[3]  {\href{http://jhep.sissa.it/stdsearch?paper=#1%28#2%29#3}
		{{\it J. High Energy Phys.\ }{\bf #1} (#2) #3}}
\newcommand\jmp[3]   {\@spires{JMAPA%2C#1%2C#3}
		{{\it J.\ Math.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\joth[3]  {\@spires{JOTHE%2C#1%2C#3}
		{{\it J.\ Operator Theory }{\bf #1} (#2) #3}}
\newcommand\jpha[3]   {\@spires{JPAGB%2CA#1%2C#3}
		{{\it J. Phys.\ }{\bf A #1} (#2) #3}}
\newcommand\jphc[3]   {\@spires{JPAGB%2CC#1%2C#3}
		{{\it J. Phys.\ }{\bf C #1} (#2) #3}}
\newcommand\jphg[3]   {\@spires{JPAGB%2CG#1%2C#3}
		{{\it J. Phys.\ }{\bf G #1} (#2) #3}}
\newcommand\lmp[3]   {\@spires{LMPHD%2CA#1%2C#3}
		{{\it Lett.\ Math.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\ncl[3]    {\@spires{NCLTA%2C#1%2C#3}
		{{\it Lett.\ Nuovo Cim.\ }{\bf #1} (#2) #3}}
\newcommand\matan[3]  {\@spires{MAANA%2CA#1%2C#3}
		{{\it Math.\ Ann.\ }{\bf #1} (#2) #3}}
\newcommand\mussr[3]  {\@spires{MUSIA%2CA#1%2C#3}
		{{\it Math.\ USSR Izv.\ }{\bf #1} (#2) #3}}
\newcommand\mams[3]  {\@spires{MAMCA%2CA#1%2C#3}
		{{\it Mem.\ Am.\ Math.\ Soc.\ }{\bf #1} (#2) #3}}
\newcommand\mpla[3]  {\@spires{MPLAE%2CA#1%2C#3}
		{{\it Mod.\ Phys.\ Lett.\ }{\bf A #1} (#2) #3}}
\newcommand\mplb[3]  {\@spires{MPLAE%2CB#1%2C#3}
		{{\it Mod.\ Phys.\ Lett.\ }{\bf B #1} (#2) #3}}
\newcommand\nature[3]  {\@spires{NATUA%2C#1%2C#3}
		{{\it Nature }{\bf #1} (#2) #3}}
\newcommand\nim[3]   {\@spires{NUIMA%2C#1%2C#3}
		{{\it Nucl.\ Instrum.\ Meth.\ }{\bf #1} (#2) #3}}
\newcommand\npa[3]   {\@spires{NUPHA%2CA#1%2C#3}
		{{\it Nucl.\ Phys.\ }{\bf A #1} (#2) #3}}
\newcommand\npb[3]    {\@spires{NUPHA%2CB#1%2C#3}
		{{\it Nucl.\ Phys.\ }{\bf B #1} (#2) #3}}
\newcommand\npps[3]  {\@spires{NUPHZ%2C#1%2C#3}
		{{\it Nucl.\ Phys.\ }{\bf #1} {\it(Proc.\ Suppl.)} (#2) #3}}
\newcommand\nc[3]    {\@spires{NUCIA%2C#1%2C#3}
		{{\it Nuovo Cim.\ }{\bf #1} (#2) #3}}
\newcommand\ncs[3]  {\@spires{NUCUA%2C#1%2C#3}
		{{\it Nuovo Cim.\ Suppl.\ }{\bf #1} (#2) #3}}
\newcommand\pan[3]  {\@spires{PANUE%2C#1%2C#3}
		{{\it Phys.\ Atom.\ Nucl.\ }{\bf #1} (#2) #3}}
\newcommand\pla[3]   {\@spires{PHLTA%2CA#1%2C#3}
		{{\it Phys.\ Lett.\ }{\bf A #1} (#2) #3}}
\newcommand\plb[3]   {\@spires{PHLTA%2CB#1%2C#3}
		{{\it Phys.\ Lett.\ }{\bf B #1} (#2) #3}}
\newcommand\pr[3]    {\@spires{PHRVA%2C#1%2C#3}
		{{\it Phys.\ Rev.\ }{\bf #1} (#2) #3}}
\newcommand\pra[3]   {\@spires{PHRVA%2CA#1%2C#3}
		{{\it Phys.\ Rev.\ }{\bf A #1} (#2) #3}}
\newcommand\prb[3]   {\@spires{PHRVA%2CB#1%2C#3}
		{{\it Phys.\ Rev.\ }{\bf B #1} (#2) #3}}
\newcommand\prc[3]   {\@spires{PHRVA%2CC#1%2C#3}
		{{\it Phys.\ Rev.\ }{\bf C #1} (#2) #3}}
\newcommand\prd[3]   {\@spires{PHRVA%2CD#1%2C#3}
		{{\it Phys.\ Rev.\ }{\bf D #1} (#2) #3}}
\newcommand\pre[3]   {\@spires{PHRVA%2CE#1%2C#3}
		{{\it Phys.\ Rev.\ }{\bf E #1} (#2) #3}}
\newcommand\prep[3]  {\@spires{PRPLC%2C#1%2C#3}
		{{\it Phys.\ Rept.\ }{\bf #1} (#2) #3}}
\newcommand\prl[3]   {\@spires{PRLTA%2C#1%2C#3}
		{{\it Phys.\ Rev.\ Lett.\ }{\bf #1} (#2) #3}}
\newcommand\phys[3]   {\@spires{PHYSA%2CA#1%2C#3}
		{{\it Physica }{\bf #1} (#2) #3}}
\newcommand\plms[3]   {\@spires{PHLTA%2CB#1%2C#3}
		{{\it Proc.\ London Math.\ Soc.\ }{\bf B #1} (#2) #3}}
\newcommand\pnas[3]  {\@spires{PNASA%2C#1%2C#3}
		{{\it Proc.\ Nat.\ Acad.\ Sci.\ }{\bf #1} (#2) #3}}
\newcommand\ppnp[3]  {\@spires{PPNPD%2C#1%2C#3}
		{{\it Prog.\ Part.\ Nucl.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\ptp[3]   {\@spires{PTPKA%2C#1%2C#3}
		{{\it Prog.\ Theor.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\ptps[3]   {\@spires{PTPSA%2C#1%2C#3}
		{{\it Prog.\ Theor.\ Phys.\ Suppl.\ }{\bf #1} (#2) #3}}
\newcommand\rmp[3]   {\@spires{RMPHA%2C#1%2C#3}
		{{\it Rev.\ Mod.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\sjnp[3]  {\@spires{SJNCA%2C#1%2C#3}
		{{\it Sov.\ J.\ Nucl.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\sjpn[3]  {\@spires{SJPNA%2C#1%2C#3}
		{{\it Sov.\ J.\ Part.\ Nucl.\ }{\bf #1} (#2) #3}}
\newcommand\jetp[3]  {\@spires{SPHJA%2C#1%2C#3}
		{{\it Sov.\ Phys.\ JETP\/ }{\bf #1} (#2) #3}}
\newcommand\jetpl[3]  {\@spires{JTPLA%2C#1%2C#3}
		{{\it Sov.\ Phys.\ JETP Lett.\ }{\bf #1} (#2) #3}}
\newcommand\spu[3]  {\@spires{SOPUA%2C#1%2C#3}
		{{\it Sov.\ Phys.\ Usp.\ }{\bf #1} (#2) #3}}
\newcommand\tmf[3]   {\@spires{TMFZA%2C#1%2C#3}
		{{\it Teor.\ Mat.\ Fiz.\ }{\bf #1} (#2) #3}}
\newcommand\tmp[3]   {\@spires{TMPHA%2C#1%2C#3}
		{{\it Theor.\ Math.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\ufn[3]   {\@spires{UFNAA%2C#1%2C#3}
		{{\it Usp.\ Fiz.\ Nauk.\ }{\bf #1} (#2) #3}}
| }}}}}}}}}}}}}}}}}}}}}} "|" is here a comment (catcode defined above) to
| }}}}}}}}}}}}}}}}}}}}}} include parenthesis for emacs to parse properly. 
\newcommand\ujp[3]   {\@spires{00267%2C#1%2C#3}
		{{\it Ukr.\ J.\ Phys.\ }{\bf #1} (#2) #3}}
\newcommand\yf[3]    {\@spires{YAFIA%2C#1%2C#3}
		{{\it Yad.\ Fiz.\ }{\bf #1} (#2) #3}}
\newcommand\zpc[3]   {\@spires{ZEPYA%2CC#1%2C#3}
		{{\it Z.\ Physik }{\bf C #1} (#2) #3}}
\newcommand\zetf[3]  {\@spires{ZETFA%2C#1%2C#3}
		{{\it Zh.\ Eksp.\ Teor.\ Fiz.\ }{\bf #1} (#2) #3}}

\newcommand{\newjournal}[5]{\@spires{#2%2C#3%2C#5}
		{{\it #1 }{\bf #3} (#4) #5}}

\newcommand\ibid[3]{{\it ibid.\ }{\bf #1} (#2) #3}
\catcode`\%=14
\catcode`\|=12
% HEPTH's: \hepth{9912999} %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\hepth}[1]{\href{http://xxx.lanl.gov/abs/hep-th/#1}{\tt hep-th/#1}}
\newcommand{\hepph}[1]{\href{http://xxx.lanl.gov/abs/hep-ph/#1}{\tt hep-ph/#1}}
\newcommand{\heplat}[1]{\href{http://xxx.lanl.gov/abs/hep-lat/#1}{\tt hep-lat/#1}}
\newcommand{\hepex}[1]{\href{http://xxx.lanl.gov/abs/hep-ex/#1}{\tt hep-ex/#1}}
\newcommand{\nuclth}[1]{\href{http://xxx.lanl.gov/abs/nucl-th/#1}{\tt nucl-th/#1}}
\newcommand{\nuclex}[1]{\href{http://xxx.lanl.gov/abs/nucl-ex/#1}{\tt nucl-ex/#1}}
\newcommand{\grqc}[1]{\href{http://xxx.lanl.gov/abs/gr-qc/#1}{\tt gr-qc/#1}}
\newcommand{\qalg}[1]{\href{http://xxx.lanl.gov/abs/q-alg/#1}{\tt q-alg/#1}}
\newcommand{\accphys}[1]{\href{http://xxx.lanl.gov/abs/accphys/#1}{\tt accphys/#1}}
\newcommand{\alggeom}[1]{\href{http://xxx.lanl.gov/abs/alg-geom/#1}{\tt alg-geom/#1}}
\newcommand{\astroph}[1]{\href{http://xxx.lanl.gov/abs/astro-ph/#1}{\tt astro-ph/#1}}
\newcommand{\chaodyn}[1]{\href{http://xxx.lanl.gov/abs/chao-dyn/#1}{\tt chao-dyn/#1}}
\newcommand{\condmat}[1]{\href{http://xxx.lanl.gov/abs/cond-mat/#1}{\tt cond-mat/#1}}
\newcommand{\nlinsys}[1]{\href{http://xxx.lanl.gov/abs/nlin-sys/#1}{\tt nlin-sys/#1}}
\newcommand{\quantph}[1]{\href{http://xxx.lanl.gov/abs/quant-ph/#1}{\tt quant-ph/#1}}
\newcommand{\solvint}[1]{\href{http://xxx.lanl.gov/abs/solv-int/#1}{\tt solv-int/#1}}
\newcommand{\suprcon}[1]{\href{http://xxx.lanl.gov/abs/supr-con/#1}{\tt supr-con/#1}}
%\newcommand{\mathph}[1]{\href{http://xxx.lanl.gov/abs/math-ph/#1}{\tt math-ph/#1}}
%\newcommand{\physics}[1]{\href{http://xxx.lanl.gov/abs/physics/#1}{\tt physics/#1}}
\newcommand{\Math}[2]{\href{http://xxx.lanl.gov/abs/math.#1/#2}{\tt math.#1/#2}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% BopHook %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
\if@preprint\else
\if@proc
\newcommand\PrHEP[1]{\@JHEPtrue\special{!userdict begin
/iseven {dup dup 2 idiv 2 mul eq} bind def
/BHend {
  translate rotate 
/Courier findfont 30 scalefont setfont 
0 0  moveto 0.80 setgray (#1) show grestore}
 bind def
statusdict /duplexmode known 
  {statusdict begin duplexmode end}
  {false}
ifelse
  {/bop-hook {gsave iseven {-90 550 570} {+90 50 300} ifelse BHend} def}
  {/bop-hook {gsave         -90 550 570                      BHend} def}
ifelse 
end
}\let\PrHEP\gobble}\else
\newcommand\JHEP[1]{\Jsplit@ident#1.\@JHEPtrue\special{!userdict begin
/iseven {dup dup 2 idiv 2 mul eq} bind def
/BHend {
  translate rotate 
/Courier findfont 30 scalefont setfont 
0 0  moveto 0.80 setgray (JHEP#1) show grestore}
 bind def
statusdict /duplexmode known 
  {statusdict begin duplexmode end}
  {false}
ifelse
  {/bop-hook {gsave iseven {-90 550 570} {+90 50 300} ifelse BHend} def}
  {/bop-hook {gsave         -90 550 570                      BHend} def}
ifelse 
end
}\let\JHEP\gobble}\fi
\fi
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% INDEX %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%..?
%                          	% REMOVED
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% FOOTNOTES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\skip\footins = 1\bigskipamount plus 2pt minus 8pt

\addtolength{\footnotesep}{1pt}
\renewcommand\footnoterule{%	% NO HYPER...
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}
\newcommand\@makefntext[1]{%
    \parindent 1em%
    \noindent
    \hb@xt@1.8em{\hss\@makefnmark}#1}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% NAMES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand\contentsname{Contents}
\if@draft\newcommand\listfigurename{List of figures}
	 \newcommand\listtablename{List of tables}\fi
\newcommand\refname{References}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract:}
\newcommand\keywordsname{Keywords:}
\newcommand\receivedname{Received:}
\newcommand\revisedname{Revised:}
\newcommand\acceptedname{Accepted:}
\newcommand\acknowlname{Acknowledgments}

\newcommand\today{}
\edef\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}

\setlength\columnsep{20\p@}
\setlength\columnseprule{0\p@}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% DEFAULTS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%\pagestyle{plain}
\pagestyle{JHEP}
\pagenumbering{arabic}
\@addtoreset{equation}{section}
\if@preprint\else\if@proc\else
		\let\pagestyle\@gobble
		\let\thispagestyle\@gobble
		\let\pagenumbering\@gobble\fi\fi
%\if@twoside\else\raggedbottom\fi
  \onecolumn
						
% FOR REQUESTED FRONTMATTER ...
\AtBeginDocument{\bgroup%		SOME NICE (LOCAL) MESSAGES... 
	\def\@APPwarn#1{\JHEP@warnl{\protect#1 should appear 
					before \protect\begin{document}}}%
	\def\@APPerr#1{\ClassError{JHEP}{\protect#1 should appear 
					before \protect\begin{document}}}%
%	\if@title\else\@APPerr{Some \protect\title{...}}\fi%
	\if@author\else\@APPerr{Some \protect\author{...}}\fi
	\if@abstract\else\@APPerr{\abstract{...}}\fi
%	\if@email\else\@APPwarn{\email}\fi%
	\if@proc\else\if@keywords\else\@APPwarn{\keywords{...}}\fi\fi
	\if@preprint
		\ifx\@preprint\relax\@APPwarn{\preprint{...}}\fi
	\else
		\if@proc\if@conf\else\@APPwarn{\conference{...}}\fi
		\else	\if@rece\else\@APPerr{\received{...}}\fi
			\if@acce\else\@APPerr{\accepted{...}}\fi
			\if@JHEP\else\@APPerr{\JHEP{mm(yyyy)nnn}}\fi
		\fi
	\fi
	\egroup
	\auto@maketitle
	\if@proc\if@speaker\else\JHEP@warnl{One \protect\speaker{...}
			must be specified among authors}\fi
			\if@dblspeak\JHEP@warnl{A single \protect\speaker{...}
			should appear in proceedings}\fi\fi
			}% IN THE BEGINNING THERE WAS THE TITLE, TYPESET IN TeX 
\endinput
%% 
%% End of file `JHEP3.cls'.
0502086.tgz                                                                                         0100644 0002252 0000027 00000331336 10252115170 012306  0                                                                                                    ustar   albrecht                        theory                                                                                                                                                                                                                  BB Zmo8\HDQ
7A@nvw_wێO!%w'l27ڍY|+*Nt_Oi$N)E&)ڤq|qH~hTBӭMvvRM>;8Oe{*նWr~^R,z]\\R6<__,R~^WRɿm-z/vv5\߭uJFI(JZMvռZ޶N|_󿷗|p
l}&UOD\}Ėt;m7JOn6vk}v~BJN>+h_y%fILЮ^2VJΙWr ^	Ϥ.9<M;sEw.ΞI6xyn9ݷ(^;y5]Zy6-ZKۻ%(7D -!nηc^:ֽS򨎖';R?-ZlMqn/+L󞔷VqCp\-Y;L*9+I7QCCk-wv.>vRIRN/wRz%`v\m|kΰT?pΐ²wX5Pٻm着U-9ԅlYn!!/@t?O4ĥ^|gWg
OMx[_짋e,hDګjqu9j~I% ,1P\NrNŤ\x1)yu3vv4ٚ@3	!nr^KH
C<Ewnsr=c
]3Hn)$y&jAX"y*UKN4fህ l`d3z*.z#ל|TEe:e<fǏG:@*hUb(9T#4Ψd1>̿7AG{nzAG5q.d70r>L	!	|>QV7~F<x&AgM;oEprFԋ=gV-2q|;޾/Vۇ=-nn_%<
jQu}qT/jz!螇2H=hDf |1\w 
xNBvrwؑ&=
3#<uVbgl7=Oe sdqf8ALRK(T^j\6~MP+i+̃YհO邒Ca@낲}c
3͟!P!~gg-{`PV+`ɹmOYvrSa_gdn65Mwk"sr^*]VmrLɛ}_Oυ
r@M|Dz@NH#["CcHISg
0[t1gY?l`~sps3?nx xLv1#O)E*=X@987ݷSaBv11ĴOgb8WoIYn05׏"~;S)!X#!pn[:{Q/v勳KP߷	/w;tgo8Vχ<92ç>D0뮽y #$cʘz?Pvp^z^O(4]O;7xWj{zmll0ۣ8^*J%1da6P-.P]^/|4\~sw.7"P!3N3{Nbh'bSx#baхӅ&vxe[&cB:5'02S;B}H\yQ'x[yo9#uv6X|ǕqMe8SyJoHyq؞bp[WMvaX)$\YgNi4[uEv)cxx<S	ʜЩMF9r
4tFQS+]!)mTU"S5M*RAŕ+JťK2uU0tSlJDʔq8J$`:J]]2]*sUM\7&;ژ!yBӀL!ǕuU$eDIe#sq)nv+ł\aݟ,vjR
,veMjkeV)jSR`aj*G2Iit:UF:AMI$2iDei<򢴶a%,:Db=\eWRʺB/zn25"iUhlP&u:bXh"q!#UxIeS><"E5}&$9K
<5Q\6CN2csWh,҂6{ 
J*[kJU	5X7	(L.	Eᷪ于1`SG|;U[ґgІ
/
lC˨2&`N"Pդb'P cJV~{c47jFZ )GJ2%>ˑ.}[>%yRV[*]>v:b`+SzjhBCm[2zi	OQKPT*Fz
Ue֐g }kRe9Ah,V2*`Z19UXUW*1	Pظe	K4@
MQ#1s-Ѩ6޺.b/Fsnmlk!=BPvsв\:+UbBL5
J%*)q
a$'9,!I1vƓ#"$79XR=PՑC䦴yn30Ɗ@1?v@}4=1{jEAi*,t`TЎ W`3P:?VViQ)<5P.үF|7
'<t,!|,={">u@2CT \D"0G!`Ԁ(.<J`T!*R20rDYHii-9`s1jڠkH~USl!İQRAc01PQ"ۃڗD=
R;*,%){*+D	O.B#TQY/[N'bMR3
X⍨oĔ%ʳ($gQV9!H]ϥզ6yW]Zȅ@\aJ9ڳ; Y⌆0Ёds=(;F߂/9@&"PF`?QV91T)AM8HiXi0 
#-ıLfw@
->hߌ4Dl߀441OKc4+AZ(H]i	(Hif48HK*1O#>.M>.Mȯip -EX3
`Am(Hai4k>.M1OKc4JȨiA^d(HVtN4Q=OKc441OKc4L8HaiA=`!A8HC42içFӚ,,Re᳦QXpR'ԀGP%9=4	6.HDyq7d7 Q?"cr2@3)],d2ǽ"g5&#$-?{;.q&r"1ʛ
`{Φ:~oYeM&jS6&tgI|Gf> CcYTO 
{o
{b --UQ~=V4ɀ3GU>ǒ<+҂6E<	0j%w R'}&zGj|QX$|"QSM0'lI'-ϣbAZ}>M:G9_3hhѨa4m#4w(.U9- TxS>dMŵ4|j8y,3QhsRNx̃@X7GgGgGg{idڗUhYN^g#e,҅J,?>R
濘(Ij#il,Mio*o
[*|%uW_.T҈4Zh&tG*a=FI@Q97	]^p!d.xOH/0~ĭ/1s*:Ci7Ccȟw&q/8RRLΊA+yb2~*tm`mb^q!Eգ(X[k1;yg^!mWkBԀ̩F(Lp`46n1r$9Ӿ'5
q .xu_bЌIs*hUm`m8M6-,x-xNrr}P%&>Yr(	4ak#^ޢI @Ԕ  y6ܐUA3i]08M>l.blPa9d 2aӱ8F9حcJFat%P*
⃅wgXƐ&\y={$èw8SvTcu ;C)"$
"v/U>RB@
1Q!X;; )/.6 N*";&^nyv;l/jm#a ^^w#4rOM-`py{ו&N}3CIneǖI<$(!"	 %+Ysn %/y~LB-w=vK]q7B0m  [j1&0)S9`]M$c܏)H)x"إJ%y;4@6p&D$pNd,لF|`p&aI=ᰇDFaeip 0'1&J lnx/u:r)$$b GSeY@0ZPjH* F! G $eZRR!S@w]Y-2(eCX틖RCRh%y%̎c4]!Ƅ~& :ǆP!\-P	${RJacM X_A1Qop!3L+i
H-/E<!Bcheҗ?w<HV9D<Qp?sz?ƫT¸(*Rce΃^CCC{Ba8J<# nA
ǝ.N
 L2((a"WI{x
x&%bX(w|!|	Eē+AH8^
TOc@a>ta_8Bw<Lk@L;p
\rufv"@4C:Z|XIǂ*(ǀMƐ<DjD 3%fa-1FBf#A0/Fh'N
"dƆHCg'ʠ?C%`-3r.=ӡM@y_"сS9m&i73:uF0x\t!"gF@>PFѩP's}!vbl@ B9cFe)L	84HJT߫F""~pieJ }D!b6 +(̴<N
ER,PD jȄ_-ulD;9Quѧ|,q(b ,C
Zrp
JhM A0bx][Pdc;AğK9O8U%Cz9frGi	]Cp8Q'8XV/DR"ȶ|V'L%r$#1P2Xq!0dHPHf
ٌW}
x9(`u$`5AD::H/:K4zVZ!_eCxQL#
J$
* ϩ#
<Ɛ+Cb#؃l"jX h<'Av%35c4;q,ЍwRNeb
I+	$sל$&e_@#D6QUTA3 s6Cn"\ϋF3lC 48@E
`\5,@&E'}Ş@QTlf \
ANGφJ02aa
-F:d*^hCpa8"fyBT*>yrSr̄!@} 2AnQ"Bh@"HI0!P9,+B&0R0N/!ߢWd8V,EN}q(h@9\_zTJ: cZEȽъDh<\D.VKH2V'֒
Y	32䢼2P$)uhEB-@[KEr#
%7P4
&-50vn
:*GYhT_ S@]ņ.9aHHTJvTG*уMiNa
	$VYЀh&Ez8S6JX*O7Ī8jmm"|S5yu:bO.L^i!!; '\*by[ʪE 0,.o,!d4לxU
?x<,0#t h<\f)k(@ыa?ʸ1A

e[	Hqg;0Jw
ZHUVjSt,ZUNgB.ZY)l~ZJkԞUH*B}=%@)ņaEpjwr06(h
A5áj㨦H}x<L*<r-~걆0Za.EڋMи 'a
y.	0l04#`M+p3)^g)UTͫdtbU%`DX^9Ns({3q B`&ǍW P,eDD,'ò` ZSdE++ 1DAdO `[=v~P_I!*I	 ]WD(
Q<qc5&"IhQ@ȌsDԂi 4ϕq@SHV 3>-+o @jc=
% J1H#Bt-O6D yG)|/0tk 728Zl'GZDRc}!a 52ۖoTԘE9djERC`K`1cJF1~ed*cKm
[kbtS\{@К}4JBg6#?df
ٻ=BD(@.sx$]]]<`ܸ5x\R	 :pԃAq?Hzkt-w]w=xNl'? X'=5m- W`[0Alt Tǻ_}F|܀)  QhP6@Xp0M5\
\LzZ aR*SeD Uk{A!J 8eF%]E^aV>w-2<w!Q6'MP"D1T-{P5+QNN;Y5.9:ȥPhQ7S#/.^,4
Hr,ԴnLH<b[pdŢ4Yn7(Gb)MU+:DD^(1ɩZN\x/ja$5X$	4'b +SE_h-r,JhJH0*;PXPi'j! *HyU6z̽hԇsʵH+)du܋Nn,@γ ڪl=J#h,N@-meQPjN(B\=NnҚQT0z
ـVlԦXf( Lo@r$"#߱VS`9蹂
%3ږ{f8˱00aqK0*S}SThaͮ&T$
f@:b0\7jo.(|E "'čJLmf8 p.RPJ=H5	F@FvPvi1 B`TvI"M4)j
&­P|BSJD>j
XR%yi@^SIxʾyy T4k#O?1Kh˘nlZ*42@_LN
BG|0@415*#{PR!
aBH@@I֓1ublQ֥`iPBɈ=ѐX60FvP<i@BH8tдQ@YN8ZH=
95X
0>՘F(
Ƹ#K@ǬP~! `h}ޢT FKᢦ|D`2⥇2}0E-CB5|!_ =ҜW0&	'y *Fv8S|IE;Jx%(STؠRr䗺Z#i3 Agb]{$ $  OS0iCȻi2he:F>)>t24rAe# ˾Ɇ81ޭ[M~Ji8
:E*J2F@VD(+hB3E@*;
Ѷ9,'F	6hԃVo"sEj'a:0d4"
)U`ZV)!j*ҥNM8o u*O6C 1|rVNdXR9Lԑo*gHuVAdU̡WB~DT&*j"EɕHX(@Z >HvԂA!<+C$:)gq#
f(TAi`)ÑDZԱ2B
*(AQ G#]r0U$_BhƄ@
lh*#\WML9@5]ցhH$U
4cq|rAc-z!Lb6Ͱ!愎5MDOMB[JBe>;:IMX.JmAKq	L4JYB"AܚX
,IQ
P(}PlRe&/nbJj\
DMTЌ$=FLԊ7õQ2723X)1enQyف(ZPA$2P#u
A;ٓxnA Y8 ndMK
Ĳ18pF+9/C:Jr
i!X-d5 pŅ\¸YF肔L%Z)xD
dH 娓?Ȇ&8dgp;:yI5l=lE]*?aY95:P$@F(Gd*P A43$H s8`~G$c(u1X;(
7QXH!J$XS0GS <Fz@TZQPSD{ ʺAcNͥj)HI8
Ѡwу\>9H2Aa(Dn-dcC񽂔dVA-þCŰUu}?LɼX:chŢlUJ5A#vSҚDQ9^[baAp@23G	Ča>/@{1GC&x(kg:"zQTjɑ3v!:рCV1ʅfj)߈6\#q412V! !,Ȋ>1cNHŝ Ң (}b#rOR
NA@<dIX#`Df| C ݹd}43|T*53c4tL+'@Tsb҇;QCJl("Vޕ{&`) ܆J
)2Q!%e*nwVeV[T"a=ҠXO<]`0Tʤ J1&{_Xvl洧<֦
NQvUk*\	jXF`a,4M?/:,O×ޗ\Y H )'uR,ClV]̋}/aM͙2F&uvcfAkj͘E:3"1QQhF^Lc0ďc}.{5-%0Cm
&l7e,r>F:'v<7 @] .WVn]RTHI;/J5*cEcSaž8A6)(2$Bϊ=Gi
PwzE,̍nV>Ԕ556dg"b6$E0%*:x0JJ9<.'H(>U' ɀiಗrX=x5+-Q,_gV㎥x6I,<Ͽ#cz聤iWi4ʛG+S,U/8[Gr@ZC3z]_SޡPDs`8
4)
Je5/,yT\b/o WKG/TjCH@g݃ʦl?\+X~-(RIxPPN!M#jˍ0` &ReN@!x
lA%tuGqA	O!(j9)QF@da!1gLU'EA3=/LTկH}HD-iG¯uR!B >	QdV!{KdGj&{4,TѴ&k7+5w{QDNDT+IF/7@D&DW"/FIaqd݁.*`# 	`UЪ7Sǎ @sZ"®\$UtHfL 0k߰&<i&ޔ9ՙ~F 萊JԀAD@yuEXQ)	~L	CFPd=k )JT/N*r?F>4GaGՃQ'YpK!4
16`I-h>$ V`uN&(d	 !a	t4e=͇7u<Ik835`	4GGQxl(]Y4HS2T.
.DG"6c DC425(r
	*
p[9gDlPɥQ[B䎤
Fz[a$lTbW=<CfA iB$*5 gUR{: Y9Y{8vQ.6 k9_XYƔA)!7
`ށ'KoCr[btA!T,4[>&=Tg%Lt]IAI\e '1i
TУl:%[A	J:nFפ0f5N6la|G

]3j2c
)pdMAVe@sU 'VFQWD8d9 &4!(*h$UE=Q+GqHsEGF}3ȥuԾ^6i:SsaBIp4*b!X{2
\2&12ciQ.'D (ӵ.AOH|"kv+,or02ANFn>F# JhCҶpRф#/%T: Hxֺikya}ב˾*cF؉PMP| c=
;>Y_8|	ꙀP:@ %`wqiZQQ$3_.s&L/q%(Q&A()h+ChfbpHʑ]ASU8@"H%3iG <..BFq:X"_gҡČu|)%l;Y592#lx"р'=5ugDE"+b4a*V旾F[@";J۟#V$@*:"$g-f!nL_Y hȸaf2:eޒfGp 	k6#@h,Z%A-+ۛZ.gEHd#'Qϋ_x9>M*֜<UkM4f#m]y,Y
-A;jqJ	M-Ni<ðz
W	1gd5rG|cpؓٴD
y9e1̔{[1q`9
Z2b*L
aa̮"q#5	0GX H*%lPĘ3QP؄F]CCMMyGDl\%jYY<s2 F$C:f
0Ep1$dBN60z `mٌTiȆ" RJ{B+@`
fEAR@ ZsR t jp 8)%>w)A+
ORPi@p+@&0h?cbXiJd i)ulhPp3s:|:fbU PWK(}WyDdH[i(%>`XtI[+#Tڃ̕c
QG
:i`rƚ _e
Ug`*#`k`Bm_.TGЇ]YF@:D D1Ր}|+S1Lmz/kp
C$kj?YNY͵
X}B4*f!NoNh(ƞT kW"H_eOh@!I
4$n#[8Ŋ\5#fо|SÒuo Lm,|L&p
We,1Q'2IȚ%+˕IK&ؒQ4`D!j2u$4<uH33qtz7l[<HY5Eqe ( f=NqY%rIDjA	J !Wd d4LX"	X{ٮ14BRcC	[c;hRӊ-6	m*QtH0m?wLcf'X*Q9F&CJPXꏠ8m9PcᎯF2qJd@MQb
f=G9`u('9ٸGԦ"*4.6:hXdZU
IReل$h̘*fQRDE`}C@twb
v-5HU1D4vHkElaxv2NxǨ;M(Ӡb,FHpK2k59d1ZDXMF6Hpj.}&^9DK1."M)%\f_d奒Xr0X3aݢȱv k9jbWfY`iR>1s6.2jیhM&@
)c{PQ2LP0u3s!HNehAEJP |ygZs`e*YcUAq@ԅM$rĘ)$+QtY?nr\KQ>[1"p<rB1D- 
gP,R(F$<A#x̸A"dhCEdC[ò
EJ[4d7뢎58T
D]EEba8كuCO)A+u
{'4͔.Z9}sE9Vo/dC0X!5q=#i!H>d i%gȉQ{L[='moB&jc&y>g&VX?YXr
@V5{]dWXXROb_fW԰(L+nX lpڞ1{Swj2ZI7 0 mv%2PMg/xx#;.{~+XAn0n,eH|BCuTCKNPfnks@*_n+>{G>ݟ[~%o
~}BFsAA#OLH-@d 9VrlC
TN
,d7 u(\@p02rrx)&tۂASB(lx̪]'n*sq1{ZpTT7$"^zNЧ*r8U"5S#[X݈Eֲ RdCgpp:¸ќ+2E)[Pzicv/5ޕa	099Xf]H3jP1bNj_QtԯXҌ@LNpԗr6N"0eV;Є6Hr45Elrʑr3J uJQX
A?{Qg&DCU*)KʁBKګIʧ%66,t=VV;0V

u㴧J"Zi$sZ@$hL4x)hX; JEV!$ł״)lcwH"D%UR
i-"dJi.2l^%B \(Ġd(4R͔O$1YxE%ςLQD=b9-b:-mk8zk<JNNta,6NoN'@ƒq*ϧ[W('cC̗2~ꥠ[

s(XJIV׫*M(DW4ae>ӶBI+j|%(ۨg>$y5Of1ƽ:?d+p<mo҈cz2+D=L1qy7TGF0Oe!yQHZ{΀E;%qe2φڡxTNΒ#B45L=q܊Zq·wDck|Iܳv#<T ,:9`PY#kc_ cVH`5tWu,n4#cNs|NZ6#e-fc+h5r;:
HtD3HH;T`5EU԰a Դxʡ|iЃ٘H+gbhcN9GH
Plx6HPyChoW2ۮb`ёx s`(2" [4ǀeLBE8jOU0$!GvԳBEkYd^PT)Ý$;X@oE>hPdE~~s'uKj1HtF3
P`Q' $λ%q5bAA%
,]C)ajm|t{zN@(iy#
)ZC,*]TX	\
%h
X7
Z,2J]xҢepNS"G-i:zV"OطTzYW	JLM(2HT)`y*?hΡ
n0+'J$Q#H%A 	16" {""J1cF%ZԠJ )9y";
nغ4,Rk`m(SYVdx?)-$ +08{	H-YT\AE(*`^OLi$	8SXmkrEq@ȼC{zj#!&u<FN.b1P`*@CX#D.AYy?@Â1ԽxrgD:h@aEthd6Rt\:
ɿA
q4v!<%b9sAKF*7g4 (Q\bDD.´qu5C#vo2zF*b虁>2f 4=2eu,He&=ք|T^+KRֺaoifSsP.4(4'!泪ۧ]&׎ݝ!&YVN1-,':{X]0HJEU	KX@=JE (:
}j#-Y1JJ`a"vS99O~2QeM옴BMhf#UwR\XM<H$
pz2Jzܐ\.M`Yъp_^1f	`(_j.dHEA@Ԩ3&~*k4fHc3x}j7PW1U\RDN.EF+%-OkfC9d=ע2	=ftVX
d#Vrwn54

f&ZlP3[v5"j13ې(8Zr>5B\ՃIbN	H|0F@o&C<
/|6wO_if%Dؑ:a%l'ZiЗ6%ϱdpo^4;jBc#8~^m݈se !GPHsa˛DQ_=6NZ+ɸf@k( zKX%Edytv(Y?x|Dy]+46'0ujM8Ӱ]ijecрٞq2igIvCir*f3(cEQҢ$^E6ҴzIt2ҭò9Naid,b-7ʍd}=&ܯ(3l9XQpDR+AS6
(&d<7<ԃnE-fPX㓳JdR`Hj"1ه$+ǂ5 GE:RIZДPH~2tJJ3--eO3=Rx dNe`5PQˎTj/m4J5dHQ4a4uqmNqgQ@(\JԬ\U 53,!3P9`2xvb.  )-@fH1A[!&JS
J13`o	J,*T851Bc,!K"ߥ(Tky`zʘ'@]43&!n#8,ktyp|dHs~Tg&RI%œ6ONE@gO}AHy
qPg1e$;B@8AD]fe类ӋQT{(K5^% ~g;#g'w=|6! KR`{4]|Cz= :5GY樃]kF5V^pAorLT#fȏpdB$
6 
!M`!PrTh\4Xtd=Cݱ~N]PTAaEܢ욖选;!{RsK2;bمAs2"<h:9y-sl< Fdp4:0¡C
GTEL j6GVI#7Ja[ ԌZue_cT54SvhbiP; c|2-	#2
XL{Ob''ઈ<Г`Cγ*L 2Rq>xjh؉bS!DDz`e呩\xß]
s4RWS/$[c/Xg'j]2b>Bi%t0-0A4*Ѐҏ8+\pZݤr\ԔbR^&x`tD¨PJ@
B䱕̀'`eR6!0Uqa "FzURڹ	 "\̭
)ъ )GeH"x*M*QȎ LVy#ԁ	B/QS֢-A~4n("d[GCK9հ1\)I-dX`ɨO\+OyJ2x-"ΰلgADmFg]!2@#)$#z>G*4Fp8j%Mt:P,0oH94E_!xDhƁ4d'iQB ֕dt`#='	;'Ť~cVltWTWa0bY"i ;QKD Q-R
b DQ0A+ -b=@|P=cU@D}|H}XC?DˢM'pheZX:I
h"&EӘT+GʧL`OGu,!br+cXpQYd;Q3"2:*g`
z\#'j֛b1?Yqlr7>aRF*Rm|mn%>|FMM[6##qA!@@ϜiQ1C,ʠ|̐:qh~(r6Y! Hd@>CV?} au",SI,rhqb-NNd&Q0
kq?5o6e#B5T&dHzFxa:
Q*zOWHc$RfrM<#x\Z$G\|Ò<	D]	*wZ9T-#Sd5eIƲi@"
!)e8_*hl(0T*W)q5@"S.ep1R35FV$u`&J^rı<CBBp[<|
{ꤚD_	z*!
08fOV'jOChF9Dpe#5]j-	H	[ cd0L{Ν-`6-53m4K8Ʈi|
0Ԝ%Dj$q?So>l"YD5FA}{lX7)چbOح~O:(8uXq)J<\;Z
!Dڝ^#[ꠇNrDUNx^swf!NbZEFBb zuz#k!=*\-gŘ}_y%}*a#sj6{cG6/vWnqJnmFI7Nʒiy@4ȔU
}n,	
M6DyE{̏]wYePH
P4dDk!EK8*csFZU.5QYή[@evn8#x`vSDA]e׊5P8R\8G "g&s\o9Y $ԂmUhuod!0(0{J9_5JJ3H
ؤHx~Vc-wG*<-\RhA6<! a	VhmHhRGŰȔTi5	
CcXxI(s{hfETUH<4`f*W@ -eHM'M`*Ւj1
E&U>Cdek"NWe+ .i{Udt ̜TUuIjo#3"Qy#_ᱵkC:-M2(F5pU*v%er$3@1.%Ϸizd"v5@痀нt,8EAx1}dYc	%x-$@Ϯ+3:*=Z1e,H0R1#jP?=Ec܂G0!ǉ)Qׇv{%j^bʎĈP,W]Tr"rVil41+tyuR#EԨHXq 	A}HwF6:.zV
R	0,2cŠ!	;kF 7
#Cۈ> UD8kRL*+JN+ؖY*3b Zu%/@%v`I<ي'	5p$76,Ģh3BIT4i	OM9hGb
̈2m,w8	1A(.!-ʜڐ	ɺ,żə	F*L3sJY~R
)@P^ᜄ1k΢f>-6"GUɰsHŐ# u`PX\[rvwD5Ym-g	C A_0K+jw0LbQ+k:i/
aX@@5-EH+fntVF8i*a;W,ΞിT+(_j]e=#cT,:`XBF|&hh(4\JF(
C*CVmq
*zw <E N2OެlZϮva܌1O=|Ӓe	-J<D]JpL>h,;Cfu^.u_%7e@o*Yvj

Yh klt:ipM
xoJ@Z6>xN0EAñ#e@>ìs
ѵ|152pBXl}ѭP9C>ZQY_S*2&S(9BFԊV#
\C7"=ΠȤcQ0%lc`j}Y
yG*xӲW745$Ju`aAU9
@KGkWxh:>3V'^cBl+D
~D(!5R`<zuDP6)șOORVxp>nZj]V䡦csv9Qh} L>:Ϙ:d1u=c"됉ϘТ(xoty:ӧ_<Vrvp|\,(OG3
:<=7yYqmW|'LhȣއQSEz,Cw8D$rX
 /Y~*2)ĸ_*ZCVKSq1e\vvBF\DY!/ϩ,Ŭ09
3Y΃c#SAG+jAFq*i/VRBp bBB*<VaI/ĬN?%V94b
+C=2@<]H<#3K RF1)N-	"dbpP&8"9aߴO47FeY\)XMzգRJ&O&ro`&fP&"űq@S9@JіH03hD"@*̹jNd1Aa8g\,T7d&`2T
:.rg)!^)B,0?
(HPԨ,LMX8
h!S
d#x<
L`@Y"҅eɫo*A	3vgQg$G<NnP1e.',@lθ˸`U:X~!"ä"E~'^\gϦ+1NV׋>.׫2Zzz5e8;Y@br5]<]eb\nǲqJPK8UUVEz;O{u-}{$p#{e"
ĕ0c]ad/Ɋ惽$2w=3γSL.}idjt	ddM'.^
|/I˴QөNȶt*0"̓<׾⽫p:|Χnr8=_/vv85;_'ë?{_P$Q_?<Ky/aj/'/Vwz1/wg 9Sչ5.`!Ds0|~y}u>_a^MV'/ΧaZ:^\<ACRasyq8?^@tv?Ph_hEV|>/V+#ÝVD`<*$J\NwSpEZ\Oѳ4</톼>^ itWUx<#Y[j}Ƈ})OC_OX8?o.毦mx<<՛O{ix|OrwlpAxϏOlv~?I$I`%&ux\/W*\ k+4䛶O~
^]	뾜>4v~!#$}xBmh
[V3}
o0o
ggt|'7}_SuGǶ@]1g-@F){7Y*dG>E6ܙn$WZ1#P(@w巘œ 7K<aiM,7qacz؞U)>eKaj/K1^"<køu^/\z;?1__Pfq}ZӍeImC_koCiϗW.P}9}|1]@`p6ޜd~DjrzJ	"Fk;/{yO|9%+ҮUL|y  D'w=
Iz;;ai@;=:?B0Y7G
D0Z
A|XS
+j~7Z7go (Xvǿh:n;2fw
Zk#B[s{a#q$n|1RM!vE#\$τܔIڛOnJ4 XD
zT׹`89;k[(L(,Nܫ>Ed+wȓZ5 nXhwnVLkjPwܫ:o#y4
@l/o:엌 'o6Bڳ~Н85y~i_0߲Oݻ/@ # -mFC6g$'rqxc w\t)Y"P1t{5_:ͧy&t,%BjʫgTOUU;zd15:SJK^TɻN; |n]S=طu6ooI,mG4{ w2:#~2WպGmo_[a -~"#!%5wE{>&K:b]lܶFn?쎮)5_H|;*&D0MCB[HBr[Ho!{{-oo!-PPB@; e6||\ [ 3~Ќ; g<l2o2vwu.&ww?][?FY.#}ǫڮZO}<dC?Sw[b־MG1|afu 񋁿6ȿ
ȿ| pB\
;DHҏ1oM[yϏ?v®x?ϻϻ~m^^|zvao_LV_fSy?i1|/q/qx>=]ӳK<<V~z*o!ok8Dx,C<y~>
g2dt)M^Oe,gK|!#zFl/'ry2Gވzx~,mQ|U+
#^<Mמ6մ[`w#YkMtOgW| 
C\::`&fI y}shDi;p([mK
gs٩Wx/(C@> 8IXKaD^vN?v&3/-;syz6\!,
ca;
/&/x`}Χ
܄7
h0Є[ކ7ҥ'nla"0G5:5}~a{Ui7fnh)>4$=T,XLuo*7PiJόOA&\c]dQkU:Mb:'lvu*j时?dGkKOk~ɍN|n!sV
ւϫ
1c,cRկ:[v(XAu:tq}Üooͺ^B7ڳĶ6ӠPd::#!S4
E`~`jv2k7-΢-3?O:
DzP_Q|
^&M:9"M?Q;޷ȣ8,CݦΫ$6X;T;x#m$oo%ͣ#"IJֱynbo˦$qLmVUJYo{*:cImcI+;ʻIUoAm꭭ YmpP'✉rq3?b0\8woD;7V.ƛ?-}Pwo-}͟w6`v9y
`Y,'Ա\4[Ȕ>7A^?Đ4+i<D*eI..2"s2w'qww'\ȣ;z;Sn;xSw'uw\qWDvu^oבuݺ^]{/?{{hml)bOڐ+Uw_Ѡ[0o ԋRA4
	-i&0x-J0M/ô H&\0Cˊ0{e='s'G{"Cx.rbygâ"2%a+ӰB;fr|*Y։\N-%PeAL.b<p{]wQ8j.ΝM<ݖ.6)7ܩ^t˲yӋ;wG7.Q4{Ѽm<JG;sN.6TI}.{LQ.0\.)
۔U-׊jv!Xb`Z.B!2K߃} +q$!Qiŀ<"x-IZ̕w(UJs3
EU\ki]k"9DV+K1<es!u±]nZsQݞg] *`nCM$SLEl>ܸ\;EIҹS;1rܿ޸LM.MPjw_6;gڟBTMlBQ[sSQİ_%Q>,(?M,U %3Xx0'WR"nB(j&
f#|IVP<hHcݑp9=Am.kwrp9q.+V>
WOS*d6EGܻe"/
wQ:-wEĿhPwv.z(:aMtmPrj߆Oz'	KoarJd;ĵf@Eɿ pdg!pd(gN SE`rQ p\E\fe\eU[;C]
}	ND_UZ<wG߉t+utu6}n
cm.{;}ÆHdN|^[ln#0Md~o2T,ְ6{ػw
{ⰃNO݆'oc{w`on[.[aoj؛aҰ76{+԰P%dBN{+a/g0_WӒ㜋N7ԫ9QƬ!
mMRŅW/g2zaCЖ={PC_<{PC={PCn=*~={7}3C={PC={PC={PC_PC+㑹+ȑ+QN+:`LEfx f(޸:w[D
Tyt*ws}TEyKFw\%4꼓l\zaY"20[.r#G(\t[.;"S5ܚnY)ՔK:H_Zy&d\հa?C5"wq+\A7AqPzV|>R̴tJQQpVpKWXܕ]KCCCi!u-VhHE MQW/qsv0u$SHh5KO{Yͯ)5ԭ'[^[k*ZJ쪀sub+jBL¨+آ+:gC}]B YA(ݭjE>h52L[*,@	r1
ޯ>_NeYK_BvP
M **ܧ+P"
@]>]̡-7bkְac@ԊC)cƙ:Nn}\/'S8!P2*Mbf׫muFvtU5yYgvoE,tOuy3j1Ī~)2̕⋬WdU+0R&VԵ"5XGv!R-yF_5Pt3	,yWXs31e>꒺kٯN(,俎hmR)\amжpef9l:.hmkh;Ndm.ڹ%s,w'ڮ׳ehmmALlޮ1]WaxmZԪ&kx9M6MxKxZ%*	rcm&ޒ=Vm4a"]$PCӇ={PWgc={PC={PC_ML8xPC={PC={PCC={P/w7D=K=ߓ+בE;gW0BEqрjq'\w۬wǝ{5w:;S/;wN-olRuz-G\4~npx')]5WSw\ĕ^_ԹpŢ2Wu\_.E_Z?C7+ةgtJW׊\n1*W\ҕ
+݊4/\ٰ-K\iJarWQV`tEl7HP1%֊%jEX2J^cBWSjEŚ?%aػ!Zvʅy\R1dݯkYiΦ_ngg9++CY/_6$j=
׋xB_[M,vZov56SakK9l~pXjxU2:lL:hl~K%j gn0':dVۂwKNW/1}
b+_[念
b*z*z*=*'cCԐVnJʻ6w
:jr+rR)Y)m\i푶PCZܟv5,ӹܟCZW!mnnאyis:?e|qYFqY'Y~[wtjqr>Y.շ768FKAՋro.'ˋjy6{|qMNOWs
|97Wu{WA|Oϧ6槧KBTzz1]^~{s4YLg'7޽mߜj*_].tܓn'K4|~bώ'{v
t^\ܠγ勉,{\6?ٹ̡,	}۳g'þ3gÏ?{\={x|v3Xr>|+-ӫۛwI8|d'|_	?%O~'ww6Ӌmݝ{{ssx||1QGݿgzs Nw5=&{?1?kWOڧial5-HćnAO.O'x`z7Oڨv~"1]N߄Of;^/na8/_?,fl=;y1#oBãś?/gl|6<
.[vx6_O}iHO87p@8'ɋ[iJt_/Wk"MOg7ů|ptX`WƔΛ6>^̯/>9ꓽp0zh"",j"Z~lw,igCr3Me\Mggx1_ya\3{z5Y旡VXWZW +!!#E(! ٩>&MIxxaA0+8	5+8
/`ΗG;fC`|~br˫Kzv"Z/ײ6RacL>\d&'/" PڐOP7<?,f/q$_Le;_ʠgٯ|?'Mwh]n	*_B(8Ndq1ċaj";*9WS?_O:|5ίe;.| `B1DǓKq2>@<_Oۓslj
i\Kt'++a&[)<hvj1pd| k	WhRHt@zQR8Q>|zj 6BB_(C\`N7Hg砖Ubr*$Afz~>qdŗ痄TYG	BkVקoD;ԁ
aTW9:f &$@
pM/t훅 b ב-t_IkVAl&{tT|Y&%I$׋  {n̓KAQa j1;@m蚒apTg|Mwqil?cF{\0^Aa' E(w]
yn-t2-RjzۖT̛+O@pù2\pNbӹ($5 g7$q(jƂ9h!
pn
v]N1XY``'Kgӯ&(?"?<F3<y\%~3{Xc,DH`EF#LB`O~ΖBeNNr$<[/OFO{+a޸mA\is]"dpv.YE4lrPTnA	$ m,<%ZVbQF
8,`]̖`\٧ْu9&Ix<rg7VGZ@<̸Ђ/Qq}u.']}48=9\o<R[+P<y|t~~]I|pAf=AEƙb9_uGkP镴=<̧gBq ?ra^NVǓVcUwwdrG
CRr\Qgس)73axlUW<?{":F-!Rh
D+pBPmоV`J:ȌI`NO4#d5H悚|bK!T ?k[BU8@ȄX	[ƱkŎt
s1 <@dscgF|,bP ZVExl-O
B$rymdF٦ř9)w9
rk
!+OB&и&O	=@qgH0ݮͮv
37	t2=w@#T0\'D3V PĠiAIQ/E)A>=́T݁YdOiP XW55zg?\L`Cחuv18Y!jtBKh=dJ~Bu|y\M\OªssypqK殼(	dNwos0>Y
94 Va(Fgpip[BIe@hUcTwPdҸCyyk"W3Q>?70	56/`K[Tڇxj$Lߑn^OOp![n+;	\5scݐF;w<.!a703`#(hi2ҙ`>W$JsÐIz~" 
&Q5j./n2WsL|i84נYTӊ
f8W/SX^L/Hr-
ЋzD?&4m!B59/z؀dw]jKsL4hbemeAݦ0OZl1z.z/h_asnYQYdL"ixtc!_ $qU[u<Y0rIfIxi._܅_w.
]8k%Df i9]Q0.|?MrKctrzȷ$4ޅ.rlʥ>L V.d1zFg}S%^45]9w@O&eE3F1jDYaxoo+*^_Mh_*_n1(/ѥUe^ (E\3=+g/s	(!
GT%07v»Y9deΧv@UbPe#!b_ܡo`nJM"8ANu# ޫTre1޻mCJㄜI?͠
9|Y+Ӌٸ`Ȧ;E.V	t*96aKh;ߍR)5k4YK?^/>;m:{9PX 
 ](Wzvq4fj8l
=?7%
Es`%+`c!YHRM&U&*Nb(*6Rr hT/	!&3ɎgL*
t:nUcikԱ=k(Wpdn;^4w1q
64=^
>]P`N:47VyKݘ-Ínۙ8Rr{w٭X<y}{Ԭ%̈́'˙i6wEX91+FdG/dُZn~~̋91J|QhuXDxi`J_{w2xm.ORzv=pnS	NA#iփ0v>:ƶ@Ϝ*̫H$b*S+Ha7n`<%tvu>=;?D<_L.Qqqf#gXjCKz!pradA>{/]7}nr]*܁\˜8`&^&gLΥ3CnTV߉&(q?[5GUr2Ie[_e_Qn=P֒ۈCg00]jw6}d=vD~{s0foeǩLHuT'_leH\e|L[9HfWAo+wfϯNbu醣.u`JW±ɒ:6ӳY#
ZE@fhι&{RzU0sý1z_ۊ:}r|:LbMY	+mϾݜrfxΚl.T,iÂbz l5-6~j(DZ,{J&|x^k1cjJ +%`ܓkHF'd)BՔ>."%,3ȫ>w	ux[臈	ז(PPݐǄ{x)D8dU2e]" ۠`mڰ38U2lvP@W#]s!w[gPt;2ؚ0lDd3W{SL6Bw۾ڰ 0<alQ7,ޥ*K[4 >b	Əu7Du轣tOv1FԾXӪ3ޮqt͗T(,d_"
a>]&-mu/s0}[Ǜ<!Wn?G3`{:Bۏ;QXZG5jl6?7;Nwdl>(eg?k(
/
v!o]rfm~cTTW_\;m;FGQHL5
gؔ?`/s
/.&糿O,`?dJ
$hx[j5v/	c]>>B3<y
:*HHigj7)li)p3\]],fe:+yg.77'؍#L\ݑDvo}"&J^?ATحCBGN|=0bg[D-s8VE6`C6,(6M+鞀NG
&hru#Wr:R󎫷ZٙӤ\5l|( jb&20-Ǯ˰cz+q4OlgXIvK9B:d:nz'O^PX$SI;=o|1;a&7~q硊B@0]6Yx@OoAy$t5{BBnY×y{.£'AU؆P.?$n(?~aڈKJ[n^m*J+NLtgjG^_3ۀ%I~w+iO׭[;)[=N4f$^7Fno2y`=b]}7&_o
gnujw%2
B9WYN(n$J!ͯe y8m0]QZr0109dٙ{Ad|Qf7Ш2){#Ce52甐7wX+7 ~%jcvsdT9"pr~uxA,O(wE,R?6Ч#ΠӋ7&΅eB ϒ5!LiR2!o0^#MTϜ5 qocBuGM"2UT\d#6_ad}&dﷇn
¦
>D:Q)鎰\4(C"DOOD\ҏ U+yelAjizM ^)D;;y0sN[`z/ -['_k~3|r <Ėle~Ig#A ̩9 lxͶⱹ);Ԓ58W8Mc`<߫듑jjٺ6}wǯ@K`@ƽNrD±CcxE[7K4]n+yݍHHv=UlUJA}'fK/Y&M
%oNtc]'<-kX}jߑE#Y.@徧m Q"HՖ6anCE4ۈGaںkT5A瓣aӃ|v47Dyl[4cIg?>[fy4M7'z[bAy8]DRc3xCv C۴FJ>"x|1<QV)ߧx- ۹`E\znF^!r;uK$O^L.Wݺ3oن~ϴQ
9pNeAoE͈/KŚuVh$¢KsIZZfm;ed^w3 3ő'd3]k>n[hؿ/p2'&ο.p5Auv5ZVq~vv|Õco3c:;w,ҥ<!r?P̟MfQ4LT	nZȮ`oɺk,+ɬ[Du׶ظa[$#t#>k'\_ص)0^G
F[^dcGD?PЫؖ1ɚv,',үZkgp
Q8]-n6d݅mI>iE=n'yM,|{ū""wCG(錒:J%vFw9^,B݆ۨO&! rߢNN@sݼ!w`'.Veb~}T[,v	UAQS^6ѽٛz[E9_N-!cQӴBn| 柷&[qfƧ@oMF59[ǃwMNikZ>Aw
?ZzX2c2nu	#:vSM40K9o<q}"}/d +m^N-^?^26+k	5w`8>Y #OWj~4<[UǮozǅ_3is6p2_o~IXM5q5՜vpɤW׈	dѩF8bG:Je6Ȳ-ݺlAW$TNkdH_DIk7SXk4u)\Ovr3Ԥ[g\
ZS5>F2մ~ݘ>a?3J;QyrrlÏItOhJlL'׋%]1 	s5e`-ǝ)4c4OoJ&@s)`z1]Cj#|9m.^=y䢶r~rEn*B VLqmHqmwC5 ,#wn=l~GE)۶9B
&X'pJ^
v!!|rgKbkY.4en3ESTM
H.D6{h6B
+21l.E~ANW̖a#1SХO,(MW;]U=!Ln!d;Οϙ(NЌqAXo65xk]/9XtīZLDH4VlףB(_o_.Q#@bq :W~;PPy|#Q#x(Ax_˼7{T<m$|KZۍpm|UTV71?Qfh}Q|w>	d(*亢L
3Kw_ :,wH-`z $M@1]2q,/&ZoIMl@z3[<rob\N0*$(k{q*]8 Y旋kRS['%LQZLt5n b6x7Yo`l"#nD|#C^Mh{2a|# e/<ף,"dyѾ6zcb`r#E=A[/6Hj׼}x*{n@@ ˃a@_Tղ gXtxVD4^ce@}\n?l`͘Y#FU,5N)4g&d&}w,yxw
9O֥M9#̞	ZʍlsJ}O&kl_ZնzYhx_K \b :
ACV*(ySz[Mݟvfk:p|6'
~ #ȳR:1yїLWaOt֑p֚cz8#gG^IGܘzq"2.m T, yW3ƈҗfYx7ZR57N!-IUb;P͘`Ke7?35еBiJtc:aRvg/rP ]Bfiq?~m3P-`Ȓ燚p>_|ߺC6DetΚ!oP!e xрrBڈMU,g'/C!Q{
qcdqۘ^@2dzM|]0Tzri+Yc,)kUv%O+d:TjUFQYStVG}Wi.CMtgFJ4+R>V^e5㝼1oȻӍ1لBaeOdqtގ2'῅ML<l]Urʋy";7y;|As0
z].ubmx^Tix\e߸Ta^dKdgO?ϧo^|r'<q`
G_Gfy(l$7GJn(\X*ݮkv|?.X`Ut)6$ev.<B'Rۈ`pf׍]g'f^iX&i-fډLk~
gz˙\@39@ohΘ!D%AM7=WNm!f	Mu]H\s#UzeAX!B+9C\MM}_-kޒ3*ZQ&85
D.dL792 ]U=+</SV0VrJ?\#	vzQo5	m`*
0\Rv_L_3 Z$8P% @L:H!?q .f&Dmsf]WɌg4ypupҧ[Y&o+h ?6fם7rϑns:a0|6q(&d{JjSVshQ<E6Y="/9p_? 5)"yVN-ks5lskF^ؔ9tUlzNMjOsa#Ph+=5l`j+ƹD Aɶ"&/-5Ljf*=f]i֪cy(nm{ebwg^khS:S$91(?`* x:pqvMvZʒ</&,=|'
\J
LmcI;3H;6tV4f
O;4w7ⶓ:nuܚ؈ƲiF펴_kY|+|zKe7֍_̑ݯãK7<!	w${>60eΐ=;-}=+}twa}~ݦUauɶv:VVxtcX'88ϮD龿}L^fnn2xk/ԇ0~XؾP]_L͂N]d!;x߹7U ;nuo]+Fٮ-i'qNϹY>ؔ2w]gwof
٢Qgݞێ;ma}u
ð;Gna>GZa#,
yKԯ6<
NACBݡik6͚
YcS<ղkk]I`S垙􀎠xAñKOnzHGk\-:cL`b{L:IϼzAПuGӎ%ennbu]v.~❃w<Mw4=Y5ͨ`AxUe=+ZwS눓 &|
A3>h-ncDwd"Kiv|Sc׷7:]pch}Tk@g?:Ϟ??	+#1n7g$-
0H[޺4ݕ9XۖlN<\^豒`vf9E2og܈ۦJd	x
3]eoU;u,|~9t0 9^LB9nc:@, JΣTd8urep3"N;^	N@
m:WHo@P< itr־̆Rv}8P^-Ǔhˁ7g;㘴5:Zj.ϼ w$YTg5C;kmh
^ސmh|xwP
켾PVmvND-Kx6U#㵥[O_d(GbZȽN#R@c骵4P(vFɃgfH&.ȏ
{y${CUtRaֳ:@ݡY%z0SOޕAs*FM>P<kwLW!ww۸w\B-(M4M\
׆@[ꍿvkeͣffGG|+H%ơ3Cd&/Wi|vo2	E3mj
WynH]0:ΞUn_kpۛnLr)]t s=k~;eLɼ5s$5_NqS8ɼ#.cGϱ_b!v>\MKgx;5֍= "c$30oE^w٦D.i4oZO</>p|thW(.;FR%~~}ԥ~lg5onIRP8ϟ]_fLS3۝z),<!ۺR_B$;A
pu~ !ǖغCsIivXA|A@mfȾ_v7ʶH	%J.v31U5Zb3 ];1tpjܜ$xtEDNwʥƕK`w"	5K<y:;b]|4vAcoZ/SQ?kn_'?zU4i
h6.n0)rLBWc̡Kh. ' }tyZ*K. rvsMr!嵈 m
{/wdIaʨeOpL}|ȿ_=&U8~wX`5htL/PվrJW7-d%d&@q| /2AK=s#۩O
*QK<Wb&)rǈm>i}b!ӵ qўۮj	5D/ph	iM
6
p PѠ|`~Գoy`ЛuH^-j⮞ى?G]I0ߚХ+\MYZG}hNmǹ6`6UMC;OKE`\s((R ƈS=wM߽a!<*~+,'HO<AfueS$98?+zdH_6@R)Sۯ^d[=?Y̮$!(Yqx# )Gln;F!U"]HS:
1/41|nB2Gp.gd}O]>3mrQ?dcpPۭ
P؁?=r"6|N*~ZzRvflcCG"u^lt#Axg3cEq sL4&,LUkAi|_m\A:*l0n6i$lEy>.
oOҴdݝ'_m6mSmYvPr9pc~.᰻V_PSAS(^WU8Z5dQG
	kpYFxɡwKWkO1h1=z$ޅLN\WkbG1ͧ>Ǥp؎(*<	vùpNc{B@)FV壭bԺD9an'pD
]Mo$N6~5E>ۨΑF̴d/^0x4tSLewx~tLU32d!d=(Ʃ6öO\
Fiw*֓=V^\-թ
Nx/3 Fkވo]a`Y<Hs2Ƴa 2G;
=ӈy~h2=q2ۂ]?7$gNnto[Ҋ_;hcGr=S>9
_7/avq:E/<8¡'qBWM* lPkviɥzZ`%PoJN1MkmT^t0G4t_oÃCrVN]=%W/΂B=>v
KmrV8o㻮tu/"HXW?;8ZU;v~"XCfcA`F`F+C	Yml9ysMr[:
wgn׼3	8-/gVLSt	B25]S?=Anl`$_vw8 \wݱߧ(]B	?;fʸ401S{Cz첼ZBlR\a3l9bQֆ(NY;OΓ-+ڞ+z쓵g{CHte'Cyˏ{'?uyivPg=F+#hNY;@wݢջ<݇Fj1L-ƓoAVYԥ~yG[Yr;mmW_eb%Sa^V:qu d䉤k?Γ,.26bڐAbnTP}W|u(y¾\Ӿ^ñՉ~}8?SԄyV6ƩU<\z_oaYCt"V/KcyX\S7niS֢($smiڰNj%,htzo:ϐD"(H#E0I"D*fb3W6T"_N_#O{sl8:p|ᖆ\w<nn<8Ƨ=J_
C:+ߕ*W\&z[fQew3 9["bjy!L׈8_oyqRtO{5=$}z5#|^ϖ/4qŉni׹tO+o
ؓم/ |9UOLq0)5?m"A1uP)F`ۛϓ͙&9NSyͣe˛;6}d:&~]HAǋj;	kkV+ӧ\qt|#ߊ.'`e}6	1'wQXF~g 
LWw]{fdO%JC3] n=D7|5i.V3vDx4GZzGi!{;gsY$XN=S!`}vd%㐼7l
(&ZGՈ7G'.X<Uh_]=?^LO^ MܥCyV~{~>1vjz^͕fEw:jɪ;v8LY>
TZQHڧyh@
kDJ)`1&/jA[PD m״væ.xU	Vh}M-zTK2$=UmODcA+fͩOz``y٨+Q΢h=H` gE|ƷoO: n/mnPK[
B&/Z4ƹp.bg]^N <	ܚR_UCi0YmX<
qj@K"n7?.ap#Pݻ`bY{j4֯W6Buƽ}grյ&&ĵwO̲fX0x:sɥ
Ζ.*kɧ~Whbcf:	iUL=ic30c]=
žp}E6$'e9/ucE#tםAiȋ1.)OU:.}Mf_a|"BцLiɑb:ls(
lǊnhsSlnV[oc+Nu'2쥗@)r,skmi	*<;Ý-&VgE
aQ^0Qjul
v~\C-_OY(-	"~X!YNh]l+ddc]ڞ\N./Jmw
KU]<ll+xEeM1ϟ̏>&kةo[YMp' ;ފrtm=14ꌟmQ^;aUymJ[g$,ًh%jknJ.p?˶rѰ4H+?_D8f k$DK+[/;8 f||J=ylDM_~<{vdgkߍlG"fMQJāUJde*;U(ZJXx藨*Ȩn6c㗑_m	Rcjx,g89ӝN<αj=௦&ǧח᧟˫b+i~<h2,jϏ+7yTdLNh<9XclInQT(wÝ0	|2|\t	%]IpZN~8q +`ȫ0djVZe>EnӱqL]L'@kKۊFB=_6JVU˰4Ҫ9c,g
FP+JzE:$*MӮ窍dJ"_A"oҧF]+k6#\zu~
7khv+֌F$:C7F`mߥ)k(paw}|{//RkT?q.a	[ޣuxnrZI
\1pN:mMmz2@*6CSG6))|mԾ:9~eGwvY[ّpy(n|)
.oMR<gs3--ZdI9tV&3k`SW=\/4Mnq/CQvFzH<SN=04p-4s,KdPU
4~72
Is6&y	\1mŋJnDWGXLbzx'm_'.oOL)<~7a&-ÌH<T}.E0[Or.SwWSkf<ɍ3U!bg_TfC^C|4Z@hQj}.zh_j;u@
⸉/4
G皫@x\{@~;Fj) Ynv4izb`B[lWkd)0H7DuP(rIj,E?syF۠kwYGѓm
&Ӟ1O 0<0},^+gJʯnʛ{5p*pk8{g\
꺳&3-ͽtҎO'Sঢ়xa'}܅д1D$m`7΋G pIv}5oaM#iV޶fMMGsF̟gKwZy2pV뾢yr$Vl1R*&݃AKԉZΦmq!$H+U%GgD;4A&34lYm܊6"\8fQF%hh^~ӥ;!^h\Xy񘳅	ƄW#<xvNiz|LZށ[ʝ]%Pwe(AlP^)]?\^ͼ ]M$jwg*̜\|j{yYDL<i[6>r=Z@hDF=s$ԏ w_T3ؐ%Noϥ9ءl}SPOTrʍ0 0qTm M(vtЋ\*SAtّ6!g`!L7NzN6j,Jƍgϗ?5V]0hn5rf{yΓǉ^if$qd#U`UǳW_.|nnQW4tדl
ԗqf'E|O6␑>|cڃD:vګoo`HdWka_@ANf'eql4ΐ\
g:7EϙEQ(9h

P/BUzk^l}s-F,ia%Z;&v9\7o˕bs&t*g&ip̪zܬZ4PůwRdGdEGVCvKQu ˩l̠AYoNFRo Xή!ajh_QQs|jޤam_Fkzqk~45dlBn>uիj,`d[I}Z?SHa*x|Zѩ)MmQqZ$ALQ_?rP..?b<o=;"Hp4C<tb/ݞ:mkK[:sd6hs1r$M.Q'n*,e\yYFXc'sfybo/"x [[WYZ!}z3ZcP:HsOmx`o)9YFz36*k[/Z2)6_B:IX]rNZY뿄;jTã6ةiHYyn
wW@bJv9ɜ8}~*,< \<sNc	/;֧Mx|FV/Y[/׆#x~~
BaS{+nٓ@{ye|*m)j 1._}Vh<B/m7V`9?[!ϕ
tq%cCZ*Cvq7JyVBOU'ڤk9Rmlh/A0mݹt.1dWNxPglAɪSal1|Λ*v\<$<:nÿ;;,KZtdϿ_~G_;p6~!60&eMԓ)(7~*7ʡmYgخ.*M{ALTɅm
dZQ5r`<=^j
C|>{$$Ip~nM׶GXW}q4%SBcKYTXݗ{,j+[t0sgd-g<.~iЅ2*WǴW8]kW~<!eA.;*نY7|)XLw+fx>Cۋ&i%Xidk';c՟ #0ٱSD%.y%kO+eyBGrM4Oþ(~IudM3,x99>=^Ld~sḫ7m-Vb7Zktd=ӗ=v&~\цkͫn"<[ [}՞6K;ä45FmkhمGjL묛{.
ݥNcwLcƚ;n~(~>pg6c*!kN];}s $O)GBܮVv?(jG]NKƷ[|/Uc׎ϧ(0;h&Y({2eg_>G8O#Ng`@=̻4QկKc}Rع?*ي#d|{%~ >^/	G&;h^Ù[W4K~Qh`l#3eYMGѻ71HHԚ0
NZY'kM]${tkZ뭇4: QՊN:'i1e\$pӴA.1c1\ۺ}oDܰ b^ὤQ/k0&q(\{>8ݗ`|/yYs-!O={;i)G Od?<]+LotgŴ?N?|vk'y־v5}&Iߺ}HXP-hM6I'<E<x49wQo㿆bw;fiޥ)P*io?UI`s3ZK[v^;[JbR?=m,Bd!BoNMg_b^7!d
dOhl>,&&
92kCӱ|ιw߭9x!II,VtzܰZ	
j& E9@9K;a#R=EF\==g^A'hfz{W50^NϮϽ8P~g/I|~E,7ca}t8y ⱨ Ջ77u
f8;|HOßC~z2Dng?
{+ARAٓ/a5TOpυ]#y2.-6.̑?>,p7r/:ǣ+|-Ƴ˿z4eGaO}%t'"2GgB`~rr1;'t8Ié*Io
{#[nmgӯ&"DOC'gٔß Yww-sڿ1tj%n<T`x~}O"z,_L^E}2<>PxYk;&"b4ȶHPQ}3Yeӫ:".%lzR8,P~!_>;ßYܮZiN'W<iy(qD.*qigܣO/?Ƿß!M'!Ș?5;ag/ltL\yM-2˧[5?M!B!j}z9t.O2X>X&_[H0eO:f@6dN멢gzuel`QgO'<8{Op0?`rηzqAp'I#aXN^6>hHeiQY
i'G3S_D=p^/CPp/ޅBpZ$9/P%;ԮʓCtޗ8>V:at,A #cAXFN_f8/ny/vIY"n?bAJ0ӥpX산iZi^l**kb#nv\^@;%pۍ1utEx	(ʶ4ɺO
X8.<'{Vӭ!:L:^ޠiTgQo#2zϦoFx3BT֠Ã~`95OFO{]QsHey142&IVE576ç4㍈dZ&d-峉1\>Z5409}]TW.f$l)ɒ蒷wBI'F}R<8A7k5o
<jK>byjOC0&*_b&I\7*H%"*"aQ/aOSkqu
zO?;F~ųxzF{
SDg|]-B7}@KçSƒLgkkWЀJZ{_LO]Va!l?r;B?2L(Dfty:_->ٟhpׇd~guF׾6s1+;=.hZAz&D/(yua\~Yi0gՇJCa{wÙBCp@fnVsoGcGnw_nnNWOohD <-ϗ\8^Cew\nz\zYG7}/ݿAk7DNvl~ 
oO既=ttJ*iadU:7u{s`/qnTS{o[u_]|$y,f?'_7=Z^ÄF [qxV9g7v9d,kp5m[-edOl:=a򨽭
ly?"6Y}rE_mqM{ѷ?}:ҿ'&<J?//<G7Wx9|KuvZh0CTGQ&_	&Qzv~:x1Y.dmF's;1YѺwlͫ36	ؘ JSUY\hHX^<=[0୿;(? Y\~0_^1fG7zx>|.pNy>G{ُ7qR=_y<鏝b>Z^>]¥+'/q@Qs wkxNzz4\0G^?k 8_BYd(?
ބ~ (:AHLiy o]Zt88囀	,bfNM>*^@t}Mpmᵿ׷7%~z1Y'Lu*K͍)maϯ}b~*uELOn?QG ~ƳvVẽ%4 CO_I6;8Ȝ/_XˉFIh |&y~'yv{jbRx =&E6JMcb`ZLwt፵n-/~tlWlv~$4mmK줵 DOu40*؇@77&y^cnH{d\MmûQ`MCthBKq$8HNo>4ytRo//[* g!)|[gf?txsӛ9tA6+?^/Cxڣg$f*"\_MWG

e&"CEїx'dhXMe¨Hz3z@7A7xBx}/,_XG"I^(UJ|8 ´8@_}0"/,؍lT/n0W
G\؍tP??}?@xGɭ_?V3!ݬZЕx@lyu>y/_OF⑨{4뚱G
.*GTƨ@gaθ㈝ᭉz39r(˔e?`
oh-
;u!\B
-l[2`[SWdCa^+B}AQ0.p0N?` T8AJގD鍶Qe( {v/y鳛gUO &qrsśӛgУp&"}o7mU(\%	R &ԫ
rn )GYvF&riϞ|nzAG
:Ϋ}VQ]!	Ia^p+IxrDDE+ܲZ$ q$dUV#.GF8UVrS>Q48*%WrOtrQ|y\E br <FoA2,~!a8
HkS6cMeǲiH28xP\
dPeG ^g2/wY A/,U*WdXː+{-QjK߱A1Jq2^*Ftߓ6/KAC~$$[QOVkKb7x:u#.q=1(?Do['d]Xe2qpadd2Q2
ƹZvl(+?\d,*Tq&0R^.IļDC/
 3`5@npiBh0
E/| D<&Gq Yys=ie<ej,@9I8.RD0X= vR2Guj<,!QYU{c~M+8.0\G|ȋC!,s]\e+2eQ!(ϥiYZ@|,<B5%tKQ?>Lnl X]eE|rY\YW_A͉!ruqUJa4HxyJ\CќL;CcY+_FzA&dl&f@H|	KUY)(҃zGBVXw69a3IiX-'E}?,i8$c>S4K Bocw<u걉~fȨdR(q #ޑ-FͲX6|2J0^*as(f,8
}LB@2e;?<~QW X^ H uEji	Q+b\g}F]Q,ĭU`!Q
63Xl7#iKl`FCXOFyt"FqL4L`|U
.W7%b2ƃ^ Q/20+tP?B8Q*C>9HȲM #GqɁG#i:Qx;"Gr` |)wULƪȕNi,NxbFeԮ!=Fy郘Rhݝ ֗^&I*ˀ$hO2L9dT@6D91Lb	?|oH "+)h,)x@edCPq 8(#,`!gXr\Iee0b
R
6E
4a$	
 ,/G,JЧqIѠ4
HFH)KpiYBoՐ2I $H$#3B0Wz!j@4) 9@&Tw-*&^ w"A Q
(Hq`'
"\oDւhQr%!D֕ĸyDŶ@!lF"14N"a0׏+B+lu1=]@)p@W Hḧ́d)Y*E<<PdFm@^N!zbjȪurU``)
W_A
6&
cB꡷qr9T(/7CjW\:_pdB@EH2QKxFx$@x!g5KZc8 h	F;k(_^Tq	Ѳ dnFG +;"|M?uE m47 YY}9 ( <rCʋjc jYQ*oG j)TʢҶr%\]J|Xp*!'^"b:$NYx)hB'mMtH1!`l-P	z+R]+zoYGjZ欜&rX+4$U^q5XTW| RRh(Ĥ."YN!F"c]UG ( `O	RȀlO}>Ez
$Xұ	I "AݧjC5U=9fX^oUR)>@<8gљ I^nlWFԦĢpmQk
Bz"aCbTBCɩHC\cҎPnX Oػ@"9!YkyyoT19$uz`<䁐9/DJb
,CId5U1$FjMD7j:w.0 @Uml @h%m{=0Ngv~2`6)k"7+}'誸(UyITՖFݤ{Jt!Ω X@H%FJoU" =nު@8څ+ZN7!(ANYo F_|܅0=x:Az!W]a]Wų^f6`׎ja#s<
,4)W?Dh*~?U&UIT.pM!M`/⛤LK&)rҾ዁}e$+7oboorF_oOa\U'vo٣vŰfJ4Kkkƛq5k%@f[7dfq
ܵ64]k#]]FIkoCm#pm͜dmAM	)qKg&kм-#\n^pGVp|{Wǻ{?eyo<y^IsX6?w_Ygt2R(k rͦO]IeaiKJG\yf^R {gܒ4¦i`0f9877YG׷eM`CXhpW/1/E\f쭶],*moG*VI%GSb`Lm&\ު&,a8ںr\՘Y!`˜|45+VBj bY_vQ'	~W|楴P7_i3^1섴ϲ
Xˏƛ"XR>+1Hi܍H#Ĭi۠YgռFhc5.G0Vg0 "08]$r aaO)rr	֧@=^sZeS7r`=̼^+ʽ:g`ҧWz3cU bܨ0J{X]*w⊟Gu%w>mUL` Mw׷Wh?9owRk_h{,Gk׾s}/N?
pmSs%6	_z[rO9:
N'CCklaw2}_c}1>me>FX3~M1?)ڂ9Y}
Mv'jǟ-
ǟywRo3?#d-x]>dFOEдow}miX
'sJ(<m/8~vzGF~+0}U`|p;I;,׾eدMoNo'	[$Iݶ_bxڶѦE_vO2h/㍿TmD%>8㧬,T;~SUq
oG[xow<8~-;ȹ)N鍿+FqV?E=!	lkok4JZ<uQ;XZܝ~*II`.NmJnmx84!qJ'!MEiڷ;-XFHLӬ_w_%giJm<>4ڐ4sy	oJLm"oiW
h˸/SxKRNmӲϸi>_x8ZHQnv_	oZq<iީߔ3!M=x듂e:,ʽ>T_Y{Nos<M{CM俙3m
~;dXL6KNoLn;6f
0#4;~fǓ}_Y'ro펷9WF0!
o'&Uń6+;fϢc5<f}N36GO-"!ͪ/?oFm3!joKBT'	oFU#!joN˿\6+!ͩ&䶹zǇ*"SZ[xOSHm	b}sj'i>O6!S쎷5qj	mzxEg\Or[kDi>O$!}wVJsyiÔ7E+;-)#,2mN)o^e굯w9~_)_9~OJU"HmsmNKR96Zkm	m"*?R߂~;-~+%-<;~	WAJܝS߂>x_eRjF|Y3g	DP(-hB
|qXgX T9jn[
%5/wqI{^KVucʃҌEcSkbD.
oz
JZpY:\a99E<(iɚ:{EKZ±J:iuV6#*X_g8Sg|ƩL͜ANJ>]6f9RWVܪbf}Shwkti8k.Z|B3)08~VlM#%{P1j]5fպ1B0Ե~Fk~VʂKVgVe:D/itgq9\XQট=7`_unj\5XʥV~t]љT
0RSlRmNcUp!G2~[Pg-[\?Co~hϯ3F#~MzAa3
]ZmiH
i3"| DEK>)!+#CڌhstE8KZG
*DF
*pD
*9&GpHAG"2XqA3;U^
;f6}gbCc
5G
5\><iӥՀ5N(K
-V S*LL.A Xb 
6nf=XjXWc_%zSXY> 
t EFW
SPcr3!K:U)3hhv
5T4Y;Ui;1d@bP /!/ɐkB#vb Փ N	]ځHVmP]-.mbߵ>Bg%͡RŐRi%遶$ꁈ&	,Lj1KF4&Iui&^TǖE$5Zj@hTk5kr@kBk- r81h$->ՂMG\As\D'QGwd')tjiԹ$jB,ho6A{B,Zc$TkMПP (Q/	'r]/QxJ.D⥃HDQiVI^OPk@ZE]*n, r]/ZARGtENᬒr-RmJ-a}Աh.!I	m1*jNgMRƁSjPWj5$F>gk(z*)Uo
xM&1xY0fٴklNx vdN$ʹ}4_3Z9W76KcO]RaI[`iNOm;S}JwPlDu	$1SZz>;`rmBQ+hB*=uWR	p}ɵ)U\ARh1gB
6@R唢7`i1цmWӒSNՈkUq-i7"U}X"kͪ*`ФH׾0+\k>,!e1SkOYlªkkS8鞁>emm@X		Y^ƪm>e}>
7*3Man2*A2Mڃ>eʿ )e6P}LfkyA2SЧpMVe\:uc1$
n)HOrЧ
 ۝q:	h5PRNkMqjEd~A,͖װ*BDk)S\3SMb߲/ЧLq\k_qtjuPvu oS8@/o!Yc9$k$	Sx
Gu@*'j`GWq<}!u}"/"6`p_61`@O	\fAW:E~Żq@8*Dy{qn%i֎^B$˖NJɗU;1'Gmћz!.lKstK)3EFs٤Rw^
UXyTsjO뤯BjaCMr Ar *X-FirzeKhg4dx䡪/D+Xx^@V:@%karj̀PmKeɏYlYl6naA6WqڴGȪ͖?UHɓxT%Iѹ6j\6aȪrjqdD0ϼ7ι	㏶ڤ/[#ϿY
TV!Ԝau*pשy#_]f)܃$hm.%nT]aK%
u')9ճU8~yI&A
dR	6CVmJNF;t.#uS?ʄn*϶i푓Nmpoȫ]TVU:PK[Xyn<WWOdUxNյUm>@ma2iJm	laKVAmaKnA=y6}|</hi+Oț]2M)O!cֶ%h '[͒0.V]y#!*R8A%궰%pOe!PyyYxm h,}=lrelu|x	_VF=Pw[xSu|ʐ%0>%2.շeK>AvH_)CfҁpYt@
m 8~sCma	9K6Ama	ٰK65շQ	o2an!vFv+0TV]!v'-|i.TߖSI}z]EhW]9%2dv&b͙y/ٔ9%2t'0M{"DK"ٔiTQ\/.+pVEק˸]$hp+wў	*l+O"u'tlʼltOE`d-KdZ+0p[⬥H6eIʼۓr|-ґh£N֪4ld_)E<iI6A
kMa+Ş8>-MPS[uуdӆX2FcJ&-rNPC3a8E<i-Y{3M4x(M-%6rq(iS$6J6A9LS6d|]^'̳"9$y/Y\JH&i+zSk̭b\̧"YUW'&xJ ɦsHilYy=my#Rޠ{ɥsEr	>9-<9W$6M".:8W7AjaA:d(_ow!/ \mQ.%-T%K-NK˚sJ.A5jaY%cNT%@-L}
Ur	jLOʗ%ⴽxBcL<Tɥc[T{剱_3AEiaho2:bu\Oj_G/{fTLX^[XyJ.AmhauJgz@sG[qD5 V%,-i9z߬ҏhsp/#oͶGIm^=pqès{eZcR5`	Ur	KpK;dzݞ{*vn.#t*3VɤJb-K&G$Z[,ǝspJ_m3XʢLdÎp՜d( ?UkImieL]L*kIXNbLuS8>pIYoa.4J($)K4JQ6/2G½v~LQ-\'YŴ0@nka4R Dzp)$R if~00`?
i #C6@SB8))Hh8$h/׹PV=a7 0ʢoG#A<)Uh$&zg9L|<IwRIZ2W/:S,2	0rt[h0OI'	QB"=>ļ?$`1#XEYpۏG<g)q?r蓏£mOG(k$Zh$8q"m%@C.NSsGC[*)F#84/-~@uǌ:"lgb]ԈC&hLaoDZH;x$.	EQRE%BS"Z>yNڽF˹6A$/Dѕ=*ݫG2"$zbɛ&iCEl#mXDhɗwFfv̷9(IAPʌN
Dzڊ8v2 WF#fD|.hmR{Ov6#edWF?WD
&#x̢jySFY73K%u̲2nW	ǑGڎeYE7.iou_9<Gs$e$;{e%4XLd䇊HN{yEi崷>%FI<GP(7yOQdr0Ҧ.S\	sBS[ee	MUbG.
QeSPY~}|%br<߉2T
a]7_
Db
v'b<T<`mR&\a_L#	q2Ubm$"{iꉰMV6^ߌ2徲)iЫH}ϫ'hA]լ\Tu_,TY	xJ$Z
԰ZVdӋ7+p=3aW=>²**,0؞RX]Q٣4h\BnT$NVJT5wSH'^~*z̶EFV~Q֐/;ġR~J`-J&y@.2?4Õ΁#-V("
ie;HY WBqWڎpzxBMۚ6*o};$`k
Tudi-md-cMnJml{X昕[_&Tj)$fIj*gUD;Gu5&m7NԞg&>panR%֤<Ze}\R%e}\R:PҡAQz3S2e7dhuW2$ʔ)'o{hENBa=:qnkdMtThz#D3L8YXl{vt.ԫ3#D3.UR%hh醙'nU<(rkI`2Ly.y(St흊u̔2ՙ^]+<uΨ<9c>\mJU:[T<{ʃ牔FkBe9xfaD}g@@d~КhܣD#&6E=	K
iU2<ޕ'w	Xtgyr*۬(-Sʦn<D%:mO(h9̔=-iĽ@iHME҈%ۗۃ>!p۠pHЭEiSŅn7ې B6$4SKIW%A񨌤MObOu4?VA({-*ۦWY{kTzhn?(vZ䠕aE(9:ŋQ^B.+}e,AP"Ǎ:.;-8@_Y{ݖ - -aek4Z݇5<7[>a2'EUK|yEa}lC'twi2oLj[At%vU3cuC>~\SI6HC˽d5Ewu<S~L.1NW.7RioVV{h\4>lZ+5%'
n?	Hhsy뭛R#VFq2~OX3 [=,RpY3VDPWE[QմfN,]N?Mo(wDKY&ZUsPVZh1_%eq0wINHMl;?
wS{w^?~'/_Js]kp>!g?.¿&nb4D3~W?[SkX |M x?333333333333333N .RBp2
t*
2O&g} N ZC%X+xYz
\K&
,2tqIPoNu\IWp݊:`cm { mHIxG^`Ng`ZĎD>g]kJw䙃uM|H#R
J- 0&#[E઀:@Lm5$T^ɗ!dA[*Jڿ\<e'1-Ps>ܶh^>0cWql'ŭw${ŇW^"=̄+|VL-o1)0*~8\ו5%\qy"a_r"a_r"a_;e['E^
k)ŲAAX]ZsGN@$]PcR`| 4hHS%W8_Lpkk@t>Ew[
1 ZH<ԏ$1	'ր&y2nd-wl$lz!۝ěؘ
N:N;fM括po%fYZXW0r[XpW${}Ciz-1:l#Y%܇`ŸK$k}`ɀy	~HЇ (D=f1ڤ	;0U6=$F=(W1Ir@"6Ȭ')
B;APumqu4䶞B.De
O;0_-2Z;AGԏLpb4nFfmṿI8I)A\MzOTfm&zɾח}/'__2?Ne!'8y$;1VPC6W UK7hAD4o,ԙu2wlCtTO*kIVGZ
-2VVo&IWWpc+?Ȋ2"VPhKa=L0RqĨ]
E?I/aJ<GΤu,Gfy"wb9}JbHYlOCo\^*~U'T7^o!f3N
6Jl~wKT21+H
;|Fhp_Wt{nh6k5n@yʕ3iL9t^jᰂW!	 "e0RсKk;*gQv1Nb60ڝM8_N~Qz]IOy0σMJakOp؀A{'vh@41{{Zށ ^K u
vh|`9+m
E2͒dJUDB n/i
7YmF*₱M&sRܭe#mᎊ=( ڛѭ'H
 ^/+Dk幚z.&Y&^/_F^9ȸ.J^%c@l?qu}װ|kҴ1~걨"KVgM7(Piz&J,L!7jOj1-kRCKؑцz[EI~WEmޤB l84hzb
V؛lc|_Zpдvl Bh[!w,wI#r{}~ՖX0fwxiNeF"֡"ASc,x+vXyXm 3$O)d_}A{[+VP0@-%q߂Ck0u J#-m/^r}R^؞:O9+4hЭKEJzP}R1|N؂fŉZum!\`޴}
CyoHkEƍE`4<{9/uuU{Anމ>kf<-koь~3TQ,P4
#_i_ۆHkGm6z; `9ʸq)cis<H&}	[/X	
iv#
׭
5?N΍՛{|w>D!`PVط>m})%K۝^''=)hmvj&-ׇ`ǤAUZ(WʎL1axbzjS>Q+*('IU68ߛq7F=M>-aKM9Y -j
:Wwm]G"qK} CU9+-
{=24+#}}3ʝM68af򂱅3Wfu8v{_kU=MxM-p˒S.h:n=	u19:n4 D4cbW{f-ބ>~ۛqBB9V;hԡ67++wPWLpʥ+8j\55z6M.YwRp׾hz&O/+6.ee&+doۮiqkږxmF:˓xRM>Lwf̹ ǟ׃7p~KUnaI$5UYDؓ(߈|s,SA2;L:Tx\U

7{GWA@=@%-!5]I˫8~9@d?O^۠_:_~yo|O/h׿^T{:2
^}F	3Zrχp5ZZ*MpO;_yezu~oWo"Zz8^}c|xAwwVx'L@4ZmY	J|[nF
ocZ_
T'oD؞\-wB$k}D7ҡ7 4ouI?-{,Jc4*Ƌȿ'-.+ptjve$$:}XSz7Ýa__/ջ;_~|*ItU2~.\.	x_#n/6u^`TC0"tc}O٧ \BbP &Pa
pN(ۑp5O;YP&lCL:ILNG3+"!	K1BLR?,<H7H91`?n&/PmvTO|Xp6 f>.Kй]H0p,1;X+Zn4+]W	48vO20AtzetaU$IbPz FAf,=|
n~bb'
|4ɶ:#l䜸nz?(*?az'x+~]A
H|^bF.3  4{LNpUW["1f
AÿLYيxBH/TҬ4k^@W;{nt$#Z4qMdt5]J*iֲR@nb($͚
w֕;r"YHMc\7q3nC o!K{u\c4MÕJ@ZX5	X2"+qU˘luq<:q`BL\?mܐNMd̲seŨ$*rD _V;9V傪'Y[;5V%ڪjY"Mk4@"CXċH5Nr ZTb-|wVӢ E*H~<&Fb5QqiՒiwĊ$iłǶ 	8<3DFPШic6Hb< fE /NbX	&Y\G '͑Ki&3DȍȍĎQqhю55k6BN	G[sQQzD	\wI:M##Y1uqHO`FTsˢ#Mc0#r;DȸWVO4ItIhvǭ%D I="!-}MC4MiM#h/\{t<:Af4ȏMc|ŷHHMSC{싚:b#Z[v =bgs;9}|'΂wQpƋ4Q.iTyrADG}k}$q3XAN>5s89J1O|~ 9spVD#5iHnaQH5h:iw7AGF\U4#M/Ih?XL2Zkb4i4&i-F3aTi4E4hh<چ~ƭ1 @OFSl4&:A
a:8[8LH:AS3nˠgANA
N?BuR6v*BP6v*B$@
?uZBҹ]:սdzN ۬t,<ec	2)I$ec.$jAhBR6v:i	<eCX'ec,JCQ6ꓔT3')MIdu1ij!E
6!mcz,P=l4!)1(l4)7QБQbH4`Q">aS-"/S#Ԉi45"i}zÝqtG6j4=":ZT)gMǘ&u"TNHjƽִ25iIhE:")E+IjbxTLRQԌl4 MHjFS(
ppR;5c5OFT+ 7:=0"P]$5S/<zt`'
t`$ce#˧rDxL:F#:@:F	ޢ|EhjƍԌ
'5cgoQ/*+ݢiӉ("@e$=cZբ!:e5y}Z&}#^1vzE*_+ʱTǤr$(HF={bѧFi>	4ʓw$Hh6(4j#Hh6(ԉj#uHh@(4Tm ~ʦj#]b>%tTmL4UI>Q&TmH4U)MIi: #MIZDAtB4d"iII*4eRCdo]5dO+O$BȒM<̦iˇ"Msi"1s]aHbwHN	N
 'vHoSFbU'0ߦu>t4
I#	N#IJBHT@T$\M7H*6tA3vӝV'ZII73I3y_nJC'dڦCyMӶ:t%`Q	tuE7HfRP
e5d/w~4_P	ixLZ>Ӵf
@ő4m  4M) /wڿ\NFRDMMuiHMM;߶.p4QF~Oyj/TeHf45$EM#IjQ⑺HN4DN#"L)#IY-:dAM!IJPSHʓsNIH|[5^[	uI3Hz4su;{9^t:qB!i8Lyf6γ{(i8LӶqB=SHp_9Eg6R뙦zқF;:D'$
=ɥMSHBϴm1MiLӖx!j8晦yi#Uix#bFR噦	=)H'Sz-Py//tpBSiO'i.B$ ͗o2L!I;SHnl3s1D;Gby}";GN3}$qg1M/i+o<KUȜg;E.C)()u&Rb4Ei(%HqgH,>rD7)N	ӴHMyE:h%hXD+<Ƙ>rԭ<Gn׍&Hm60lT]E˱3Mn6RZN'tt9MSgH蘎Qі~+K:G=[O4pMWe/3EntHQӭUj:0 aEMLG `::*K.m-~RQF]ӕz<Nttaљ:r׍0٠h`Hљ:tt$owٖ8oKtt%N::hZ5U$96>љ:r9:LI::SG0usTSGIGgHy:cy!|3u$-t]`֓ԑ3u.`NGtHѕmљ:tteYi"pttvҕvZ즣#ͤF4w!	x-4ek>I;gHΙ6D%,-3+tth/Ӷq-tt T6K[u3M$yLZxllDBδ6m$%l9/::F΀Τt=[4EXG_bCFn5]fpP2I,u:KdR!ݡIHw(TII:t?b){Η^'=Iuғ^'%:$[uIbI~g:,'u5@"{y#^gH\7u	I뉽Μm#!QC%ڵRׅ4ׅ@nI,7r/@
dw&lnttNP-DsF;nBHهй-<#9{['SED&;yIŤ&3g$
.R%ROw}!qo
@FD5E Pj0i Tɐ2xA2)>:e)h'R%DAS'T9#EA(hHm3y%CG2uV)!ŁT$ޛ4P&I#y/Rpϔ'ǤޫǬ(đX$xCnH1I
619yS^G|+t}e:D'b3*b&Z;JC1=,Jl~Q,'	ē"'_*IڡbT)0Ye7g=q64K)
¦U/?bT/N@l=:"M,9ۜ7K'' IN<a<V̃C3c"4Q/"E@O\bZ]D
b<h@1jB&l|-aRհ}ä2q1("ϻhD&xmD1L,3a<y'B0inC}ŞۤҶ[m%aGf/6lF4oir%bѹ;QIgKG,ǅ7f(N`ڢl'"#7Z>61+.P:6bQ`)HQa̊,2I~`mC&Xm"-S-qR[*"ro,d6.N{clAؘ1F>o$X)jz~/RjJOQ:ߣZ;Ն$b֪ŘsQ.=brQְmbV-OG8"EUr~EY5B9=Y`WȱwR˽}ȉFtu}bz1G3of!^YXI:l0-$EM_m;h*bd)nd~S_3}f1$[zDtz7I6t5W$A$ēMkNLM4+-$$&*e9/l&yD˦YO/8K'lL$ZJE-A
ك'H%Q5QZNͷeѐG5oM Yv⽷Hl&{lQw:svihk"vg	lfӐ(unZr̘@<%0űEum+_슆Td`?1Yoe!*hȤ'^<$wэ!zEuO+m]/<;mZK4v>ݜ>9kֽ?[4i!iN~K;SDnv\z8W">ye=dw-{n3'D#| 
+
rJ|e9PןJ8d-$L"GD~FUvzϰ
3%<
z}1*p=cDuʈ+zʊ#eyTA<IǓGWx:߆iɷYc%H_1Q飄46bi1z#Ş2
;f̂
XZ9

0S0?ecG9v㦴S{Fǆ(_97<6<
 
ve#C"t<uǕo{sj^٥tI0uh70]Oz.AImk[_{J_q}kn+_______________J__ip<|R1u7"BIY.ɘr.ɘr.ɘS}tItItI,MO@EǓBgWlG"|B07oi\la`p8 \
IDp`V%1;Xyrz]HuP[;H].Z
p	 "Pok%7G%dBg.	C&tZЙKhW%
"
=KY$1߇#f9|L}8b3'Y,"$1hC,#Y27IШ~ѱ $1X6?I=~]C ? $1Xb~,`HbL$fQ>ߟ$fH$1*K PK?IRW3|O Y
$1/I̢IbȠC,`Hb$1 Y8~ Er,$?I2[{,w2C,?I̢,?IrjEn_ԧ< c< 7y@ W -0>қhU7?>#I[J؆[G{Gy|7 xpa D(^Gz	jN[GGGu|7eLO~o}4:o c^ÞHQΰOHQu"Ea"wLܑ o 1tiEL
 )J]ƙDi~cL	~ۘ4!Ra9VOJGJ.
p욌N'y翿Kx,_wc|wŦD}7W;zhⷱ/}wk%gt{vh6Q0kH7'*s8VҢLj0H_sDcRyW?OF9YE~\Ӆs}7Lpp|!Wl*Pzt lyb4L^6T\486pNdB7IXGL	났rdh #3x륻l 0C\\y5;"|'|,;/
6Χ,3`؎p=D Puxѹ^xA^Up
r=|&q` Gwçm qtAƜq، :e ` 7?_-LxvqS1zx171!ȉT&{?9'h݃aYrWc
z~1Wc5, :2<'sk2q|1)BH0Ӣ'Oz!aY䉢)Phoce$={=D2=9s aRAUO^BH-C%
1@SŜsN"X5PL=O?UCS3ɃU-%gўFgF|u8H	VўFA$fx/cN19,kJfn^)$ 	A'tb4ߧgRCGy3I^/b{01"=6ҦgcN'	=62`XDOn_%_=z}/{2$w8^d$O+}\)ةʌ*4JӣYb3'[tL*ǜ<CdpҩjXYvd{"NONL0Q3O&"&^tFI<̿wӵmhd}{2td$A<LbgV)VסRuɆ`uJuQaP+XfN	U$րV*NXIW֠[3ɰچH  +T!
CPPU*TJ`OsR)7!7RgQ\Lh}"U2MJb"le5Jx$M֊DPl&K&&h*RvMF%Aq/V^iAf
ic%ɘ=C>"c.]$s+i%r0ɘVmT6"jG46zB7bk;]x5QTLbN"Ӫo>Klgw:4~vDf+e22Ie)XH.`MRP:u
@cME
 <ht!(PƏߪ;N`-@AeǤ:x^ZI|TKо2_n"j$[gdO:7pŶNB7 
dc
ա6٘D&i-/bd!9uS7~C" !1=rg2YlHdP^5dfT"tr#gdТ2YeId*1e39lLB
v[=3mdLLLbu>vHSzi?11I
ILL¬Qd^2cDM,bN"ېw6%Lf"S5;v'oE&od$6#duR[̶ٶLKmUX6b_2k:ľY2O/9/ݩvμdgĨNJq,Ji2'I鈁dHQHLH?bmCF&<[̼-rKٌKy!}kYuƣZؗLF%}Ib_2Lvl$Fb`ʬLF&i7s͜|w3'dD.3`Pu:32h5K۬e
SLLLLf$"d"21LL#t!p4TdDȌCdf|3Yd!23et8M0kYLfb[u
,EȌ~beLBdaYִM&!bO"K0CӉQ,fib&kPΓ5&Bu%3S:b 3u )h)(i)yLM9Nf(2$34 ^)^Mf"K2CSB P	:X|dD'Gbq'Gpdxf:Mxd3ጬ/f8#닏d3Ȫ,L.ENf3
6dd$W;uo	Bbw4xqE!`|d32<O,MdXggYd"S,}bw*UNe2驚Bdw2ٝ DroAU7dv2EY D$3EEIgԧ23q@R]d!3BzQNA1,d 2).A'f"kc!q1!=괝!anu!{qBdn2P$i!27A ]fQF/6A`bL,,Md2Kc D"15MDXjD6CS2C7CĴZr Sz)Hu<3(u0-,0?a}Adfh"^$$%PCBdY~x
i!baA(rbX2[ZLLMA
͔o̔_{P"ېX8;{̔Ǔ-#aBo ==QrJEf[qNdLAŬA=Ogg{:<4<.<lB,L)6!3;^|թH3sRn:0 8D;vQ2%zYi^O\BN`Wω<A!A^"D:bHsLD2YFXb1kP'ră{lܛ42FE'"*4:*x^)$yx?<0=.dy?½G1eV'e1_YB`:vJIl.wuF.	2jmF!ţm-j"gL=bDBoF#B՝xc@~6
Y	@:4VD/"ZSb'VD%"4" ^f{+b]Rml&8ju4/)2/,b.<48,ѤHGN"Nꈿ|KROUJdʳ/e"BoA8Aᑩu5;7B*q/	]:[Yi ;˽
!TTPMjrVH,M6	K JhI	g>=s&lh0vj=ȫCEuX2ue
6q0ʷqy\MY:&N7#cy;{&YpȳReXl}03'X`3uQ^}Vťi_~dҥ|fssńYZz3f{`]"r0a'l5G I0	-BM sFVR`diRtFq6ƹYy5oIS8	Q0򊆴G
C/a(sGB`5aeA7hA
6[|&(xG<,zq[
imqV5{y0x|8)a9l ryH4x>տ*'IOnopoT*6?-kƿkug?<gA?p?c>c>c>c>c>c>c>c>c>c>c>c>c>c>c=g|{Hx)h!]p}xx
@%@UXP3pNPJP DnBL)Ta
BE♵Ț+? +1-6=_ #D0</Fn,5лtNĎ:vReT ГJ)F%@U <\VlaU y &	8?lhFWVVu!_@py.t'l7o.hqf,!<tO|M#" .Npa AM9U`fB܇7HH %T`ky5f7Wo=8RWd |#xDX2&N`܄C☆#d;s5ѓ[;F.wTZ\1bBMSLP
@}(m@
ty,з]-@e#0H A}yFm88888	Czuڇ`ZajJV&[cTtBy_ʕ*U@ou%tJBb˿?@1&Ob ;&:@گ5LP,fk!Q`
h!aF`Eo+phF5hm3zit(ݩCW"Ԏtk{h_V	/~
JqXqÌgVt.3EѳfvDVt	ˈ.aDCU}&p·=:;Ȟf¸fFft
+T8'XGo8Qm4'wcEmFC4Н]ø3HZ#S i4O{[lԧWdx{'_)Ophx<=)4k1(uxɔaL+H.5FO>O鬍W@n3CbT#mԼ*ϿS
v'؆a*N
IK?X7n2vLC#,BG:RXA oLft6BA08KtB,/P}0WblI3rB2B;|%`$ؒL-)h5&ؒVcK,Z2%OrВ2'<D|z|(i(/vk-<qhOXwxb(wz cC	, quwجPhԘzߓDF:N-?\bk
Ӽھhz57{/rdv7Ke3OāM\#n{/81 b\>KPNmyvwԣG메h˴e@xD[UhK|*%2+㺅>9nplᨏ@3?ٽVXM!ót%̃Nt:}t*=ң!L[DvN_mlGu4*WDR
6]߹?R5"eJvxMu=}4v
g)ctzd/!LwĶ<)60zJBkQv&@7.q4؅D[_9ق'Z͏NN!ՂՐP[K5\Ă]RP(~3
rs~nЖY~f[O9gx?sgFrf[jplKd6K'-q
3۲	,p~~t=mY)2ٖٓam)7̶<쁏m.|px1J	}Ed9U>r4iESmX[DNR-7;Y4gV t-#`Xt=|\l@8YJ`
vaGeg[)bgDbcg[j	uz3666G;L 9w|2;^vK%|ǘc5Q]F71,4 <".|q@x368qNv#'XA;F.gkt`k}	Vv+h3$]liٮqNJmqasa|l}`bn)><ѩ+4=.e
xnaSA<w-^Gx-"z8zF=]V0n\V0DՎu/N2I`~H7%EBn`.G'!C"!=G/D۔lOC8Köv9"axGz:H>
Hthb51#ptd8sX>8rQ8u'?$\(ix*
P9<z,,g蘡zJEx'E{6r,saq{\IO3n0\Wr|q抺VHս!"\Z)Wa8BMt=W֕fm8)
"UYWʃp.p	F ̞+up9XI3GИC1(cXg	3+*'E](2&q#;Lcܖ8>##m3B|0"xSaU&2:){*ӺR>͙߇D :1"9.33jC}"(tUCTwb O;.q=RBlOpfjF+|WG	MI"1' uO"#}=]𞧮SHQ'tol\+tѽ{m9\ߍXcN2K
lcN\o"> Wb>W'ѥs0z5=	,:үקѢc>x+c.G5bx=X<ѥNX9;4>P8Q۩9/wf#H'BtZY~Dc~1i"$}=zL<s%I[$vH#
Og,UyX:ۧ	DpL03O:NxBN3u-`TT5W\	SXxo=gzOPxBWOYq"T\G9?jC&BO1'YY4v,|:'N9xQ2s^Ww%Yhp
xmIh.FL"X=
=tܿ-9x\]W<]?^B
ィCIg"܌j㾿 1|y"	FM|0!pOxmA3k\(t7q{Ht^OaNr#k^$6*tokuWx+%EzNTxcr8
G/E0żc1/}.Vw}aH1toΐՇw1n"/.
+ y`]^rHr UYmÀn|!co--nךw?CSк<q_ՆHк<}.XkUCn3.A .'q {D/1dl
Wa1|a$_yȗ!Ixl#_Al2w:m6\EW^mԡry`x\^lM!7b)_]T`H\R]Qx:g8a\eD+]IVe(h$Y 2ũyci=Py붨jwxMpư!nz0//AqӌUPOP6k\y\ v/>{a]yMa_,Ζt)0;IPsqGҔ~%BCغꀡŜ𶼠 |1S68/+;<m̾DY:$-71|0$Iw	Jg!r6/5,B X!:,S| }@%Zx@
8 H6{ /N_ԡdu2yE[:ng9c7\
>v㵏Y\=`;G~0AxW;_W;Pǃb7r|Z'p*m6#ZYfOn(j^-iMDp04l
E

-/=gij7[%l0ЅT~`W(I-,hȧ"Яn6{|NE:߼!	MouHXȪ	K4]68tHXȪ	Y:$,dUꐰI2$,dU771k/Cq~FvвUp؏K@glfˀD21~_`Wn6	4<Jl3|0+,
˗V^U2.ޠyC䢡^Cxsx[Nw(hٌ <95+W?|M#h
h
Ը~7a321a>C>17zYdרk	WRCaykXj^1b+枲1
,yQ`#
<C#/CUSԐ7|[57!o|	;-ld[vm H
nȕ=cEa˸ݤ}.=:NTrȖم% [
K=d[7ˏR20<lM ;Bd6,U˳wped.5UWB'(BeS,q\Tׯ/ڳ!W6ds(>׺ WZ솦1y+g^"sz745nhj7\zuQ04d3/n/.J
Z)톧5(w+/ klCSzԘ{yUײFQۉ`Ul'!VaFƼ4^*G|ޗ~8%F{8K3<5
O9ᩑ^Μs<y!^wCBa(O$X1Bnċ4X*,idq^r}܋c3|ߋɂ6@Q[PZ( pzR>;3p,eoyUQ
7eu@uŜ(Kk[~lh+P.Lrȷ'^*-W4=Mش[X[MFGg5:yi/fV]ޔ*3I^ƃi(Oۘ
&4l\!	*w(aLfQfQs/pZIrG
GZAFn1e7(WXd@uVRqm 2,Pð@(Oˈ}hR:=o[B5y'"m2`9N/іKT/[x{Rgʃ㠅{{q<f@E1!mUPͣ]ţT;TI*җ6i9<7RbJ7½dga9jy}U,j<J 38g_%F~6ǿU{]ۥJ4lD*Ɩ4(dj4pգTN':}nbWbU!M^$2ҕ"؊jAQ;lk(4D63SegLllLbYy8"-X=)	R3P!\'f?|'TY&뷶QkX~L2t:Lx!90/*0E&/XTZXr4H"L+g,9'<Le3CP\){`UҨץ%Al9K˓t{8>4.Dn|ȞV⬥iaeʞ8
UjRaOU'3eOKۆW=ms	uޖ~݃畽+_<+g"Vޣ$qILqv ]N-?j
ö4Yg, {ҙJ{7lr4h
SQLw4y~r`L	)!aTZD
&)H#"2qzT {NĶo$Hm(~a^9>wx+$`	=Ǜ)e*_	#JpHt
N@흫qaSszc+Zc2L+eJ'I&?]̳" :О
4z'ͅ%Zen6ܙ@6^+<(".޳RF{@i&+CE"'OeQg=qE(G0(_DvA33YBٝ젮DjcSF(8T@/!ZnmE<mek?VJAlY:Rg.Ur=;A2RL(@A$rޞ	I3MIDRrZ'a#VͿD`;(aÆ:+iixCG嬢6	"f\z6*Nz#i(kԨ[r'6m-ID6!cU6|Y$0

U5`{	نYlìR{	AM#V
݉Zvs;D),9+Þ1X\Om)
`=inNW{	qNG"KHvN)D+X{[%QS l/DVOl'i%l۪'/DV1,m{I2Ǖ
W>E}L
Q>k<mr"l٧k"/D&8Y6sdDPfH{"l̪үCm&A|'Bq[VH-[i{ɤbo qɄr6,vަnt
e/DR]vbCE.k$NYF&V/,ɭ.&ܕu1a<Yb0QJщЍ(PEoHk9ޠ1Ϗ%8\&|qz mسSsR4i<;>Ժ^vdu{;vB /
YYv&d^|
:m3KG`)2<=eZJ:Qd3)bI,,UZR-0檣/eg2Oe_JK@2./+RF%#h2@K6s8"l4]Ź9Iv4 ɣ#}4nl/|,F5>QG>ki6uu5q0mc*bi',1Hv-w̄;FS/	]Y9q,q#D>s&?-1Cs17pQ#HvIfHC|8F7BFôCCE>9e7iTf*
kcj@`84&I,7\ͅ>="ʹYnX8Qf,d<<h1_pbdH Of:҇@jiFk;[^sw~
4ZIHMa *L@mx<
r[^	Al3hycKS[	QVq킖YU|ٕll}['x
A[u['[`eZ=L
Ei-b6JdgZS|:˸u/F;pQz©U9y1oF6<Օ2CIù[Iw/a4_7aZq쇉]dH
x*+wZ3X#@n\DhIE8miZ:p'Iu7.QFy~dQ6`\qxE%{Z1ĕAW1izL|&0drLd3xQ2YMxVY_r4]YMgq`k9
;:.hv=}]LDaEkIR JPh:Zji\Y=e2YaEYbOcxQsXѧFʳ:i96;:6 !Mͷat(Ϥ*:\}CaE71:1P1aEOaE.. mm3H{piJL9r/֫˷@,i+t[|H[Os{3H_~*\@`#<wxa
	m3H&dܶҦUiuWcwb˝qWuޛ;plȼ
A0h:}&sjg #V
W?W<_鶂[pwG8D82)jժbme^$ݕiç; ,GAu/1n$ِ >vQcos[8$:ސJ$9." [ 9ޛCigKZ
\\Z5(]F^WB$}& 2I'I:TV'd9p!>
NE"rdJC{
4YU	]E΃#D' caGล1"^Zwa4gP*1I:qG(
F0ЍDi8p_
Ah[be	Ts73;\$dʯ]	f1/PD^ "@"F^bW'_/ e7 rbIB~I[H䵎GcxH:z:Hhl&L`&.vqE04&FfΗײFNj(g$OI:뵰y8%P2N]~Ы.գk]
ӵ.ZG`~u7;n7'L3Bõ.<0a<a|deڮrxg+&·2m+9%G.;1a;a9G.;ޑySxMԉsX.ɱǤm:JU]y?.\彶3sy*[*nk{ybݙnkIt[K,i(]j+m'C<m-uQ2LnkVa}ab[}Y(10f1ٶu'7;dȲdH
'.:"yYi 0>R?ꎧPΣ l
G(%&[U9a^̫(;}'\v 8#OvAJnDWnDWvMA8h*|
ɂ8*#f2)Z3Վ]T-l'j9cHD94۸HOs2!s2١sevB<Jԋ}մay(d!}]s.W춅sns)%mhXd|v(\&ʺy'N8CnS_S8LtX%;01椝e!e!Sd椝h!Sr&C-Dd2+1
)kh&i؟
ה[wtJs2ٵsҮMZٵs2UPEv
;_ڭ	e{
;
~N)N2TM7ַtNJvũR PG}dZ&;6$CB&;B&GPddRw|d9L׉֚$c>W]x>a R̍l9WXRdZ%8n?,hcB%.1܅9`gYY%;	(e0'qS#`Csqm	yDmb&uvAnP`].1XO
vAs摽|E?xrTg%jZ(K;qp\ډcNN2!ܚ8sq?'{!LpIvOMvOLdgvUHjWVMT(8H< m9qcOv #K)wS[rb'AL};pmceeB嶦ܴK0(,
b%:}TN&MSfO4lM J)nU!E{˄Oj,GX$MdKdRWyΪuO]U>zFKVlcp]1!T X>Az(%Ny7.dOC8=3">.
C>&JPұ~4 r!TۆoCz;F=\dǸ]'e 8 htԶeN&ٳmr@QJݸOXM=&,1'XV=XeFOEMH1k
KVzU!H_1M
?bN-	P#}XTHyŶ>z[]2UvKǬYm&mӑ>O>a|F94xV ,mX}šϹsW̩,	ǜSYcob1x ASsk
t8;'H<ja೶pX}9aqoTXO$>ǜ1QQ~+ՎȧQ5ύ|`hx49hB;Db_1YaiVb	',ثTy?pNG[ZU$xs҆EgU>2aYKX9&P\ՎIS˯[wg$L?dҞq`3EoL,̭aƙ;g;VhIM&2¤tpAdX?Ui|f \=0q=Կ&\4`rf脽GlthCkjz.e	{بI4LG#vbcM)q.>FMעd(^UL>a/;K{UL>˪bgiS9|ޒ)h
;gICdpxo`"FXޭ_X~a5R	6*>FM-,m
S*gexuZ/QY$S	|j{cNn̸zx`6UǕ
7Qtb47L;$OpuCƖ/>Fͺ)c9sNfc"r7QeҞc/5\YZRĩo5끶&#}ŜKy/bZ/f?F36j+!un/McNث'/z=&gTZc[Oبy݄ҶlT>}L;L0Yϯ3Yd̸9c.|5k{U1S 6j^waԿQ 8pYqFח`bF05ʿبuF](CҊA[&0FÃEwQ݀Oi7 S
Y:npnЧ)6Hښ CUiFrҢ;^β	бQ):Qe5 n*@;]2
U n]VuXIvs_.#SdTEWhnhЯa Q}OlT_VMFMj]QaMO~!Inq#lT\+~])uׯp[WcJҡcߗ7)=GIku%޺.pW_&\*W>MG'6{8cg9~}b 5{JVᕰ/RqL:)=6+KR\9A
+ i;m===[j{}N|=̲!Nبz&lTZQS0.B7M!G[
Xe?5iMyOo|=B7Z|F0Fu:ȷip8^:n"6x$恍:L  ?B?}̫~][wL0num|+I_aז%ykk8 uuv i
חE
`
C6jlTQS옦q6<	fE1MyZt/s/w4EӔi/4+E6ynST)Ad d dmhLS5~FMƩx4)nҌJƯx8ȣ㘶s4)MVcJcdń
K$d	4Y1V)MV
NK_Ni@y4B68agO䖙ب)vӨ+~ᾞ.~"O&dKtqL4;|f5Mb
Lݦ=g!
'v^ȷ"6c[̶mRQyAuyAwY30dU7du~èA0ju~:]W_/ݨ5`?Ѝ`:hQnLyۯ;6f*.dq.ግoi艍M dZF.QL`[5L h` sB>ul1a[:)mS
d|q`3EcCdR
بX<F4QMyJب|O;62,hcb+bcx_t
ǹ錍mZ۞Qim5hcҒNalpdQN&E&
L6*	lQ4ـ&fLe^7d///95j/5]f
M5e&t[,"'0J+u@w#Xu#d\unۍ@dAaRȉLfvb&c>匍.Ç6qNب1ֺ.WJF{.KihaH]0JxfJ7fjf%	y٬f%Kfw}=+2Ϡ)J=c&ctvlԔweZfD.
U<
U0VvLC}*Ps匍.l^' H=l2sإ.弴d8/myi<SKp.a¹h{;c|T/NFc"tlԔ%2dLVcŘuXd5h4!ØFKgln8#6A.au.%3&&.]J0f*01S2;{2;l݁.s:l1MdLaCV6j2[z2v)[]ssc:&c5ب#6jt//4R9oQmM_:a0l^lClT 3i)O-˒4/Q]+-6j2ֻliZQq:07L롍ҥ0Dq7kn3Ś/
0˩|ب2)Mh3H
{c}썽q,4єɘHiҹ,&_4jzNبݦiEVþ	بxǩgǩK9N_ʱil6j2;͊6W,+x)n0
0.$ӎ	+9ciX:a&d--u2;[w5"d{بiX	L'ldlw2۰IW2+6QIL$xkw`&c;tFM*Mu?a&ca-Pv]8F6b22|)pdw緝QӞV<r}v	!XxҌ
f;rFMu_l36j2;lzȡ[	+,gMmd<fR!Ӂm e.ɼ6|ȑQX9y%$(F-Q[x	5ѝwh6j2;Lfit7L-{6j2-ws#B	5ֽ{xʔ=-qlaǞqF	c7k۵6j2;Qg&}L7cvS?Xi%C3]qFMs	^=J ckKqv`|wc0/%zQaK^^\بɘpaƎ.?×|_y2pQegvm>7?;S060PP75]Q<4f4f*MCFF(6-gldp=p>L\XN`[D$]Qe{6j2;y
NgNN`;c&CˈQ.5uL"QD/[cӡt66^	5]%aR_
?buFM{w錍6faRvz>d_}a(M~2UግJٔبIuL2/hУ
/='6*#_x^/U5	V;ajRt݆1)/:r	m+wyٶ/+T5|)[fE)=pFMhۗQ9*&Kb脍ڞ)%ٶB9+Q*֨CN`;c&b/ %1F<{1Q@mV#6j/d$6j~oi&0p	 *6j7lC*rFMBpa*Nl@ZgUIV	Р;B]m6(lT88cjMg-mۍAŁӱjiOب`	V4jG'lTVw#6e[0_,m%RYƒ(obvC_ب7,uبz7MŁSjmtOبl88Jn{Fvha'Jk=0m*r3H&8c&7̆[HFmaJ8PZ<n8q`h,!t	 `84UG7'6jH˝"dt<F36j:VJ垥QaX3ld_Y4:V4I>q=qQG'l$nf:r:%6,bvMb9c&,wY:%o.%ki;dr 脍dYgrRٓLdOG̾D2,>T^ٗ6j
̓)KE ˉNX(tʇgldCsPG6;r~Ъ{'=/TrFFk/LبYEa-	&
>/5fʇgl,D	5ب f~boe1F5بy=ʖ_'~F36j^_*C~)pO R
OREKl,4%Kq/m*/=_rc˵؀xv~id3'c<F36jld7gq6Ob{Mg=cبĨ66*mNب#6Pa\_' 
t'^Yˉ}tN@166bBk	8c;'ڙ66׶;G8#;GNXݰ=y%7zN{\C@;GMϘnɄ=NG0'~񊇳腾"7> $ k^e%~YǘM:mq<ml{=xdO]>[o?yzyG˗|~qyo^˿|w?'>Ug>Y׵mH#P5MsEZ6o.jϿxr|凿⏽o^zEM~񣛏^}Gkw_\>>_޽l?nbg_׿B:?ѦO._կ݋/!>ⓗ?pP[{뗟?zҾCW_~ǟrCymضW~t귿}/{O.wk/߾wɋO?ǟt-.?թL|鿽x/x>_Z"~/?[x[*|˫//xB58Rx?o_}_^ZXkC>򣗿{?{{^śoZo~ݼ/^O^|=O>'콯>zV~I
cꏷ(8}1:O 7^NˏHMD>^է!'_~O[5B7>}XN9_m_mU]/l7w~X7VjEǟ@wi+u#f?/x/~unrsyz./>"+\>
W_|^\PX?҉Osk^Q}kOS_W/_~fi/?hyoF6>o)pe_Sh͵^~Vƭ>~?<_ߏ~/ڒϫF.-Ṽw}g//EMOx{Gݶ{i?o?{hˋׯ_|wq_wǟ|t6~
Ҥ{zZW-?ąIYZ֗O^U5L?WCh׸ѯ>'~^Ye~W!ǛM&bPQ~Oo.Gί_o<тgOԟ/^q<;^Y;KzEKZA˵؂ESgܷ}CgB}ڀi	~զ/.7(n4!bb!Z!yi5oX#Z߼W[.s:ǡ}ӯ/?f3jv>*L^>pPYeZx헗׿ÛlI֩߾_.mEi֔͛gKgK[=o_}!}i+H}}´o~UTy6ǟN17x		?m~UK&w\V2|5Piօ@qx@jRxjĿ^j\jfV~#6F6w'G>j&wjWzuǟ|9Gk[}o=[7nGTjFgӛq{uf֘7$|I#0"_׎T(
VDz<>y,G|#E_7}S3O?RFb O~qn|S݌h/r|Di˦K͇}+~7KR{p0E*Eo_}W=^Km\LnB`AC7c돟?
*"Zڦ
a)r~/g/>k:7_;`5{֙~Bj,M=n=z
'
-?ú4|oB[ `Ǫu߇_oT{J
?.;˧i-}umԟw{ܝLiSky|ɾK<YIoG__/9:;'/~?6__?nڶ~3oO??yG.#RRj s[Ӆ+g4oU~Vxrh7hx-3!}7Z28S`mi~/jMoO*Yx)xa)bǊ@k8GPϒҁ*/^p\Pq/x鿼EO0~7?ʗ(1͏">
_Yߦ">~77_(߽9gɛ.-ߵoL6WsQ,w}B7}7 ʶ/,Q~fhmd{
3mKu-w+o۪a~ڶGu-#ć&zPtR|z<,(7>hc|ܯ$dp6\XS-wuo
u桕f-wkҞć
yrMG n7aovp|[wKa_|Z}u}Yu]{KeZFQ^Q>Cn!$Ѫnpu	۵/Z5]:KBbJ
5o}
ǺMZN<fmV%j0r5ʘPJcI)[rkUAZU?Sfa_V-]عϏVQrԶJ!ʂ0fikkJ]{n14&C}P0}+o{7J?Ve?Z^Y۫޻זvۚ+b]xokl߇_09>9Xn&D0v4\ h%_pۊ꼷8Izk,+C5Vtx9#5ʝ>lݍقyuElkNoZoK{q+V{6{5l-.n7Hh۵|ޒn=Kǂ1;|6M6j_w6r[779bxx)VyyzSjm-V1Zo`6k-*y$d{PP$-{K ЦUa]q8` kch" dp(dwhi
m=!:5BɄ|Z i\kn˸5[g-[!®&rwpj4?Jjuu	j&~!?l7{@8b;
FUkgu_vݮ
A;
yp2ncp{xY#Fd5F>Kmm7mܵjp俥mtvEJys^]mݶkMݣMݏ.e$H6I&,Y ]1%${AJG+>E}|	 LU!銹ZfrQ>D]zƚ|צ
QbsE+wO+ƥtjǸ,`@EpݤzM
$<mjת$ց5@}Kew, dR	wX}@RuY @Z+7n}aˡT)Z+	#!ƺhr-l` Ѯ-F7>+#dv,Lml7&XOιrnWLj<'^[SU`"p
zJBnn rǭ+.yktJ٠>vP`E{[,66(õ.li!Jن{{%
?#4Պx@y[ q*B8@︧.t(zZ[]`5cB5I1\[m2s%4,h	apl`;c$mrܡ}ܱ a[
n7Y=ĨB71؊7=^qhLn_C143T5Q#-4 ZL6j&#kŶLцP5p[
][pԺ	ZaO&rYG7
V؛lc|Y0eZB}؛ܸa
޻Ԅ!x[aQ>5RZW$6ќPnVWDM^/)hC;FvXi
./Pmwٲr̴!]E~c_zXXm,YM,wtIkA(
$RZRy.F(Z/,R*Wn\yiJ['BMˁ\ Go |n۴)7@=fZL&
Ps}.uj,u@XNm2$i2dΞ5 t[\KMmO
mzDhU!ZBǉZ!ڒs_Sxk+6JH{X<kV%}Ϝdx?.WjL+vx	ڡY2@xT=cQWQ"3th$Eq9 
-h
Hu6C(}:xҹv$G2z{d{h1w?ˀmj{X)+|/bח/˟\)r%}"|/>_Ӥl>MW݄Q5ywa.
jnBeM8\n%NԴ}<WQ	o]_
#>ُ
C~o~S77Bvk_Ps%#%S(Ns"	r
7t<Z/ξ0qH򠏬 dSfްOwcko.r;:?r#nz)dϹ@A.3;wd1jaIM&(ݜscn.p
i@h }΋Do}\8tħ̔Ȼf᭑B1	;n 黱"wQ3cxiFS=_v=-nV5TAhK3/rSN3|T ro^ǂޡ9U/c~- @Xn=i(@&QaKoKT#F<%dm-"<c5l
ЙNuY!H3E6GV51>z<eԩ%H&T91M& S8Ǭ#v&ap"R!G!*{Yڄ稴1;@fBYm:Y#s"tPq=mGr&ڍp}mYMt/DYnc#%W=Yb TӞ!m؞~6j/#1w̅=bZ
d/H[sTi i;bЖ6lXz_:b q5FKW(T}v#"gql](cT'ȸtAc/#z,B>(dO$D ?f1si+b:Ppiy9aݛzloұ/&6+prق.z1ܛ	ƍU%N1\pЍ	!VʅuR#kRc#0➖o-5,ImʇdЋafYu4:)KElVXN{w$">( !pz
rU$пÿAX\;ۨ\FIc.QM@X@!:ݘ	 H*[aSwc&0#pT'L@#)cX4N>h~e4,RP |`Kzzq (Fnz{r,K 1?c"&4%0äϞM@d;䳭L`M-Lh*G{<q. )MB $C(ؚ@H_6UxPvB9tjRtriu^H	X+yo`>6jĶmٶĉT`$P8AhI*RH F3l@dږäèlsһ.6)QA &F`qm.&D+VC2\EF}	N	EH3"ےzC7H
Q Yh$У
1pvV¦p)6KTᚨj 0hҐ&2ECeQYO	Lᔹ
 )z,&Tv"O=1rP
xp+ZXMw%O4GNx}q[ Ĺ#QEFJ`I캬<udjv6d
0K3HX>KE&oM]c/JQ^
:@B|C˳,_yR3<q/G DV)?;W¶t("B|ʜ6QʑHld)dQaK)5]!'P,aFY
ihH 	)O
hb*Y3s!pc#ϼ.р	
EK_ XSUtMGX4=6fwj:eS!mUШwwj[2VITCf NH	LG*k5[c!ǔZ۫q>c1
&C`ZfЊ ja(kalU[XĢϗ=TF,"U4"RZeHCr=
Da,#.5fL&y+Q6jF!UܢhέBSR*ǔQ嘒< NY+T-2.L`69Hn4ɞM}QMj6@_GdQ=$*ǗQ*Tk&l2#2r|I1CʯX<2a<ϣQɣcE;JkOX3X	ǚ>ka$͏f9F_w@ca.#Ĭ=٢дTɗh )\2~ԅIp`XDTcV؆{\hT,h,yvڣB}ԔUL
Рh.LWGMcQ'mT%T[SD㇑/rU2UiGM2
:}4#cW%HW	HKN|5%Qך_8gA	l~<J&a9uĥQ]b֬ûɣ(:.6W&dhSEsq V(!Xo7ƵPzĚ'd+#|F
>G5a+S|,!(5UW\(|n?ex7{TQyrGkj
jqy>ª+{P]9iBWrx*_r<u;<AZ)In((ۈBL+<Uyr쯪+>T뉂n(Cuf[&	.ď
 I-¡riX^'\	[Db{1(Rp0J&(Zyn) I*%kTbK	ѳBJxKc(tUnġ] *K:ha!]yb
+Le(XD"
BGTuª+Yw勹RD~+D%DaroN7Z@o/tbzZ0K"sPW"b,,TJlɥϲJ&yXan	QggH2(Ryg#גMOu孂dU |u<B2ɪx-(HfHr#X$pΉ
yUW3Q'γ|9$dS<7喬
a,pI.8
ޚQLd^^x 3yB[E=$"/4%"dǢS[9y.o0FaS}L+>
cG-)h;
lK9/0Nu+֭r芌\%@-Mn:؁lΫ(
 ȍgVѽNj0^DлA!P"(
>ŭww×a
WO-<1_w&h;0.{ИB'[J=ywOcF{|%\bM?aKoW*#Xhu!^MZgil7.$"&޹
ڌ׭-1y,^FQ2WT
p {#/ިCY1qgݞmaOqR$p5EI[vRU,`]-xMEyQaಿQvҐ	.=ڐamh9h	h<d`!zVD~B#Df	.iGxAk
bzIMr"tᮂWJ=qqu7I9TS}2ILLbhc_ o%bSD"#I`a	Eݑ,vR-_?0*ñqΣ~8.]e穦΋ഭZ:LJh3<q .3@>M\3ΔjQpkЎ1P׉WΪ4ۏŚ!&ΫflD]c:nIhm 
"Qp1.&
`$eª;q}ڊ`aZiШ=w'0=6Qi'9t]N NmGW^}o@fAHY
J|\6`ύ-  Z
                  &UAC|)F=<{? A +=0_SPp-׻uy&! MX 
eOV(]Y;=< aAN</300r$2GMMh947ſ.eEBi^?&PL =- P2}^߉u?*P=nOs]aʚB&?&ߞjj  )¿x!-*^HD
{a5OjXt~Y`R@
+B$
Q)
j+uOz '` 8Z!\-A>5`1xrWK-}%SאopVf/]YϛAе~=k+PϗF5cvxVټ=na`3]{ u?,?$f"fz<
 O.o<6 O
6ȓo<|oImȓȓ'
qi÷8\4C.@naor@E9s ۢ9mQ(py[?r-9\ρ.or@E93 ۢ9mQ(py[?r-9\ρ.v(˟9#[b;,m}RkRbuh]^#+80UͮqׄsO9@`fO`',:.`+]	FOFzx7,+:F]e|fXa+*yF:ޮaE/;K6D]ABͳ1 _GqzⰢ4VT`9ͷVzz{Ke6F*1пVM@>Al
s8+N&Aň^O%_gSav}-V_I
oHH
_vHVro9a1;r2o%soxU'W2ƥ;_s.6m6SfT|ޏD{17{S5FO~{7.nk_  D\3hP8w{iD nQＴߑuPFa'Ab X$}dr$?z4VF0b̮&! J#`I=@Pu<JB_XML
A[*ATp$5wvڂ;]%xvs}=\q[KClI>lqق,
\\2]܂,
2>L[gAhGxdzT8 vtڠo}l,bijPA²\
.(Y6,
3M [u?R\}C4~-x2pt902%-]3`߂(
3%g@>:4GY;\R rYH/Lz
2S{&蜥Ib|zgztұ>EH4nX d8
1S \U |Ppqc3G1$hG$Kۃ3t,ѕ~[OY
}}lۆ@8qhJ~ Ph"H)W ҭ)JB82˸q vm߾q aἆUL#EzHo̒+޷2s̈́)H%6/Ĝ0M%86jT2M ؝iaM*]m2>*v*j%#6eQ0v6n-B(ualFFKex!f陟JXFzq8HЫ$ߎUF~3ڬm%tgtio a(!,*Y9
/- j=!yDҢ\KrAsI/myzf˃/z}j	wm ZPAM'i9(	q1IZ-c [tp:f)	\>ղ4uYn!q7P1]OSbȉ>ɻ)}
pma8j҉x`GCSX$"{JhO.EshbĔ)zkңtaטl1(4֍ΥG<D9s$15c2JL\0%-ЅQrĉX~~t ]Oc}S2%ց)cʙͮ]J~f}"2Tϒ?eL=Ŏ2}	רcagq882>|06"O>QV406"?4(!+"dc,'!w+Q\(+Ȭc}"hUS`zyQC;K/SD= ĤWqk8E:_ _%;*3u}@A3WL@!A#}ǜQGGOS7P3/69l"w1˓#1W9 J7e>FDmX	gtܹ# #!(ey=.a=8z~zI!FP,[=ru@y9Ĉf8E@	c1u5u3G b 975Nm48.q&BT&6꫘a ~/dLxLh8 v	8ǆcN}r&}9̩+;cNԿYp[x_1q*Pa{$ўC&ux*?O5W̩M̕1b
[5W̩s)zMcNt^ w4w'Än\8Os1%xjh1sNUЗZ멾i멾g%$zώs~.90G "g1Diۚ+T_Pz]uLcNƒ8=}ǜKMu"u*?t_" ycN?%(>ͺ}6ԲS:xjY=1SL`1|aў_3|*Ȱ)z̬/+
5W~zg17OvJp?+u2'QFSfvX2jQqT9W^4	o6,|:SOPgG(&hP\XmG
c
6*H1h:g>/.^??ͪ @
(J!Zi/D+B?&p?%D<}4".6Bym]tOT$Fx
BUSO׍[:60UZ)*9QQEh~̓"xpO^om.D)t&T)NumĔ^LjTy^`AhQ^^bYl|
UՎD~j6ē"U<CN>w';e ,Te
'!Q`ʓX:(*˝sDq#IJȤD
DVA^n
(%Nz+i0]9u2xҧi^wJw&QY\VN\Rx}/_	algu< ia@:}iîdzwҩU0Q*>q`E2jp/Opۓzyl`\uҙJd.̐ڏDOfJWHeŽ-!s*ר%BfjjWGrtte.8#GEFEq9CGen+3qcز)+cz#6!)zYaz&-T݊l/19uc8fQFk^}jQ4h]C]{ h;	m̭$1Þ64,
sϧXGB6Zc/b|Bp?oz_
Q5ˎz1ve/wvpEJ؟Y˸?Z,4*QVY!.jaˬ3e6"Zϓ$##.4Tѽi'i-!yuD:|3Cs@4:7A?R=zF3qR.
d~`_vA(lxc+O'GU+oeE2%x,"/M%Qi5}zֽ.Fq&-HžTTn,{G0ڢ%VYay<ꨈQǰ<(mR	Zxم_++!`2HY9Rbk'!A㠳'}NA
38XxKYȭdCEXgeV-˜yY4]NZ Wk]Kq`	{XEy#P>j'?Q`:sX$-t[16nO!6GBR Α`iSWTZ|Dh3I (ⶪ2nVkgC$ui^" Q.NK" /Z{D[/חzŸ#^A	W{@ZzX8*}>ibZu<MSI2:j$v/<\!$o٥m9r$W!5GԬCx!5tg'H>	WfaG}n|{ۃo?mg=YMLA}}IF
eBFmngKYHO`ģϽ0XMC}PK֬<9~|-r[偭>Og8ŞǱ$˒a)f(ڸFhiif2ѲW4 j ʲf.~!4]L4Mh˘yі䘓 LV64BLI(CC0"T~snvS
fc7]yr̙Fmf"1msq.$A(JJ?4rl=̈SJI`,@${`KH>>n\Ţk},#m	nEBXrrLVn%eEAZJne.ڪ.6E&y&Gf}-,bRmg%ig:Bb9t]\tv}D#n\e{֪Ѷz,
	mGcBgY4[6#,%6A ^mI*>^vD9ӥ6C,e2hF	Qp$Жhd1LQhS8v-q
e瘍lׇ6H&m3F57_rJ&Ѣd5'o$0aʼp3&TNkrۊ"ƭ6,hINK;M%Z:(	pPfdZ?j&b\]j"Ƽm|)mKA[dІ.w\lOLR
^'0W~pXs5eyr
\w	!almb8QK
^3cڌju+kG#'mM׽λ4Q?%㷰ĘΒK4,bۉ.DUVM.o$-թڀiqHwW]̺~#]kHQǷXqk%
M+Ґ6[x༷00=dS%~6gtP`fM(_lJhp]n	d OiѠ:{{*z1Lv^Y>O$	Ӡ<!s4g-,	f:kR5	Mc^$7vh6c*ǼS?|@B9zN}p̛AcdrGyY^tcl>6g/e&Qi)@'3;#}Gxc3]qxoqGAyd̚z䋽d̚Xb0=B?9M0i$f{d$h}"G=&&XFFI{O&pA4vI%K 9XɊH~WZE#{iɒ)95E'zɄ#t0Yb%3ҩ̩t]ma6S{	vhܤʸM6dT?&3feӕAxf1M,*t̔u!I>U8$'rӉ0H2{1eubwm^.2t̞y̞
6dT̓$"ǘ:{jP6$蕅Kf#fO1{*]6ŀ̞9SQFbHfO=rrH>4=s"IGIf7I:*GgPefPefPe2ttJA5 F<j/tV<4=TӉA5uVTV:oEhK#bAuCXuME@fS1uE^ J>ėJg͢#LHFhU2FX1X,LGb%͢$M֣
`#3O<OcgQE:ji¨_gQEۛE\3fQŜO ]iE5ta,X?YS70
ɢ'aE@cgREêN)f!/f39;jlEhfŨ
6KQl BQ`DbAe#IG4*q.a3fRͤ}f4jdʗs#5s3"Τyp2gUO~l1)5M٘fjD-4/֍h6Ub?ͦyb6Ul{nL+|	fpE\?h{bͦ6*Tqͦ9c6ղTQdh
<Ck0*t`6U:3Ms&t6&sT1gSkYգZaWiWiFU'3+_
jfӴ#XY[f<`^]ZۣYYApѽͣYYCOk!=wU[wu`D̟'I0*-lfE<e`fmyQ5O=5tFUUVƊ4͠%lfrE9763-ΪLi*_̟`VU̟`VU3?:k&BgYeZqzg3QuՅXdC'R,d`
QfU:ꪋE2)쬪HӬKfU1*֟`VUΥΪqYUQΪ
>Ϊ4/YT`6W48$:*ܙU701%B)`fյs}ųK/XCgZEZd:*3j̣Vd]QVu(d
VW(vfU$7̪Ls2'fյ31JFs̪H3"ά!,K̥3]'̪d4*OV>s̪H̪ìS\YNW<!u-f9E̮JrIbvvUi2ybf[%>z
j<fVY;jX=2)
G!jeokgRE6LY%$nf9EYNYNYNіfWYd9]d9]d9]ͮ]gy0ҥȷ](@fW=&MpX	&i&LHSrk2iYɣKW)گSd+]%VF3̒S֛Y	j!U7V1 c>)6Tc􌼄2szpiqD7`!>*Ufkԇϭ=!\:x	j3 LW;Naz0iL9ܦ"af$ufƴ(IN۴Ȕ^b2!0>qHU1.^qDV 7 ypy[zђDH;IIKNuIZ29crJc0#U7ӘbgdE*m'vF<jGR#IU]yA%op+cy2N-JY[g:M>2qkE`t\MShJ={ie                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    