set pointsize 0.5
set yrange [0:1]
set xrange [0.5:1]
set xtics 0.1
set ytics 0.2
set nokey
#set terminal postscript enhanced color 7
set terminal postscript monochrome 7
set xlabel "xaxis"
set ylabel "yaxis"
set output "efficiency_symmetric.ps"
set origin 0,0
set size 0.3, 0.3
set multiplot
set title
set title "",-.5
set origin 0.0,0.03300000000000004
set size 0.25, 0.25
set key top left spacing 1.0
set nokey
set ylabel "efficiency"
set xlabel "\alpha"
set y2label ""

#what we really want here is to divide the graph into two regions: 
# alpha \in (0.5..0.853) in which only symmetric eq exists, and efficiency is : (2alpha^2+1-2alpha)/alpha
# alpha \in (0.853..1) in which the worse eq is the assymetric and the efficiency is: 
# eff = 

plot (2*x**2+1-2*x)/(x)

