\NeedsTeXFormat{LaTeX2e}[1994/06/01]
\ProvidesClass{mye}[2000/01/19]

%Variant of egs.cls.  Options: ms (manuscript) and normal article
%options.
%% The egsclass file is available from
%%     http://www.copernicus.org/COPERNICUS/latex/latex.htm

\newcommand{\NPG}{Nonlinear Processes in Geophysics}
\newcommand{\PCE}{Physics and Chemistry of the Earth}
\newcommand{\KHB}{Klein\-heu\-bacher Berichte}
\newif\if@draft
\newif\if@egsbook
\newif\if@khb
%\DeclareOption{draft}{\@drafttrue}
\DeclareOption{ms}{\@drafttrue}
\DeclareOption{inbook}{\@egsbooktrue}
\DeclareOption{khb}{\@khbtrue\@egsbooktrue}
\DeclareOption{fleqn}{\relax}
%\DeclareOption{twoside}{\relax}
\DeclareOption{twocolumn}{\relax}
\DeclareOption{titlepage}{\relax}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass[fleqn]{article}
%\@twosidefalse
%\if@draft\@twocolumnfalse\else\@twocolumntrue\fi
\if@draft\@twocolumnfalse\else\@twocolumnfalse\fi
\if@egsbook\@twocolumnfalse\fi
\def\refname{References}
\def\figurename{Fig.}
\def\tablename{Table}
\def\fnum@figure{\figurename~\thefigure}
\def\fnum@table{\tablename~\thetable}
\if@egsbook
 \def\abstractname{Resume}
\else
 \def\abstractname{Abstract}
\fi
\def\acknowname{Acknowledgement}
\def\acknowsname{Acknowledgements}
\if@khb
\IfFileExists{german.sty}{\RequirePackage{german}}{%
  \ClassWarningNoLine{egs}{Cannot find german.sty; proceding without it}
  \@ifundefined{language}{\newcount\language \language=0}{}%
  \providecommand{\selectlanguage}[1]{\csname captions##1\endcsname
   \language=\csname l@##1\endcsname\relax}%
  \providecommand{\iflanguage}[3]{%
    \expandafter\ifx\csname l@##1\endcsname\relax ##3%
    \else \ifnum\csname l@##1\endcsname=\language ##2%
    \else ##3\fi\fi}%
  \@ifundefined{l@english}{\chardef\l@english=255}{}%
  \@ifundefined{l@german}{\chardef\l@german=254}{}%
}
\def\captionsgerman{%
  \def\acknowname{Danksagung}%
  \def\acknowsname{Danksagungen}%
  \def\refname{Schrifttum}%
  \def\abstractname{Zusammenfassung}%
  \def\appendixname{Anhang}%
  \def\figurename{Bild}%
  \def\tablename{Tabelle}}
\def\captionsenglish{%
  \def\acknowname{Acknowledgement}%
  \def\acknowsname{Acknowledgements}%
  \def\refname{References}%
  \def\abstractname{Abstract}%
  \def\appendixname{Appendix}%
  \def\figurename{Figure}%
  \def\tablename{Table}}
\selectlanguage{german}
\fi
\if@draft
\oddsidemargin  0cm
\evensidemargin 0cm
\textheight 22cm
\textwidth 15cm
\topmargin 0cm
\raggedbottom
\let\subsecsize=\normalsize
\else
\def\@normalsize{\@setsize\normalsize{12pt}\xpt\@xpt
\abovedisplayskip 10\p@ plus2\p@ minus5\p@
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip  \z@ plus3\p@
\belowdisplayshortskip  6\p@ plus3\p@ minus3\p@
\let\@listi\@listI}

\def\small{%
\if@egsbook
  \@setsize\small{9pt}\viiipt\@viiipt
\else
  \@setsize\small{10pt}\viiipt\@viiipt
\fi
\abovedisplayskip 8.5\p@ plus3\p@ minus4\p@
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip \z@ plus2\p@
\belowdisplayshortskip 4\p@ plus2\p@ minus2\p@
\def\@listi{\leftmargin\leftmargini
\topsep 4\p@ plus2\p@ minus2\p@\parsep 2\p@ plus\p@ minus\p@
\itemsep \parsep}}

\let\footnotesize=\small

\def\scriptsize{\@setsize\scriptsize{8pt}\viipt\@viipt}
\def\tiny{\@setsize\tiny{6pt}\vpt\@vpt}
\def\large{\@setsize\large{14pt}\xiipt\@xiipt}
\def\Large{\@setsize\Large{18pt}\xivpt\@xivpt}
\def\LARGE{\@setsize\LARGE{22pt}\xviipt\@xviipt}
\def\huge{\@setsize\huge{25pt}\pt\@xxpt}
\def\Huge{\@setsize\Huge{30pt}\xxvpt\@xxvpt}
\if@egsbook
  \def\subsecsize{\@setsize\subsecsize{12pt}\xipt\@xipt}
\fi

\normalsize
\oddsidemargin  1cm
\evensidemargin 1cm
\topmargin -2.1cm
\headheight 2cm
\headsep 0.5cm
\topskip = 12pt
\footskip 30pt
\if@egsbook
  \textwidth 11.7cm
  \textheight = 45\baselineskip
\else
%  \textwidth 17.7cm
  \textwidth 12.5cm
  \textheight = 56\baselineskip
    \setlength\@tempdima        {\paperwidth}
    \addtolength\@tempdima      {-\textwidth}
    \setlength\oddsidemargin    {.5\@tempdima}
    \addtolength\oddsidemargin  {-1in}
\fi
\if@khb
  \textwidth 16.9cm
  \textheight = 56\baselineskip
  \oddsidemargin -0.54cm
  \evensidemargin -0.54cm
\fi
\advance\textheight by \topskip
\columnsep 0.7cm
\columnseprule 0pt
\fi
\parindent 1em
\parskip 0pt plus 1pt
\if@egsbook
\def\section{\@startsection {section}{1}{\z@}{-2em plus-1ex minus
    -.2ex}{1em plus.2ex}{\reset@font\large
             \bfseries
}}
\def\subsection{\@startsection{subsection}{2}{\z@}{-1em plus-0.25ex
    minus-.2ex}{1em plus.2ex}{\reset@font\subsecsize
             \bfseries
}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}{-1em plus
    -0.25ex minus-.2ex}{1em plus.2ex}{\reset@font\normalsize
             \bfseries
}}
\def\paragraph{\@startsection{paragraph}{4}{\z@}{1em plus
    0.25ex minus.2ex}{-1ex plus-.2ex}{\reset@font\normalsize
             \bfseries
}}
\else
\def\section{\@startsection {section}{1}{\z@}{-2em plus-1ex minus
    -.2ex}{1em plus.2ex}{\reset@font\normalsize
             \bfseries
}}
\def\subsection{\@startsection{subsection}{2}{\z@}{-1em plus-0.25ex
    minus-.2ex}{1em plus.2ex}{\reset@font\normalsize
             \rmfamily
}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}{-1em plus
    -0.25ex minus-.2ex}{1em plus.2ex}{\reset@font\normalsize
             \rmfamily
}}
\fi
\if@khb\else\let\paragraph=\subsubsection\fi
\let\subparagraph=\paragraph
\@ifundefined{reset@font}{\let\reset@font=\relax}{}
\setcounter{secnumdepth}{3}
\if@khb \def\desfont{\bfseries} \else \def\desfont{\itshape}\fi
\def\descriptionlabel#1{\hspace\labelsep \desfont #1.}
\def\description{\list{}{\labelwidth\z@ \leftmargin\z@ \itemindent-\leftmargin
       \let\makelabel\descriptionlabel\reset@font\small}}

\let\enddescription\endlist
\setcounter{topnumber}{1}
\def\topfraction{.7}
\setcounter{bottomnumber}{1}
\def\bottomfraction{.3}
\setcounter{totalnumber}{3}
\def\textfraction{0}
\def\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\def\dbltopfraction{.7}
\def\dblfloatpagefraction{.5}
\long\def\@makecaption#1#2{%
   \vskip 10\p@
     {\reset@font\small{\bf #1.} #2\par}}

\long\def\@makenarrowcap#1#2{\hfill\vbox to \z@{\hsize=5cm \vss
     \reset@font\small{\bf #1.} #2\par\null}}
\def\figbox{\@ifstar{\let\egsbox\makebox\@figbox}
  {\let\egsbox\framebox\@figbox}}
\def\@figbox#1#2#3{\setbox\@tempboxa=\hbox{%
  \if!#1!\egsbox{#3}\else
  \egsbox[#1][c]{\if!#2!#3\else\@tempdima#2\relax
  \divide\@tempdima by2\relax
  \advance\@tempdima by-\fboxsep \advance\@tempdima by-\fboxrule
  \vrule\@height\@tempdima\@depth\@tempdima\@width\z@
  \vbox to \z@{\vss\hbox{#3}\vss}\fi}\fi}%
  \@tempdima=\hsize \advance\@tempdima by-\wd\@tempboxa
  \box\@tempboxa
  \if@egsbook\else
  \ifdim\@tempdima>5.5cm \let\@makecaption=\@makenarrowcap\fi
  \fi}
\let\@oxfloat=\@xfloat
\def\@xfloat#1[#2]{\@oxfloat#1[#2]\small}
\if@twocolumn
\leftmargini 2em
\leftmarginii 1.75em
\leftmarginiii 1.5em
\leftmarginiv 1em
\leftmarginv .5em
\leftmarginvi .5em
\fi
\def\labelitemi{\bf --}
\def\labelitemii{\bf --}
\def\labelitemiii{$\m@th\bullet$}
\def\labelitemiv{$\m@th\cdot$}
\def\maketitle{\setcounter{Maxaffil}{1}%
\setcounter{footnote}{0}%
\begingroup
\def\@thanks{}\parindent=0pt
\if@twocolumn
   \twocolumn[%
    {\begin{minipage}[b][7.5cm][s]{\hsize}
   \null\vfil
    \begin{minipage}{\hsize}
    \raggedright
 \let\footnotesize\normalsize
 \let\footnoterule\relax
 \def\thefootnote{\fnsymbol{footnote}}%
   \def\@mpfn{footnote}%
   \let\thempfn=\thefootnote
   \renewcommand\@makefntext[1]{%
      \parindent 1em \noindent
      \@makefnmark##1}
   {\LARGE\bfseries \@title\par}
   \vspace{10pt}
   {\normalsize
     \renewcommand{\Authfont}{\bfseries}%
     \renewcommand{\Affilfont}{\mdseries}%
     \setlength{\affilsep}{4pt}%
     \baselineskip 15pt
     \let\and=\sw@and
     \begin{minipage}[t]{\hsize}\flushleft\baselineskip=12pt%
        \@author
     \end{minipage}\par}%
     \@thanks
   \end{minipage}%
   \vspace{20pt}%
   \end{minipage}%
   }]\else
\global\@topnum\z@
\if@egsbook\if@draft\else
    \begin{minipage}[b][5cm][s]{\hsize}
    \null\vfil
    \begin{minipage}{\hsize}
    \raggedright
 \let\footnotesize\normalsize
 \let\footnoterule\relax
 \def\thefootnote{\fnsymbol{footnote}}%
   \def\@mpfn{footnote}%
   \let\thempfn=\thefootnote
   \renewcommand\@makefntext[1]{%
      \parindent 1em \noindent
      \@makefnmark##1}
   {\LARGE\bfseries \@title\par}
   \vspace{1cm}
   {\large
     \renewcommand{\Authfont}{\normalfont}%
     \renewcommand{\Affilfont}{\normalsize\normalfont}%
     \setlength{\affilsep}{4pt}%
     \baselineskip 15pt
     \let\and=\sw@and
     \begin{minipage}[t]{\hsize}\flushleft\baselineskip=12pt%
        \@author
     \end{minipage}\par}%
     \@thanks
   \end{minipage}%
   \end{minipage}%
\fi\fi
\fi
   \renewcommand\@makefntext[1]{\parindent 1em \noindent ##1}%
 \let\footnotesize\normalsize
\if@egsbook\else
  \if!\@corresp!\else
\footnotetext{\textit{Correspondence to:} \@corresp}%
\fi\fi
\endgroup
\setcounter{footnote}{0}%
\let\thanks\relax
\gdef\@thanks{}\gdef\@author{}\gdef\@title{}\let\maketitle\relax
\if@draft\gdef\baselinestretch{1.4}\reset@font\large\normalsize\fi
}
\renewcommand\and{\@centercr}
\newcommand\sw@and{\end{minipage}\\[1em]\begin{minipage}[t]{\hsize}%
  \flushleft\baselineskip12pt}
\def\journal#1{\def\@journal{#1}}
\let\booktitle=\journal
   \def\@journal{???}
\if@khb\booktitle{\KHB}\fi
\def\msnumber#1{\def\@msnumber{#1}} \def\@msnumber{???}
\def\firstauthor#1{\def\@firstauthor{#1}} \def\@firstauthor{???}
\def\proofs#1{\def\@proofs{#1}} \def\@proofs{}
\def\offsets#1{\expandafter\split@off#1\\@@ \def\@offsets{#1}}
\def\@offsets{}
\def\split@off#1\\#2@@{\def\@corresp{#1}}
\def\correspondence#1{\def\@corresp{#1} \def\offsets##1{\def\@offsets{##1}}}
  \def\@corresp{}
\def\received#1{\def\@recvd{#1}}   \def\@recvd{???}
\def\accepted#1{\def\@accptd{#1}}  \def\@accptd{???}
\def\communicated#1{}
\def\abslang{}
%\renewenvironment{abstract}{%
%  \if@khb \abslang\fi
%  \if@draft
%    \if@egsbook
%      \if@khb
%        \reset@font\normalsize
%        \begin{center}%
%          {\bfseries \abstractname\vspace{-.5em}\vspace{\z@}}%
%        \end{center}%
%        \begin{quotation}%
%      \else
%        \section{\abstractname}
%      \fi
%    \else
%      \reset@font\normalsize
%      \begin{center}%
%       {\bfseries \abstractname\vspace{-.5em}\vspace{\z@}}%
%      \end{center}%
%      \begin{quotation}%
%    \fi
%  \else
%    \if@egsbook
%      \if@khb
%        \paragraph*{\abstractname.}
%      \else
%        \section{\abstractname}
%      \fi
%    \else
%      \reset@font\normalsize\par\noindent
%        {\bfseries \abstractname.}
%         \ignorespaces
%    \fi
%  \fi}{%
%  \if@khb
%    \iflanguage{german}{\gdef\abslang{\selectlanguage{english}}}
%                       {\gdef\abslang{\selectlanguage{german}}}
%  \fi
%  \if@draft
%    \if@egsbook\if@khb
%      \end{quotation}\newpage\fi
%    \else
%      \end{quotation}\newpage
%    \fi
%  \else
%    \if@egsbook\else
%      \newline\null\par\hrule
%    \fi
%  \fi}
\newenvironment{acknowledgements}{\begin{description}\item[\acknowsname]}%
    {\end{description}}
\newenvironment{acknowledgement}{\begin{description}\item[\acknowname]}%
    {\end{description}}
\def\ps@cameraready{\let\@mkboth\@gobbletwo
  \def\@oddhead{\reset@font\normalsize
    \begin{minipage}[t]{\textwidth}%
\hspace{\fill}\thepage
    \end{minipage}} \let\@evenhead=\@oddhead
    \def\@oddfoot{}\def\@evenfoot{}}
\if@twocolumn
  \flushbottom \else \raggedbottom
\fi
\def\iftwocol#1#2{\if@twocolumn#1\else #2\fi}
\if@draft\ps@plain\else\ps@cameraready\fi

\pagenumbering{arabic}
\if@twocolumn \flushbottom \else \raggedbottom \fi
\if@twoside \flushbottom \fi
\newcommand\fncomma{\textsuperscript{,}}
\AtBeginDocument{\mathindent\z@}
%% Copyright 1997-1999 Patrick W Daly
%% Max-Planck-Institut f\"ur Aeronomie
%% Max-Planck-Str. 2
%% D-37191 Katlenburg-Lindau
%% Germany
%% E-mail: daly@linmpi.mpg.de
\def\ModuleVersion#1[#2]{}
    \ModuleVersion{authblk}
          [1999/02/23 1.2 (PWD)]
%% authblk coding copyright (C) 1997 Patrick W. Daly
\newcommand\Authfont{\normalfont}
\newcommand\Affilfont{\normalfont}
\newcommand\Authsep{, }
\newcommand\Authands{ and }
\newcommand\Authand{ and }
\newlength{\affilsep}\setlength{\affilsep}{1em}
\newlength{\@affilsep}
\newcounter{Maxaffil}
\setcounter{Maxaffil}{2}
\newcounter{authors}
\newcounter{affil}
\newif\ifnewaffil \newaffiltrue
\newcommand\AB@authnote[1]{\textsuperscript{\normalfont#1}}
\newcommand\AB@affilnote[1]{\textsuperscript{\normalfont#1}}
\providecommand\textsuperscript[1]{$^{#1}$}
\newcommand\AB@blk@and{\protect\Authfont\protect\AB@setsep}
\newcommand\AB@pand{\protect\and \protect\Authfont \protect\AB@setsep}
\@namedef{@sep1}{}
\@namedef{@sep2}{\Authand}
\newcommand\AB@affilsep{\protect\Affilfont}
\newcommand\AB@affilsepx{\protect\\\protect\Affilfont}
\newcommand\AB@setsep{\setlength{\@affilsep}{\affilsep}}
\newcommand\AB@resetsep{\setlength{\@affilsep}{\z@}}
\newcommand\AB@authlist{}
\newcommand\AB@affillist{}
\newcommand\AB@authors{}
\newcommand\AB@empty{}
\xdef\AB@author{\noexpand\AB@blk@and\@author}
\renewcommand\author[2][]%
      {\ifnewaffil\addtocounter{affil}{1}%
       \edef\AB@thenote{\arabic{affil}}\fi
      \if\relax#1\relax\def\AB@note{\AB@thenote}\else\def\AB@note{#1}%
        \setcounter{Maxaffil}{0}\fi
      \ifnum\value{authors}>1\relax
      \@namedef{@sep\number\c@authors}{\Authsep}\fi
      \addtocounter{authors}{1}%
      \begingroup
          \let\protect\@unexpandable@protect \let\and\AB@pand
          \def\thanks{\protect\thanks}\def\footnote{\protect\footnote}%
         \@temptokena=\expandafter{\AB@authors}%
         {\def\\{\protect\\[\@affilsep]\protect\Affilfont
              \protect\AB@resetsep}%
              \xdef\AB@author{\AB@blk@and#2}%
       \ifnewaffil\gdef\AB@las{}\gdef\AB@lasx{\protect\Authand}\gdef\AB@as{}%
           \xdef\AB@authors{\the\@temptokena\AB@blk@and}%
       \else
          \xdef\AB@authors{\the\@temptokena\AB@as\AB@au@str}%
          \global\let\AB@las\AB@lasx\gdef\AB@lasx{\protect\Authands}%
          \gdef\AB@as{\Authsep}%
       \fi
       \gdef\AB@au@str{#2}}%
         \@temptokena=\expandafter{\AB@authlist}%
         \let\\=\authorcr
         \xdef\AB@authlist{\the\@temptokena
           \protect\@nameuse{@sep\number\c@authors}%
           \protect\Authfont#2\AB@authnote{\AB@note}}%
      \endgroup
      \ifnum\value{authors}>2\relax
      \@namedef{@sep\number\c@authors}{\Authands}\fi
      \newaffilfalse
}
\newcommand\authorcr{\protect\\ \protect\Authfont \protect\AB@setsep}%
\newcommand\affil[2][]%
   {\newaffiltrue\let\AB@blk@and\AB@pand
      \if\relax#1\relax\def\AB@note{\AB@thenote}\else\def\AB@note{#1}%
        \setcounter{Maxaffil}{0}\fi
      \begingroup
        \let\protect\@unexpandable@protect
        \def\thanks{\protect\thanks}\def\footnote{\protect\footnote}%
        \@temptokena=\expandafter{\AB@authors}%
        {\def\\{\protect\\\protect\Affilfont}\xdef\AB@temp{#2}}%
         \xdef\AB@authors{\the\@temptokena\AB@las\AB@au@str
         \protect\\[\affilsep]\protect\Affilfont\AB@temp}%
         \gdef\AB@las{}\gdef\AB@au@str{}%
        {\def\\{, \ignorespaces}\xdef\AB@temp{#2}}%
        \@temptokena=\expandafter{\AB@affillist}%
        \xdef\AB@affillist{\the\@temptokena \AB@affilsep
          \AB@affilnote{\AB@note}\protect\Affilfont\AB@temp}%
      \endgroup
       \let\AB@affilsep\AB@affilsepx
}
\def\@author{}
\renewcommand\@author{\ifx\AB@affillist\AB@empty\AB@author\else
      \ifnum\value{affil}>\value{Maxaffil}\def\rlap##1{##1}%
    \AB@authlist\\[\affilsep]\AB@affillist
    \else  \AB@authors\fi\fi}
%% Copyright 1993-1999 Patrick W Daly
%% Max-Planck-Institut f\"ur Aeronomie
%% Max-Planck-Str. 2
%% D-37191 Katlenburg-Lindau
%% Germany
%% E-mail: daly@linmpi.mpg.de
\def\ModuleVersion#1[#2]{}
    \ModuleVersion{appendix}
           [1999/02/23 2.1 (PWD)]
\@ifundefined{iffigcaps}{}
  {\PackageWarningNoLine{appendix}
     {***********************************\MessageBreak
      This package read in after `figcaps'\MessageBreak
      There could be problems with sublabelled\MessageBreak
      figure and table numbers.\MessageBreak
      ***********************************}}
\providecommand{\appendixname}{Appendix}
\let\orisection=\section
\let\theolds=\thesection
\let\theoldss=\thesubsection
\def\appendix{\par
  \setcounter{section}{0}
  \setcounter{subsection}{0}
  \def\thesection{\Alph{section}}
  \def\thesubsection{\thesection\arabic{subsection}}
  \setcounter{secnumdepth}{4}
  \@addtoreset{equation}{section}
  \setcounter{equation}{0}
  \def\theequation{\thesection\arabic{equation}}
  \@addtoreset{figure}{section}
  \setcounter{figure}{0}
  \def\thefigure{\thesection\arabic{figure}}
  \@addtoreset{table}{section}
  \def\thetable{\thesection\arabic{table}}
  \setcounter{table}{0}
  \def\@Alph##1{\ifcase##1A\or A\or B\or C\or D\else\@Ialph{##1}\fi}
  \def\section{\@startsection {section}{1}{\z@}{-2em plus
    -1ex minus-.2ex}{1em plus.2ex}{\reset@font
       \if@egsbook\large\else\normalsize\fi
    \bfseries\noindent \appendixname~}}
}
\def\noappendix{\setcounter{secnumdepth}{0}
  \global\let\section=\orisection
  \global\let\thesection=\theolds
  \global\let\thesubsection=\theoldss
}
%% Copyright 1993-1999 Patrick W Daly
%% Max-Planck-Institut f\"ur Aeronomie
%% Max-Planck-Str. 2
%% D-37191 Katlenburg-Lindau
%% Germany
%% E-mail: daly@linmpi.mpg.de
\def\ModuleVersion#1[#2]{}
    \ModuleVersion{figcaps}
        [1999/02/23 4.7 (PWD)]
\@ifundefined{chapter}{}{%
    \PackageError{figcaps}
     {`figcaps' may only be used with article-like classes}
     {There is no help. You just cannot use `figcaps'}}
\newif\iffigcaps \figcapstrue
\newif\iffigmark \figmarkfalse
\newif\if@figpage \@figpagefalse
\@ifundefined{figurecapname}{\def\figurecapname{Figure Captions}}{}
\@ifundefined{tablepagename}{\def\tablepagename{Tables}}{}
\@ifundefined{figurepagename}{\def\figurepagename{Figures}}{}
\begingroup
  \catcode `|=0 \catcode `[= 1
  \catcode`]=2 \catcode `\{=12 \catcode `\}=12
  \catcode`\^^M=13 \catcode`\\=12 %
|long|gdef|@vfig#1\end{figure}[|def|@term[\end{figure}]%
          |expandafter|writelof#1^^M\end{figure}^^M|end[figure]]%
|long|gdef|@vsfig#1\end{figure*}[|def|@term[\end{figure*}]%
          |expandafter|writelof#1^^M\end{figure*}^^M|end[figure*]]%
|long|gdef|@vtab#1\end{table}[|def|@term[\end{table}]%
          |expandafter|writelot#1^^M\end{table}^^M|end[table]]%
|long|gdef|@vstab#1\end{table*}[|def|@term[\end{table*}]%
          |expandafter|writelot#1^^M\end{table*}^^M|end[table*]]%
|long|gdef|@fcaponly#1\caption[|endgroup|@fcaption]%
|long|gdef|@feject#1\end{figure}[|end[figure]]%
  |endgroup
\long\def\FC@writefile#1#2{\@ifundefined{tf@#1}{}{%
  \immediate\write\csname tf@#1\endcsname{#2}}}
\def\lof{lof} \def\lot{lot}

{\catcode`\^^M=13%
  \long\gdef\writelof#1^^M{\def\@tempb{#1}%
      \ifx\@tempb\@term\let\@tempa\relax\else
      \if@filesw\FC@writefile{pof}{#1}\fi\let\@tempa\writelof\fi \@tempa}
  \long\gdef\writelot#1^^M{\def\@tempb{#1}%
      \ifx\@tempb\@term\let\@tempa\relax\else
      \if@filesw\FC@writefile{pot}{#1}\fi\let\@tempa\writelot\fi \@tempa}
}
\def\@fcaption{\refstepcounter\@captype \@ifnextchar[{\@@fcapopt}{\@@fcap}}
\def\@@fcapopt[#1]#2{\@caption\@captype[]{#2}\begingroup\set@literal\@feject}
\def\@@fcap#1{\@caption\@captype[]{#1}\begingroup\set@literal\@feject}
\def\figcapson{\figcapstrue}
\def\figcapsoff{\figcapsfalse}
\def\figmarkon{\figmarktrue}
\def\figmarkoff{\figmarkfalse}
\def\figure{\iffigcaps \let\@tempb=\@zfigure \else \let\@tempb=\@float\fi
  \@tempb{figure}}
\def\@zfigure#1{\begingroup\set@literal\@ifnextchar[{\@figure}{\@figure[]}}
\def\@figure[#1]{\@ifundefined{tf@pof}{\newwrite\tf@pof
     \if@filesw\immediate\openout\tf@pof\jobname.\lof\relax
     \ifFC@appendix\FC@writefile{pof}{\string\doappendix}\fi\fi}{}%
  \refstepcounter{figure}\iffigmark\marginpar{\fbox{\fnum@figure}}\fi
  \def\@captype{figure}\if@filesw\FC@writefile{pof}{\string\begin{figure}}\fi
  \@vfig}

\def\endfigure{\iffigcaps
    \endgroup\if@filesw\FC@writefile{pof}{\string\end{figure}}\fi\else
    \end@float\fi}

\@namedef{figure*}{\iffigcaps \let\@tempb=\@zsfigure \else
  \let\@tempb=\@dblfloat\fi \@tempb{figure}}
\def\@zsfigure#1{\begingroup\set@literal\@ifnextchar[{\@sfigure}{\@sfigure[]}}
\def\@sfigure[#1]{\@ifundefined{tf@pof}{\newwrite\tf@pof
     \if@filesw\immediate\openout\tf@pof\jobname.\lof\relax
     \ifFC@appendix\FC@writefile{pof}{\string\doappendix}\fi\fi}{}%
  \refstepcounter{figure}\iffigmark\marginpar{\fbox{\fnum@figure}}\fi
  \def\@captype{figure}\if@filesw\FC@writefile{pof}{\string\begin{figure}}\fi
  \@vsfig}

\@namedef{endfigure*}{\iffigcaps\endfigure\else\end@dblfloat\fi}
\def\table{\iffigcaps \let\@tempb=\@ztable \else \let\@tempb=\@float\fi
  \@tempb{table}}
\def\@ztable#1{\begingroup\set@literal\@ifnextchar[{\@table}{\@table[]}}
\def\@table[#1]{\@ifundefined{tf@pot}{\newwrite\tf@pot
     \if@filesw\immediate\openout\tf@pot\jobname.\lot\relax
     \ifFC@appendix\FC@writefile{pot}{\string\doappendix}\fi\fi}{}%
  \refstepcounter{table}\iffigmark\marginpar{\fbox{\fnum@table}}\fi
  \def\@captype{table}\if@filesw\FC@writefile{pot}{\string\begin{table}}\fi
  \@vtab}

\def\endtable{\iffigcaps
   \endgroup\if@filesw\FC@writefile{pot}{\string\end{table}}\fi\else
   \end@float\fi}

\@namedef{table*}{\iffigcaps \let\@tempb=\@zstable \else
  \let\@tempb=\@dblfloat\fi \@tempb{table}}
\def\@zstable#1{\begingroup\set@literal\@ifnextchar[{\@stable}{\@stable[]}}
\def\@stable[#1]{\@ifundefined{tf@pot}{\newwrite\tf@pot
     \if@filesw\immediate\openout\tf@pot\jobname.\lot\relax
     \ifFC@appendix\FC@writefile{pot}{\string\doappendix}\fi\fi}{}%
  \refstepcounter{table}\iffigmark\marginpar{\fbox{\fnum@table}}\fi
  \def\@captype{table}\if@filesw\FC@writefile{pot}
    {\string\begin{table}}%
    \fi\@vstab}

\@namedef{endtable*}{\iffigcaps\endtable\else
   \end@dblfloat\fi}
\def\tableofcontents{%
  \PackageWarningNoLine{figcaps}
   {Ignored: \protect\tableofcontents\space command}}
\def\listoffigures{%
  \PackageWarningNoLine{figcaps}
   {Ignored: \protect\listoffigures\space command}}
\def\listoftables{%
  \PackageWarningNoLine{figcaps}
   {Ignored: \protect\listoftables\space command}}
\def\addtocontents#1#2{\relax}
\def\addcontentsline#1#2#3{\relax}
{\catcode`\^^M=\active \gdef\cr@relax{\catcode`\^^M=\active \let^^M=\relax}}
\def\set@literal{\cr@relax \let\do\@makeother\dospecials}
\def\@figurecaps{\@ifundefined{tf@pof}{}{\if@filesw
  \immediate\closeout\tf@pof\fi
  \@ifundefined{appendixname}{}{\def\appendixname{}}
  \parindent\z@
  \reset@figtab\clearpage\section*{\figurecapname}\vspace{1cm}%
    \@mkboth{\uppercase{\figurecapname}}{\uppercase{\figurecapname}}%
    \addcontentsline{toc}{section}{\figurecapname}%
  \def\figure{\def\addcontentsline####1####2####3{}%
    \def\@captype{figure}%
    \begingroup\set@literal\@fcaponly
   }\def\endfigure{\endgroup\bigskip}%
  {\let\@makecaption=\@makefcaption
  \@input{\jobname.\lof}}%
  \clearpage}}%
\def\@tablepage{\@ifundefined{tf@pot}{}{\if@filesw
  \immediate\closeout\tf@pot\fi
  \@ifundefined{appendixname}{}{\def\appendixname{}}
  \parindent\z@
  \reset@figtab\clearpage\section*{\tablepagename}
    \@mkboth{\uppercase{\tablepagename}}{\uppercase{\tablepagename}}%
   \def\table{\def\@captype{table}\vbox\bgroup
    \small
   }\def\endtable{\egroup\bigskip}%
  \@input{\jobname.\lot}
  \clearpage}}
\def\printfigures{\@figpagetrue}
\def\@figurepage{\if@figpage\@ifundefined{tf@pof}{}{%
  \@ifundefined{appendixname}{}{\def\appendixname{}}
  \reset@figtab\clearpage\section*{\figurepagename}%
  \@mkboth{\uppercase{\figurepagename}}{\uppercase{\figurepagename}}%
  \begingroup
  \def\figure{\def\@captype{figure}\vbox\bgroup}\def\endfigure{\egroup
    \vspace{20pt}}%
  \def\label##1{}%
  \@input{\jobname.\lof}\newpage\endgroup}\fi}
\def\reset@figtab{%
  \setcounter{figure}{0}\setcounter{table}{0}
}
\AtEndDocument{\iffigcaps\@tablepage\@figurecaps\@figurepage\fi}
\let\@appendix=\appendix
\newif\ifFC@appendix \FC@appendixfalse
\def\appendix{\FC@appendixtrue
  \@ifundefined{tf@pof}{}{\if@filesw\FC@writefile{pof}{\string\doappendix}\fi}%
  \@ifundefined{tf@pot}{}{\if@filesw\FC@writefile{pot}{\string\doappendix}\fi}%
  \global\let\@section=\section
  \doappendix
  \let\@@section=\section
  \def\section{%
    \@ifundefined{tf@pof}{}{\if@filesw\FC@writefile{pof}{\string
        \stepcounter{section}}\fi}%
    \@ifundefined{tf@pot}{}{\if@filesw\FC@writefile{pot}{\string
        \stepcounter{section}}\fi}%
    \@@section}
  \global\let\reset@figtab=\@unappendix}
\def\doappendix{%
  \global\let\@thefigure=\thefigure
  \global\let\@thetable=\thetable
  \global\let\@cl@section=\cl@section
  \@appendix
}
\def\@unappendix{\FC@appendixfalse
  \setcounter{figure}{0}\setcounter{table}{0}
  \let\thefigure=\@thefigure
  \let\thetable=\@thetable
  \let\cl@section=\@cl@section
  \let\section=\@section
}
\let\@makefcaption=\@makecaption
\if@draft\figcapstrue\else\figcapsfalse\fi
%% Copyright 1993-1999 Patrick W Daly
%% Max-Planck-Institut f\"ur Aeronomie
%% Max-Planck-Str. 2
%% D-37191 Katlenburg-Lindau
%% Germany
%% E-mail: daly@linmpi.mpg.de
\def\ModuleVersion#1[#2]{}
    \ModuleVersion{balance}
         [1999/02/23 4.3 (PWD)]
\newcommand{\@BAlancecol}{\if@twocolumn
  \setbox0=\vbox{\unvbox\@outputbox} \@tempdima=\ht0
  \advance\@tempdima by \topskip \advance\@tempdima
     by -\baselineskip \divide\@tempdima by 2
     \splittopskip=\topskip
  {\vbadness=\@M \loop \global\setbox3=\copy0
   \global\setbox1=\vsplit3 to \@tempdima
   \ifdim\ht3>\@tempdima \global\advance\@tempdima by 1pt \repeat}
   \setbox\@leftcolumn=\vbox to \@tempdima{\unvbox1\vfil}
   \setbox\@outputbox=\vbox to \@tempdima
     {\dimen2=\dp3\unvbox3\kern-\dimen2
      \vfil}
  \fi}
\newif\if@BAlanceone
\global\@BAlanceonefalse
\newdimen\oldvsize
\newcommand{\@BAdblcol}{\if@firstcolumn
       \unvbox\@outputbox \penalty\outputpenalty
       \global\oldvsize=\@colht \global\multiply \@colht by 2
       \global\@BAlanceonetrue
       \global\@firstcolumnfalse
  \else \global\@firstcolumntrue
       \if@BAlanceone
       \global\@BAlanceonefalse\@BAlancecol
       \global\@colht=\oldvsize \else
       \PackageWarningNoLine{balance}
          {You have called \protect\balance\space
             in second column\MessageBreak
           Columns might not be balanced}\fi
     \setbox\@outputbox\vbox to \@colht{\hbox to\textwidth
     {\hbox to\columnwidth {\box\@leftcolumn \hss}\hfil
      \vrule width\columnseprule\hfil \hbox to\columnwidth
      {\box\@outputbox \hss}}\vfil}\@combinedblfloats
     \@outputpage \begingroup \@dblfloatplacement
     \@startdblcolumn \@whilesw\if@fcolmade \fi
     {\@outputpage\@startdblcolumn}\endgroup
  \fi}
\newcommand{\@BAcleardblpage}{\clearpage\if@twoside \ifodd\c@page\else
  \hbox{}\newpage\fi\fi}
\newcommand{\@@cleardblpage}{}
\let\@@cleardblpage=\cleardoublepage

\newcommand{\@@utputdblcol}{}
\let\@@utputdblcol=\@outputdblcol
\newcommand{\balance}{\global\let\@outputdblcol=\@BAdblcol
  \global\let\cleardoublepage=\@BAcleardblpage}
\newcommand{\nobalance}{\global\let\@outputdblcol=\@@utputdblcol
  \global\let\cleardoublepage=\@@cleardblpage}
\endinput
